/**** BSIM4.3.0  Released by Jane Xuemei Xi 05/09/2003 ****/

/**********
 * Copyright 2003 Regents of the University of California. All rights reserved.
 * File: b4v3.c of BSIM4.3.0.
 * Author: 2000 Weidong Liu
 * Authors: 2001- Xuemei Xi, Jin He, Kanyu Cao, Mohan Dunga, Mansun Chan, Ali Niknejad, Chenming Hu.
 * Project Director: Prof. Chenming Hu.
 * Modified by Xuemei Xi, 04/06/2001.
 * Modified by Xuemei Xi, 10/05/2001.
 * Modified by Xuemei Xi, 11/15/2002.
 * Modified by Xuemei Xi, 05/09/2003.
 **********/

#include "ngspice.h"
#include "devdefs.h"
#include "bsim4v3def.h"
#include "suffix.h"

IFparm BSIM4v3pTable[] = { /* parameters */
IOP( "l",   BSIM4v3_L,      IF_REAL   , "Length"),
IOP( "w",   BSIM4v3_W,      IF_REAL   , "Width"),
IOP( "m",   BSIM4v3_M,      IF_REAL   , "Separate Parallel multiplier"),
IOP( "nf",  BSIM4v3_NF,     IF_REAL   , "Number of fingers"),
IOP( "sa",  BSIM4v3_SA,     IF_REAL   , "distance between  OD edge to poly of one side "),
IOP( "sb",  BSIM4v3_SB,     IF_REAL   , "distance between  OD edge to poly of the other side"),
IOP( "sd",  BSIM4v3_SD,     IF_REAL   , "distance between neighbour fingers"),
IOP( "min",  BSIM4v3_MIN,   IF_INTEGER , "Minimize either D or S"),
IOP( "ad",  BSIM4v3_AD,     IF_REAL   , "Drain area"),
IOP( "as",  BSIM4v3_AS,     IF_REAL   , "Source area"),
IOP( "pd",  BSIM4v3_PD,     IF_REAL   , "Drain perimeter"),
IOP( "ps",  BSIM4v3_PS,     IF_REAL   , "Source perimeter"),
IOP( "nrd", BSIM4v3_NRD,    IF_REAL   , "Number of squares in drain"),
IOP( "nrs", BSIM4v3_NRS,    IF_REAL   , "Number of squares in source"),
IOP( "off", BSIM4v3_OFF,    IF_FLAG   , "Device is initially off"),
IOP( "rbdb", BSIM4v3_RBDB,  IF_REAL   , "Body resistance"),
IOP( "rbsb", BSIM4v3_RBSB,  IF_REAL   , "Body resistance"),
IOP( "rbpb", BSIM4v3_RBPB,  IF_REAL   , "Body resistance"),
IOP( "rbps", BSIM4v3_RBPS,  IF_REAL   , "Body resistance"),
IOP( "rbpd", BSIM4v3_RBPD,  IF_REAL   , "Body resistance"),
IOP( "trnqsmod", BSIM4v3_TRNQSMOD, IF_INTEGER, "Transient NQS model selector"),
IOP( "acnqsmod", BSIM4v3_ACNQSMOD, IF_INTEGER, "AC NQS model selector"),
IOP( "rbodymod", BSIM4v3_RBODYMOD, IF_INTEGER, "Distributed body R model selector"),
IOP( "rgatemod", BSIM4v3_RGATEMOD, IF_INTEGER, "Gate resistance model selector"),
IOP( "geomod", BSIM4v3_GEOMOD, IF_INTEGER, "Geometry dependent parasitics model selector"),
IOP( "rgeomod", BSIM4v3_RGEOMOD, IF_INTEGER, "S/D resistance and contact model selector"),
IP( "ic",  BSIM4v3_IC,     IF_REALVEC , "Vector of DS,GS,BS initial voltages"),
OP( "gmbs",         BSIM4v3_GMBS,       IF_REAL,    "Gmb"),
OP( "gm",           BSIM4v3_GM,         IF_REAL,    "Gm"),
OP( "gds",          BSIM4v3_GDS,        IF_REAL,    "Gds"),
OP( "vdsat",        BSIM4v3_VDSAT,      IF_REAL,    "Vdsat"),
OP( "vth",          BSIM4v3_VON,        IF_REAL,    "Vth"),
OP( "id",           BSIM4v3_CD,         IF_REAL,    "Ids"),
OP( "ibd",          BSIM4v3_CBD,        IF_REAL,    "Ibd"),
OP( "ibs",          BSIM4v3_CBS,        IF_REAL,    "Ibs"),
OP( "isub",         BSIM4v3_CSUB,       IF_REAL,    "Isub"),
OP( "igidl",        BSIM4v3_IGIDL,      IF_REAL,    "Igidl"),
OP( "igisl",        BSIM4v3_IGISL,      IF_REAL,    "Igisl"),
OP( "igs",          BSIM4v3_IGS,        IF_REAL,    "Igs"),
OP( "igd",          BSIM4v3_IGD,        IF_REAL,    "Igd"),
OP( "igb",          BSIM4v3_IGB,        IF_REAL,    "Igb"),
OP( "igcs",         BSIM4v3_IGCS,       IF_REAL,    "Igcs"),
OP( "igcd",         BSIM4v3_IGCD,       IF_REAL,    "Igcd"),
OP( "vbs",          BSIM4v3_VBS,        IF_REAL,    "Vbs"),
OP( "vgs",          BSIM4v3_VGS,        IF_REAL,    "Vgs"),
OP( "vds",          BSIM4v3_VDS,        IF_REAL,    "Vds"),
OP( "cgg",         BSIM4v3_CGGB,       IF_REAL,    "Cggb"),
OP( "cgs",         BSIM4v3_CGSB,       IF_REAL,    "Cgsb"),
OP( "cgd",         BSIM4v3_CGDB,       IF_REAL,    "Cgdb"),
OP( "cbg",         BSIM4v3_CBGB,       IF_REAL,    "Cbgb"),
OP( "cbd",         BSIM4v3_CBDB,       IF_REAL,    "Cbdb"),
OP( "cbs",         BSIM4v3_CBSB,       IF_REAL,    "Cbsb"),
OP( "cdg",         BSIM4v3_CDGB,       IF_REAL,    "Cdgb"),
OP( "cdd",         BSIM4v3_CDDB,       IF_REAL,    "Cddb"),
OP( "cds",         BSIM4v3_CDSB,       IF_REAL,    "Cdsb"),
OP( "csg",         BSIM4v3_CSGB,       IF_REAL,    "Csgb"),
OP( "csd",         BSIM4v3_CSDB,       IF_REAL,    "Csdb"),
OP( "css",         BSIM4v3_CSSB,       IF_REAL,    "Cssb"),
OP( "cgb",         BSIM4v3_CGBB,       IF_REAL,    "Cgbb"),
OP( "cdb",         BSIM4v3_CDBB,       IF_REAL,    "Cdbb"),
OP( "csb",         BSIM4v3_CSBB,       IF_REAL,    "Csbb"),
OP( "cbb",         BSIM4v3_CBBB,       IF_REAL,    "Cbbb"),
OP( "capbd",       BSIM4v3_CAPBD,      IF_REAL,    "Capbd"),
OP( "capbs",       BSIM4v3_CAPBS,      IF_REAL,    "Capbs"),
OP( "qg",          BSIM4v3_QG,         IF_REAL,    "Qgate"),
OP( "qb",          BSIM4v3_QB,         IF_REAL,    "Qbulk"),
OP( "qd",          BSIM4v3_QD,         IF_REAL,    "Qdrain"),
OP( "qs",          BSIM4v3_QS,         IF_REAL,    "Qsource"),
OP( "qinv",        BSIM4v3_QINV,       IF_REAL,    "Qinversion"),
};

IFparm BSIM4v3mPTable[] = { /* model parameters */
IOP( "capmod", BSIM4v3_MOD_CAPMOD, IF_INTEGER, "Capacitance model selector"),
IOP( "diomod", BSIM4v3_MOD_DIOMOD, IF_INTEGER, "Diode IV model selector"),
IOP( "rdsmod", BSIM4v3_MOD_RDSMOD, IF_INTEGER, "Bias-dependent S/D resistance model selector"),
IOP( "trnqsmod", BSIM4v3_MOD_TRNQSMOD, IF_INTEGER, "Transient NQS model selector"),
IOP( "acnqsmod", BSIM4v3_MOD_ACNQSMOD, IF_INTEGER, "AC NQS model selector"),
IOP( "mobmod", BSIM4v3_MOD_MOBMOD, IF_INTEGER, "Mobility model selector"),
IOP( "rbodymod", BSIM4v3_MOD_RBODYMOD, IF_INTEGER, "Distributed body R model selector"),
IOP( "rgatemod", BSIM4v3_MOD_RGATEMOD, IF_INTEGER, "Gate R model selector"),
IOP( "permod", BSIM4v3_MOD_PERMOD, IF_INTEGER, "Pd and Ps model selector"),
IOP( "geomod", BSIM4v3_MOD_GEOMOD, IF_INTEGER, "Geometry dependent parasitics model selector"),
IOP( "fnoimod", BSIM4v3_MOD_FNOIMOD, IF_INTEGER, "Flicker noise model selector"),
IOP( "tnoimod", BSIM4v3_MOD_TNOIMOD, IF_INTEGER, "Thermal noise model selector"),
IOP( "igcmod", BSIM4v3_MOD_IGCMOD, IF_INTEGER, "Gate-to-channel Ig model selector"),
IOP( "igbmod", BSIM4v3_MOD_IGBMOD, IF_INTEGER, "Gate-to-body Ig model selector"),
IOP( "tempmod", BSIM4v3_MOD_TEMPMOD, IF_INTEGER, "Temperature model selector"),
IOP( "paramchk", BSIM4v3_MOD_PARAMCHK, IF_INTEGER, "Model parameter checking selector"),
IOP( "binunit", BSIM4v3_MOD_BINUNIT, IF_INTEGER, "Bin  unit  selector"),
IOP( "version", BSIM4v3_MOD_VERSION, IF_STRING, "parameter for model version"),
IOP( "toxe", BSIM4v3_MOD_TOXE, IF_REAL, "Electrical gate oxide thickness in meters"),
IOP( "toxp", BSIM4v3_MOD_TOXP, IF_REAL, "Physical gate oxide thickness in meters"),
IOP( "toxm", BSIM4v3_MOD_TOXM, IF_REAL, "Gate oxide thickness at which parameters are extracted"),
IOP( "toxref", BSIM4v3_MOD_TOXREF, IF_REAL, "Target tox value"),
IOP( "dtox", BSIM4v3_MOD_DTOX, IF_REAL, "Defined as (toxe - toxp) "),
IOP( "epsrox", BSIM4v3_MOD_EPSROX, IF_REAL, "Dielectric constant of the gate oxide relative to vacuum"),
IOP( "cdsc", BSIM4v3_MOD_CDSC, IF_REAL, "Drain/Source and channel coupling capacitance"),
IOP( "cdscb", BSIM4v3_MOD_CDSCB, IF_REAL, "Body-bias dependence of cdsc"), 
IOP( "cdscd", BSIM4v3_MOD_CDSCD, IF_REAL, "Drain-bias dependence of cdsc"), 
IOP( "cit", BSIM4v3_MOD_CIT, IF_REAL, "Interface state capacitance"),
IOP( "nfactor", BSIM4v3_MOD_NFACTOR, IF_REAL, "Subthreshold swing Coefficient"),
IOP( "xj", BSIM4v3_MOD_XJ, IF_REAL, "Junction depth in meters"),
IOP( "vsat", BSIM4v3_MOD_VSAT, IF_REAL, "Saturation velocity at tnom"),
IOP( "at", BSIM4v3_MOD_AT, IF_REAL, "Temperature coefficient of vsat"),
IOP( "a0", BSIM4v3_MOD_A0, IF_REAL, "Non-uniform depletion width effect coefficient."), 
IOP( "ags", BSIM4v3_MOD_AGS, IF_REAL, "Gate bias  coefficient of Abulk."), 
IOP( "a1", BSIM4v3_MOD_A1, IF_REAL, "Non-saturation effect coefficient"),
IOP( "a2", BSIM4v3_MOD_A2, IF_REAL, "Non-saturation effect coefficient"),
IOP( "keta", BSIM4v3_MOD_KETA, IF_REAL, "Body-bias coefficient of non-uniform depletion width effect."),
IOP( "nsub", BSIM4v3_MOD_NSUB, IF_REAL, "Substrate doping concentration"),
IOP( "ndep", BSIM4v3_MOD_NDEP, IF_REAL, "Channel doping concentration at the depletion edge"),
IOP( "nsd", BSIM4v3_MOD_NSD, IF_REAL, "S/D doping concentration"),
IOP( "phin", BSIM4v3_MOD_PHIN, IF_REAL, "Adjusting parameter for surface potential due to non-uniform vertical doping"),
IOP( "ngate", BSIM4v3_MOD_NGATE, IF_REAL, "Poly-gate doping concentration"),
IOP( "gamma1", BSIM4v3_MOD_GAMMA1, IF_REAL, "Vth body coefficient"),
IOP( "gamma2", BSIM4v3_MOD_GAMMA2, IF_REAL, "Vth body coefficient"),
IOP( "vbx", BSIM4v3_MOD_VBX, IF_REAL, "Vth transition body Voltage"),
IOP( "vbm", BSIM4v3_MOD_VBM, IF_REAL, "Maximum body voltage"),

IOP( "xt", BSIM4v3_MOD_XT, IF_REAL, "Doping depth"),
IOP( "k1", BSIM4v3_MOD_K1, IF_REAL, "Bulk effect coefficient 1"),
IOP( "kt1", BSIM4v3_MOD_KT1, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt1l", BSIM4v3_MOD_KT1L, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt2",  BSIM4v3_MOD_KT2, IF_REAL, "Body-coefficient of kt1"),
IOP( "k2",   BSIM4v3_MOD_K2,  IF_REAL, "Bulk effect coefficient 2"),
IOP( "k3",   BSIM4v3_MOD_K3,  IF_REAL, "Narrow width effect coefficient"),
IOP( "k3b",  BSIM4v3_MOD_K3B, IF_REAL, "Body effect coefficient of k3"),
IOP( "w0",   BSIM4v3_MOD_W0,  IF_REAL, "Narrow width effect parameter"),
IOP( "dvtp0",  BSIM4v3_MOD_DVTP0, IF_REAL, "First parameter for Vth shift due to pocket"),
IOP( "dvtp1",  BSIM4v3_MOD_DVTP1, IF_REAL, "Second parameter for Vth shift due to pocket"),
IOP( "lpe0",  BSIM4v3_MOD_LPE0, IF_REAL, "Equivalent length of pocket region at zero bias"),
IOP( "lpeb",  BSIM4v3_MOD_LPEB, IF_REAL, "Equivalent length of pocket region accounting for body bias"),
IOP( "dvt0", BSIM4v3_MOD_DVT0, IF_REAL, "Short channel effect coeff. 0"),
IOP( "dvt1", BSIM4v3_MOD_DVT1, IF_REAL, "Short channel effect coeff. 1"),
IOP( "dvt2", BSIM4v3_MOD_DVT2, IF_REAL, "Short channel effect coeff. 2"),
IOP( "dvt0w", BSIM4v3_MOD_DVT0W, IF_REAL, "Narrow Width coeff. 0"),
IOP( "dvt1w", BSIM4v3_MOD_DVT1W, IF_REAL, "Narrow Width effect coeff. 1"),
IOP( "dvt2w", BSIM4v3_MOD_DVT2W, IF_REAL, "Narrow Width effect coeff. 2"),
IOP( "drout", BSIM4v3_MOD_DROUT, IF_REAL, "DIBL coefficient of output resistance"),
IOP( "dsub", BSIM4v3_MOD_DSUB, IF_REAL, "DIBL coefficient in the subthreshold region"),
IOP( "vth0", BSIM4v3_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOP( "vtho", BSIM4v3_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOP( "ua", BSIM4v3_MOD_UA, IF_REAL, "Linear gate dependence of mobility"),
IOP( "ua1", BSIM4v3_MOD_UA1, IF_REAL, "Temperature coefficient of ua"),
IOP( "ub", BSIM4v3_MOD_UB, IF_REAL, "Quadratic gate dependence of mobility"),
IOP( "ub1", BSIM4v3_MOD_UB1, IF_REAL, "Temperature coefficient of ub"),
IOP( "uc", BSIM4v3_MOD_UC, IF_REAL, "Body-bias dependence of mobility"),
IOP( "uc1", BSIM4v3_MOD_UC1, IF_REAL, "Temperature coefficient of uc"),
IOP( "u0", BSIM4v3_MOD_U0, IF_REAL, "Low-field mobility at Tnom"),
IOP( "eu", BSIM4v3_MOD_EU, IF_REAL, "Mobility exponent"),
IOP( "ute", BSIM4v3_MOD_UTE, IF_REAL, "Temperature coefficient of mobility"),
IOP( "voff", BSIM4v3_MOD_VOFF, IF_REAL, "Threshold voltage offset"),
IOP( "minv", BSIM4v3_MOD_MINV, IF_REAL, "Fitting parameter for moderate invversion in Vgsteff"),
IOP( "voffl", BSIM4v3_MOD_VOFFL, IF_REAL, "Length dependence parameter for Vth offset"),
IOP( "tnom", BSIM4v3_MOD_TNOM, IF_REAL, "Parameter measurement temperature"),
IOP( "cgso", BSIM4v3_MOD_CGSO, IF_REAL, "Gate-source overlap capacitance per width"),
IOP( "cgdo", BSIM4v3_MOD_CGDO, IF_REAL, "Gate-drain overlap capacitance per width"),
IOP( "cgbo", BSIM4v3_MOD_CGBO, IF_REAL, "Gate-bulk overlap capacitance per length"),
IOP( "xpart", BSIM4v3_MOD_XPART, IF_REAL, "Channel charge partitioning"),
IOP( "delta", BSIM4v3_MOD_DELTA, IF_REAL, "Effective Vds parameter"),
IOP( "rsh", BSIM4v3_MOD_RSH, IF_REAL, "Source-drain sheet resistance"),
IOP( "rdsw", BSIM4v3_MOD_RDSW, IF_REAL, "Source-drain resistance per width"),    
IOP( "rdswmin", BSIM4v3_MOD_RDSWMIN, IF_REAL, "Source-drain resistance per width at high Vg"),
IOP( "rsw", BSIM4v3_MOD_RSW, IF_REAL, "Source resistance per width"),
IOP( "rdw", BSIM4v3_MOD_RDW, IF_REAL, "Drain resistance per width"),
IOP( "rdwmin", BSIM4v3_MOD_RDWMIN, IF_REAL, "Drain resistance per width at high Vg"),
IOP( "rswmin", BSIM4v3_MOD_RSWMIN, IF_REAL, "Source resistance per width at high Vg"),

IOP( "prwg", BSIM4v3_MOD_PRWG, IF_REAL, "Gate-bias effect on parasitic resistance "),    
IOP( "prwb", BSIM4v3_MOD_PRWB, IF_REAL, "Body-effect on parasitic resistance "),    

IOP( "prt", BSIM4v3_MOD_PRT, IF_REAL, "Temperature coefficient of parasitic resistance "),    
IOP( "eta0", BSIM4v3_MOD_ETA0, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "etab", BSIM4v3_MOD_ETAB, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "pclm", BSIM4v3_MOD_PCLM, IF_REAL, "Channel length modulation Coefficient"),
IOP( "pdiblc1", BSIM4v3_MOD_PDIBL1, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblc2", BSIM4v3_MOD_PDIBL2, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblcb", BSIM4v3_MOD_PDIBLB, IF_REAL, "Body-effect on drain-induced barrier lowering"),   
IOP( "fprout", BSIM4v3_MOD_FPROUT, IF_REAL, "Rout degradation coefficient for pocket devices"),
IOP( "pdits", BSIM4v3_MOD_PDITS, IF_REAL, "Coefficient for drain-induced Vth shifts"),
IOP( "pditsl", BSIM4v3_MOD_PDITSL, IF_REAL, "Length dependence of drain-induced Vth shifts"),
IOP( "pditsd", BSIM4v3_MOD_PDITSD, IF_REAL, "Vds dependence of drain-induced Vth shifts"),
IOP( "pscbe1", BSIM4v3_MOD_PSCBE1, IF_REAL, "Substrate current body-effect coefficient"),   
IOP( "pscbe2", BSIM4v3_MOD_PSCBE2, IF_REAL, "Substrate current body-effect coefficient"),   
IOP( "pvag", BSIM4v3_MOD_PVAG, IF_REAL, "Gate dependence of output resistance parameter"),   

IOP( "jss", BSIM4v3_MOD_JSS, IF_REAL, "Bottom source junction reverse saturation current density"),
IOP( "jsws", BSIM4v3_MOD_JSWS, IF_REAL, "Isolation edge sidewall source junction reverse saturation current density"),
IOP( "jswgs", BSIM4v3_MOD_JSWGS, IF_REAL, "Gate edge source junction reverse saturation current density"),
IOP( "pbs", BSIM4v3_MOD_PBS, IF_REAL, "Source junction built-in potential"),
IOP( "njs", BSIM4v3_MOD_NJS, IF_REAL, "Source junction emission coefficient"),
IOP( "xtis", BSIM4v3_MOD_XTIS, IF_REAL, "Source junction current temperature exponent"),
IOP( "mjs", BSIM4v3_MOD_MJS, IF_REAL, "Source bottom junction capacitance grading coefficient"),
IOP( "pbsws", BSIM4v3_MOD_PBSWS, IF_REAL, "Source sidewall junction capacitance built in potential"),
IOP( "mjsws", BSIM4v3_MOD_MJSWS, IF_REAL, "Source sidewall junction capacitance grading coefficient"),
IOP( "pbswgs", BSIM4v3_MOD_PBSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance built in potential"),
IOP( "mjswgs", BSIM4v3_MOD_MJSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance grading coefficient"),
IOP( "cjs", BSIM4v3_MOD_CJS, IF_REAL, "Source bottom junction capacitance per unit area"),
IOP( "cjsws", BSIM4v3_MOD_CJSWS, IF_REAL, "Source sidewall junction capacitance per unit periphery"),
IOP( "cjswgs", BSIM4v3_MOD_CJSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance per unit width"),

IOP( "jsd", BSIM4v3_MOD_JSD, IF_REAL, "Bottom drain junction reverse saturation current density"),
IOP( "jswd", BSIM4v3_MOD_JSWD, IF_REAL, "Isolation edge sidewall drain junction reverse saturation current density"),
IOP( "jswgd", BSIM4v3_MOD_JSWGD, IF_REAL, "Gate edge drain junction reverse saturation current density"),
IOP( "pbd", BSIM4v3_MOD_PBD, IF_REAL, "Drain junction built-in potential"),
IOP( "njd", BSIM4v3_MOD_NJD, IF_REAL, "Drain junction emission coefficient"),
IOP( "xtid", BSIM4v3_MOD_XTID, IF_REAL, "Drainjunction current temperature exponent"),
IOP( "mjd", BSIM4v3_MOD_MJD, IF_REAL, "Drain bottom junction capacitance grading coefficient"),
IOP( "pbswd", BSIM4v3_MOD_PBSWD, IF_REAL, "Drain sidewall junction capacitance built in potential"),
IOP( "mjswd", BSIM4v3_MOD_MJSWD, IF_REAL, "Drain sidewall junction capacitance grading coefficient"),
IOP( "pbswgd", BSIM4v3_MOD_PBSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance built in potential"),
IOP( "mjswgd", BSIM4v3_MOD_MJSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance grading coefficient"),
IOP( "cjd", BSIM4v3_MOD_CJD, IF_REAL, "Drain bottom junction capacitance per unit area"),
IOP( "cjswd", BSIM4v3_MOD_CJSWD, IF_REAL, "Drain sidewall junction capacitance per unit periphery"),
IOP( "cjswgd", BSIM4v3_MOD_CJSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance per unit width"),

IOP( "vfbcv", BSIM4v3_MOD_VFBCV, IF_REAL, "Flat Band Voltage parameter for capmod=0 only"),
IOP( "vfb", BSIM4v3_MOD_VFB, IF_REAL, "Flat Band Voltage"),
IOP( "tpb", BSIM4v3_MOD_TPB, IF_REAL, "Temperature coefficient of pb"),
IOP( "tcj", BSIM4v3_MOD_TCJ, IF_REAL, "Temperature coefficient of cj"),
IOP( "tpbsw", BSIM4v3_MOD_TPBSW, IF_REAL, "Temperature coefficient of pbsw"),
IOP( "tcjsw", BSIM4v3_MOD_TCJSW, IF_REAL, "Temperature coefficient of cjsw"),
IOP( "tpbswg", BSIM4v3_MOD_TPBSWG, IF_REAL, "Temperature coefficient of pbswg"),
IOP( "tcjswg", BSIM4v3_MOD_TCJSWG, IF_REAL, "Temperature coefficient of cjswg"),
IOP( "acde", BSIM4v3_MOD_ACDE, IF_REAL, "Exponential coefficient for finite charge thickness"),
IOP( "moin", BSIM4v3_MOD_MOIN, IF_REAL, "Coefficient for gate-bias dependent surface potential"),
IOP( "noff", BSIM4v3_MOD_NOFF, IF_REAL, "C-V turn-on/off parameter"),
IOP( "voffcv", BSIM4v3_MOD_VOFFCV, IF_REAL, "C-V lateral-shift parameter"),
IOP( "dmcg", BSIM4v3_MOD_DMCG, IF_REAL, "Distance of Mid-Contact to Gate edge"),
IOP( "dmci", BSIM4v3_MOD_DMCI, IF_REAL, "Distance of Mid-Contact to Isolation"),
IOP( "dmdg", BSIM4v3_MOD_DMDG, IF_REAL, "Distance of Mid-Diffusion to Gate edge"),
IOP( "dmcgt", BSIM4v3_MOD_DMCGT, IF_REAL, "Distance of Mid-Contact to Gate edge in Test structures"),
IOP( "xgw",  BSIM4v3_MOD_XGW, IF_REAL, "Distance from gate contact center to device edge"),
IOP( "xgl",  BSIM4v3_MOD_XGL, IF_REAL, "Variation in Ldrawn"),
IOP( "rshg", BSIM4v3_MOD_RSHG, IF_REAL, "Gate sheet resistance"),
IOP( "ngcon", BSIM4v3_MOD_NGCON, IF_REAL, "Number of gate contacts"),
IOP( "xrcrg1",  BSIM4v3_MOD_XRCRG1, IF_REAL, "First fitting parameter the bias-dependent Rg"),
IOP( "xrcrg2",  BSIM4v3_MOD_XRCRG2, IF_REAL, "Second fitting parameter the bias-dependent Rg"),
IOP( "lambda",  BSIM4v3_MOD_LAMBDA, IF_REAL, " Velocity overshoot parameter"),
IOP( "vtl",      BSIM4v3_MOD_VTL,     IF_REAL, " thermal velocity"),
IOP( "lc",     BSIM4v3_MOD_LC,     IF_REAL, " back scattering parameter"),
IOP( "xn",     BSIM4v3_MOD_XN,     IF_REAL, " back scattering parameter"),
IOP( "lint", BSIM4v3_MOD_LINT, IF_REAL, "Length reduction parameter"),
IOP( "ll",   BSIM4v3_MOD_LL, IF_REAL, "Length reduction parameter"),
IOP( "llc",  BSIM4v3_MOD_LLC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lln",  BSIM4v3_MOD_LLN, IF_REAL, "Length reduction parameter"),
IOP( "lw",   BSIM4v3_MOD_LW,  IF_REAL, "Length reduction parameter"),
IOP( "lwc",  BSIM4v3_MOD_LWC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lwn",  BSIM4v3_MOD_LWN, IF_REAL, "Length reduction parameter"),
IOP( "lwl",  BSIM4v3_MOD_LWL, IF_REAL, "Length reduction parameter"),
IOP( "lwlc", BSIM4v3_MOD_LWLC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lmin", BSIM4v3_MOD_LMIN, IF_REAL, "Minimum length for the model"),
IOP( "lmax", BSIM4v3_MOD_LMAX, IF_REAL, "Maximum length for the model"),

IOP( "wr",   BSIM4v3_MOD_WR, IF_REAL, "Width dependence of rds"),
IOP( "wint", BSIM4v3_MOD_WINT, IF_REAL, "Width reduction parameter"),
IOP( "dwg",  BSIM4v3_MOD_DWG, IF_REAL, "Width reduction parameter"),
IOP( "dwb",  BSIM4v3_MOD_DWB, IF_REAL, "Width reduction parameter"),

IOP( "wl",   BSIM4v3_MOD_WL, IF_REAL, "Width reduction parameter"),
IOP( "wlc",  BSIM4v3_MOD_WLC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wln",  BSIM4v3_MOD_WLN, IF_REAL, "Width reduction parameter"),
IOP( "ww",   BSIM4v3_MOD_WW, IF_REAL, "Width reduction parameter"),
IOP( "wwc",  BSIM4v3_MOD_WWC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wwn",  BSIM4v3_MOD_WWN, IF_REAL, "Width reduction parameter"),
IOP( "wwl",  BSIM4v3_MOD_WWL, IF_REAL, "Width reduction parameter"),
IOP( "wwlc", BSIM4v3_MOD_WWLC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wmin", BSIM4v3_MOD_WMIN, IF_REAL, "Minimum width for the model"),
IOP( "wmax", BSIM4v3_MOD_WMAX, IF_REAL, "Maximum width for the model"),

IOP( "b0",  BSIM4v3_MOD_B0, IF_REAL, "Abulk narrow width parameter"),
IOP( "b1",  BSIM4v3_MOD_B1, IF_REAL, "Abulk narrow width parameter"),

IOP( "cgsl", BSIM4v3_MOD_CGSL, IF_REAL, "New C-V model parameter"),
IOP( "cgdl", BSIM4v3_MOD_CGDL, IF_REAL, "New C-V model parameter"),
IOP( "ckappas", BSIM4v3_MOD_CKAPPAS, IF_REAL, "S/G overlap C-V parameter "),
IOP( "ckappad", BSIM4v3_MOD_CKAPPAD, IF_REAL, "D/G overlap C-V parameter"),
IOP( "cf",  BSIM4v3_MOD_CF, IF_REAL, "Fringe capacitance parameter"),
IOP( "clc", BSIM4v3_MOD_CLC, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "cle", BSIM4v3_MOD_CLE, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "dwc", BSIM4v3_MOD_DWC, IF_REAL, "Delta W for C-V model"),
IOP( "dlc", BSIM4v3_MOD_DLC, IF_REAL, "Delta L for C-V model"),
IOP( "xw", BSIM4v3_MOD_XW, IF_REAL, "W offset for channel width due to mask/etch effect"),
IOP( "xl", BSIM4v3_MOD_XL, IF_REAL, "L offset for channel length due to mask/etch effect"),
IOP( "dlcig", BSIM4v3_MOD_DLCIG, IF_REAL, "Delta L for Ig model"),
IOP( "dwj", BSIM4v3_MOD_DWJ, IF_REAL, "Delta W for S/D junctions"),

IOP( "alpha0", BSIM4v3_MOD_ALPHA0, IF_REAL, "substrate current model parameter"),
IOP( "alpha1", BSIM4v3_MOD_ALPHA1, IF_REAL, "substrate current model parameter"),
IOP( "beta0", BSIM4v3_MOD_BETA0, IF_REAL, "substrate current model parameter"),
IOP( "agidl", BSIM4v3_MOD_AGIDL, IF_REAL, "Pre-exponential constant for GIDL"),
IOP( "bgidl", BSIM4v3_MOD_BGIDL, IF_REAL, "Exponential constant for GIDL"),
IOP( "cgidl", BSIM4v3_MOD_CGIDL, IF_REAL, "Parameter for body-bias dependence of GIDL"),
IOP( "egidl", BSIM4v3_MOD_EGIDL, IF_REAL, "Fitting parameter for Bandbending"),
IOP( "aigc", BSIM4v3_MOD_AIGC, IF_REAL, "Parameter for Igc"),
IOP( "bigc", BSIM4v3_MOD_BIGC, IF_REAL, "Parameter for Igc"),
IOP( "cigc", BSIM4v3_MOD_CIGC, IF_REAL, "Parameter for Igc"),
IOP( "aigsd", BSIM4v3_MOD_AIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "bigsd", BSIM4v3_MOD_BIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "cigsd", BSIM4v3_MOD_CIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "aigbacc", BSIM4v3_MOD_AIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "bigbacc", BSIM4v3_MOD_BIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "cigbacc", BSIM4v3_MOD_CIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "aigbinv", BSIM4v3_MOD_AIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "bigbinv", BSIM4v3_MOD_BIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "cigbinv", BSIM4v3_MOD_CIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "nigc", BSIM4v3_MOD_NIGC, IF_REAL, "Parameter for Igc slope"),
IOP( "nigbinv", BSIM4v3_MOD_NIGBINV, IF_REAL, "Parameter for Igbinv slope"),
IOP( "nigbacc", BSIM4v3_MOD_NIGBACC, IF_REAL, "Parameter for Igbacc slope"),
IOP( "ntox", BSIM4v3_MOD_NTOX, IF_REAL, "Exponent for Tox ratio"),
IOP( "eigbinv", BSIM4v3_MOD_EIGBINV, IF_REAL, "Parameter for the Si bandgap for Igbinv"),
IOP( "pigcd", BSIM4v3_MOD_PIGCD, IF_REAL, "Parameter for Igc partition"),
IOP( "poxedge", BSIM4v3_MOD_POXEDGE, IF_REAL, "Factor for the gate edge Tox"),

IOP( "ijthdfwd", BSIM4v3_MOD_IJTHDFWD, IF_REAL, "Forward drain diode forward limiting current"),
IOP( "ijthsfwd", BSIM4v3_MOD_IJTHSFWD, IF_REAL, "Forward source diode forward limiting current"),
IOP( "ijthdrev", BSIM4v3_MOD_IJTHDREV, IF_REAL, "Reverse drain diode forward limiting current"),
IOP( "ijthsrev", BSIM4v3_MOD_IJTHSREV, IF_REAL, "Reverse source diode forward limiting current"),
IOP( "xjbvd", BSIM4v3_MOD_XJBVD, IF_REAL, "Fitting parameter for drain diode breakdown current"),
IOP( "xjbvs", BSIM4v3_MOD_XJBVS, IF_REAL, "Fitting parameter for source diode breakdown current"),
IOP( "bvd", BSIM4v3_MOD_BVD, IF_REAL, "Drain diode breakdown voltage"),
IOP( "bvs", BSIM4v3_MOD_BVS, IF_REAL, "Source diode breakdown voltage"),

IOP( "gbmin", BSIM4v3_MOD_GBMIN, IF_REAL, "Minimum body conductance"),
IOP( "rbdb", BSIM4v3_MOD_RBDB, IF_REAL, "Resistance between bNode and dbNode"),
IOP( "rbpb", BSIM4v3_MOD_RBPB, IF_REAL, "Resistance between bNodePrime and bNode"),
IOP( "rbsb", BSIM4v3_MOD_RBSB, IF_REAL, "Resistance between bNode and sbNode"),
IOP( "rbps", BSIM4v3_MOD_RBPS, IF_REAL, "Resistance between bNodePrime and sbNode"),
IOP( "rbpd", BSIM4v3_MOD_RBPD, IF_REAL, "Resistance between bNodePrime and bNode"),

IOP( "lcdsc",  BSIM4v3_MOD_LCDSC, IF_REAL, "Length dependence of cdsc"),
IOP( "lcdscb", BSIM4v3_MOD_LCDSCB, IF_REAL, "Length dependence of cdscb"),
IOP( "lcdscd", BSIM4v3_MOD_LCDSCD, IF_REAL, "Length dependence of cdscd"),
IOP( "lcit",   BSIM4v3_MOD_LCIT,  IF_REAL, "Length dependence of cit"),
IOP( "lnfactor", BSIM4v3_MOD_LNFACTOR, IF_REAL, "Length dependence of nfactor"),
IOP( "lxj", BSIM4v3_MOD_LXJ, IF_REAL, "Length dependence of xj"),
IOP( "lvsat", BSIM4v3_MOD_LVSAT, IF_REAL, "Length dependence of vsat"),
IOP( "lat", BSIM4v3_MOD_LAT, IF_REAL, "Length dependence of at"),
IOP( "la0", BSIM4v3_MOD_LA0, IF_REAL, "Length dependence of a0"), 
IOP( "lags", BSIM4v3_MOD_LAGS, IF_REAL, "Length dependence of ags"), 
IOP( "la1", BSIM4v3_MOD_LA1, IF_REAL, "Length dependence of a1"),
IOP( "la2", BSIM4v3_MOD_LA2, IF_REAL, "Length dependence of a2"),
IOP( "lketa", BSIM4v3_MOD_LKETA, IF_REAL, "Length dependence of keta"),
IOP( "lnsub", BSIM4v3_MOD_LNSUB, IF_REAL, "Length dependence of nsub"),
IOP( "lndep",  BSIM4v3_MOD_LNDEP, IF_REAL, "Length dependence of ndep"),
IOP( "lnsd",  BSIM4v3_MOD_LNSD, IF_REAL, "Length dependence of nsd"),
IOP( "lphin", BSIM4v3_MOD_LPHIN, IF_REAL, "Length dependence of phin"),
IOP( "lngate", BSIM4v3_MOD_LNGATE, IF_REAL, "Length dependence of ngate"),
IOP( "lgamma1", BSIM4v3_MOD_LGAMMA1, IF_REAL, "Length dependence of gamma1"),
IOP( "lgamma2", BSIM4v3_MOD_LGAMMA2, IF_REAL, "Length dependence of gamma2"),
IOP( "lvbx", BSIM4v3_MOD_LVBX, IF_REAL, "Length dependence of vbx"),
IOP( "lvbm", BSIM4v3_MOD_LVBM, IF_REAL, "Length dependence of vbm"),
IOP( "lxt",  BSIM4v3_MOD_LXT,  IF_REAL, "Length dependence of xt"),
IOP( "lk1",   BSIM4v3_MOD_LK1,  IF_REAL, "Length dependence of k1"),
IOP( "lkt1",  BSIM4v3_MOD_LKT1, IF_REAL, "Length dependence of kt1"),
IOP( "lkt1l", BSIM4v3_MOD_LKT1L, IF_REAL, "Length dependence of kt1l"),
IOP( "lkt2",  BSIM4v3_MOD_LKT2, IF_REAL, "Length dependence of kt2"),
IOP( "lk2",   BSIM4v3_MOD_LK2,  IF_REAL, "Length dependence of k2"),
IOP( "lk3",   BSIM4v3_MOD_LK3,  IF_REAL, "Length dependence of k3"),
IOP( "lk3b",  BSIM4v3_MOD_LK3B, IF_REAL, "Length dependence of k3b"),
IOP( "lw0",   BSIM4v3_MOD_LW0,  IF_REAL, "Length dependence of w0"),
IOP( "ldvtp0",  BSIM4v3_MOD_LDVTP0, IF_REAL, "Length dependence of dvtp0"),
IOP( "ldvtp1",  BSIM4v3_MOD_LDVTP1, IF_REAL, "Length dependence of dvtp1"),
IOP( "llpe0",  BSIM4v3_MOD_LLPE0, IF_REAL, "Length dependence of lpe0"),
IOP( "llpeb",  BSIM4v3_MOD_LLPEB, IF_REAL, "Length dependence of lpeb"),
IOP( "ldvt0", BSIM4v3_MOD_LDVT0, IF_REAL, "Length dependence of dvt0"),
IOP( "ldvt1", BSIM4v3_MOD_LDVT1, IF_REAL, "Length dependence of dvt1"),
IOP( "ldvt2", BSIM4v3_MOD_LDVT2, IF_REAL, "Length dependence of dvt2"),
IOP( "ldvt0w", BSIM4v3_MOD_LDVT0W, IF_REAL, "Length dependence of dvt0w"),
IOP( "ldvt1w", BSIM4v3_MOD_LDVT1W, IF_REAL, "Length dependence of dvt1w"),
IOP( "ldvt2w", BSIM4v3_MOD_LDVT2W, IF_REAL, "Length dependence of dvt2w"),
IOP( "ldrout", BSIM4v3_MOD_LDROUT, IF_REAL, "Length dependence of drout"),
IOP( "ldsub", BSIM4v3_MOD_LDSUB, IF_REAL, "Length dependence of dsub"),
IOP( "lvth0", BSIM4v3_MOD_LVTH0, IF_REAL,"Length dependence of vto"),
IOP( "lvtho", BSIM4v3_MOD_LVTH0, IF_REAL,"Length dependence of vto"),
IOP( "lua",  BSIM4v3_MOD_LUA, IF_REAL, "Length dependence of ua"),
IOP( "lua1", BSIM4v3_MOD_LUA1, IF_REAL, "Length dependence of ua1"),
IOP( "lub", BSIM4v3_MOD_LUB, IF_REAL, "Length dependence of ub"),
IOP( "lub1", BSIM4v3_MOD_LUB1, IF_REAL, "Length dependence of ub1"),
IOP( "luc",  BSIM4v3_MOD_LUC, IF_REAL, "Length dependence of uc"),
IOP( "luc1", BSIM4v3_MOD_LUC1, IF_REAL, "Length dependence of uc1"),
IOP( "lu0",  BSIM4v3_MOD_LU0, IF_REAL, "Length dependence of u0"),
IOP( "lute", BSIM4v3_MOD_LUTE, IF_REAL, "Length dependence of ute"),
IOP( "lvoff", BSIM4v3_MOD_LVOFF, IF_REAL, "Length dependence of voff"),
IOP( "lminv", BSIM4v3_MOD_LMINV, IF_REAL, "Length dependence of minv"),
IOP( "ldelta", BSIM4v3_MOD_LDELTA, IF_REAL, "Length dependence of delta"),
IOP( "lrdsw", BSIM4v3_MOD_LRDSW,  IF_REAL, "Length dependence of rdsw "),    
IOP( "lrsw", BSIM4v3_MOD_LRSW, IF_REAL, "Length dependence of rsw"),
IOP( "lrdw", BSIM4v3_MOD_LRDW, IF_REAL, "Length dependence of rdw"),

IOP( "lprwg", BSIM4v3_MOD_LPRWG,  IF_REAL, "Length dependence of prwg "),    
IOP( "lprwb", BSIM4v3_MOD_LPRWB,  IF_REAL, "Length dependence of prwb "),    

IOP( "lprt", BSIM4v3_MOD_LPRT, IF_REAL, "Length dependence of prt "),    
IOP( "leta0", BSIM4v3_MOD_LETA0, IF_REAL, "Length dependence of eta0"),   
IOP( "letab", BSIM4v3_MOD_LETAB, IF_REAL, "Length dependence of etab"),   
IOP( "lpclm", BSIM4v3_MOD_LPCLM, IF_REAL, "Length dependence of pclm"),   
IOP( "lpdiblc1", BSIM4v3_MOD_LPDIBL1, IF_REAL, "Length dependence of pdiblc1"),   
IOP( "lpdiblc2", BSIM4v3_MOD_LPDIBL2, IF_REAL, "Length dependence of pdiblc2"),   
IOP( "lpdiblcb", BSIM4v3_MOD_LPDIBLB, IF_REAL, "Length dependence of pdiblcb"),   
IOP( "lfprout", BSIM4v3_MOD_LFPROUT, IF_REAL, "Length dependence of pdiblcb"),
IOP( "lpdits", BSIM4v3_MOD_LPDITS, IF_REAL, "Length dependence of pdits"),
IOP( "lpditsd", BSIM4v3_MOD_LPDITSD, IF_REAL, "Length dependence of pditsd"),
IOP( "lpscbe1",  BSIM4v3_MOD_LPSCBE1, IF_REAL, "Length dependence of pscbe1"),   
IOP( "lpscbe2",  BSIM4v3_MOD_LPSCBE2, IF_REAL, "Length dependence of pscbe2"),   
IOP( "lpvag", BSIM4v3_MOD_LPVAG, IF_REAL, "Length dependence of pvag"),   
IOP( "lwr",  BSIM4v3_MOD_LWR, IF_REAL, "Length dependence of wr"),
IOP( "ldwg", BSIM4v3_MOD_LDWG, IF_REAL, "Length dependence of dwg"),
IOP( "ldwb", BSIM4v3_MOD_LDWB, IF_REAL, "Length dependence of dwb"),
IOP( "lb0",  BSIM4v3_MOD_LB0, IF_REAL, "Length dependence of b0"),
IOP( "lb1",  BSIM4v3_MOD_LB1, IF_REAL, "Length dependence of b1"),
IOP( "lcgsl", BSIM4v3_MOD_LCGSL, IF_REAL, "Length dependence of cgsl"),
IOP( "lcgdl", BSIM4v3_MOD_LCGDL, IF_REAL, "Length dependence of cgdl"),
IOP( "lckappas", BSIM4v3_MOD_LCKAPPAS, IF_REAL, "Length dependence of ckappas"),
IOP( "lckappad", BSIM4v3_MOD_LCKAPPAD, IF_REAL, "Length dependence of ckappad"),
IOP( "lcf",  BSIM4v3_MOD_LCF,  IF_REAL, "Length dependence of cf"),
IOP( "lclc", BSIM4v3_MOD_LCLC, IF_REAL, "Length dependence of clc"),
IOP( "lcle", BSIM4v3_MOD_LCLE, IF_REAL, "Length dependence of cle"),
IOP( "lalpha0", BSIM4v3_MOD_LALPHA0, IF_REAL, "Length dependence of alpha0"),
IOP( "lalpha1", BSIM4v3_MOD_LALPHA1, IF_REAL, "Length dependence of alpha1"),
IOP( "lbeta0", BSIM4v3_MOD_LBETA0, IF_REAL, "Length dependence of beta0"),
IOP( "lagidl", BSIM4v3_MOD_LAGIDL, IF_REAL, "Length dependence of agidl"),
IOP( "lbgidl", BSIM4v3_MOD_LBGIDL, IF_REAL, "Length dependence of bgidl"),
IOP( "lcgidl", BSIM4v3_MOD_LCGIDL, IF_REAL, "Length dependence of cgidl"),
IOP( "legidl", BSIM4v3_MOD_LEGIDL, IF_REAL, "Length dependence of egidl"),
IOP( "laigc", BSIM4v3_MOD_LAIGC, IF_REAL, "Length dependence of aigc"),
IOP( "lbigc", BSIM4v3_MOD_LBIGC, IF_REAL, "Length dependence of bigc"),
IOP( "lcigc", BSIM4v3_MOD_LCIGC, IF_REAL, "Length dependence of cigc"),
IOP( "laigsd", BSIM4v3_MOD_LAIGSD, IF_REAL, "Length dependence of aigsd"),
IOP( "lbigsd", BSIM4v3_MOD_LBIGSD, IF_REAL, "Length dependence of bigsd"),
IOP( "lcigsd", BSIM4v3_MOD_LCIGSD, IF_REAL, "Length dependence of cigsd"),
IOP( "laigbacc", BSIM4v3_MOD_LAIGBACC, IF_REAL, "Length dependence of aigbacc"),
IOP( "lbigbacc", BSIM4v3_MOD_LBIGBACC, IF_REAL, "Length dependence of bigbacc"),
IOP( "lcigbacc", BSIM4v3_MOD_LCIGBACC, IF_REAL, "Length dependence of cigbacc"),
IOP( "laigbinv", BSIM4v3_MOD_LAIGBINV, IF_REAL, "Length dependence of aigbinv"),
IOP( "lbigbinv", BSIM4v3_MOD_LBIGBINV, IF_REAL, "Length dependence of bigbinv"),
IOP( "lcigbinv", BSIM4v3_MOD_LCIGBINV, IF_REAL, "Length dependence of cigbinv"),
IOP( "lnigc", BSIM4v3_MOD_LNIGC, IF_REAL, "Length dependence of nigc"),
IOP( "lnigbinv", BSIM4v3_MOD_LNIGBINV, IF_REAL, "Length dependence of nigbinv"),
IOP( "lnigbacc", BSIM4v3_MOD_LNIGBACC, IF_REAL, "Length dependence of nigbacc"),
IOP( "lntox", BSIM4v3_MOD_LNTOX, IF_REAL, "Length dependence of ntox"),
IOP( "leigbinv", BSIM4v3_MOD_LEIGBINV, IF_REAL, "Length dependence for eigbinv"),
IOP( "lpigcd", BSIM4v3_MOD_LPIGCD, IF_REAL, "Length dependence for pigcd"),
IOP( "lpoxedge", BSIM4v3_MOD_LPOXEDGE, IF_REAL, "Length dependence for poxedge"),

IOP( "lvfbcv", BSIM4v3_MOD_LVFBCV, IF_REAL, "Length dependence of vfbcv"),
IOP( "lvfb", BSIM4v3_MOD_LVFB, IF_REAL, "Length dependence of vfb"),
IOP( "lacde", BSIM4v3_MOD_LACDE, IF_REAL, "Length dependence of acde"),
IOP( "lmoin", BSIM4v3_MOD_LMOIN, IF_REAL, "Length dependence of moin"),
IOP( "lnoff", BSIM4v3_MOD_LNOFF, IF_REAL, "Length dependence of noff"),
IOP( "lvoffcv", BSIM4v3_MOD_LVOFFCV, IF_REAL, "Length dependence of voffcv"),
IOP( "lxrcrg1",  BSIM4v3_MOD_LXRCRG1, IF_REAL, "Length dependence of xrcrg1"),
IOP( "lxrcrg2",  BSIM4v3_MOD_LXRCRG2, IF_REAL, "Length dependence of xrcrg2"),
IOP( "llambda",  BSIM4v3_MOD_LLAMBDA, IF_REAL, "Length dependence of lambda"),
IOP( "lvtl",      BSIM4v3_MOD_LVTL,     IF_REAL, " Length dependence of vtl"),
IOP( "lxn",     BSIM4v3_MOD_LXN,    IF_REAL, " Length dependence of xn"),
IOP( "leu",  BSIM4v3_MOD_LEU, IF_REAL, "Length dependence of eu"),

IOP( "wcdsc",  BSIM4v3_MOD_WCDSC, IF_REAL, "Width dependence of cdsc"),
IOP( "wcdscb", BSIM4v3_MOD_WCDSCB, IF_REAL, "Width dependence of cdscb"),  
IOP( "wcdscd", BSIM4v3_MOD_WCDSCD, IF_REAL, "Width dependence of cdscd"),  
IOP( "wcit",   BSIM4v3_MOD_WCIT,  IF_REAL, "Width dependence of cit"),
IOP( "wnfactor", BSIM4v3_MOD_WNFACTOR, IF_REAL, "Width dependence of nfactor"),
IOP( "wxj", BSIM4v3_MOD_WXJ, IF_REAL, "Width dependence of xj"),
IOP( "wvsat", BSIM4v3_MOD_WVSAT, IF_REAL, "Width dependence of vsat"),
IOP( "wat", BSIM4v3_MOD_WAT, IF_REAL, "Width dependence of at"),
IOP( "wa0", BSIM4v3_MOD_WA0, IF_REAL, "Width dependence of a0"), 
IOP( "wags", BSIM4v3_MOD_WAGS, IF_REAL, "Width dependence of ags"), 
IOP( "wa1", BSIM4v3_MOD_WA1, IF_REAL, "Width dependence of a1"),
IOP( "wa2", BSIM4v3_MOD_WA2, IF_REAL, "Width dependence of a2"),
IOP( "wketa", BSIM4v3_MOD_WKETA, IF_REAL, "Width dependence of keta"),
IOP( "wnsub", BSIM4v3_MOD_WNSUB, IF_REAL, "Width dependence of nsub"),
IOP( "wndep",  BSIM4v3_MOD_WNDEP, IF_REAL, "Width dependence of ndep"),
IOP( "wnsd",  BSIM4v3_MOD_WNSD, IF_REAL, "Width dependence of nsd"),
IOP( "wphin", BSIM4v3_MOD_WPHIN, IF_REAL, "Width dependence of phin"),
IOP( "wngate", BSIM4v3_MOD_WNGATE, IF_REAL, "Width dependence of ngate"),
IOP( "wgamma1", BSIM4v3_MOD_WGAMMA1, IF_REAL, "Width dependence of gamma1"),
IOP( "wgamma2", BSIM4v3_MOD_WGAMMA2, IF_REAL, "Width dependence of gamma2"),
IOP( "wvbx", BSIM4v3_MOD_WVBX, IF_REAL, "Width dependence of vbx"),
IOP( "wvbm", BSIM4v3_MOD_WVBM, IF_REAL, "Width dependence of vbm"),
IOP( "wxt",  BSIM4v3_MOD_WXT,  IF_REAL, "Width dependence of xt"),
IOP( "wk1",   BSIM4v3_MOD_WK1,  IF_REAL, "Width dependence of k1"),
IOP( "wkt1",  BSIM4v3_MOD_WKT1, IF_REAL, "Width dependence of kt1"),
IOP( "wkt1l", BSIM4v3_MOD_WKT1L, IF_REAL, "Width dependence of kt1l"),
IOP( "wkt2",  BSIM4v3_MOD_WKT2, IF_REAL, "Width dependence of kt2"),
IOP( "wk2",   BSIM4v3_MOD_WK2,  IF_REAL, "Width dependence of k2"),
IOP( "wk3",   BSIM4v3_MOD_WK3,  IF_REAL, "Width dependence of k3"),
IOP( "wk3b",  BSIM4v3_MOD_WK3B, IF_REAL, "Width dependence of k3b"),
IOP( "ww0",   BSIM4v3_MOD_WW0,  IF_REAL, "Width dependence of w0"),
IOP( "wdvtp0",  BSIM4v3_MOD_WDVTP0, IF_REAL, "Width dependence of dvtp0"),
IOP( "wdvtp1",  BSIM4v3_MOD_WDVTP1, IF_REAL, "Width dependence of dvtp1"),
IOP( "wlpe0",  BSIM4v3_MOD_WLPE0, IF_REAL, "Width dependence of lpe0"),
IOP( "wlpeb",  BSIM4v3_MOD_WLPEB, IF_REAL, "Width dependence of lpeb"),
IOP( "wdvt0", BSIM4v3_MOD_WDVT0, IF_REAL, "Width dependence of dvt0"),
IOP( "wdvt1", BSIM4v3_MOD_WDVT1, IF_REAL, "Width dependence of dvt1"),
IOP( "wdvt2", BSIM4v3_MOD_WDVT2, IF_REAL, "Width dependence of dvt2"),
IOP( "wdvt0w", BSIM4v3_MOD_WDVT0W, IF_REAL, "Width dependence of dvt0w"),
IOP( "wdvt1w", BSIM4v3_MOD_WDVT1W, IF_REAL, "Width dependence of dvt1w"),
IOP( "wdvt2w", BSIM4v3_MOD_WDVT2W, IF_REAL, "Width dependence of dvt2w"),
IOP( "wdrout", BSIM4v3_MOD_WDROUT, IF_REAL, "Width dependence of drout"),
IOP( "wdsub", BSIM4v3_MOD_WDSUB, IF_REAL, "Width dependence of dsub"),
IOP( "wvth0", BSIM4v3_MOD_WVTH0, IF_REAL,"Width dependence of vto"),
IOP( "wvtho", BSIM4v3_MOD_WVTH0, IF_REAL,"Width dependence of vto"),
IOP( "wua",  BSIM4v3_MOD_WUA, IF_REAL, "Width dependence of ua"),
IOP( "wua1", BSIM4v3_MOD_WUA1, IF_REAL, "Width dependence of ua1"),
IOP( "wub", BSIM4v3_MOD_WUB, IF_REAL, "Width dependence of ub"),
IOP( "wub1", BSIM4v3_MOD_WUB1, IF_REAL, "Width dependence of ub1"),
IOP( "wuc",  BSIM4v3_MOD_WUC, IF_REAL, "Width dependence of uc"),
IOP( "wuc1", BSIM4v3_MOD_WUC1, IF_REAL, "Width dependence of uc1"),
IOP( "wu0",  BSIM4v3_MOD_WU0, IF_REAL, "Width dependence of u0"),
IOP( "wute", BSIM4v3_MOD_WUTE, IF_REAL, "Width dependence of ute"),
IOP( "wvoff", BSIM4v3_MOD_WVOFF, IF_REAL, "Width dependence of voff"),
IOP( "wminv", BSIM4v3_MOD_WMINV, IF_REAL, "Width dependence of minv"),
IOP( "wdelta", BSIM4v3_MOD_WDELTA, IF_REAL, "Width dependence of delta"),
IOP( "wrdsw", BSIM4v3_MOD_WRDSW,  IF_REAL, "Width dependence of rdsw "),
IOP( "wrsw", BSIM4v3_MOD_WRSW, IF_REAL, "Width dependence of rsw"),
IOP( "wrdw", BSIM4v3_MOD_WRDW, IF_REAL, "Width dependence of rdw"),

IOP( "wprwg", BSIM4v3_MOD_WPRWG,  IF_REAL, "Width dependence of prwg "),
IOP( "wprwb", BSIM4v3_MOD_WPRWB,  IF_REAL, "Width dependence of prwb "),

IOP( "wprt", BSIM4v3_MOD_WPRT, IF_REAL, "Width dependence of prt"),
IOP( "weta0", BSIM4v3_MOD_WETA0, IF_REAL, "Width dependence of eta0"),   
IOP( "wetab", BSIM4v3_MOD_WETAB, IF_REAL, "Width dependence of etab"),   
IOP( "wpclm", BSIM4v3_MOD_WPCLM, IF_REAL, "Width dependence of pclm"),   
IOP( "wpdiblc1", BSIM4v3_MOD_WPDIBL1, IF_REAL, "Width dependence of pdiblc1"),   
IOP( "wpdiblc2", BSIM4v3_MOD_WPDIBL2, IF_REAL, "Width dependence of pdiblc2"),   
IOP( "wpdiblcb", BSIM4v3_MOD_WPDIBLB, IF_REAL, "Width dependence of pdiblcb"),   
IOP( "wfprout", BSIM4v3_MOD_WFPROUT, IF_REAL, "Width dependence of pdiblcb"),
IOP( "wpdits", BSIM4v3_MOD_WPDITS, IF_REAL, "Width dependence of pdits"),
IOP( "wpditsd", BSIM4v3_MOD_WPDITSD, IF_REAL, "Width dependence of pditsd"),
IOP( "wpscbe1",  BSIM4v3_MOD_WPSCBE1, IF_REAL, "Width dependence of pscbe1"),   
IOP( "wpscbe2",  BSIM4v3_MOD_WPSCBE2, IF_REAL, "Width dependence of pscbe2"),   
IOP( "wpvag", BSIM4v3_MOD_WPVAG, IF_REAL, "Width dependence of pvag"),   
IOP( "wwr",  BSIM4v3_MOD_WWR, IF_REAL, "Width dependence of wr"),
IOP( "wdwg", BSIM4v3_MOD_WDWG, IF_REAL, "Width dependence of dwg"),
IOP( "wdwb", BSIM4v3_MOD_WDWB, IF_REAL, "Width dependence of dwb"),
IOP( "wb0",  BSIM4v3_MOD_WB0, IF_REAL, "Width dependence of b0"),
IOP( "wb1",  BSIM4v3_MOD_WB1, IF_REAL, "Width dependence of b1"),
IOP( "wcgsl", BSIM4v3_MOD_WCGSL, IF_REAL, "Width dependence of cgsl"),
IOP( "wcgdl", BSIM4v3_MOD_WCGDL, IF_REAL, "Width dependence of cgdl"),
IOP( "wckappas", BSIM4v3_MOD_WCKAPPAS, IF_REAL, "Width dependence of ckappas"),
IOP( "wckappad", BSIM4v3_MOD_WCKAPPAD, IF_REAL, "Width dependence of ckappad"),
IOP( "wcf",  BSIM4v3_MOD_WCF,  IF_REAL, "Width dependence of cf"),
IOP( "wclc", BSIM4v3_MOD_WCLC, IF_REAL, "Width dependence of clc"),
IOP( "wcle", BSIM4v3_MOD_WCLE, IF_REAL, "Width dependence of cle"),
IOP( "walpha0", BSIM4v3_MOD_WALPHA0, IF_REAL, "Width dependence of alpha0"),
IOP( "walpha1", BSIM4v3_MOD_WALPHA1, IF_REAL, "Width dependence of alpha1"),
IOP( "wbeta0", BSIM4v3_MOD_WBETA0, IF_REAL, "Width dependence of beta0"),
IOP( "wagidl", BSIM4v3_MOD_WAGIDL, IF_REAL, "Width dependence of agidl"),
IOP( "wbgidl", BSIM4v3_MOD_WBGIDL, IF_REAL, "Width dependence of bgidl"),
IOP( "wcgidl", BSIM4v3_MOD_WCGIDL, IF_REAL, "Width dependence of cgidl"),
IOP( "wegidl", BSIM4v3_MOD_WEGIDL, IF_REAL, "Width dependence of egidl"),
IOP( "waigc", BSIM4v3_MOD_WAIGC, IF_REAL, "Width dependence of aigc"),
IOP( "wbigc", BSIM4v3_MOD_WBIGC, IF_REAL, "Width dependence of bigc"),
IOP( "wcigc", BSIM4v3_MOD_WCIGC, IF_REAL, "Width dependence of cigc"),
IOP( "waigsd", BSIM4v3_MOD_WAIGSD, IF_REAL, "Width dependence of aigsd"),
IOP( "wbigsd", BSIM4v3_MOD_WBIGSD, IF_REAL, "Width dependence of bigsd"),
IOP( "wcigsd", BSIM4v3_MOD_WCIGSD, IF_REAL, "Width dependence of cigsd"),
IOP( "waigbacc", BSIM4v3_MOD_WAIGBACC, IF_REAL, "Width dependence of aigbacc"),
IOP( "wbigbacc", BSIM4v3_MOD_WBIGBACC, IF_REAL, "Width dependence of bigbacc"),
IOP( "wcigbacc", BSIM4v3_MOD_WCIGBACC, IF_REAL, "Width dependence of cigbacc"),
IOP( "waigbinv", BSIM4v3_MOD_WAIGBINV, IF_REAL, "Width dependence of aigbinv"),
IOP( "wbigbinv", BSIM4v3_MOD_WBIGBINV, IF_REAL, "Width dependence of bigbinv"),
IOP( "wcigbinv", BSIM4v3_MOD_WCIGBINV, IF_REAL, "Width dependence of cigbinv"),
IOP( "wnigc", BSIM4v3_MOD_WNIGC, IF_REAL, "Width dependence of nigc"),
IOP( "wnigbinv", BSIM4v3_MOD_WNIGBINV, IF_REAL, "Width dependence of nigbinv"),
IOP( "wnigbacc", BSIM4v3_MOD_WNIGBACC, IF_REAL, "Width dependence of nigbacc"),
IOP( "wntox", BSIM4v3_MOD_WNTOX, IF_REAL, "Width dependence of ntox"),
IOP( "weigbinv", BSIM4v3_MOD_WEIGBINV, IF_REAL, "Width dependence for eigbinv"),
IOP( "wpigcd", BSIM4v3_MOD_WPIGCD, IF_REAL, "Width dependence for pigcd"),
IOP( "wpoxedge", BSIM4v3_MOD_WPOXEDGE, IF_REAL, "Width dependence for poxedge"),
IOP( "wvfbcv", BSIM4v3_MOD_WVFBCV, IF_REAL, "Width dependence of vfbcv"),
IOP( "wvfb", BSIM4v3_MOD_WVFB, IF_REAL, "Width dependence of vfb"),
IOP( "wacde", BSIM4v3_MOD_WACDE, IF_REAL, "Width dependence of acde"),
IOP( "wmoin", BSIM4v3_MOD_WMOIN, IF_REAL, "Width dependence of moin"),
IOP( "wnoff", BSIM4v3_MOD_WNOFF, IF_REAL, "Width dependence of noff"),
IOP( "wvoffcv", BSIM4v3_MOD_WVOFFCV, IF_REAL, "Width dependence of voffcv"),
IOP( "wxrcrg1",  BSIM4v3_MOD_WXRCRG1, IF_REAL, "Width dependence of xrcrg1"),
IOP( "wxrcrg2",  BSIM4v3_MOD_WXRCRG2, IF_REAL, "Width dependence of xrcrg2"),
IOP( "wlambda",  BSIM4v3_MOD_WLAMBDA, IF_REAL, "Width dependence of lambda"),
IOP( "wvtl",      BSIM4v3_MOD_WVTL,     IF_REAL, "Width dependence of vtl"),
IOP( "wxn",     BSIM4v3_MOD_WXN,    IF_REAL, "Width dependence of xn"),
IOP( "weu",  BSIM4v3_MOD_WEU, IF_REAL, "Width dependence of eu"),

IOP( "pcdsc",  BSIM4v3_MOD_PCDSC, IF_REAL, "Cross-term dependence of cdsc"),
IOP( "pcdscb", BSIM4v3_MOD_PCDSCB, IF_REAL, "Cross-term dependence of cdscb"), 
IOP( "pcdscd", BSIM4v3_MOD_PCDSCD, IF_REAL, "Cross-term dependence of cdscd"),
IOP( "pcit",   BSIM4v3_MOD_PCIT,  IF_REAL, "Cross-term dependence of cit"),
IOP( "pnfactor", BSIM4v3_MOD_PNFACTOR, IF_REAL, "Cross-term dependence of nfactor"),
IOP( "pxj", BSIM4v3_MOD_PXJ, IF_REAL, "Cross-term dependence of xj"),
IOP( "pvsat", BSIM4v3_MOD_PVSAT, IF_REAL, "Cross-term dependence of vsat"),
IOP( "pat", BSIM4v3_MOD_PAT, IF_REAL, "Cross-term dependence of at"),
IOP( "pa0", BSIM4v3_MOD_PA0, IF_REAL, "Cross-term dependence of a0"), 
IOP( "pags", BSIM4v3_MOD_PAGS, IF_REAL, "Cross-term dependence of ags"),
IOP( "pa1", BSIM4v3_MOD_PA1, IF_REAL, "Cross-term dependence of a1"),
IOP( "pa2", BSIM4v3_MOD_PA2, IF_REAL, "Cross-term dependence of a2"),
IOP( "pketa", BSIM4v3_MOD_PKETA, IF_REAL, "Cross-term dependence of keta"),
IOP( "pnsub", BSIM4v3_MOD_PNSUB, IF_REAL, "Cross-term dependence of nsub"),
IOP( "pndep",  BSIM4v3_MOD_PNDEP, IF_REAL, "Cross-term dependence of ndep"),
IOP( "pnsd",  BSIM4v3_MOD_PNSD, IF_REAL, "Cross-term dependence of nsd"),
IOP( "pphin", BSIM4v3_MOD_PPHIN, IF_REAL, "Cross-term dependence of phin"),
IOP( "pngate", BSIM4v3_MOD_PNGATE, IF_REAL, "Cross-term dependence of ngate"),
IOP( "pgamma1", BSIM4v3_MOD_PGAMMA1, IF_REAL, "Cross-term dependence of gamma1"),
IOP( "pgamma2", BSIM4v3_MOD_PGAMMA2, IF_REAL, "Cross-term dependence of gamma2"),
IOP( "pvbx", BSIM4v3_MOD_PVBX, IF_REAL, "Cross-term dependence of vbx"),
IOP( "pvbm", BSIM4v3_MOD_PVBM, IF_REAL, "Cross-term dependence of vbm"),
IOP( "pxt",  BSIM4v3_MOD_PXT,  IF_REAL, "Cross-term dependence of xt"),
IOP( "pk1",   BSIM4v3_MOD_PK1,  IF_REAL, "Cross-term dependence of k1"),
IOP( "pkt1",  BSIM4v3_MOD_PKT1, IF_REAL, "Cross-term dependence of kt1"),
IOP( "pkt1l", BSIM4v3_MOD_PKT1L, IF_REAL, "Cross-term dependence of kt1l"),
IOP( "pkt2",  BSIM4v3_MOD_PKT2, IF_REAL, "Cross-term dependence of kt2"),
IOP( "pk2",   BSIM4v3_MOD_PK2,  IF_REAL, "Cross-term dependence of k2"),
IOP( "pk3",   BSIM4v3_MOD_PK3,  IF_REAL, "Cross-term dependence of k3"),
IOP( "pk3b",  BSIM4v3_MOD_PK3B, IF_REAL, "Cross-term dependence of k3b"),
IOP( "pw0",   BSIM4v3_MOD_PW0,  IF_REAL, "Cross-term dependence of w0"),
IOP( "pdvtp0",  BSIM4v3_MOD_PDVTP0, IF_REAL, "Cross-term dependence of dvtp0"),
IOP( "pdvtp1",  BSIM4v3_MOD_PDVTP1, IF_REAL, "Cross-term dependence of dvtp1"),
IOP( "plpe0",  BSIM4v3_MOD_PLPE0, IF_REAL, "Cross-term dependence of lpe0"),
IOP( "plpeb",  BSIM4v3_MOD_PLPEB, IF_REAL, "Cross-term dependence of lpeb"),
IOP( "pdvt0", BSIM4v3_MOD_PDVT0, IF_REAL, "Cross-term dependence of dvt0"),
IOP( "pdvt1", BSIM4v3_MOD_PDVT1, IF_REAL, "Cross-term dependence of dvt1"),
IOP( "pdvt2", BSIM4v3_MOD_PDVT2, IF_REAL, "Cross-term dependence of dvt2"),
IOP( "pdvt0w", BSIM4v3_MOD_PDVT0W, IF_REAL, "Cross-term dependence of dvt0w"),
IOP( "pdvt1w", BSIM4v3_MOD_PDVT1W, IF_REAL, "Cross-term dependence of dvt1w"),
IOP( "pdvt2w", BSIM4v3_MOD_PDVT2W, IF_REAL, "Cross-term dependence of dvt2w"),
IOP( "pdrout", BSIM4v3_MOD_PDROUT, IF_REAL, "Cross-term dependence of drout"),
IOP( "pdsub", BSIM4v3_MOD_PDSUB, IF_REAL, "Cross-term dependence of dsub"),
IOP( "pvth0", BSIM4v3_MOD_PVTH0, IF_REAL,"Cross-term dependence of vto"),
IOP( "pvtho", BSIM4v3_MOD_PVTH0, IF_REAL,"Cross-term dependence of vto"),
IOP( "pua",  BSIM4v3_MOD_PUA, IF_REAL, "Cross-term dependence of ua"),
IOP( "pua1", BSIM4v3_MOD_PUA1, IF_REAL, "Cross-term dependence of ua1"),
IOP( "pub", BSIM4v3_MOD_PUB, IF_REAL, "Cross-term dependence of ub"),
IOP( "pub1", BSIM4v3_MOD_PUB1, IF_REAL, "Cross-term dependence of ub1"),
IOP( "puc",  BSIM4v3_MOD_PUC, IF_REAL, "Cross-term dependence of uc"),
IOP( "puc1", BSIM4v3_MOD_PUC1, IF_REAL, "Cross-term dependence of uc1"),
IOP( "pu0",  BSIM4v3_MOD_PU0, IF_REAL, "Cross-term dependence of u0"),
IOP( "pute", BSIM4v3_MOD_PUTE, IF_REAL, "Cross-term dependence of ute"),
IOP( "pvoff", BSIM4v3_MOD_PVOFF, IF_REAL, "Cross-term dependence of voff"),
IOP( "pminv", BSIM4v3_MOD_PMINV, IF_REAL, "Cross-term dependence of minv"),
IOP( "pdelta", BSIM4v3_MOD_PDELTA, IF_REAL, "Cross-term dependence of delta"),
IOP( "prdsw", BSIM4v3_MOD_PRDSW,  IF_REAL, "Cross-term dependence of rdsw "),    
IOP( "prsw", BSIM4v3_MOD_PRSW, IF_REAL, "Cross-term dependence of rsw"),
IOP( "prdw", BSIM4v3_MOD_PRDW, IF_REAL, "Cross-term dependence of rdw"),

IOP( "pprwg", BSIM4v3_MOD_PPRWG,  IF_REAL, "Cross-term dependence of prwg "),    
IOP( "pprwb", BSIM4v3_MOD_PPRWB,  IF_REAL, "Cross-term dependence of prwb "),    

IOP( "pprt", BSIM4v3_MOD_PPRT, IF_REAL, "Cross-term dependence of prt "),
IOP( "peta0", BSIM4v3_MOD_PETA0, IF_REAL, "Cross-term dependence of eta0"),
IOP( "petab", BSIM4v3_MOD_PETAB, IF_REAL, "Cross-term dependence of etab"),
IOP( "ppclm", BSIM4v3_MOD_PPCLM, IF_REAL, "Cross-term dependence of pclm"),
IOP( "ppdiblc1", BSIM4v3_MOD_PPDIBL1, IF_REAL, "Cross-term dependence of pdiblc1"),
IOP( "ppdiblc2", BSIM4v3_MOD_PPDIBL2, IF_REAL, "Cross-term dependence of pdiblc2"),
IOP( "ppdiblcb", BSIM4v3_MOD_PPDIBLB, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "pfprout", BSIM4v3_MOD_PFPROUT, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "ppdits", BSIM4v3_MOD_PPDITS, IF_REAL, "Cross-term dependence of pdits"),
IOP( "ppditsd", BSIM4v3_MOD_PPDITSD, IF_REAL, "Cross-term dependence of pditsd"),
IOP( "ppscbe1",  BSIM4v3_MOD_PPSCBE1, IF_REAL, "Cross-term dependence of pscbe1"),
IOP( "ppscbe2",  BSIM4v3_MOD_PPSCBE2, IF_REAL, "Cross-term dependence of pscbe2"),
IOP( "ppvag", BSIM4v3_MOD_PPVAG, IF_REAL, "Cross-term dependence of pvag"),   
IOP( "pwr",  BSIM4v3_MOD_PWR, IF_REAL, "Cross-term dependence of wr"),
IOP( "pdwg", BSIM4v3_MOD_PDWG, IF_REAL, "Cross-term dependence of dwg"),
IOP( "pdwb", BSIM4v3_MOD_PDWB, IF_REAL, "Cross-term dependence of dwb"),
IOP( "pb0",  BSIM4v3_MOD_PB0, IF_REAL, "Cross-term dependence of b0"),
IOP( "pb1",  BSIM4v3_MOD_PB1, IF_REAL, "Cross-term dependence of b1"),
IOP( "pcgsl", BSIM4v3_MOD_PCGSL, IF_REAL, "Cross-term dependence of cgsl"),
IOP( "pcgdl", BSIM4v3_MOD_PCGDL, IF_REAL, "Cross-term dependence of cgdl"),
IOP( "pckappas", BSIM4v3_MOD_PCKAPPAS, IF_REAL, "Cross-term dependence of ckappas"),
IOP( "pckappad", BSIM4v3_MOD_PCKAPPAD, IF_REAL, "Cross-term dependence of ckappad"),
IOP( "pcf",  BSIM4v3_MOD_PCF,  IF_REAL, "Cross-term dependence of cf"),
IOP( "pclc", BSIM4v3_MOD_PCLC, IF_REAL, "Cross-term dependence of clc"),
IOP( "pcle", BSIM4v3_MOD_PCLE, IF_REAL, "Cross-term dependence of cle"),
IOP( "palpha0", BSIM4v3_MOD_PALPHA0, IF_REAL, "Cross-term dependence of alpha0"),
IOP( "palpha1", BSIM4v3_MOD_PALPHA1, IF_REAL, "Cross-term dependence of alpha1"),
IOP( "pbeta0", BSIM4v3_MOD_PBETA0, IF_REAL, "Cross-term dependence of beta0"),
IOP( "pagidl", BSIM4v3_MOD_PAGIDL, IF_REAL, "Cross-term dependence of agidl"),
IOP( "pbgidl", BSIM4v3_MOD_PBGIDL, IF_REAL, "Cross-term dependence of bgidl"),
IOP( "pcgidl", BSIM4v3_MOD_PCGIDL, IF_REAL, "Cross-term dependence of cgidl"),
IOP( "pegidl", BSIM4v3_MOD_PEGIDL, IF_REAL, "Cross-term dependence of egidl"),
IOP( "paigc", BSIM4v3_MOD_PAIGC, IF_REAL, "Cross-term dependence of aigc"),
IOP( "pbigc", BSIM4v3_MOD_PBIGC, IF_REAL, "Cross-term dependence of bigc"),
IOP( "pcigc", BSIM4v3_MOD_PCIGC, IF_REAL, "Cross-term dependence of cigc"),
IOP( "paigsd", BSIM4v3_MOD_PAIGSD, IF_REAL, "Cross-term dependence of aigsd"),
IOP( "pbigsd", BSIM4v3_MOD_PBIGSD, IF_REAL, "Cross-term dependence of bigsd"),
IOP( "pcigsd", BSIM4v3_MOD_PCIGSD, IF_REAL, "Cross-term dependence of cigsd"),
IOP( "paigbacc", BSIM4v3_MOD_PAIGBACC, IF_REAL, "Cross-term dependence of aigbacc"),
IOP( "pbigbacc", BSIM4v3_MOD_PBIGBACC, IF_REAL, "Cross-term dependence of bigbacc"),
IOP( "pcigbacc", BSIM4v3_MOD_PCIGBACC, IF_REAL, "Cross-term dependence of cigbacc"),
IOP( "paigbinv", BSIM4v3_MOD_PAIGBINV, IF_REAL, "Cross-term dependence of aigbinv"),
IOP( "pbigbinv", BSIM4v3_MOD_PBIGBINV, IF_REAL, "Cross-term dependence of bigbinv"),
IOP( "pcigbinv", BSIM4v3_MOD_PCIGBINV, IF_REAL, "Cross-term dependence of cigbinv"),
IOP( "pnigc", BSIM4v3_MOD_PNIGC, IF_REAL, "Cross-term dependence of nigc"),
IOP( "pnigbinv", BSIM4v3_MOD_PNIGBINV, IF_REAL, "Cross-term dependence of nigbinv"),
IOP( "pnigbacc", BSIM4v3_MOD_PNIGBACC, IF_REAL, "Cross-term dependence of nigbacc"),
IOP( "pntox", BSIM4v3_MOD_PNTOX, IF_REAL, "Cross-term dependence of ntox"),
IOP( "peigbinv", BSIM4v3_MOD_PEIGBINV, IF_REAL, "Cross-term dependence for eigbinv"),
IOP( "ppigcd", BSIM4v3_MOD_PPIGCD, IF_REAL, "Cross-term dependence for pigcd"),
IOP( "ppoxedge", BSIM4v3_MOD_PPOXEDGE, IF_REAL, "Cross-term dependence for poxedge"),
IOP( "pvfbcv", BSIM4v3_MOD_PVFBCV, IF_REAL, "Cross-term dependence of vfbcv"),
IOP( "pvfb", BSIM4v3_MOD_PVFB, IF_REAL, "Cross-term dependence of vfb"),
IOP( "pacde", BSIM4v3_MOD_PACDE, IF_REAL, "Cross-term dependence of acde"),
IOP( "pmoin", BSIM4v3_MOD_PMOIN, IF_REAL, "Cross-term dependence of moin"),
IOP( "pnoff", BSIM4v3_MOD_PNOFF, IF_REAL, "Cross-term dependence of noff"),
IOP( "pvoffcv", BSIM4v3_MOD_PVOFFCV, IF_REAL, "Cross-term dependence of voffcv"),
IOP( "pxrcrg1",  BSIM4v3_MOD_PXRCRG1, IF_REAL, "Cross-term dependence of xrcrg1"),
IOP( "pxrcrg2",  BSIM4v3_MOD_PXRCRG2, IF_REAL, "Cross-term dependence of xrcrg2"),
IOP( "plambda",  BSIM4v3_MOD_PLAMBDA, IF_REAL, "Cross-term dependence of lambda"),
IOP( "pvtl",      BSIM4v3_MOD_PVTL,     IF_REAL, "Cross-term dependence of vtl"),
IOP( "pxn",     BSIM4v3_MOD_PXN,    IF_REAL, "Cross-term dependence of xn"),
IOP( "peu",  BSIM4v3_MOD_PEU, IF_REAL, "Cross-term dependence of eu"),

/* stress effect*/
IOP( "saref", BSIM4v3_MOD_SAREF, IF_REAL, "Reference distance between OD edge to poly of one side"),
IOP( "sbref", BSIM4v3_MOD_SBREF, IF_REAL, "Reference distance between OD edge to poly of the other side"),
IOP( "wlod", BSIM4v3_MOD_WLOD, IF_REAL, "Width parameter for stress effect"),
IOP( "ku0", BSIM4v3_MOD_KU0, IF_REAL, "Mobility degradation/enhancement coefficient for LOD"),
IOP( "kvsat", BSIM4v3_MOD_KVSAT, IF_REAL, "Saturation velocity degradation/enhancement parameter for LOD"),
IOP( "kvth0", BSIM4v3_MOD_KVTH0, IF_REAL, "Threshold degradation/enhancement parameter for LOD"),
IOP( "tku0", BSIM4v3_MOD_TKU0, IF_REAL, "Temperature coefficient of KU0"),
IOP( "llodku0",  BSIM4v3_MOD_LLODKU0, IF_REAL, "Length parameter for u0 LOD effect"),
IOP( "wlodku0",  BSIM4v3_MOD_WLODKU0, IF_REAL, "Width parameter for u0 LOD effect"),
IOP( "llodvth",  BSIM4v3_MOD_LLODVTH, IF_REAL, "Length parameter for vth LOD effect"),
IOP( "wlodvth",  BSIM4v3_MOD_WLODVTH, IF_REAL, "Width parameter for vth LOD effect"),
IOP( "lku0", BSIM4v3_MOD_LKU0, IF_REAL, "Length dependence of ku0"),
IOP( "wku0", BSIM4v3_MOD_WKU0, IF_REAL, "Width dependence of ku0"),
IOP( "pku0", BSIM4v3_MOD_PKU0, IF_REAL, "Cross-term dependence of ku0"),
IOP( "lkvth0", BSIM4v3_MOD_LKVTH0, IF_REAL, "Length dependence of kvth0"),
IOP( "wkvth0", BSIM4v3_MOD_WKVTH0, IF_REAL, "Width dependence of kvth0"),
IOP( "pkvth0", BSIM4v3_MOD_PKVTH0, IF_REAL, "Cross-term dependence of kvth0"),
IOP( "stk2", BSIM4v3_MOD_STK2, IF_REAL, "K2 shift factor related to stress effect on vth"),
IOP( "lodk2", BSIM4v3_MOD_LODK2, IF_REAL, "K2 shift modification factor for stress effect"),
IOP( "steta0", BSIM4v3_MOD_STETA0, IF_REAL, "eta0 shift factor related to stress effect on vth"),
IOP( "lodeta0", BSIM4v3_MOD_LODETA0, IF_REAL, "eta0 shift modification factor for stress effect"),


IOP( "noia", BSIM4v3_MOD_NOIA, IF_REAL, "Flicker noise parameter"),
IOP( "noib", BSIM4v3_MOD_NOIB, IF_REAL, "Flicker noise parameter"),
IOP( "noic", BSIM4v3_MOD_NOIC, IF_REAL, "Flicker noise parameter"),
IOP( "tnoia", BSIM4v3_MOD_TNOIA, IF_REAL, "Thermal noise parameter"),
IOP( "tnoib", BSIM4v3_MOD_TNOIB, IF_REAL, "Thermal noise parameter"),
IOP( "rnoia", BSIM4v3_MOD_RNOIA, IF_REAL, "Thermal noise coefficient"),
IOP( "rnoib", BSIM4v3_MOD_RNOIB, IF_REAL, "Thermal noise coefficient"),
IOP( "ntnoi", BSIM4v3_MOD_NTNOI, IF_REAL, "Thermal noise parameter"),
IOP( "em", BSIM4v3_MOD_EM, IF_REAL, "Flicker noise parameter"),
IOP( "ef", BSIM4v3_MOD_EF, IF_REAL, "Flicker noise frequency exponent"),
IOP( "af", BSIM4v3_MOD_AF, IF_REAL, "Flicker noise exponent"),
IOP( "kf", BSIM4v3_MOD_KF, IF_REAL, "Flicker noise coefficient"),

IP( "nmos", BSIM4v3_MOD_NMOS,  IF_FLAG, "Flag to indicate NMOS"),
IP( "pmos", BSIM4v3_MOD_PMOS,  IF_FLAG, "Flag to indicate PMOS"),
};

char *BSIM4v3names[] = {
   "Drain",
   "Gate",
   "Source",
   "Bulk",
   "Charge"
};

int	BSIM4v3nSize = NUMELEMS(BSIM4v3names);
int	BSIM4v3pTSize = NUMELEMS(BSIM4v3pTable);
int	BSIM4v3mPTSize = NUMELEMS(BSIM4v3mPTable);
int	BSIM4v3iSize = sizeof(BSIM4v3instance);
int	BSIM4v3mSize = sizeof(BSIM4v3model);
