
#ifndef __search_h__
#define __search_h__

#include <time.h>

struct results_set
{
	guchar guid[16];
	guint32 num_recs;
	guint32 ip;
	guint16 port;
	guint32 speed;
	guint16 status; // status bits 7 known vendor, 1 busy, 0 push needed, maybe more later
	gchar *trailer; // copy of the actual raw trailer data, vendor code is here, busy bits

	GSList *records;
};

// We make a record for every Query Hit file name info, you
// could have 255 of these in one result set

struct record
{
	struct results_set *results_set;
	gchar *name; // the file name
	guint32 size; // size of the file
	guint32 index; // index tag for the GET command
	gchar *tag_data; // copy of the actual raw tag data, may be MP3 tag info, 0 terminated
};


extern GSList *searches;							/* List of search structs */

/* flags for _new_search() */
#define SEARCH_PASSIVE     0x01         /* start a passive search */

#endif	/* __search_h__ */

/* vi: set ts=3: */

