#!/usr/bin/perl

$README = <<_README;

 mysql_admin.pl for NapShare updated 01/10/03

 This script creates a MySql table if one doesn't exist and inserts
 information for each file from the directory given. The data is used
 by the companion NapShare Automation Filter Script called
 "filter_sql.pl" which searches the database as files are
 passed to it from NapShare.

 You must create a database with a username and a password on your
 local machine. You need to have mysqld running on your system.

 Set this script to CHMOD 755 for it to run.

 It will also show you a list of any duplicate files that have the
 same exact size. The idea here is that files over about 300K in size
 on the network that have the same exact size are probably dups. Its
 up to you what you want to do with your duplicate files.

 You MUST set the variables below with your own database name, user
 name, password and the path to your "done" NapShare file directory.

 This program is run from the command line like and a menu is provided
 for all function choices.

 Mandrake commands used to create a database and user were:

 run this from root:
 mysql_setpermission
 at the prompt you want to "Add a database + user privilege for that database"
 create a database called "filelist" and a username "yourname" and a password
 for that user, and type "localhost" as a host name to allow access from
 (all this without the "" quotes of course) and enter that info into the
 variables below.
 There are also commands called "mysqladmin" and "mysqlaccess", you may want
 to read the man page for those or use phpMyAdmin from freshmeat.net

 This program is released under the GNU Public License (GPL) and is
 "open source". By using it you release the authors of NapShare from
 any and all liablilty resulting from it's use. You use this program
 at your own risk.

 Look for further updates to this script in the seperate file for perl
 filter scripts at the main NapShare download area at
 http://napshare.sf.net

_README

# end of README ------------------------------------------------------

#
#
# ----- Set these for your database settings

$database = "filelist";     ## the name of our database
$user     = "yourusername";           ## username for database
$password = "yourpassword";    ## password for database

$directory = "/home/username/workingdir/done/";

# ----- End of your database settings
#
#

$dbg = 0;                   # turn this on for a little more output

use DBI;

# no caching on STDOUT
$| = 1;

#########################
########## Main Menu Loop

while ( !$end ) {
	 print "\n";
	 print "     ###########################################\n";
	 print "     #      NapShare MySql Admin Program       #\n";
	 print "     #                                         #\n";
	 print "     #  What would you like to do:             #\n";
	 print "     #                                         #\n";
	 print "     #  1. Add or Update the File Data.        #\n";
	 print "     #     - adds only new file data           #\n";
	 print "     #  2. Show Duplicate Size Files.          #\n";
	 print "     #  3. Search & Show Records.              #\n";
	 print "     #  4. Create the Table.                   #\n";
	 print "     #  5. Delete the Table.                   #\n";
	 print "     #  6. Delete all Records, Empty Table.    #\n";
	 print "     #  7. Show Settings.                      #\n";
	 print "     #  0. Exit this program.                  #\n";
	 print "     #                                         #\n";
	 print "     ###########################################\n\n";
	 print "Make your choice [1,2,3,4,5,6,7,0]: ";

	 while (<STDIN>) {
		  $answer = $_;
		  chomp($answer);
		  if ( $answer =~ /1|2|3|4|5||6|7|0/ ) {
				print "\n";
				&fill_table    if ( $answer == 1 );
				&show_dups     if ( $answer == 2 );
				&search_table  if ( $answer == 3 );
				&create_table  if ( $answer == 4 );
				&drop_table    if ( $answer == 5 );
				&delete_all    if ( $answer == 6 );
				&show_settings if ( $answer == 7 );
				if ( $answer == 0 ) {
					 print "Later..... \n\n";
					 $end = 1;
					 }
				} ## end if ( $answer =~ /1|2|3|4|5||6|7|0/)
		  else {
				print "\n ERROR: Your answer was $answer\n";
				print "That's not a option, please try again\n";
				}
		  last;
		  } ## end while (<STDIN>)
	 } ## end while ( !$end )

exit;


#
##########################
####### All the little commands

sub create_table {

	 &mysql_connect;    ## connect to database server

	 &mysql_execute(
		  "CREATE TABLE napshare (
				 id int(11) NOT NULL auto_increment,
				 filename text NOT NULL,
				 size int(11) NOT NULL default '0',
				 PRIMARY KEY (id)
				 );"
		  );

	 if ( defined $rc ) { print "Table Created\n"; }

	 &mysql_disconnect;

	 print "\n --- ALL DONE ---\n";

	 } ## end sub create_table

sub drop_table {
	 my ($answer1);
	 print "WARNING: This will delete all data and delete the table\nAre you sure? [y/n]: ";
	 while (<STDIN>) {
		  $answer1 = $_;
		  chomp($answer1);
		  if ( $answer1 =~ /y|Y|n|N/ ) {
				if ( $answer1 eq "y" || $answer1 eq "Y" ) { last; }
				if ( $answer1 eq "n" || $answer1 eq "N" ) {
					 print "\nABORTED: Nothing done.\n";
					 return;
					 }
				} ## end if ( $answer1 =~ /y|Y|n|N/)
		  else { print "\nPlease enter 'y' or 'n': "; }
		  } ## end while (<STDIN>)

	 &mysql_connect;    ## connect to database server

	 &mysql_execute( "DROP TABLE napshare ;" );

	 &mysql_disconnect;

	 print "\n --- ALL DONE ---\n";

	 } ## end sub drop_table

sub delete_all {
	 my ($answer1);
	 print "WARNING: This will delete all data in the current table\nAre you sure? [y/n]: ";
	 while (<STDIN>) {
		  $answer1 = $_;
		  chomp($answer1);
		  if ( $answer1 =~ /y|Y|n|N/ ) {
				if ( $answer1 eq "y" || $answer1 eq "Y" ) { last; }
				if ( $answer1 eq "n" || $answer1 eq "N" ) {
					 print "\nABORTED: Nothing done.\n";
					 return;
					 }
				} ## end if ( $answer1 =~ /y|Y|n|N/)
		  else { print "\nPlease enter 'y' or 'n': "; }
		  } ## end while (<STDIN>)

	 &mysql_connect;    ## connect to database server

	 &mysql_execute( "DELETE FROM napshare ;" );

	 &mysql_disconnect;

	 print "\n --- ALL DONE ---\n";

	 } ## end sub delete_all

sub fill_table {

	 $count = 0;

	 &mysql_connect;    ## connect to database server

	 opendir( aDIR, "$directory" ) || die "\nCan't open dir '$directory'\n";
	 @files = readdir(aDIR);
	 closedir(aDIR);

	 print "Working (please wait) ";

	 foreach $file (@files) {
		  if ( !-f "$directory$file" ) { next; }
		  @fStat = stat("$directory$file");

		  $size     = "";
		  $filename = "";
		  &mysql_execute("SELECT * FROM napshare WHERE size = $fStat[7] AND filename = \"$file\"");
		  if ($sth) {
				( $id, $filename, $size ) = $sth->fetchrow();
				}

		  if ( ( $size eq "" ) && ( $filename eq "" ) ) {
				print ".";
				&mysql_execute(
					 "INSERT INTO napshare (filename,size)
                       VALUES(\"$file\",$fStat[7]) " );
				$count++;
				} ## end if ( ( $size eq "" ) &&...
		  } ## end foreach $file (@files)

	 &mysql_disconnect;

	 print "\n$count Records added this pass.\n";

	 print "\n --- ALL DONE ---\n";

	 } ## end sub fill_table

sub show_settings {

	 print "Current Settings:\n\n";
	 print "Database Username: '$user'\n";
	 print "Database Name    : '$database'\n";
	 print "File Directory   : '$directory'\n";
	 print "\n";

	 } ## end sub show_settings

sub search_table {

	 print "Enter Search Keywords: ";
	 $termsx = <STDIN>;
	 chomp($termsx);

	 &make_terms;    ##make a SQL call from the terms

	 print "\nSearching for: '$it'\n\n";

	 if ( $it ne "" ) {

		  &mysql_connect;    ## connect to database server

		  ### now we will read out all rows that are in the database, for later fetch

		  &mysql_execute("SELECT * FROM napshare WHERE $it");

		  print "Results:\n\n";

		  if ($sth) {
				while ( ( $id, $filename, $size ) = $sth->fetchrow() ) {
					 print "$size $filename\n";
					 }
				}
		  else { print "NONE FOUND.\n"; }
		  } ## end if ( $it ne "" )

	 &mysql_disconnect;

	 print "\n --- ALL DONE ---\n";

	 } ## end sub search_table

sub show_dups {

	 print "\n --- DUPLICATE CHECK REPORT BELOW (using size for match) ---\n";

	 &mysql_connect;    ## connect to database server

	 &mysql_execute("SELECT * FROM napshare");
	 if ($sth) {
		  while ( ( $id, $filename, $size ) = $sth->fetchrow() ) {
				$first = 0;
				&mysql_execute2("SELECT * FROM napshare WHERE size = $size AND id != $id");
				if ($sth2) {    # note that we are using sth2 here
					 while ( ( $id2, $filename2, $size2 ) = $sth2->fetchrow() ) {
						  if ( !$first ) {
								print "----ORIG= $size $filename\n";
								$first = 1;
								}
						  print "DUP-SIZE= $size2 $filename2\n";
						  } ## end while ( ( $id2, $filename2...
					 } ## end if ($sth2)
				} ## end while ( ( $id, $filename,...
		  } ## end if ($sth)

	 &mysql_disconnect;

	 print "\n --- ALL DONE ---\n";

	 } ## end sub show_dups

#######################
# MySql connect to database Subroutine

sub mysql_connect {

	 undef($dbh);
	 my ($errflag);

	 $errflag = 0;
	 $dsn     = "DBI:mysql:$database";

	 $dbh = DBI->connect( $dsn, $user, $password ) or $errflag = 1;    ## here's where we connect

	 if ( !defined $dbh ) { $errflag = 1; }

	 if ($errflag) { print "ERROR: Can't connect to database '$database'\n"; }

	 if ( $dbg > 0 ) { print "Connected to database.\n\n"; }
	 } ## end sub mysql_connect

#######################
# MySql disconnect from database Subroutine

sub mysql_disconnect {

	 if ( defined $sth )  { $sth->finish; }
	 if ( defined $sth2 ) { $sth2->finish; }

	 # Disconnect the database handle. This actually
	 # - disconnects you from the database specified
	 # - by $dbh

	 if ( defined $dbh ) { $dbh->disconnect; }

	 if ( $dbg > 0 ) { print "Disconnected from database.\n\n"; }
	 } ## end sub mysql_disconnect

#######################
# MySql execute command Subroutine

sub mysql_execute {

	 undef($sth);
	 undef($rc);
	 my ($errflag);

	 $errflag = 0;

	 $cmd1 = $_[0];

	 $sth = $dbh->prepare("$cmd1") or $errflag = 1;

	 if ( !defined $sth ) { $errflag = 1 }

	 if ( !$errflag ) {
		  $rc = $sth->execute or $errflag = 1;
		  }    #do the command that was 'prepared' before

	 if ( !defined $rc ) { $errflag = 1; }

	 if ($errflag) { print "ERROR: Can't execute command '$cmd1'\n"; }

	 if ( $dbg > 0 ) { print "Execute command complete '$cmd1'.\n\n"; }

	 } ## end sub mysql_execute

#######################
# MySql execute command Subroutine for sub commands

sub mysql_execute2 {

	 undef($sth2);
	 undef($rc2);
	 my ($errflag);

	 $errflag = 0;

	 $cmd1 = $_[0];

	 $sth2 = $dbh->prepare("$cmd1") or $errflag = 1;

	 if ( !defined $sth2 ) { $errflag = 1 }

	 if ( !$errflag ) {
		  $rc2 = $sth2->execute or $errflag = 1;
		  }    #do the command that was 'prepared' before

	 if ( !defined $rc2 ) { $errflag = 1; }

	 if ($errflag) { print "ERROR: Can't execute command '$cmd1'\n"; }

	 if ( $dbg > 0 ) { print "Execute command complete '$cmd1'.\n\n"; }

	 } ## end sub mysql_execute2

######### Here we make the search terms

sub make_terms {

	 @terms = split ( /\s+/ , $termsx );

	 $it = "";

	 $showterm = "";

	 $flag = "0";

	 foreach $term (@terms) {
		  if ( ( $term eq 'and' ) or ( $term eq 'AND' ) ) {
				$it .= "AND ";
				$showterm .= "AND ";
				$flag = "0";
				next;
				} ## end if ( ( $term eq 'and' ...
		  elsif ( ( $term eq 'or' ) || ( $term eq 'OR' ) ) {
				$it .= "OR ";
				$showterm .= "OR ";
				$flag = "0";
				next;
				} ## end elsif ( ( $term eq 'or' )...
		  elsif ( $term eq '+' ) {
				$it .= "AND ";
				$showterm .= "AND ";
				$flag = "0";
				next;
				} ## end elsif ( $term eq '+' )
		  elsif ( ( length $term ) < 2 ) {    ## skip terms less than 2 letters
				next;
				}
		  ## at this point we have a term word
		  if ( $flag eq "1" ) {    ## no and/or so put in or as default after first term passes
				$it .= "AND ";
				$showterm .= "AND ";
				}

		  $term =~ s/\n//g;        # no \n for this string
		  $showterm .= $term . " ";
		  $showterm2 .= $term . " ";

		  $it .= "((filename LIKE '\%$term\%') OR (size LIKE '\%$term\%')) ";
		  $flag = "1";
		  } ## end foreach $term (@terms)

	 $showterm =~ s/^\s+//;       ## remove trailing spaces
	 $showterm =~ s/\s+$//;
	 } ## end sub make_terms

