(require 'quail)
(quail-define-package "py-CNS" "py-CNS"
 t
 "Chinese National Standard planes 3-7
pinyin input package
mechanically extracted from the cefdb database of the
KanjiBase for Windows package written by Christian Wittern."
 '(
  (">" . quail-next-candidate-block)
  ("<" . quail-prev-candidate-block)
  (" " . quail-select-current)
  )
 nil nil)

;;
(qd  "a1"	"$(K2!(B")
(qdv "ai1"	"$(J2q7[7l$(KGL$(L5Y(B")
(qdv "ai2"	"$(I'g@zG0$(JBWD2D7mL$(KNWPnWB^Qntn|$(LQ<^]cd$(M0KDbH)(B")
(qdv "ai3"	"$(IO2Yg$(J1LBUMI[>\t$(K<@=*I&P"$(L;)KaSo$(M#\I~]W(B")
(qdv "ai4"	"$(I(|3x7_C4RLT]VwX8$(J"*&&&0@wKeV5[M[|`1`U$(KC,Y>b4eZ$(L'[-B/e6h?m?p?uHmNoR-SxSyZlc`cs$(M,r?[aUby(B")
(qdv "an1"	"$(I7O:oD>IkNO[U`($(J+T13?MBvTkV)$(K#l$&(GLFde$(L*lV}$(M.n3N=EC9d7(B")
(qdv "an2"	"$(I&e$(Jg=$(K8d^R$(L9FQ@(B")
(qdv "an3"	"$(I;g?pByHx$(J?'F/TZcXl_$(K:mWVep{3$(M&q(B")
(qdv "an4"	"$(I(ZW@$(J3j71^P^hhVl>$(K%GM}R"_xc=f`xu$(L88As$(ML2(B")
(qdv "ang1"	"$(M'8+S(B")
(qdv "ang2"	"$(I*e-"$(J#z8-H_$(K*m$(L![(B")
(qdv "ang3"	"$(IJ_$(J3x$(M5~(B")
(qdv "ang4"	"$(I)J2J$(JK($(K#u>-F@FO$(L9[Og(B")
(qdv "ao1"	"$(I%??G$(J#T^L$(K"4$!Q)(B")
(qdv "ao2"	"$(I@HF.GxU~Xa_#$(J3HC*C,C.IsJFSCVa[-]s^2e/e4g_j%$(KMU]lnanqr;rBvB$(LS-$(M!C,./F5N6`8)9(91;,;.<^I2InO5P9PtSfVRVWZ/ZuZ}[-[/\D]/]g`I`XaVcA(B")
(qdv "ao3"	"$(I&83v:y$(J$3'6OI`VeIlR$(K]~fO$(LI3O{$(M,((B")
(qdv "ao4"	"$(IFOFQFqK}PR$(J"Q.]6yC[CbS5dNlL$(K'C.z8=KDber*$(L0K646:>0B|RI\+\d\e$(M!r-7-=-L/J7}8|Lj(B")
(qdv "ba1"	"$(I.13=4.$(J#*';*62Bc)$(K&@&w5b6!=PCmW|(B")
(qdv "ba2"	"$(I"+&4(32v$(J%h&9*&*-5[;`@MHWNnNuUCUJYZ$(K)g/+5j<eKNM.O~$(L+`+d:KGFO4O<WNYtd;$(M+H6QM+a}(B")
(qdv "ba3"	"$(I14$(J77$(L@3(B")
(qdv "ba4"	"$(I003<[/a@ag$(J*p?ZHcUpcye`$(K4~YL$(L2`AZI|V,b6$(MDZIW^j(B")
(qdv "bai1"	"$(J2&$(K2^(B")
(qdv "bai2"	"$(I2I$(L%<(}(B")
(qdv "bai3"	"$(I0uAD$(K>=bE$(L7r@1Zz$(MG/(B")
(qdv "bai4"	"$(I$9)09IZK$(J@EP%`5$(K%x@hE'I-_inRqq$(L'C7n8iI+IKUz[H]9^Y`.$(M7,86=_?mCRG7^](B")
(qdv "ban1"	"$(I)E*[BeY8$(JB:KPK\R;S8SDV{eO$(K&h*GAiN;SCr[$(L!7#s8-9R;IB:KJW?af$(M%:2^9B<h<vIU_~ajd](B")
(qdv "ban3"	"$(I%@%f$(JAy$(K#n(7;G$(L<gB}C"a~(B")
(qdv "ban4"	"$(I!S2s$(J#X%x)aI}$(K+ORme6sm$(L't4&@7(B")
(qdv "bang1"	"$(I0,0h2&9Q;;A1MC[\$(J&4$(KG'N>_Dta$(L2t4f<^OX$(M;l(B")
(qdv "bang3"	"$(J(<87Ps$(K9\$(LUI^%^&^-(B")
(qdv "bang4"	"$(I)M17E>$(J*b?PJGO($(K";"p8a>uDzvq$(L'bDGDH$(M(2B-Qv(B")
(qdv "bao1"	"$(ISDVB$(J(-6/$(K"6%u$(L"F2/;,IB$(M([It(B")
(qdv "bao2"	"$(IJK^i$(J?\Ntct$(L-9$(MKRQ6X:YzeL(B")
(qdv "bao3"	"$(I(N012E2F:P@uN/RsT4W-Z5b>$(J!B4;[1c6ecn>$(K%eDIZ8$(L"K%!)C/f2N4;6f9JAzCCFKFSQqd<dDdO$(M+9+@5b6';4E1EbL"LGS?(B")
(qdv "bao4"	"$(I!U&2-C^#$(J-KH?HnVAZu[A]CiIiSk"mk$(K)K6m=y>3?mG#$(LGXYTd+$(M('.X2_?vCuDlDnG<G=MIN1SlU!WVX6[m]7aLeQeS(B")
(qdv "bei1"	"$(IApS=$(J%S>i?6?C?te2g!k*$(K.q25@#G=QEVdoSpg$(L#n/3/8:f>`$(M!_51Lc[uc}(B")
(qdv "bei3"	"$(J5"$(L"I(B")
(qdv "bei4"	"$(I)B/X0A4J788&@=BlIxN*[^$(J%'&A'3,20\:';U=/==A`BECvD_M$O+UhWlfJ$(K!l&?&j5+M8M?S)$(L&v)1)J-,0$539]FIJ4JtK-K4P[TV]'`0$(M"s%%%U5m6B7xKaLyW0Z%[r^X(B")
(qdv "ben1"	"$(I=%`i$(J+aD$mF$(K)zoY$(L*00r3WE1$(M)I4'6KQ#U?(B")
(qdv "ben3"	"$(I"7AsGP$(J,8$(K&&Z]Z_$(L#p6IH'J6UBUC[q$(M"C(B")
(qdv "ben4"	"$(I)#6"6N?PA@EUL=$(J-n4r$(K\^(B")
(qdv "beng1"	"$(I@yHpIZVE$(J1?:NWD$(K$',%,-2A9#E3EbI;JVZ"cW$(L0Oa%b0cf$(MX[(B")
(qd  "beng2"	"$(K6P(B")
(qdv "beng3"	"$(IVyVzW/\!$(JE1L:LFRqfy$(K*F<4D:`!dE$(L2k$(M(KC1(B")
(qdv "beng4"	"$(I?QLQbF$(JA#F~Sp$(K>IAvJ~b#$(LY1$(M)D3qS4(B")
(qdv "bi1"	"$(I&t<aW*$(J*1:i='?mMQSAb@$(K%SEyJzM4PrR$Tv$(LD/a^$(M:>='(B")
(qdv "bi2"	"$(J-mHwO,$(L5#(B")
(qdv "bi3"	"$(I"F#G$D.b/?3,31$(J*gB|GrL{UgZ5$(K*X,0,109678_9B=~L@M=SIU]ir$(L(o*k,D9.TN$(M05TtW/Y(cocp(B")
(qdv "bi4"	"$(I$y%9*8,O0.8:8t9\;E<O?/?oBQH`I#LNL]X7XjY0[V]7]P_($(J!L"F#N$%$W&e(**N+/,q.M.e4%4J4y;I<1<4>MBdBjC&H;HCJ+K"N#NLQ+QKVPVQWaXUYL[b]/]U^o`3`Pb8bDe'e6eTg\gbn#$(K":#M#g%Y%y("(*)\)c.o3I6V9Z=->y?|A3F$F&G:GbGsKBL3MJMdO^OnTFUxV8YW^e_-`-aZb>eFm/u!uGvtyPz*zj$(L*V*W+6.W.].`=*>l?C?E?g@0HVHWKWM?OYOfO}PZUDX\YaYk\X\fb.$(M"f&U&x'<(j)/)e)g*-+o-f/[1?485A8b9):N:e@<AFC6COE=ECH}J#P;QOQtY4ZYZw\ea!(B")
(qdv "bian1"	"$(I$;B[MmV`Y:]j]t$(J$gT6f-iNm8$(K&BqKsU$(L#V%x3BERE\$(M6x7%:.@DC}DkK"Q@VjYK_(_0`ibgcf(B")
(qdv "bian3"	"$(J/KT3[#[*\']($(K(&jywL$(L-t;>CgE($(M::JuNW(B")
(qdv "bian4"	"$(I$e)b*,+y.l;I;K?%J!S&$(J(,)g)o*7,L/v;i>'HLV\[Kf1iKmv$(K9,9l>"@{K[[xb8lXoGr|{C$(L".+^,z021f7?=.=k?M?N?\H`NvNwROT0\`aO$(M"i#F)u3=3T9P:;:?YAYX[Y\i\j(B")
(qdv "biao1"	"$(IC$T9W|^y^{aWb%$(J!P:GC0P'QnQyReV#W1[=f~g`$(K!7M#So\xp.r6zR|<$(L?[P>P?$(M$p+3:W?W?t@BJGR}X&X8],bs(B")
(qdv "biao3"	"$(IRv$(JC!S#$(K[VdY$(L;x;y;}<%$(M,);[>[U#_Q(B")
(qdv "biao4"	"$(I6,$(JiD$(Mc3(B")
(qdv "bie1"	"$(Ia_$(J9_CRm_n3$(KN}Uofx$(McB(B")
(qdv "bie2"	"$(I$`$(J&Y,Y4m?bA|U&$(K-S:=>UIxYm^A`{$(L!N)eLDdJ$(M5tP7VJ(B")
(qdv "bie4"	"$(J,6,r6K?n@fWr$(K2t:Va^$(L7CAJFq$(MO%(B")
(qdv "bin1"	"$(I5VB;QYZe\n^``\``$(J";-oGWV+iVm;$(K&]dse7i`r@sAxT$(L&zLObfbg$(M-3KCU8`,`=(B")
(qdv "bin3"	"$(J?}X7$(Ks%$(M^M(B")
(qdv "bin4"	"$(IGTJpW<$(K>b$(M8+Uj(B")
(qdv "bing1"	"$(I!L"W6_HjM]Up$(K'+?TBJOF_hrv$(L)x,L.X.Y/M=P$(M#C`9(B")
(qdv "bing3"	"$(I)1-#2\60C=SdWO$(J.T4):jTJ$(K#>(O,[0\7mRFRJZHkx$(L(n,$$(M4K=PK\(B")
(qdv "bing4"	"$(I$X(c/K1P3$<AE+bE$(J+`6:FyZ?bnd\gK$(K%$8-84CNEZE_T\b6chd$gehYk8$(L)9759fK)$(M2c(B")
(qdv "bo1"	"$(I"\/c2Z65E3]^$(J!A('/r7)?dK[`sclij$(K!v%w'?'a*]6}g|h"t}$(L!V!W!X%h'x)i8vDXS&Un$(M&O+!J\R.(B")
(qdv "bo2"	"$(I&f,t.r0]1^2X<g?}@'@,A.G8G`GlI-KeO'OqQOT1aV$(J&$'7(8,02p343:9k<G>GB9D^G4H]KuRKS=SUTiUEXy`R`ravcEfxgrk,k:kXmP$(K#N)G3.4P52:d;iAXD#KSM~N*U9UFUjUqYo]_^Kacg3gkjCtox:zF{S$(L(V-7/'?jGGIEO:$(M!Q$:$o$v'[)=,A.'2+5x<L?YB;CVE4HJJ4LYS:SFW.YC[N\C]Fc)e)f2f<(B")
(qdv "bo3"	"$(IOm$(J&'$(K$qs.$(L0506O@$(MEy(B")
(qdv "bo4"	"$(IPWU#$(J0D\gch$(K1rZ7\&$(M.KMm(B")
(qdv "bu1"	"$(I0k$(JUI$(K!^6*:u$(L@Vc5$(M%d*[4:EW(B")
(qdv "bu2"	"$(JPq$(Kvi$(M_O(B")
(qdv "bu3"	"$(I=P@SCeOY$(J$][His$(K!s$jLYR(RpUHy}zG$(L!,7G<r$(M=7DiUDV[(B")
(qdv "bu4"	"$(I)U)V)^7?8T96CZIoSb$(J(F-,.Z::@/K1N;TfX4XCbv$(K&'0c5<:;U(`<c9fq$(L#?$a.p9iCqV=$(MKQ(B")
(qdv "ca1"	"$(J`?$(K@-SG(B")
(qd  "ca2"	"$(Ku&(B")
(qdv "ca3"	"$(Jks$(MNO(B")
(qdv "ca4"	"$(J_C$(Kp<(B")
(qdv "cai1"	"$(IH6$(J0'@+$(K^{$(LBK(B")
(qdv "cai2"	"$(I"y$-B.$(J#1$wHt$(L,}E'X%XTb/$(M,,(B")
(qdv "cai3"	"$(I/T$(J1f5n^u$(K@cwY$(LA#$(M#T(B")
(qdv "cai4"	"$(I^O$(KaLbCy`zX$(LD=a:$(M=<G@]:(B")
(qdv "can1"	"$(I"S'i'j9g:)<n@9Y$$(J-a\I]l_)lO$(KYx[4c#c|hli,{)$(L/GG#$(M+8JS(B")
(qdv "can2"	"$(I)W1j5lINIPK~RaTR$(J$MBmIu\#j&$(K$L(1-_J)WTXQ_:nGvC$(L5W8c;e;nCQay$(M2uBcY%b](B")
(qdv "can3"	"$(I5x$(JB>BlCS$(KnF$(M"{"~#!G,Tc(B")
(qdv "can4"	"$(I0GM<P_V($(J%zDAQD$(K3;HMN)u}vvxj$(L&pLc$(M-/9A(B")
(qdv "cang1"	"$(I"v$(J6OHh^\$(KCfG.$(L&#*|,Z4EA@ZM$(M%a+WDU(B")
(qdv "cang2"	"$(INR$(JDPVX$(K[>p>x'$(LMX$(M#&7C(B")
(qdv "cang4"	"$(IJ%MTVQ(B")
(qdv "cao1"	"$(IL>$(JV=$(M8;8>(B")
(qdv "cao2"	"$(INBV?[B$(JBgLXQvjz$(K.tLbMRV|\vjf$(M#YBNMz[I[h^o_Cb`f+(B")
(qdv "cao3"	"$(IA($(J!S$(K>.$(L!tWSaP$(M^f(B")
(qd  "cao4"	"$(Ky6(B")
(qdv "ce3"	"$(J6H_J$(L=H(B")
(qdv "ce4"	"$(I!y>VCOFJH\M_O<Tf$(J)h-C3|6lCGEqMd[5$(K)S*.H+K;M>S=V]$(L"9#Z&"131a2v8AFmLVR^`$aEc7$(M-&-z4C9e9l@?A4(B")
(qdv "cen1"	"$(I5SFX$(L]c$(M"N(B")
(qdv "cen2"	"$(I"CQ.$(J*|WE_(dwk>k@$(KK"sKwb$(M#h:%(B")
(qdv "cen3"	"$(Kj0ls$(M&#(B")
(qdv "ceng2"	"$(IUi$(JR]W.\@$(KL^LrUI$(LVB$(MJ>^`(B")
(qd  "ceng4"	"$(KD[(B")
(qdv "cha1"	"$(I;r@fHN$(J$p+3,?/x6@7@;w<CGw$(K$^(Z-h.#1+3f=;B"H^OfXOXd]d]e`8hK$(L#*.t/"0W;;CjG3IHQfS>YA$(M"S'#'D3h3iH"I1MlOATRa;(B")
(qdv "cha2"	"$(I-4<uDcWt$(J&~,J1NC6J?\~lGnL$(K,w:@:t=q@2AtL"L:N`RAZ@[R^zhLtn$(L(B9gAOKeWJ$(M*O:Y>Aep(B")
(qdv "cha3"	"$(J`]$(K*~(B")
(qdv "cha4"	"$(I'_,)3z$(J![$I0*$(K"g.`[cdhkXrxy!$(L%r)j5Q$(M3Cb$(B")
(qdv "chai1"	"$(I'($(J'S>`F;[fkb$(LI4(B")
(qdv "chai2"	"$(J7wFiK7$(K*?>Y>s(B")
(qdv "chai3"	"$(I8M$(L;RD*(B")
(qdv "chai4"	"$(IaH$(JCJ$(K*$;<HbiEt6x-$(M'q(@;MX}X~(B")
(qdv "chan1"	"$(I8p$(J$)%{.>APJz$(K*S1a1b1k20?&AMY<owzI$(L7#9kB1Hi$(M-X(B")
(qdv "chan2"	"$(I0m55LyN%OOY;_Z$(J$R=tGEaYc>cgdsfPgegvhxme$(K-59">C?ZAyG4Pxg7gVmMn2p6tFvFv\x0xsyQ{U{v|2|:$(L2F=-K@QIQh$(M0X757f8N8z?0@)CGRTU2cOeo(B")
(qdv "chan3"	"$(I/e7E@CFiFxOV[v`H$(J$B+C3%A1J6JoLUOc^,bwh'l-lZ$(K$"6U>,?RD~G+P4R3ake"f?myudvSx6z2z_$(L#g<nI^Y\\=$(M,LD:R/Ya\9]vaS(B")
(qdv "chan4"	"$(I2fAWPC_}$(JVfd[hvi^$(KNtR/YDh=pEs_v9w]x7x8xA{&$(L=4P^$(MZs(B")
(qdv "chang1"	"$(I;~CCIHYh$(J@<bk$(K23S&kM$(L(!8?A9$(M=0(B")
(qdv "chang2"	"$(I!p%;4jBxIGL"M1N=[M$(J!\%+M}apj+$(K;cKY]}bon0$(L"J%w*S.DQ0$(M!3*.5+;?J^`D(B")
(qdv "chang3"	"$(IEnEsF&O*$(JIqkC$(K7c$(L1g$(M$9Cr(B")
(qdv "chang4"	"$(INtV|$(J?(D{]'$(K&4A.TL$(L)_AqU<$(M&.&3B=b+(B")
(qdv "chao1"	"$(IY%$(J%^)r6+HV]%]meph1iw$(K%}9yD=Oc$(LF6\W$(MHmT^U4(B")
(qdv "chao2"	"$(I5WZ)[4$(J3gC+QoW`i~$(KE(E5H3PKe.$(LA5^U$(M"H<kQFR_UL[.(B")
(qdv "chao3"	"$(I&aGoI!^-$(J/==;OLb{$(KBwK%zP$(LJv^H^M^P$(M-`FoN3R$(B")
(qdv "chao4"	"$(I!r"h$(J58BT$(K*L/uQ[eJ(B")
(qdv "che1"	"$(I/vDD$(K-)Ye$(LOEPx$(MYW(B")
(qdv "che3"	"$(I/W6!$(J;F;H$(KFxfh$(LXe$(MZP(B")
(qdv "che4"	"$(I728<=HJR$(J!5!I-k.F2A<5Q\QaSaTQX2gD$(K#O4^4k5IA(C>E#K1MPOBSbT'Ys`z$(L2E2W>(@5ARGE]:bc$(M#/(d(e-e3p7w<+@GPP[?\|(B")
(qdv "chen1"	"$(I&F.gFg$(J9CFEG7$(K')/=<gCuN=NjR5h/$(LBF^t$(M%,%;3e(B")
(qdv "chen2"	"$(I#R/1/60Z6C8P8y9G=m?aZC$(J'0)D042+GkT=],$(K/KJBNVR;a'$(L"P#}'a+@.G/BIVcb$(M*i*j7>8X;"F+KLfS(B")
(qdv "chen3"	"$(I9>$(J5_^I$(K:7A'Gy$(L+-(B")
(qdv "chen4"	"$(I?9DPKST>$(JUik!$(K6BpVvM$(M>sM2RkY8_F(B")
(qdv "cheng1"	"$(I'X)e*y2|:eIFL;N)SZZg$(J**+L8>GY$(K0p4hT2ne$(L4W4X8}$(M9^;2;gJ_(B")
(qdv "cheng2"	"$(I&'+",'1/2?:J<7=a=w>+?<@[DSKvUeX+]\$(J$i&23<8J=V?aE7N][,$(K+f,tJALEM!R%TfTgZr[\`mcsjo$(L+0+]1@1H51;*FCJ9Zx`l$(M)^/#/$9C<PH$Z8]h(B")
(qdv "cheng3"	"$(I+.0p=Q$(J!H$(K2E8S9J?@$(LI!$(M+F5{ej(B")
(qdv "cheng4"	"$(JH5H6S|X{$(K+X87Rhh8(B")
(qdv "chi1"	"$(I%S0C1f=t>|K>]U_E$(J/5>TATD,GIJjU@f*hE$(K&U'](N0Y2eAPHKI"Q!UW^M^mfMkA|N$(L&K(/.V3/8`;j;q>=G1K[PKYz\:]=co$(M#[#q%m+b+c,\2l6,7.:d=q>QCFE&ENEOHVP=TBWBZMb%c@(B")
(qdv "chi2"	"$(I(o.P4S98=x@&AaD|J'SmV>b,$(J+"+b0~=1>4@;@^A^K~O?UVY%YC_H$(K#t$|2P6G;[B7WqvK$(L&^&_&c*F*G*L2?4bBtE)HaHbQKUTWE$(M)C2}2~3!3"3+:q;SJ$OgRiU,Y0b*f%(B")
(qdv "chi3"	"$(I+g3-353I9&<G?(IWRp$(J":)**C-s1O5W:{;oHr$(K"=#E$x'6,20-6^9~;=<2=p>QPdQhZXffi:$(L&s)D.k/g/h8>9;COIAOuSlX1]?]w$(M'B(B")
(qdv "chi4"	"$(I&G&c+F,T/n3B7JC~J8KsKzY1$(J$S%6(:)x7S7T7z9'9B9KG_GzK:O%RjSiSoT(ZXjl$(K!`##)!2z?WDRH]MhOUT|U@W=XhY8mzrc$(L*&1s3":u@AE4O3Y.^m_8bA$(M#)+7+`/]4j9Q>P?s@O@[CdJOMgQYR8VxV{Zg`N(B")
(qdv "chong1"	"$(I"~-L.EF)G(Kr$(J&I'")I0U50EIW8WK]AaFaW$(K/N<f=(Q%V=^+`yr/r:u>uFv`$(L#R%t87AQCuV7W(`w$(M'41wFtZbZedj(B")
(qdv "chong2"	"$(I2)5K@BG]I[_Y$(J3dJsMFek$(K6.8Qjcjg$(L.9$(M\!(B")
(qdv "chong3"	"$(J0{1aHJV|YY$(KOl$(M-;(B")
(qdv "chong4"	"$(IAd$(JB=T$$(K)W4KQmoh$(M4G(B")
(qdv "chou1"	"$(IAFa{$(J$d9MD"X%$(K*UHIQvVnlq$(L-C1L1QJ(K1V0]>$(M#:`j(B")
(qdv "chou2"	"$(IB~CQWg^h`IaZ$(J$E6fMcP}UxY;[9[N`7k0l@m<$(K,eLBN|\2]#cieMwZzQ$(L0x1!=J=~@wHsR[Zh_"_:$(M-n.B/!/2239R;#<uV:W^Z:^0b/(B")
(qdv "chou3"	"$(I+6X9a/$(J!9b"g)$(K<^>4TX_ejQ$(L"*Ot$(M4`7~=TLLLM(B")
(qdv "chou4"	"$(J:LLr$(K:jQi$(L(6(B")
(qdv "chu1"	"$(I#Z]H$(JDk$(K%R0M9w;;Slk9y\$(L)b$(MFdW]^P(B")
(qdv "chu2"	"$(I899<:'F$IBQ:[;$(J<LAWK3Kh]wgEi;$(K^'ppxk$(L5^K3MlMwQ"Spa[cm$(M)+8aJZ(B")
(qdv "chu3"	"$(I<<O.Pab3$(JC>ka$(KWyYAZFb_wI$(M^O(B")
(qdv "chu4"	"$(I$d&~)4-<8Q8b9[9pJ$$(J'85<5J8@9=9j;M>xALGPH"M{T8V?$(K#20G:[<QAYJTJuLfQAR,ZI^uahd}o]$(L1B<=DgE|G"Vvc~$(M*H2]8@P.da(B")
(qd  "chua3"	"$(KD{(B")
(qdv "chua4"	"$(JLvTomo$(K!2bKd4(B")
(qd  "chuai2"	"$(JPA(B")
(qdv "chuai3"	"$(J=\$(K$P$(L7tI8(B")
(qdv "chuai4"	"$(JJMkM$(Kj,{7$(MZr(B")
(qdv "chuan1"	"$(I!<=n$(K#@$(LLSY0(B")
(qdv "chuan2"	"$(I3XQx$(J9yDuVJ$(Kn'$(L4d]r$(M)l8Y(B")
(qdv "chuan3"	"$(IEu$(J@)M-$(K&b;"@.$(M!YC^ML(B")
(qdv "chuan4"	"$(J1u$(K'BAhWaXcdK$(LD'$(MCZ(B")
(qdv "chuang1"	"$(I!R#=6/7qB]M.R/$(JLOQhQu$(K\P\n^<hX$(L$2AbK.K\_R_x_y$(M9N(B")
(qdv "chuang2"	"$(I"[)|K7U^]W$(Ja,dJ$(K,9YNcajj$(L#1(db8$(MQWZB(B")
(qdv "chuang3"	"$(IG*$(JC#$(K=hST(B")
(qdv "chuang4"	"$(I+C/b$(J<6FL]P$(L#iBN[)$(M34:Z(B")
(qdv "chui1"	"$(I_?$(JmQ$(K+g9{$(LG<$(McJ(B")
(qdv "chui2"	"$(I081aW&$(J6uF%L&ea$(K?aV{f2$(L&.+77%P)RxRyZq$(M#D&n*VA;A@D>K5PoUe(B")
(qdv "chui4"	"$(ISA$(JI/K=WB$(K/>\ccG$(L:<$(M0>@3(B")
(qdv "chun1"	"$(I)C1G4">ZBoX"$(Jee$(KX\$(L1lSC$(M'}.\.r=H>RGFN0(B")
(qdv "chun2"	"$(I2"4,44<b>FBEIDNES,$(J#c5xLHTU$(K5*M_U.j3$(L#I'e3g$(M'7--GSY`Ys]'`Q(B")
(qdv "chun3"	"$(I*Z:,:KCxH5NYVl[j$(J=D=XKs$(K/p=[G[yI$(LI&Zp]($(M#$-tJ`_HaE(B")
(qdv "chuo1"	"$(I4l$(JmN$(K5`tLv^$(M[=[>b'er(B")
(qdv "chuo4"	"$(I'/'k.N6z8L:UE'IwNsX[`S$(J!T){14<A>WZo^bgOj>$(K+WBhXf[+aCfUzk$(L)W?a@|Umb@$(M%L)c1u7P<DAVNt[9^Nce(B")
(qdv "ci1"	"$(I7[97?zWK$(J&,/H:.OER0$(K.56pCjW$$(L<LRDTg[B$(M-?-YPAPBVUae(B")
(qdv "ci2"	"$(I+l-{5p?&?KDwFpH(MnO7P:Zc_w$(J4(>,H-L2UT$(K.&5EO;hd$(L.0LsSI`}$(M#e$z%I%}=v={CsUzY|(B")
(qdv "ci3"	"$(J:&$(K)-,6AmC9N<WcZ2$(L%&<TAUXy$(M5z(B")
(qdv "ci4"	"$(I(d+E,64T>wWF$(J:s@iG|LRS<U6$(K)&5MCODQHtdMm2$(L%#,%5C;W<p@}DEFrLhNAX5$(M(42p(B")
(qdv "cong1"	"$(I"%%H(~,[5r<|D<FNG_HsI%N.N5N6UCViZu[H[m$(J&j'~:lC8IaL]M6N5PcTIW_XVYI]}ajft$(K"%'q7S7r888B;PB#EcVFXeeX$(L7<D6HJILI~KKOrViWT$(M)\*@4Z63;Q>(E<IP]((B")
(qdv "cong2"	"$(I!K0qNpN}Q8^<_S$(J"C1CQ?j'$(Kj?lumLm`p=wx$(L'W.>EP$(M$ZKHKIXr[T\s(B")
(qdv "cong3"	"$(JG-$(Kd^$(M(X;d;e(B")
(qdv "cong4"	"$(KHGSX$(M(~3P3QbX(B")
(qd  "cou1"	"$(K2>(B")
(qdv "cou4"	"$(I4N$(K$UP$P<XF_Hh'o&oH$(M$_(B")
(qdv "cu1"	"$(IEiP,$(J.D$(K/!cP{]|I$(Me0fB(B")
(qdv "cu2"	"$(I?)?Z$(J+S$(L2#@uQD]zbY$(M)n(B")
(qdv "cu3"	"$(KIBN8(B")
(qdv "cu4"	"$(IF/IaIuUyY3_P$(J$7,n-_.y4P6{G]LYQlXd^+c$g7kzl&$(K![3G<c>KB;EWG7RWVVYQ]8c0ofy5$(L3@B[Xtbyc%$(M!(&l/%:DBVI$K-M#M$[+\0aQ(B")
(qd  "cuan1"	"$(McS(B")
(qdv "cuan2"	"$(IZN$(Ka_|L$(M?Ddp(B")
(qd  "cuan3"	"$(JP8(B")
(qdv "cuan4"	"$(IRxUq$(J[a_gmb$(K[r]&{{$(M$n9%9|GmUda8b:f?(B")
(qdv "cui1"	"$(IFMLONc$(J8eH(K-WP]kh4$(KEhN4N9XY]9e,$(M,T(B")
(qdv "cui2"	"$(I\M$(K,4(B")
(qdv "cui3"	"$(IO\$(JJhPGP~QU`[$(KQ4R:(B")
(qdv "cui4"	"$(I"s&"3C3N=/Q=W(XeXz$(J*J0k6B8??8G,IEIHP`[<fe$(K)#LuMuPTTNVj]%b5c'cScrdPfGiolBub$(L(H.!=r$(M!=;\;`C\S.(B")
(qdv "cun1"	"$(I'9az$(JI)JW$(K#*$(L%[(B")
(qdv "cun2"	"$(J+W$(L$DXp$(M^a(B")
(qdv "cun3"	"$(J"v$(L"@$(M0i(B")
(qdv "cuo1"	"$(K3,@BAGAQgm$(M?hYO(B")
(qdv "cuo2"	"$(I6O8`=RDB$(J<|RkWh]rhI$(KFGH?J`ef$(LFzac$(M'm-I<q>Y?HPfZz[@^9(B")
(qdv "cuo3"	"$(J9XK+eM$(L7B$(M+\G|O$TAai(B")
(qdv "cuo4"	"$(I8R?M^$$(J,tJNk^$(K)B-\0e8o]Bu%xw|1$(LFNFjR}W\[+[8].$(M#A%|4Dd?(B")
(qdv "da1"	"$(J6DE2a~$(KNff<$(MKe(B")
(qdv "da2"	"$(I7K:!>xB3$(J+83G7Z8S@%\.$(K8KW-a#cde*e<i*isqO$(L1,2hAIY5$(M)m6k(B")
(qd  "da3"	"$(KNq(B")
(qdv "da4"	"$(I!n@i$(J+4f6$(K"J1=$(L"=(B")
(qdv "dai1"	"$(I(bT\$(K]j(B")
(qdv "dai3"	"$(J!uMNMS$(L#w(B")
(qdv "dai4"	"$(I#W*}.s=0LLN,XQ]N`)$(J;[I5L0OUYVY[]x$(K"C'3+8.h667(=&>zGSYHd?z\$(L$|*H7*<`BqEJKGUk$(M#*<\<_?qG-P{Q7e,(B")
(qdv "dan1"	"$(I%U'c(s*b9?9m:[JUP@RF$(J,5>2ILS]`gd^$(K#x&D>*`=i=j.qo$(L!d+x5f:y<DCKE&ECEjO>$(M"D0+AvK$UI(B")
(qd  "dan2"	"$(J2\(B")
(qdv "dan3"	"$(I.!.fX=$(J#Q&\ANW]`S$(K"(GJTAUQV4]thp$(L:W$(M6iAA`[b8(B")
(qdv "dan4"	"$(I)35c5t;D>=@OJ`QJVvW4^~$(J")&:P(VC[xgB$(K!j"`._/AD'VT["[`\g\p]1`lb?oWtj$(L!x"~$j%e;@<3M_Z"Z#^K$(M$b+v-s:lABOXQ-Ux\J(B")
(qdv "dang1"	"$(I#Q$(JX.[l[oa'$(KUU]uc!i"n#r#xYxf$(L$K$n'!B-(B")
(qdv "dang3"	"$(I,n]0`7`M$(J5liJlw$(KaWx"|.$(M(s)x(B")
(qdv "dang4"	"$(I#?E;EGMDO#^W$(JI=IrL/LcP5$(K%U/@TQd.dJd_e>z1$(L>#Zf^=`E$(M$=."/;/A6y(B")
(qdv "dao1"	"$(I#u40$(J!*$(L!9(B")
(qdv "dao3"	"$(IFYFZF[G/JETWVo$(J9Z`/$(KSy$(M!i#67\8M9F;VFYIpL-O@T%\I`.c](B")
(qdv "dao4"	"$(I+D7QHRN_Rd\j$(J4@:6OqU7\7d#gQ$(K*+1;=+@_a/b/ku$(L52=\?8?<HqQzY4`Yc<c]$(M"X)O)Q,Z2><XAkFeGMHqX_Xa(B")
(qdv "de2"	"$(I0x3y;M;TFc$(JM|$(K'R(^9V@^E=Un$(L/L<9HcHhHoRTT)$(M-j4LFx(B")
(qdv "dei1"	"$(K_1$(MBC(B")
(qd  "dei4"	"$(IO-(B")
(qdv "deng1"	"$(I$&K9Uj$(JBBPoRv[pa/kE$(K\5dViVnct~$(L6G9r$(M%_)(/+0:CBUb\t(B")
(qdv "deng3"	"$(I3`$(K\B$(L!j!u4:(B")
(qdv "deng4"	"$(IEmO[W{$(JikjqmH$(K-T?iTaU!_5rutKxv$(M[d(B")
(qdv "di1"	"$(I,{2g?7$(J"-/*0R@'AwJcPW$(K%`&E/Y4];O=_KCL6L>T0om$(L&o:p:qE/GwL~O2Q|$(M!P!W@:(B")
(qdv "di2"	"$(I(i(t*I0%JTY+\h$(J!Z']0tJnLzOSY9`F$(KEdIKaGbLftygys$(LOUPq^i$(M"(.A@CA5B1JTPi(B")
(qdv "di3"	"$(I%7)7.y4q5}Ov$(J%)'5)_+P.b4Y5s8*N,]R$(K,SQI$(L#o$f$k&F'F'Q'o*:+j,o/R1X2^2e3C;HCvDbDiDlEHEIK0McNdNhNrX;dT$(MC&(B")
(qdv "di4"	"$(I#c%A'$074=9J9NCuE2F2F~JzL!PZZL$(J#f%u&O5c;P<)H@J-L^W']`eSk(mY$(K!8!U'E'n(`,D.L.g0*0X8(8q<S=zLym:u<{z$(L"/&?*[+"-F;FAKE2E6EXXuYdZ($(M!,&p0U?3?4A9I?ICMNNZR2RgRz^((B")
(qdv "dian1"	"$(I@}@~_C$(J4BY$^7b0eBf.hfjt$(K!1kdoiuyz]|E$(LR/X/_0$(MM>Ry(B")
(qdv "dian3"	"$(I(/-h8/;t$(K+,$(L.iCH(B")
(qdv "dian4"	"$(I=6Q(]@^8$(J#?-r8=>]BuIJOr[j`OhP$(K152w44@yA>B]LgM%\]]nc2cU$(L0>5'@xJMSgS|[3\)cyc|$(M$J5;7WA3M!a{boc`(B")
(qdv "diao1"	"$(I*%/g4|T#T.Z+$(J!@.W4[B`FR$(K"#080=HCI7PBec$(L;{<q?^ZXb4$(M,9V}(B")
(qdv "diao3"	"$(J'V$(K!(!i"YET]0$(L"w:D(B")
(qdv "diao4"	"$(I3{8^NGS5_n$(J(%?=?WQM$(K/W:C]._b$(L"}#"4aD7OoPu$(M#;\X_B(B")
(qdv "die2"	"$(I,V7S8D;N?4@KBrYTZAZB^l$(J(9-j0N1n8&>LG}HDOzXBXb]q]tkemWnY$(K(+(t,=-%/31w3J6+<5CtHSJDN2P!U}[n]>dRospbv3y*{e{j{k$(L0v9V9X:(=o>)@LA(H*K*KOT.VxWmXEYw\<^+_Eah$(M!X']'{(n(p)E)H+R,d0&:{;/CkGPI{JjJkLPPjRmSQSxd_(B")
(qd  "die3"	"$(JCW(B")
(qd  "die4"	"$(I3D(B")
(qdv "ding1"	"$(I";"K"`$(J$j$(K'_$(L!5?F(B")
(qdv "ding3"	"$(ITz$(JOV$(L:,F<IaIbS5^;d-$(M8AZ-Z.(B")
(qdv "ding4"	"$(I"L&{Ua$(J?#$(K'N.1O1c1k.$(L%%%H(B")
(qdv "diu1"	"$(I!E"c#1$(K2K(B")
(qdv "dong1"	"$(I(:-%-&/C5$5e7y<NH|QH[u$(J&QUP^~$(K2W<G@U@YD%Q=YGYz^XfHmR$(L($@UApN2$(M,F<,LnR`(B")
(qdv "dong3"	"$(I4Z5~Ni$(JL*P|X*\=$(K/4oRt)$(MG*W6(B")
(qdv "dong4"	"$(I#('W,B@>Bv$(J)+3O8nBRb!$(KC4PlRVc`fZp\uS$(L"C$(MQI(B")
(qdv "dou1"	"$(I$p7N9v$(J;;CaJ@Yo$(K(F(RJ<U{ZB]Dd`nVr=$(LKwLyb:cA$(M){P^(B")
(qdv "dou3"	"$(I':9+$(JJ.SG$(K#p-u0<SH$(L"##3,,at$(M;J(B")
(qdv "dou4"	"$(I6f=`CSJuYJYr]b$(J,;,m9f<$=bBcG<T@X<Zxm7$(K.[0l0r4@I|YUj1j2j9v"$(L'}+w3)4U<4Yp[|b^c_$(M646=8n><C*V__)_>(B")
(qdv "du1"	"$(J^<$(K$s'[,.:0A)PL]5dt$(L-b3~L'(B")
(qdv "du2"	"$(I-sBnTBTDW^ZZ_d_v`O$(J.?:e>QH}S-Vma)a^eFk3$(K2_4&QSUOalebh4h|ldmGr(tGxq{-$(L(T-S;k>qJCK2$(M'`90I#NQO,PNSiX.YJ]$ab(B")
(qdv "du3"	"$(IAVBhI@Nd$(J"^6j9L;<?!G2Nxa*iA$(K:`@PO2$(L?4N|X&bZ$(M-23faf(B")
(qdv "du4"	"$(I#`(A9x@"H^RbZn__$(J'D1K4g=WGdOTVRcji=$(K,v/<?}B3O3\(\zc6jz$(L(;26>kWt$(M%YB[H;Omcq(B")
(qdv "duan1"	"$(I;)V_$(JM>bCc}$(KX:d!$(LLT$(MP!P"(B")
(qdv "duan3"	"$(J-7V7$(L:2$(MSAX$(B")
(qdv "duan4"	"$(I6:B$BWBk$(J7i^FgP$(K,,6?=<eQjrtP$(L5M5NIcIdS4]NcR$(M$$DhMxaT(B")
(qdv "dui1"	"$(I+q/q5^@\MIR6$(J,_<y@j]Z^Zdx$(K"$(i.a>N>\@bGARGZ6$(L2>6;?(?)?HBaR6$(M(|;~>`dh(B")
(qdv "dui3"	"$(I9a$(J1q?TFD$(K%9Z:$(M1bT.(B")
(qdv "dui4"	"$(I">"x$Q%\0-C^]GbD$(J"JEUO\T^TsV*[@bGi[l\l^$(K#<(-+eAWLqP;[<b&cnpApKqs$(M-91c78=2D\KUQ1Q3W7[P]G]I^e_o_}dgdi(B")
(qdv "dun1"	"$(I5bALKKL9U_$(J&@>^Q-RrW*$(KLodQqiq}$(L8%$(M7&;3FjG%W\(B")
(qdv "dun3"	"$(K5wtC$(MYI(B")
(qdv "dun4"	"$(I9ZL%R~$(J&`($.t0/EK$(K-i;j@@AOFIToawcuf0$(L$e%/.(5p$(M!1)q=IJ{L(PJUN(B")
(qdv "duo1"	"$(I;+$(J"R+\$(K+H1";k$(L$:$;$lGTa_$(MK%(B")
(qdv "duo2"	"$(I64;u=GK/$(J)97OSe`q$(K)31[QtXn][m{o6tcte$(L$u/t1_;aF]Q`Sb$(M""(B")
(qdv "duo3"	"$(I#x+p,pBcDsL)$(J"{%K(g(|2k6nEWE\GxLPU8\EaP$(K)E2X;/;C<3>RA7MFR`Y:_Y$(L$~,-.H4sA4C&$(M!q+-1`:]L?T2du(B")
(qdv "duo4"	"$(I'^-b-eEXTI$(J&L.)3h9sA]I>M<YD]Mdhk=$(K(r.<3]4d@1B{G@RLRr[P$(LCpL]RkTQXm$(M!k*}L[`K(B")
(qdv "e1"	"$(I(=(@(B53$(J/P40Ey$(K0CIy$(L>i(B")
(qdv "e2"	"$(I0c?`DKIdMJOiV*VqW3Y|Z!Z"[6$(J9YO3Tna($(K4*5S5sBkX]Y_`>n=p!$(L/FH:R7[Z$(M*dJeS"(B")
(qdv "e3"	"$(I0S11$(J(mJ5$(M4r?GKY(B")
(qdv "e4"	"$(I"N)8+Q4B5o:=:>;2<ZAcBdD#D~EqL*O>RXVO]s`GaU$(J!N%b(3(X(`+}0T0e5L6MBDEPISO0SYU#_[_zbee[i9$(K!q%I(;(>)b,b/82h4b=7@XCpDAL,NMO?P\QzR^RzW6_rh2juoEt<u\vkvuw.$(L"N#'$](Z,v5}6<:mDDHgI>LwM7N>NbR.$(M!n"K(5,P4P=B@vDfETFBFaK6LIR,WSYDZ+Z0]&]d]x^L`e(B")
(qdv "en1"	"$(I,XGnI2$(J<b(B")
(qdv "en3"	"$(IMR$(K#y(B")
(qd  "en4"	"$(IJY(B")
(qdv "er2"	"$(I$S+V>mSuVp^g$(J+'/93T53E~PbaZ$(K4gE8R2W5k%s!$(L)S-Y-Z.-b9cq$(M''66:VR"(B")
(qdv "er3"	"$(I"?/2;F>'P4$(J!s$(KIbOrkbu'$(L4D4e$(M$|?|Go(B")
(qdv "er4"	"$(I"I,"91DVE&$(J/?4AB7IVNh$(K!:.9;w$(L8nRJ(B")
(qdv "fa1"	"$(IQ+$(J%]*v.n60A>\y$(KiN$(LBrKhRqRr(B")
(qdv "fa2"	"$(I+k1c$(J/J:S$(K/*f}$(L"7#.;?CiL3(B")
(qdv "fa3"	"$(I)fJr^:$(J%>Ak$(K'0$(L2=GbTkd1d_$(M+A+XSa(B")
(qd  "fa4"	"$(I-|(B")
(qdv "fan1"	"$(I7G^|$(J)WI.fkgs$(K<;c}p:$(L'G$(M?TA?SU(B")
(qdv "fan2"	"$(I!/!o#]#i.h3W<2C]KyU|X{[f\[$(J41I`J{Lh["]ad0d]guiCmI$(K#-DJTZUB\bcQi5latvxHy_$(L!1(O,A-Q-uSW\}c!$(M+55=5>BHI}J8JgOdPKPLQ*Q8V-V1XtY\_S(B")
(qdv "fan3"	"$(I"o$(J*<5b$(K#a5]O|$(L#2'Z(B")
(qdv "fan4"	"$(I2Y7PK_VY\7^9$(J!y$0'K*I/|;c;dUq[;\KjK$(K%t'14X5@6l:1P_i2p?wv$(L$C,S,{-@4\9{<.B@OlW5$(M/H3kD'K*^ScM(B")
(qdv "fang1"	"$(I%y*!3i$(J*iOB$(K/JJ:a&$(L9DdS$(MEa(B")
(qdv "fang2"	"$(I05_,$(KKa$(L+Y/@1d<h$(MLX(B")
(qdv "fang3"	"$(I$J$k&0)A*o6=$(J*RNz$(K*d$(M+m(B")
(qdv "fang4"	"$(I9:$(KX?(B")
(qdv "fei1"	"$(I6p=&@!b&$(J6)?.d{eVil$(K;a$(L#E$B<u>LM%$(M2ILbOzXc(B")
(qdv "fei2"	"$(I<"$(J;uEnTPkQ$(KAS$(L':$(M*$(B")
(qdv "fei3"	"$(IRT$(J)j0}6(RFS'$(KA6F3NyjAr0$(LRi$(Mb^(B")
(qdv "fei4"	"$(IRV[#a&$(J#D(])C*0.P.R6'6*8s;*I~JYPXQRQSTHV}\R\T\|^v^za1fhi!$(K&L5F<D=BBgKQL2S1_ZaHdWlmmSsk$(L,w0|234$CJD_F4HEKgL@NiP5UL_e_fa|$(M0`35A-BXJaVdZ~]<^=a(d:(B")
(qdv "fen1"	"$(I%b%h&$8~JgQcQfSH$(J#w/69~;j;lPpY^b:$(K"Z&m1\5u=2`.{O$(L'@;N<!JjT2T3ZEdCdb$(M=~`:(B")
(qdv "fen2"	"$(I%5%<3p<~E__!$(J'25GJwO:PdQ,U~W)$(K%2'S4eLzM<XR]bc5q\$(L[`aA$(M-D-S.F/B>lIyJ@JpM(PRV'[3a~cC(B")
(qdv "fen3"	"$(IFf$(K2TI6(B")
(qdv "fen4"	"$(Ia2$(J%jPkW%bccI$(K'"*MDrRvUyY-ggp&$(L*OG$[\\R]#_&$(M!o&Z&[-y/l8-8p:4G)S#S^(B")
(qdv "feng1"	"$(I"g#"$[.50P0d748U:I:m=TK+M+S+V<[O\3^*^,`Ea9$(J%E(!,x2~Kvmd$(K5T=:D)PYnbv6zr$(L"m&e&i'+)\/z0MNE\jbLcT$(M#c(z)'5D@IIl(B")
(qdv "feng2"	"$(I2%CjG^U2$(J$5QjXee#$(K:UQrV9(B")
(qdv "feng3"	"$(J;O^=$(KoQ$(L+((B")
(qdv "feng4"	"$(I!Q<fEgP%$(JC2h.$(KU1$(L*25GZ4$(M7#<0?R^4f!(B")
(qdv "fo2"	"$(I!J%=$(K,T{i$(L%j$(MbQeC(B")
(qd  "fo4"	"$(KF8(B")
(qd  "fou1"	"$(K*k(B")
(qdv "fou2"	"$(I/y0`HvN`$(J:,>DTr$(K/^3L>#IrVX]:$(L:k?/C4VQ(B")
(qdv "fou3"	"$(I81?~$(J%J(f7k;sYz$(K.M3n<!$(L#]95$(MF4(B")
(qdv "fou4"	"$(IAe$(J'[$(L]d(B")
(qdv "fu1"	"$(I$x*-*V+L396?6JCqD+ImT:Z&Z'$(J#g$$$-*f*j,>2U4$?gRU[._afwhL$(K,zO0S#S.SESLZWh(i9$(L*5:F@S@hD(E5M)VPVRYy]Bbx$(M)F9E:S?=D&EoI&Y](B")
(qdv "fu2"	"$(I)=-X.%.&.[/B2P9BC\E1N!O^OySz$(J!"#+'q)]-U/#/7/;2a5>8c9);E<hA)A@AqHRLfNSNVT%W$X=XKZ>ZT^D_#_5_B_Mb<en$(K!B%|*5*6*`0)0x4z5'7P8p:?<W>H?CC+D!D"E%FwH5K(K.K3MXP+QCU5VSXXYlZ/\j]v^#`3`LcKd8ewgii[l4t%x&{N|K$(L$%$}'<*=*t+h-v-w0{2G::;J>9A-C(C+C@EBRzT]ThWcZ\^A`Q$(M%'&a)b*e2U;7C`LCMtMuN4N9N:NiNjVgV~`+eB(B")
(qdv "fu3"	"$(I+36)<}=O=eSTW8W>$(J$<$~.8059WEuFuT\\`bp$(K$?$K013HD3D_E4I0k;$(L#m&3'E'w,eELENHLL6OxQ+$(M&0+.0c1Y255?5O5q=iG8I7LmS>W'ZU(B")
(qdv "fu4"	"$(I!C(*//2j5;9^:F:{>~HMJeO!VdYZYl]M$(J#Y&N-"5/6!6N8b;S<RBGE'EaG!G"I6IPIfO.RSRXS*TL[s^i`|a}bMdA$(K#r&";\;b;h@SGVJ4PJSAZ+]2]g`_o?oLqhwSwsze$(L,|.EDNMEP-XWY(Y2[J[m`Z`ka{br$(M!s"n&9(o)9,S074z4{5P;;;^>$>%CHCnDwIkL*LNLRL^ZFZV]Camaz(B")
(qd  "ga4"	"$(L#O(B")
(qdv "gai1"	"$(I,!/41C7FJX$(J-d3N6wFA$(K;sRlXD$(L63QT$(M3X(B")
(qdv "gai3"	"$(I>($(K"f(B")
(qdv "gai4"	"$(I!F"#7RAgD8GdL`Ld$(J$:$(Kxi$(L2K$(M,t<i(B")
(qdv "gan1"	"$(I"T#f(y+#+A.i7}9nTT$(J$>$u%!'>.~3v6$AsSd$(K%pD>J]Zk$(L!T#aAwS[dp$(M$#0*6P@fD"(B")
(qd  "gan2"	"$(I!m(B")
(qdv "gan3"	"$(I*?/'Pp]Y^e$(J8wOR\/]$h8kLl.lJlWmSn5nN$(KMe\Scx$(L+S-83b=h@:@vITP8S/_A$(M&C:xHQIBPddT(B")
(qdv "gan4"	"$(I&S/EOxT/Tv`|$(J"d0+iam?$(K-zFDoe$(L/6A8SASB]a$(M!@+U5M6)>u__(B")
(qdv "gang1"	"$(I*#.#5P6#:"HwR=$(J!R$H*A>d$(K-"-f;d?Q@=O`eS$(L#L%i*s-0.~0J676z:O<E=K?!F$IDJ5QxR4$(M%J&b(B")
(qdv "gang3"	"$(I(.$(LJe$(M$g/9(B")
(qd  "gang4"	"$(I<q(B")
(qdv "gao1"	"$(I3>7M>GI7L_QAXHYe$(J&H6-:`KjcTkK$(Kk_$(L17C;L&Vk`'`T$(M"O#"$c1P2QO2V,(B")
(qdv "gao3"	"$(I"8#F>OMBMZXo$(J%w*MWJ`{$(K%,A&Ba_w$(L*]LH$(MV8(B")
(qdv "gao4"	"$(I%!+M$(J,b$(K#R,u?8Iqa~f$$(L7>EgXGXH(B")
(qdv "ge1"	"$(I&%>JFvI0JHT3VJ$(J'1)7*/.;/Q=-OkQNUS^)l0$(K'b)e7*?^D`NLS;Wrc"$(L&)+++2ErFgM8P,dd$(M#z#{F5Pr`P(B")
(qdv "ge2"	"$(I""$s1=CyG;JSRhYQ$(J$")3,'-/2.:M:q@aKAL"LLP{VnXp`Qb(c{h9$(K.A6z8i:#;@>:?3E{M1Y#`ueuq+q,q;rLrMrZyR$(LPyS(^Z$(M(S5II|NmOjR;TiTj]R(B")
(qdv "ge3"	"$(IR\$(J)L$(K8#RsV`$(L45>!$(M0z0{(B")
(qdv "ge4"	"$(I!,!-$(J"/$(K+d(B")
(qd  "gei3"	"$(L73(B")
(qdv "gen1"	"$(I'[$(L(*8Y@dbz(B")
(qdv "gen3"	"$(JNY$(M+)5S(B")
(qdv "gen4"	"$(I&?$(KCU$(L%f(B")
(qdv "geng1"	"$(I.(.A3E=i>.N1$(J-~5i$(K3Q$(L1MCIRsVC]3$(M.j5"5#EGR%R1TO`oc,(B")
(qdv "geng3"	"$(I0^388O=IN#$(J28@QFZ$(K-V7]EkNkR?d(v*$(LCWG2GHI;O^$(ML8R0[o(B")
(qdv "geng4"	"$(IAi$(J6s$(K&5Gr$(L5ySG$(M>I(B")
(qdv "gong1"	"$(I!\$q&B*3*K+W,2B,I}St[2$(J!a*{+E+V-25pKYO4O@RcZQc-$(K"d+-3bA|HxMjWpYM[3]G$(L!<"A$o$p%|.z7S?l@(C7O=Q5X8ax$(M%MM7(B")
(qdv "gong3"	"$(I'V,UOCONWA$(J"c$\-[3_A,WN$(K#|%@4a<nY3i(j*jNl-t:$(L&:+eL4WvWxaz$(M2w5GB&I-T:e>(B")
(qdv "gong4"	"$(J+#+$9t<T>AF\VK$(K/{>WWArawW$(L%y_Ba1$(MQ9^2(B")
(qdv "gou1"	"$(I&R8K?hEZ[]$(J#A./=pSS^(f+$(K,i.c;)LQ]{hmq#$(L#j47$(M%)&H&d*~1|:(:)DuNkRr(B")
(qdv "gou3"	"$(I-x86=,?+$(J+%=&$(K(_7~;WMfPh$(L'2:jG?MqSZW_\]$(M(R;C(B")
(qdv "gou4"	"$(I()4y?$L-$(J5R;B<F<g<j=EDWK@KVU1$(K@!G/I:O!W!egq%r^$(L*NI<QX\Z^g$(M)28f:R<9B6JHJIL<L=Nl(B")
(qdv "gu1"	"$(I+c.z7{ED$(J%v6d:bRbZDa<$(K'y(a.b1>4[BQBmM0Wgn4$(L/U1I6n8!9w@&C6GxLuNfOkSSVT`s$(M)f2L2T>L_h(B")
(qdv "gu2"	"$(Knm$(Ldsdt$(M+u(B")
(qdv "gu3"	"$(I/z<wH0Yb$(J"2.%2K495&9IC{E_FGQZh:kYmX$(K#7({*p.2BsG*NzT5U$V~Y?^be}i1iKl\ltyl$(L'*,h.,2m3S3l4"6,C2Z%Z+\4d$dz$(M$K%X&7,C2[:3>m@uK]W+[5]3^H``(B")
(qdv "gu4"	"$(I2V5R>QClER_5$(J0=4n?FBPOCTzb\j=$(Ku(wi$(L@2(B")
(qdv "gua1"	"$(I)-3]6`A|OgR{SrYU$(J#B#Z+o5jNG$(K"5%a9b<aGdW>f>yo$(L$./#2p7{8K90:)FDS^Vh$(M!T'w,J/63w5X>1AxEgF~O9TN]Y(B")
(qdv "gua3"	"$(IMa$(K1!CHX9$(L!4(B")
(qdv "gua4"	"$(J%idI$(Ko_$(L^Rd`$(MY:Y;(B")
(qdv "guai1"	"$(IA;$(J0b:_>z?@$(K#C(ldk$(L%`4B5%;YW`(B")
(qdv "guai3"	"$(I-5$(JEk$(K!{A:$(L8O8S(B")
(qdv "guai4"	"$(I,_347^8\$(J!i@@PBh$$(K&:&p/.//2q7>`Rmn$(L$&+K4AB\$(MG0(B")
(qdv "guan1"	"$(ICGD(J=X4Y!Y?$(J0i1JE.dFe^hd$(K28>!>^Ggb{sDwu$(L!i0,?6C%G>\3a3$(M6C;q;rDGTa\&]z]}_,bEc_c~(B")
(qdv "guan3"	"$(I*P?jRJ$(JFpG&N+Yd$(K4u$(LM<$(MV%(B")
(qdv "guan4"	"$(I-OBZLP[E`z$(JDRN2$(K(5,k8EJ_MtNg^5|8$(L3-=CJkL?^F$(M#M)6@;G`T`\"(B")
(qdv "guang1"	"$(I$('D,$DvElT;$(J')'+$(KJ3UCizkcn<y^$(L)N274p7eB(B)Jz$(M/d/m9*(B")
(qd  "guang2"	"$(JU0(B")
(qdv "guang3"	"$(I"H$(Jhwmj$(KlZ$(MGvH!N^(B")
(qdv "guang4"	"$(IZD$(J1[l6$(K)O-KKti%tT$(LMW(B")
(qdv "gui1"	"$(I"J0g2D3K9l<H>o?SK^L}QlRG\^$(J3m:7;qA9CVV.YnZkc.h6i{j$jY$(K/\>xGCJ{T[`pgWv(w7$(L2j<}L+[s[}$(M7K7i7j9;=d=e@.@nBjKq(B")
(qdv "gui3"	"$(I,W,h,r.?24$(J(#(q+X+]8T:1GyNPO'T;ZS$(K'#(M.34"4D7zB6$(L!`%X&|+*,N0*8=9s<mDdIyKtPvXicudgdn$(M$[6<B_c/(B")
(qdv "gui4"	"$(I#EI?RtWIa4$(J!,'g-BKGM9RIS~U{dZgq$(K*K-x=CB(NDT3ZE`Nt(xr$(L$L0m2D4PB>XY$(M)7<)A+JFJf\y]>]Da](B")
(qdv "gun1"	"$(I;<IY$(L?;(B")
(qdv "gun3"	"$(I!!3tB>I>T!VDY"$(J?;JfNr[I$(K9YHiW8$(LNe\|^#b,$(M!}>3aFcr(B")
(qdv "gun4"	"$(IF9FyH3Y($(J8">0e|$(K=mEEmaqE(B")
(qdv "guo1"	"$(I9c?eWc$(JB$^4$(K]R`@pv{.$(LPRX}ZNdc$(M0V6-F\K(]ib-(B")
(qdv "guo2"	"$(I%)'{'|("+eb9$(J1}?9Y|[`cJ$(K*i3\:JIcNKSiU`bIe0meqIt?$(L&V+QCZIeQF$(M#'C'QdUgVT(B")
(qdv "guo3"	"$(I<;>YHiSe]'$(J'Iby$(K,#w!$(M4-NzOoSKX{Zx(B")
(qdv "guo4"	"$(I&O'1>A$(Ja#h_$(K5YT<r$$(LOO$(M[<(B")
(qd  "ha1"	"$(JT1(B")
(qd  "ha2"	"$(LNM(B")
(qd  "ha4"	"$(J=%(B")
(qdv "hai1"	"$(I2T$(J$J%-)t$(K$N..(B")
(qdv "hai2"	"$(IDr_+$(JU=Y0$(K>2J0^q^s$(L&w0:(B")
(qdv "hai3"	"$(J*%2f\!$(KFJ$(L:#L\$(M**0C4X9TbWev(B")
(qdv "hai4"	"$(I_x$(J):)N3s:2eX$(K"q#b0V3j4F?5I3jkns$(L!.#r&,'8/W0'97(B")
(qdv "han1"	"$(I-c0eSh$(J,^2]5I;:;@Gt$(K$G3%J*YTvN$(L1yT[_2_3d#$(M9H>v(B")
(qdv "han2"	"$(I$K'Z-[0'0E0w4\5F6BCUCoH[S4$(J*;*>+k9&CtRpZcb.m9$(K"72N6[:MHYImN\d>ttu^$(L/461=EHFMCOZT;$(M"4#t$A2s3*:$D9D_FURdS-(B")
(qdv "han3"	"$(I*M.\1o$(J!fOhVG[J$(K3"E|[,h~mrzv$(L3i$(M'i[_(B")
(qdv "han4"	"$(I0/1y29638W;i=LDIL{UD$(J"`"i"j#4#W$o,=,X1o294S4U9<?*D:DMG@GTHSIcQCW{XX`+d9eGlrmTm^$(K!*.F0H216h7Y=D=iCsEHFzJ?U\W}[5]L_Cfao,q"rWtl$(L"G"Z8F@TA0D,J;Q3]p`jaDarbN$(M"6+6/`5(7U8r>2@MC0DyK}LZLk(B")
(qdv "hang1"	"$(JF?$(K&V(B")
(qdv "hang2"	"$(I7VP(Vn$(J)A/o:P;p$(K/a3kK`Zhkfs]$(Lbw$(M+iBtT{(B")
(qdv "hang3"	"$(I4{$(J'?$(KC~(B")
(qdv "hang4"	"$(J5Y$(K!Y'&1^H<f/$(L>:E9(B")
(qdv "hao1"	"$(I++$(JXJ$(K32G1[;\)nw$(L1S7}8Qa`$(MB4J9J:(B")
(qdv "hao2"	"$(I</BbGzKDLBM0P3TVTc[7$(J<;JJZ6]^$(K%H's1C=tKFQP$(L6^$(M(v)L*U6.E@FpP,(B")
(qdv "hao3"	"$(I(I0s$(L$E$m$(M]H(B")
(qdv "hao4"	"$(I".%:%W(63^6E6I8}E?G9QvUWZT$(J&1,\4O5m61?|@CJg$(K#i'('t75K?K_UZX}[f\-d=mftzwg$(L9-^@$(M%`8t(B")
(qdv "he1"	"$(I)&->H-$(JOsb=$(K!%,X/9RYi'xJ{%$(M3DI,VE(B")
(qdv "he2"	"$(I'y---u.2.q4-4^;V>\>}?XA/DYDe$(J!~'#'W,&003l:8A'CsGGKXOOVTXqYN^Kawc]gmlg$(K%P*v,W3D4l=}BBB~C`DoFeOLU0VsiJj|oay8y:$(L**.w2V3,:^>"A%E#E%F|O`XS[;[EcC$(M$P%e+T1\4);+=,=/@(AqF!F$IzJCKXM4P<U9W@Z$(B")
(qd  "he3"	"$(KK:(B")
(qdv "he4"	"$(I"!/H7,8lC0LmX.^]`'b)$(J3iG6M5O1_\a>c'e@fZiTl<$(K"2-m6w?qWM\6]xemgRgshOjUv}{_$(L.1N#NCdY$(M!7(8+q,E2x9!BuM.P2el(B")
(qdv "hei1"	"$(I9k$(JPf$(KM2$(M6l(B")
(qdv "hen2"	"$(J/D99J8$(M5@(B")
(qdv "hen3"	"$(IDU$(J@I$(K7R$(L7KbJ(B")
(qdv "hen4"	"$(L157`(B")
(qdv "heng1"	"$(I,]0t$(J=.$(K3'B,$(L5/(B")
(qdv "heng2"	"$(IHFY^]<$(JA+U2ZV]Gg~$(KI@\.cy$(L&7/9>E?zG[]f$(MUKV?(B")
(qdv "heng4"	"$(IL1$(J_y(B")
(qdv "hong1"	"$(I#5,i`^$(J5d5eERE`N_RVWymf$(K8T;BD;OgRTYb_&gOlKwq{V$(L*9/SDyJwM+$(M&})Z0Z5V;9;:E$MdX*Z,`&btc&d)(B")
(qdv "hong2"	"$(I(J,*/A/|0b7\8)9F>!@#@%@|CbCrD3ESGbJ|$(J%\*c*r*w+B/45H6#;~J[KUb1$(K#.&6(|)<+b0,0K1WRwbHp@$(L(:4J8qL/MeVaZ'apc($(M(-/EXH^+f'f>(B")
(qdv "hong3"	"$(I1E1N$(Jmr$(K-q3veIqu$(Ld7(B")
(qdv "hong4"	"$(I7+J>$(J,#<MFh$(K/'4B4C>lAqB^NbVYYf$(M9{EEHB(B")
(qd  "hou1"	"$(Kw0(B")
(qdv "hou2"	"$(I.6:AH;Ms$(J#U)@=gEJM/M@^Mel$(K7V7p7|8V?n?zC!H#XZ_\f8o0oA$(L#|&>=6?7H1KCSk^x_>_Q$(M&R&~'$+43U3VE+(B")
(qdv "hou3"	"$(I&g$(K*3,<J-$(LNI(B")
(qdv "hou4"	"$(I+b?*$(J1Y6[@}A5HMSlS}ZI$(K3}C<xb$(L.@/>1n5q<X=3F{$(M3I7V(B")
(qdv "hu1"	"$(I)j,j.n4g;U?EF4K6QET8$(J&c'()>+x.62d5K80:a;2;yCLE}OMZ!^|$(K"H&[*(1z359!:5=@CXIOJUN?ZM\"fe$(L"1$W$Z&O&R&W'h*;*C-o0E2}385a@eD@D~ItJ<NuQnTWZ6[C^6$(M#(-b-c/35_8wE%LzScWkfU(B")
(qdv "hu2"	"$(I1A2H4w7|83:.>)NKO]Q*SXV\$(J$N.$0A0n3y=NDUE!FTG:G\HIKzM;MMR<W+W2W[Y4Z^[n\O\rh5j:$(K'-2H4Y5c6y7t8'A]B9BEJ2MbNYP^R*S,TnTtW,WOXb_B`,aqe{m<mUn1plsouYv;wPy"$(L'q-#/n6A9N9m:"?SEkEoQWZ9[k^1$(M#u(P+_+f+|+}4\;I=8>c@#D3E|FqROVfW5^E`O(B")
(qdv "hu3"	"$(I$i>R>a$(J2gFs$(KIZJa$(LEf$(M,%(B")
(qdv "hu4"	"$(I!e!fG!P'WX$(J$#&U'u(h)6*z.p.x5@C'CXDZDfF:QLWTi\$(K!m!u#v$Q$[+;.)/]0?1e5pHWNGZe\_]*^6^ikRmku=yA{*|D$(L"n#\$A$w*a,(,),5-z-|/o3.:[:g?|C5DjE3G_T$$(M)y-(9>D$\?^.(B")
(qdv "hua1"	"$(I#86n$(K%iIHj/n>p{$(L)'$(M;xQ'\U(B")
(qdv "hua2"	"$(I$nKxMHNUUc$(J-DUZ[Y]8$(KIwNeZ5[-^p$(L*-J1P\$(M"M;*K8TX_V(B")
(qd  "hua3"	"$(Jb[(B")
(qdv "hua4"	"$(I*757IjRjXh].$(J#]&R(z.m/!>kB(R&$(K,Q:_HRHrK#Kb[@$(L-47hCPPjdm$(M!+#o,_.=8PB*P/YB(B")
(qd  "huai1"	"$(IXI(B")
(qdv "huai2"	"$(IPk$(Jf`$(Kg^gdlT{2$(LNV$(MW)Y.(B")
(qdv "huai4"	"$(IPI$(JcM$(K9h^^h0s}xL$(LQV(B")
(qdv "huan1"	"$(I#y/)LgUFYyaLaM$(JOFV!kfnA$(K;&?gsIv,$(M*#9.EfP~QfUnY3eR(B")
(qdv "huan2"	"$(I%l*/*s>&>P@-$(J'F(b(w7#7$OwS4TKWw\m`)`Zc^c`$(K"M0DExKjKmZw`opytmxp$(L6H8z9'9G@aBkU,XNY:bWb]$(M%@'x-g2O:O?6HpJ~K7T@]2(B")
(qdv "huan3"	"$(I/s;*["$(J,R=h>b$(K,OBbOhXN[|^jpkzm$(L9/K}$(MHda4(B")
(qdv "huan4"	"$(I!]*g6\:3;QAOASUG$(J'E'L-u3PJ=MvZ0$(K6/>6B!G9GeH.L<SPr"$(L!I(20q3y8"BoK~$(M*N-m-o0$089a>0?fG"YTY[[J_|(B")
(qdv "huang1"	"$(I#[6F$(J"f)!+U-+3M=)$(K#{$%$V053[3w;+@IBp`d$(L$[$\$_&H0\0`0c0g103{71;O;uKuK|RlTP]&]\$(M%k165y6"6%Qk(B")
(qdv "huang2"	"$(IBjH,HSKO]}^T`f$(J#v.BL7T&T5VzW!$(K=$QoUKXkcNcondrsuOyG$(L3E9u;6>7B;CeKDMY$(M1~D=JvOqRVRWStV&Z>_?`Z(B")
(qdv "huang3"	"$(I1LD`Z^^%$(JKC$(K(m-{FETh$(L]RbE(B")
(qdv "huang4"	"$(IA'A9XW$(JPP$(KID$(MQ/(B")
(qdv "hui1"	"$(I$)+T2,5/:YX&$(J(t/X0%8v8z>N@VC5E/J'J0LM[0e\gt$(K.U>`?"C$G$J$TDZD`hg<gI{:$(L%2(?<RE"IFS"S8Ty\O$(M!c)`4~6d9$Gh_"d<d~(B")
(qdv "hui2"	"$(I%+(j,L0n9L>bDH$(JU*ZEaz$(K"x0`E@`k$(L*B+.c?$(M(7(B")
(qdv "hui3"	"$(I'.B&BV$(J)J/F2t8U8aV9X8XA]?_=`^$(KT)TIT_ehlL$(L084N?s$(M,s-*3M5a9mNHSwa/a0(B")
(qdv "hui4"	"$(I"D#),^0{4H<X>5BDDXD_EpLAOXP;S\WZZ@ZM\2^s^va^$(J&}(R(c(j0c9*>%D3E&ELGAGvH{IDPmSqT]\n^Ja@dKdcf}gkgyk2la$(K%(1c7o8u>G>}?2CeEtF%SqTH_'_/e=j!mmpFw9$(L!%(3-p8B9$G0H[I{Wn\^\q\r`Vbe$(M#7%h-p0|2q:T>gB/FrMf[!\hd!e.(B")
(qdv "hun1"	"$(I,}:t;^>9B#$(J+c0s$(K1p9+9H]E$(L#+${8@>NSE$(M?x(B")
(qdv "hun2"	"$(I%}:EHe$(J0E6r:K>@T4_;b)b?bx$(K[N`Dax$(LU/Y#(B")
(qdv "hun3"	"$(ICBI$]o$(JC}MO$(KBqo[$(LU^(B")
(qdv "hun4"	"$(I+(<tA0$(JM[gg$(K,l?vI!IEX^Y)clzB$(LRQ$(M6taJ(B")
(qd  "huo1"	"$(IP6(B")
(qdv "huo2"	"$(I7kC<$(J3bA=NN$(K%.(q;TN(^W$(L.cLE$(M$M(B")
(qdv "huo3"	"$(I$*'4FG$(L0uE_E`$(M!{(B")
(qdv "huo4"	"$(I&&+]4P8_APAuF'REX?Z_\o^>aKa[ad$(J+l0;1F=f>\B"GMI,IgIzNHO{Q]TtV6[?[U^5a\c\d,dpf4f5l?lum:m~$(K#V458Y<%>;?9C.F;H`JOLtMLNu[D\KbOd5e:hDswyx$(L%,'k3H4V?1??BJBSL<R0TZUb\~]x$(M84GZJ;S&VqZ9_pbRdXeKf-(B")
(qdv "ji1"	"$(I(>,<4%:n;z<)=y>DDnEhGBNkO"O/OlV=VRW![a[b[c\q]2_6`F`naJ$(J"9"Y$P$c019v<'<K?[B5C|L~ONS>U%Xs\)\q_7`*aMff$(K&N)L*n1Z2-475}6TCqFKFTI9T,TKW7WdX$]o_$cJd\e(ilu?v]w%$(L"l$5$g&]'&3_4c5b6>6L8J:P=;=w?0F!F(F;G4J&J0LXY`[<bj$(M)N)k0k1t295o5r5sA/B7B`J'KjKkM1MjO(QH_Aa<apbS(B")
(qdv "ji2"	"$(I!2"U(}+K-?/76]73:@<j>LA,KJL5MPM`TiU$Vf_za%b/$(J"@&V&|(;(s.C0`0a626c<x@(@qB4DcD}E?I0ODQ7R2S)ScShXmZ,[7\+\2^>a.gJgpnW$(K$>$},3,j0.1u3m3p6W7i7}8H8L;Q>$?U@HB>G`H,I1JHN.OdPsQ~RaS7SpVxWz[i\%]Z^l_JaEb\bxeNe~k(o>qTtIvrwVxD$(L!6!a"?$($)*#*f,?/=/q3\5e6m9=:J=!?%A^B6C{I?KAK^MpMyN,Tw\m];]`^Xc.$(M"]%v&E';(U(c,c000y1o4*?1@dAsAtCXEZH(I(JbP*PSRBUAVsYN]`^n_/c4eJ(B")
(qdv "ji3"	"$(I"A"V"_$,&n6*;e?bP>$(J"M12`mgIiz$(K!Z!x$4'Q'i*70k7f7wD+WPZlc*fWipkDm7u#ul$(L#=&L(X(Y)^+%/QI_$(M!U2E2|4JR+R>cN(B")
(qdv "ji4"	"$(I!@!A#%%3+i.V/a5w6@6K6q6v='=4@?CcEcFEF^HKI/IVP!RzWxX,$(J"3#`%"&m*E*m1B4a:H?j@DD5E6FrGoIOMnO8aed7eHe_g9gWj`jglC$(K!>$<'O+\,I,V,r-Q-g-y0^5R6R6`;#;M=">%?sAFB[BeBxKiM-N'O\OaP1StWSX1X3X>XA[9^&_t`9a-f+h>k&lklrmImPoFs8wOwwx`yr$(L!M#`%*%k(0+C,J0%222<3P585R:@>2AACfCxDaJnLBTKU{Z{^)`<c{$(M$7$R%['e-1/y1N3L4N5L:M:|<B=*=LBBD%D1MeN'N~O#T5TDZ[Z``4a`d,(B")
(qdv "jia1"	"$(I)2*pC|E5MgXi$(J'9._.`5!:);-A0mn$(K+7/;4Z6~@DVG$(L*gCTF`GmGnGpT&T'$(M6G6\;'Rn(B")
(qdv "jia2"	"$(I%0):0(7T;dA^$(J%G(T*!9\GJRRTa]!`0$(K&>-=/52.@sKLLjP?WH]"dXyk$(L@#Z<dH$(M&z+<5J>#Kw(B")
(qdv "jia3"	"$(I$j+O1B$(J#:.[5.$(K+Q<[?{@7xe$(L5{;CO,a!$(M+a04(B")
(qdv "jia4"	"$(I'KGG$(J7B$(K.X4{?4bl$(L%n.ZMb$(M'N+E(B")
(qdv "jian1"	"$(I*2,.4<>-BPB^C+DdE:G'H4J3MiN?RWUwW0X)]d^^^c_s$(J%@&T4'5N6E7>8h@HC`NlP]Z([4[F_u`:c:ewjDjxli$(K-^809X=?C)CWMgO_Sx]|edh<ktm^nLq7ua$(L&f+T+X0?2b4-498E?oHBHpSqXP[#^bb%c3$(M#@$\$i)")),'.1/Y/b0m2*3S=Y>\CDH[M6ODQ{T#[B[D[G\:]._*b0b1b}b~(B")
(qdv "jian3"	"$(I/U4O7a<D=jCgFuF|HDXJXOY&\O]%]=]F_7$(J!d*o=0EHJ$KrO^PCR5RHS+U_\sc7e;g,l'$(K)}EaKyL}VDc-c.cHg@gJkoseuqvDvdwlwoyzzA{R$(L)L+V>>JEPiQ*$(M!K'!,6.x1V4|;vApP+P-WyX^\W^h_P_T_abBbaed(B")
(qdv "jian4"	"$(I'L/F6M9_>HK2L|O&P7UHVcWjXX[1[A]_a"$(J1T3}7J=,=d>RG$IRT)W@`Ma[bqd'd5g[hOjkkUl1$(K!p0><0NmW?_Mb9j-l~mDo5oTqXslv~xczE$(L54AiDWNXZi_@`(`nb\d@$(M"F$e)8,K/1;K=-=.AHHhJ7NvNwOMU\Xn^!_]aYeH(B")
(qdv "jiang1"	"$(I2NB{D5G#PHZt\y$(J&W'-0#5:9lVg[te>j#lN$(K+C3~<{K|]aiAqgsj$(L%51J<,K(TtVUaQb!$(MHbL%\Q(B")
(qdv "jiang3"	"$(I@aFHFbGVL\V%$(JWY$(KSzUDjd$(LK9K;b1$(M&/IxT6T7Y/(B")
(qdv "jiang4"	"$(I"&#D0YG)NLR9$(J"l7-<<$(K)74=9LC8[u`g$(LEsG|Lo$(M$~*/.e/k4_?!(B")
(qdv "jiao1"	"$(I#L4#IhV3WM\Z][$(J!j%X*\/Z8g9z:(B+DTNTO6PrZW[W\af,i+$(K#j$k6(7LE)V)_Kb%n@$(L/K3:8M8s@cA3D.ZWdr$(M+p+w2C8{:y?.VkW#^-^5c8dMdNeb(B")
(qdv "jiao3"	"$(I&C1I2(8GB:IyL7UO\6\@^k$(J$s7=:y<:CoIdKFa4amcY$(K"}$E)9)f0"3s8b9p=f@rC-INLvQsT>WoX|\G_yi#ikm?tQ$(L..34AoGUJ~L#R~Vo[%$(M!;$+,M,N,O/&/c0D;o@TB}H/S]T0(B")
(qdv "jiao4"	"$(I$t/,3!669HAKKC_M$(J#l>"DCITNQPhdWhz$(K-s3Z><H1V>gSiyj8k|l+sP$(L"B"["\+g+k6+@8G6G7LJ[NbS$(M!h:-<NK0(B")
(qdv "jie1"	"$(I6-:L:\>>>BBIHOPv$(J2Y;g@$ENEvK)V:XnXtYK^S$(K;8@}GG^toDwtx4$(LH5JQJSKz`9bO$(M$1$3'2,!.:=?@7E!Y>Y@^6(B")
(qdv "jie2"	"$(I!*$]']+v4F;nA=AAD2EyGJNDNg]$]&a1$(J!+!1!3">(i3Y9$9A;V=v?l@REZItP:T#U(Vd\8\b_va&b$$(K"0"A#X#^$@'>*t+&,d-20/2=6=6b73>cA%IIM`PWWbWnX[b~lvo7q6tpvozY{6$(L"T"o#f&J+s.M2A556y:XC>DuI5JTJVPTTXWg_od]$(M!>$0&4'\*9.3.c0G4f8i?%B>C,H&NLTqU%Zp]_b[(B")
(qdv "jie3"	"$(I(?DTEW$(K!'#&,EKwaMdr$(L*_$(M'S3m@/(B")
(qdv "jie4"	"$(I%i(U.*:NAtBuJxQ#RlT(Z{$(J!:"G#d#p$(1W3?E,EcHjO5SNnF$(K#8#w&l&~6$KPKZmZz$$(L"y$?'L)%1?7.KNN9P'_Yda$(M(6(Q+j+s3A@kJ-P#TT(B")
(qd  "jin0"	"$(K+0(B")
(qdv "jin1"	"$(I/(HrISMhT<$(J/\O2P9W;YE`ce~$(K"_%O:PPa\E\}mwnC$(L<bJ]MdU+`>$(M'J'M(J(Z3&H6Q"(B")
(qdv "jin2"	"$(Kf)w/(B")
(qdv "jin3"	"$(I!I'f3eG[P]Ux$(J,eJqM"R([Dac$(K-d@ZLnO:XCZgazbwza$(L*~MBN{QQS2[fcM$(M!u$B'a'c'd2?2B7@@0@bQX(B")
(qdv "jin4"	"$(I#T)n1H2.3V4h6{@IDhFLG6H"H2K.LfP|TwU*$(J"B"t-&-5/N3L>>C\Q"Wx];c+ibnE$(K"?&}.v2C8w9:=o=r>n?NL(LcV?]qpB$(L#t)z,<8^;D@GJpW,[~$(M2i3l7l:tG5MyORQ<U(XZ_R_j(B")
(qdv "jing1"	"$(I%B+%,u.w8+>@>WD'HfK#V)$(J#a3#DLF3OHTj]"bu$(K!P$_2;H_NoOQZ\^%_ufbfpg'o*ymz%$(L*}+!1b2P42;[>]IjK"LkVOdw$(M*]5&:m>yL_OtQJRJXk^:(B")
(qdv "jing3"	"$(I)d.GJV]1$(J(B$(K(6*NdCl3$(L&ZE}$(M+((B")
(qdv "jing4"	"$(I%L(u-U596R;H=p@:ATIeI{JLNATlU7ZR_U$(J#^%C,$."6&V]Yu[T[\`Xn<$(K#)$y((12O>`Gsn$(L=L?`G&IWS,WO$(M)K.I0t?nC+C:PU(B")
(qdv "jiong1"	"$(I!'!x+r9MH<SlW5$(J)fAO$(K-9-Z?pgF$(L+'$(MM)(B")
(qdv "jiong3"	"$(I+-+<4'70ChGiWy]#$(JJB$(K#;A`DEPPv2$(L&[R=SX$(M$t+==g(B")
(qd  "jiong4"	"$(JPu(B")
(qdv "jiu1"	"$(I'"48EeUf$(J!'!{#.#/$a(J+M/e3DFVTBfE$(K!4!;!<!g"|$d%1%5/Q0jPM$(L!$!&"z#0%P(f(g-R-~./3f@!D0G/J[MvN*RNRtZZa2$(M.b4xJqQ}d$(B")
(qdv "jiu3"	"$(I!0#K*137EO$(J"X'n0:$(K+}6E6a9qD.$(L!?%0%1(K(_.3EqEt(B")
(qdv "jiu4"	"$(I"Q#O#^-2/I1b:V@JF`FaWG\4$(J!e#&7M818K9}<%@sE[G;IyMaZGbsh`$(K+M0$3l8{?d@aDjLlPmQeZ-_7`[iMo}$(L*"+4+f-N.4/1/24Z<(FoGvJOKdLKPtV*W%Zg[/]Ucw$(M"<&:&W'E-64@6#9};6J|NgP|^*^pdC(B")
(qdv "ju1"	"$(I!{&7(O(R+45)?>C@T7$(J'$)k*}.O/@1-162i85?/F#MmT9V>VE]>_lbmf@$(K/:5161;F;ZAAAbK>L%QOTypG$(L3n>yC3MxVLVMW^_Obs$(M#1%>1I1L98:n:o;FBEGzINP_TzXu(B")
(qdv "ju2"	"$(I1l5.5mE$HbNuNwO1[9\=$(J$t%m&{(0,G3)4H8N>h?zFvN*RuYk^l_/_WaLaad8iMivjbkw$(K!\#S%q)x+10|2G4t9?<Y<o>h?'F!HBO+O=P%TlX;Z#`Abqi]k1lnt&$(L#<&=')1E3`J,JRJUP*T/`[aFaYci$(M$6*6*C*_1!1&4M5/<S=@>WF2FSHfNnOJT+T,T_ZN\4^8a^ascUd2d5d6dqe%(B")
(qdv "ju3"	"$(I(m12GQWm$(J().N7j9aEQ`T$(K6k7\<OH$ODT#]+d|v:$(L#D.j1oQ%_I`"$(M4Q\5(B")
(qdv "ju4"	"$(I(x)6*w,z-=/P/Y/d2]4o5vFoG+G,K3SyWVZo_L$(J%F'P;&BhKNMRMXR+\<bTd.eyf&gG$(K'%+k,"/_1{3C4IK'MVR|S@Y~ZT])fkg$hiiImiq&rE$(L!=!n!o!p,j3=7_<><BM5PIUe\9^Qag$(M!9':'n)v-w/x5`6F6^@AR!URW-YfaX(B")
(qdv "juan1"	"$(I,,-T4QWL$(J+<9^Gsmz$(K(u3y5,8WX2Y]^Cf9$(L1O;Z$(M*`BrEpTy_u(B")
(qdv "juan3"	"$(Jl!$(KQXT-$(La;$(MA{Y']V_M(B")
(qdv "juan4"	"$(I'a,D6k;C==DuFh$(J,o-O3J3c:r@uNcTyWg$(K6;6C@~BIDcFbWfZ}\@jWwzy={M$(L!y#W0n165K7@?yBHFpFxHrUV]kcL$(M#f(>)}*3*47'<1CAPH_ya5bP(B")
(qdv "jue1"	"$(J6g$(M.,(B")
(qdv "jue2"	"$(I!$"}#$(n)F*Q,l-y.+.91e68<{=1>3>t?LC}E}F!F"GtH'L?M)QDU=UEXsZ-Z8[=\Xaa$(J!2"}#!$V*W+q0H0f546a6z7W9g>&?f@]B0CrEwG+JlM.MhMqP;\*\z]E]H_Ya2cFdkimjGk&k4lv$(K!0!M!y"m#9#}$1$w&G)T)`,+/X5|899.939P9U:L<)<]?PDiI%PpQ3R8UM\T\Zc]ifn8v)w`xGy3zLzyzz{m|#|(|/$(L%U*y+}.b.r1v2i3|6C=B?d?}DcF~GCR#X3XL[O_ubndq$(M"["\$w)B,R-C./.41e7$9o=UCjE\J!OVQ&V`X5Z!ZDZJ]B_!_c`}(B")
(qd  "jue3"	"$(K!,(B")
(qdv "jue4"	"$(IP+$(J7,$(KA$Le$(L2"(B")
(qdv "jun1"	"$(I%O&P,%H.J4J9P-\)$(JG5_:i)$(K&A2Z^kfJm($(L&g*U*\-T/*/O/V/X5[6bOyQg$(MEl(B")
(qdv "jun3"	"$(J0p:@B-$(K8&@zkT$(L6$(B")
(qdv "jun4"	"$(I9t<K=SH]K-PeU:V/WSZ;_K$(J5F<o<}JeSufB$(K0f2'={B0GHLPZneYrX$(L'%,f=j@RA~D<[>\?\@a?aKc>$(M"Q:!P?(B")
(qd  "ka1"	"$(K"l(B")
(qd  "ka3"	"$(K+~(B")
(qdv "ka4"	"$(J)pSn$(Kx~$(LVr$(ML7(B")
(qdv "kai1"	"$(I+|J.$(J!M=_gR$(K.?85;3NCOK$(LYZ_-cX$(M4u=1(B")
(qdv "kai3"	"$(I$7ME$(JI&KQL;$(K/FGm[E$(L%MJ.[_$(M(&L:(B")
(qdv "kai4"	"$(I)r)yF6Zb$(J2uCN$(K>fT&bNhC$(LJu$(M%S-|]Q(B")
(qdv "kan1"	"$(I1[2L$(J&S86ll$(K@nA~CT$(L@$$(MRp(B")
(qd  "kan2"	"$(KEC(B")
(qdv "kan3"	"$(I'N4GVZ$(J!z1hN-S7_1ic$(K9IBSC'K<N%`/$(L,/?'$(M#}*^Co(B")
(qdv "kan4"	"$(I7X$(J?AG#ltnH$(K%v,Y-MQ/TkoI$(L'(4O[Wb$$(M%r(HBqK?SP_Nec(B")
(qdv "kang1"	"$(I30FTLWR*Y5$(J5`BtJLQ@R$XN$(KCIJEJYJxU~V.e2$(LQ&V>V?`1$(M"1/0(B")
(qdv "kang3"	"$(I%z$(J5aOG$(KDsEITB$(LEi$(M+~(B")
(qdv "kang4"	"$(I.7$(K:]@3ZbZce#$(L";)22C(B")
(qdv "kao1"	"$(JNsNy$(L''6p(B")
(qdv "kao3"	"$(IGCX-$(J!&&t399nD.bJ$(L%F8L$(M.pOL(B")
(qdv "kao4"	"$(ICpYu$(JF8NM^V$(K(pB\i}(B")
(qdv "ke1"	"$(I.d2UD-MbMzOu$(J'/H|f'$(KP~`4tg$(L,q>tIIK&Y-_X_h$(M(ARR(B")
(qdv "ke2"	"$(I6e$(J2@$(LJ']}$(M)s(B")
(qdv "ke3"	"$(I([-Z7$XB$(J)^)bPzY3j6$(K)IR+$(LPY$(M#b(B")
(qdv "ke4"	"$(I+G+h0J0X::;fA+H>I($(J%Q3q6Q>vD4K2KqM7SQSVY?ax$(K(n)*6q7H9iA@E~F0F2U|Z{[!j~vx$(L"D)a*m.Q0@245s7Z7l="=V=xJiJlNOPn_1$(M7+;]]o(B")
(qd  "ken1"	"$(JNU(B")
(qdv "ken3"	"$(I$6+m0z$(J'jMk$(K1hYCbz$(L-`;'GPbX$(M),7|Rj(B")
(qd  "ken4"	"$(LL0(B")
(qdv "keng1"	"$(I%KC3F{S#VW$(J"?&l,V-;1&9U]~$(K*q.04)GuQWQ]V#b2d#$(L*E68OB$(M<I(B")
(qdv "kong1"	"$(I+}4i?H$(J1D8I:T?IhX$(K8vIWIhk?$(M87@'(B")
(qdv "kong3"	"$(I0}$(J)FF_$(K*CS+$(L'\7R?k\p(B")
(qdv "kong4"	"$(J8l$(KHP$(LK+(B")
(qdv "kou1"	"$(I@@$(J$z$(K&!$(L4%<'DU\M$(MK1K2(B")
(qdv "kou3"	"$(J!./{$(K%:$(L(R)o(B")
(qdv "kou4"	"$(I+:,v/Z0UB%$(J219e9hRN$(K#,B2EnV,[ww-|"$(L'g>YGtHnV#$(M$-DQZje'(B")
(qdv "ku1"	"$(I&z-@/8?D@.$(J!c$@&_+02%OyP#Pv\B`;eq$(K"n&/+|/k;H>LLHR)R{]Vb1$(L.C2U8_Ed_L_q$(MA&W1(B")
(qdv "ku3"	"$(J3wL$$(K7K$(L.#Z!(B")
(qdv "ku4"	"$(I2t>/>p$(J2r9`RyT>$(K;zQbXu$(L<?$(MTY(B")
(qdv "kua1"	"$(IDp$(J%y0!bH$(K40$(L$=&nX>X{(B")
(qdv "kua3"	"$(I+^$(J)"$(KEQ$(L!0$(M*v(B")
(qdv "kua4"	"$(K!/)2$(LO9Xqb|$(M<@(B")
(qdv "kuai1"	"$(I/k:_$(J!l$(KLR_T(B")
(qdv "kuai3"	"$(IACPo$(L;\N+(B")
(qdv "kuai4"	"$(I%8:M$(J!`#_%N(G(W072-L%k5$(K1.?Vi!nu$(L+H,W/+9)=R$(M!p?2HWP[(B")
(qdv "kuan1"	"$(I@v$(Jf9(B")
(qdv "kuan3"	"$(I6bA}RN$(JIGJZk;$(KA-M$M;$(L@lJ:]s$(MI4(B")
(qd  "kuan4"	"$(Jdf(B")
(qdv "kuang1"	"$(I/5$(J(P/U3]$(K)J;tCACPJmZ'Z9n&$(L2cH~Xh$(M+%(B")
(qdv "kuang2"	"$(J#[5E95$(K.Jfu$(L7V7a9LAl$(M*Z<#EU(B")
(qdv "kuang3"	"$(J_>$(LFWRW(B")
(qdv "kuang4"	"$(I!Z$A$Y2^`T$(J&/)i+h/>AGUeZ~_`kNmm$(K+5/P2xtJ$(L*xB]XVXX$(M.YG;(B")
(qdv "kui1"	"$(J8ddr$(K*\L`PU],ki{<$(L=IX2$(M2<;&;8BPO^(B")
(qdv "kui2"	"$(I1D:H?wVh`/$(J$*7e?~GbI4U/Yxedkhm!$(K,_8FO7PQX4o%xhy@yM|@$(L-^.N;b=)RwT<a=df$(M.w5W=!=;?9EJJzMrMsTh]](B")
(qdv "kui3"	"$(I,5Dj$(J?VT-ZjZz$(K4%hbmvqp$(L8f$(M!/CcKfLK_b(B")
(qdv "kui4"	"$(IVI\f_l$(J?2KpR\]Id%inirjm$(K1}NsOYc$dDf*iG$(L#/=`G:$(M'/,g8v<*B8CLG+GfN!O7O8OfR'Xdc(c+(B")
(qdv "kun1"	"$(I4v5+5Q@2IJJqM;O@\&$(J!b+i@xW7$(K"U+`YikQm&y/$(L6J=<ExF\$(M'f?uTbU)ZX^r`ud|e2(B")
(qd  "kun2"	"$(I>f(B")
(qdv "kun3"	"$(I=fSB$(J&k2$;}N!$(L/\Z0[R[jb{$(M!!!F:CMM(B")
(qdv "kun4"	"$(K->BZ(B")
(qdv "kuo4"	"$(I)/,oF-J<S?U9V{$(J36Uk$(K1xCKEKV2$(L6VA}]2$(M4w>|DEKb[fb6cWf8(B")
(qdv "la1"	"$(IR!$(J&85+$(K8rMpN6YI$(M:UWZ(B")
(qd  "la2"	"$(I;h(B")
(qdv "la4"	"$(I7A=U=[>UD)J"V$Z:[*\T\_]g]w$(J7C>YL6M(Sg[(`ecvf|g6g]lh$(K078!@0G_OO[zf4l[prszz[$(L`f$(M)d@sTKeq(B")
(qdv "lai2"	"$(I/O5'=9?O$(J$F3-5}>g?LMjb~e{$(K?rHTHhUS$(L/&$(M)@2@d8(B")
(qdv "lai3"	"$(I%JC,$(KC2Jghx$(MFAbn(B")
(qdv "lai4"	"$(IS[ZSZp\G$(J>tMHYpZvfcg3k$n.$(Ka6bUg]t8tN$(M(^)35Z;i<7<EF9Ff^~(B")
(qdv "lan2"	"$(I4[K5P1T[X0\l^V`<`qapa}$(J"aV,`Hasc9cRg$lAm]$(K+l8?>~QFaPasiqksn3n[qMscv>ynz}$(LHI$(M.M:z^c(B")
(qdv "lan3"	"$(I5&RfThU<WkZ3\9^0`s$(J+jDDca$(KA<lMn!vZwj$(LH|\y],]4$(M&TFQG(]Mbhc$(B")
(qdv "lan4"	"$(I^=aC$(J>#V"gXh{$(Kl0lFqC$(LH]$(M$S/OLoSOXX^YbF(B")
(qdv "lang2"	"$(I0\4)6c=lD6I|$(J(I,B,k9Q@-FcJH_0$(K2o3_GYRdeDfj$(LU.cD$(M%A(B")
(qdv "lang3"	"$(I6HQ&$(J262>PT$(K@uBc$(LI}(B")
(qdv "lang4"	"$(J:*^{$(KF(FrJ+(B")
(qdv "lao1"	"$(K[7vl(B")
(qdv "lao2"	"$(I$b$c.I0!;lUb`d$(J,Q.gBOGLK^NBP7Q'Xwa;$(K'|-e:XM\UXf~j)j6$(L&k(=,E6K7]$(M9w>~J<S8(B")
(qdv "lao3"	"$(I,e=z$(JZPZqd3kR$(K3i6L$(L(t.P$(M>OD{I8JAOHOIT\ay(B")
(qdv "lao4"	"$(IKuXb_{$(JS/$(KiTp/z'$(MTI(B")
(qd  "le1"	"$(IF1(B")
(qd  "le3"	"$(J;K(B")
(qdv "le4"	"$(I!X"M"O$/$8A{SY$(J(H,33FHFJ~ck$(K)?k]nU$(M'6/zJiL9(B")
(qdv "lei2"	"$(I3\QN`Y$(JH4J&JrL\P_Vv\ea"iPk)knmxnD$(K[ZbZeAg\l]m%q5y.yfzl$(Lc}$(M,;/pAODaIeNGO0\E]1^[^ka#a%a&bCf)f*fQ(B")
(qdv "lei3"	"$(I+j-KRP\1`C$(J"H35INWXZ{[Vf:fAhihjj[$(K(LC}G;i&sMwX$(LXF\FaW$(M(y?I?O@\C5F^J/MVNIN]T?]8^^^_`Sc7dbeTe[fEfF(B")
(qdv "lei4"	"$(I'E)g.T/:1}@<Of$(J2TTCUoZ-[6[ScwfjhT$(K3+3zCJUag}ljs4$(L-[<_A+B_SDZ1$(M$*7!7eKnSub=(B")
(qdv "leng2"	"$(JY}$(K0RQ@\~fV$(L>w(B")
(qd  "leng4"	"$(J^e(B")
(qd  "li1"	"$(M"|(B")
(qdv "li2"	"$(I#&/h5q6^8!9S;W<E=$B'B+C%CaDJHcNIORS>V6WWZIZ]\+^M`3`A`v`y$(J0g7^8M8P<B@.A4BMCEFmFxJVOQQgQtQxRJTVZ:]\_+_._ba_b}jBk+k{m2$(K#?8@@RA8BXEXG&IfJXMIMiN0QnW_Zz\t]/]6];]Oe%g5lbn~r.r4s5s>t#u4wCxzyD$(L3R8kGhHPQbWaYx^($(M#H$8&6*%*50g6f:H=G@XBaD)GsHAHuLWLwLxPnRtU[VNVOW:ZAZhZo[)[*[O\Y`!`]a=bUbdc2c=d;eNf0(B")
(qdv "li3"	"$(I$3){,A=KDN[,$(J,`0@2D5gE5jJ$(K0aArSaU*[]`J`Qbsbthjp}zq|7$(L"3<[AVWu$(M).@x\)`A`Ea:(B")
(qdv "li4"	"$(I![")$h'm/i1(1S2'2>3b547h8]9q9z@MAzE)EFEdG2G7GSI1I4M>Q5Q]SISvU)UQWbZ<ZEZV[)\V\`]]^?^C^P_@$(J'&(E)$)&);)=+N+e,]3E4"6A8288:V:v:}<@?UBFOJQfTvU>UlU|VoY>]B_VaNb5cUdyeQf%f[fsf{hri,iOiyk#kqmZn=nS$(K!e!w#D$S+K,$.:3P3d3r5C6e8]9k:~<->mByC_E*H|M'N/NxOPP`RbSMSeTMT`UPVtW9Zy\+\3^x_%_|a5a7a9dNe@gYg`gth5hviUj#l5l=lRlSn)pRp[pjq~s:sQsss{s~t"t.t9v4v?vRvVw(wTwexBy+yOy[ybz8zNzO{\{x|3$(L!:#>,\-J.y1F3T595o6`;h;|=^MONUO\PSP~RGRMRRS_SzXJZ[[$]jaNd>$(M!'!6!<"$#R%/%p,f-G-~.i/C/r0N3(3)3R6u9/999j<K?P@>@^@aAiAzDMDNDeFuH.KNKyM}N-NKNTNUP`R#RwSoT(W,WhWiXGX`YGYbZL[s\p])_g_kb<bicQcnd0d@dHet(B")
(qd  "lian1"	"$(Kuf(B")
(qdv "lian2"	"$(I;R@3F#FrGgK1K4KTKqN7N8QUQ~RCR[U@ZF\P^n`>$(J556x=#BxIeK?KcX'XQ\0^WccjM$(K=eH)IoW+[[]3a}eehHhwn"uPw>x<x|z?{;|;$(L'DM2$(M%4'--Q-R-k8$8%A.D!FhJ=JxMWMXTMf1(B")
(qdv "lian3"	"$(IZJ$(JK#[m`h$(K6ZuIyC$(M",(B")
(qdv "lian4"	"$(I0y:Z:i<JBgS;T~\R]f^\b5$(J=YDqdPgj$(K7M@6PRU+Ugd{p,r+y7|,$(LL5$(M3o8gSd(B")
(qdv "liang2"	"$(I/_CXN{$(J8pGiY{Z1$(Ke!$(L$0+~1pAhGqJgLGLbPcTsV4$(M5]<O=r=s(B")
(qdv "liang3"	"$(I"a$?$UIIO)W?$(J(=+u1x:>:\$(K!692f[$(MEQ(B")
(qdv "liang4"	"$(I/t$(J7}9??0BCN?$(L50EuHwIkKZOnS:S;$(M=V(B")
(qdv "liao2"	"$(I(fKHKiM"U4Y2[3]J_%$(JC"Q8[!]ie8fg$(K.u=KDnLsVP\w]Tczigl?m>u$$(L!KVbVcVg\8\B$(M!-"a$W-'-E/>/u5^7`7a:<@YHKH\U_V@VAZCZc(B")
(qdv "liao3"	"$(J"p'oPKXf[_$(K"u$n'f]Cj+lgqc$(M*"FV(B")
(qdv "liao4"	"$(I-g3384;$\U$(JN1`"gx$(KU"]Ju+z!$(L:UAST^^N$(M9"9sSg(B")
(qdv "lie1"	"$(IKl$(K2r$(L@E(B")
(qd  "lie2"	"$(KOw(B")
(qdv "lie4"	"$(I1w=ABYCsZP_e$(J%P)Q-R2C2z:wBzDsGeU-Zt_scqhQhaiLk9l4m1$(K"T#!(X**.R/V49:vCVZ4[$`BaBaJadb)bJbPd/h#i?j7mVmgn}t@t[tuumwrx2xIzS$(L'#)G-\.n5F7T7bAEB#FnJrLFNZOVU}U~VpYCasb*ch$(M#E(9.</K2F5B>HGRN`PGR4RXRZU/WD\kacc*dv(B")
(qdv "lin2"	"$(I2i5>5G;|OZW#Z$\Q$(J&i8#B<C(DSJuPNaGk?m@$(KHNJvLIs<z($(LAvU-Zb`H$(M)i,&/s1J1z4<7b94<e=5>]?o@K@`B%CwEjG~H0ONUJZ^`-and-e(e=(B")
(qdv "lin3"	"$(IK0L.QVX2$(J%41zQ&d6g{$(K:aC0d"qw$(L5=?>_p$(M>{G&]K]N(B")
(qdv "lin4"	"$(I+`,a1">"GsXr_V`Kb"$(J"IGURt\?_|a-d!ix$(K#Y(zF|LdUE`:gNgZ{G$(L&N6"6&7c=q$(M>ZOOU@\1(B")
(qd  "ling1"	"$(IPs(B")
(qdv "ling2"	"$(I&b(_-n2{3&8'82???B?tC*C8HYNSO`QGSQTnU"UAVuZq`}a8axb1b<bBbC$(J#@&=+t.:/,1V1`5'6%8:8D;eASCUI!NvN~UGWVfChFjjjojwk7l2lPmlmsmtn)n+n4n7nOnPnX$(K)n.d/C6\<A>OBUDHDSDuDxHJK-KHLDP'S*Y{Z[b}c4gHlGpIr!t]t^t_uAx3yTz.zHzfzhz~{B{K{l{~|B$(L2T9Y<lDtQG]^cz$(M)*,-4O9+=3>b@oA'C"DXF.G1GtHPI0N@NAPbQ0T<UsU|X=X@XFXJYy\<\>\L\P_m`V`xaWb,cXcYcxd.d/dGdPe#e8e:e;e]ewex(B")
(qdv "ling3"	"$(I*|8rXq$(Kl{(B")
(qdv "ling4"	"$(J1wI$$(K@[NIQqj"vX(B")
(qdv "liu1"	"$(ILw$(MSV(B")
(qdv "liu2"	"$(I#'&\*67H=DG{H%M2OtQkQpR`USW6W7W\Yw]C_y$(J#7$Q-p24:%:n>UFKKiXv[3\Sa6fll:$(K3W:G;'=j?EVhVwW'`wdcgGgph*h-hqo1rAsNxmzV$(L(a(b,Y28LxQ'TB^2$(M"9%w&A*;1$2o4=4>5v80N,QqRbS9VKVp^/`'aa(B")
(qdv "liu3"	"$(I),6[Q2$(JHXRQ$(K#F<m$(L3o:lD#J%c*$(M:KAaV=(B")
(qdv "liu4"	"$(I*5-`MM]c$(J,/K`Km\3^d$(K?-GBH0O)Vz_@aehR$(L*+LN$(M"_;|Q](B")
(qd  "lo4"	"$(J`@(B")
(qdv "long2"	"$(I#U+x3'B=KfLxR4ROZ9\H\S]L^D_\`+ar$(J:~IlW?_Nc,fVfdgcj9m-$(K#0PXR>\kc8ejhGkhl(l.odt!u{vUvWwQxKz/{Y|?$(L<oF*N5Yh_4$(M-OAyB\F[H,N#NhO-Ro[A[Cc#d9(B")
(qdv "long3"	"$(IZ.^H`L$(Kgqm+(B")
(qdv "long4"	"$(I'w+*0:181p=]`J$(J(Z,lfW$(K-R:fBf$(L6}Od(B")
(qdv "lou2"	"$(I+?,(4EAjO;R%Y6]T$(J<7C1M1]Qh)i}$(KJy]Kdim@$(L6%6O=y>J>M$(M"&"'?CKMTLUHd+(B")
(qdv "lou3"	"$(IQmR+$(K-?V1[1uK(B")
(qdv "lou4"	"$(J15Q=$(K"8E9JWMqP7dge&$(L&5<k?@^8(B")
(qdv "lu2"	"$(I%n)uO}\N\]^Bat$(J)l4xFoZn`%cLfTfYminC$(K56d1g?k}vTwE{y|&$(L?UE@EEKF$(M((FmI%QMSpSr^|_zd3(B")
(qdv "lu3"	"$(IFBL[U%X*^U$(J#M@OC_HqP,]V`}k8$(K8z=xEwg,phx[$(L,:<zRERF]@aS$(M-}6D?Q(B")
(qdv "lu4"	"$(I'C(q+R,?/]/l5#516}<!@A@ELJN9NfO%Q9Q}S:V~[}_"a7aF$(J!p0q:A?XBfCFEtF*F5FwMJN"N(P*Q3QAQ^ROVIWnX1`NaqdbnG$(K/I438|@g@mA*F1G]IUIlJZMBMrN]P:Q&QGUvV7Z$\|]m_#_{b`c[d+dxe)h+ivk5kUwG$(L0L1$9b=G?+@4F=M*PmUjUlX:XnYX[-[u^5cN$(M$)'3)Y,#-F/G2:5':G:[:\;1=K@%@iB0BLC]P>Q!Q;R[YQZR`Lbzc;c^(B")
(qdv "lu:2"	"$(I)[J)JlQtZW\B$(J[']d_X_q`xf\$(KN3aTb@pdq0$(LB3\D^ndQ$(M$4@4B<\nfD(B")
(qdv "lu:3"	"$(I#;'M0B105DNb$(J-T/W4N93R.RgZlg+$(K)r-@-XB8X%Z,jEt*$(L,;/`/x81H%IGLC]b$(M"@4!6~:,??T&e&(B")
(qdv "lu:4"	"$(I%^HkLi`Q$(JL1Lllk$(K7)8t;6ATB)EqP]S(V<[&`Kg~lfpfpsrDt;$(LN@$(M:0:1QgS[TCf;(B")
(qdv "lu:e4"	"$(I7I@8DZL6OQ$(J3`6e7rSFX]ak$(KIR]?^0`bu7$(M;E;G;N[}\b(B")
(qdv "luan2"	"$(I,/131ZB?J7Xd_A_D`6a|$(Jmy$(KiRsBuwv<z;zg{g{n$(M$y%^WpX,[F\G\H\O^}dQdRdZ(B")
(qdv "luan3"	"$(Iab$(L(L7[$(MW`Wa(B")
(qdv "luan4"	"$(I$@41$(J8j$(K.>Tdop$(L.L=iAWAXD3^T$(M:}?lF0N=Rx^Qa"(B")
(qdv "lun2"	"$(I*l505U>C[y$(JFP$(K('@eHFQ1$(LFXZw(B")
(qdv "lun3"	"$(I4tI"$(JF1$(LU?(B")
(qdv "lun4"	"$(KPua?$(M<$(B")
(qdv "luo2"	"$(I?W^a`bb7$(J%LB\Q{VD]&jpkpn$nR$(KcThzr<s6s;sTv=xay<{L{o|'|)$(M(b/{@_O+UiWj[ea2bTbmc{(B")
(qdv "luo3"	"$(I/QO0Wi_J$(J22_phghljAjLmu$(K3FB'D|Kq`7s=uxy#$(L.v`p$(M,m;5H'Ir^g_&a@b@dSdn(B")
(qdv "luo4"	"$(I1zR2Wf$(J%A-I-c3Q>~H0KoZM\;\Fkrl{$(K1O1s;$>&KuRM[#g4sCt>uuvgyKz=zZ$(LQCZc$(M1C1D=FQ=Yv_3_f`5bNcP(B")
(qd  "ma1"	"$(ITS(B")
(qdv "ma2"	"$(IK{NNV5$(JQYao$(KENN[V+[CnYwAxPxx$(LF>a,$(MQN(B")
(qdv "ma3"	"$(KO'rN$(L?ZH^PGRP(B")
(qdv "ma4"	"$(I(a/@@5B_E=FwSp$(J=+EBK5l`$(K9NK+NdRxZG^O$(LQ/(B")
(qd  "mai1"	"$(I[0(B")
(qdv "mai2"	"$(IKY$(JW4[$$(K6<M3qmu6zC$(MA!D`(B")
(qdv "mai3"	"$(JJ_WG$(KLC$(LXa$(MQ((B")
(qdv "mai4"	"$(I$C.c2b$(J#8^8atdL$(K+2Q2Q:Z^l`puuCyy$(M<5<8CPJLY9]%_U_Ybe(B")
(qd  "man1"	"$(J6X(B")
(qdv "man2"	"$(I*a>hG"OzY,$(JB[QXQzWjWkZ<iY$(K1&R}VQ]'^?djeWqAr{|H$(LG9^l$(M"u.94lLDQyV^YlZWZv][`Fem(B")
(qdv "man3"	"$(I5-[C$(J9POud"$(KB_KJYS\{{F$(L^<_~$(M6vDo(B")
(qdv "man4"	"$(IAZNFQKQXXmY-$(JW|$(K;YEFMHT"u~{>$(LCwM}$(M,`,p-U-{/v;)?zC3H]HsU`(B")
(qd  "mang1"	"$(J,U(B")
(qdv "mang2"	"$(I0v1v28=k$(J"L'T-$5{<Y<mFeHuZ9c#$(K'H(c0]:HE<H6JdYg$(L$U'|)$,H489_L1UGUZWe(B")
(qdv "mang3"	"$(IXw[F$(J'X,W4Q4t:hC$X5$(K(#AVMSMwR9fzjFr7$(L'K)"$(M(32&2e9WE`(B")
(qdv "mang4"	"$(J'G:[$(K"D:y(B")
(qd  "mao1"	"$(I=+(B")
(qdv "mao2"	"$(I*"8g8uHL$(J'`>PADH^g5$(K.@5)7l@&^.k!$(L1;2+:/:0D]EyEzOzPJ_[$(M(?;TIb(B")
(qdv "mao3"	"$(I"6&)$(J!-"s&!E>$(K&9/"$(L,g.I;T<t@MCyIm$(M'Z(B")
(qdv "mao4"	"$(I&-&v'U-1.036AQAbMFS^$(J!>*8,i.'0L7f8W=[GgKSO>[%cD$(K!r.I3*8O8x>A?kLwRjo;$(L%z+G1)8l=(>Z?{@tBECnE,E[GAO.T*X_^._(b`bbbhdk$(M!5%j%s'W(V)1-81W:r;(IsOK(B")
(qdv "me0"	"$(I,4K"$(L03$(M03(B")
(qdv "mei2"	"$(I&Y)X*03M7@<V=(AmCVD*GEJ,]z$(J,12G?uKxT<U3XEeg$(K77U6XJeyp($(L,*,U:+:hBOM,SvT(Uc$(M$`$h0#A=N)N*R\T9(B")
(qdv "mei3"	"$(I#z;'K]\*$(J&-GOP!$(K=YkV$(L(<,B6wN)(B")
(qdv "mei4"	"$(I2p?:EbH8[s$(JB&Z_\P$(K';-n>iA=VJYh$(L1"7Ddhdj$(M"%"->?@-(B")
(qdv "men2"	"$(I42W'Y/$(JJT^Hlq$(M0eJQbV(B")
(qdv "men4"	"$(I5uL&Lo$(K5e$(LHk(B")
(qd  "meng1"	"$(Jn-(B")
(qdv "meng2"	"$(I/!/[3%C#N]Q/TJT`TeXfXg_r$(JP<UyV(^'`=`vdCdDf^gZi3m=$(K:4;5;eANIGL\NiY"_9_=_V_]cAd2gohFm!m.m8mCn.nhpPpTpUq=q@uJvIv_w2xRxU$(L-1;XKqKrMjO6W9]!]Zaib"b&$(M"V%H0E0O2D4W;_<l<z>xB2D(GCOZQwU0U7US(B")
(qdv "meng3"	"$(I/mB/$(J?&\,bf$(K9=Ejvm{/$(L/E(B")
(qdv "meng4"	"$(I4x@_T^$(J=$>?]u`yjE$(K[/tWu8yWyp$(LBAHyHzWW$(M$^%gII_q(B")
(qdv "mi2"	"$(I(pD[IgTd\e`~aman$(J)B3,4!45:#@LFXZbc5fpg'g-hGjPj]kPly$(K&,(T:O<6='=sH8HzOvSNY1eEg/hWj[krk~qVrpr}v8w<x?xS$(L,~1w<W>F>G>uMsNaReU)U*U\_J_{cG$(M+]1^4i6W:9D/M%M_Yu[,[M[l^teW(B")
(qdv "mi3"	"$(I'H-E2c>%_B$(J<lOPX&Z@hhiUkgm0$(K.6KoON`ek,z<$(L?VBQ\*\>$(M@HEuF-(B")
(qdv "mi4"	"$(I!()?0V6t7(8w9y>`@bLVQSU/UvWzXPXk$(J.H/h5256?+MpN>STWbY=]e`#h+j-j2$(K9<?K@'PHV$V*]F^/_>dnd~r\u:$(L!r*r39DJHeLPMkNkWkX4X6\#ae$(M'Y(k2YBQHXIcL\L]L~M?NqOvY_^AaDcl(B")
(qdv "mian2"	"$(I!;AqM|P2S-TQWw$(J${LbM_Z}`>crhWiFl9m5$(K-$0(\OaIabkJqDy-$(L,'3mW$`2$(M%o'=(00<2k7Z@*A%H3I_LB]m(B")
(qdv "mian3"	"$(I"Y$R&y4RF}P.P/S.$(J%o)y.{7P=H$(K'`,L.77y$(L'd5X>;><ElLjPrZo]/$(M*uDg(B")
(qdv "mian4"	"$(I+!>vMp$(J#n8VRB_r$(K*b^"e|jJ$(L3Y4z6*Z&Z^$(M4((B")
(qdv "miao2"	"$(IMxQz$(J/kei$(Kk'$(LGo(B")
(qdv "miao3"	"$(J#G>=R>$(K'X(0B?[Xo.wp$(LW3$(M%q9XOaPZR9R=]"(B")
(qdv "miao4"	"$(I(g;@$(J-'E-$(KAUUr$(L6i(B")
(qdv "mie1"	"$(I#70#$(K/$(B")
(qd  "mie3"	"$(I0"(B")
(qdv "mie4"	"$(I9|T,T?ZG^N`R$(J<eR@[2cocxl3$(K+$/T4TB5N_\$hkj\tSzW$(L7i;_HfWRW[a]$(M$<'o'p-WA#B@LhOYOn\;\^]9d}e$(B")
(qdv "min2"	"$(I%e%{(5-z.3.;2k6'8*;0=;BqC5HCHqJQRuVb$(J.=5Q727n;TA"AME*E8$(K)uI]f]kK$(L'~3;>sC1WCYr$(M"P52=DR<R?(B")
(qdv "min3"	"$(I+HAUKt`$`%$(J#=(4;JCPZa\f$(K.wN:Xp\8i<iXu9$(LIwVV\ndy$(M)[HGT8YUef(B")
(qdv "ming2"	"$(I'O5@6G=|MN$(J*YR[b%bl$(K;.Ca^_fNhSs'$(L1k>\IvT|V']{$(MY!Zm(B")
(qdv "ming3"	"$(J-L.h6?<v$(LFH\{(B")
(qdv "ming4"	"$(JRo$(L=8$(M2$(B")
(qd  "miu2"	"$(K*Z(B")
(qd  "mo1"	"$(I,F(B")
(qdv "mo2"	"$(IQ@`ua*$(J<9Cca`e=h0n%$(KE6FjOzaRpqz|$(LR][Q$(M#-,0,{?]?b?eN[QQT$[~\A(B")
(qdv "mo3"	"$(I)%$(J%2V2d|$(K"LS}`xary9$(M]=`"dm(B")
(qdv "mo4"	"$(I,y-S-Y-r.u8.8i<i>i?-KXM#O|Q[Y*$(J%g&G'<,:.A.QAzBqC%HHJPJQQsU)UAU\U`VY\ccnebf]frg0h*h-m3$(K!@%D)d*j3|464J4x5K<X=v>tC7D6E$J!R<RnZY[t]-cZjGnNnTp|uLx(x*y;$(L35@QAyJdKIMgN$NPW{[Ma+c&d4$(M'h2'5T6N9d:^:_;-GGVyZf['d*e}fJ(B")
(qdv "mou2"	"$(INZ[Q$(J5$L@M'YH_$$(K%;&Q/m7x;-Js`VdHoNt5$(L"Q*3.^1+H@NxWqcP$(M1E6>6b;UEqH2RNTl\a(B")
(qdv "mou3"	"$(J@4$(KHZ$(L(+:i(B")
(qdv "mou4"	"$(I2aPL$(J@2S0X:$(K)q4i?0Y,$(MTV(B")
(qd  "mu1"	"$(JS,(B")
(qdv "mu2"	"$(IGy$(J&K)?$(K1deG(B")
(qdv "mu3"	"$(I&r.'.e0O2Q=B$(J(~;=;NUU$(K''Ev$(L2r9jAk$(MC=(B")
(qdv "mu4"	"$(I2S5d?{@nLR_4$(J.|7<9JJ,SsSt$(KBjS0VbZK`U$(L$/,p363>8oGKL(MiWYYq]__n$(M"j"w&5.L4344PQ(B")
(qdv "na2"	"$(IDW$(J/A5(7]h7$(K*)+?4_5X<9^H$(L,a,bI"JqRp$(M:/`?(B")
(qdv "na3"	"$(I4e$(J?w$(K%*/q@,g:$(M>d(B")
(qdv "na4"	"$(I$}'88e8qA?I;Ln$(J(/4h5\>uAaR:c*$(K$9&+&H&d',(@-0.f/64V=NA#BYGWSKk"k#rT$(L)32!6U9ZEaKQL[U3U5_.bR$(M%G)W(B")
(qd  "nai0"	"$(M!O(B")
(qdv "nai2"	"$(IGj$(J3@$(K=R$(LQl(B")
(qdv "nai3"	"$(I&s(G,K$(JF]$(KW0e1$(L"{#G)~7A>%$(MS*(B")
(qdv "nai4"	"$(I>NG=$(J>(@7`ubY$(K7IFCMxNl$(L01P9$(M1QVl(B")
(qdv "nan2"	"$(I)O0N2O$(J(>0Mj*$(K.mJreqyF$(L5;6xJ)X?[{$(M=CDRDTKJYtZk]4]5_{aZdk(B")
(qdv "nan3"	"$(IHyM^Mj$(J/+2:;DTA^9$(K)YJeQ}$(L9x:vVwXcd!$(M"t*p-q=OHl(B")
(qdv "nan4"	"$(Jdv$(K*[-j4qun$(L3*$(MG>[\^b_;(B")
(qd  "nang1"	"$(J"((B")
(qdv "nang2"	"$(Iae$(KG8$(M(LIG`qb7cT(B")
(qd  "nang3"	"$(Jkm(B")
(qdv "nang4"	"$(I`o$(Jln$(K1Py'y(z5zn$(MdUd^e@(B")
(qdv "nao2"	"$(I7]?!XA$(J0J3.G=JxkG$(K!_"Q&=8Z[=v$$(L,X191R3D:7:8DpL2Ro$(MQ$RuWuX;(B")
(qdv "nao3"	"$(I,\1!:j@jHE$(J+s0^8yAJU;$(K%+*@+s30@4GXKMLZX@^`_mjs$(L*`/|1:7f969T;3>SA$B9BbC\U"UsUtVzW#ZL$(M"++Y/P091g3c3d6!6+7Q9M9k(B")
(qdv "nao4"	"$(IE<$(J",$(K#1.=tOu"$(L+#Ss(B")
(qd  "ne2"	"$(KA1(B")
(qdv "ne4"	"$(JF0$(K`($(M1R(B")
(qdv "nei2"	"$(KQx\[kl(B")
(qdv "nei3"	"$(I8B`g$(J8~_*$(KYwk3(B")
(qdv "nei4"	"$(I!H"i$(J1Q$(K#~+.8U95KX$(L$@?~HU(B")
(qdv "nen1"	"$(I^"$(MWl(B")
(qdv "nen3"	"$(Jkcld(B")
(qdv "nen4"	"$(IFSLH$(J''$(LU9U:$(MHy(B")
(qdv "neng2"	"$(I8CB4$(Jg8$(LMQ$(M2((B")
(qdv "neng3"	"$(Ji>$(K>5(B")
(qdv "ni2"	"$(I(V4uH~NzYi$(J"+4z5,:U;+;>G.$(K)^/E<h>JDCfXk7mXx#$(L*D0"0A1*>3>h`yc'$(M)R\FdW(B")
(qdv "ni3"	"$(I"2$H$P)52r@q$(J<iH<Ush}lH$(K<b[A[O`|h^m$q)svvhxQ$(L%q&Q&S2X2d6Y7sY^$(M7^Dm`@(B")
(qdv "ni4"	"$(I$!.a3fWa$(J"_'!(".49D<N=8=kAvCIIhQ`U^X`kT$(K(?/#4n8<HLM^T!YOajfrq]u.z`$(L8:LfR!R`RaRbWzYN[t\o$(M(I,3A~JD\c(B")
(qdv "nian2"	"$(I*C*D2wT%$(JAu$(K+[IJrt$(L)w.K/(5uYF$(M2W2X(B")
(qdv "nian3"	"$(I?=A`[:$(JPR$(K"N(,+=YXb=eKokqerwwB$(LOC$(M<T=cJy(B")
(qdv "nian4"	"$(I4n9bI.$(J#"DOEoF"I:$(K@iMY$(L'`:5$(MM0Nu^\(B")
(qd  "niang2"	"$(IPV(B")
(qdv "niang3"	"$(JnJ$(K`)$(M[%(B")
(qd  "niang4"	"$(Jjc(B")
(qdv "niao3"	"$(IZ2$(JAIPHZg_ff_$(K'P(bgcj=l:pX|A$(LPMP__'cV$(M!4#46(7R83>5?\(B")
(qdv "niao4"	"$(I1~5E$(Kva$(L6o6s@~G~^9(B")
(qdv "nie1"	"$(I5n;s?cS7$(JACT|jI$(K_k$(L0PICa6$(MW|_r(B")
(qdv "nie2"	"$(K2B$(L4C(B")
(qdv "nie4"	"$(I-00):O<B<C>^B8C2PuZ4^Z`1`@$(J%q,%-91@4k8\<X<w=yGKLaN{RiY-\(_,kiklkxn!n?$(K!R!z"\&.(w)D,M/U3^4Q:9:{D?G{H7J/Jj]@`;i4j:sHsWtRv!zT{X$(L9!?*E=G5J+R8R:V3bI$(M,+-0.+:~?EB9F%GBL{OkSLWGX![:\`b&cw(B")
(qdv "nin2"	"$(IMv$(KD}(B")
(qd  "nin3"	"$(Jn2(B")
(qdv "ning2"	"$(I,1@ta,$(J)m1/?R[O`Cgdiek~$(K:nMWT+UAUfhBm*$(L7"Q8Qo\"aB$(M${GnPMYr`Me4(B")
(qdv "ning3"	"$(IQ'$(JRw`9d>$(Kc,cgvj$(MUFV/(B")
(qdv "ning4"	"$(I#{$(JQV]4$(LNj(B")
(qdv "niu2"	"$(I&Q*d$(J6^$(KK^n;(B")
(qdv "niu3"	"$(J%%*_/p<"Fk$(K&`&s*r5~=,A"Zf$(L+v-!N-Z$(B")
(qdv "niu4"	"$(I/&Z,$(K6HOSja$(M>q(B")
(qdv "nong2"	"$(IPcT{X3XE^7$(JQ4X>\%a]gin\$(K;`iFn9r%xgyw$(LY+Y,$(M.[8jHvI.McO?UMX2[U[j[xa'bbcy(B")
(qd  "nong3"	"$(JmB(B")
(qdv "nong4"	"$(J)YV/$(K0_K~$(L#v62(B")
(qdv "nou2"	"$(JiX$(K,A7-:$GUx!$(L>d?GL|$(MAhV(Xj(B")
(qdv "nou3"	"$(J2c<d$(K1i1n1qk4(B")
(qdv "nou4"	"$(IG<]B$(J0rg;$(K2@Ft|F$(M:X(B")
(qdv "nu2"	"$(I!t$(J#9'ZUR$(K4?$(LYv(B")
(qdv "nu3"	"$(K/%5A$(L5t:9\Q(B")
(qdv "nu4"	"$(IA8$(J$1$9Sm$(K<<<?BTX"$(L1/(B")
(qd  "nu:2"	"$(J4.(B")
(qd  "nu:3"	"$(L"M(B")
(qdv "nu:4"	"$(ILp$(J/i5?5ZA[$(K'D)A*eAos#$(L,#.&;5;sP:\u$(M1_O|(B")
(qdv "nu:e4"	"$(I3g9fC1$(L4G8RN<$(M9LJ*(B")
(qdv "nuan3"	"$(IAXBR$(J/8$(K-}$(L,^$(M/MJ](B")
(qd  "nuan4"	"$(JPY(B")
(qdv "nuo2"	"$(I/;$(J1$X)$(K&x&{,g-*7A7B8eI*J9iwpx$(L2\GgIMQ:$(MV<Wg]S(B")
(qdv "nuo3"	"$(I.>`5$(J)#$(K429%M+fv$(L5B$(M"W?yJt(B")
(qdv "nuo4"	"$(I4;;qG%HPR|Zf$(JCgMP\[eo$(K8M>MOZ_U$(L+JDe$(M.!AC(B")
(qdv "o3"	"$(J5)$(LDP(B")
(qdv "ou1"	"$(I)T)Y.$;SN;QyU{^J`N$(JJ/W3Xci($(K=uE:\unZ$(L2'8X(B")
(qdv "ou2"	"$(KOW$(M`d(B")
(qdv "ou3"	"$(IF<$(J-|DtJpL4$(K1LIdL-`s$(M'|(B")
(qdv "ou4"	"$(Jd~$(KOTbAj@nr$(M#^U$(B")
(qdv "pa1"	"$(J#b#i*L5SAYHg$(K$m*Y/`5Q<pPF$(MB.(B")
(qdv "pa2"	"$(ICL$(JJX$(KBrTqa.d@$(L^v$(M[a(B")
(qd  "pa3"	"$(J*u(B")
(qdv "pa4"	"$(L'c1.(B")
(qd  "pai1"	"$(Ky0(B")
(qdv "pai2"	"$(IO4Uk$(J3*Wc[Gba$(K!a$(LK,(B")
(qd  "pai3"	"$(K9-(B")
(qdv "pai4"	"$(I&U>e$(J"&-X:$V_$(K"@&S<MHlOCcb$(L:a$(M&B(B")
(qdv "pan1"	"$(I!s.mUP$(JI[WO$(K.-9^\Y$(L!^$S4?@m$(M?c(B")
(qdv "pan2"	"$(I;kYI\c$(J>VY.j5$(K/,L?NhQT^~lY$(L,k@YXk$(M!V8JBlOr(B")
(qdv "pan3"	"$(I:T$(K<N(B")
(qdv "pan4"	"$(I$Z)v^_b#$(J%tND$(K%c'^7Z$(L,O.+4R4S<#<$Ev$(M);+,(B")
(qdv "pang1"	"$(I)c>?N<$(K6YRX_^g>{w$(LA/B7I]KcT6Vu$(MKPM'[V(B")
(qdv "pang2"	"$(I3L@dA&V8WUYM]Z]`^r$(JDmKaPjY&$(K0O?(C]]kt3$(L&y'z+p85JLO]$(M1+1,(B")
(qdv "pang3"	"$(IVF$(JRn(B")
(qdv "pang4"	"$(I$l)q*O$(J:<$(KD($(LCR(B")
(qdv "pao1"	"$(I&3$(J&zAn$(K+<MDZplAtZ$(L(>S!(B")
(qdv "pao2"	"$(I*&-i?FJP$(J;4Zw$(K%j5BK4_o`np_$(L9<DRd&$(M,[QBU"(B")
(qdv "pao3"	"$(JkH$(KAnF5aS(B")
(qdv "pao4"	"$(I2WJN^E$(J2_;aP^R`_L`B$(K%f.|<iTz`~n/$(M&!4.O<(B")
(qdv "pei1"	"$(I#,%V*X0>$(J/CO-$(K*I4U@QK0$(L5)9I;tEnE~$(M*((B")
(qdv "pei2"	"$(I'<5MIT$(J+JGnHNJ:N6UNb-$(K&i9t:8P3$(L,i<Y>*Y_Ybb_$(M$/5Q6H=l(B")
(qdv "pei3"	"$(JHi$(L1id\$(M60(B")
(qdv "pei4"	"$(I,w.kJb$(J$.)V273z9|>n$(K"X*a$(L(C+L+N83bk$(M7yJsMi[Q[b_8_e(B")
(qdv "pen1"	"$(I:;$(M,e(B")
(qdv "pen2"	"$(I.":5$(J70$(KoB(B")
(qd  "pen3"	"$(KF:(B")
(qdv "pen4"	"$(L9^V)(B")
(qdv "peng1"	"$(I(01+7`[@$(J%O)/-(-A2?47ARH#$(K*-*15&8}Lm$(L2Zc^$(MD.(B")
(qdv "peng2"	"$(I.Q04@VCDF>K8M*SOXx]S^S_'$(J1g<!?e@dCMHEIU]g]|^w_<b>iQmh$(KI\NvQQa%engDi-n%$(LP=$(M9h<J>:BOHNJnJoLeTnYF]!]X_d(B")
(qdv "peng3"	"$(I6lM'$(J6"$(K9O(B")
(qdv "peng4"	"$(J.-aUb_$(K\X$(L*K[c$(MA)(B")
(qdv "pi1"	"$(I(z)()o)s)x*'2y6<87?,?fA<E4K:MLXD$(J#>&[&]*O+p-%..=SG>G{I($(K#G%\&X)p*04->+>8>g?DF7K,Y7ZJ^V_.rhs7$(L&9,F,n3+3QCELAcQ$(MC7D|LSa.(B")
(qdv "pi2"	"$(I*W9.<sPKSo$(J>c@=C~Z/b|$(K&(&2*x5x8s949AFUO@P6SFVv^a`&dA$(L3k8h8j>.>/MGMHU(YiYj[ec#c$$(M%c-.0?7o<-<H>K@tGNO)SG`7aBag(B")
(qdv "pi3"	"$(I-A/-9$TH$(J'c-{7y<zTRYs^}ad$(K#$#%#T#e$h+4;^Uw$(L*6*J*wIXN]$(M(t<o(B")
(qdv "pi4"	"$(I7)C&$(J*#-l6JCdP>VVX(Y,\vdajUlSlV$(K${'!(=G-McO*Oe]`_Qb"bGf-mqw{zd$(L3[9%:HG}P%S+T:cZ$(M!2$Y,V4yKvPyUoa3b?e9(B")
(qdv "pian1"	"$(J0X>OE(SW$(K7e8,82(B")
(qdv "pian2"	"$(I=:>EOpYj$(J6b6~@~Dp$(KBNP[XHmO$(M(DC-Qj(B")
(qd  "pian3"	"$(I8v(B")
(qdv "pian4"	"$(I[o$(J[d$(ML.(B")
(qdv "piao1"	"$(I\z]V$(J2vC?DNV^]Ob4dB$(KSWdzoJ|G$(M!)?VC_M<S7S<SES_^laIaNd&(B")
(qdv "piao2"	"$(IQoUh[S_9$(KJ[[hzK$(M8\S+[q[z^{b;(B")
(qdv "piao3"	"$(J"K/`3+@zM#PFj)$(K)~iYiZ$(L@sVjW]$(M9[?i@|NXN|SCXeXw\%(B")
(qdv "piao4"	"$(I@D$(JJ2X"h2l;$(Kek$(L\0$(M#V.W@SAuMAMBS/`0`8dr(B")
(qdv "pie1"	"$(IL8Y4$(J<8@XHQ$(KF)]N]U$(M+BC%E"(B")
(qd  "pie3"	"$(I!#(B")
(qd  "pie4"	"$(L[z(B")
(qd  "pin1"	"$(I6((B")
(qdv "pin2"	"$(I0RUIXl$(JcQj~$(K%^a2s|t2z9$(L&}6S$(MFPKtUGV4\~eM(B")
(qdv "pin3"	"$(K"F/2GR(B")
(qdv "pin4"	"$(K!H$(L!*,l:}>QX|$(M<G>^(B")
(qdv "ping1"	"$(J,vGBV0Yv$(K/g:wA_Xa`?(B")
(qdv "ping2"	"$(I'Y.^2:2;5C5[808Y8d;=>;BwEzO5Sx$(J%k)}:f>j>lF|O_PtQF_Ek/$(K3e:2ALFqRCa*kalom;$(L"+):*R2o4@;Q=?BpD-J$a7$(M"Z"q&o0-0r0s4+:FH#Lr(B")
(qdv "ping4"	"$(J9G$(K1((B")
(qdv "po1"	"$(IE*E|$(J$66]7c$(K'v*W4L4|5GK9e+$(L*u3%J\Ki$(M!N3|<~(B")
(qdv "po2"	"$(I@o$(J=GBKLj`bcGgz$(KAlp~$(LG^$(M7I(B")
(qdv "po3"	"$(J&3R*$(K%E&o*><Z[?qJ$(M+D(B")
(qdv "po4"	"$(I(k)t*(2m2z85?6$(J$8)X/.5t:3Y]]*dug&$(K$l&t+L1N;R;SL7f,flh}l|q^$(L3&:rA?CDM'OhOj`{$(M1T1s4VGEIQ(B")
(qdv "pou1"	"$(JZ"$(K:^(B")
(qdv "pou2"	"$(I&5S8$(JF-$(KDGW]fA$(L8e(B")
(qdv "pou3"	"$(I/j4c<F=#$(J1l^pbje3$(LFh^d$(M>8MaMb(B")
(qd  "pou4"	"$(MCT(B")
(qdv "pu1"	"$(I!g!h-*43PwTMW1$(J2*V;h?l]$(K,n0gJ=cOq:w$$(L's7wdx$(MFCah(B")
(qdv "pu2"	"$(I$0HVKpR1U'])$(J&+'x.wLqQ0WHWZ\u]9io$(K#c#d,{/yAfV:\D\Ra+qts[si$(L$98m$(M-h8x>pANB$GaGdH?Yk(B")
(qdv "pu3"	"$(I"4G5No$(Kw:$(L*@$(MC4CeU+(B")
(qdv "pu4"	"$(I(2$(J;.$(K%{$(M8EN.SY(B")
(qdv "qi1"	"$(IF=FsJ(Kd_3$(J(k*T-@1*1^8FKIN^P"VFXT[q]T$(K%3&T-.-c-t34376Q@vBoDwE.MAMaP=P@V%a4a;hZmsu/uB$(L#l/p/s6Q8)9,;U>H@bAGBMBRH_JaWoZjZm\a$(M5%;LC2J0MpMqXI\_^,(B")
(qdv "qi2"	"$(I#p'B)9*f.O3/5L5Z8Z9;9E<8C7EME`HaHmI,IOJhKRM9MXQ6RHT"W}X![$a+$(J!w"##}&Z+n-G.@2'5V5q8'8o:g=9E{HeO&UdYwZeZf[k^*bof$j;jT$(K'z(%/z3T6>@\CnF-F6FfHnISQ-W(^DcRnkoltAtwz#{9$(L"c'{(%(&*v-j373e5.84:R:Y:b;E;K;o<@?2E-I-INM1YEYQ]A`5`r$(M"I)%)A+e,$0!1l3#4d4m5)5*EKF"F#I)LOLuNFOuOxQnR@W~bZe/(B")
(qdv "qi3"	"$(I#X#Y%$&w*@/~4a4bC;HuIQRn$(J$G$}%$+)8$:E?,A*B.F`G0$(K(2*f*{-+0!<,G|P5^n$(L!f%Z)#3x5w<;=nCzEeI%LqMRUa`ec0$(MK@(B")
(qdv "qi4"	"$(I%#%o&<)w;JG$K@L$R$Za$(J"w%_'Q(x*X*a+*/(/M0(386,6pA%B~CmG)HmI2M?QcS"S\W#X$]N]jbWnK$(K'k*_*h+R/d0@142*2L7$7=868P<1CDELEMF?P0R.TUWj[I]ickf%hQmJpOsuwF$(L%)%-%V'_+y,I.:.d0.0o3'404[5?<C<QDqE0HRJ"J7L)LtMaN%RUU7X0av$(M!#(Y)?-u0'1yF{I[ImM/MJP'U^]{`^b"(B")
(qdv "qia1"	"$(K%[Mkui(B")
(qdv "qia2"	"$(J1v$(K-p$(MLH(B")
(qd  "qia3"	"$(I?;(B")
(qdv "qia4"	"$(I#@$(J%H1H6}E<KHj<j?$(K*o,&,'-v/)3h?uA;k-ng$(L70F_H9b3$(MHHV#(B")
(qdv "qian1"	"$(I#A#B#|$4&H'3)S,@,m-R.X1`G&I'Nv\"^1^Kb'b2$(J#2'M'l1,;Z<JCeW"X~Yq^q_kfig%iBiqmR$(K"R+F0E0F8J8yEzG5J\JhS`TE\y](_,l9ujvsy2z7$(L)*/I1GI9RcaM$(M"z#8&|(_7m8*8W:P>}C/IvLESIUXW%Y-Y2[H(B")
(qdv "qian2"	"$(I#j1h3hJ2LsMfZU$(J6V=L@5EgN|W/`YlF$(K$$6i<7CbHoNrORq({,$(L#x,6=WQjYSY{`!aT$(MAcEHI9SWSXUmX|_.`{c.(B")
(qdv "qian3"	"$(I-Q23$(J.s8.8r<tY:h"ih$(K#',G2i6S:hI'VOXG[.^Pc@cVf=wN$(L=0$(M=4HLX1(B")
(qdv "qian4"	"$(I!}1%C!LKNMTK`ZaE$(J,j>CC-CfG(OZR/Sj$(K26I,K7Q+y]$(L#NJ>WD$(M'~2G(B")
(qdv "qiang1"	"$(I3?7:B@R3[K$(J2X>oF&K'mM$(K29B/BAQ0WheafCfRk:u]zb$(L.g?$AnH/Mh\V$(M"G%u+z0.C[(B")
(qdv "qiang2"	"$(I;GPJPn[I$(J1;Bo$(Ka<q8x@xX$(L"%?AA]RA[?$(M-4-^?M@$GpM[T]X9dOd\(B")
(qdv "qiang3"	"$(I5!Y]$(J?7$(KD,a]p`rH(B")
(qdv "qiang4"	"$(KhguM(B")
(qdv "qiao1"	"$(I7ZJ*S*Vk^u$(J)5<uCiIWPJY'mD$(K2c7_<~M"V&_;yZ$(L=F\PdX$(M.z/"147=K[N"(B")
(qdv "qiao2"	"$(IKjUUX`\{]>^x$(J-yD(IFN9UBW,X#$(KU't$$(L6!$(M1UAmAoAwIDSMXs(B")
(qdv "qiao3"	"$(I(<9XT+$(J3a$(K!k!~AZV3pw$(L!}#)$t'YYn$(M6O(B")
(qdv "qiao4"	"$(I=oJnSUUg`r$(J0?>5>7HyI\OpOtV8$(K63Xzk[$(L3]H.LQTA$(M">->6p79(B")
(qdv "qie1"	"$(I!|\p$(JBSQqZy$(K/7$(M`b(B")
(qdv "qie2"	"$(J%s$(K%r$(L%=(B")
(qdv "qie3"	"$(L!/!B(B")
(qdv "qie4"	"$(I+I.H0?5i6j7v;{$(J--.50Y7!90<Q=>CBE+EhWIWsXI].]X^/^NmO$(K*V,?,f,q5r@LC=F*IiL&LKQjU_\ee-oUsGutz&$(L@'CYXw$(M#O2nBiHZNeT-U*`h(B")
(qdv "qin1"	"$(I+$9s:rI^QT$(J&n(CGNWA_"$(K2s@dz^$(L797J;~DQGkS)$(M(`1011;hL4QiW?cE(B")
(qdv "qin2"	"$(I"3#0/p2G6199=<>_PlPtRMYGYH\'$(J&^*G6L=uDaQi^ymE$(K$z0dA!L!NaiC$(L=M=QR>]M$(M&-&80%9yNbOSa|(B")
(qdv "qin3"	"$(I95$(J4`9/<ndX$(K)>@jDvQ>YaYcy%$(L6\>XFaQp$(M"7+#7YKrQLb5(B")
(qdv "qin4"	"$(I$u$~%s&/AI$(J(D,~;rL-L|_U$(K"P*Q2)9Rj^$(L]i$(M6zCW(B")
(qdv "qing1"	"$(I4Y5?6|?ILvSN$(JH%gN$(Kwd$(L$>0B0C0Q5E=YOMOcY$$(M)T@8(B")
(qdv "qing2"	"$(I/`AYU&$(J%p*@+D-1P0$(K0Nx\{T$(L?r$(M-[(B")
(qdv "qing3"	"$(I@0$(J[/$(K+{1v$(L]m$(M"c5YKoMo(B")
(qdv "qing4"	"$(IM&$(J-*2N9i$(KGEkq$(L/mRYRZUr$(M,DYc(B")
(qdv "qiong1"	"$(I<oGkP8$(J1<Ff$(K/1?6h$$(L$s?vOqOwYU$(M*B=#(B")
(qdv "qiong2"	"$(I"(#P<1=!=7=}?_C(EoP0\a$(J(_2w3k<f>[CxN}XF\G`J`K$(K*B/|3VRuRyWtZ1Z~_+`aaQbT$(LBjDLNKPUR9WwXj$(M!&.20n1}6/8OCl\M(B")
(qdv "qiong3"	"$(I.jNV(B")
(qdv "qiong4"	"$(J%9(\MVN&$(K2b339&(B")
(qdv "qiu1"	"$(I"b(+(;)aMcN-Vr$(J(./m@*T0^Cj7lx$(K%L<HXtkju-$(L!C*P2I4k5$OWW=$(M&F&^(<1@2v>TP(RDT*XL[1e-(B")
(qdv "qiu2"	"$(I"0"1"P"Z$%$1'-,q0=1$1s9K<R<`=MN3]v$(J'y(5+I,D,N,S032x2}5X7N>FB'G^TlbK$(K"j()+S-;.+.Z7d:i;U<8=5AHJ,X7Ypa$$(L$-+M<cA!A_H,OvTdV|W7WsX(b=$(M't,7-x6q8h>6>rE~Ii(B")
(qdv "qiu3"	"$(IA>$(J^]$(KZ`jK$(MAG(B")
(qdv "qiu4"	"$(JT/$(K)h<U<_JSke(B")
(qdv "qu1"	"$(I!W$E(#(^*v-)-j._9@?8JCNrOoOs_~$(J.j/Y3u4|:YEfH`IKJ!MtMyTD]p^j$(K!)#K0y1U3SH9KGwR{I$(L&&4!;S>8>nCSOAR$W8Xgbm$(M#J$!%z)>+M2b5wE7E9I3RMW;YP(B")
(qdv "qu2"	"$(I6g?[QjWP^/_H_T`;ao$(J0];G@JH>I]L9OeU+UQVHVUX?\:\\_@_AaJdSf7f<i$jWkAm&n@$(K7G9W9`:*<CDVJLLTSJVNYBb7d]j<n$n+s,s`v.w+w|w}xo{Q{q|%$(L+>2.5]>mD2EMFdU1Z_]%^/_T$(M/)4R6c>,>_@5@6E]EsEvHMOWR]UvW$W}X+XUZ&\d_#`Tdsf"(B")
(qdv "qu3"	"$(I={HT_=$(J'.305#;,$(K7UCrD]FPkOsx$(L=DTq$(M>afH(B")
(qdv "qu4"	"$(I"*":Q|X~]*$(J)M+6;$B{NJ$(K*4ZQ$(L$"0l1xE.O5ajbtbv$(M!EWK(B")
(qdv "quan1"	"$(I:CHW$(J6=ky$(K72:S$(L[T(B")
(qdv "quan2"	"$(I!v,;-W7b;5<lABD/L^[n^)aO$(J%M3R>pBHDK^reZi0m'$(K%>'<(v+^032v3X;A@kPZo|qzsYv%v0$(L!{@*FZH2Pd$(M!f)<-$6M=j=kb(dtf:(B")
(qdv "quan3"	"$(I'n>u$(J!%!8$_%r'B*$8X?hEr\hex$(K2M<*OG$(MHU(B")
(qdv "quan4"	"$(I!T/o@F$(J?KYi$(Kwy$(L?J$(M4aHk(B")
(qdv "que1"	"$(JF'S@$(K7[v/$(LC-(B")
(qdv "que2"	"$(JNq$(LPX$(M+Q>.(B")
(qdv "que4"	"$(I$g*)1k273UCHK|P&SJU>^;$(J%V98>/E%H!JRJ]MuVSW=YT^acOcdfbgVlc$(K'=/H1V3-:BM(NZ_8e\mdnvoPyvzt$(L&<;r$(M&%*G4t8R9S:"@2FDJRPwQ)`R(B")
(qdv "qun1"	"$(I%FCR$(J(L,|G[Mo$(KBi$(L6|?"$(M;%(B")
(qdv "qun2"	"$(I0iCnDOJk$(J2)V<$(KY!$(L7)7-R"$(M(M(B")
(qdv "qun3"	"$(JMr_Q$(KVy$(M!e:B(B")
(qdv "ran2"	"$(I*R3m3n3uJsKARSS``:`B`k$(J;8HOI<[P\_m|$(K/ZDkG!NEcFogz6$(L&E,GC_C`DmK:L"NDZ/$(M%35[=m=n>jExRqWI[p^3dJe_e`(B")
(qdv "ran3"	"$(I!M%R*i:WAlE,$(J-Z4>A?B3Y\$(K&3(J(e+c,74N@VRqZL$(L'T4j:wCB$(M5|(B")
(qdv "rang2"	"$(JfDfG$(Kn,yV$(M%5XB_t`w(B")
(qdv "rang3"	"$(Jg"j\n6$(Kl%sh$(MXf[gb.bY(B")
(qd  "rang4"	"$(MeD(B")
(qdv "rao2"	"$(Kcw$(MBk(B")
(qdv "rao3"	"$(JjQ$(K[KtM$(M3^Gr(B")
(qd  "rao4"	"$(KS\(B")
(qdv "re3"	"$(J%a$(K8N$(LXK(B")
(qdv "re4"	"$(K*A3EBWM)$(M,*/X(B")
(qdv "ren2"	"$(I#w%x9'>4>6?iWH$(J"q$h@mB)H+$(L!O%9(B")
(qdv "ren3"	"$(I#h1d7l$(J!x#,'h4L9u$(K.N{#$(L%Q99$(M/h(B")
(qdv "ren4"	"$(I!6&#&E,-,b226Z9A>r@$$(J"e'J0,ZZ$(K$+$C0IKeZm$(L';'^)!/u1'467/:\AfNTc-c/cj(B")
(qdv "reng2"	"$(I&}-v/+$(J#0%T'z$(K""5Z<:$(LDsP}$(M_`(B")
(qdv "ri4"	"$(I'})]9W?g$(J$X$(K'c/v$(L!e&P&U/[QHZD(B")
(qdv "rong2"	"$(I%[-31R=s>lMSR;R_[[\C$(J%7)P8O>+AVD<K%R)Y(YBc|eK$(K4,:|NnW)Wv_PcegEn{$(L'--?1=1r8y_P$(M*s0(3,KFL/Za]?(B")
(qdv "rong3"	"$(I!O"=%-A:O8$(J2VD;D>SMY6fU$(K!d(W*/1_2a58=MQ\$(L2_4_EF$(MC#H7N&(B")
(qdv "rong4"	"$(IT5$(K5DxZ$(LZ*(B")
(qdv "rou2"	"$(I&M<TBfCwZ\$(J4MDybLjR$(K4c<|Zx$(M&{;!(B")
(qdv "rou3"	"$(J7F$(KH'$(M2;(B")
(qdv "rou4"	"$(I%Z$(JZ+$(L%G*e$(M>M(B")
(qdv "ru2"	"$(I$=1Y<m>n`]aY$(J3C<=>;IAIBO`g2gHlI$(K)t.C<'BMFXVZ`Zoqyt$(LZkaack$(M$L$T.g2jB]B|K,T}V2ZO`>(B")
(qdv "ru3"	"$(I'%$(J:!$(K(dSOh`ve$(L!D3zMN(B")
(qdv "ru4"	"$(I!89rMY$(J3eCTD=[e$(K"iuQ$(L?nRj]F$(M'bc-(B")
(qdv "ruan2"	"$(J7dMB$(K?LGcM|\0$(M!m(B")
(qdv "ruan3"	"$(I.F4?:wBsC{FRS$YS$(J*U=m@:DzESF[S{`.g1$(K'I0Z1,G?O<VaWL\LhU$(L%\(q+I$(M'.9iDtJJJl(B")
(qdv "ruan4"	"$(K_I_Xn6o9(B")
(qdv "rui2"	"$(I=>=?$(J)R9cFd$(KIAlC$(M21(B")
(qdv "rui3"	"$(IRY\x\|$(JPa\>$(L`@$(MXo(B")
(qdv "rui4"	"$(I7uILOLP9WsX%$(J*l1~TGg>$(K#B:Y=/jx$(L@o(B")
(qdv "run2"	"$(IUY$(L^_$(M9\GqH1N?(B")
(qdv "run3"	"$(I;a$(K6|(B")
(qdv "run4"	"$(IKbOT$(LVA(B")
(qdv "ruo4"	"$(I#3<z$(JXk$(KCEW@q*$(L.$/J0-=b=cHZW<WVa-a/$(M#SFEOG(B")
(qdv "sa3"	"$(Jl*$(KJQd*{D$(L%.8pA1A;J`]6$(M#<<><?=Z@=UC(B")
(qdv "sa4"	"$(I%PJW$(J"DH~OfP?RxVuWmYm]F$(K&1&k(IKULLYt[H[g]<]Ym}ooqYqat=$(L=sL_Z,d8$(M+2:2:vIw(B")
(qdv "sai1"	"$(I;PPqYY$(Jeh(B")
(qd  "sai3"	"$(JL'(B")
(qdv "sai4"	"$(J`L$(K6NHvVk$(LR+\$$(M?BS,W[(B")
(qdv "san1"	"$(I#bF,M/Wo$(J##?cQb$(K!J"[C&H@W4p%$(L$`+:$(M,1/*/qZH]l(B")
(qdv "san3"	"$(I1*CWHdMoXU$(J!<CA\D\Zb;e1e:$(K7D:WA\OHWF$(LF3[r$(M.GHSQcV5XY_-(B")
(qdv "san4"	"$(I+);wLlSV$(J1\cK$(KWR]]^7ienB$(LIO$(M#G(B")
(qdv "sang1"	"$(I-//J1\$(JU.$(K_?cXjYtsuT$(LG%G.Sc$(M-A?&I/(B")
(qdv "sang3"	"$(IYW$(JK4Y2_t$(KGt$(M[^(B")
(qdv "sang4"	"$(KF>MQ(B")
(qdv "sao1"	"$(I+NN>`#$(J65FIXD[{d&$(K)@?,?B@FF=JkV_eRmHnzrK$(L1N7|SN^S$(M12131>1k>JAPG6Z2]|(B")
(qdv "sao3"	"$(I0I:q$(LGa$(M$k2S(B")
(qdv "sao4"	"$(J%d_c$(K8CFhY0^y$(L@/(B")
(qd  "se1"	"$(J`~(B")
(qdv "se4"	"$(I7C<I?0?|FeLzM7PbZkZr$(J#)2mKLOYV4VN[^`a$(K/c?>CQL#L$L)Q$R@ShVc['bBbQd-iBqbtk$(L,38x>?Q-RCTC\l$(M!I$F%B%P,y/<0,8qA0FwIZJ,N_S6WsWtX'Z#Z((B")
(qdv "sen1"	"$(I.D4zTp$(K:qGIM]$(M.o2H(B")
(qdv "sen3"	"$(JIY$(KDZqx(B")
(qd  "sen4"	"$(K=k(B")
(qdv "seng1"	"$(J<0\}(B")
(qd  "seng4"	"$(Jmq(B")
(qdv "sha1"	"$(I3.6UELGNYtYv$(J$!-e2Q?i@ZDHTeZ7eR$(K+>.E3:3M;f?JMNT=T]g2u5$(L$^2(6.@<@>VIaXd^$(M#Q'U+l1v8V;b>CJ"UcZZZy(B")
(qdv "sha3"	"$(IK,$(J]Y$(K%Z5[(B")
(qdv "sha4"	"$(I5X:(OS$(J"h3$8+=}@0MfMgMiTuVZ^"bAbEgF$(K",'U7Q8:G<GfJ.U-Xye8k)lw$(L@nHdMoSm]u$(M3u3v5<>&L3(B")
(qdv "shai1"	"$(I<YL3$(J\A(B")
(qdv "shai3"	"$(KER$(M:6(B")
(qdv "shai4"	"$(ITs$(J^#hN$(K=>(B")
(qdv "shan1"	"$(I!B"]$a(F:pRAU!X]\E$(J'N+.8!@|G%JdMDT[c"e"m+nM$(K+6;NBHQNQpa"imx;$(L)g)h/w0/0I2l9OM{Xr$(M$Q0"=[V)XNYR\=a6(B")
(qdv "shan3"	"$(I?rA7B2VV$(J#e+[2,9FDhG?^$$(K*l0J>_G^MGSgvbvc|+$(L4wO-UY^p$(MIA(B")
(qdv "shan4"	"$(I3}E0EkGmK!T$U`XFXt[{\m]X`h$(J&C6<PIR,S:WtY1$(K".-H5$97;II2JpMvNpTJbYw=x1$(L5v:6=lG,LZX9bQ$(M#5&s<`<aA]A}H^O!O1TFVIYH[Ect(B")
(qdv "shang1"	"$(IF8FCGW$(JQE^&j(kVlb$(KGn$(L&%cB$(M%x)5,W/j0/0T68?(@,CKEIF3VcVe(B")
(qdv "shang3"	"$(Je?$(MQ`(B")
(qdv "shang4"	"$(I!&(QFjJ5`V$(Kji$(L!'La$(M;Hd[(B")
(qdv "shao1"	"$(I$L-aR5$(J@bD]We\N$(K2n:bL[]A$(MXx(B")
(qdv "shao2"	"$(IHU$(J*,Pn$(K?*$(L(-$(M.)(B")
(qdv "shao3"	"$(I*c$(J%(=`G9$(K5zd0lx$(L,9E^(B")
(qdv "shao4"	"$(I0@EVHtSa$(J064R;#=s?{Xx$(K,/$(LAgHC(B")
(qdv "she1"	"$(IIq$(JaC$(KfY$(M)46*(B")
(qdv "she2"	"$(I%~/#V[$(J0S:oAHDFE9EG$(K539eB@WYj;$(L&G/5@)DIK=$(M"p#k.>1#4g(B")
(qdv "she3"	"$(J1PH[$(L@6(B")
(qdv "she4"	"$(I*]7%<_?AOF]-_N$(J#%2n6F7E8tc/$(K1I5%@o@pAcY=\7^I_fayv+{$$(L"|1Z8#8Z?P?T@;A)EDHXJBKy$(M$@)P2tB)^;(B")
(qdv "shen1"	"$(I",#m*H+10QE6$(J,y3n;/A.J;LiO$Q|S(\M_4$(K!o&7+".n:N;EAkBlJcW`mFp*$(L#:#c$N-s1#1(1z6N=d=eL`[L`=d%$(M'@EPR((B")
(qdv "shen2"	"$(J*h$(M&*XK(B")
(qdv "shen3"	"$(I$w%q0W9#O{$(J'R>B@pNZQO_na0fI$(K4MU4ZNi.$(L%$(j+53?Qv$(M+d9ObD(B")
(qdv "shen4"	"$(I,~.-2!2h6a7'FlH)TC$(J/EG~$(K)(/jAsC1E\HuZ=$(L-62{3!4/L!$(M0H1KG?IjR^(B")
(qdv "sheng1"	"$(I"j%E'?-w.o1i9e=@T0$(J$ACzF7UX$(K)i)oA/$(L#5&4E:b}(B")
(qdv "sheng2"	"$(IHoT&$(JD|LE$(KP)qk$(M$D19Ua(B")
(qdv "sheng3"	"$(IMG$(J6_6|;\DvE$M+S[YS$(K.s7^BCOqY;$(L2q>cBP$(ML;(B")
(qdv "sheng4"	"$(I:#BmF?RR$(JCybR$(K3`Lk^Tw*$(L5-BLFFFcM3[![.[l[y$(M.tTQ(B")
(qdv "shi1"	"$(I#\*.9YG~I5J~P*\i$(J%c)`/f/w6W9H;";b@NG3M0Sfd(l|$(K$A>]JlX)]M`^a|nooCy{{4$(L!>"0#($q%s&2(W0_1Y1[7+=z@CDoF,F.N^N_NmP6PwQdamd.dM$(M&\+nGYG[IfMCO6W(_7bO(B")
(qdv "shi2"	"$(I$2&=(K(M2u5k:2D{Lr$(J&b4{UOf($(K!|!}&R1X2&7+7uE,Oo$(L%>'/(l+{204|4}4~5!BfN(N6W4_6$(M'j4[>E?FFW^D(B")
(qdv "shi3"	"$(I"d#2,97z$(J(@*4.\AANIO#U<$(K%s-|/05?9D;lOITG`Cob$(L"u"v#U$O%T(k)?)[*c*n.[9W<7>oBxE!H"H#N~WZ`)(B")
(qdv "shi4"	"$(I#*'b'e't)Q)`+9-!2d8J;BEJI+MkOGOkPQ$(J!U#O$4$Y)n*"*]*^+,->-}5^78;5?)@h@yAFAxHZLNMbT}U'\&]_lf$(K$~%J*O+P/L3t4A9};D;u<I>TFcJna>dTeBettYv@$(L!k"'#q$y)>0b0w1t303132445&5z89<S?OBCClCmDkE+LLNWO%S6TbV^X]bq$(M'I)!)0*:*>-]/(0~497G<n@}E/G.HTHtJ2XTY1\7cHdAeY(B")
(qdv "shou1"	"$(I!`$(J%:$(K.Y3x$(L!b"S(B")
(qdv "shou2"	"$(KFp$(M7ETH(B")
(qdv "shou3"	"$(I"<+n$(J$r11^_$(L-A<y>_R*$(M2"E3d%(B")
(qdv "shou4"	"$(I4]6oX/$(JM`ag$(K(<2[2|646o:cI[IjX(\d^ZbRc($(L&~5nFOG(IgK_P0\/_/_lcx$(M%W'&*g*r/}/~021X92?S@lNJUV(B")
(qdv "shu1"	"$(I)N=ECkIzSK$(J!)#k*+-<-z3;4*5o7;9.>mK!OKk|$(K(o/r31FBI8NHWZZ3[vcCr5u|$(L##0#1u<&A"SJUF$(M#m41^'(B")
(qdv "shu2"	"$(I6$T}b$$(J"\%8-:B#QphslU$(K2`Wk{"$(L&8*j.J000iFEc"$(M()K>Uu[Kbf(B")
(qdv "shu3"	"$(I;&UL_t$(J4X;?W-X@]:lom}$(K0LL{\?x]$(L:GCkDMS<`G$(M2K3gBdB{I`Tg(B")
(qdv "shu4"	"$(I+,+;3Z5_5`8$<v?N@kAMCJGKGXGaIlLIRqS<U0UlVN$(J'_-f5-8%@6D&EbGlInO}T'T2Zra+n*$(K%V(DCYJ'N,PEY^Zi`Ho=$(L-X:x=,?BAPAeFyK8NQNYPWSQV][4[7^D$(M#K#L#j-d.s3y8"J[M"MwU&W_(B")
(qdv "shua1"	"$(J%Z$(K#A$(L8&=t(B")
(qdv "shua3"	"$(JTq$(KYRjv(B")
(qd  "shua4"	"$(IIb(B")
(qdv "shuai1"	"$(JD8$(K@AUdnO$(LPb$(M!"$,?A(B")
(qdv "shuai4"	"$(IO:$(JBNXa$(K,REfM[N1n\$(LX"$(M(Ccd(B")
(qdv "shuan1"	"$(JfF$(K9>[Tus(B")
(qdv "shuan4"	"$(IJA$(JS&$(KaOqNz+$(M7[^v(B")
(qdv "shuang1"	"$(I!^?x]K_Ob0$(Jkvm$m($(KN-t'x)zD{s$(L;d$(MDWKOS3aAdl(B")
(qdv "shuang3"	"$(IV1_$$(J1'QBWqe0$(KV@X-]!dl$(LFf^W^z$(MHY(B")
(qdv "shuang4"	"$(IL+XM$(K\o$(MNs(B")
(qdv "shui2"	"$(K#6i0(B")
(qdv "shui3"	"$(J=7$(K$2/OZA(B")
(qdv "shui4"	"$(I1{=_=h$(J*FC4NeYW$(K$*/?$(L3Z7,X,$(M%n9b:c(B")
(qdv "shun3"	"$(JRs$(K==$(L;B=p(B")
(qdv "shun4"	"$(I2`;`Q>RK`j$(JI7$(L.U7&\6\7$(M@zOQQ|ZG(B")
(qdv "shuo1"	"$(J,)$(K(Q$(LX<$(MLU(B")
(qdv "shuo4"	"$(I=W$(JCqDELAcp$(K9dDME]H[Vq^;_Ob$h!vp$(L(,8CJ2J8ZO$(M93@]Wc[nc|(B")
(qdv "si1"	"$(I!+$.(40~:zErF%OIXNXv[kaD$(J/'4p><DeL#Q#R{VeVqV~W:aXb,bNdgi"k<l~$(K&u1'8>?%LVN{PIT{T~\Q^$d7rUw8wn$(L)K+n0D0j0s5*767X=@U4U8$(M&t1A2{9@=p^&a*(B")
(qdv "si3"	"$(J8x$(L%N%u%v(4(9@p$(MFn(B")
(qdv "si4"	"$(I$$$N(C(H)G)i*F-,-m.p88=qE7R'X'$(J!;*3/"0B2y42;(KTNKPlQ.U4$(K#3,U.e0~1#4W:\C#KcKlQ5YE$(L!U"_)O)Q3w3}6W6r7;7M:&:=<v<xHNN}V`XM$(M#s&G(g0^4647EBO:(B")
(qdv "song1"	"$(I)R-:/^5a6TJtPdTx$(J1XJEL,PSU5$(K)/)1;xCiCoN"\A`]bDr?$(L'vE{Ge$(MLd(B")
(qdv "song3"	"$(I1.AGAxLa^2$(J=FXgc~$(KJqaac;ox$(L'0;!RVR{Vl$(M82(B")
(qdv "song4"	"$(I?RGIIi$(K5!6MI5$(LORXDYBc;$(M<U<VKm(B")
(qdv "sou1"	"$(I1;;>FzG@I6NXR]$(J6R<rR7R^^TbFe%h3h<$(K1*M@T%^cesjTj`$(L=[I1JZK<S$T+Tr[G$(M4T7)<w=w=xD~K|LAVZa7(B")
(qdv "sou3"	"$(I9uRBZH$(JEE$(K=4WI\mle$(L&A&B6[=$>U>[FG[P$(M&@'+(B")
(qdv "sou4"	"$(II*Qs$(K3uO8yh$(LK]_*(B")
(qdv "su1"	"$(I]!$(JPi_^$(Kg{h3pQ$(L7W$(M%KD2O=]*_=(B")
(qd  "su2"	"$(L7N(B")
(qd  "su3"	"$(K3<(B")
(qdv "su4"	"$(I'F/r2@5B6d7n8><e@WA5B-E{GUIEI_ItJ&LXLkNCQgVGXVX_];$(J8L=RKWN3PLPQUfW9X0XM_je5j.$(K(!*E*z2R3A8.=)>P@CFyG6GFM:NSQ(TPU&UV\`^=`Ya`b(ibk@rlt7y~$(L#^%(&m)F,T253a565k6F>V?iJGLMNnRK$(M"8&Y1F2)3<6a;A;B<(AZB+B,C;CEE-ErGQOCR:RPRQSBZi]q^7f6(B")
(qdv "suan1"	"$(IIn$(K:>d)t\u[$(LUN$(MEn(B")
(qd  "suan3"	"$(Jfq(B")
(qdv "suan4"	"$(I2o$(K=nc>erhh$(L'M`%(B")
(qdv "sui1"	"$(I!:'+',/$M$$(J0>mgn"$(K'4=^?!]Ijh$(LD1$(M$2$5's*l5.;O;PQEUp(B")
(qdv "sui2"	"$(IBiD}E@S($(Kmhsq$(MOUPz(B")
(qdv "sui3"	"$(IQWV#[p]a$(JZ*kO$(KNA$(ME?FbGwQsTdVHVS]bc'(B")
(qdv "sui4"	"$(I!l+8.=32;1;\<S<[BOCEMWPOQMRyUN\\],$(J>_D*LCP=Q(Q5RzWoXH\C`daEcbd`e(fvhm$(K$,2<7EEOEsH%IaPkQ*T;U#VuXo\J\U_}aXb]hcmomun5qZ$(L(m333V@%JAOLSaY3Y>$(M,o0F0h0o8C9&G$SeT1XRY~\,_wdLf((B")
(qdv "sun1"	"$(IE\Xp$(JS.ev$(KWu|=$(L"hP@WBd?$(M.722:u(B")
(qdv "sun3"	"$(I3+$(J9p9x=OF@IiKDL+Rh$(M#B&Q1';{A6(B")
(qdv "sun4"	"$(J<H$(LJ^(B")
(qdv "suo1"	"$(I0D15FILG$(J(69>FWGDNCT!g}$(K2{ARKO$(L/N6B7u<UL%]0^$^,$(M#,#p$':8>*>+D8(B")
(qdv "suo3"	"$(I-IB0H&QrR<YE[P$(J0&6C9{<k=I=K??A6BrC)CkCuF>FYH/KZKfL.R3S;SPTYXzX}b3hJ$(K=6CwN#NTPGT^WwX'YV_ld:jMjOnyoMrOrns($(L1C7k<:F+YKYla>bd$(M@c@wAQB^CJD^Z{(B")
(qdv "suo4"	"$(K<PKpRBoK(B")
(qd  "ta1"	"$(K1B(B")
(qdv "ta3"	"$(IFDKBQ?$(J0|EmY)$(K7'W"e_k/nl$(M)J+V(B")
(qdv "ta4"	"$(I!G-p5H<0B1K%P`QBQPTuWDaP$(J&r+1/10y1)2!3(448A:^>X?>F+FMFtL8LdR6RGRWRmXrYj[E[~\{aTayc&e}g?gAgMhAhYm#n,nU$(K+p242k74<z>0?=@G@JAeCyF^HeICQ^UNW%d3fKf_kHk`pWs+sFsVt-z@zs$(L-U3q@fC.IUK>USXo^*`|`~aU$(M$U$V/,/=/t1x3}3~4#8s:h;y=SB~C|GuJVKZK^K`MnWx\o]~^C_Wd1(B")
(qdv "tai1"	"$(I(!$(J&"4}$(KS!q9(B")
(qdv "tai2"	"$(I(((r-d>KARBKD$K*TgU?$(J!^UL$(KF[lPo~$(L%3/l>->4J{[]]<$(M!z+L0v`/(B")
(qdv "tai3"	"$(JUr$(KbS(B")
(qdv "tai4"	"$(I&!&(A-Pz$(J/O$(K#]0+1TZj$(LFU$(M9ZcL(B")
(qdv "tan1"	"$(I('1t3H3S;jBFK<WpZy$(J'%DJL}R"[]$(K$=/s9fI?N&P2Wect$(L&b(F-f2[9"T?$(M[W`sdK(B")
(qdv "tan2"	"$(I<pKLKMO?Z/ZiZz]/_[$(J57>eN:R1VxX6\-\V$(K$($-;(DqPo]=cficq?r,w@y4$(L<*dK$(M(\)|,"6ZPaRISqW*^V_lcadeeIe{(B")
(qdv "tan3"	"$(IPjQIUK$(J'e)cRE]LaSn/$(K5g<RA9IeK=h{iOj&$(LUXW|`7a9$(M*,+';$bG(B")
(qdv "tan4"	"$(I`X$(J#|F{RamV$(K7N?[?]QUfFh)$(L2HRv$(M?-Lp(B")
(qdv "tang1"	"$(I(%$(JT"$(KTY\4$(M=&(B")
(qdv "tang2"	"$(I9o:<<?@;@eE#FtMOMqR:UtYf[i$(J6><EAUBsC]D9F9GmH$K&KbR-X;\J_OkW$(KG(^\_"_4bpj_nirI$(L5~]X$(M%&%<)U<;<gCpDFDOHRIEI\K'bL(B")
(qdv "tang3"	"$(I"p4APE$(JDols$(Kw_$(M/a(B")
(qdv "tang4"	"$(KY._!$(MK9K:(B")
(qdv "tao1"	"$(I%d.44:H!J\J]R?VHYA[_$(J!h)d2;:O;1R9$(K!5%/*2.r6]9z>pU?m4np$(L"V#QFsJmPAW+`&$(M%9/n2!2R5EDxE*N>QSQoVD(B")
(qdv "tao2"	"$(I/31|IROcYc\0$(J<PM^T{^kbzc%$(K*R2Q$(L4r8u8{EVF)$(M$H.d/51;2M5C7L@!(B")
(qd  "tao3"	"$(Jj1(B")
(qdv "tao4"	"$(I#H4~$(L*Z(B")
(qdv "te4"	"$(I8f<>T*Xc$(J)8+A1c1|4G8qJASESHcs$(K'~FH\I$(L4KFMI@(B")
(qdv "teng1"	"$(IRD$(JcW$(K]\{5$(MeE(B")
(qdv "teng2"	"$(IGZSqWR\}_Xas$(JQG\xh,h>n'n8$(KEoV!^vmtq<t,u*xO{[$(L4(SHTL$(M&]'K2f:i:jAJBWBmBnGbI>NMSyTPXhY)Z?ZT\w^#cjd((B")
(qd  "teng3"	"$(J]o(B")
(qdv "teng4"	"$(J=*$(Kix(B")
(qdv "ti1"	"$(J6G6P;YYJeEhD$(KG%J7Y`[oc\s"$(L/$3N5dY9$(M<<CfDPEYF/MEPF(B")
(qdv "ti2"	"$(I:X@QBtDzH?HQLtNmUdVU`=$(J4_9":+=(>1@PDxH.KJNdR~SXSb])^._&i'$(K-G:%</@8EAFFKKc:evi>$(LJhOi_U$(M!l(+202V394$<%CiH>L+R6Ra[6^F^G(B")
(qdv "ti3"	"$(I1,?@OwZs]8$(K,y9(tb$(M<FQu(B")
(qdv "ti4"	"$(I'0(T*t;%?VEaLeO$VCW;W[Y9]:$(J$L1:2#3&=MK<O!PVS_WzePh\$(K+D/M8[??B-F+M&V6V;b,d[r~w?$(L(87dH$\w$(M-v61;cArBzU>[7^I(B")
(qdv "tian1"	"$(I"zHgTtYO$(J't*VZ]$(KI)g9rg$(L#@#S#[%^;V`6$(MM{(B")
(qdv "tian2"	"$(I*z,d.`3Q3T7D?J@XUM$(J.0Gf$(K&*<\B4JMO-W.iW$(L,x14$(M#N&<&>(;,n1a(B")
(qdv "tian3"	"$(I({4f4sC'NeV^$(J"$1d3f4~>fM~dY$(K'w+z6D@lABDeIYPzQupeqd$(L%')72&IuKUMT_D`^cHd"$(M(/(]A8NpY{`k(B")
(qdv "tian4"	"$(I7*$(JDnVp$(K&v$(L:zS\T\(B")
(qdv "tiao1"	"$(I<(><$(J%I=a$(K&-EB$(L8/I[I\IfVeY&$(MH=LV(B")
(qdv "tiao2"	"$(I&J(\/S5I>XLbOKYx$(J(Q@[Th^s$(K%?5vB<JFl;p^$(L%O1&2,@jNHWK$(M*D(B")
(qdv "tiao3"	"$(I1FDq$(J-x3=$(K4$SY[G$(L9@[AbH(B")
(qdv "tiao4"	"$(I8"$(J(O<p$(KJ|VU\i$(LQsb~$(MCg(B")
(qdv "tie1"	"$(I,Y$(J_Dj8$(K;K^Ynj$(LW)(B")
(qdv "tie3"	"$(IE8_m$(JP@$(K7W=O$(L,y$(MK4VLYe`1`2(B")
(qdv "tie4"	"$(IYd$(JA{H=U]$(KjP$(M[4(B")
(qd  "ting0"	"$(JAl(B")
(qdv "ting1"	"$(I!P"GSSV"\?\r`p$(J'aLBTc$(K+J+N0t=Q$(L%6%b'A:4:~CLM4(B")
(qdv "ting2"	"$(I"^RgW9$(J$^+_.&_%$(K'e6):rAuXMf(q/$(L.'<NU!$(MR-(B")
(qdv "ting3"	"$(I1x?m?nIc$(J209b$(K"s'K6A:KJJK}g.$(L"bUwUxW*$(M1{(B")
(qd  "ting4"	"$(K-b(B")
(qdv "tong1"	"$(I%'LM$(J@{$(K)"?eCGE2Fm\r$(L7IE]\L(B")
(qdv "tong2"	"$(I(h1M7iE~Q^$(J&6&M)'-v3o8]9#:R@vD6GuN7NRVr\if#gohbii$(K#P%-+Z.,;}=%C[F/I`Lh`j`tw,y|$(L(i+?1%B$L}O0$(M>n>oA_M&R3WJZ@]ub_bpcD(B")
(qdv "tong3"	"$(I&K$(J(l)2,<2(?q$(KCMia$(M+*(B")
(qdv "tong4"	"$(IL#$(K:g$(M8#(B")
(qdv "tou1"	"$(I4L:|Va(B")
(qdv "tou2"	"$(I"9%/\u$(J0W0_2M7Aes$(K-1SDaDg"$(L1P3IPoPp$(M#~b2(B")
(qdv "tou3"	"$(I8x$(JU[$(K`5$(MUfW4[#^>(B")
(qdv "tou4"	"$(J,-2H5]$(K%B5o9;<tav$(Lbu(B")
(qdv "tu1"	"$(I*>Iv$(J"~94GF$(K-k2}J%$(L>z(B")
(qdv "tu2"	"$(I%(*E0l4dE.F7M3$(J"n#o081]2{336i7`8/=jGpJ<K9M8MxQQQ}S6TdW\$(K0w3&6_8D:!>j?c@NDyGKIzJbO/OmP(R-Z&_G$(L$!$I)-.s127$7H<<=}>$GBG{QZVsW>[X$(M"y(#*c7D<C=:EkOh(B")
(qdv "tu3"	"$(I!a$(K#+(B")
(qdv "tu4"	"$(I'S$(K&IfLw1$(L>+$(M50Oi(B")
(qdv "tuan1"	"$(I=-$(JSw]chK$(M3]6eW3["(B")
(qdv "tuan2"	"$(I#>%*TjUsWv$(JkI$(K8n`2jDmNn`{0$(LA2I:Jb_}$(M&X5758;@^)e~(B")
(qdv "tuan3"	"$(IT=UR_;$(K9rO{[Q$(L_#$(M,5H%X>cZc[(B")
(qd  "tuan4"	"$(M3`(B")
(qd  "tui0"	"$(I8o(B")
(qdv "tui1"	"$(JB}DYD[JkeJ$(KQ_Xx$(LR(Y'(B")
(qdv "tui2"	"$(I=NKPS_]"^@$(J7*IIIZW&Yrh!$(K-48$ErGNS{UGdUpcyN$(M?5KBKDPX\x_Z(B")
(qdv "tui3"	"$(IVTW:$(J,M,Z2JK/g@$(M-B(B")
(qdv "tui4"	"$(IDF$(J,9,{Wf$(K1t4pEuOt`M$(L'V.=Y7$(M>)Cx(B")
(qdv "tun1"	"$(I%"K;Q%$(J8)]5eu$(K0oTjfs$(L(J-l(B")
(qdv "tun2"	"$(I&l9-SL$(J*:AoFJPE$(K%l=ADpZd$(L$1%7-&-O:V<2<6<F=gDrF:H8b[$(M*h,/,23[3\H|VV\2]fa,(B")
(qdv "tun3"	"$(J,!M](B")
(qdv "tun4"	"$(I1-$(K:6J;oV(B")
(qdv "tuo1"	"$(I#}&D)..<8E<P$(J%`+G9;;7UYa=l=$(K$a4SB1BvDNJIQ"pY$(L='Todu$(M'y+G3{5uP1`((B")
(qdv "tuo2"	"$(I)k***{-l-o/02l?CJiOrT'Z*$(J.,467%;9HAYll$mG$(K%W'$7nHfK&u_u`x,$(L*z3p4o929n9o:BC=NcO;^|_Vd'do$(M363B4UE;LQL`^B(B")
(qdv "tuo3"	"$(I:sAoQCY{[?\K$(J"m$(K-I3c9cAxUmY9$(L&r@@$(M=((B")
(qdv "tuo4"	"$(IGD$(J2l=w[LcS$(K^@nD$(LT-$(M!a"U3z81G2(B")
(qdv "wa1"	"$(I2M8;@NA3Vs\,\-`2$(J)1-]2j:tUw$(K%8&\1MD&Hy$(L1|[i$(M-%>k(B")
(qdv "wa2"	"$(K1J<=(B")
(qdv "wa3"	"$(I'o*u$(K$r%d'2)U/o(B")
(qdv "wa4"	"$(I8kJma(a)$(J4/48<Dcm$(K$b*yFgWD$(L9v(B")
(qdv "wai1"	"$(KSj$(M7/(B")
(qd  "wai3"	"$(K0Q(B")
(qdv "wai4"	"$(IPf[>$(Jn1$(K&87?Q9qyrz$(L"d(B")
(qdv "wan1"	"$(I,M5Y<cIM$(J#qBXn9$(K,(71<>nEojy$z)$(L&+$(M)&5c(B")
(qdv "wan2"	"$(J325O:/HbK0$(K"b$5*w5q6XB$b^$(L!2:oA{A|^u$(M+O@g@h(B")
(qdv "wan3"	"$(I0T2K2[4r6P<9>][L]u$(J*t.12=4,@cAEEdFOG*MUMlQWUWYbYh^1_G$(K'g+:7`9s:eK*Za[S_nfEfQkYkg$(L)07qD5L$d*$(M2P4c4h<x=Q@rN+(B")
(qdv "wan4"	"$(I7690Y.$(J=Q>Z]{dOfu$(K4v5V__ueug$(L!3'?4+7mATI*I/$(M$r&,&fPs_^(B")
(qdv "wang1"	"$(J!4!J!K%<&)-q9197_-$(K,x:D$(L6k>f(B")
(qdv "wang2"	"$(I!4"n3A3j$(J$,$(K-/S-(B")
(qdv "wang3"	"$(I(v*L3:<=>1NlSw$(J'^'v/d2^2`2e8Q@r$(K$8-r;{=.D<Hq$(L"8":$F%E&j&{3j4`7L:|?bDnEKEZOQY%aodl$(M&u(B")
(qdv "wang4"	"$(J)v1i]Sab$(K$I@qBuPy\q$(L('(`;4LUbD$(MU-(B")
(qdv "wei1"	"$(I5:5g:/:^:a<5W%]h$(J6k8H=lL?Y~Z$^taK$(KCvHkIkPVPgryw'$(L2xUo_W$(M$j314B7MP}RF^?`U(B")
(qdv "wei2"	"$(I:d="=5X:Zm$(J1>=!I'RA]J]WaIbQbrd*i@$(K!fClJtQ8RDSST6Y[qUt0tBx_{'{r$(L"r"s$Y,c8.=UHtNSQa\g_;aVc9cK$(M,x9g=aBwByKdS1S2(B")
(qdv "wei3"	"$(I(S/}6L8N;O@/H}Q!YRY\$(J7(74757?7b9V9d>$?]B!E)GXLINWNgO/R|VhW(\1^-_iaHb/d)i1jVju$(K$D-,8h?XGhO6O9OAX8XIY'Y@Yn_3`TaFb<ezm_rRvnyB$(L0=6q;^R'T"WIZP^e_+$(M)-):2Z3YA<D}M;S{T>VBX\Z)Z4\S`CaM(B")
(qdv "wei4"	"$(I-(;#=*>sCYEvM%M8MwPSRcS6V:Y7[._gaTaq$(J7D7V<a@!@>B%E#J^JtXPY@[&^Qd<eYi|jy$(K%o'r0U8+>(K8M9O"P/U7W3[s\>babbc{gxh9j>kLo)x+z:$(L2u2z4<4^5x9c9d9eANJ!M:Q{V@VyW"ZRaC$(M"r#X&w-)-a3'3a;XBDGlJmKxP6Z]\m\qeF(B")
(qdv "wen1"	"$(I-$<kA\D9G|S%]p_*$(J.JK$eD$(KCcFAqWrk$(M%C(B")
(qdv "wen2"	"$(I"l%r3l7=JaJvP"R^T6V9_`$(JD~$(K#oKR[pn?$(L-"DCDF$(M3$O{Tsbw(B")
(qdv "wen3"	"$(I*T8I8S:7@wOWR,$(J,7$(K)v,~:p;%H~O,[(qL$(L-*FlVt$(M0f(B")
(qdv "wen4"	"$(I7#;oCtX1$(J,h7.DX^Yig$(K69i)$(L+\-]6';";#>|ABLd$(M&2'0.CNC(B")
(qdv "weng1"	"$(IB`EHGAYB$(J<{R=a{h=$(KB`C\X+j](B")
(qdv "weng2"	"$(J.f$(K,|or(B")
(qdv "weng3"	"$(I+d:SI)$(J`$$(K3=6j>da=eojl$(MO3(B")
(qdv "weng4"	"$(K78b:n*$(M[{_:`a(B")
(qdv "wo1"	"$(I4_6r$(J?Sif$(K9o$(LAu$(M,qCa(B")
(qdv "wo3"	"$(IC/$(K!F)H9)E-Tp`F$(L"t$v'j'l+UE?Fw(B")
(qdv "wo4"	"$(I*\5|AkR}TO`[$(J'O-H?YA-FlS`V'$(K$T*cGaIMSuf{g6$(L;PA<N:P{P|$(M'>(T;m[L(B")
(qdv "wu1"	"$(I#d$#:`G}$(J"k4VD!FbKtZd$(K"W<}@]B*H(d;dBrQ$(L$h:`>j?.@]^fcp$(M$N-Z7(?;RfRh(B")
(qdv "wu2"	"$(I!i${$|*`0<7>8[D]QdW)W2Y}$(J,g,z.!4b@\Q:W<WdWuZ=\L$(K:3ADB+H"I>J"P}R6Ydw"$(L!R"^&D*X0N296~8G9KA[D+T`bPcO$(M'^'_*F*\,|.^4vE^LlRcReX"Yp\B(B")
(qdv "wu3"	"$(I$M)>)D58=8KIO(P5$(J"0%=)Z7QMYV`Y"Y5`nd-$(K-a>w@+NXS2Sddme`$(L!#!J$b'N3s3vU6YuZs$(M&$4E4F7T7n;}?~FiJhNDNEO*WoX3a9(B")
(qdv "wu4"	"$(I!q,s1&1';.@`B6EBGpVt$(J$x&P'p(S*Z+2+5,E-J.75|X,YXh&hU$(K'p+@-!4'@5ApDtN~U:VMVRXi^*iQlUm#$(L(")P-5=mHlN3\;c6$(M#W?^@WDHDYL,Q2`l(B")
(qdv "xi1"	"$(I#6#g%j%u&.)P6+7.;7@GA!D!GRGrI:KZPxPyP{Q\Q`S0UXUZUrVMWqXTZ(Z=[G[d]I^A$(J!O"T$K&o)E)s*P-!-)/G/S/z8Y:=;!=o={@WBABQE=IjJ(K8N8PZRLRTTNV$V@VOZ.\^_F_P_e_ha7aAaBaDcef>iEl[$(K"<&Y(80&1G5t=0@KAgBVC:EiGzJ1SmTeYkZ;^>bXb[dugfi;kvl#l,l2l8lJp)p5pHrPsZt+w3wJwhx.y&yS{t$(L!A$'&;(.*!*1+o,00Z7P7U8g?&?qA6AjB"BIFLFiGiI$IlJ=S`Xfalaw$(M!g%N&V'R*a+?.;/W2%7t8S:a:b<&?_?j@{AeBpC>D+D4F_F`G\L5VG\]]r_\adc1(B")
(qdv "xi2"	"$(I5%5,5=7;<'<rB7DAFWG?G\N[$(J*`0u0w8(8E<c=qFCN<N`QJX3XS^[^nc0dGi2$(K*!0m3!62CBC{DLGiPAS?TwU<Vf\N]$`"f\rfuDuV$(L*)/D18JJQwYe`+ccce$(M"}%f.U.]5j8Z<!=XKAKKL|L}V*Vw[kf,fM(B")
(qdv "xi3"	"$(I!)4`D,L(PgP}TL]9^._qal$(J.*<?C<GRKne$h[kt$(K%)($*D5h=#E[IuI{MyOyWCY$$(L'U.;4=>gGRN&Q~`;a\$(M&D)$)M7r<"M`PWQASndo(B")
(qdv "xi4"	"$(I#k,S/>0[4793<#>8>IExF+GqGuJFKEMtPmSETGVL[&$(J#-#J'i)q,K-V3X4e67@eAQE]FjGCH)KRR4RMS?W>c1fHfNiZ$(K"9"B&W(j(y){*".{/f020P1E1m9G>aB&DbESI#JRKkM5RPS<[q^J^S^]agnnqFtq$(L'9'p(D)v.B/!727^8(<Z>a>bLlLpM(M^OaOsT!TSW0WG[*^qbFbM$(M%+&c&m(G*w-:1%181:2z9~I;Q~WY^s(B")
(qdv "xia1"	"$(I./9*?l$(J0Z64OjeL$(K*^+a-P./L=yJ$(LS'Si_F$(M(=J5J6LFP:(B")
(qdv "xia2"	"$(I'I'~,>-^-q6X:0>yDCJ;N'YC]r_]$(J#<&J-W4=4w9(9-=6=|?^A(FUH1T.^E^Gh]m4$(K)_-<556f:(G0K)O.VWY\bWelf;o4q2$(LI,aH$(M#nDjIdKhTx_G(B")
(qd  "xia3"	"$(M4q(B")
(qdv "xia4"	"$(I!%#:*k.,4mH9$(J'C,C2IB_D)H'QrV3$(K'T9u:&>o^Lrd$(L!(QYZ7Zu$(M%$%V7F8D:E?8M\Wn(B")
(qdv "xian1"	"$(I)}.S.t/=7m@1M?\w^R`!bA$(J$/)G2R515=7K>*AZC@K.VbX|Z8[w`paRc!cff/g*h~i_idjajel+$(K)C+G-N/tC%J6P9[Fi\l1p9rbt/u@$(L+E7Q</B`BzN0N1$(M(1<y@ZGAGJGKWLaOaP(B")
(qdv "xian2"	"$(I&Z2#2R52:]<.DlK\M=Q0QLS!SCU\Z~^f`l$(J1G1s5T>!IpRCZp]+_]bBd2lj$(K!G#=.(2F6KA4OjQ<W;]4d<jwl&m-o8txuU$(L'R(w2;919q=|?QA>ACADHYJXJYO1O~P!$(M$q.{.|/^/_1B1f779K9_FgN;RHTGZ<Z=(B")
(qdv "xian3"	"$(I)',g1J1U7L@xDRMeQuXCYX$(J-iCnHdJvPUc8cZd@ht$(K/S0#?lS_`Wl)p+pNvGvL|5$(LL:^jcv$(M@NKsNBQ>QCYg[w\*]EeAf.(B")
(qdv "xian4"	"$(I,J/w0*1>4!458@>,BaEAEtHnI`J:OaQ1Z%Zw[Ta'$(J#\$e'm:B?-B/COIkImL3[R``b`gTh|jhm,$(K.".'2]3U5P?hAdC6L9P,QkV[_Re9e;l'vOwMxM$(L4x7jF"O)R_`d$(M%*&_*k,Y-i4559A|D[FsN\Q4];`3(B")
(qdv "xiang1"	"$(I4X9R:&?YE%^!$(K&;9nCSGPfBo2$(L_k$(M6h>eC!E6UTUUY,]Ja+(B")
(qdv "xiang2"	"$(I'G,:1W>$Dk$(J@tDrLm$(K'5)F*<7q;9C@`\$(LM!$(M+r(B")
(qdv "xiang3"	"$(I+&+a>gKcPAWEau$(J@KF=W0$(K7/;0?:M/$(L`,$(M"3+"5hA*V.(B")
(qdv "xiang4"	"$(I2AE"S@[-$(J3A7L8idq$(K?~W^X{h]iSm]nAr)w4$(L9?9A>xBnGlO#UJZrc@$(M"2"Y2=9=O}P\P](B")
(qdv "xiao1"	"$(I$''v5*6h7-<^=YF*L4LcN&NPUoXu[W^&$(J,F,u2S4<<\?yDgI^O=Q6Z4_9_S__b'b2e7fMj@kol}m/nV$(K%'++-(.\.^7J:FC3J#J5KVL]Lp_je[g%lO|-$(L+a6l7898@O@PA&NqT}U#$(M![%.,].v8T?}@9E#^za$e|fL(B")
(qdv "xiao2"	"$(I*j3JNn$(J$2.}/$Abd4i&$(K#q2\4sChW[$(L:dEp(B")
(qdv "xiao3"	"$(I''<$Z>a!$(J7vB*Hl$(KGq\C\W$(LGsV8$(MHF(B")
(qdv "xiao4"	"$(I'`+[/M@PF0QFXRYP\A$(J"4,@.vB?[Q[Z\X`zd+dn$(K/e@?KW[ycDg-ij{^$(L6TC~Km$(M%O4Y8=B'K+M~(B")
(qdv "xie1"	"$(I+{$(J,w$(K%g96:E@`XK\<i+l_$(L'"$(M/w:fOwY"(B")
(qdv "xie2"	"$(I"-#+#s,`,k3O3s:->7C`DfSsWr[`$(J(A4f7Y<V=PFFG`I|LpNaSRTbW5[h^?g(i4$(K(~.T.]?x@)F\FuMEWsXr^f_S`Sc%dIi3jp$(L)u8U:S<"P;Rm\k$(M"v.H2d2h308]=\>-C~_I(B")
(qdv "xie3"	"$(I!zZ}$(JiGk'$(K%_L1h%$(L&x(B")
(qdv "xie4"	"$(I)<,81q3r9{>*BBLDN$PDVAZl[+a0$(J%W&E(y+~-6-h/<0d1R4T8m9[;k=3=?=J>9A/C3DIF}H2J\RDRfTTVcViZh\Q_?c?fQhqhuj}k-$(K1f5^5y>F>Z?;DmHsH{I+I=X*YK_F_~dZfngagukpm0p'p]q-tdwmzJ{($(L,R/v4m:Z;2>OBdFvOJQeSPUvV[Z-]n`4aqbadUdV$(M!A$d$u,@,j.T.q///e5H8!F]F}HoJ.KlM5MQMZO]O_Wv\\_$d=(B")
(qdv "xin1"	"$(I'5/V095y=FG1LUPTPUR-$(J!6%?/y$(K"{5{7@;_HVS4[6u0$(L!~.6<H?DEOY*$(M'V/o6&F6e*(B")
(qdv "xin2"	"$(I:hQ,$(KE&R0W2$(MD*(B")
(qdv "xin3"	"$(I_^$(J96$(K6,(B")
(qdv "xin4"	"$(I8A8j9"I]JfOh[e$(J!0!Y$v*H/~4FdH$(K"o$J>BC*PbT@UkW<pt$(L!S6XMPO&UMdA$(M+/KuO;(B")
(qdv "xing1"	"$(I1QI\N\S}ToVg\s]q$(J2|<[DVL!M=[}ci$(K7.GvH-IXJKO[OuP.VK\!\fj%$(LB%Ze`t$(M"0-\@pC(b>eG(B")
(qdv "xing2"	"$(I%2'\(l,R/<4(4p=r$(J"<(e*=Z2$(K(x/[069a;v$(L.x60<jB!F'KR$(M*7*8(B")
(qdv "xing3"	"$(J=nE@IC_2$(K8RIp$(M6S(B")
(qdv "xing4"	"$(I/\D4HhNhZ1Zx$(J-.>a?%?3U?$(K'A)aYP$(L+$-)5(A7B'JoL*U;$(M&g(q1<1=fT(B")
(qdv "xiong1"	"$(I##$z&W3R9%Da$(J&w$(K%]0;jR$(L+A-nA,E7M9XC$(MK/UZ(B")
(qdv "xiong2"	"$(IEE$(J@SO<j0$(Km\$(LD|U&$(MaH(B")
(qd  "xiong3"	"$(J+9(B")
(qdv "xiong4"	"$(IFF$(JY#$(K)QA?ya$(LWUbK(B")
(qdv "xiu1"	"$(I2*ICJo[D_&$(J#s(?)~3B?QDdNbU,\$]z$(K,c>V?$F_S6S9Yy]h_Ef@k$n^t4$(L%m2-2g;1?cC9C:CcE$MMO$`o$(M%('5>9>X@@NV(B")
(qd  "xiu2"	"$(IU3(B")
(qdv "xiu3"	"$(ICf$(J"|$b$(K)jI(po$(L(5,@(B")
(qdv "xiu4"	"$(ICiM:NaOPUz[J\ka;$(J.kI1$(K-Jg)x}$(LDTQ2^cb)$(M&++ycF(B")
(qdv "xu1"	"$(I*;1g4@8a8c;_F3Zh[5[ra-$(J"P$n(Y+?-^3U:]KyL<WRYy\d$(K"c&F5/5J8^9|:":x;mH>K@LxR4\VcLg[it$(L!c$,$r+_,d-<-=-mArC8H}JFN!N=P2VK_H_zb#$(M"*"/#x%1&?+1.k9tALARA[A\J?PpViX((B")
(qdv "xu2"	"$(II<$(J:d?v$(KJN$(L.8:n(B")
(qdv "xu3"	"$(I+2HJ$(J#x(1EVLkle$(K7kA[GOVmW:XqyE$(L%lA:D}`/$(M#9#`(u*++^,B;zD0K#(B")
(qdv "xu4"	"$(I$O&L'A+P-}/%2=4$67?\DiGHGfH1I&J?MUN"O~U8$(J#m'd)<,P4D9N<_>q@k@lA7ByHUSOYPbge!e-eUgYh/hB$(K-~4o5#7!9Q9g:I;y@t@wAzC5CzHdI.JoNNQ?TiX<XS^,^hhVnXrJtX$(L)5)Y<i=N@DG8GQX=YLYM[xcE$(M"L0IB5IHIMLTZn(B")
(qdv "xuan1"	"$(I"f#9%6&,+B0oBNH:H=M\N2UJV+VS\v]x^($(J(p2<6t7'=i@gJ"UM_ddMdTm"$(K+I-L8l=gO#OkPqPvVAX6dFiLjtqf$(L6_EGPVPfQrRuV_W2`Wb<cS$(M406w=9?@DrHrR5TJTmY<dD(B")
(qdv "xuan2"	"$(I2$L@QwT|\F_o_|$(J#K+H/t=@LVNmQ;XWfRlQlT$(K"'#H$]04EVK6K\L.^:p-t1uN$(L,u2J7x9U[w$(M;>GD(B")
(qdv "xuan3"	"$(I4&$(J9OJ4S^i#$(K)):oDlX/$(LAHS=Y/]V`N(B")
(qdv "xuan4"	"$(I(w0+HlXYa=$(J/-CYH:\j^:$(K'uD*JCYJ^wihsyvP$(L4q?x@iC[VFX!\cc,$(M*{176$CNDpDsDvGUGeJWT"a\(B")
(qdv "xue1"	"$(IS'^t$(J!v$;Og$(K*gzo$(LaJ$(MIKO`V+c"(B")
(qdv "xue2"	"$(I^p$(J%1&#7g9:@T_}$(K2mbh$(L'y+mNg(B")
(qdv "xue3"	"$(I[X$(K.;(B")
(qdv "xue4"	"$(I1X21?kSR$(J#S%f&X*[.L/2/^4&;)ArWL$(K'j/b3{59;n@(W1mpn(o3$(L#7]|(B")
(qdv "xun1"	"$(I,GM,V,\~`x$(Jd;f!$(Kzw$(LTe$(M"A7"9'I'P$P%_n(B")
(qdv "xun2"	"$(I&I1n4C;">qKWM@M{Sk`e$(J'@+v-b3I:pJaMG\]$(K)R.DBFD@FSSBUJ``c3l/qGz,$(L'5)p)q/,:_>^J3QyRhS3YIZ5$(M"k({3J>VAUG3G]IRITObU=_Ef/(B")
(qdv "xun4"	"$(I"r,N-t033|464}?'DbIpY~\Y^d^w$(J$U0"Nf$(K@/Khm9q>yq$(L'X(x.?/T0p6=?fDxFVP(YfYg$(M(w)w*b7p:ga?eU(B")
(qdv "ya1"	"$(I!7#/(e)_2~\%$(J!q!|+m.<1.?:UtZ[bX$(K@|auyj$(L9lPN$(M+t6I6XEXEh(B")
(qdv "ya2"	"$(I&+.Y79Gc$(J*k.q$(K#hKTQg$(L."9CAcK/ZI$(MWC(B")
(qdv "ya3"	"$(IB}$(J,..IMz$(K@fBzS:$(LKscn$(M9I(B")
(qdv "ya4"	"$(I$B/DCARr]D$(J!F1_89;W?4fzl7$(K!#!E"~$u1~4/6&9';L<y=Tmcz4$(LKE]T$(Mf$fA(B")
(qdv "yan1"	"$(I2-25NWPiUm$(J0V1b7&8u>K@"EXJ}XR[+i%$(K-w.4XT_a`#fIlNv[$(L*89:9EG@GDGzH4I#JyTuTzZ|^>$(M!L!R$I/f>zDKFy(B")
(qdv "yan2"	"$(I&],+5"7<;3=X@ZCKD?D\NTYV\>\I]k_8`.`0b?$(J!k&a)e4I4^7u?"I-JyL5M&XLY8ZY_{a?b&f2fXgfi*i`kjk}lmmJm\$(K'x2:3/3qNBV5g_haj{kBm=pLs2stzx{@{b$(L,[D{Uqa)$(M"d#0'Q*J*K*M6[9,F:K.L)LqR|V7WX^T`ra-b4ccey(B")
(qdv "yan3"	"$(I!>#q'R0L164kC.DyKkX#X$$(J"S"U$f%0)()\+!235k5v7m8[;6=U?EF.FNM*Syg4lM$(K"^#(&)+V+o3R6d7j9v<(?`@TE0F9FlGjHQHpNRN^QJX_Zs[B^ob'dyf:gyhIh[h\mKo\tHu1y1$(L9P?IBBK{P#U2V&_C$(M(:/.:I;a<{<|==ESFNIgK<Q.T!Vm`$`\(B")
(qdv "yan4"	"$(I%Q,P4D?sEfFAG3QeTmYLYmZ|\D_Rayb!b*$(J!X%~/u1(3^=~>HH&HpMZP.Q%Q*TW[CdefOnZ$(K$Z+j2O9$CxD5HUHaJ@OsPwQyS|[_\#`*e^fcg&kZo#pJzczi$(L+;,r2a@qD\F%G+HOSuXI_aa*cl$(M%Z*1+$.V/N@e@mL>SZWd\ge\(B")
(qdv "yang1"	"$(I'p2_2qK$$(J"N':@9UD$(K'@<EURs-$(L:A(B")
(qdv "yang2"	"$(I';'=.]1OANDGRiS"Y_^q$(J$l({*~,s.#=BClEF[z\"eW$(K#J%7/w0W:z]sc7f!jqo:u,uW$(L/a9(IrT_Tc]W$(M"E*P*Q9JBgDJH5Uqat(B")
(qdv "yang3"	"$(I1?A*B)E[OnZv$(J4\69A_At$(K)M0s6@<KDgL*L+RIRKScWE$(L8$;`@=K`$(MTk(B")
(qdv "yang4"	"$(ILT$(J;0>SBeCDH\^XhR$(K$65\6#=bG3Qddf$(L:sT9$(M;wG^(B")
(qdv "yao1"	"$(I!=#<)HA]C>P$]{$(J$'1+;XM:$(K")"I&$+/2~9SPSXP`6$(L$8$P1}J/P.W!$(M(x)t=>Li(B")
(qdv "yao2"	"$(I/G2}7r9!9(>dAEG4H#J[KhM[[g^X$(J*d,4/)<,D+KEP-Q>Y!Y*Yff=gUi6iR$(K&O,s1l99:/<s>q?oG,L0O$QDV^Z<^Gbdd6h_$(L)s-a7v7y;&DhDzEYFTKPMS]1$(M#y%D)r,h-_0p7s8_<'<Q<cHgS5UObq(B")
(qdv "yao3"	"$(I"k(Y,0;(H7Vm_>b+$(J"x%|(r*s3r;h<s>-H9HaJ1NwO"UcZ3$(K$oInLUO&Rt$(L:L;<;=;AChG;M]W'$(M'F-#>/>4LgM3Zl(B")
(qdv "yao4"	"$(IC"GhV0Z``4`{$(J(uFaOWQ/WQ`2hym*$(K#Q#z&#=]=d>7D\RST8`Ocjh7hEvwx/x=$(L07C)IpLWQ}$(M!\,v-!;f;kBFDVH4N5RUWzb9(B")
(qdv "ye1"	"$(ILu$(J\U$(Kn:$(L5"$(M;D=}Xz(B")
(qdv "ye2"	"$(I0_196Y?]Bp$(JNFVLYG$(K0%AEo'$(LAYD$MzXz$(M&J(B")
(qdv "ye3"	"$(K!h(4,a^3$(L!Y"2#8GN$(M!x(B")
(qdv "ye4"	"$(I%v+'-.B"BTK)L<P~QaS3ScTrU,UVWlX6[~\W^}`aa5$(J#6+f-Y0j1E8fK>K{OlP\TFTSU"Ye`fgChSlKlXn[$(K$F(K*91g2Y8*?YAJDUEpGZH*OJOVTWW*W{[:]P^)_W`ibff&f5hAhTkSmTuX$(L",)Z*T4{H?JKaI$(M#_*R.Z.~/Z4b5$728I8d8e9-K{N8NPPhSbV!V"XA\#(B")
(qdv "yi1"	"$(I!d$v%C+~-D5h;LKVNyPMW$]+_u$(J"%+Y-P/n5D>sAeJCLJLuQIS!Uz\H]]g|k.k`$(K#W(h:,?tE^Sk[J^8f|kzonr2r9{u$(L&a5I>AC|HGNLR|URUyZn$(M%8.`0Y<s?"AfAjEtFHHnMvQKS|V\`paK(B")
(qdv "yi2"	"$(I$W*A,3-6.v1)2e5O9}:vCPE^NJPYP^SiTXWda6av$(J!#$q(v*2+Z,*,d.K2o3/4#4E9!;C<+AKE;HPNOTpZAZLZOb*hnj|$(K"-"w#"$Y%#'{(9(})X*&*:1Y609_:k=L=l?.?yA5CdEJFvIsKEOxPeSZX~YF]W_sk*lcpSxVyLyi{Z$(L$<&/'m(N({)E)X+Z->/?1D1]2S5_6d8V:':E=%@\@kBDKSMVNpQ]Q_V%XR\,\Nand9$(M(}+&+:2r383H4H4I7u<3<4<bOsPlQbU;X#(B")
(qdv "yi3"	"$(I"/'&'h,H.x6;7x;yJwO3PrSGW.Zj$(J#V5h=<?5YFet$(K!C$H'L)4*=4(5.DFL5LiVg$(L'i(^)]//1e=&$(M(E8,BoMKY&\zaCe1(B")
(qdv "yi4"	"$(I"q"t#J#e$f&A'q'u)")h)p*B+_-P/R1_1r2n4+8V8m8z9,9/9i:$:l;:;v<*<d>0>c@*@c@lCICND=D^G:I~L'L/LFP<PNPPQQQ{R)TqU+V'V@[w\$]|aGafajak$(J!!!W"="o'=)0*5*K+F+z+|.(/3/g1M1k2P2Z3t4l4v5M6U7"7x8G8R8`9q:5<>>w>{?NAXA~B,B^D0F^GSHoHsI*I3L>MKN.NiNoP6PgPwPxR?R_S9W~[u[v\4]3_'_K_x`,`Ia!c<cCe,f3fnghh#i]ipk6kFl"$(K!D!V!t"]"a"e#_$.$M$e$t%%%<%b'V'Z([)%)')6*|+%-:/B000A0n1y4;546g7T7v:::Z;*;|<.>{A^A{CRC^DTE1HjIVNQQBQMQYREROTxU)U;U[UpVBVLYZZ?^2^4_`_ga@c+c^dbdqfwg+iPlQoyq'qRq[r'rGs*s^upv{wHwKx5z0$(L!@"!"f#J#z$V$d&T&l'J'O'f(p(v)H)m+&+1-I-_-k.).*.\0^0y0}1U3r435+5U;z<0<\=O?e@rB5D?F-GJGrHDKHKVKfL,L^M-N?N[O"QLRHRXTmTnUiWjX)YcZYZdZy\_]y^r`O`ba'bBd(dN$(M!S$C(N(O*A*W*f+h._0d1d1m3x5!6J717O9#9:9D;W<j=R>;?*@1AnC?DIE_F)GLH`IFLvP4PeSJTUTrU1V3VCXOXm]L]a^$_@dE(B")
(qdv "yin1"	"$(I'>+o-M1T5<7d7j=u?q?uB9D7JBMuObYN$(J!o%B)T,a:0MASrT:V-$(K(\1`3B8%;~JiK!Nw`rk^$(L/d/j/r213(4v6?A.B&DYP3QURn$(M!J*|,40]3W5:7XF,FGKEMSPvPx(B")
(qdv "yin2"	"$(I"B"w&m);-F2<9)BGC6EQK?KNM5O_Z#$(J','4'r,c4q;f>|BILSd:$(K2(98;p<xHEX=j$s0$(L+</b3X666];p>}AxQ!Q#QtV:[a$(M!H$f*<,X73?,?KB(Q%S'WE[8[;ci(B")
(qdv "yin3"	"$(I!?3(<]JDLhTUW~^5aR$(J!$"u'sIQK]`4cBc[d$gSm.$(K0[4O6%8A?jd9h6l$x9$(L#!'n,M3dPFca$(M#|*27c:@<RATMUM^OpZ"]A_[`%`gei(B")
(qdv "yin4"	"$(I6sPhT_U1WB$(J'k+g/]5B5C>}CCCHCpD@IoJ)O]S1U9$(K68<jB%RZUiYj[W\*a(xy$(LA`Cb]5_7`q$(M*y288mP&(B")
(qdv "ying1"	"$(I:b;9AvECMlVe\:\;_jaQa\a]$(J"O.E;^ECSZYOddjvj{kJnB$(KGkOpXBa8gBlVo+pDsasbsgy>$(L_N$(M%]*YA"I*KS]e_XbAc6(B")
(qdv "ying2"	"$(I&x@6D:IKMyOJQRU5U6^3_Wah$(J7p;_="KM_Tb#bScAd/fag:$(K:'A}NJNPW/_Nd%m,s\vAvE$(L#MG)H0VEWH$(M&P-,2/7JM|N(OlU:(B")
(qdv "ying3"	"$(IM6R([h\<$(J%*0Q9E9R>)e<g#$(K8)G"Jf`1`If6g1p4$(L'SCrP1$(M"l$>B#E(Skc%(B")
(qdv "ying4"	"$(I%wA[N:P?ZQ]3]5]E$(JO~T_$(KUh[M[aex|P$(L*($(M'L@qG'H*JKMFMG(B")
(qdv "yong1"	"$(I@mBHJ@PG$(JC:L`QP[i[r[ya%n($(K4.<TTRiHl7mlt`$(L0U_!$(M,?3.3/E2FLG}H+H{KcKgQUR~W&Z'[yd'(B")
(qdv "yong2"	"$(I9CFUTFTNVX`"$(JC;DjJmXO]fd}$(K5dM6N5VIr]$(MCCDzL0L1(B")
(qdv "yong3"	"$(I's5z;Y;]A$A2AJBMFm$(J"z(K-N9T@_$(K-]6-<$>?R'RfXU`+q`$(L#_%+*7/%1>6#Rdbo$(M(,4"8(S(SDVFWw^W^ick(B")
(qdv "yong4"	"$(I%`$(J+:$(K#s.yx>$(L#k'1-+---.9\Oe$(M,=(B")
(qdv "you1"	"$(I<U`&`P$(J!_"g6`M4_w$(K"G$R&%9m?1a[f7i6li$(L)|*.+l5j?tG=\t$(M6]<[?XRKSSWQ(B")
(qdv "you2"	"$(I$o%M&i'2*Y,Z0F0a=J?UGeJdS|^4$(J(++y02=e>y@1G8GjLeSx_I`&c2c=$(K#m$c&M&y'm'}(]+T/n5a<uGMIFI_O4W#WGYvZU^E_2_6f3i~o$$(L"j(c-{.R/A77<]ETEUEWL8OIWdY=ak$(M$E'l*&6j7:7;96:s<dB?D-PgQlSNX%(B")
(qdv "you3"	"$(I!_-f/{3[6W<Q=gM-$(J#5)u/03K8<@YHYV&ZR$(K'G(Y)P)k.kDdF]P*QfU2Y*c_j(lh{f$(L(1*/-x1{6)7:9~=aM/M0Sj$(M#w$m%#2J8`(B")
(qdv "you4"	"$(I%t'd)$*J7oRm$(J$Z$`6.A&A:AgUH[g$(K,o3O9@K]N!^}rCrF|O$(L"H"X"k"x,t0kF5G!Y[`Ud2$(M/:>>E{R)T)[va>cK(B")
(qdv "yu1"	"$(I.U.|B([l$(J"]%#H,H3N@R%$(L4L<J>'B?UH$(M*)GO(B")
(qdv "yu2"	"$(I!1#t&9&:&p+7.80K0M2C:c=CAyBJNHRoTPV2V]_0$(J"V&q'H)H*x*y/L/c0-0C1j4W7U8{9,:X;v;xA}B6DwL_LgM,O9QdVjYQ^B_8`(anbIf?fSiWj"jNj^m>$(K$0&Z'/'F)|*u+B0S2S8;:+?b@>HHKfObTCZ)[)[*^[g0m5m[o<o@qHr1rYuExN|!$(L%Y+[,s-:-;0t3^3t3u4Q6@6M8W8a8b;.B^CXF&F2J?J}KxLYNBS#S9S@T1TfTjXAZHZT_w`u$(M.@/I1(1)8y=AChRESTT[XE]\`zax(B")
(qdv "yu3"	"$(I"m#_&T+5/94*;!JJN4TZTa$(J".+w.+1r<*?kO[SJSvTMY`[)ah$(K,8.p/~919MEGO5Y5^!kF$(L"O$G$H$c'H'I+/+D-W.h3M5>@9B4F1FRHHHKV"W:]E]L`z$(M!0(%.S011p1q7_?ZE>G:XV_1_s`W(B")
(qdv "yu4"	"$(I%|')+U.C/L3Y5j6S9d:1:B;?<y=2?1BzD1DMHzJ/O=SnT2TbU]X>Yp]O^+^m`?aAawb($(J#~&?+R0.0[0l1"1%1A5f6\7G8;:Z<3=x@?@U@`AmE"EAEjF$JSKKKkN%P3U}X+X^\o]-]6^c`E`lbicPezf8iHiuj4kD$(K!L)5,^-W.i0q1o2U3$4m5:5m7a8m;,;:<V=!>'>/?+?\LAQ.RHReRgTTWWY&ZCZu\1^g_v`0`fb+ePf"g=kEk\m)m3nQn_p7pzq{uvv5yu{={?{P|>|C|J$(L%8%A-i/;7O8|;v=:?Y@BA*ALFAFBGcJsSUVWX+YDZU\(\i`Saub(c)cr$(M#v,<,w-5.$.&.0.l3O3t565d6E747<8G8Q<p="=+=J=W=^=t=u>B>UAlGTRASHTEV6V>VbWfYj[&]t^@_4a_d4dIdxe7eOeheuf&fR(B")
(qdv "yuan1"	"$(I%,+@0&5A6w6y7&8h9wa`b@$(J&7+r92N'Njafau$(K(P---81|2J<w?OLXQc[}$(L)f.|.}9#9+NFT8$(M6UR7e3f@(B")
(qdv "yuan2"	"$(I!N/"/.:D=.@(M~P#V-VPWN_1$(J(U0h<~=:A$DbO7i<$(KGDV\a)amd&k<re{+$(L(U.f/C4M;lAtFY[9bp$(M+k,83b65>N>iK!ZE_Kf3(B")
(qdv "yuan3"	"$(I3@?T$(KD0f.$(M"o4A(B")
(qdv "yuan4"	"$(I)K0|3qJ#OjRe$(J638B;3<`Twh%l8$(K81AKBdC/H2O%OEkN$(L#&%I+O/:69=9HuNyY<$(M3G[R]O(B")
(qdv "yue1"	"$(J;'I?I@$(K/l6JEYKsuo{E$(L/y<+$(M8^(B")
(qdv "yue4"	"$(I%N%a)I1#3F3o6&8|9=9D>#J6U;W_$(J%}&.)K)w+O0K4+4:9@;L?o@GD`HTPeYt[c]7a3djhcjil(l)l,m[m{$(K)V/G5;6"8j9TJ8J}K/MzPNSrViZOeOg*i8l!lyqQvHw^x${d|$$(L"q&6'3'4(7(s)V0F0H2$<A>&C/QuXd$(M7gBMC$HeN<X/Yq^w`|bHdcee(B")
(qdv "yun1"	"$(IB*I3$(J^`$(K7<>SQZ$(M&1(B")
(qdv "yun2"	"$(I!V'6.B@pA)ArBSG>IAQ)XK$(J*e/:$(K,h0b5U>1$(L&q;7B*G`MtaZbl$(M1]6oFO(B")
(qdv "yun3"	"$(I*+.):*?dMKaS$(J(&,,/l668}GZIvK6Klj/$(K(B+!R=rr$(L(\cU$(MU}d>(B")
(qdv "yun4"	"$(I#S%&%I(D;/;bCvEPRUS/$(J(7O;X-Xh^;mC$(KT4X0hyo!ros3$(L*dY!Y?$(M#U5,70[2f4(B")
(qdv "za1"	"$(I!c&N*r$(J#Rhp$(K1?IQp3$(L=v$(M?+R{X)(B")
(qdv "za2"	"$(IENJITYX|$(J;tAcIMO*UufKi7jC$(K2ld,iiinmbsOv-$(L)l$(M*mJX\(_+(B")
(qdv "za3"	"$(Kfy$(MVt^"eP(B")
(qdv "zai1"	"$(I&`2/$(J$T@3$(K9/$(L!m%46(Jx$(M&I'k(B")
(qdv "zai3"	"$(J+;FSRZ$(K?FF`FaF~nf$(L.e4>6c$(M"5(B")
(qdv "zai4"	"$(I"{#o'JK'$(J!]Py$(KC"CFRkgA$(L>6B+BsGW$(M"!"R(B")
(qdv "zan1"	"$(J!=1=I;N=Rd$(M&K(B")
(qdv "zan2"	"$(K_0$(L=5(B")
(qdv "zan3"	"$(I'P-NL0TAWn_G_f$(J<q>rN/e9m6nI$(K9jCLEUbF$(L7~93T5$(M##S@]Tbv(B")
(qdv "zan4"	"$(IN~X(Y<Z[_b`waI$(J:II_]n`Gczhejs$(K#5GwcEqPr&{|$(L3U?R$(M.}9x?)CUT4]U(B")
(qdv "zang1"	"$(IA_DgaN$(J$+//$(K-A3Kh:lI$(L(Q:tA\C<GMVZ$(M7ACI]^(B")
(qdv "zang4"	"$(I@^$(JNE$(KJP$(LMmWM$(MOF(B")
(qdv "zao1"	"$(IM!Q4Y'$(JC/_m_o$(KUs$(M$(CyWM]+^x_ibKcz(B")
(qdv "zao2"	"$(IY=$(JN4$(M<]UhXg`vbu(B")
(qdv "zao3"	"$(IV7Xn$(J%3SI$(K+Yi{$(L)<-2.%1h;i$(M$aTSXl\[(B")
(qdv "zao4"	"$(I&u6QD&V&^I`c$(J,($(K.H163NF'dG$(L6eD4Q7c:$(M/QHDJd\/`Y(B")
(qdv "ze2"	"$(I&16m:9NjV!]n$(J17>6C=L)LWM2QTQ_XZe.$(K">,\2%:TMnV-ZV]7]whejBmxnJtf$(LBvByB{FkXUX^[&bic2$(M!:$}+{,I-T/D3n<ACQHxI^MH`B(B")
(qdv "ze4"	"$(I"X)@$(J$O+{$(K-32u8k?HA2$(L#{(e+r+t+u$(M7*(B")
(qd  "zei2"	"$(K[k(B")
(qdv "zen1"	"$(IQi$(J\k$(MAg(B")
(qdv "zen4"	"$(ISW$(KR1do(B")
(qdv "zeng1"	"$(IQZX^$(JI9J%Q)a:$(Kj5oz$(M"e.%/TA`(B")
(qd  "zeng3"	"$(K\/(B")
(qdv "zeng4"	"$(J]D$(Kxt$(MJNZKdy(B")
(qdv "zha1"	"$(I;mAn$(J0G3~@&BVCKC^DGE4J*JIf)k\mp$(K7{B:O}UlVC$(LSY[n$(M'9?dRl`c(B")
(qdv "zha2"	"$(I3;B\a$$(J&u<OB1LT$(K%M&c&e,!5=76=w?GDfJ&N$O]XVZRb;$(LAaTp[I$(Mbr(B")
(qdv "zha3"	"$(I[!_.$(J2s8ZEOL=SkYa$(K%AIvL;P|$(LKo$(M/\3KAMP8Voar(B")
(qdv "zha4"	"$(I&^+YC:RI$(J&<,I3p4-:mGHH8Ib^3hM$(K<kS"[l$(L!L8N8P$(M*'3E4S<r>D@ED,PcT3Y^(B")
(qdv "zhai1"	"$(I1@69:?$(JCwWinQ$(K7,Gojbl"|M$(L8,$(M?aK~al(B")
(qdv "zhai2"	"$(IX<$(J[X$(KLJ$(L*h/c0(^B$(M1S(B")
(qdv "zhai3"	"$(I(]E-EY$(J43Q1$(K'*4<D$SU$(L9M(B")
(qdv "zhai4"	"$(I5{$(JEiMT$(K:RIt$(LQN[b_5$(M%~0uC)(B")
(qdv "zhan1"	"$(I-B6>9h?3PXU-Z?]ma~$(J!D#rD%H7P4Z&dReflE$(K.BR~XWjZlpoOwUxl$(L82$(M8lFkHOKpUrUwW!W"]kakc!c0c9eaek(B")
(qdv "zhan3"	"$(I;8@hFVZ7_)$(J192EB@F)I#SBVBY/\5a9c3dVd_g^$(K<F[^[jb*bicce]iDj'n-qv$(L9y>{O8`D$(M(f7S8~BvVhY#[]]P^Z_%cm(B")
(qdv "zhan4"	"$(I,c8,AfAhBAIUKgQhX}$(J)|.o=CFqJ|T+eCk_$(K2?5O<+=\H\Q,ZZdSi/mAocp"s&tD$(L,4,V0h8[K$$(M#]2aF;(B")
(qdv "zhang1"	"$(IN@_:$(J=2M\T~$(KEedvnHu;(B")
(qdv "zhang3"	"$(K"r-[WUc<$(L"6(B")
(qdv "zhang4"	"$(I!D7!B|F;F_Qq$(K"K&<'7(B")
(qdv "zhao1"	"$(I(`-+$(JMsR'^0$(K$7WQ[b$(L9z9|9}@N]]$(M2#(B")
(qd  "zhao2"	"$(I7W(B")
(qdv "zhao3"	"$(J'|5PDiEe$(K!A!K$#^d$(M2,(B")
(qdv "zhao4"	"$(I,I6%CmH_UBX;$(J#L%U&g(2:-<->IFQQ$`ob^$(K.WDaQ6S^lzsL$(L"W"]&`*M9H;$F^IhVX]J]Y`K`M```a$(M0Q3r3s5-A$X7(B")
(qdv "zhe1"	"$(I6D$(J8k$(K=X$(LIs$(M)h)p(B")
(qdv "zhe2"	"$(I)~.R06:8O6OBQ7WY_a$(J!g#($|&v,f-#-4-Q0P0z4d<(?_@#J9R#T`Tx][i/kSl%m%$(K!W#[,p>EL8MZTOUe]Q]S]y`ce/iujXovr-sSv'v1$(L80<8?9@HL>M=MDS7Vd]P$(M#22g<=BZBbJ&J3S$SmUEUtY}fP(B")
(qdv "zhe3"	"$(IHH$(KQHfP(B")
(qdv "zhe4"	"$(I*q-;F(\t$(J,A4K4i?`$(K)s3(3?9*dLnIoX$(L;(^}_r`i$(M0)1h1i1j;<;=I<(B")
(qdv "zhen1"	"$(I%4-~0f1]7Y9T;p;x@gA4E9EII8S9\L$(J0$2O5y<I=ZD'D1EMR8h@n0$(K%6%T(U,C@;H4P>gCzU$(L"`1`4'@^D[FuG]W@$(M!*%F+K9?<:<MB:G4O~`Hc<(B")
(qdv "zhen3"	"$(I!u,#,|8=$(J&x.^.a3>4C9+;%;R?pAdHG`6gw$(K!S"1)m.}<LS$S3Sf^Fbv$(L#$#%+3,&9a9p:{C'CNN`NsO+OGU_d,d5d6$(M859GQzU.V0W9Xp\}(B")
(qdv "zhen4"	"$(I?y@]B5GOQ-YD[Y$(J*9*S2/25;zI"TmZ`ga$(K$p-o0i?)J>eig#$(L0Y2n@I@Z@_KvTvYR^`a"$(M*=>hU{fN(B")
(qdv "zheng1"	"$(I"e$I3a8#FdYo]A$(J)[+-+Q3V7{9o:C:c;]=4D\F!F(FgGQW6WMZ#bblD$(K%z)02d65;J=8DDF4HmQ`X#]X^N`$eCgKi_q|rV$(L)@*,+,,!?#IYX#]HcF$(M4]5e8}<tV9V;V]Z6dw(B")
(qdv "zheng3"	"$(I&6Fn$(J2"OX$(K$g?/CCDhNU$(LY)$(M#I$".E(B")
(qdv "zheng4"	"$(IKnOE[R$(J2[?<KwVsc;cH$(K2Ig8qn$(L">#6,2.5DOTFWh$(M'u4k9]=%IJNcNd(B")
(qdv "zhi1"	"$(I!b%g(&-9...@7f>T?2?vCdF:JcN|WJ_<a:$(J$=%&&>&y-?-t.z4]:">8G1NAXYZU$(K!?#Z$f$i'9*s.S0h5"5f6:;VCkI^I}S8VoZP^9dwk=xExF$(L!l)t-c-d-e2s2~3#3L6D:1BUE>F0O?UU`?`B$(M+P+x:pD5D6[0(B")
(qdv "zhi2"	"$(I#n/N4/92C9LjT@W`ac$(J&*1#18:?<.<U@BL[N$UjUmUv`'`taVari5i:$(K&q'o>@BnH;H}M{R7aAcpidlHq.t{uHyc|*$(L-D-E>,>@AdGYGjJ#M"SKSd[g$(M,i,l2-7B8U@FAXI=Q5Yx^<(B")
(qdv "zhi3"	"$(I!9#.%k)*-G.:3)3~8{>{]($(J!G"A"y&;1e:z?r@n@oDQEYMCU:UK]K$(K$)&r/}2j2p3g5(9[<#GQG}RNani^n7$(L"Y$z&0(#*'+),1-(0<1K2|CADZZ``8$(M*t066R\r(B")
(qdv "zhi4"	"$(I($(E0;0r5f7g8F8s;6<W>kA6CMJZMAMVS~V.[|]4]6^F_c_h$(J#C$y((/V1S1y4c595A7_7a9m:|=r?1A!BbBpF6IxI{POQ9QHQkSzT*WUX/XjYMZsaQaibdbhh^j!$(K$W(V*T+u-U3o4#4w5-5k6n798/:):Q=cAIAwC|E7E>EPEgFMGpH/LNM*M,Q'QLQRR#T1TuUcVrWmW~XwY/\'_)cqddfmg!hnhok>m|m~o(oZsJtEx^$(L&@(~)d+B+F,C-q-r._0d2:2f5L5P5T7!;8;9;:;G<OBXC^DSD`H\I=K7L-MJMKMUP]TETJU>UEVYVfWpXQ\T]*_$_%_,b2b>$(M!."#"^#3#a%R(*)S*0*?*X.-0S0b1n3j4%8/;n;p;t<W@QC@CqCvEVE[EcK3MTN6N{PIPOPqQrTpUBVQYMYVZqcG(B")
(qdv "zhong1"	"$(I#~$\)m3wF]T)$(J"5'w'})z.uLGW^]=]haOdt$(K"/'.*J=3BRsr$(L!Q#A%_.O7=9t?3?:?=H>Kk$(M#Z(FBUBeBfIVIh(B")
(qdv "zhong3"	"$(I:4A~H+$(J7I$(K+q>kj}wD$(L5\$(M'*0j9z]c(B")
(qdv "zhong4"	"$(I)\3k:f=v>jRk$(J"'"1#j/_797Xa8dz$(K@<S>T*XLXj$(L/Y0SBTGOOmZt$(M"=$;6sAIS;SRaG(B")
(qdv "zhou1"	"$(I+Z2+9O9`>SSP$(J%R/T3[3\:4EsQ[ZH$(K0'418~;1B|C;PtWiZ0hN$(L!F"E%c&**<,>Kl$(M3?9U9VF8]s(B")
(qdv "zhou2"	"$(I56$(K+'$(Lc+(B")
(qdv "zhou3"	"$(I*:.}<%HZ$(J'f)O7~F4$(KHXITQ7$(LKb(B")
(qdv "zhou4"	"$(I$F'x,77~>z?#D0H*JOMdR>Y)`*$(J68FB`D`ifo$(K).*H+m.!FnHOOXUuX,\s`%vf$(L+q86H=M6M@^yd)$(MDq(B")
(qdv "zhu1"	"$(I,f=)L~Sj\.$(J#F-01U9r@,A<JKM%[[bVbtcu$(K*;2y4EH!L/Qa_d`vdOfdg;$(L?]JDct$(M3_?ULtY=(B")
(qdv "zhu2"	"$(I"R-\7wa?aBb.$(J+70)6Z9wJ`X\b7dUh(mw$(K"O#42+3@S%T(tUx%$(LBwK?V1\K]q$(M&L&M($0}1"AKBYCbHaJYQ:^1(B")
(qdv "zhu3"	"$(I!"(L?"BXK=LqU[`,aX$(J%[&5.c5*>JJbdl$(K*%4H4`57K5]H^Ba!xn$(L,_C0U@UK\&$(M")-V.P.f@~FlGkSsdzfGfO(B")
(qdv "zhu4"	"$(I*$3#7t?.CTETOMSMY`$(J%;%e&F([++.G.l:9HBK|Q2^m`-`Wb6k%$(K&K)8*,-6-Y4R9K<dEDMKUbk{s/w&$(L3K8\<5TaZ:$(M&`'%,^/U8FEmH_N}O'PDRSSvXDYd\$]-a1bk(B")
(qdv "zhua1"	"$(I3d$(KBOHA$(M62Qx(B")
(qdv "zhua3"	"$(K.*7;$(L-%(B")
(qd  "zhuai1"	"$(LGy(B")
(qdv "zhuan1"	"$(IQn$(Jej$(K'M)$?Aspv&$(L$T$X){)}6vGd(B")
(qdv "zhuan3"	"$(IR0$(J(n83m)n&$(Kou$(M1Zbx(B")
(qdv "zhuan4"	"$(I&_:G:gD;Xy^L$(J!C;mEx$(K&J?_TrUY`Pf1m6v|$(L#y,]2L=+I7$(M3@:*G{OP(B")
(qdv "zhuang1"	"$(I#M0H3c=~C[Uu$(JS2$(KFoh&$(L(P9>>KDVX*(B")
(qdv "zhuang4"	"$(I&k+wa>$(J3!$(K.G3>:<AagljIyd$(L$3&hdR$(M[S(B")
(qdv "zhui1"	"$(I5(<6\($(J=TH*^6$(K>9$(ML@(B")
(qdv "zhui4"	"$(I3*>2CFX@^b$(J6T?D$(K+U<`?#A0FLP#T$\9`'eT$(L>Wb+$(M%\'C-"4}6T9n<2A^DLH8JMMPP@PmVP(B")
(qdv "zhun1"	"$(J7:SKSL$(L)/-g5m$(M3;Y6\f(B")
(qdv "zhun3"	"$(I9~_2$(J4u$(MF?F@Xy(B")
(qdv "zhun4"	"$(J?$$(M;0S~(B")
(qdv "zhuo1"	"$(I^Y$(Jd1i8$(K%=v7$(M$G(B")
(qdv "zhuo2"	"$(I(8)l-_6V7/;}=3C-GML2L:ODTkW"b:$(J!/#'.X1{3'7t7|9]:J=cB2CZHKKdK}MwPMTOVkWF[8[:\W^g`A`ki?j_kk$(K"h'h+E5_6';g>X@xB=H=I~L4Q#QlSsTVTcU>XEY+Y2_cbmf^fiq$q4tVthyU$(L#,)r/-0[1\5`I'I(I`P`PlUg`FbV$(M.*.N.O.Q.R.m?pA(C.F1G9KGT|T~Y7Yi]0`yb\(B")
(qd  "zhuo3"	"$(J+^(B")
(qdv "zhuo4"	"$(JI%$(Ka\(B")
(qdv "zi1"	"$(I,&.W.{9P:+@rD@RwVjY[$(J)%*D+=3Z8^<]?OE0E^F2K*K,ZN\6^Oc(dEglh;hCj3$(K#/)y<&?wA+G~IgOMPfUtY(Z%[2[e]zb|hsmWw)z"$(L#b#e,`0&2@:T?,?5E;N8R3S]TIVGXZXlYG_<$(M%b&j)~++154,4253546n8o:+:=<6=)BGBJDCDcG_K)M*M,QaVnWF]y`Gavb!b#e5(B")
(qd  "zi2"	"$(L_t(B")
(qdv "zi3"	"$(I#N#V$>&o*=.~:6GF$(JZF$(K!N'8*},);!FNHwcB$(L0V2)4#4)415VCUCVM;TH$(M!t'X,G3F7h?J@jP5(B")
(qdv "zi4"	"$(I3_777U$(J-3-M-`:DJOWv$(K$B&f.82$48909E;2;7BtP{mE$(L%J,.-M/{0!112%3O8T8d;0SeVqX~$(M%l/84e8cO.QG(B")
(qdv "zong1"	"$(I;4AwF\N+O+O,R"Yk[q[z]i$(J(a6o7H7h@AB]EDE|JUL(MEbPem$(K5n7O=9?fGlGxR!`Ee5r>x{$(LBGBhE<W-Y;_mcW$(M'")X4n67<.>=EDGILJYE]p(B")
(qdv "zong3"	"$(I4K62;X;cBUFk$(J7qC9Q~$(K2DXse3$(L7z:c:e@"J|TxVH$(M#>88GiI@(B")
(qdv "zong4"	"$(IC)H{MrR@$(J+d/&3"DlMe$(K1-aof#jm$(L]CbU$(M&h3Z:AO"(B")
(qdv "zou1"	"$(I*xHX$(J0mOnP[Rlkd$(K:-CgH:^|bnpi$(L4g4hEbQm_ja#$(M(l)#)G*!26273>E:W2^Jb)(B")
(qdv "zou3"	"$(I$:$(K'l$(L,7.2(B")
(qdv "zou4"	"$(IU.$(JOag<gL$(K!-/iX.X`[Uo-$(L!;<|>DH(IZR%R&$(M!|"?(B")
(qd  "zu1"	"$(IS{(B")
(qdv "zu2"	"$(I!Y*n5NGYY@Yn[<$(J)S0x8C?J?xML_3$(K/x9C>)HcY6^-^1_LaYe$fSk+mYu2$(L$*%;'r*{3ABVBWBYBe$(M#.2m(B")
(qdv "zu3"	"$(I-k$(JQw$(K.jI<QK$(L2R3Jad$(M&)(B")
(qdv "zu4"	"$(J]1$(K36{J$(M2\(B")
(qdv "zuan1"	"$(Jma$(Kuk$(MYLYS(B")
(qdv "zuan3"	"$(I^Q$(Jku$(K'Wm"$(MAYHc`#fI(B")
(qdv "zuan4"	"$(I`U`_$(JdQ(B")
(qdv "zui1"	"$(IDLQ<Q_[($(J,OhZjX$(K-BE/FRWXjn$(L[:$(M/gI+QmW>bc(B")
(qdv "zui3"	"$(I-H$(J,"84$(K;4E`$(M,a,k76(B")
(qdv "zui4"	"$(I1V9UDxJ+S2Wh$(JG'P&f"$(K'Y+y2/LWT7X!c?cIpZv#$(LIxV$`L$(M'T.u(B")
(qdv "zun1"	"$(IX\$(Kzp$(M":"m7qCz(B")
(qdv "zun3"	"$(JB;$(Kcm(B")
(qdv "zun4"	"$(K(E4:\Hcvo^t|(B")
(qdv "zuo1"	"$(KRi$(M%?Ym(B")
(qdv "zuo2"	"$(I2xE/$(J;A>.EzOoUb\pkZ$(K%~qSzu|0$(LQ>]~$(M&NN%cVf=(B")
(qdv "zuo3"	"$(I)Z$(J&(2FVW$(K<B$(L047($(M:7(B")
(qdv "zuo4"	"$(I(,+t5s8n?5ai$(J#E*.,[.i;Qg.$(K#`);-#.~2#J^Y|z3$(L"4%p)I*Q+=-h/P1^a<$(MXWc5(B")

(quail-setup-current-package)
