#ifndef EMACS18_REGEXP
#  define EMACS19_REGEXP
#endif /* not EMACS18_REGEXP */

#if defined (EMACS18_REGEXP)
#include "regex18.c"
/* Set REGS to hold NUM_REGS registers, storing them in STARTS and
   ENDS.  Subsequent matches using PATTERN_BUFFER and REGS will use
   this memory for recording register information.  STARTS and ENDS
   must be allocated using the malloc library routine, and must each
   be at least NUM_REGS * sizeof (regoff_t) bytes long.

   If NUM_REGS == 0, then subsequent matches should allocate their own
   register data.

   Unless this function is called, the first search or match using
   PATTERN_BUFFER will allocate its own register data, without
   freeing the old data.  */

void
re_set_registers (bufp, regs, num_regs, starts, ends)
    struct re_pattern_buffer *bufp;
    struct re_registers *regs;
    unsigned num_regs;
    regoff_t *starts, *ends;
{
  regs->num_regs = RE_NREGS;
}
#else  /* not EMACS18_REGEXP */
#include "regex19.c"
#endif /* not EMACS18_REGEXP */
