;;; quail/hanja-ksc.el --- Quail-package for hanja (KSC5601) inputting

;;; \comment 
;;; \comment Copyright Wnn Consortium. 1993
;;; \comment 
;;; \comment Permission to use, copy, modify, distribute, and sell this
;;; \comment software and its documentation for any purpose is hereby
;;; \comment granted without fee, provided that all of the following
;;; \comment conditions are satisfied:
;;; \comment 
;;; \comment 1) The above copyright notice appears in all copies
;;; \comment 2) Both that copyright notice and this permission notice
;;; \comment    appear in supporting documentation
;;; \comment 3) Following words followed by the above copyright notice
;;; \comment    appear in all supporting documentation of software based
;;; \comment    on this:
;;; \comment 
;;; \comment   "This software is based on the original version of Korean 
;;; \comment    Hangul-Hanja dictionary developed by Wnn Consortium."
;;; \comment 
;;; \comment 4) The name Wnn Consortium not be used in advertising or
;;; \comment    publicity pertaining to distribution of the software
;;; \comment    without specific, written prior permission
;;; \comment 
;;; \comment Wnn Consortium makes no representations about the suitability
;;; \comment of this software for any purpose.  It is provided "as is"
;;; \comment without express or implied warranty.
;;; \comment 
;;; \comment WNN CONSORTIUM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
;;; \comment SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
;;; \comment AND FITNESS, IN NO EVENT SHALL WNN CONSORTIUM BE LIABLE FOR
;;; \comment ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
;;; \comment WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
;;; \comment WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;; \comment TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;; \comment OR PERFORMANCE OF THIS SOFTWARE.
;;; \comment
;;; \comment	Korean Hangul/$(CySm.(B $(CS$m.(B $(C\(|5(B $(C\*_v(B
;;; \comment	Korean Hangul-Hanja dictionary Version 1.0

(require 'quail)

(quail-define-package
 "hanja-ksc" "2$(C9z=D(BKSC$(CySm.(B" t
 "$(Cz1SWGO4B(B $(CySm.@G(B $(Cj$@;(B $(CGQ1[(B2$(C9zcR@87N(B $(C{<usGO?)(B $(C`TwI(B"
 '(
   ("," . quail-prev-candidate-block)
   ("<" . quail-prev-candidate-block)
   ("." . quail-next-candidate-block)
   (">" . quail-next-candidate-block)
   (" " . quail-select-current)
   )
 )

(qdv "rk"	"$(CJ!J"J#J$J%J&J'J(J)J*J+J,J-J.J/J0J1J2J3J4J5J6J7J8J9J:J;J<J=(B")
(qdv "rkr"	"$(CJ>J?J@JAJBJCJDJEJFJGJH(B")
(qdv "rks"	"$(CJIJJJKJLJMJNJOJPJQJRJSJTJUJVJWJXJYJZJ[J\J]J^J_J`(B")
(qdv "rkf"	"$(CJaJbJcJdJeJfJgJhJiJj(B")
(qdv "rka"	"$(CJkJlJmJnJoJpJqJrJsJtJuJvJwJxJyJzJ{J|J}J~(B")
(qdv "rkq"	"$(CK!K"K#K$K%K&(B")
(qdv "rkd"	"$(CK'K(K)K*K+K,K-K.K/K0K1K2K3K4K5K6K7K8K9K:K;K<K=K>(B")
(qdv "ro"	"$(CK?K@KAKBKCKDKEKFKGKHKIKJKKKLKMKNKOKPKQKR(B")
(qdv "ror"	"$(CKSKT(B")
(qdv "rod"	"$(CKUKVKWKX(B")
(qdv "rir"	"$(CKY(B")
(qdv "rj"	"$(CKZK[K\K]K^K_K`KaKbKcKdKeKfKgKhKiKj(B")
(qdv "rjs"	"$(CKkKlKmKnKoKpKqKrKsKtKuKv(B")
(qdv "rjf"	"$(CKwKxKyKz(B")
(qdv "rja"	"$(CK{K|K}K~L!L"L#(B")
(qdv "rjq"	"$(CL$L%L&(B")
(qdv "rp"	"$(CL'L(L)(B")
(qdv "rur"	"$(CL*L+L,L-L.L/L0(B")
(qdv "rus"	"$(CL1L2L3L4L5L6L7L8L9L:L;(B")
(qdv "ruf"	"$(CL<L=L>L?L@LA(B")
(qdv "rua"	"$(CLBLCLDLELFLG(B")
(qdv "rud"	"$(CLHLILJLKLLLMLNLOLPLQLRLSLTLULVLWLXLYLZL[L\L]L^L_L`LaLbLcLdLeLfLgLhLiLjLkLlLmLnLoLpLqLrLsLt(B")
(qdv "rP"	"$(CLuLvLwLxLyLzL{L|L}L~M!M"M#M$M%M&M'M(M)M*M+M,M-M.(B")
(qdv "rh"	"$(CM/M0M1M2M3M4M5M6M7M8M9M:M;M<M=M>M?M@MAMBMCMDMEMFMGMHMIMJMKMLMMMNMOMPMQMRMSMTMU(B")
(qdv "rhr"	"$(CMVMWMXMYMZM[M\(B")
(qdv "rhs"	"$(CM]M^M_M`MaMbMcMdMeMf(B")
(qdv "rhf"	"$(CMgMhMi(B")
(qdv "rhd"	"$(CMjMkMlMmMnMoMpMqMrMsMtMuMvMwMxMy(B")
(qdv "rhw"	"$(CMz(B")
(qdv "rhk"	"$(CM{M|M}M~N!N"N#N$N%N&N'N((B")
(qdv "rhkr"	"$(CN)N*N+N,(B")
(qdv "rhks"	"$(CN-N.N/N0N1N2N3N4N5N6N7N8N9N:N;N<N=(B")
(qdv "rhkf"	"$(CN>N?N@NA(B")
(qdv "rhkd"	"$(CNBNCNDNENFNGNHNINJNKNLNMNN(B")
(qdv "rho"	"$(CNONPNQ(B")
(qdv "rhl"	"$(CNRNSNTNUNVNWNXNYNZ(B")
(qdv "rhld"	"$(CN[N\N]N^(B")
(qdv "ry"	"$(CN_N`NaNbNcNdNeNfNgNhNiNjNkNlNmNnNoNpNqNrNsNtNuNvNw(B")
(qdv "rn"	"$(CNxNyNzN{N|N}N~O!O"O#O$O%O&O'O(O)O*O+O,O-O.O/O0O1O2O3O4O5O6O7O8O9O:O;O<O=O>O?O@OAOBOCODOEOFOGOHOIOJOKOLOMONOO(B")
(qdv "rnr"	"$(COPOQOROSOTOU(B")
(qdv "rns"	"$(COVOWOXOYOZO[(B")
(qdv "rnf"	"$(CO\O]O^O_(B")
(qdv "rnd"	"$(CO`OaObOcOdOe(B")
(qdv "rnjs"	"$(COfOgOhOiOjOkOlOmOnOo(B")
(qdv "rnjf"	"$(COpOqOrOsOt(B")
(qdv "rnp"	"$(COuOvOwOxOyOz(B")
(qdv "rnl"	"$(CO{O|O}O~P!P"(B")
(qdv "rb"	"$(CP#P$P%P&P'P(P)P*P+P,P-P.P/P0P1(B")
(qdv "rbs"	"$(CP2P3P4P5P6P7P8(B")
(qdv "rbf"	"$(CP9(B")
(qdv "rmr"	"$(CP:P;P<P=P>P?P@(B")
(qdv "rms"	"$(CPAPBPCPDPEPFPGPHPIPJPKPLPMPNPO(B")
(qdv "rmf"	"$(CPP(B")
(qdv "rma"	"$(CPQPRPSPTPUPVPWPXPYPZP[P\P]P^(B")
(qdv "rmq"	"$(CP_P`PaPbPcPdPe(B")
(qdv "rmd"	"$(CPfPgPhPi(B")
(qdv "rl"	"$(CPjPkPlPmPnPoPpPqPrPsPtPuPvPwPxPyPzP{P|P}P~Q!Q"Q#Q$Q%Q&Q'Q(Q)Q*Q+Q,Q-Q.Q/Q0Q1Q2Q3Q4Q5Q6Q7Q8Q9Q:Q;Q<Q=Q>Q?Q@QAQBQCQDQEQFQGQHQIQJQK(B")
(qdv "rls"	"$(CQL(B")
(qdv "rlf"	"$(CQMQNQOQP(B")
(qdv "rla"	"$(CQQ(B")
(qdv "Rlr"	"$(CQR(B")
(qdv "sk"	"$(CQSQTQUQVQWQXQYQZQ[Q\Q]Q^Q_Q`Qa(B")
(qdv "skr"	"$(CQbQcQdQeQfQgQhQi(B")
(qdv "sks"	"$(CQjQkQlQmQnQoQpQqQr(B")
(qdv "skf"	"$(CQsQt(B")
(qdv "ska"	"$(CQuQvQwQxQyQzQ{Q|Q}(B")
(qdv "skq"	"$(CQ~R!R"R#R$(B")
(qdv "skd"	"$(CR%R&R'R(R)R*R+(B")
(qdv "so"	"$(CR,R-R.R/R0R1(B")
(qdv "sod"	"$(CR2(B")
(qdv "su"	"$(CR3(B")
(qdv "sus"	"$(CR4R5R6(B")
(qdv "sua"	"$(CR7R8R9R:(B")
(qdv "sud"	"$(CR;R<(B")
(qdv "sh"	"$(CR=R>R?R@RARBRCRDRERFRGRHRIRJRKRLRMRN(B")
(qdv "shr"	"$(CRORPRQRRRSRT(B")
(qdv "shs"	"$(CRU(B")
(qdv "shd"	"$(CRVRWRXRYRZR[R\(B")
(qdv "shl"	"$(CR]R^R_R`RaRb(B")
(qdv "sy"	"$(CRc(B")
(qdv "sn"	"$(CRdReRfRgRhRiRjRk(B")
(qdv "sns"	"$(CRl(B")
(qdv "snf"	"$(CRm(B")
(qdv "sb"	"$(CRnRo(B")
(qdv "smr"	"$(CRpRq(B")
(qdv "sma"	"$(CRr(B")
(qdv "smd"	"$(CRsRtRuRvRwRx(B")
(qdv "sl"	"$(CRyRz(B")
(qdv "slr"	"$(CR{R|(B")
(qdv "ek"	"$(CR}R~(B")
(qdv "eks"	"$(CS!S"S#S$S%S&S'S(S)S*S+S,S-S.S/S0S1S2S3S4(B")
(qdv "ekf"	"$(CS5S6S7S8S9(B")
(qdv "eka"	"$(CS:S;S<S=S>S?S@SASBSCSDSESFSGSHSISJ(B")
(qdv "ekq"	"$(CSKSLSMSNSO(B")
(qdv "ekd"	"$(CSPSQSRSSSTSUSVSWSXSYSZ(B")
(qdv "eo"	"$(CS[S\S]S^S_S`SaSbScSdSeSfSgShSiSj(B")
(qdv "eor"	"$(CSk(B")
(qdv "ejr"	"$(CSlSm(B")
(qdv "eh"	"$(CSnSoSpSqSrSsStSuSvSwSxSySzS{S|S}S~T!T"T#T$T%T&T'T(T)T*T+T,T-T.T/T0T1T2T3T4T5T6T7(B")
(qdv "ehr"	"$(CT8T9T:T;T<T=T>T?T@TA(B")
(qdv "ehs"	"$(CTBTCTDTETFTGTHTITJTK(B")
(qdv "ehf"	"$(CTLTM(B")
(qdv "ehd"	"$(CTNTOTPTQTRTSTTTUTVTWTXTYTZT[T\T]T^(B")
(qdv "en"	"$(CT_T`TaTbTcTdTeTfTgThTi(B")
(qdv "ens"	"$(CTjTkTlTmTnTo(B")
(qdv "emr"	"$(CTp(B")
(qdv "emd"	"$(CTqTrTsTtTuTvTwTxTy(B")
(qdv "fk"	"$(CTzT{T|T}T~U!U"U#U$(B")
(qdv "fkr"	"$(CU%U&U'U(U)U*U+U,U-(B")
(qdv "fks"	"$(CU.U/U0U1U2U3U4U5U6(B")
(qdv "fkf"	"$(CU7U8(B")
(qdv "fka"	"$(CU9U:U;U<U=U>U?U@UAUB(B")
(qdv "fkq"	"$(CUCUDUE(B")
(qdv "fkd"	"$(CUFUGUHUIUJUKULUM(B")
(qdv "fo"	"$(CUNUOUPUQ(B")
(qdv "fod"	"$(CUR(B")
(qdv "fir"	"$(CUSUT(B")
(qdv "fid"	"$(CUUUVUWUXUYUZU[U\U]U^U_U`Ua(B")
(qdv "fu"	"$(CUbUcUdUeUfUgUhUiUjUkUlUmUnUoUpUqUrUs(B")
(qdv "fur"	"$(CUtUuUvUwUxUyUz(B")
(qdv "fus"	"$(CU{U|U}U~V!V"V#V$V%V&V'V((B")
(qdv "fuf"	"$(CV)V*V+V,V-V.(B")
(qdv "fua"	"$(CV/V0V1V2V3(B")
(qdv "fuq"	"$(CV4(B")
(qdv "fud"	"$(CV5V6V7V8V9V:V;V<V=V>V?V@VAVBVCVDVEVF(B")
(qdv "fP"	"$(CVGVHVIVJVK(B")
(qdv "fh"	"$(CVLVMVNVOVPVQVRVSVTVUVVVWVXVYVZV[V\V](B")
(qdv "fhr"	"$(CV^V_V`VaVbVcVd(B")
(qdv "fhs"	"$(CVe(B")
(qdv "fhd"	"$(CVfVgVhViVjVkVl(B")
(qdv "fhl"	"$(CVmVnVoVpVqVrVsVt(B")
(qdv "fy"	"$(CVuVvVwVxVyVzV{V|V}V~W!W"(B")
(qdv "fyd"	"$(CW#(B")
(qdv "fn"	"$(CW$W%W&W'W(W)W*W+W,W-W.W/W0(B")
(qdv "fb"	"$(CW1W2W3W4W5W6W7W8W9W:W;W<W=W>(B")
(qdv "fbr"	"$(CW?W@WA(B")
(qdv "fbs"	"$(CWBWCWDWEWFWG(B")
(qdv "fbf"	"$(CWHWIWJWK(B")
(qdv "fbd"	"$(CWL(B")
(qdv "fmr"	"$(CWMWN(B")
(qdv "fma"	"$(CWO(B")
(qdv "fmd"	"$(CWPWQWRWSWTWU(B")
(qdv "fl"	"$(CWVWWWXWYWZW[W\W]W^W_W`WaWbWcWdWeWfWgWhWiWjWkWlWmWnWo(B")
(qdv "fls"	"$(CWpWqWrWsWtWuWvWwWx(B")
(qdv "fla"	"$(CWyWzW{W|W}(B")
(qdv "flq"	"$(CW~X!X"X#(B")
(qdv "ak"	"$(CX$X%X&X'X(X)X*X+(B")
(qdv "akr"	"$(CX,X-X.X/X0X1(B")
(qdv "aks"	"$(CX2X3X4X5X6X7X8X9X:X;X<X=X>X?X@XAXBXCXD(B")
(qdv "akf"	"$(CXEXFXGXHXIXJXK(B")
(qdv "akd"	"$(CXLXMXNXOXPXQXRXSXTXUXVXW(B")
(qdv "ao"	"$(CXXXYXZX[X\X]X^X_X`XaXbXcXdXe(B")
(qdv "aor"	"$(CXfXgXhXiXj(B")
(qdv "aod"	"$(CXkXlXmXnXoXp(B")
(qdv "aur"	"$(CXqXr(B")
(qdv "aus"	"$(CXsXtXuXvXwXxXyXzX{X|X}(B")
(qdv "auf"	"$(CX~Y!(B")
(qdv "aud"	"$(CY"Y#Y$Y%Y&Y'Y(Y)Y*Y+Y,Y-Y.Y/Y0(B")
(qdv "aP"	"$(CY1(B")
(qdv "ah"	"$(CY2Y3Y4Y5Y6Y7Y8Y9Y:Y;Y<Y=Y>Y?Y@YAYBYCYDYEYFYGYHYI(B")
(qdv "ahr"	"$(CYJYKYLYMYNYOYP(B")
(qdv "ahf"	"$(CYQYR(B")
(qdv "ahd"	"$(CYSYTYU(B")
(qdv "ay"	"$(CYVYWYXYYYZY[Y\Y]Y^Y_Y`Ya(B")
(qdv "an"	"$(CYbYcYdYeYfYgYhYiYjYkYlYmYnYoYpYqYrYsYtYuYvYw(B")
(qdv "anr"	"$(CYxYy(B")
(qdv "ans"	"$(CYzY{Y|Y}Y~Z!Z"Z#Z$Z%Z&Z'(B")
(qdv "anf"	"$(CZ(Z)Z*(B")
(qdv "al"	"$(CZ+Z,Z-Z.Z/Z0Z1Z2Z3Z4Z5Z6Z7Z8Z9Z:Z;Z<Z=(B")
(qdv "als"	"$(CZ>Z?Z@ZAZBZCZDZEZFZGZHZIZJ(B")
(qdv "alf"	"$(CZKZLZM(B")
(qdv "qkr"	"$(CZNZOZPZQZRZSZTZUZVZWZXZYZZZ[Z\Z]Z^Z_Z`(B")
(qdv "qks"	"$(CZaZbZcZdZeZfZgZhZiZjZkZlZmZnZoZpZqZrZsZtZuZvZwZxZy(B")
(qdv "qkf"	"$(CZzZ{Z|Z}Z~[!["[#[$[%[&(B")
(qdv "qkd"	"$(C['[([)[*[+[,[-[.[/[0[1[2[3[4[5[6[7[8[9[:[;[<[=[>[?[@[A[B(B")
(qdv "qo"	"$(C[C[D[E[F[G[H[I[J[K[L[M[N[O[P[Q[R[S[T[U[V(B")
(qdv "qor"	"$(C[W[X[Y[Z[[[\[][^(B")
(qdv "qjs"	"$(C[_[`[a[b[c[d[e[f[g[h(B")
(qdv "qjf"	"$(C[i[j[k[l(B")
(qdv "qja"	"$(C[m[n[o[p[q[r[s[t[u(B")
(qdv "qjq"	"$(C[v[w(B")
(qdv "qur"	"$(C[x[y[z[{[|[}[~\!\"\#\$(B")
(qdv "qus"	"$(C\%\&\'\(\)\*\+(B")
(qdv "quf"	"$(C\,\-\.\/(B")
(qdv "qud"	"$(C\0\1\2\3\4\5\6\7\8\9\:\;\<\=\>\?\@(B")
(qdv "qh"	"$(C\A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P(B")
(qdv "qhr"	"$(C\Q\R\S\T\U\V\W\X\Y\Z\[\\\]\^\_\`\a(B")
(qdv "qhs"	"$(C\b(B")
(qdv "qhf"	"$(C\c(B")
(qdv "qhd"	"$(C\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s(B")
(qdv "qn"	"$(C\t\u\v\w\x\y\z\{\|\}\~]!]"]#]$]%]&]'](])]*]+],]-].]/]0]1]2]3]4]5]6]7]8]9]:];]<]=]>]?]@(B")
(qdv "qnr"	"$(C]A(B")
(qdv "qns"	"$(C]B]C]D]E]F]G]H]I]J]K]L]M]N]O]P]Q]R]S]T(B")
(qdv "qnf"	"$(C]U]V]W]X]Y(B")
(qdv "qnd"	"$(C]Z][]\]]]^]_(B")
(qdv "ql"	"$(C]`]a]b]c]d]e]f]g]h]i]j]k]l]m]n]o]p]q]r]s]t]u]v]w]x]y]z]{]|]}]~^!^"^#^$^%^&^'^(^)^*^+^,(B")
(qdv "qls"	"$(C^-^.^/^0^1^2^3^4^5^6^7^8^9^:(B")
(qdv "qld"	"$(C^;^<^=^>(B")
(qdv "tk"	"$(C^?^@^A^B^C^D^E^F^G^H^I^J^K^L^M^N^O^P^Q^R^S^T^U^V^W^X^Y^Z^[^\^]^^^_^`^a^b^c^d^e^f^g^h^i^j^k^l^m^n^o^p^q^r^s^t^u^v^w^x^y^z(B")
(qdv "tkr"	"$(C^{^|^}^~(B")
(qdv "tks"	"$(C_!_"_#_$_%_&_'_(_)_*_+_,(B")
(qdv "tkf"	"$(C_-_._/_0_1(B")
(qdv "tka"	"$(C_2_3_4_5_6_7_8_9(B")
(qdv "tkq"	"$(C_:_;_<_=(B")
(qdv "tkd"	"$(C_>_?_@_A_B_C_D_E_F_G_H_I_J_K_L_M_N_O_P_Q_R_S_T_U_V_W_X_Y_Z_[_\(B")
(qdv "to"	"$(C_]_^__(B")
(qdv "tor"	"$(C_`_a_b_c_d(B")
(qdv "tod"	"$(C_e_f_g_h_i(B")
(qdv "tj"	"$(C_j_k_l_m_n_o_p_q_r_s_t_u_v_w_x_y_z_{_|_}_~`!`"`#`$`%`&`'`(`)(B")
(qdv "tjr"	"$(C`*`+`,`-`.`/`0`1`2`3`4`5`6`7`8(B")
(qdv "tjs"	"$(C`9`:`;`<`=`>`?`@`A`B`C`D`E`F`G`H`I`J`K`L`M`N`O`P`Q`R`S`T`U`V`W`X(B")
(qdv "tjf"	"$(C`Y`Z`[`\`]`^`_```a`b`c`d`e(B")
(qdv "tja"	"$(C`f`g`h`i`j`k`l`m(B")
(qdv "tjq"	"$(C`n`o`p`q(B")
(qdv "tjd"	"$(C`r`s`t`u`v`w`x`y`z`{`|`}`~a!a"a#a$a%(B")
(qdv "tp"	"$(Ca&a'a(a)a*a+a,a-a.(B")
(qdv "th"	"$(Ca/a0a1a2a3a4a5a6a7a8a9a:a;a<a=a>a?a@aAaBaCaDaEaFaGaHaIaJaKaLaMaNaOaPaQaRaS(B")
(qdv "thr"	"$(CaTaUaVaWaXaYaZa[a\(B")
(qdv "ths"	"$(Ca]a^a_a`aaab(B")
(qdv "thf"	"$(Cac(B")
(qdv "thd"	"$(Cadaeafagahaiajak(B")
(qdv "tho"	"$(Calamanaoap(B")
(qdv "thl"	"$(Caqar(B")
(qdv "tn"	"$(Casatauavawaxayaza{a|a}a~b!b"b#b$b%b&b'b(b)b*b+b,b-b.b/b0b1b2b3b4b5b6b7b8b9b:b;b<b=b>b?b@bAbBbCbDbEbFbGbHbIbJbKbLbMbNbObPbQ(B")
(qdv "tnr"	"$(CbRbSbTbUbVbWbXbYbZb[b\b](B")
(qdv "tns"	"$(Cb^b_b`babbbcbdbebfbgbhbibjbkblbmbnbobpbqbrbsbtbubvbwbx(B")
(qdv "tnf"	"$(Cbybzb{b|(B")
(qdv "tnd"	"$(Cb}b~c!(B")
(qdv "tmf"	"$(Cc"c#c$(B")
(qdv "tmq"	"$(Cc%c&c'c(c)(B")
(qdv "tmd"	"$(Cc*c+c,c-c.c/c0c1c2c3(B")
(qdv "tl"	"$(Cc4c5c6c7c8c9c:c;c<c=c>c?c@cAcBcCcDcEcFcGcHcIcJcKcLcMcNcO(B")
(qdv "tlr"	"$(CcPcQcRcScTcUcVcWcXcYcZc[c\c]c^(B")
(qdv "tls"	"$(Cc_c`cacbcccdcecfcgchcicjckclcmcncocpcqcrcsctcucv(B")
(qdv "tlf"	"$(Ccwcxcycz(B")
(qdv "tla"	"$(Cc{c|c}c~d!d"d#d$d%d&(B")
(qdv "tlq"	"$(Cd'd(d)(B")
(qdv "Tkd"	"$(Cd*(B")
(qdv "Tl"	"$(Cd+(B")
(qdv "dk"	"$(Cd,d-d.d/d0d1d2d3d4d5d6d7d8d9d:d;d<d=(B")
(qdv "dkr"	"$(Cd>d?d@dAdBdCdDdEdFdGdHdIdJdK(B")
(qdv "dks"	"$(CdLdMdNdOdPdQdRdSdTdU(B")
(qdv "dkf"	"$(CdVdWdXdY(B")
(qdv "dka"	"$(CdZd[d\d]d^d_d`da(B")
(qdv "dkq"	"$(Cdbdcddde(B")
(qdv "dkd"	"$(Cdfdgdhdidjdkdl(B")
(qdv "do"	"$(Cdmdndodpdqdrdsdtdudvdw(B")
(qdv "dor"	"$(Cdxdydzd{d|d}d~(B")
(qdv "dod"	"$(Ce!e"e#e$(B")
(qdv "di"	"$(Ce%e&e'e(e)e*e+e,e-e.e/(B")
(qdv "dir"	"$(Ce0e1e2e3e4e5e6e7e8(B")
(qdv "did"	"$(Ce9e:e;e<e=e>e?e@eAeBeCeDeEeFeGeHeIeJeKeLeMeNeOePeQeReSeTeUeVeW(B")
(qdv "dj"	"$(CeXeYeZe[e\e]e^e_e`ea(B")
(qdv "djr"	"$(Cebecedeeef(B")
(qdv "djs"	"$(Cegeheiejekel(B")
(qdv "djf"	"$(Cemen(B")
(qdv "dja"	"$(Ceoepeqereset(B")
(qdv "djq"	"$(Ceuev(B")
(qdv "dps"	"$(Cew(B")
(qdv "du"	"$(Cexeyeze{e|e}e~f!f"f#f$f%f&f'f(f)f*f+f,f-f.f/f0f1(B")
(qdv "dur"	"$(Cf2f3f4f5f6f7f8f9f:f;f<f=f>(B")
(qdv "dus"	"$(Cf?f@fAfBfCfDfEfFfGfHfIfJfKfLfMfNfOfPfQfRfSfTfUfVfWfXfYfZf[f\f]f^f_f`fafbfcfdfefffgfhfi(B")
(qdv "duf"	"$(Cfjfkflfmfnfofpfqfrfs(B")
(qdv "dua"	"$(Cftfufvfwfxfyfzf{f|f}f~g!g"g#g$(B")
(qdv "duq"	"$(Cg%g&g'g((B")
(qdv "dud"	"$(Cg)g*g+g,g-g.g/g0g1g2g3g4g5g6g7g8g9g:g;g<g=g>g?g@gAgBgCgDgEgFgGgHgIgJgKgLgMgNgOgP(B")
(qdv "dP"	"$(CgQgRgSgTgUgVgWgXgYgZg[g\g]g^g_g`gagbgcgdgegfgggh(B")
(qdv "dh"	"$(Cgigjgkglgmgngogpgqgrgsgtgugvgwgxgygzg{g|g}g~h!h"h#h$h%h&h'h((B")
(qdv "dhr"	"$(Ch)h*h+h,h-(B")
(qdv "dhs"	"$(Ch.h/h0h1h2h3(B")
(qdv "dhf"	"$(Ch4(B")
(qdv "dhd"	"$(Ch5h6h7h8h9h:h;h<h=(B")
(qdv "dhk"	"$(Ch>h?h@hAhBhChDhE(B")
(qdv "dhks"	"$(ChFhGhHhIhJhKhLhMhNhOhPhQhRhShThUhVhW(B")
(qdv "dhkf"	"$(ChX(B")
(qdv "dhkd"	"$(ChYhZh[h\h](B")
(qdv "dho"	"$(Ch^h_h`ha(B")
(qdv "dhl"	"$(Chbhchdhehf(B")
(qdv "dy"	"$(Chghhhihjhkhlhmhnhohphqhrhshthuhvhwhxhyhzh{h|h}h~i!i"i#i$i%i&i'i(i)i*i+i,i-i.(B")
(qdv "dyr"	"$(Ci/i0i1i2i3i4(B")
(qdv "dyd"	"$(Ci5i6i7i8i9i:i;i<i=i>i?i@iAiBiCiDiEiFiGiHiIiJiKiL(B")
(qdv "dn"	"$(CiMiNiOiPiQiRiSiTiUiViWiXiYiZi[i\i]i^i_i`iaibicidieifigihiiijikil(B")
(qdv "dnr"	"$(Ciminioipiqirisitiu(B")
(qdv "dns"	"$(Civiwixiyizi{i|i}i~j!j"j#j$(B")
(qdv "dnf"	"$(Cj%j&j'(B")
(qdv "dnd"	"$(Cj(j)(B")
(qdv "dnjs"	"$(Cj*j+j,j-j.j/j0j1j2j3j4j5j6j7j8j9j:j;j<j=j>j?j@jAjBjCjD(B")
(qdv "dnjf"	"$(CjEjFjG(B")
(qdv "dnl"	"$(CjHjIjJjKjLjMjNjOjPjQjRjSjTjUjVjWjXjYjZj[j\j]j^j_j`(B")
(qdv "db"	"$(Cjajbjcjdjejfjgjhjijjjkjljmjnjojpjqjrjsjtjujvjwjxjyjzj{j|j}j~k!k"k#k$k%k&k'k(k)k*k+k,k-k.k/k0k1k2k3k4k5k6k7k8k9k:(B")
(qdv "dbr"	"$(Ck;k<k=k>k?k@kA(B")
(qdv "dbs"	"$(CkBkCkDkEkFkGkHkIkJkKkLkMkN(B")
(qdv "dbf"	"$(CkOkPkQkRkS(B")
(qdv "dbd"	"$(CkTkUkVkWkX(B")
(qdv "dms"	"$(CkYkZk[k\k]k^k_(B")
(qdv "dmf"	"$(Ck`(B")
(qdv "dma"	"$(Ckakbkckdkekf(B")
(qdv "dmq"	"$(Ckgkhki(B")
(qdv "dmd"	"$(Ckjkkklkm(B")
(qdv "dml"	"$(Cknkokpkqkrksktkukvkwkxkykzk{k|k}k~l!l"(B")
(qdv "dl"	"$(Cl#l$l%l&l'l(l)l*l+l,l-l.l/l0l1l2l3l4l5l6l7l8l9l:l;l<l=l>l?l@lAlBlClDlElFlGlH(B")
(qdv "dlr"	"$(ClIlJlKlLlMlNlOlP(B")
(qdv "dls"	"$(ClQlRlSlTlUlVlWlXlYlZl[l\l]l^l_l`lalblcldlelflglh(B")
(qdv "dlf"	"$(Cliljlklllmlnlolplq(B")
(qdv "dla"	"$(Clrlsltlulvlwlxlylzl{l|(B")
(qdv "dlq"	"$(Cl}l~m!m"m#(B")
(qdv "dld"	"$(Cm$m%m&m'(B")
(qdv "wk"	"$(Cm(m)m*m+m,m-m.m/m0m1m2m3m4m5m6m7m8m9m:m;m<m=m>m?m@mA(B")
(qdv "wkr"	"$(CmBmCmDmEmFmGmHmImJmKmLmMmN(B")
(qdv "wks"	"$(CmOmPmQmRmS(B")
(qdv "wka"	"$(CmTmUmVmWmXmY(B")
(qdv "wkq"	"$(CmZ(B")
(qdv "wkd"	"$(Cm[m\m]m^m_m`mambmcmdmemfmgmhmimjmkmlmmmnmompmqmrmsmtmumvmwmxmymzm{m|m}m~n!(B")
(qdv "Od"	"$(Cn3n4n5n6(B")
(qdv "wo"	"$(Cn"n#n$n%n&n'n(n)n*n+n,n-n.n/n0n1n2(B")
(qdv "wj"	"$(Cn7n8n9n:n;n<n=n>n?n@nAnBnCnDnEnFnGnHnInJnKnLnMnNnOnPnQnR(B")
(qdv "wjr"	"$(CnSnTnUnVnWnXnYnZn[n\n]n^n_n`nanbncndnenfngnhninjnk(B")
(qdv "wjs"	"$(Cnlnmnnnonpnqnrnsntnunvnwnxnynzn{n|n}n~o!o"o#o$o%o&o'o(o)o*o+o,o-o.o/o0o1o2o3o4o5o6(B")
(qdv "wjf"	"$(Co7o8o9o:o;o<o=o>(B")
(qdv "wja"	"$(Co?o@oAoBoCoDoEoFoG(B")
(qdv "wjq"	"$(CoHoIoJ(B")
(qdv "wjd"	"$(CoKoLoMoNoOoPoQoRoSoToUoVoWoXoYoZo[o\o]o^o_o`oaobocodoeofogohoiojokolomonooopoqorosotouovowoxoyozo{o|o}o~p!p"p#(B")
(qdv "wp"	"$(Cp$p%p&p'p(p)p*p+p,p-p.p/p0p1p2p3p4p5p6p7p8p9p:(B")
(qdv "wh"	"$(Cp;p<p=p>p?p@pApBpCpDpEpFpGpHpIpJpKpLpMpNpOpPpQpRpSpTpUpVpWpXpYpZp[p\p]p^p_p`papbpcpdpepfpgph(B")
(qdv "whr"	"$(Cpipjpkpl(B")
(qdv "whs"	"$(Cpmpn(B")
(qdv "whf"	"$(Cpopppq(B")
(qdv "whd"	"$(Cprpsptpupvpwpxpypzp{p|p}p~q!q"q#q$(B")
(qdv "whk"	"$(Cq%q&q'q(q)(B")
(qdv "whl"	"$(Cq*(B")
(qdv "wn"	"$(Cq+q,q-q.q/q0q1q2q3q4q5q6q7q8q9q:q;q<q=q>q?q@qAqBqCqDqEqFqGqHqIqJqKqLqMqNqOqPqQqR(B")
(qdv "wnr"	"$(CqSqT(B")
(qdv "wns"	"$(CqUqVqWqXqYqZq[q\q]q^q_q`qaqbqcqdqeqfqg(B")
(qdv "wnf"	"$(Cqh(B")
(qdv "wnd"	"$(Cqiqjqkql(B")
(qdv "wmr"	"$(Cqm(B")
(qdv "wmf"	"$(Cqn(B")
(qdv "wmq"	"$(Cqoqpqq(B")
(qdv "wmd"	"$(Cqrqsqtquqvqwqxqyqzq{q|(B")
(qdv "wl"	"$(Cq}q~r!r"r#r$r%r&r'r(r)r*r+r,r-r.r/r0r1r2r3r4r5r6r7r8r9r:r;r<r=r>r?r@(B")
(qdv "wlr"	"$(CrArBrCrDrE(B")
(qdv "wls"	"$(CrFrGrHrIrJrKrLrMrNrOrPrQrRrSrTrUrVrWrXrYrZr[r\r]r^r_r`rarbrcrdrerfrgrh(B")
(qdv "wlf"	"$(Crirjrkrlrmrnrorprqrrrsrtrurvrw(B")
(qdv "wla"	"$(Crxry(B")
(qdv "wlq"	"$(Crzr{r|r}r~s!s"(B")
(qdv "wld"	"$(Cs#s$s%(B")
(qdv "ck"	"$(Cs&s's(s)s*s+s,s-s.s/s0s1s2s3s4(B")
(qdv "ckr"	"$(Cs5s6s7s8s9s:s;(B")
(qdv "cks"	"$(Cs<s=s>s?s@sAsBsCsDsEsFsGsHsIsJ(B")
(qdv "ckf"	"$(CsKsLsMsNsO(B")
(qdv "cka"	"$(CsPsQsRsSsTsUsVsWsXsY(B")
(qdv "ckd"	"$(CsZs[s\s]s^s_s`sasbscsdsesfsgshsisjskslsmsnso(B")
(qdv "co"	"$(Cspsqsrssstsusvswsxsyszs{(B")
(qdv "cor"	"$(Cs|s}s~t!(B")
(qdv "cj"	"$(Ct"t#t$t%(B")
(qdv "cjr"	"$(Ct&t't(t)t*t+t,t-t.t/t0t1t2t3t4(B")
(qdv "cjs"	"$(Ct5t6t7t8t9t:t;t<t=t>t?t@tAtBtCtDtEtFtG(B")
(qdv "cjf"	"$(CtHtItJtKtLtMtNtOtPtQ(B")
(qdv "cja"	"$(CtRtStTtUtVtWtXtYtZt[(B")
(qdv "cjq"	"$(Ct\t]t^t_t`tatbtctdte(B")
(qdv "cjd"	"$(Ctftgthtitjtktltm(B")
(qdv "cp"	"$(Ctntotptqtrtstttutvtw(B")
(qdv "ch"	"$(Ctxtytzt{t|t}t~u!u"u#u$u%u&u'u(u)u*u+u,u-u.u/u0u1u2u3u4(B")
(qdv "chr"	"$(Cu5u6u7u8u9u:(B")
(qdv "chs"	"$(Cu;u<u=u>(B")
(qdv "chd"	"$(Cu?u@uAuBuCuDuEuFuGuH(B")
(qdv "chkf"	"$(CuI(B")
(qdv "chl"	"$(CuJuKuL(B")
(qdv "cn"	"$(CuMuNuOuPuQuRuSuTuUuVuWuXuYuZu[u\u]u^u_u`uaubuc(B")
(qdv "cnr"	"$(Cudueufuguhuiujukulumunuo(B")
(qdv "cns"	"$(Cupuqur(B")
(qdv "cnf"	"$(Cusutuu(B")
(qdv "cnd"	"$(Cuvuwuxuyuzu{(B")
(qdv "cnp"	"$(Cu|u}u~v!(B")
(qdv "cnl"	"$(Cv"v#v$v%v&v'v(v)v*v+v,v-v.v/(B")
(qdv "cmr"	"$(Cv0v1v2v3v4(B")
(qdv "cmd"	"$(Cv5(B")
(qdv "cl"	"$(Cv6v7v8v9v:v;v<v=v>v?v@vAvBvCvDvEvFvGvHvIvJvKvLvM(B")
(qdv "clr"	"$(CvNvOvP(B")
(qdv "cls"	"$(CvQ(B")
(qdv "clf"	"$(CvRvSvT(B")
(qdv "cla"	"$(CvUvVvWvXvYvZv[v\v](B")
(qdv "clq"	"$(Cv^(B")
(qdv "cld"	"$(Cv_v`(B")
(qdv "zho"	"$(Cva(B")
(qdv "xk"	"$(Cvbvcvdvevfvgvhvivjvkvlvmvnvo(B")
(qdv "xkr"	"$(Cvpvqvrvsvtvuvvvwvxvyvzv{v|v}v~w!(B")
(qdv "xks"	"$(Cw"w#w$w%w&w'w(w)w*w+(B")
(qdv "xkf"	"$(Cw,w-(B")
(qdv "xka"	"$(Cw.w/w0w1(B")
(qdv "xkq"	"$(Cw2w3w4(B")
(qdv "xkd"	"$(Cw5w6w7w8w9(B")
(qdv "xo"	"$(Cw:w;w<w=w>w?w@wAwBwCwDwEwFwG(B")
(qdv "xor"	"$(CwHwIwJ(B")
(qdv "xod"	"$(CwK(B")
(qdv "xj"	"$(CwL(B")
(qdv "xh"	"$(CwMwNwOwP(B")
(qdv "xhd"	"$(CwQwRwSwTwUwVwW(B")
(qdv "xhl"	"$(CwXwYwZw[w\w](B")
(qdv "xn"	"$(Cw^w_w`wawbwc(B")
(qdv "xmr"	"$(Cwdwe(B")
(qdv "xma"	"$(Cwf(B")
(qdv "vk"	"$(Cwgwhwiwjwkwlwmwnwowpwqwrwswtwuwv(B")
(qdv "vks"	"$(Cwwwxwywzw{w|w}w~x!(B")
(qdv "vkf"	"$(Cx"x#x$(B")
(qdv "vo"	"$(Cx%x&x'x(x)x*x+x,x-x.x/(B")
(qdv "vod"	"$(Cx0x1x2x3(B")
(qdv "vir"	"$(Cx4(B")
(qdv "vus"	"$(Cx5x6x7x8x9x:x;x<x=x>(B")
(qdv "vua"	"$(Cx?(B")
(qdv "vud"	"$(Cx@xAxBxCxD(B")
(qdv "vP"	"$(CxExFxGxHxIxJxKxLxMxN(B")
(qdv "vh"	"$(CxOxPxQxRxSxTxUxVxWxXxYxZx[x\x]x^x_x`xaxbxcxdxexfxgxhxixj(B")
(qdv "vhr"	"$(Cxkxlxmxnxoxp(B")
(qdv "vy"	"$(Cxqxrxsxtxuxvxwxxxyxzx{x|x}x~(B")
(qdv "vna"	"$(Cy!y"(B")
(qdv "vnd"	"$(Cy#y$y%y&y'(B")
(qdv "vl"	"$(Cy(y)y*y+y,y-y.(B")
(qdv "vlf"	"$(Cy/y0y1y2y3y4y5y6y7y8(B")
(qdv "vlq"	"$(Cy9y:(B")
(qdv "gk"	"$(Cy;y<y=y>y?y@yAyByCyDyEyFyGyH(B")
(qdv "gkr"	"$(CyIyJyKyLyM(B")
(qdv "gks"	"$(CyNyOyPyQyRySyTyUyVyWyXyYyZy[(B")
(qdv "gkf"	"$(Cy\y](B")
(qdv "gka"	"$(Cy^y_y`yaybycydyeyfygyhyi(B")
(qdv "gkq"	"$(Cyjykylymynyoyp(B")
(qdv "gkd"	"$(Cyqyrysytyuyvywyxyyyzy{y|y}y~z!z"z#(B")
(qdv "go"	"$(Cz$z%z&z'z(z)z*z+z,z-z.z/z0z1z2z3z4z5(B")
(qdv "gor"	"$(Cz6z7(B")
(qdv "god"	"$(Cz8z9z:z;z<(B")
(qdv "gid"	"$(Cz=z>z?z@zAzBzCzDzE(B")
(qdv "gj"	"$(CzFzGzHzI(B")
(qdv "gjs"	"$(CzJzKzLzM(B")
(qdv "gjf"	"$(CzN(B")
(qdv "gja"	"$(CzOzP(B")
(qdv "gur"	"$(CzQzRzSzT(B")
(qdv "gus"	"$(CzUzVzWzXzYzZz[z\z]z^z_z`zazbzczdzezfzgzhzi(B")
(qdv "guf"	"$(Czjzkzlzm(B")
(qdv "gua"	"$(Czn(B")
(qdv "guq"	"$(Czozpzqzrzsztzuzvzwzxzyzz(B")
(qdv "gud"	"$(Cz{z|z}z~{!{"{#{${%{&{'{({){*{+{,{-{.{/{0(B")
(qdv "gP"	"$(C{1{2{3{4{5{6{7{8{9(B")
(qdv "gh"	"$(C{:{;{<{={>{?{@{A{B{C{D{E{F{G{H{I{J{K{L{M{N{O{P{Q{R{S{T{U{V{W{X{Y{Z{[{\{]{^{_{`{a{b(B")
(qdv "ghr"	"$(C{c{d{e(B")
(qdv "ghs"	"$(C{f{g{h{i{j{k(B")
(qdv "ghf"	"$(C{l{m{n(B")
(qdv "ghd"	"$(C{o{p{q{r{s{t{u{v{w{x(B")
(qdv "ghk"	"$(C{y{z{{{|{}{~|!|"|#|$|%|&|'|((B")
(qdv "ghkr"	"$(C|)|*|+|,|-|.(B")
(qdv "ghks"	"$(C|/|0|1|2|3|4|5|6|7|8|9|:|;|<|=|>|?(B")
(qdv "ghkf"	"$(C|@|A|B|C|D(B")
(qdv "ghkd"	"$(C|E|F|G|H|I|J|K|L|M|N|O|P|Q|R|S|T|U|V|W|X|Y|Z|[|\(B")
(qdv "ghl"	"$(C|]|^|_|`|a|b|c|d|e|f|g|h|i|j|k|l|m|n|o|p(B")
(qdv "ghlr"	"$(C|q|r(B")
(qdv "ghld"	"$(C|s|t|u(B")
(qdv "gy"	"$(C|v|w|x|y|z|{|||}|~}!}"}#}$(B")
(qdv "gn"	"$(C}%}&}'}(})}*}+},}-}.}/}0}1(B")
(qdv "gns"	"$(C}2}3}4}5}6}7}8}9}:};(B")
(qdv "gnd"	"$(C}<(B")
(qdv "gnjs"	"$(C}=}>}?}@(B")
(qdv "gnp"	"$(C}A}B}C(B")
(qdv "gnl"	"$(C}D}E}F}G}H}I}J}K(B")
(qdv "gb"	"$(C}L}M}N}O}P(B")
(qdv "gbf"	"$(C}Q}R}S(B")
(qdv "gbd"	"$(C}T}U}V}W}X(B")
(qdv "gmr"	"$(C}Y(B")
(qdv "gms"	"$(C}Z}[}\}](B")
(qdv "gmf"	"$(C}^}_}`}a(B")
(qdv "gma"	"$(C}b}c}d(B")
(qdv "gmq"	"$(C}e}f}g}h(B")
(qdv "gmd"	"$(C}i(B")
(qdv "gml"	"$(C}j}k}l}m}n}o}p}q}r}s}t}u}v}w}x}y}z}{}|}}(B")
(qdv "glf"	"$(C}~(B")

(quail-setup-current-package)
