;; Copyright (C) 1992 Free Software Foundation, Inc.
;; This file is part of Mule (MULtilingual Enhancement of GNU Emacs).

;; Mule is free software distributed in the form of patches to GNU Emacs.
;; You can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; Mule is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; 92.3.23  modified for Mule Ver.0.9.1 by K.Handa <handa@etl.go.jp>
;;;	defrule -> its-defrule, define-its-mode -> its-define-mode
;;; 92.7.10  modified for Mule Ver.0.9.5 by K.Handa <handa@etl.go.jp>
;;;	Modified from its-hangul.el
;;; 92.8.12  modified for Mule Ver.0.9.6
;;;		by S.Kobayashi <koba@keisu-s.t.u-tokyo.ac.jp>
;;;	Prompt of "hangul" package corrected.
;;; 92.9.29  modified for Mule Ver.0.9.6 by K.Handa <handa@etl.go.jp>
;;;	"p" is mapped to "$(C$D(B".
;;; 93.3.2   modified for Mule Ver.0.9.7.1
;;;		by Seo Young Jin <frog%math1.kaist.ac.kr@daiduk.kaist.ac.kr>
;;;	New package hangul3 is added.
;;; 93.3.26  modified for Mule Ver.0.9.7.1 by K.Handa <handa@etl.go.jp>
;;;		by Seo Young Jin <frog%math1.kaist.ac.kr@daiduk.kaist.ac.kr>
;;;	In hangle3 package, one entry is corrected.
;;; 93.7.27  modified for Mule Ver.0.9.8
;;;				by K.Un <zraun01@hpserv.zdv.uni-tuebingen.de>
;;;	Several maps are corrected/added.
;;; 93.7.28  modified for Mule Ver.0.9.8 by H.Tsuiki <tsuiki@sfc.keio.ac.jp>
;;;	"o" produce $(C$@(B.
;;; 93.8.2   modified for Mule Ver.0.9.8 by K.Handa <handa@etl.go.jp>
;;;	hangle3 packaged is put in a separated file.
;;; 93.11.19 modified for Mule Ver.1.1 by K.Handa <handa@etl.go.jp>
;;;	"P" produces "$(C$F(B".
;;; 95.7.1   modified for Mule Ver.2.2 by <koaunghi.un@zdv.uni-tuebingen.de>
;;;	Latin-alphabets, old-hanguls, symbols added.

(require 'quail)

(quail-define-package
 "hangul" "$(CGQ1[(B 2$(C9z=D(B"
 '((?r . "$(C$!(B") (?s . "$(C$$(B") (?e . "$(C$'(B") (?f . "$(C$)(B") (?a . "$(C$1(B")
   (?q . "$(C$2(B") (?t . "$(C$5(B") (?d . "$(C$7(B") (?w . "$(C$8(B") (?c . "$(C$:(B")
   (?z . "$(C$;(B") (?x . "$(C$<(B") (?v . "$(C$=(B") (?g . "$(C$>(B")
   (?R . "$(C$"(B") (?E . "$(C$((B") (?Q . "$(C$3(B") (?W . "$(C$9(B") (?T . "$(C$6(B")
   (?O . "$(C$B(B") (?P . "$(C$F(B")
   (?k . "$(C$?(B") (?i . "$(C$A(B") (?j . "$(C$C(B") (?p . "$(C$D(B") (?u . "$(C$E(B") (?h . "$(C$G(B")
   (?y . "$(C$K(B") (?n . "$(C$L(B") (?b . "$(C$P(B") (?m . "$(C$Q(B") (?l . "$(C$S(B"))
 "Hangul input method.
  $(CGQ1[(B:	$(C$!$"$$$'$($)$1$2$3$5$6$7$8$9$:$;$<$=$>$?$A$C$D$F$E$G$K$L$P$Q$S$@$B(B
  KEY:	r R s e E f a q Q t T d w W c z x v g k i j p P u h y n b m l o O

The key sequence \"Z<key>\" can be used for \"$(C#0(B..$(C#A(B..$(C#a(B..\".
The key sequence \"H<key-sequence>\" can be used for \"$(C$U$V(B...\".
The key sequnece \"S<key>\" can be used for such symbols as \"$(C!M!L"6(B...\".

You can use the key M-i to know the avairable key combination.
For instance, typing \"S\" followed by \"M-i\" will tell you
 which key you should type to input some specific symbol.
--- Example ---
<key sequence>		r	k	r	k
<string inserted>	$(C$!(B	$(C0!(B	$(C0"(B	$(C0!0!(B
<key sequence>		r	k	r	<M-SP>	k
<string inserted>	$(C$!(B	$(C0!(B	$(C0"(B	$(C0"(B	$(C0"$?(B"
 nil t t)

(qd "r"	?$(C$!(B)
(qd "s"	?$(C$$(B)
(qd "e"	?$(C$'(B)
(qd "f"	?$(C$)(B)
(qd "a"	?$(C$1(B)
(qd "q"	?$(C$2(B)
(qd "t"	?$(C$5(B)
(qd "d"	?$(C$7(B)
(qd "w"	?$(C$8(B)
(qd "c"	?$(C$:(B)
(qd "z"	?$(C$;(B)
(qd "x"	?$(C$<(B)
(qd "v"	?$(C$=(B)
(qd "g"	?$(C$>(B)

(qd "R"	?$(C$"(B)
(qd "E"	?$(C$((B)
(qd "Q"	?$(C$3(B)
(qd "W"	?$(C$9(B)
(qd "T"	?$(C$6(B)
(qd "P" ?$(C$F(B)

(qd "k"	?$(C$?(B)
(qd "i"	?$(C$A(B)
(qd "j"	?$(C$C(B)
(qd "p"	?$(C$D(B)
(qd "u"	?$(C$E(B)
(qd "h"	?$(C$G(B)
(qd "y"	?$(C$K(B)
(qd "n"	?$(C$L(B)
(qd "b"	?$(C$P(B)
(qd "m"	?$(C$Q(B)
(qd "l"	?$(C$S(B)
(qd "o"	?$(C$@(B)
(qd "O"	?$(C$B(B)

(qd "rk"	?$(C0!(B)
(qd "rkr"	?$(C0"(B)
(qd "rks"	?$(C0#(B)
(qd "rke"	?$(C0$(B)
(qd "rkf"	?$(C0%(B)
(qd "rkfr"	?$(C0&(B)
(qd "rkfa"	?$(C0'(B)
(qd "rka"	?$(C0((B)
(qd "rkq"	?$(C0)(B)
(qd "rkqt"	?$(C0*(B)
(qd "rkt"	?$(C0+(B)
(qd "rkT"	?$(C0,(B)
(qd "rkd"	?$(C0-(B)
(qd "rkw"	?$(C0.(B)
(qd "rkc"	?$(C0/(B)
(qd "rkx"	?$(C00(B)
(qd "rkv"	?$(C01(B)
(qd "rkg"	?$(C02(B)
(qd "ro"	?$(C03(B)
(qd "ror"	?$(C04(B)
(qd "ros"	?$(C05(B)
(qd "rof"	?$(C06(B)
(qd "roa"	?$(C07(B)
(qd "roq"	?$(C08(B)
(qd "rot"	?$(C09(B)
(qd "roT"	?$(C0:(B)
(qd "rod"	?$(C0;(B)
(qd "ri"	?$(C0<(B)
(qd "rir"	?$(C0=(B)
(qd "ris"	?$(C0>(B)
(qd "rif"	?$(C0?(B)
(qd "rit"	?$(C0@(B)
(qd "rid"	?$(C0A(B)
(qd "rO"	?$(C0B(B)
(qd "rOs"	?$(C0C(B)
(qd "rOf"	?$(C0D(B)
(qd "rj"	?$(C0E(B)
(qd "rjr"	?$(C0F(B)
(qd "rjs"	?$(C0G(B)
(qd "rje"	?$(C0H(B)
(qd "rjf"	?$(C0I(B)
(qd "rjfa"	?$(C0J(B)
(qd "rja"	?$(C0K(B)
(qd "rjq"	?$(C0L(B)
(qd "rjt"	?$(C0M(B)
(qd "rjT"	?$(C0N(B)
(qd "rjd"	?$(C0O(B)
(qd "rjw"	?$(C0P(B)
(qd "rjx"	?$(C0Q(B)
(qd "rjv"	?$(C0R(B)
(qd "rjg"	?$(C0S(B)
(qd "rp"	?$(C0T(B)
(qd "rps"	?$(C0U(B)
(qd "rpf"	?$(C0V(B)
(qd "rpa"	?$(C0W(B)
(qd "rpq"	?$(C0X(B)
(qd "rpt"	?$(C0Y(B)
(qd "rpd"	?$(C0[(B)
(qd "rpT"	?$(C0Z(B)
(qd "ru"	?$(C0\(B)
(qd "rur"	?$(C0](B)
(qd "ruR"	?$(C0^(B)
(qd "rus"	?$(C0_(B)
(qd "rue"	?$(C0`(B)
(qd "ruf"	?$(C0a(B)
(qd "rua"	?$(C0b(B)
(qd "ruq"	?$(C0c(B)
(qd "rut"	?$(C0d(B)
(qd "ruT"	?$(C0e(B)
(qd "rud"	?$(C0f(B)
(qd "rux"	?$(C0g(B)
(qd "rP"	?$(C0h(B)
(qd "rPs"	?$(C0i(B)
(qd "rPf"	?$(C0j(B)
(qd "rPq"	?$(C0k(B)
(qd "rPt"	?$(C0l(B)
(qd "rh"	?$(C0m(B)
(qd "rhr"	?$(C0n(B)
(qd "rhs"	?$(C0o(B)
(qd "rhe"	?$(C0p(B)
(qd "rhf"	?$(C0q(B)
(qd "rhfa"	?$(C0r(B)
(qd "rhft"	?$(C0s(B)
(qd "rhfg"	?$(C0t(B)
(qd "rha"	?$(C0u(B)
(qd "rhq"	?$(C0v(B)
(qd "rht"	?$(C0w(B)
(qd "rhd"	?$(C0x(B)
(qd "rhw"	?$(C0y(B)
(qd "rhk"	?$(C0z(B)
(qd "rhkr"	?$(C0{(B)
(qd "rhks"	?$(C0|(B)
(qd "rhkf"	?$(C0}(B)
(qd "rhkfa"	?$(C0~(B)
(qd "rhka"	?$(C1!(B)
(qd "rhkq"	?$(C1"(B)
(qd "rhkt"	?$(C1#(B)
(qd "rhkd"	?$(C1$(B)
(qd "rho"	?$(C1%(B)
(qd "rhos"	?$(C1&(B)
(qd "rhof"	?$(C1'(B)
(qd "rhoq"	?$(C1((B)
(qd "rhoT"	?$(C1)(B)
(qd "rhod"	?$(C1*(B)
(qd "rhl"	?$(C1+(B)
(qd "rhlr"	?$(C1,(B)
(qd "rhls"	?$(C1-(B)
(qd "rhlf"	?$(C1.(B)
(qd "rhla"	?$(C1/(B)
(qd "rhlq"	?$(C10(B)
(qd "rhlt"	?$(C11(B)
(qd "rhld"	?$(C12(B)
(qd "ry"	?$(C13(B)
(qd "rys"	?$(C14(B)
(qd "ryf"	?$(C15(B)
(qd "ryq"	?$(C16(B)
(qd "ryt"	?$(C17(B)
(qd "rn"	?$(C18(B)
(qd "rnr"	?$(C19(B)
(qd "rns"	?$(C1:(B)
(qd "rne"	?$(C1;(B)
(qd "rnf"	?$(C1<(B)
(qd "rnfr"	?$(C1=(B)
(qd "rnfa"	?$(C1>(B)
(qd "rnfg"	?$(C1?(B)
(qd "rna"	?$(C1@(B)
(qd "rnq"	?$(C1A(B)
(qd "rnt"	?$(C1B(B)
(qd "rnd"	?$(C1C(B)
(qd "rnw"	?$(C1D(B)
(qd "rnj"	?$(C1E(B)
(qd "rnjr"	?$(C1F(B)
(qd "rnjs"	?$(C1G(B)
(qd "rnjf"	?$(C1H(B)
(qd "rnjT"	?$(C1I(B)
(qd "rnjd"	?$(C1J(B)
(qd "rnp"	?$(C1K(B)
(qd "rnpt"	?$(C1L(B)
(qd "rnl"	?$(C1M(B)
(qd "rnlr"	?$(C1N(B)
(qd "rnls"	?$(C1O(B)
(qd "rnlf"	?$(C1P(B)
(qd "rnla"	?$(C1Q(B)
(qd "rnlq"	?$(C1R(B)
(qd "rnlt"	?$(C1S(B)
(qd "rb"	?$(C1T(B)
(qd "rbs"	?$(C1U(B)
(qd "rbf"	?$(C1V(B)
(qd "rm"	?$(C1W(B)
(qd "rmr"	?$(C1X(B)
(qd "rms"	?$(C1Y(B)
(qd "rme"	?$(C1Z(B)
(qd "rmf"	?$(C1[(B)
(qd "rmfr"	?$(C1\(B)
(qd "rma"	?$(C1](B)
(qd "rmq"	?$(C1^(B)
(qd "rmt"	?$(C1_(B)
(qd "rmd"	?$(C1`(B)
(qd "rml"	?$(C1a(B)
(qd "rl"	?$(C1b(B)
(qd "rlr"	?$(C1c(B)
(qd "rls"	?$(C1d(B)
(qd "rle"	?$(C1e(B)
(qd "rlf"	?$(C1f(B)
(qd "rlfa"	?$(C1g(B)
(qd "rla"	?$(C1h(B)
(qd "rlq"	?$(C1i(B)
(qd "rlt"	?$(C1j(B)
(qd "rld"	?$(C1k(B)
(qd "rlw"	?$(C1l(B)
(qd "rlv"	?$(C1m(B)
(qd "Rk"	?$(C1n(B)
(qd "Rkr"	?$(C1o(B)
(qd "RkR"	?$(C1p(B)
(qd "Rks"	?$(C1q(B)
(qd "Rkf"	?$(C1r(B)
(qd "Rkfa"	?$(C1s(B)
(qd "Rka"	?$(C1t(B)
(qd "Rkq"	?$(C1u(B)
(qd "Rkt"	?$(C1v(B)
(qd "RkT"	?$(C1w(B)
(qd "Rkd"	?$(C1x(B)
(qd "Rkx"	?$(C1y(B)
(qd "Ro"	?$(C1z(B)
(qd "Ror"	?$(C1{(B)
(qd "Ros"	?$(C1|(B)
(qd "Rof"	?$(C1}(B)
(qd "Roa"	?$(C1~(B)
(qd "Roq"	?$(C2!(B)
(qd "Rot"	?$(C2"(B)
(qd "RoT"	?$(C2#(B)
(qd "Rod"	?$(C2$(B)
(qd "Ri"	?$(C2%(B)
(qd "Rir"	?$(C2&(B)
(qd "Rif"	?$(C2'(B)
(qd "Rj"	?$(C2((B)
(qd "Rjr"	?$(C2)(B)
(qd "RjR"	?$(C2*(B)
(qd "Rjs"	?$(C2+(B)
(qd "Rjf"	?$(C2,(B)
(qd "Rja"	?$(C2-(B)
(qd "Rjq"	?$(C2.(B)
(qd "Rjt"	?$(C2/(B)
(qd "RjT"	?$(C20(B)
(qd "Rjd"	?$(C21(B)
(qd "Rp"	?$(C22(B)
(qd "Rpr"	?$(C23(B)
(qd "Rps"	?$(C24(B)
(qd "Rpa"	?$(C25(B)
(qd "Rpt"	?$(C26(B)
(qd "Rpd"	?$(C27(B)
(qd "Ru"	?$(C28(B)
(qd "Rus"	?$(C29(B)
(qd "Ruf"	?$(C2:(B)
(qd "Rut"	?$(C2;(B)
(qd "RuT"	?$(C2<(B)
(qd "Rux"	?$(C2=(B)
(qd "RP"	?$(C2>(B)
(qd "Rh"	?$(C2?(B)
(qd "Rhr"	?$(C2@(B)
(qd "Rhs"	?$(C2A(B)
(qd "Rhsg"	?$(C2B(B)
(qd "Rhf"	?$(C2C(B)
(qd "Rha"	?$(C2D(B)
(qd "Rhq"	?$(C2E(B)
(qd "Rht"	?$(C2F(B)
(qd "Rhd"	?$(C2G(B)
(qd "Rhw"	?$(C2H(B)
(qd "Rhc"	?$(C2I(B)
(qd "Rhk"	?$(C2J(B)
(qd "Rhkr"	?$(C2K(B)
(qd "Rhkf"	?$(C2L(B)
(qd "RhkT"	?$(C2M(B)
(qd "Rhkd"	?$(C2N(B)
(qd "Rho"	?$(C2O(B)
(qd "Rhor"	?$(C2P(B)
(qd "Rhod"	?$(C2Q(B)
(qd "Rhl"	?$(C2R(B)
(qd "Rhls"	?$(C2S(B)
(qd "Rhlf"	?$(C2T(B)
(qd "Rhla"	?$(C2U(B)
(qd "Rhlq"	?$(C2V(B)
(qd "Rhld"	?$(C2W(B)
(qd "Ry"	?$(C2X(B)
(qd "Rn"	?$(C2Y(B)
(qd "Rnr"	?$(C2Z(B)
(qd "Rns"	?$(C2[(B)
(qd "Rnf"	?$(C2\(B)
(qd "Rnfg"	?$(C2](B)
(qd "Rna"	?$(C2^(B)
(qd "Rnq"	?$(C2_(B)
(qd "Rnt"	?$(C2`(B)
(qd "Rnd"	?$(C2a(B)
(qd "Rnw"	?$(C2b(B)
(qd "Rnj"	?$(C2c(B)
(qd "Rnjf"	?$(C2d(B)
(qd "RnjT"	?$(C2e(B)
(qd "Rnjd"	?$(C2f(B)
(qd "Rnp"	?$(C2g(B)
(qd "Rnpr"	?$(C2h(B)
(qd "Rnps"	?$(C2i(B)
(qd "Rnpf"	?$(C2j(B)
(qd "Rnpa"	?$(C2k(B)
(qd "Rnpq"	?$(C2l(B)
(qd "RnpT"	?$(C2m(B)
(qd "Rnl"	?$(C2n(B)
(qd "Rnls"	?$(C2o(B)
(qd "Rnlf"	?$(C2p(B)
(qd "Rnla"	?$(C2q(B)
(qd "Rnlq"	?$(C2r(B)
(qd "Rb"	?$(C2s(B)
(qd "Rm"	?$(C2t(B)
(qd "Rmr"	?$(C2u(B)
(qd "Rms"	?$(C2v(B)
(qd "Rmsg"	?$(C2w(B)
(qd "Rmf"	?$(C2x(B)
(qd "Rmfa"	?$(C2y(B)
(qd "Rmfg"	?$(C2z(B)
(qd "Rma"	?$(C2{(B)
(qd "Rmq"	?$(C2|(B)
(qd "Rmt"	?$(C2}(B)
(qd "Rmd"	?$(C2~(B)
(qd "Rmx"	?$(C3!(B)
(qd "Rl"	?$(C3"(B)
(qd "Rlr"	?$(C3#(B)
(qd "Rls"	?$(C3$(B)
(qd "Rlf"	?$(C3%(B)
(qd "Rla"	?$(C3&(B)
(qd "Rlq"	?$(C3'(B)
(qd "Rlt"	?$(C3((B)
(qd "Rld"	?$(C3)(B)
(qd "sk"	?$(C3*(B)
(qd "skr"	?$(C3+(B)
(qd "skR"	?$(C3,(B)
(qd "sks"	?$(C3-(B)
(qd "ske"	?$(C3.(B)
(qd "skf"	?$(C3/(B)
(qd "skfr"	?$(C30(B)
(qd "skfa"	?$(C31(B)
(qd "ska"	?$(C32(B)
(qd "skq"	?$(C33(B)
(qd "skt"	?$(C34(B)
(qd "skT"	?$(C35(B)
(qd "skd"	?$(C36(B)
(qd "skw"	?$(C37(B)
(qd "skc"	?$(C38(B)
(qd "skx"	?$(C39(B)
(qd "skg"	?$(C3:(B)
(qd "so"	?$(C3;(B)
(qd "sor"	?$(C3<(B)
(qd "sos"	?$(C3=(B)
(qd "sof"	?$(C3>(B)
(qd "soa"	?$(C3?(B)
(qd "soq"	?$(C3@(B)
(qd "sot"	?$(C3A(B)
(qd "soT"	?$(C3B(B)
(qd "sod"	?$(C3C(B)
(qd "si"	?$(C3D(B)
(qd "sir"	?$(C3E(B)
(qd "sis"	?$(C3F(B)
(qd "sif"	?$(C3G(B)
(qd "sia"	?$(C3H(B)
(qd "sid"	?$(C3I(B)
(qd "sj"	?$(C3J(B)
(qd "sjr"	?$(C3K(B)
(qd "sjrt"	?$(C3L(B)
(qd "sjs"	?$(C3M(B)
(qd "sjf"	?$(C3N(B)
(qd "sjfa"	?$(C3O(B)
(qd "sjfq"	?$(C3P(B)
(qd "sja"	?$(C3Q(B)
(qd "sjq"	?$(C3R(B)
(qd "sjt"	?$(C3S(B)
(qd "sjT"	?$(C3T(B)
(qd "sjd"	?$(C3U(B)
(qd "sjg"	?$(C3V(B)
(qd "sp"	?$(C3W(B)
(qd "spr"	?$(C3X(B)
(qd "sps"	?$(C3Y(B)
(qd "spf"	?$(C3Z(B)
(qd "spa"	?$(C3[(B)
(qd "spq"	?$(C3\(B)
(qd "spt"	?$(C3](B)
(qd "spT"	?$(C3^(B)
(qd "spd"	?$(C3_(B)
(qd "su"	?$(C3`(B)
(qd "sur"	?$(C3a(B)
(qd "sus"	?$(C3b(B)
(qd "suf"	?$(C3c(B)
(qd "sua"	?$(C3d(B)
(qd "suq"	?$(C3e(B)
(qd "suT"	?$(C3f(B)
(qd "sud"	?$(C3g(B)
(qd "suz"	?$(C3h(B)
(qd "sP"	?$(C3i(B)
(qd "sPs"	?$(C3j(B)
(qd "sh"	?$(C3k(B)
(qd "shr"	?$(C3l(B)
(qd "shs"	?$(C3m(B)
(qd "shf"	?$(C3n(B)
(qd "shfa"	?$(C3o(B)
(qd "sha"	?$(C3p(B)
(qd "shq"	?$(C3q(B)
(qd "sht"	?$(C3r(B)
(qd "shd"	?$(C3s(B)
(qd "shv"	?$(C3t(B)
(qd "shg"	?$(C3u(B)
(qd "shk"	?$(C3v(B)
(qd "shks"	?$(C3w(B)
(qd "shkf"	?$(C3x(B)
(qd "shkT"	?$(C3y(B)
(qd "shl"	?$(C3z(B)
(qd "shls"	?$(C3{(B)
(qd "shlf"	?$(C3|(B)
(qd "shla"	?$(C3}(B)
(qd "shlq"	?$(C3~(B)
(qd "shlt"	?$(C4!(B)
(qd "sy"	?$(C4"(B)
(qd "syr"	?$(C4#(B)
(qd "sys"	?$(C4$(B)
(qd "syf"	?$(C4%(B)
(qd "syq"	?$(C4&(B)
(qd "syt"	?$(C4'(B)
(qd "syd"	?$(C4((B)
(qd "sn"	?$(C4)(B)
(qd "snr"	?$(C4*(B)
(qd "sns"	?$(C4+(B)
(qd "sne"	?$(C4,(B)
(qd "snf"	?$(C4-(B)
(qd "sna"	?$(C4.(B)
(qd "snq"	?$(C4/(B)
(qd "snt"	?$(C40(B)
(qd "snd"	?$(C41(B)
(qd "snj"	?$(C42(B)
(qd "snjT"	?$(C43(B)
(qd "snp"	?$(C44(B)
(qd "snl"	?$(C45(B)
(qd "snls"	?$(C46(B)
(qd "snlf"	?$(C47(B)
(qd "snla"	?$(C48(B)
(qd "snlq"	?$(C49(B)
(qd "sb"	?$(C4:(B)
(qd "sbr"	?$(C4;(B)
(qd "sbf"	?$(C4<(B)
(qd "sba"	?$(C4=(B)
(qd "sbq"	?$(C4>(B)
(qd "sbd"	?$(C4?(B)
(qd "sm"	?$(C4@(B)
(qd "smr"	?$(C4A(B)
(qd "sms"	?$(C4B(B)
(qd "smf"	?$(C4C(B)
(qd "smfr"	?$(C4D(B)
(qd "smfa"	?$(C4E(B)
(qd "sma"	?$(C4F(B)
(qd "smq"	?$(C4G(B)
(qd "smt"	?$(C4H(B)
(qd "smd"	?$(C4I(B)
(qd "smw"	?$(C4J(B)
(qd "smv"	?$(C4K(B)
(qd "sml"	?$(C4L(B)
(qd "smls"	?$(C4M(B)
(qd "smlf"	?$(C4N(B)
(qd "sl"	?$(C4O(B)
(qd "slr"	?$(C4P(B)
(qd "sls"	?$(C4Q(B)
(qd "slf"	?$(C4R(B)
(qd "slfa"	?$(C4S(B)
(qd "sla"	?$(C4T(B)
(qd "slq"	?$(C4U(B)
(qd "slt"	?$(C4V(B)
(qd "sld"	?$(C4W(B)
(qd "slv"	?$(C4X(B)
(qd "ek"	?$(C4Y(B)
(qd "ekr"	?$(C4Z(B)
(qd "ekR"	?$(C4[(B)
(qd "eks"	?$(C4\(B)
(qd "eke"	?$(C4](B)
(qd "ekf"	?$(C4^(B)
(qd "ekfr"	?$(C4_(B)
(qd "ekfa"	?$(C4`(B)
(qd "ekfq"	?$(C4a(B)
(qd "ekfg"	?$(C4b(B)
(qd "eka"	?$(C4c(B)
(qd "ekq"	?$(C4d(B)
(qd "ekt"	?$(C4e(B)
(qd "ekT"	?$(C4f(B)
(qd "ekd"	?$(C4g(B)
(qd "ekw"	?$(C4h(B)
(qd "ekc"	?$(C4i(B)
(qd "ekg"	?$(C4j(B)
(qd "eo"	?$(C4k(B)
(qd "eor"	?$(C4l(B)
(qd "eos"	?$(C4m(B)
(qd "eof"	?$(C4n(B)
(qd "eoa"	?$(C4o(B)
(qd "eoq"	?$(C4p(B)
(qd "eot"	?$(C4q(B)
(qd "eoT"	?$(C4r(B)
(qd "eod"	?$(C4s(B)
(qd "ei"	?$(C4t(B)
(qd "ej"	?$(C4u(B)
(qd "ejr"	?$(C4v(B)
(qd "ejR"	?$(C4w(B)
(qd "ejs"	?$(C4x(B)
(qd "eje"	?$(C4y(B)
(qd "ejf"	?$(C4z(B)
(qd "ejfa"	?$(C4{(B)
(qd "ejfq"	?$(C4|(B)
(qd "eja"	?$(C4}(B)
(qd "ejq"	?$(C4~(B)
(qd "ejt"	?$(C5!(B)
(qd "ejd"	?$(C5"(B)
(qd "ejc"	?$(C5#(B)
(qd "ejv"	?$(C5$(B)
(qd "ep"	?$(C5%(B)
(qd "epr"	?$(C5&(B)
(qd "eps"	?$(C5'(B)
(qd "epf"	?$(C5((B)
(qd "epa"	?$(C5)(B)
(qd "epq"	?$(C5*(B)
(qd "ept"	?$(C5+(B)
(qd "epT"	?$(C5,(B)
(qd "epd"	?$(C5-(B)
(qd "eu"	?$(C5.(B)
(qd "eus"	?$(C5/(B)
(qd "euf"	?$(C50(B)
(qd "euT"	?$(C51(B)
(qd "eud"	?$(C52(B)
(qd "eP"	?$(C53(B)
(qd "ePs"	?$(C54(B)
(qd "eh"	?$(C55(B)
(qd "ehr"	?$(C56(B)
(qd "ehs"	?$(C57(B)
(qd "ehe"	?$(C58(B)
(qd "ehf"	?$(C59(B)
(qd "ehfa"	?$(C5:(B)
(qd "ehft"	?$(C5;(B)
(qd "eha"	?$(C5<(B)
(qd "ehq"	?$(C5=(B)
(qd "eht"	?$(C5>(B)
(qd "ehd"	?$(C5?(B)
(qd "ehc"	?$(C5@(B)
(qd "ehx"	?$(C5A(B)
(qd "ehk"	?$(C5B(B)
(qd "ehks"	?$(C5C(B)
(qd "ehkf"	?$(C5D(B)
(qd "eho"	?$(C5E(B)
(qd "ehoT"	?$(C5F(B)
(qd "ehl"	?$(C5G(B)
(qd "ehls"	?$(C5H(B)
(qd "ehlf"	?$(C5I(B)
(qd "ehla"	?$(C5J(B)
(qd "ehlq"	?$(C5K(B)
(qd "ehlt"	?$(C5L(B)
(qd "ey"	?$(C5M(B)
(qd "en"	?$(C5N(B)
(qd "enr"	?$(C5O(B)
(qd "ens"	?$(C5P(B)
(qd "enf"	?$(C5Q(B)
(qd "ena"	?$(C5R(B)
(qd "enq"	?$(C5S(B)
(qd "ent"	?$(C5T(B)
(qd "end"	?$(C5U(B)
(qd "enj"	?$(C5V(B)
(qd "enjT"	?$(C5W(B)
(qd "enp"	?$(C5X(B)
(qd "enpd"	?$(C5Y(B)
(qd "enl"	?$(C5Z(B)
(qd "enls"	?$(C5[(B)
(qd "enlf"	?$(C5\(B)
(qd "enlq"	?$(C5](B)
(qd "enlt"	?$(C5^(B)
(qd "enld"	?$(C5_(B)
(qd "eb"	?$(C5`(B)
(qd "ebs"	?$(C5a(B)
(qd "ebf"	?$(C5b(B)
(qd "eba"	?$(C5c(B)
(qd "ebd"	?$(C5d(B)
(qd "em"	?$(C5e(B)
(qd "emr"	?$(C5f(B)
(qd "ems"	?$(C5g(B)
(qd "eme"	?$(C5h(B)
(qd "emf"	?$(C5i(B)
(qd "emfa"	?$(C5j(B)
(qd "ema"	?$(C5k(B)
(qd "emq"	?$(C5l(B)
(qd "emt"	?$(C5m(B)
(qd "emd"	?$(C5n(B)
(qd "eml"	?$(C5o(B)
(qd "el"	?$(C5p(B)
(qd "elr"	?$(C5q(B)
(qd "els"	?$(C5r(B)
(qd "ele"	?$(C5s(B)
(qd "elf"	?$(C5t(B)
(qd "ela"	?$(C5u(B)
(qd "elq"	?$(C5v(B)
(qd "elt"	?$(C5w(B)
(qd "elT"	?$(C5x(B)
(qd "eld"	?$(C5y(B)
(qd "elw"	?$(C5z(B)
(qd "Ek"	?$(C5{(B)
(qd "Ekr"	?$(C5|(B)
(qd "Eks"	?$(C5}(B)
(qd "Ekf"	?$(C5~(B)
(qd "Eka"	?$(C6!(B)
(qd "Ekq"	?$(C6"(B)
(qd "Ekt"	?$(C6#(B)
(qd "EkT"	?$(C6$(B)
(qd "Ekd"	?$(C6%(B)
(qd "Ekg"	?$(C6&(B)
(qd "Eo"	?$(C6'(B)
(qd "Eor"	?$(C6((B)
(qd "Eos"	?$(C6)(B)
(qd "Eof"	?$(C6*(B)
(qd "Eoa"	?$(C6+(B)
(qd "Eoq"	?$(C6,(B)
(qd "Eot"	?$(C6-(B)
(qd "EoT"	?$(C6.(B)
(qd "Eod"	?$(C6/(B)
(qd "Ej"	?$(C60(B)
(qd "Ejr"	?$(C61(B)
(qd "Ejs"	?$(C62(B)
(qd "Ejf"	?$(C63(B)
(qd "Ejfa"	?$(C64(B)
(qd "Ejfq"	?$(C65(B)
(qd "Eja"	?$(C66(B)
(qd "Ejq"	?$(C67(B)
(qd "Ejt"	?$(C68(B)
(qd "EjT"	?$(C69(B)
(qd "Ejd"	?$(C6:(B)
(qd "Ejg"	?$(C6;(B)
(qd "Ep"	?$(C6<(B)
(qd "Epr"	?$(C6=(B)
(qd "Eps"	?$(C6>(B)
(qd "Epf"	?$(C6?(B)
(qd "Epa"	?$(C6@(B)
(qd "Epq"	?$(C6A(B)
(qd "Ept"	?$(C6B(B)
(qd "EpT"	?$(C6C(B)
(qd "Epd"	?$(C6D(B)
(qd "Eu"	?$(C6E(B)
(qd "EuT"	?$(C6F(B)
(qd "Eh"	?$(C6G(B)
(qd "Ehr"	?$(C6H(B)
(qd "Ehs"	?$(C6I(B)
(qd "Ehf"	?$(C6J(B)
(qd "Ehd"	?$(C6K(B)
(qd "Ehk"	?$(C6L(B)
(qd "Ehkf"	?$(C6M(B)
(qd "Eho"	?$(C6N(B)
(qd "Ehl"	?$(C6O(B)
(qd "Ehls"	?$(C6P(B)
(qd "En"	?$(C6Q(B)
(qd "Enr"	?$(C6R(B)
(qd "Ens"	?$(C6S(B)
(qd "Enf"	?$(C6T(B)
(qd "Enfg"	?$(C6U(B)
(qd "Ena"	?$(C6V(B)
(qd "End"	?$(C6W(B)
(qd "Enp"	?$(C6X(B)
(qd "Enl"	?$(C6Y(B)
(qd "Enls"	?$(C6Z(B)
(qd "Enlf"	?$(C6[(B)
(qd "Enla"	?$(C6\(B)
(qd "Enlq"	?$(C6](B)
(qd "Enld"	?$(C6^(B)
(qd "Em"	?$(C6_(B)
(qd "Emr"	?$(C6`(B)
(qd "Ems"	?$(C6a(B)
(qd "Eme"	?$(C6b(B)
(qd "Emf"	?$(C6c(B)
(qd "Ema"	?$(C6d(B)
(qd "Emq"	?$(C6e(B)
(qd "Emt"	?$(C6f(B)
(qd "Eml"	?$(C6g(B)
(qd "Emls"	?$(C6h(B)
(qd "Emlf"	?$(C6i(B)
(qd "Emla"	?$(C6j(B)
(qd "Emlq"	?$(C6k(B)
(qd "El"	?$(C6l(B)
(qd "Els"	?$(C6m(B)
(qd "Elf"	?$(C6n(B)
(qd "Ela"	?$(C6o(B)
(qd "Elq"	?$(C6p(B)
(qd "Elt"	?$(C6q(B)
(qd "Eld"	?$(C6r(B)
(qd "fk"	?$(C6s(B)
(qd "fkr"	?$(C6t(B)
(qd "fks"	?$(C6u(B)
(qd "fkf"	?$(C6v(B)
(qd "fka"	?$(C6w(B)
(qd "fkq"	?$(C6x(B)
(qd "fkt"	?$(C6y(B)
(qd "fkT"	?$(C6z(B)
(qd "fkd"	?$(C6{(B)
(qd "fkw"	?$(C6|(B)
(qd "fkv"	?$(C6}(B)
(qd "fkg"	?$(C6~(B)
(qd "fo"	?$(C7!(B)
(qd "for"	?$(C7"(B)
(qd "fos"	?$(C7#(B)
(qd "fof"	?$(C7$(B)
(qd "foa"	?$(C7%(B)
(qd "foq"	?$(C7&(B)
(qd "fot"	?$(C7'(B)
(qd "foT"	?$(C7((B)
(qd "fod"	?$(C7)(B)
(qd "fi"	?$(C7*(B)
(qd "fir"	?$(C7+(B)
(qd "fis"	?$(C7,(B)
(qd "fit"	?$(C7-(B)
(qd "fid"	?$(C7.(B)
(qd "fj"	?$(C7/(B)
(qd "fjr"	?$(C70(B)
(qd "fjs"	?$(C71(B)
(qd "fjf"	?$(C72(B)
(qd "fja"	?$(C73(B)
(qd "fjq"	?$(C74(B)
(qd "fjt"	?$(C75(B)
(qd "fjT"	?$(C76(B)
(qd "fjd"	?$(C77(B)
(qd "fjg"	?$(C78(B)
(qd "fp"	?$(C79(B)
(qd "fpr"	?$(C7:(B)
(qd "fps"	?$(C7;(B)
(qd "fpf"	?$(C7<(B)
(qd "fpa"	?$(C7=(B)
(qd "fpq"	?$(C7>(B)
(qd "fpt"	?$(C7?(B)
(qd "fpd"	?$(C7@(B)
(qd "fu"	?$(C7A(B)
(qd "fur"	?$(C7B(B)
(qd "fus"	?$(C7C(B)
(qd "fuf"	?$(C7D(B)
(qd "fua"	?$(C7E(B)
(qd "fuq"	?$(C7F(B)
(qd "fut"	?$(C7G(B)
(qd "fuT"	?$(C7H(B)
(qd "fud"	?$(C7I(B)
(qd "fP"	?$(C7J(B)
(qd "fPs"	?$(C7K(B)
(qd "fPq"	?$(C7L(B)
(qd "fPt"	?$(C7M(B)
(qd "fh"	?$(C7N(B)
(qd "fhr"	?$(C7O(B)
(qd "fhs"	?$(C7P(B)
(qd "fhf"	?$(C7Q(B)
(qd "fha"	?$(C7R(B)
(qd "fhq"	?$(C7S(B)
(qd "fht"	?$(C7T(B)
(qd "fhd"	?$(C7U(B)
(qd "fhk"	?$(C7V(B)
(qd "fhks"	?$(C7W(B)
(qd "fhkd"	?$(C7X(B)
(qd "fhoT"	?$(C7Y(B)
(qd "fhl"	?$(C7Z(B)
(qd "fhls"	?$(C7[(B)
(qd "fhlf"	?$(C7\(B)
(qd "fhla"	?$(C7](B)
(qd "fhlq"	?$(C7^(B)
(qd "fhlt"	?$(C7_(B)
(qd "fhld"	?$(C7`(B)
(qd "fy"	?$(C7a(B)
(qd "fys"	?$(C7b(B)
(qd "fyf"	?$(C7c(B)
(qd "fyq"	?$(C7d(B)
(qd "fyt"	?$(C7e(B)
(qd "fyd"	?$(C7f(B)
(qd "fn"	?$(C7g(B)
(qd "fnr"	?$(C7h(B)
(qd "fns"	?$(C7i(B)
(qd "fnf"	?$(C7j(B)
(qd "fna"	?$(C7k(B)
(qd "fnq"	?$(C7l(B)
(qd "fnt"	?$(C7m(B)
(qd "fnd"	?$(C7n(B)
(qd "fnj"	?$(C7o(B)
(qd "fnjT"	?$(C7p(B)
(qd "fnp"	?$(C7q(B)
(qd "fnl"	?$(C7r(B)
(qd "fnlr"	?$(C7s(B)
(qd "fnls"	?$(C7t(B)
(qd "fnlf"	?$(C7u(B)
(qd "fnla"	?$(C7v(B)
(qd "fnlt"	?$(C7w(B)
(qd "fnld"	?$(C7x(B)
(qd "fb"	?$(C7y(B)
(qd "fbr"	?$(C7z(B)
(qd "fbs"	?$(C7{(B)
(qd "fbf"	?$(C7|(B)
(qd "fba"	?$(C7}(B)
(qd "fbq"	?$(C7~(B)
(qd "fbt"	?$(C8!(B)
(qd "fbd"	?$(C8"(B)
(qd "fm"	?$(C8#(B)
(qd "fmr"	?$(C8$(B)
(qd "fms"	?$(C8%(B)
(qd "fmf"	?$(C8&(B)
(qd "fma"	?$(C8'(B)
(qd "fmq"	?$(C8((B)
(qd "fmt"	?$(C8)(B)
(qd "fmd"	?$(C8*(B)
(qd "fmw"	?$(C8+(B)
(qd "fmx"	?$(C8,(B)
(qd "fmv"	?$(C8-(B)
(qd "fl"	?$(C8.(B)
(qd "flr"	?$(C8/(B)
(qd "fls"	?$(C80(B)
(qd "flf"	?$(C81(B)
(qd "fla"	?$(C82(B)
(qd "flq"	?$(C83(B)
(qd "flt"	?$(C84(B)
(qd "fld"	?$(C85(B)
(qd "ak"	?$(C86(B)
(qd "akr"	?$(C87(B)
(qd "aks"	?$(C88(B)
(qd "aksg"	?$(C89(B)
(qd "ake"	?$(C8:(B)
(qd "akf"	?$(C8;(B)
(qd "akfr"	?$(C8<(B)
(qd "akfa"	?$(C8=(B)
(qd "aka"	?$(C8>(B)
(qd "akq"	?$(C8?(B)
(qd "akt"	?$(C8@(B)
(qd "akd"	?$(C8A(B)
(qd "akw"	?$(C8B(B)
(qd "akx"	?$(C8C(B)
(qd "akg"	?$(C8D(B)
(qd "ao"	?$(C8E(B)
(qd "aor"	?$(C8F(B)
(qd "aos"	?$(C8G(B)
(qd "aof"	?$(C8H(B)
(qd "aoa"	?$(C8I(B)
(qd "aoq"	?$(C8J(B)
(qd "aot"	?$(C8K(B)
(qd "aoT"	?$(C8L(B)
(qd "aod"	?$(C8M(B)
(qd "aow"	?$(C8N(B)
(qd "ai"	?$(C8O(B)
(qd "air"	?$(C8P(B)
(qd "aif"	?$(C8Q(B)
(qd "aid"	?$(C8R(B)
(qd "aj"	?$(C8S(B)
(qd "ajr"	?$(C8T(B)
(qd "ajs"	?$(C8U(B)
(qd "ajf"	?$(C8V(B)
(qd "ajfa"	?$(C8W(B)
(qd "aja"	?$(C8X(B)
(qd "ajq"	?$(C8Y(B)
(qd "ajt"	?$(C8Z(B)
(qd "ajd"	?$(C8[(B)
(qd "ajw"	?$(C8\(B)
(qd "ajg"	?$(C8](B)
(qd "ap"	?$(C8^(B)
(qd "apr"	?$(C8_(B)
(qd "aps"	?$(C8`(B)
(qd "apf"	?$(C8a(B)
(qd "apa"	?$(C8b(B)
(qd "apq"	?$(C8c(B)
(qd "apt"	?$(C8d(B)
(qd "apT"	?$(C8e(B)
(qd "apd"	?$(C8f(B)
(qd "au"	?$(C8g(B)
(qd "aur"	?$(C8h(B)
(qd "aus"	?$(C8i(B)
(qd "auf"	?$(C8j(B)
(qd "aut"	?$(C8k(B)
(qd "auT"	?$(C8l(B)
(qd "aud"	?$(C8m(B)
(qd "auc"	?$(C8n(B)
(qd "aP"	?$(C8o(B)
(qd "ah"	?$(C8p(B)
(qd "ahr"	?$(C8q(B)
(qd "ahrt"	?$(C8r(B)
(qd "ahs"	?$(C8s(B)
(qd "ahf"	?$(C8t(B)
(qd "ahfa"	?$(C8u(B)
(qd "aha"	?$(C8v(B)
(qd "ahq"	?$(C8w(B)
(qd "aht"	?$(C8x(B)
(qd "ahd"	?$(C8y(B)
(qd "ahk"	?$(C8z(B)
(qd "ahks"	?$(C8{(B)
(qd "ahkT"	?$(C8|(B)
(qd "ahkd"	?$(C8}(B)
(qd "ahl"	?$(C8~(B)

(qd "ahls"	?$(C9!(B)
(qd "ahlf"	?$(C9"(B)
(qd "ahlq"	?$(C9#(B)
(qd "ahlt"	?$(C9$(B)
(qd "ahld"	?$(C9%(B)
(qd "ay"	?$(C9&(B)
(qd "ays"	?$(C9'(B)
(qd "ayf"	?$(C9((B)
(qd "ayq"	?$(C9)(B)
(qd "ayt"	?$(C9*(B)
(qd "an"	?$(C9+(B)
(qd "anr"	?$(C9,(B)
(qd "anR"	?$(C9-(B)
(qd "ans"	?$(C9.(B)
(qd "ane"	?$(C9/(B)
(qd "anf"	?$(C90(B)
(qd "anfr"	?$(C91(B)
(qd "anfa"	?$(C92(B)
(qd "ana"	?$(C93(B)
(qd "anq"	?$(C94(B)
(qd "ant"	?$(C95(B)
(qd "and"	?$(C96(B)
(qd "anx"	?$(C97(B)
(qd "ang"	?$(C98(B)
(qd "anj"	?$(C99(B)
(qd "anjs"	?$(C9:(B)
(qd "anjf"	?$(C9;(B)
(qd "anjq"	?$(C9<(B)
(qd "anjt"	?$(C9=(B)
(qd "anp"	?$(C9>(B)
(qd "anl"	?$(C9?(B)
(qd "anls"	?$(C9@(B)
(qd "anlf"	?$(C9A(B)
(qd "ab"	?$(C9B(B)

(qd "abs"	?$(C9C(B)
(qd "abf"	?$(C9D(B)
(qd "aba"	?$(C9E(B)
(qd "abt"	?$(C9F(B)
(qd "am"	?$(C9G(B)
(qd "ams"	?$(C9H(B)
(qd "amf"	?$(C9I(B)
(qd "ama"	?$(C9J(B)
(qd "amt"	?$(C9K(B)
(qd "al"	?$(C9L(B)
(qd "alr"	?$(C9M(B)
(qd "als"	?$(C9N(B)
(qd "ale"	?$(C9O(B)
(qd "alf"	?$(C9P(B)
(qd "alfa"	?$(C9Q(B)
(qd "ala"	?$(C9R(B)
(qd "alq"	?$(C9S(B)
(qd "alt"	?$(C9T(B)
(qd "alT"	?$(C9U(B)
(qd "ald"	?$(C9V(B)
(qd "alc"	?$(C9W(B)
(qd "alx"	?$(C9X(B)
(qd "qk"	?$(C9Y(B)
(qd "qkr"	?$(C9Z(B)
(qd "qkR"	?$(C9[(B)
(qd "qkrt"	?$(C9\(B)
(qd "qks"	?$(C9](B)
(qd "qke"	?$(C9^(B)
(qd "qkf"	?$(C9_(B)
(qd "qkfr"	?$(C9`(B)
(qd "qkfa"	?$(C9a(B)
(qd "qkfq"	?$(C9b(B)
(qd "qka"	?$(C9c(B)
(qd "qkq"	?$(C9d(B)
(qd "qkt"	?$(C9e(B)
(qd "qkd"	?$(C9f(B)
(qd "qkx"	?$(C9g(B)
(qd "qo"	?$(C9h(B)
(qd "qor"	?$(C9i(B)
(qd "qos"	?$(C9j(B)
(qd "qof"	?$(C9k(B)
(qd "qoa"	?$(C9l(B)
(qd "qoq"	?$(C9m(B)
(qd "qot"	?$(C9n(B)
(qd "qoT"	?$(C9o(B)
(qd "qod"	?$(C9p(B)
(qd "qox"	?$(C9q(B)
(qd "qi"	?$(C9r(B)
(qd "qir"	?$(C9s(B)
(qd "qis"	?$(C9t(B)
(qd "qiq"	?$(C9u(B)
(qd "qj"	?$(C9v(B)
(qd "qjr"	?$(C9w(B)
(qd "qjs"	?$(C9x(B)
(qd "qje"	?$(C9y(B)
(qd "qjf"	?$(C9z(B)
(qd "qjfa"	?$(C9{(B)
(qd "qja"	?$(C9|(B)
(qd "qjq"	?$(C9}(B)
(qd "qjt"	?$(C9~(B)
(qd "qjd"	?$(C:!(B)
(qd "qjw"	?$(C:"(B)
(qd "qp"	?$(C:#(B)
(qd "qpr"	?$(C:$(B)
(qd "qps"	?$(C:%(B)
(qd "qpe"	?$(C:&(B)
(qd "qpf"	?$(C:'(B)
(qd "qpa"	?$(C:((B)
(qd "qpq"	?$(C:)(B)
(qd "qpt"	?$(C:*(B)
(qd "qpT"	?$(C:+(B)
(qd "qpd"	?$(C:,(B)
(qd "qu"	?$(C:-(B)
(qd "qur"	?$(C:.(B)
(qd "qus"	?$(C:/(B)
(qd "quf"	?$(C:0(B)
(qd "quq"	?$(C:1(B)
(qd "qut"	?$(C:2(B)
(qd "quT"	?$(C:3(B)
(qd "qud"	?$(C:4(B)
(qd "qux"	?$(C:5(B)
(qd "qP"	?$(C:6(B)
(qd "qPs"	?$(C:7(B)
(qd "qh"	?$(C:8(B)
(qd "qhr"	?$(C:9(B)
(qd "qhR"	?$(C::(B)
(qd "qhs"	?$(C:;(B)
(qd "qhf"	?$(C:<(B)
(qd "qha"	?$(C:=(B)
(qd "qhq"	?$(C:>(B)
(qd "qht"	?$(C:?(B)
(qd "qhd"	?$(C:@(B)
(qd "qhk"	?$(C:A(B)
(qd "qhks"	?$(C:B(B)
(qd "qhkT"	?$(C:C(B)
(qd "qho"	?$(C:D(B)
(qd "qhoT"	?$(C:E(B)
(qd "qhl"	?$(C:F(B)
(qd "qhlr"	?$(C:G(B)
(qd "qhls"	?$(C:H(B)
(qd "qhlf"	?$(C:I(B)
(qd "qhla"	?$(C:J(B)
(qd "qhlq"	?$(C:K(B)
(qd "qy"	?$(C:L(B)
(qd "qys"	?$(C:M(B)
(qd "qn"	?$(C:N(B)
(qd "qnr"	?$(C:O(B)
(qd "qns"	?$(C:P(B)
(qd "qne"	?$(C:Q(B)
(qd "qnf"	?$(C:R(B)
(qd "qnfr"	?$(C:S(B)
(qd "qnfa"	?$(C:T(B)
(qd "qna"	?$(C:U(B)
(qd "qnq"	?$(C:V(B)
(qd "qnt"	?$(C:W(B)
(qd "qnd"	?$(C:X(B)
(qd "qnx"	?$(C:Y(B)
(qd "qnv"	?$(C:Z(B)
(qd "qnj"	?$(C:[(B)
(qd "qnjf"	?$(C:\(B)
(qd "qnjT"	?$(C:](B)
(qd "qnp"	?$(C:^(B)
(qd "qnl"	?$(C:_(B)
(qd "qnlr"	?$(C:`(B)
(qd "qnls"	?$(C:a(B)
(qd "qnlf"	?$(C:b(B)
(qd "qnld"	?$(C:c(B)
(qd "qb"	?$(C:d(B)
(qd "qbs"	?$(C:e(B)
(qd "qbf"	?$(C:f(B)
(qd "qba"	?$(C:g(B)
(qd "qbt"	?$(C:h(B)
(qd "qbd"	?$(C:i(B)
(qd "qm"	?$(C:j(B)
(qd "qmr"	?$(C:k(B)
(qd "qms"	?$(C:l(B)
(qd "qmf"	?$(C:m(B)
(qd "qma"	?$(C:n(B)
(qd "qmq"	?$(C:o(B)
(qd "qmt"	?$(C:p(B)
(qd "ql"	?$(C:q(B)
(qd "qlr"	?$(C:r(B)
(qd "qls"	?$(C:s(B)
(qd "qlf"	?$(C:t(B)
(qd "qlfa"	?$(C:u(B)
(qd "qla"	?$(C:v(B)
(qd "qlq"	?$(C:w(B)
(qd "qlt"	?$(C:x(B)
(qd "qld"	?$(C:y(B)
(qd "qlw"	?$(C:z(B)
(qd "qlc"	?$(C:{(B)
(qd "Qk"	?$(C:|(B)
(qd "Qkr"	?$(C:}(B)
(qd "Qks"	?$(C:~(B)
(qd "Qkf"	?$(C;!(B)
(qd "Qkfa"	?$(C;"(B)
(qd "Qka"	?$(C;#(B)
(qd "Qkq"	?$(C;$(B)
(qd "Qkt"	?$(C;%(B)
(qd "QkT"	?$(C;&(B)
(qd "Qkd"	?$(C;'(B)
(qd "Qkg"	?$(C;((B)
(qd "Qo"	?$(C;)(B)
(qd "Qor"	?$(C;*(B)
(qd "Qos"	?$(C;+(B)
(qd "Qof"	?$(C;,(B)
(qd "Qoa"	?$(C;-(B)
(qd "Qoq"	?$(C;.(B)
(qd "Qot"	?$(C;/(B)
(qd "QoT"	?$(C;0(B)
(qd "Qod"	?$(C;1(B)
(qd "Qi"	?$(C;2(B)
(qd "Qir"	?$(C;3(B)
(qd "Qia"	?$(C;4(B)
(qd "Qj"	?$(C;5(B)
(qd "Qjr"	?$(C;6(B)
(qd "Qjs"	?$(C;7(B)
(qd "Qje"	?$(C;8(B)
(qd "Qjf"	?$(C;9(B)
(qd "Qja"	?$(C;:(B)
(qd "Qjt"	?$(C;;(B)
(qd "QjT"	?$(C;<(B)
(qd "Qjd"	?$(C;=(B)
(qd "Qp"	?$(C;>(B)
(qd "Qpd"	?$(C;?(B)
(qd "Qu"	?$(C;@(B)
(qd "Qur"	?$(C;A(B)
(qd "Qua"	?$(C;B(B)
(qd "Quq"	?$(C;C(B)
(qd "Qut"	?$(C;D(B)
(qd "QuT"	?$(C;E(B)
(qd "Qud"	?$(C;F(B)
(qd "Qh"	?$(C;G(B)
(qd "Qhr"	?$(C;H(B)
(qd "Qhs"	?$(C;I(B)
(qd "Qhf"	?$(C;J(B)
(qd "Qha"	?$(C;K(B)
(qd "Qhq"	?$(C;L(B)
(qd "Qhd"	?$(C;M(B)
(qd "Qhl"	?$(C;N(B)
(qd "Qy"	?$(C;O(B)
(qd "Qyd"	?$(C;P(B)
(qd "Qn"	?$(C;Q(B)
(qd "Qnr"	?$(C;R(B)
(qd "Qns"	?$(C;S(B)
(qd "Qnf"	?$(C;T(B)
(qd "Qna"	?$(C;U(B)
(qd "Qnt"	?$(C;V(B)
(qd "Qnd"	?$(C;W(B)
(qd "Qb"	?$(C;X(B)
(qd "Qbd"	?$(C;Y(B)
(qd "Qm"	?$(C;Z(B)
(qd "Qms"	?$(C;[(B)
(qd "Qmf"	?$(C;\(B)
(qd "Qma"	?$(C;](B)
(qd "Qmq"	?$(C;^(B)
(qd "Ql"	?$(C;_(B)
(qd "Qlr"	?$(C;`(B)
(qd "Qls"	?$(C;a(B)
(qd "Qlf"	?$(C;b(B)
(qd "Qla"	?$(C;c(B)
(qd "Qlq"	?$(C;d(B)
(qd "Qlt"	?$(C;e(B)
(qd "Qld"	?$(C;f(B)
(qd "tk"	?$(C;g(B)
(qd "tkr"	?$(C;h(B)
(qd "tkrt"	?$(C;i(B)
(qd "tks"	?$(C;j(B)
(qd "tke"	?$(C;k(B)
(qd "tkf"	?$(C;l(B)
(qd "tkfr"	?$(C;m(B)
(qd "tkfa"	?$(C;n(B)
(qd "tka"	?$(C;o(B)
(qd "tkq"	?$(C;p(B)
(qd "tkt"	?$(C;q(B)
(qd "tkT"	?$(C;r(B)
(qd "tkd"	?$(C;s(B)
(qd "tkx"	?$(C;t(B)
(qd "to"	?$(C;u(B)
(qd "tor"	?$(C;v(B)
(qd "tos"	?$(C;w(B)
(qd "tof"	?$(C;x(B)
(qd "toa"	?$(C;y(B)
(qd "toq"	?$(C;z(B)
(qd "tot"	?$(C;{(B)
(qd "toT"	?$(C;|(B)
(qd "tod"	?$(C;}(B)
(qd "ti"	?$(C;~(B)
(qd "tir"	?$(C<!(B)
(qd "tis"	?$(C<"(B)
(qd "tif"	?$(C<#(B)
(qd "tia"	?$(C<$(B)
(qd "tiq"	?$(C<%(B)
(qd "tit"	?$(C<&(B)
(qd "tid"	?$(C<'(B)
(qd "tO"	?$(C<((B)
(qd "tOs"	?$(C<)(B)
(qd "tOf"	?$(C<*(B)
(qd "tOa"	?$(C<+(B)
(qd "tOd"	?$(C<,(B)
(qd "tj"	?$(C<-(B)
(qd "tjr"	?$(C<.(B)
(qd "tjR"	?$(C</(B)
(qd "tjrt"	?$(C<0(B)
(qd "tjs"	?$(C<1(B)
(qd "tje"	?$(C<2(B)
(qd "tjf"	?$(C<3(B)
(qd "tjfa"	?$(C<4(B)
(qd "tjfq"	?$(C<5(B)
(qd "tja"	?$(C<6(B)
(qd "tjq"	?$(C<7(B)
(qd "tjt"	?$(C<8(B)
(qd "tjT"	?$(C<9(B)
(qd "tjd"	?$(C<:(B)
(qd "tjv"	?$(C<;(B)
(qd "tp"	?$(C<<(B)
(qd "tpr"	?$(C<=(B)
(qd "tps"	?$(C<>(B)
(qd "tpf"	?$(C<?(B)
(qd "tpa"	?$(C<@(B)
(qd "tpq"	?$(C<A(B)
(qd "tpt"	?$(C<B(B)
(qd "tpT"	?$(C<C(B)
(qd "tpd"	?$(C<D(B)
(qd "tu"	?$(C<E(B)
(qd "tur"	?$(C<F(B)
(qd "tus"	?$(C<G(B)
(qd "tuf"	?$(C<H(B)
(qd "tua"	?$(C<I(B)
(qd "tuq"	?$(C<J(B)
(qd "tut"	?$(C<K(B)
(qd "tuT"	?$(C<L(B)
(qd "tud"	?$(C<M(B)
(qd "tP"	?$(C<N(B)
(qd "tPs"	?$(C<O(B)
(qd "tPf"	?$(C<P(B)
(qd "tPd"	?$(C<Q(B)
(qd "th"	?$(C<R(B)
(qd "thr"	?$(C<S(B)
(qd "thR"	?$(C<T(B)
(qd "ths"	?$(C<U(B)
(qd "thf"	?$(C<V(B)
(qd "thfa"	?$(C<W(B)
(qd "tha"	?$(C<X(B)
(qd "thq"	?$(C<Y(B)
(qd "tht"	?$(C<Z(B)
(qd "thd"	?$(C<[(B)
(qd "thx"	?$(C<\(B)
(qd "thk"	?$(C<](B)
(qd "thkr"	?$(C<^(B)
(qd "thks"	?$(C<_(B)
(qd "thkf"	?$(C<`(B)
(qd "thkd"	?$(C<a(B)
(qd "tho"	?$(C<b(B)
(qd "thos"	?$(C<c(B)
(qd "thof"	?$(C<d(B)
(qd "thoa"	?$(C<e(B)
(qd "thot"	?$(C<f(B)
(qd "thoT"	?$(C<g(B)
(qd "thl"	?$(C<h(B)
(qd "thls"	?$(C<i(B)
(qd "thlf"	?$(C<j(B)
(qd "thla"	?$(C<k(B)
(qd "thlq"	?$(C<l(B)
(qd "thlt"	?$(C<m(B)
(qd "ty"	?$(C<n(B)
(qd "tyr"	?$(C<o(B)
(qd "tys"	?$(C<p(B)
(qd "tyf"	?$(C<q(B)
(qd "tya"	?$(C<r(B)
(qd "tyq"	?$(C<s(B)
(qd "tyt"	?$(C<t(B)
(qd "tyd"	?$(C<u(B)
(qd "tn"	?$(C<v(B)
(qd "tnr"	?$(C<w(B)
(qd "tns"	?$(C<x(B)
(qd "tne"	?$(C<y(B)
(qd "tnf"	?$(C<z(B)
(qd "tna"	?$(C<{(B)
(qd "tnq"	?$(C<|(B)
(qd "tnt"	?$(C<}(B)
(qd "tnd"	?$(C<~(B)
(qd "tnc"	?$(C=!(B)
(qd "tnx"	?$(C="(B)
(qd "tnv"	?$(C=#(B)
(qd "tnj"	?$(C=$(B)
(qd "tnjT"	?$(C=%(B)
(qd "tnp"	?$(C=&(B)
(qd "tnpr"	?$(C='(B)
(qd "tnps"	?$(C=((B)
(qd "tnpf"	?$(C=)(B)
(qd "tnpa"	?$(C=*(B)
(qd "tnpd"	?$(C=+(B)
(qd "tnl"	?$(C=,(B)
(qd "tnlr"	?$(C=-(B)
(qd "tnls"	?$(C=.(B)
(qd "tnlf"	?$(C=/(B)
(qd "tnla"	?$(C=0(B)
(qd "tnlq"	?$(C=1(B)
(qd "tnlt"	?$(C=2(B)
(qd "tnld"	?$(C=3(B)
(qd "tb"	?$(C=4(B)
(qd "tbr"	?$(C=5(B)
(qd "tbf"	?$(C=6(B)
(qd "tba"	?$(C=7(B)
(qd "tbt"	?$(C=8(B)
(qd "tbd"	?$(C=9(B)
(qd "tm"	?$(C=:(B)
(qd "tmr"	?$(C=;(B)
(qd "tms"	?$(C=<(B)
(qd "tmf"	?$(C==(B)
(qd "tmfr"	?$(C=>(B)
(qd "tma"	?$(C=?(B)
(qd "tmq"	?$(C=@(B)
(qd "tmt"	?$(C=A(B)
(qd "tmd"	?$(C=B(B)
(qd "tl"	?$(C=C(B)
(qd "tlr"	?$(C=D(B)
(qd "tls"	?$(C=E(B)
(qd "tle"	?$(C=F(B)
(qd "tlf"	?$(C=G(B)
(qd "tlfg"	?$(C=H(B)
(qd "tla"	?$(C=I(B)
(qd "tlq"	?$(C=J(B)
(qd "tlt"	?$(C=K(B)
(qd "tld"	?$(C=L(B)
(qd "tlv"	?$(C=M(B)
(qd "Tk"	?$(C=N(B)
(qd "Tkr"	?$(C=O(B)
(qd "Tkrt"	?$(C=P(B)
(qd "Tks"	?$(C=Q(B)
(qd "Tkf"	?$(C=R(B)
(qd "Tka"	?$(C=S(B)
(qd "Tkq"	?$(C=T(B)
(qd "TkT"	?$(C=U(B)
(qd "Tkd"	?$(C=V(B)
(qd "Tkg"	?$(C=W(B)
(qd "To"	?$(C=X(B)
(qd "Tor"	?$(C=Y(B)
(qd "Tos"	?$(C=Z(B)
(qd "Tof"	?$(C=[(B)
(qd "Toa"	?$(C=\(B)
(qd "Toq"	?$(C=](B)
(qd "ToT"	?$(C=^(B)
(qd "Tod"	?$(C=_(B)
(qd "Tid"	?$(C=`(B)
(qd "Tj"	?$(C=a(B)
(qd "Tjr"	?$(C=b(B)
(qd "Tjs"	?$(C=c(B)
(qd "Tjf"	?$(C=d(B)
(qd "Tjfa"	?$(C=e(B)
(qd "Tja"	?$(C=f(B)
(qd "Tjq"	?$(C=g(B)
(qd "TjT"	?$(C=h(B)
(qd "Tjd"	?$(C=i(B)
(qd "Tp"	?$(C=j(B)
(qd "Tps"	?$(C=k(B)
(qd "Tpf"	?$(C=l(B)
(qd "TPs"	?$(C=m(B)
(qd "Th"	?$(C=n(B)
(qd "Thr"	?$(C=o(B)
(qd "Ths"	?$(C=p(B)
(qd "The"	?$(C=q(B)
(qd "Thf"	?$(C=r(B)
(qd "Thfa"	?$(C=s(B)
(qd "Tha"	?$(C=t(B)
(qd "Thq"	?$(C=u(B)
(qd "Thd"	?$(C=v(B)
(qd "Thk"	?$(C=w(B)
(qd "Thkr"	?$(C=x(B)
(qd "Thks"	?$(C=y(B)
(qd "ThkT"	?$(C=z(B)
(qd "Tho"	?$(C={(B)
(qd "ThoT"	?$(C=|(B)
(qd "Thl"	?$(C=}(B)
(qd "Thls"	?$(C=~(B)
(qd "Thlf"	?$(C>!(B)
(qd "Thla"	?$(C>"(B)
(qd "Thlq"	?$(C>#(B)
(qd "Ty"	?$(C>$(B)
(qd "Tn"	?$(C>%(B)
(qd "Tnr"	?$(C>&(B)
(qd "Tns"	?$(C>'(B)
(qd "Tnf"	?$(C>((B)
(qd "Tna"	?$(C>)(B)
(qd "Tnq"	?$(C>*(B)
(qd "Tnd"	?$(C>+(B)
(qd "Tnj"	?$(C>,(B)
(qd "TnjT"	?$(C>-(B)
(qd "Tnp"	?$(C>.(B)
(qd "Tnl"	?$(C>/(B)
(qd "Tnls"	?$(C>0(B)
(qd "Tbd"	?$(C>1(B)
(qd "Tm"	?$(C>2(B)
(qd "Tmr"	?$(C>3(B)
(qd "Tms"	?$(C>4(B)
(qd "Tmf"	?$(C>5(B)
(qd "Tmfa"	?$(C>6(B)
(qd "Tmfg"	?$(C>7(B)
(qd "Tma"	?$(C>8(B)
(qd "Tmq"	?$(C>9(B)
(qd "Tml"	?$(C>:(B)
(qd "Tmls"	?$(C>;(B)
(qd "Tmlf"	?$(C><(B)
(qd "Tmla"	?$(C>=(B)
(qd "Tl"	?$(C>>(B)
(qd "Tlr"	?$(C>?(B)
(qd "Tls"	?$(C>@(B)
(qd "Tlf"	?$(C>A(B)
(qd "Tla"	?$(C>B(B)
(qd "Tlq"	?$(C>C(B)
(qd "Tlt"	?$(C>D(B)
(qd "Tld"	?$(C>E(B)
(qd "dk"	?$(C>F(B)
(qd "dkr"	?$(C>G(B)
(qd "dks"	?$(C>H(B)
(qd "dksw"	?$(C>I(B)
(qd "dksg"	?$(C>J(B)
(qd "dkf"	?$(C>K(B)
(qd "dkfr"	?$(C>L(B)
(qd "dkfa"	?$(C>M(B)
(qd "dkfg"	?$(C>N(B)
(qd "dka"	?$(C>O(B)
(qd "dkq"	?$(C>P(B)
(qd "dkt"	?$(C>Q(B)
(qd "dkT"	?$(C>R(B)
(qd "dkd"	?$(C>S(B)
(qd "dkx"	?$(C>T(B)
(qd "dkv"	?$(C>U(B)
(qd "do"	?$(C>V(B)
(qd "dor"	?$(C>W(B)
(qd "dos"	?$(C>X(B)
(qd "dof"	?$(C>Y(B)
(qd "doa"	?$(C>Z(B)
(qd "doq"	?$(C>[(B)
(qd "dot"	?$(C>\(B)
(qd "doT"	?$(C>](B)
(qd "dod"	?$(C>^(B)
(qd "di"	?$(C>_(B)
(qd "dir"	?$(C>`(B)
(qd "dis"	?$(C>a(B)
(qd "dif"	?$(C>b(B)
(qd "difq"	?$(C>c(B)
(qd "dia"	?$(C>d(B)
(qd "diq"	?$(C>e(B)
(qd "dit"	?$(C>f(B)
(qd "did"	?$(C>g(B)
(qd "dix"	?$(C>h(B)
(qd "dig"	?$(C>i(B)
(qd "dO"	?$(C>j(B)
(qd "dOs"	?$(C>k(B)
(qd "dOf"	?$(C>l(B)
(qd "dOq"	?$(C>m(B)
(qd "dj"	?$(C>n(B)
(qd "djr"	?$(C>o(B)
(qd "djs"	?$(C>p(B)
(qd "djsw"	?$(C>q(B)
(qd "dje"	?$(C>r(B)
(qd "djf"	?$(C>s(B)
(qd "djfr"	?$(C>t(B)
(qd "djfa"	?$(C>u(B)
(qd "dja"	?$(C>v(B)
(qd "djq"	?$(C>w(B)
(qd "djqt"	?$(C>x(B)
(qd "djt"	?$(C>y(B)
(qd "djT"	?$(C>z(B)
(qd "djd"	?$(C>{(B)
(qd "djw"	?$(C>|(B)
(qd "djz"	?$(C>}(B)
(qd "djv"	?$(C>~(B)
(qd "dp"	?$(C?!(B)
(qd "dpr"	?$(C?"(B)
(qd "dps"	?$(C?#(B)
(qd "dpf"	?$(C?$(B)
(qd "dpa"	?$(C?%(B)
(qd "dpq"	?$(C?&(B)
(qd "dpt"	?$(C?'(B)
(qd "dpd"	?$(C?((B)
(qd "du"	?$(C?)(B)
(qd "dur"	?$(C?*(B)
(qd "duR"	?$(C?+(B)
(qd "dus"	?$(C?,(B)
(qd "duf"	?$(C?-(B)
(qd "dufa"	?$(C?.(B)
(qd "dufq"	?$(C?/(B)
(qd "dua"	?$(C?0(B)
(qd "duq"	?$(C?1(B)
(qd "duqt"	?$(C?2(B)
(qd "dut"	?$(C?3(B)
(qd "duT"	?$(C?4(B)
(qd "dud"	?$(C?5(B)
(qd "dux"	?$(C?6(B)
(qd "duv"	?$(C?7(B)
(qd "dug"	?$(C?8(B)
(qd "dP"	?$(C?9(B)
(qd "dPs"	?$(C?:(B)
(qd "dPf"	?$(C?;(B)
(qd "dPa"	?$(C?<(B)
(qd "dPq"	?$(C?=(B)
(qd "dPt"	?$(C?>(B)
(qd "dPT"	?$(C??(B)
(qd "dh"	?$(C?@(B)
(qd "dhr"	?$(C?A(B)
(qd "dhs"	?$(C?B(B)
(qd "dhf"	?$(C?C(B)
(qd "dhfr"	?$(C?D(B)
(qd "dhfa"	?$(C?E(B)
(qd "dhft"	?$(C?F(B)
(qd "dhfg"	?$(C?G(B)
(qd "dha"	?$(C?H(B)
(qd "dhq"	?$(C?I(B)
(qd "dht"	?$(C?J(B)
(qd "dhd"	?$(C?K(B)
(qd "dhc"	?$(C?L(B)
(qd "dhk"	?$(C?M(B)
(qd "dhkr"	?$(C?N(B)
(qd "dhks"	?$(C?O(B)
(qd "dhkf"	?$(C?P(B)
(qd "dhka"	?$(C?Q(B)
(qd "dhkq"	?$(C?R(B)
(qd "dhkt"	?$(C?S(B)
(qd "dhkT"	?$(C?T(B)
(qd "dhkd"	?$(C?U(B)
(qd "dho"	?$(C?V(B)
(qd "dhor"	?$(C?W(B)
(qd "dhos"	?$(C?X(B)
(qd "dhoa"	?$(C?Y(B)
(qd "dhot"	?$(C?Z(B)
(qd "dhod"	?$(C?[(B)
(qd "dhl"	?$(C?\(B)
(qd "dhlr"	?$(C?](B)
(qd "dhls"	?$(C?^(B)
(qd "dhlf"	?$(C?_(B)
(qd "dhla"	?$(C?`(B)
(qd "dhlq"	?$(C?a(B)
(qd "dhlt"	?$(C?b(B)
(qd "dhld"	?$(C?c(B)
(qd "dy"	?$(C?d(B)
(qd "dyr"	?$(C?e(B)
(qd "dys"	?$(C?f(B)
(qd "dyf"	?$(C?g(B)
(qd "dya"	?$(C?h(B)
(qd "dyq"	?$(C?i(B)
(qd "dyt"	?$(C?j(B)
(qd "dyd"	?$(C?k(B)
(qd "dn"	?$(C?l(B)
(qd "dnr"	?$(C?m(B)
(qd "dns"	?$(C?n(B)
(qd "dnf"	?$(C?o(B)
(qd "dnfr"	?$(C?p(B)
(qd "dnfa"	?$(C?q(B)
(qd "dna"	?$(C?r(B)
(qd "dnq"	?$(C?s(B)
(qd "dnt"	?$(C?t(B)
(qd "dnd"	?$(C?u(B)
(qd "dnj"	?$(C?v(B)
(qd "dnjr"	?$(C?w(B)
(qd "dnjs"	?$(C?x(B)
(qd "dnjf"	?$(C?y(B)
(qd "dnja"	?$(C?z(B)
(qd "dnjq"	?$(C?{(B)
(qd "dnjT"	?$(C?|(B)
(qd "dnjd"	?$(C?}(B)
(qd "dnp"	?$(C?~(B)
(qd "dnpr"	?$(C@!(B)
(qd "dnps"	?$(C@"(B)
(qd "dnpf"	?$(C@#(B)
(qd "dnpa"	?$(C@$(B)
(qd "dnpq"	?$(C@%(B)
(qd "dnpd"	?$(C@&(B)
(qd "dnl"	?$(C@'(B)
(qd "dnlr"	?$(C@((B)
(qd "dnls"	?$(C@)(B)
(qd "dnlf"	?$(C@*(B)
(qd "dnla"	?$(C@+(B)
(qd "dnlq"	?$(C@,(B)
(qd "dnlt"	?$(C@-(B)
(qd "dnld"	?$(C@.(B)
(qd "db"	?$(C@/(B)
(qd "dbr"	?$(C@0(B)
(qd "dbs"	?$(C@1(B)
(qd "dbf"	?$(C@2(B)
(qd "dba"	?$(C@3(B)
(qd "dbq"	?$(C@4(B)
(qd "dbt"	?$(C@5(B)
(qd "dbd"	?$(C@6(B)
(qd "dbc"	?$(C@7(B)
(qd "dm"	?$(C@8(B)
(qd "dmr"	?$(C@9(B)
(qd "dms"	?$(C@:(B)
(qd "dmf"	?$(C@;(B)
(qd "dmfv"	?$(C@<(B)
(qd "dma"	?$(C@=(B)
(qd "dmq"	?$(C@>(B)
(qd "dmt"	?$(C@?(B)
(qd "dmd"	?$(C@@(B)
(qd "dmw"	?$(C@A(B)
(qd "dmc"	?$(C@B(B)
(qd "dmz"	?$(C@C(B)
(qd "dmx"	?$(C@D(B)
(qd "dmv"	?$(C@E(B)
(qd "dmg"	?$(C@F(B)
(qd "dml"	?$(C@G(B)
(qd "dmls"	?$(C@H(B)
(qd "dmlf"	?$(C@I(B)
(qd "dmla"	?$(C@J(B)
(qd "dmlt"	?$(C@K(B)
(qd "dl"	?$(C@L(B)
(qd "dlr"	?$(C@M(B)
(qd "dls"	?$(C@N(B)
(qd "dlf"	?$(C@O(B)
(qd "dlfr"	?$(C@P(B)
(qd "dlfa"	?$(C@Q(B)
(qd "dlfg"	?$(C@R(B)
(qd "dla"	?$(C@S(B)
(qd "dlq"	?$(C@T(B)
(qd "dlt"	?$(C@U(B)
(qd "dlT"	?$(C@V(B)
(qd "dld"	?$(C@W(B)
(qd "dlw"	?$(C@X(B)
(qd "dlv"	?$(C@Y(B)
(qd "wk"	?$(C@Z(B)
(qd "wkr"	?$(C@[(B)
(qd "wks"	?$(C@\(B)
(qd "wksg"	?$(C@](B)
(qd "wke"	?$(C@^(B)
(qd "wkf"	?$(C@_(B)
(qd "wkfa"	?$(C@`(B)
(qd "wka"	?$(C@a(B)
(qd "wkq"	?$(C@b(B)
(qd "wkt"	?$(C@c(B)
(qd "wkT"	?$(C@d(B)
(qd "wkd"	?$(C@e(B)
(qd "wkw"	?$(C@f(B)
(qd "Or"	?$(C@h(B)
(qd "Os"	?$(C@i(B)
(qd "Of"	?$(C@j(B)
(qd "Oa"	?$(C@k(B)
(qd "Oq"	?$(C@l(B)
(qd "Ot"	?$(C@m(B)
(qd "OT"	?$(C@n(B)
(qd "Od"	?$(C@o(B)
(qd "wo"	?$(C@g(B)
(qd "wor"	?$(C@h(B)
(qd "wos"	?$(C@i(B)
(qd "wof"	?$(C@j(B)
(qd "woa"	?$(C@k(B)
(qd "woq"	?$(C@l(B)
(qd "wot"	?$(C@m(B)
(qd "woT"	?$(C@n(B)
(qd "wod"	?$(C@o(B)
(qd "wi"	?$(C@p(B)
(qd "wir"	?$(C@q(B)
(qd "wis"	?$(C@r(B)
(qd "wisg"	?$(C@s(B)
(qd "wif"	?$(C@t(B)
(qd "wia"	?$(C@u(B)
(qd "wid"	?$(C@v(B)
(qd "wO"	?$(C@w(B)
(qd "wOs"	?$(C@x(B)
(qd "wOf"	?$(C@y(B)
(qd "wj"	?$(C@z(B)
(qd "wjr"	?$(C@{(B)
(qd "wjs"	?$(C@|(B)
(qd "wjf"	?$(C@}(B)
(qd "wjfa"	?$(C@~(B)
(qd "wja"	?$(CA!(B)
(qd "wjq"	?$(CA"(B)
(qd "wjt"	?$(CA#(B)
(qd "wjd"	?$(CA$(B)
(qd "wjw"	?$(CA%(B)
(qd "wp"	?$(CA&(B)
(qd "wpr"	?$(CA'(B)
(qd "wps"	?$(CA((B)
(qd "wpf"	?$(CA)(B)
(qd "wpa"	?$(CA*(B)
(qd "wpq"	?$(CA+(B)
(qd "wpt"	?$(CA,(B)
(qd "wpd"	?$(CA-(B)
(qd "wu"	?$(CA.(B)
(qd "wus"	?$(CA/(B)
(qd "wuf"	?$(CA0(B)
(qd "wua"	?$(CA1(B)
(qd "wuq"	?$(CA2(B)
(qd "wuT"	?$(CA3(B)
(qd "wud"	?$(CA4(B)
(qd "wP"	?$(CA5(B)
(qd "wh"	?$(CA6(B)
(qd "whr"	?$(CA7(B)
(qd "whs"	?$(CA8(B)
(qd "whf"	?$(CA9(B)
(qd "whfa"	?$(CA:(B)
(qd "wha"	?$(CA;(B)
(qd "whq"	?$(CA<(B)
(qd "wht"	?$(CA=(B)
(qd "whd"	?$(CA>(B)
(qd "whw"	?$(CA?(B)
(qd "whc"	?$(CA@(B)
(qd "whg"	?$(CAA(B)
(qd "whk"	?$(CAB(B)
(qd "whkr"	?$(CAC(B)
(qd "whkf"	?$(CAD(B)
(qd "whkq"	?$(CAE(B)
(qd "whkt"	?$(CAF(B)
(qd "whkd"	?$(CAG(B)
(qd "who"	?$(CAH(B)
(qd "whoT"	?$(CAI(B)
(qd "whod"	?$(CAJ(B)
(qd "whl"	?$(CAK(B)
(qd "whls"	?$(CAL(B)
(qd "whlf"	?$(CAM(B)
(qd "whla"	?$(CAN(B)
(qd "whlq"	?$(CAO(B)
(qd "whlt"	?$(CAP(B)
(qd "whld"	?$(CAQ(B)
(qd "wy"	?$(CAR(B)
(qd "wyr"	?$(CAS(B)
(qd "wys"	?$(CAT(B)
(qd "wyd"	?$(CAU(B)
(qd "wn"	?$(CAV(B)
(qd "wnr"	?$(CAW(B)
(qd "wns"	?$(CAX(B)
(qd "wnf"	?$(CAY(B)
(qd "wnfr"	?$(CAZ(B)
(qd "wnfa"	?$(CA[(B)
(qd "wna"	?$(CA\(B)
(qd "wnq"	?$(CA](B)
(qd "wnt"	?$(CA^(B)
(qd "wnd"	?$(CA_(B)
(qd "wnj"	?$(CA`(B)
(qd "wnjT"	?$(CAa(B)
(qd "wnp"	?$(CAb(B)
(qd "wnl"	?$(CAc(B)
(qd "wnlr"	?$(CAd(B)
(qd "wnls"	?$(CAe(B)
(qd "wnlf"	?$(CAf(B)
(qd "wnla"	?$(CAg(B)
(qd "wnlq"	?$(CAh(B)
(qd "wnlt"	?$(CAi(B)
(qd "wb"	?$(CAj(B)
(qd "wbs"	?$(CAk(B)
(qd "wbf"	?$(CAl(B)
(qd "wba"	?$(CAm(B)
(qd "wm"	?$(CAn(B)
(qd "wmr"	?$(CAo(B)
(qd "wms"	?$(CAp(B)
(qd "wmf"	?$(CAq(B)
(qd "wma"	?$(CAr(B)
(qd "wmq"	?$(CAs(B)
(qd "wmt"	?$(CAt(B)
(qd "wmd"	?$(CAu(B)
(qd "wl"	?$(CAv(B)
(qd "wlr"	?$(CAw(B)
(qd "wls"	?$(CAx(B)
(qd "wle"	?$(CAy(B)
(qd "wlf"	?$(CAz(B)
(qd "wlfa"	?$(CA{(B)
(qd "wla"	?$(CA|(B)
(qd "wlq"	?$(CA}(B)
(qd "wlt"	?$(CA~(B)
(qd "wld"	?$(CB!(B)
(qd "wlw"	?$(CB"(B)
(qd "wlx"	?$(CB#(B)
(qd "wlv"	?$(CB$(B)
(qd "Wk"	?$(CB%(B)
(qd "Wkr"	?$(CB&(B)
(qd "Wks"	?$(CB'(B)
(qd "Wksg"	?$(CB((B)
(qd "Wkf"	?$(CB)(B)
(qd "Wkfq"	?$(CB*(B)
(qd "Wka"	?$(CB+(B)
(qd "Wkq"	?$(CB,(B)
(qd "Wkt"	?$(CB-(B)
(qd "WkT"	?$(CB.(B)
(qd "Wkd"	?$(CB/(B)
(qd "Wo"	?$(CB0(B)
(qd "Wor"	?$(CB1(B)
(qd "Wos"	?$(CB2(B)
(qd "Wof"	?$(CB3(B)
(qd "Woa"	?$(CB4(B)
(qd "Woq"	?$(CB5(B)
(qd "Wot"	?$(CB6(B)
(qd "WoT"	?$(CB7(B)
(qd "Wod"	?$(CB8(B)
(qd "Wi"	?$(CB9(B)
(qd "Wis"	?$(CB:(B)
(qd "Wid"	?$(CB;(B)
(qd "Wj"	?$(CB<(B)
(qd "Wjr"	?$(CB=(B)
(qd "Wjs"	?$(CB>(B)
(qd "Wjf"	?$(CB?(B)
(qd "Wja"	?$(CB@(B)
(qd "Wjq"	?$(CBA(B)
(qd "Wjt"	?$(CBB(B)
(qd "WjT"	?$(CBC(B)
(qd "Wjd"	?$(CBD(B)
(qd "Wp"	?$(CBE(B)
(qd "Wpd"	?$(CBF(B)
(qd "Wu"	?$(CBG(B)
(qd "WuT"	?$(CBH(B)
(qd "Wh"	?$(CBI(B)
(qd "Whr"	?$(CBJ(B)
(qd "Whs"	?$(CBK(B)
(qd "Whf"	?$(CBL(B)
(qd "Wha"	?$(CBM(B)
(qd "Whq"	?$(CBN(B)
(qd "Wht"	?$(CBO(B)
(qd "Whd"	?$(CBP(B)
(qd "Whc"	?$(CBQ(B)
(qd "Whk"	?$(CBR(B)
(qd "Whkr"	?$(CBS(B)
(qd "Whkf"	?$(CBT(B)
(qd "WhkT"	?$(CBU(B)
(qd "Who"	?$(CBV(B)
(qd "WhoT"	?$(CBW(B)
(qd "Whl"	?$(CBX(B)
(qd "Whls"	?$(CBY(B)
(qd "Whlf"	?$(CBZ(B)
(qd "Whla"	?$(CB[(B)
(qd "Whlq"	?$(CB\(B)
(qd "Wyd"	?$(CB](B)
(qd "Wn"	?$(CB^(B)
(qd "Wnr"	?$(CB_(B)
(qd "Wns"	?$(CB`(B)
(qd "Wnf"	?$(CBa(B)
(qd "Wna"	?$(CBb(B)
(qd "Wnq"	?$(CBc(B)
(qd "Wnd"	?$(CBd(B)
(qd "Wnj"	?$(CBe(B)
(qd "WnjT"	?$(CBf(B)
(qd "Wnjd"	?$(CBg(B)
(qd "Wnl"	?$(CBh(B)
(qd "Wb"	?$(CBi(B)
(qd "Wm"	?$(CBj(B)
(qd "Wma"	?$(CBk(B)
(qd "Wmt"	?$(CBl(B)
(qd "Wmd"	?$(CBm(B)
(qd "Wl"	?$(CBn(B)
(qd "Wlr"	?$(CBo(B)
(qd "Wls"	?$(CBp(B)
(qd "Wlf"	?$(CBq(B)
(qd "Wla"	?$(CBr(B)
(qd "Wlq"	?$(CBs(B)
(qd "Wld"	?$(CBt(B)
(qd "Wlw"	?$(CBu(B)
(qd "Wlg"	?$(CBv(B)
(qd "ck"	?$(CBw(B)
(qd "ckr"	?$(CBx(B)
(qd "cks"	?$(CBy(B)
(qd "cksg"	?$(CBz(B)
(qd "ckf"	?$(CB{(B)
(qd "cka"	?$(CB|(B)
(qd "ckq"	?$(CB}(B)
(qd "ckt"	?$(CB~(B)
(qd "ckT"	?$(CC!(B)
(qd "ckd"	?$(CC"(B)
(qd "ckw"	?$(CC#(B)
(qd "co"	?$(CC$(B)
(qd "cor"	?$(CC%(B)
(qd "cos"	?$(CC&(B)
(qd "cof"	?$(CC'(B)
(qd "coa"	?$(CC((B)
(qd "coq"	?$(CC)(B)
(qd "cot"	?$(CC*(B)
(qd "coT"	?$(CC+(B)
(qd "cod"	?$(CC,(B)
(qd "ci"	?$(CC-(B)
(qd "cis"	?$(CC.(B)
(qd "cisg"	?$(CC/(B)
(qd "cif"	?$(CC0(B)
(qd "cia"	?$(CC1(B)
(qd "cid"	?$(CC2(B)
(qd "cj"	?$(CC3(B)
(qd "cjr"	?$(CC4(B)
(qd "cjs"	?$(CC5(B)
(qd "cjf"	?$(CC6(B)
(qd "cja"	?$(CC7(B)
(qd "cjq"	?$(CC8(B)
(qd "cjt"	?$(CC9(B)
(qd "cjT"	?$(CC:(B)
(qd "cjd"	?$(CC;(B)
(qd "cp"	?$(CC<(B)
(qd "cpr"	?$(CC=(B)
(qd "cps"	?$(CC>(B)
(qd "cpf"	?$(CC?(B)
(qd "cpa"	?$(CC@(B)
(qd "cpq"	?$(CCA(B)
(qd "cpt"	?$(CCB(B)
(qd "cpd"	?$(CCC(B)
(qd "cu"	?$(CCD(B)
(qd "cus"	?$(CCE(B)
(qd "cuT"	?$(CCF(B)
(qd "cP"	?$(CCG(B)
(qd "cPs"	?$(CCH(B)
(qd "cPd"	?$(CCI(B)
(qd "ch"	?$(CCJ(B)
(qd "chr"	?$(CCK(B)
(qd "chs"	?$(CCL(B)
(qd "chf"	?$(CCM(B)
(qd "cha"	?$(CCN(B)
(qd "chq"	?$(CCO(B)
(qd "cht"	?$(CCP(B)
(qd "chd"	?$(CCQ(B)
(qd "chk"	?$(CCR(B)
(qd "chks"	?$(CCS(B)
(qd "chkf"	?$(CCT(B)
(qd "chkd"	?$(CCU(B)
(qd "chl"	?$(CCV(B)
(qd "chls"	?$(CCW(B)
(qd "chlf"	?$(CCX(B)
(qd "chla"	?$(CCY(B)
(qd "chlq"	?$(CCZ(B)
(qd "chlt"	?$(CC[(B)
(qd "chld"	?$(CC\(B)
(qd "cy"	?$(CC](B)
(qd "cya"	?$(CC^(B)
(qd "cn"	?$(CC_(B)
(qd "cnr"	?$(CC`(B)
(qd "cns"	?$(CCa(B)
(qd "cnf"	?$(CCb(B)
(qd "cna"	?$(CCc(B)
(qd "cnq"	?$(CCd(B)
(qd "cnt"	?$(CCe(B)
(qd "cnd"	?$(CCf(B)
(qd "cnj"	?$(CCg(B)
(qd "cnjT"	?$(CCh(B)
(qd "cnp"	?$(CCi(B)
(qd "cnps"	?$(CCj(B)
(qd "cnl"	?$(CCk(B)
(qd "cnls"	?$(CCl(B)
(qd "cnlf"	?$(CCm(B)
(qd "cnla"	?$(CCn(B)
(qd "cnlq"	?$(CCo(B)
(qd "cnlt"	?$(CCp(B)
(qd "cnld"	?$(CCq(B)
(qd "cb"	?$(CCr(B)
(qd "cbs"	?$(CCs(B)
(qd "cbf"	?$(CCt(B)
(qd "cba"	?$(CCu(B)
(qd "cbd"	?$(CCv(B)
(qd "cm"	?$(CCw(B)
(qd "cmr"	?$(CCx(B)
(qd "cms"	?$(CCy(B)
(qd "cmf"	?$(CCz(B)
(qd "cma"	?$(CC{(B)
(qd "cmq"	?$(CC|(B)
(qd "cmt"	?$(CC}(B)
(qd "cmd"	?$(CC~(B)
(qd "cl"	?$(CD!(B)
(qd "clr"	?$(CD"(B)
(qd "cls"	?$(CD#(B)
(qd "cle"	?$(CD$(B)
(qd "clf"	?$(CD%(B)
(qd "clfr"	?$(CD&(B)
(qd "cla"	?$(CD'(B)
(qd "clq"	?$(CD((B)
(qd "clt"	?$(CD)(B)
(qd "cld"	?$(CD*(B)
(qd "zk"	?$(CD+(B)
(qd "zkr"	?$(CD,(B)
(qd "zks"	?$(CD-(B)
(qd "zkf"	?$(CD.(B)
(qd "zka"	?$(CD/(B)
(qd "zkq"	?$(CD0(B)
(qd "zkt"	?$(CD1(B)
(qd "zkd"	?$(CD2(B)
(qd "zo"	?$(CD3(B)
(qd "zor"	?$(CD4(B)
(qd "zos"	?$(CD5(B)
(qd "zof"	?$(CD6(B)
(qd "zoa"	?$(CD7(B)
(qd "zoq"	?$(CD8(B)
(qd "zot"	?$(CD9(B)
(qd "zoT"	?$(CD:(B)
(qd "zod"	?$(CD;(B)
(qd "zi"	?$(CD<(B)
(qd "zir"	?$(CD=(B)
(qd "zid"	?$(CD>(B)
(qd "zj"	?$(CD?(B)
(qd "zjr"	?$(CD@(B)
(qd "zjs"	?$(CDA(B)
(qd "zje"	?$(CDB(B)
(qd "zjf"	?$(CDC(B)
(qd "zja"	?$(CDD(B)
(qd "zjq"	?$(CDE(B)
(qd "zjt"	?$(CDF(B)
(qd "zjT"	?$(CDG(B)
(qd "zjd"	?$(CDH(B)
(qd "zp"	?$(CDI(B)
(qd "zpr"	?$(CDJ(B)
(qd "zps"	?$(CDK(B)
(qd "zpf"	?$(CDL(B)
(qd "zpa"	?$(CDM(B)
(qd "zpq"	?$(CDN(B)
(qd "zpt"	?$(CDO(B)
(qd "zpd"	?$(CDP(B)
(qd "zu"	?$(CDQ(B)
(qd "zus"	?$(CDR(B)
(qd "zuf"	?$(CDS(B)
(qd "zua"	?$(CDT(B)
(qd "zuq"	?$(CDU(B)
(qd "zut"	?$(CDV(B)
(qd "zuT"	?$(CDW(B)
(qd "zud"	?$(CDX(B)
(qd "zP"	?$(CDY(B)
(qd "zh"	?$(CDZ(B)
(qd "zhr"	?$(CD[(B)
(qd "zhs"	?$(CD\(B)
(qd "zhf"	?$(CD](B)
(qd "zha"	?$(CD^(B)
(qd "zhq"	?$(CD_(B)
(qd "zht"	?$(CD`(B)
(qd "zhd"	?$(CDa(B)
(qd "zhk"	?$(CDb(B)
(qd "zhkr"	?$(CDc(B)
(qd "zhks"	?$(CDd(B)
(qd "zhkf"	?$(CDe(B)
(qd "zhka"	?$(CDf(B)
(qd "zhkd"	?$(CDg(B)
(qd "zho"	?$(CDh(B)
(qd "zhod"	?$(CDi(B)
(qd "zhl"	?$(CDj(B)
(qd "zhlf"	?$(CDk(B)
(qd "zy"	?$(CDl(B)
(qd "zn"	?$(CDm(B)
(qd "znr"	?$(CDn(B)
(qd "zns"	?$(CDo(B)
(qd "znf"	?$(CDp(B)
(qd "zna"	?$(CDq(B)
(qd "znq"	?$(CDr(B)
(qd "znt"	?$(CDs(B)
(qd "znd"	?$(CDt(B)
(qd "znj"	?$(CDu(B)
(qd "znjs"	?$(CDv(B)
(qd "znjf"	?$(CDw(B)
(qd "znjd"	?$(CDx(B)
(qd "znp"	?$(CDy(B)
(qd "znpd"	?$(CDz(B)
(qd "znl"	?$(CD{(B)
(qd "znlr"	?$(CD|(B)
(qd "znls"	?$(CD}(B)
(qd "znlf"	?$(CD~(B)
(qd "znla"	?$(CE!(B)
(qd "znlq"	?$(CE"(B)
(qd "znlt"	?$(CE#(B)
(qd "znld"	?$(CE$(B)
(qd "zb"	?$(CE%(B)
(qd "zbs"	?$(CE&(B)
(qd "zbf"	?$(CE'(B)
(qd "zba"	?$(CE((B)
(qd "zm"	?$(CE)(B)
(qd "zmr"	?$(CE*(B)
(qd "zms"	?$(CE+(B)
(qd "zmf"	?$(CE,(B)
(qd "zma"	?$(CE-(B)
(qd "zmq"	?$(CE.(B)
(qd "zmd"	?$(CE/(B)
(qd "zl"	?$(CE0(B)
(qd "zlr"	?$(CE1(B)
(qd "zls"	?$(CE2(B)
(qd "zlf"	?$(CE3(B)
(qd "zla"	?$(CE4(B)
(qd "zlq"	?$(CE5(B)
(qd "zlt"	?$(CE6(B)
(qd "zld"	?$(CE7(B)
(qd "xk"	?$(CE8(B)
(qd "xkr"	?$(CE9(B)
(qd "xks"	?$(CE:(B)
(qd "xkf"	?$(CE;(B)
(qd "xkfr"	?$(CE<(B)
(qd "xka"	?$(CE=(B)
(qd "xkq"	?$(CE>(B)
(qd "xkt"	?$(CE?(B)
(qd "xkT"	?$(CE@(B)
(qd "xkd"	?$(CEA(B)
(qd "xo"	?$(CEB(B)
(qd "xor"	?$(CEC(B)
(qd "xos"	?$(CED(B)
(qd "xof"	?$(CEE(B)
(qd "xoa"	?$(CEF(B)
(qd "xoq"	?$(CEG(B)
(qd "xot"	?$(CEH(B)
(qd "xoT"	?$(CEI(B)
(qd "xod"	?$(CEJ(B)
(qd "xi"	?$(CEK(B)
(qd "xid"	?$(CEL(B)
(qd "xj"	?$(CEM(B)
(qd "xjr"	?$(CEN(B)
(qd "xjs"	?$(CEO(B)
(qd "xjf"	?$(CEP(B)
(qd "xjfa"	?$(CEQ(B)
(qd "xja"	?$(CER(B)
(qd "xjq"	?$(CES(B)
(qd "xjt"	?$(CET(B)
(qd "xjT"	?$(CEU(B)
(qd "xjd"	?$(CEV(B)
(qd "xp"	?$(CEW(B)
(qd "xpr"	?$(CEX(B)
(qd "xps"	?$(CEY(B)
(qd "xpf"	?$(CEZ(B)
(qd "xpa"	?$(CE[(B)
(qd "xpq"	?$(CE\(B)
(qd "xpt"	?$(CE](B)
(qd "xpd"	?$(CE^(B)
(qd "xu"	?$(CE_(B)
(qd "xus"	?$(CE`(B)
(qd "xuT"	?$(CEa(B)
(qd "xP"	?$(CEb(B)
(qd "xPs"	?$(CEc(B)
(qd "xh"	?$(CEd(B)
(qd "xhr"	?$(CEe(B)
(qd "xhs"	?$(CEf(B)
(qd "xhf"	?$(CEg(B)
(qd "xha"	?$(CEh(B)
(qd "xhq"	?$(CEi(B)
(qd "xht"	?$(CEj(B)
(qd "xhd"	?$(CEk(B)
(qd "xhv"	?$(CEl(B)
(qd "xhk"	?$(CEm(B)
(qd "xhks"	?$(CEn(B)
(qd "xho"	?$(CEo(B)
(qd "xhl"	?$(CEp(B)
(qd "xhls"	?$(CEq(B)
(qd "xhlt"	?$(CEr(B)
(qd "xhld"	?$(CEs(B)
(qd "xy"	?$(CEt(B)
(qd "xn"	?$(CEu(B)
(qd "xnr"	?$(CEv(B)
(qd "xns"	?$(CEw(B)
(qd "xnf"	?$(CEx(B)
(qd "xna"	?$(CEy(B)
(qd "xnq"	?$(CEz(B)
(qd "xnt"	?$(CE{(B)
(qd "xnd"	?$(CE|(B)
(qd "xnj"	?$(CE}(B)
(qd "xnjT"	?$(CE~(B)
(qd "xnp"	?$(CF!(B)
(qd "xnl"	?$(CF"(B)
(qd "xnlr"	?$(CF#(B)
(qd "xnls"	?$(CF$(B)
(qd "xnlf"	?$(CF%(B)
(qd "xnla"	?$(CF&(B)
(qd "xnlq"	?$(CF'(B)
(qd "xnld"	?$(CF((B)
(qd "xb"	?$(CF)(B)
(qd "xbs"	?$(CF*(B)
(qd "xbf"	?$(CF+(B)
(qd "xba"	?$(CF,(B)
(qd "xbd"	?$(CF-(B)
(qd "xm"	?$(CF.(B)
(qd "xmr"	?$(CF/(B)
(qd "xms"	?$(CF0(B)
(qd "xme"	?$(CF1(B)
(qd "xmf"	?$(CF2(B)
(qd "xmfa"	?$(CF3(B)
(qd "xma"	?$(CF4(B)
(qd "xmq"	?$(CF5(B)
(qd "xmt"	?$(CF6(B)
(qd "xml"	?$(CF7(B)
(qd "xmls"	?$(CF8(B)
(qd "xmlf"	?$(CF9(B)
(qd "xmla"	?$(CF:(B)
(qd "xmlq"	?$(CF;(B)
(qd "xl"	?$(CF<(B)
(qd "xlr"	?$(CF=(B)
(qd "xls"	?$(CF>(B)
(qd "xlf"	?$(CF?(B)
(qd "xla"	?$(CF@(B)
(qd "xlq"	?$(CFA(B)
(qd "xlt"	?$(CFB(B)
(qd "xld"	?$(CFC(B)
(qd "vk"	?$(CFD(B)
(qd "vkr"	?$(CFE(B)
(qd "vkR"	?$(CFF(B)
(qd "vks"	?$(CFG(B)
(qd "vkf"	?$(CFH(B)
(qd "vkfa"	?$(CFI(B)
(qd "vka"	?$(CFJ(B)
(qd "vkq"	?$(CFK(B)
(qd "vkt"	?$(CFL(B)
(qd "vkT"	?$(CFM(B)
(qd "vkd"	?$(CFN(B)
(qd "vkx"	?$(CFO(B)
(qd "vo"	?$(CFP(B)
(qd "vor"	?$(CFQ(B)
(qd "vos"	?$(CFR(B)
(qd "vof"	?$(CFS(B)
(qd "voa"	?$(CFT(B)
(qd "voq"	?$(CFU(B)
(qd "vot"	?$(CFV(B)
(qd "voT"	?$(CFW(B)
(qd "vod"	?$(CFX(B)
(qd "vi"	?$(CFY(B)
(qd "vir"	?$(CFZ(B)
(qd "vj"	?$(CF[(B)
(qd "vjr"	?$(CF\(B)
(qd "vjs"	?$(CF](B)
(qd "vjf"	?$(CF^(B)
(qd "vja"	?$(CF_(B)
(qd "vjq"	?$(CF`(B)
(qd "vjt"	?$(CFa(B)
(qd "vjT"	?$(CFb(B)
(qd "vjd"	?$(CFc(B)
(qd "vp"	?$(CFd(B)
(qd "vpr"	?$(CFe(B)
(qd "vps"	?$(CFf(B)
(qd "vpf"	?$(CFg(B)
(qd "vpa"	?$(CFh(B)
(qd "vpq"	?$(CFi(B)
(qd "vpt"	?$(CFj(B)
(qd "vpd"	?$(CFk(B)
(qd "vu"	?$(CFl(B)
(qd "vus"	?$(CFm(B)
(qd "vuf"	?$(CFn(B)
(qd "vua"	?$(CFo(B)
(qd "vuq"	?$(CFp(B)
(qd "vuT"	?$(CFq(B)
(qd "vud"	?$(CFr(B)
(qd "vP"	?$(CFs(B)
(qd "vPf"	?$(CFt(B)
(qd "vPq"	?$(CFu(B)
(qd "vPt"	?$(CFv(B)
(qd "vh"	?$(CFw(B)
(qd "vhr"	?$(CFx(B)
(qd "vhs"	?$(CFy(B)
(qd "vhf"	?$(CFz(B)
(qd "vha"	?$(CF{(B)
(qd "vhq"	?$(CF|(B)
(qd "vht"	?$(CF}(B)
(qd "vhd"	?$(CF~(B)
(qd "vhk"	?$(CG!(B)
(qd "vhkd"	?$(CG"(B)
(qd "vhl"	?$(CG#(B)
(qd "vhls"	?$(CG$(B)
(qd "vy"	?$(CG%(B)
(qd "vys"	?$(CG&(B)
(qd "vyf"	?$(CG'(B)
(qd "vyq"	?$(CG((B)
(qd "vyt"	?$(CG)(B)
(qd "vn"	?$(CG*(B)
(qd "vnr"	?$(CG+(B)
(qd "vns"	?$(CG,(B)
(qd "vne"	?$(CG-(B)
(qd "vnf"	?$(CG.(B)
(qd "vnfa"	?$(CG/(B)
(qd "vna"	?$(CG0(B)
(qd "vnq"	?$(CG1(B)
(qd "vnt"	?$(CG2(B)
(qd "vnd"	?$(CG3(B)
(qd "vnj"	?$(CG4(B)
(qd "vnjd"	?$(CG5(B)
(qd "vnl"	?$(CG6(B)
(qd "vnls"	?$(CG7(B)
(qd "vnlf"	?$(CG8(B)
(qd "vnla"	?$(CG9(B)
(qd "vnlt"	?$(CG:(B)
(qd "vb"	?$(CG;(B)
(qd "vbs"	?$(CG<(B)
(qd "vbf"	?$(CG=(B)
(qd "vba"	?$(CG>(B)
(qd "vbt"	?$(CG?(B)
(qd "vbd"	?$(CG@(B)
(qd "vm"	?$(CGA(B)
(qd "vms"	?$(CGB(B)
(qd "vmf"	?$(CGC(B)
(qd "vma"	?$(CGD(B)
(qd "vmq"	?$(CGE(B)
(qd "vmt"	?$(CGF(B)
(qd "vl"	?$(CGG(B)
(qd "vlr"	?$(CGH(B)
(qd "vls"	?$(CGI(B)
(qd "vlf"	?$(CGJ(B)
(qd "vla"	?$(CGK(B)
(qd "vlq"	?$(CGL(B)
(qd "vlt"	?$(CGM(B)
(qd "vld"	?$(CGN(B)
(qd "gk"	?$(CGO(B)
(qd "gkr"	?$(CGP(B)
(qd "gks"	?$(CGQ(B)
(qd "gkf"	?$(CGR(B)
(qd "gkfx"	?$(CGS(B)
(qd "gka"	?$(CGT(B)
(qd "gkq"	?$(CGU(B)
(qd "gkt"	?$(CGV(B)
(qd "gkd"	?$(CGW(B)
(qd "go"	?$(CGX(B)
(qd "gor"	?$(CGY(B)
(qd "gos"	?$(CGZ(B)
(qd "gof"	?$(CG[(B)
(qd "goa"	?$(CG\(B)
(qd "goq"	?$(CG](B)
(qd "got"	?$(CG^(B)
(qd "goT"	?$(CG_(B)
(qd "god"	?$(CG`(B)
(qd "gi"	?$(CGa(B)
(qd "gid"	?$(CGb(B)
(qd "gj"	?$(CGc(B)
(qd "gjr"	?$(CGd(B)
(qd "gjs"	?$(CGe(B)
(qd "gjf"	?$(CGf(B)
(qd "gjfa"	?$(CGg(B)
(qd "gja"	?$(CGh(B)
(qd "gjq"	?$(CGi(B)
(qd "gjt"	?$(CGj(B)
(qd "gjd"	?$(CGk(B)
(qd "gp"	?$(CGl(B)
(qd "gpr"	?$(CGm(B)
(qd "gps"	?$(CGn(B)
(qd "gpf"	?$(CGo(B)
(qd "gpa"	?$(CGp(B)
(qd "gpq"	?$(CGq(B)
(qd "gpt"	?$(CGr(B)
(qd "gpd"	?$(CGs(B)
(qd "gu"	?$(CGt(B)
(qd "gur"	?$(CGu(B)
(qd "gus"	?$(CGv(B)
(qd "guf"	?$(CGw(B)
(qd "gua"	?$(CGx(B)
(qd "guq"	?$(CGy(B)
(qd "gut"	?$(CGz(B)
(qd "guT"	?$(CG{(B)
(qd "gud"	?$(CG|(B)
(qd "gP"	?$(CG}(B)
(qd "gPs"	?$(CG~(B)
(qd "gPf"	?$(CH!(B)
(qd "gPq"	?$(CH"(B)
(qd "gh"	?$(CH#(B)
(qd "ghr"	?$(CH$(B)
(qd "ghs"	?$(CH%(B)
(qd "ghf"	?$(CH&(B)
(qd "ghfx"	?$(CH'(B)
(qd "gha"	?$(CH((B)
(qd "ghq"	?$(CH)(B)
(qd "ght"	?$(CH*(B)
(qd "ghd"	?$(CH+(B)
(qd "ghx"	?$(CH,(B)
(qd "ghk"	?$(CH-(B)
(qd "ghkr"	?$(CH.(B)
(qd "ghks"	?$(CH/(B)
(qd "ghkf"	?$(CH0(B)
(qd "ghkt"	?$(CH1(B)
(qd "ghkd"	?$(CH2(B)
(qd "gho"	?$(CH3(B)
(qd "ghor"	?$(CH4(B)
(qd "ghos"	?$(CH5(B)
(qd "ghot"	?$(CH6(B)
(qd "ghod"	?$(CH7(B)
(qd "ghl"	?$(CH8(B)
(qd "ghlr"	?$(CH9(B)
(qd "ghls"	?$(CH:(B)
(qd "ghlf"	?$(CH;(B)
(qd "ghlq"	?$(CH<(B)
(qd "ghlt"	?$(CH=(B)
(qd "ghld"	?$(CH>(B)
(qd "gy"	?$(CH?(B)
(qd "gys"	?$(CH@(B)
(qd "gyf"	?$(CHA(B)
(qd "gyq"	?$(CHB(B)
(qd "gyt"	?$(CHC(B)
(qd "gn"	?$(CHD(B)
(qd "gnr"	?$(CHE(B)
(qd "gns"	?$(CHF(B)
(qd "gnf"	?$(CHG(B)
(qd "gnfx"	?$(CHH(B)
(qd "gna"	?$(CHI(B)
(qd "gnt"	?$(CHJ(B)
(qd "gnd"	?$(CHK(B)
(qd "gnj"	?$(CHL(B)
(qd "gnjs"	?$(CHM(B)
(qd "gnjf"	?$(CHN(B)
(qd "gnja"	?$(CHO(B)
(qd "gnjd"	?$(CHP(B)
(qd "gnp"	?$(CHQ(B)
(qd "gnpr"	?$(CHR(B)
(qd "gnps"	?$(CHS(B)
(qd "gnpf"	?$(CHT(B)
(qd "gnpd"	?$(CHU(B)
(qd "gnl"	?$(CHV(B)
(qd "gnlr"	?$(CHW(B)
(qd "gnls"	?$(CHX(B)
(qd "gnlf"	?$(CHY(B)
(qd "gnla"	?$(CHZ(B)
(qd "gnlq"	?$(CH[(B)
(qd "gnlt"	?$(CH\(B)
(qd "gnld"	?$(CH](B)
(qd "gb"	?$(CH^(B)
(qd "gbr"	?$(CH_(B)
(qd "gbs"	?$(CH`(B)
(qd "gbf"	?$(CHa(B)
(qd "gba"	?$(CHb(B)
(qd "gbt"	?$(CHc(B)
(qd "gbd"	?$(CHd(B)
(qd "gm"	?$(CHe(B)
(qd "gmr"	?$(CHf(B)
(qd "gms"	?$(CHg(B)
(qd "gmsg"	?$(CHh(B)
(qd "gme"	?$(CHi(B)
(qd "gmf"	?$(CHj(B)
(qd "gmfr"	?$(CHk(B)
(qd "gma"	?$(CHl(B)
(qd "gmq"	?$(CHm(B)
(qd "gmt"	?$(CHn(B)
(qd "gmd"	?$(CHo(B)
(qd "gmx"	?$(CHp(B)
(qd "gml"	?$(CHq(B)
(qd "gmls"	?$(CHr(B)
(qd "gmlf"	?$(CHs(B)
(qd "gmla"	?$(CHt(B)
(qd "gmlq"	?$(CHu(B)
(qd "gmld"	?$(CHv(B)
(qd "gl"	?$(CHw(B)
(qd "glr"	?$(CHx(B)
(qd "gls"	?$(CHy(B)
(qd "glf"	?$(CHz(B)
(qd "gla"	?$(CH{(B)
(qd "glq"	?$(CH|(B)
(qd "glt"	?$(CH}(B)
(qd "gld"	?$(CH~(B)

(qd "Z!"	?$(C#!(B)
(qd "Z\""	?$(C#"(B)
(qd "Z#"	?$(C##(B)
(qd "Z$"	?$(C#$(B)
(qd "Z%"	?$(C#%(B)
(qd "Z&"	?$(C#&(B)
(qd "Z'"	?$(C#'(B)
(qd "Z("	?$(C#((B)
(qd "Z)"	?$(C#)(B)
(qd "Z*"	?$(C#*(B)
(qd "Z+"	?$(C#+(B)
(qd "Z,"	?$(C#,(B)
(qd "Z-"	?$(C#-(B)
(qd "Z."	?$(C#.(B)
(qd "Z/"	?$(C#/(B)
(qd "Z0"	?$(C#0(B)
(qd "Z1"	?$(C#1(B)
(qd "Z2"	?$(C#2(B)
(qd "Z3"	?$(C#3(B)
(qd "Z4"	?$(C#4(B)
(qd "Z5"	?$(C#5(B)
(qd "Z6"	?$(C#6(B)
(qd "Z7"	?$(C#7(B)
(qd "Z8"	?$(C#8(B)
(qd "Z9"	?$(C#9(B)
(qd "Z:"	?$(C#:(B)
(qd "Z;"	?$(C#;(B)
(qd "Z<"	?$(C#<(B)
(qd "Z="	?$(C#=(B)
(qd "Z>"	?$(C#>(B)
(qd "Z?"	?$(C#?(B)
(qd "Z@"	?$(C#@(B)
(qd "ZA"	?$(C#A(B)
(qd "ZB"	?$(C#B(B)
(qd "ZC"	?$(C#C(B)
(qd "ZD"	?$(C#D(B)
(qd "ZE"	?$(C#E(B)
(qd "ZF"	?$(C#F(B)
(qd "ZG"	?$(C#G(B)
(qd "ZH"	?$(C#H(B)
(qd "ZI"	?$(C#I(B)
(qd "ZJ"	?$(C#J(B)
(qd "ZK"	?$(C#K(B)
(qd "ZL"	?$(C#L(B)
(qd "ZM"	?$(C#M(B)
(qd "ZN"	?$(C#N(B)
(qd "ZO"	?$(C#O(B)
(qd "ZP"	?$(C#P(B)
(qd "ZQ"	?$(C#Q(B)
(qd "ZR"	?$(C#R(B)
(qd "ZS"	?$(C#S(B)
(qd "ZT"	?$(C#T(B)
(qd "ZU"	?$(C#U(B)
(qd "ZV"	?$(C#V(B)
(qd "ZW"	?$(C#W(B)
(qd "ZX"	?$(C#X(B)
(qd "ZY"	?$(C#Y(B)
(qd "ZZ"	?$(C#Z(B)
(qd "Z["	?$(C#[(B)
(qd "SW"	?$(C#\(B)
(qd "Z]"	?$(C#](B)
(qd "Z^"	?$(C#^(B)
(qd "Z_"	?$(C#_(B)
(qd "Z`"	?$(C#`(B)
(qd "Za"	?$(C#a(B)
(qd "Zb"	?$(C#b(B)
(qd "Zc"	?$(C#c(B)
(qd "Zd"	?$(C#d(B)
(qd "Ze"	?$(C#e(B)
(qd "Zf"	?$(C#f(B)
(qd "Zg"	?$(C#g(B)
(qd "Zh"	?$(C#h(B)
(qd "Zi"	?$(C#i(B)
(qd "Zj"	?$(C#j(B)
(qd "Zk"	?$(C#k(B)
(qd "Zl"	?$(C#l(B)
(qd "Zm"	?$(C#m(B)
(qd "Zn"	?$(C#n(B)
(qd "Zo"	?$(C#o(B)
(qd "Zp"	?$(C#p(B)
(qd "Zq"	?$(C#q(B)
(qd "Zr"	?$(C#r(B)
(qd "Zs"	?$(C#s(B)
(qd "Zt"	?$(C#t(B)
(qd "Zu"	?$(C#u(B)
(qd "Zv"	?$(C#v(B)
(qd "Zw"	?$(C#w(B)
(qd "Zx"	?$(C#x(B)
(qd "Zy"	?$(C#y(B)
(qd "Zz"	?$(C#z(B)
(qd "Z{"	?$(C#{(B)
(qd "Z|"	?$(C#|(B)
(qd "Z}"	?$(C#}(B)
(qd "Z^-"	?$(C#~(B)

(qd "HS"	?$(C$U(B)
(qd "Hse"	?$(C$V(B)
(qd "Hst"	?$(C$W(B)
(qd "HsT"	?$(C$X(B)
(qd "Hfrt"	?$(C$Y(B)
(qd "Hfqt"	?$(C$[(B)
(qd "Hfe"	?$(C$Z(B)
(qd "HfT"	?$(C$\(B)
(qd "HfG"	?$(C$](B)
(qd "Haq"	?$(C$^(B)
(qd "Hat"	?$(C$_(B)
(qd "HaT"	?$(C$`(B)
(qd "Had"	?$(C$a(B)
(qd "Hqr"	?$(C$b(B)
(qd "Hqe"	?$(C$c(B)
(qd "Hqtr"	?$(C$d(B)
(qd "Hqte"	?$(C$e(B)
(qd "Hqw"	?$(C$f(B)
(qd "Hqx"	?$(C$g(B)
(qd "Hqd"	?$(C$h(B)
(qd "HQd"	?$(C$i(B)
(qd "Htr"	?$(C$j(B)
(qd "Hts"	?$(C$k(B)
(qd "Hte"	?$(C$l(B)
(qd "Htq"	?$(C$m(B)
(qd "Htw"	?$(C$n(B)
(qd "HT"	?$(C$o(B)
(qd "HD"	?$(C$p(B)
(qd "Hd"	?$(C$q(B)
(qd "Hdw"	?$(C$r(B)
(qd "HdT"	?$(C$s(B)
(qd "Hvd"	?$(C$t(B)
(qd "HG"	?$(C$u(B)
(qd "Hg"	?$(C$v(B)
(qd "Hyi"	?$(C$w(B)
(qd "HyO"	?$(C$x(B)
(qd "Hyl"	?$(C$y(B)
(qd "Hbu"	?$(C$z(B)
(qd "HbP"	?$(C${(B)
(qd "Hbl"	?$(C$|(B)
(qd "H."	?$(C$}(B)
(qd "H.l"	?$(C$~(B)

(qd "SY"	?$(C!M(B)
(qd "SP"	?$(C!L(B)
(qd "S%"	?$(C"6(B)
(qd "Swn"	?$(C"_(B)
(qd "Sks"	?$(C"^(B)
(qd "SNo"	?$(C"`(B)
(qd "SCo"	?$(C"a(B)
(qd "STM"	?$(C"b(B)
(qd "Sam"	?$(C"c(B)
(qd "Spm"	?$(C"d(B)
(qd "STel"	?$(C"e(B)
(qd "SC"	?$(C!I(B)
(qd "SA"	?$(C!J(B)
(qd "SC/"	?$(C!K(B)
(qd "SF"	?$(C"5(B)

(quail-setup-current-package)
