#!/usr/bin/perl -w

use Net::MsnMessenger;
use strict;
use vars qw($msn $socket $srv_socket);

$msn = Net::MsnMessenger->new(debug => 1, debug_connection => 1);

$msn->add_callback('DEBUG', \&debug);
$msn->add_callback('DEBUG_CONNECTION', \&debug);

$socket = Net::MsnMessenger::Connection->new(
    address         => '192.168.0.1',
    port            => '6891',
    connection_type => 'server',
    server_type     => 'FTP',
    protocol        => 'tcp',
    msn             => $msn,
);

$socket->create_connection;

while (1)
{
    $msn->do_one_loop;
    print "ERROR: " . $msn->get_error . "\n" if $msn->error;
}

sub debug
{
    print "$_[0]\n";
}

