#!/usr/bin/perl -w
#
# Print a list of Net::MsnMessenger's callbacks

use DirHandle;
use FileHandle;
use strict;

my @files = "../lib/Net/MsnMessenger.pm";
my $dh = DirHandle->new("../lib/Net/MsnMessenger") || die $!;
my @cbs = ();

for ($dh->read)
{
    push @files, "../lib/Net/MsnMessenger/$_" if !/^\./;
}
$dh->close;

for (@files)
{
    my $fh = new FileHandle "< $_" || die $!;

    while (my $line = <$fh>)
    {
        if ($line =~ /->_callback\(\s*(?:\'|\")(\S+?)(?:\'|\")/)
        {
	    push @cbs, $1 unless grep {$_ eq $1} @cbs;
	}
    }
    $fh->close;
}

print $_ . "\n" for sort @cbs;

