# -*- Mode: perl; perl-indent-level: 8; coding: utf-8 -*-
#
# Net::MsnMessenger::Voice
#
# Copyright (C) 2003 <incoming@tiscali.cz>  All rights reserved.
# This module is free software; You can redistribute and/or modify it under
# the same terms as Perl itself.
#
# $Id: Voice.pm,v 1.6 2003/07/15 21:34:05 incoming Exp $

package Net::MsnMessenger::Voice;

use strict qw(subs vars);
use vars   qw($AUTOLOAD);

sub AUTOLOAD
{
	my $self = shift;
	my $name = $AUTOLOAD;
	$name =~ s/.*:://;
	return if $name =~ /DESTROY$/;

	if (!exists $self->{$name})
	{
		Carp::croak("AUTOLOAD: $name is not a valid method\n");
	}
	$self->{$name} = shift if @_;
	$self->{$name};
}

# Net::MsnMessenger::Voice->new
sub new
{
	my ($this, %args) = @_;
	my $self = {};

	$self->{invitation_cookie} = $args{invitation_cookie} || undef;

	$self->{voice_session} = $args{voice_session};
	$self->{swb_session}   = $args{swb_session};
	$self->{msn}           = $args{msn};

	$self->{ip_address} = undef;
	$self->{port}       = undef;
	$self->{conn_type}  = undef;
	$self->{type}       = 'Voice Conversation';

	$self->{incoming} = $args{incoming} || undef;
	$self->{outgoing} = $args{outgoing} || undef;

	$self->{_client} = undef;
	$self->{session_id} = $args{session_id} || undef;

	bless $self, $this;
	$self->{swb} = $self->msn->{_swb}->[$self->{swb_session}];
	return $self;
}

# Net::MsnMessenger::Voice->invite
sub invite
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$self->invitation_cookie(int(rand(9999999)+1));
	$self->msn->session_id($message->generate_session_id) if !defined $self->msn->session_id;
	$self->session_id($self->msn->session_id);

	$attributes{invitation_command} = "INVITE";
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{session_protocol} = 'SM1';
	$attributes{context_data} = "Requested:SIP_A,;Capabilities:SIP_A,SIP_V,;";
	$attributes{session_id} = $self->session_id;

	$message->add_header_voice;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
	1;
}

# Net::MsnMessenger::Voice->invite_accept
sub invite_accept
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'ACCEPT';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{context_data} = 'Requested:SIP_A,;';
	$attributes{session_protocol} = 'SM1';
	$attributes{conn_type} = 'Direct-Connect';
	$attributes{launch_application} = 'TRUE';
	$attributes{ip_address} = $self->msn->ip_address . ':10119';
	$attributes{session_id} = $self->session_id;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
	1;
}

# Net::MsnMessenger::Voice->invite_accept_confirm
sub invite_accept_confirm
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'ACCEPT';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{session_protocol} = 'SM1';

	$attributes{launch_application} = 'TRUE';
	$attributes{session_id} = $self->session_id;

	# TODO: Finish!
}

# Net::MsnMessenger::Voice->invite_cancel
sub invite_cancel
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'CANCEL';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{cancel_code} = 'TIMEOUT';
	$attributes{session_id} = $self->session_id;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
	1;
}

# Net::MsnMessenger::Voice->invite_reject
sub invite_reject
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'CANCEL';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{cancel_code} = 'REJECT';
	$attributes{session_id} = $self->session_id;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
	1;
}

# Net::MsnMessenger::Voice->create_client
sub create_client
{
	my $self = shift;

	if ($self->conn_type eq 'Direct-Connect')
	{
		$self->msn->_callback('DEBUG', "Voice: Connect to $self->{ip_address}:$self->{port}");

		$self->{_client} = Net::MsnMessenger::Connection->new(
			address         => $self->ip_address,
			port            => $self->port,
			connection_type => 'client',
			server_type     => 'voice',
			protocol        => 'udp',
			swb_session     => $self->swb_session,
			voice_session   => $self->voice_session,
			msn             => $self->msn,
		);

		$self->{_client}->create_connection || return undef;
	}
	else
	{
		$self->msn->disconnect_voice($self->swb_session, $self->voice_session);
		$self->msn->_callback('VOICE_CANCEL', $self->swb_session, $self->voice_session,
				      "Connection type $self->{conn_type} is not supported");
	}

	# TODO: Finish!
	1;
}

"Net::MsnMessenger::Voice";
__END__
