# -*- Mode: perl; perl-indent-level: 8; coding: utf-8 -*-
#
# Net::MsnMessenger::Switchboard
#
# Copyright (C) 2003 <incoming@tiscali.cz>  All rights reserved.
# This module is free software; You can redistribute and/or modify it under
# the same terms as Perl itself.
#
# $Id: Switchboard.pm,v 1.6 2003/07/15 21:34:05 incoming Exp $

package Net::MsnMessenger::Switchboard;

use strict qw(subs vars);
use vars   qw($AUTOLOAD);

sub AUTOLOAD
{
	my $self = shift;
	my $name = $AUTOLOAD;
	$name =~ s/.*:://;
	return if $name =~ /DESTROY$/;

	if (exists $self->{$name})
	{
		$self->{$name} = shift if @_;
		return $self->{$name};
	}

	return $self->{_client}->$name(@_) if defined $self->{_client} &&
	    $self->{_client}->can($name);

	if (exists $self->{_client}->{$name})
	{
		$self->{_client}->{$name} = shift if @_;
		return $self->{_client}->{$name};
	}
	Carp::confess("AUTOLOAD: $name is not a valid method\n");
}

# Net::MsnMessenger::Switchboard->new
sub new
{
	my $this = shift;
	my %args = @_;
	my $self = {};

	$self->{swb_id_srv} = $args{swb_id_srv} || undef;  # Server side session ID
	$self->{swb_id}     = $args{swb_id};               # Local session ID
	$self->{conn_hash}  = $args{conn_hash} || undef;   # Hash to login to the SB server
	$self->{incoming}   = ();                          # Inocming/outgoing messages sorted
	$self->{outgoing}   = ();                          # by the transaction ID
	$self->{inviting}   = undef;
	$self->{msn}        = $args{msn};

	$self->{_client} = undef;
	$self->{_users}  = ();                             # Users in this session

	$self->{_file}          = ();                      # File transfers
	$self->{_file_sessions} = 0;                       # Number of File transfer sessions

	$self->{_voice}          = ();                     # Voice conversations
	$self->{_voice_sessions} = 0;                      # Number of Voice sessions

	$self->{_netmeeting}          = ();
	$self->{_netmeeting_sessions} = 0;

	$self->{_rassistance}          = ();
	$self->{_rassistance_sessions} = 0;

	$self->{_client} = Net::MsnMessenger::Connection->new(
		address         => $args{server},
		port            => $args{port},
		connection_type => 'client',
		server_type     => 'SS',
		protocol        => 'tcp',
		swb_session     => $args{swb_id},
		msn             => $args{msn},
	);

	bless $self, $this;
	return $self;
}

# Net::MsnMessenger::Switchboard->add_user
sub add_user
{
	my ($self, $passport, $fname) = @_;
	my $r_user = $self->msn->get_user($passport);

	if (!defined $r_user)
	{
		$r_user = Net::MsnMessenger::Contact->new(passport => $passport, fname => $fname);
	}

	if ($self->{_users})
	{
		return undef if grep {$r_user->passport eq $_->passport} @{$self->{_users}};
	}
	push @{$self->{_users}}, $r_user;
	1;
}

# Net::MsnMessenger::Switchboard->remove_user
sub remove_user
{
	my ($self, $user) = @_;
	for (my $i = 0; $i < @{$self->{_users}}; $i++)
	{
		return splice @{$self->{_users}}, $i, 1 if $self->{_users}->[$i]->passport eq $user;
	}
	return undef;
}

# Net::MsnMessenger::Switchboard->get_users
sub get_users
{
	my $self = shift;
	return @{$self->{_users}} if $self->{_users} && scalar @{$self->{_users}};
	return ();
}

# Net::MsnMessenger::Switchboard->invite_login
sub invite_login
{
	my $self = shift;
	return undef if $self->connected;

	$self->create_connection or return undef;
	$self->send_packet('user', $self->msn->passport, $self->conn_hash, "\r\n");
	1;
}

# Net::MsnMessenger::Switchboard->invite_to_session
sub invite_to_session
{
	my ($self, $passport) = @_;
	$self->send_packet('invite', $passport, "\r\n");
	1;
}

# Net::MsnMessenger::Switchboard->join_session
sub join_session
{
	my $self = shift;
	return undef if $self->connected;

	$self->create_connection or return undef;
	$self->send_packet('answer',
			   $self->msn->passport, $self->conn_hash, $self->swb_id_srv, "\r\n");
    1;
}

# Net::MsnMessenger::Switchboard->find_cookie
sub find_cookie
{
	my ($self, $cookie) = @_;
	return undef if !defined $cookie;

	for ('_file', '_voice', '_netmeeting', '_rassistance')
	{
		next if !$self->{$_."_sessions"};

		for (my $i = 0; $i < $self->{$_."_sessions"}; $i++)
		{
			return $self->{$_}->[$i] if defined $self->{$_}->[$i] && defined
			    $self->{$_}->[$i]->invitation_cookie && $self->{$_}->[$i]->invitation_cookie eq $cookie;
		}
	}
	undef;
}

# Net::MsnMessenger::Switchboard->remove_invite
sub remove_invite
{
	my ($self, $invitation_cookie) = @_;
	my $cookie_obj = $self->find_cookie($invitation_cookie);

	if (defined $cookie_obj)
	{
		if ($cookie_obj->type eq 'File Transfer')
		{
			$self->msn->disconnect_file($cookie_obj->swb_session,
						    $cookie_obj->file_session);
		}

		elsif ($cookie_obj->type eq 'Voice Conversation')
		{
			$self->msn->disconnect_voice($cookie_obj->swb_session,
						     $cookie_obj->voice_session);
		}

		elsif ($cookie_obj->type eq 'NetMeeting')
		{
		}

		elsif ($cookie_obj->type eq 'Remote Assistance')
		{
		}
	}
	1;
}

"Net::MsnMessenger::Switchboard";
__END__

