# -*- Mode: perl; perl-indent-level: 8; coding: utf-8 -*-
#
# Net::MsnMessenger::RemoteAssistance
#
# Copyright (C) 2003 <incoming@tiscali.cz>  All rights reserved.
# This module is free software; You can redistribute and/or modify it under
# the same terms as Perl itself.
#
# $Id: RemoteAssistance.pm,v 1.3 2003/07/06 04:13:02 incoming Exp $

package Net::MsnMessenger::RemoteAssistance;

use strict qw(subs vars);
use vars   qw($AUTOLOAD);

sub AUTOLOAD
{
	my $self = shift;
	my $name = $AUTOLOAD;
	$name =~ s/.*:://;
	return if $name =~ /DESTROY$/;

	if (!exists $self->{$name})
	{
		Carp::croak("AUTOLOAD: $name is not a valid method\n");
	}
	$self->{$name} = shift if @_;
	$self->{$name};
}

# Net::MsnMessenger::RemoteAssistance->new
sub new
{
	my ($this, %args) = @_;
	my $self = {};

	$self->{invitation_cookie} = $args{invitation_cookie} || undef;
	$self->{rassistance_session} = $args{rassistance_session};

	$self->{swb_session} = $args{swb_session};
	$self->{msn}         = $args{msn};

	$self->{ip_address} = undef;
	$self->{port}       = undef;
	$self->{type}       = 'Remote Assistance';

	$self->{incoming} = $args{incoming} || undef;
	$self->{outgoing} = $args{outgoing} || undef;

	$self->{_client} = undef;
	$self->{session_id} = $args{session_id} || undef;

	bless $self, $this;
	$self->{swb} = $self->msn->{_swb}->[$self->{swb_session}];
	return $self;
}

# Net::MsnMessenger::RemoteAssistance->invite
sub invite
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$self->invitation_cookie(int(rand(9999999)+1));
	$self->msn->session_id($message->generate_session_id) if !defined $self->msn->session_id;
	$self->session_id($self->msn->session_id);

	$attributes{invitation_command} = 'INVITE';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{session_protocol} = 'SM1';
	$attributes{session_id} = $self->session_id;

	$message->add_header_remote_assistance;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
	1;
}

# Net::MsnMessenger::RemoteAssistance->invite_accept
sub invite_accept
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'ACCEPT';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{session_protocol} = 'SM1';
	$attributes{launch_application} = 'TRUE';
	$attributes{request_data} = 'IP-Address:';
	$attributes{ip_address} = $self->msn->ip_address;
	$attributes{session_id} = $self->session_id;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
	1;
}

# Net::MsnMessenger::RemoteAssistance->invite_accept_confirm
sub invite_accept_confirm
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'ACCEPT';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{session_protocol} = 'SM1';
	$attributes{launch_application} = 'TRUE';
	$attributes{request_data} = 'IP-Address:';
	$attributes{ip_address} = $self->msn->ip_address;
	$attributes{session_id} = $self->session_id;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
}

# Net::MsnMessenger::RemoteAssistance->invite_cancel
sub invite_cancel
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'CANCEL';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{cancel_code} = 'TIMEOUT';
	$attributes{session_id} = $self->session_id;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
	1;
}

# Net::MsnMessenger::RemoteAssistance->invite_context
sub invite_context
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'CONTEXT';
	$attributes{invitation_cookie} = $self->invitation_cookie;

	# TODO: Finish
}

# Net::MsnMessenger::RemoteAssistance->invite_reject
sub invite_reject
{
	my $self = shift;
	my $message = Net::MsnMessenger::Message->new;
	my %attributes;

	$attributes{invitation_command} = 'CANCEL';
	$attributes{invitation_cookie} = $self->invitation_cookie;
	$attributes{cancel_code} = 'REJECT';
	$attributes{session_id} = $self->session_id;

	$self->swb->send_packet('message', $message->create_invite(%attributes));
	1;
}

"Net::MsnMessenger::RemoteAssistance";
__END__
