# -*- Mode: perl; perl-indent-level: 8; coding: utf-8 -*-
#
# Net::MsnMessenger::Data
#
# Copyright (C) 2003 <incoming@tiscali.cz>  All rights reserved.
# This module is free software; You can redistribute and/or modify it under
# the same terms as Perl itself.
#
# $Id: Data.pm,v 1.10 2003/07/17 08:12:48 incoming Exp $

package Net::MsnMessenger::Data;

use Exporter;
use strict;

use vars  qw(@ISA @EXPORT $Challenge $Msn_version $Message_len $Pager_len $Command
	     %Error %Guid %Status %Contact_List %LCID
	     %R_Status %R_Contact_List %R_LCID);


@ISA    = qw(Exporter);


@EXPORT = qw($Challenge $Msn_version $Message_len $Pager_len $Command
	     %Error %Guid %Status %Contact_List %LCID
	     %R_Status %R_Contact_List %R_LCID);


$Challenge   = "Q1P7W2E4J9R8U3S5";              # Md5 challenge magic
$Msn_version = "MSNP7 MSNP6 MSNP5 MSNP4 CVR0";  # MSN protocol version (v7)
$Message_len = 1664;                            # Maximal instant message length
$Pager_len   = 113;


$Command = {
	Contact_List => {
		auto_allow           => 'GTC',
		block_privacy        => 'BLP',
		list                 => 'LST',
		list_group           => 'LSG',
		mobile_device        => 'MOB',
		mobile_device_my     => 'MBE',
		phone_home           => 'PHH',
		phone_list_own       => 'PRP',
		phone_list_user      => 'BPR',
		phone_mobile         => 'PHM',
		phone_work           => 'PHW',
		sync                 => 'SYN',
	},

	Event => {
		add_group            => 'ADG',
		add_user             => 'ADD',
		change_my_status     => 'CHG',
		challenge            => 'CHL',
		client_version       => 'CVR',
		find                 => 'FND',
		find_invite          => 'SDC',
		friendly_name        => 'REA',
		incoming_page        => 'IPG',    # TODO
		initial_status       => 'ILN',
		login                => 'NLN',
		logout               => 'FLN',
		message              => 'MSG',
		notification         => 'NOT',
		pager                => 'PAG',
		ping                 => 'PNG',
		pong                 => 'QNG',
		query                => 'QRY',
		remove_group         => 'RMG',
		remove_user          => 'REM',
		rename_group         => 'REG',
		send_invitation      => 'SND',
		url                  => 'URL',
		quit                 => 'OUT',
	},

	File => {
		file                 => 'FIL',
		file_cancel          => 'CCL',
		file_transfer        => 'TFR',
	},

	Login => {
		info                 => 'INF',
		redirect             => 'XFR',
		user                 => 'USR',
		version              => 'VER',
	},

	Switchboard => {
		answer               => 'ANS',
		acknowledge          => 'ACK',
		invite               => 'CAL',
		invited              => 'RNG',
		join                 => 'JOI',
		leave                => 'BYE',
		list_swb             => 'IRO',
		not_acknowledge      => 'NAK',
	},
};

%Guid = (
	 "Application sharing"     => '{F1B1920C-6A3C-4ce7-B18C-AFAB305FD03D}',  # ## TODO
	 "File Transfer"           => '{5D3E02AB-6190-11d3-BBBB-00C04F795683}',
	 "NetMeeting"              => '{44BBA842-CC51-11CF-AAFA-00AA00B6015C}',
	 "Remote Assistance"       => '{56b994a7-380f-410b-9985-c809d78c1bdc}',  # ## TODO
	 "Voice Conversation"      => '{02D3C01F-BF30-4825-A83A-DE7AF41648AA}',  # ## TODO
	 "Whiteboard"              => '{1DF57D09-637A-4ca5-91B9-2C3EDAAF62FE}',  # ## TODO
);

%Error = (
	  200 => 'Syntax error',
	  201 => 'Invalid parameter',
	  205 => 'Invalid user',
	  206 => 'Domain name is missing',
	  207 => 'Already logged in',
	  208 => 'Invalid user name',                         # SWB Connection Error (1st user)
	  209 => 'Nickname change is illegal',
	  210 => 'The user list is full',
	  215 => 'The user is already there',
	  216 => 'The user is not in list',                   # SWB Connection Error (1st user)
	  217 => 'The user is not online',                    # SWB Connection Error (1st user)
	  218 => 'Already in mode',
	  219 => 'The user is in the opposite list',
	  223 => 'Too many groups',
	  224 => 'Invalid group',
	  225 => 'User is not in group',
	  229 => 'Group name is too long',
	  230 => 'Cannot remove group zero',
	  231 => 'The group is invalid',
	  280 => 'Switchboard failed',
	  281 => 'Transfer to switchboard failed',

	  300 => 'Required field missing',
	  301 => 'Too many matches found',
	  302 => 'Not logged in',

	  500 => 'Internal server error',
	  501 => 'Database server error',
	  502 => 'Member search is currently unavailable',
	  510 => 'File operation failed',
	  520 => 'Memory allocation failed',
	  540 => 'Challenge response failed',

	  600 => 'Server is busy',
	  601 => 'Server is unavailable',
	  602 => 'Peer nameserver is down',
	  603 => 'Database connection failed',
	  604 => 'Server is going down',
	  605 => 'Server is unavailable',

	  707 => 'Could not create connection',
	  710 => 'Bad CVR parameters sent',
	  711 => 'Write is blocking',
	  712 => 'Session is overloaded',
	  713 => 'Too many active users',
	  714 => 'Too many sessions',
	  715 => 'Not expected',
	  717 => 'Bad friend file',
	  731 => 'Not expected',

	  800 => 'Server commands sent too rapidly',

	  910 => 'Server too busy',
	  911 => 'Authentication failed',
	  912 => 'Server too busy',
	  913 => 'Not allowed when offline',                  # SWB Connection Error
	  914 => 'Server is unavailable',
	  915 => 'Server is unavailable',
	  916 => 'Server is unavailable',
	  917 => 'Authentication failed',
	  918 => 'Server is too busy',
	  919 => 'Server is too busy',
	  920 => 'Not accepting new users',
	  921 => 'Server is too busy',
	  922 => 'Server is too busy',
	  923 => 'Kids Passport without parental consent',    # NS Connection Error
	  924 => 'Passport account not yet verified',
);

%Status = (
	   online         => 'NLN',
	   offline        => 'FLN',
	   appear_offline => 'HDN',
	   idle           => 'IDL',
	   away           => 'AWY',
	   busy           => 'BSY',
	   be_right_back  => 'BRB',
	   on_the_phone   => 'PHN',
	   out_to_lunch   => 'LUN',
);

%Contact_List = (
	   forward_list  => 'FL',
	   reverse_list  => 'RL',
	   allow_list    => 'AL',
	   block_list    => 'BL',
);

%R_Status       = reverse %Status;
%R_Contact_List = reverse %Contact_List;

%LCID = (
	 'Default'                            => 2048,
	 'Afrikaans'                          => 1078,
	 'Albanian'                           => 1052,
	 'Arabic (United Arab Emirates)'      => 14337,
	 'Arabic (Bahrain)'                   => 15361,
	 'Arabic (Algeria)'                   => 5121,
	 'Arabic (Egypt)'                     => 3073,
	 'Arabic (Iraq)'                      => 2049,
	 'Arabic (Jordan)'                    => 11265,
	 'Arabic (Kuwait)'                    => 13313,
	 'Arabic (Lebanon)'                   => 12289,
	 'Arabic (Libya)'                     => 4097,
	 'Arabic (Morocco)'                   => 6145,
	 'Arabic (Oman)'                      => 8193,
	 'Arabic (Qatar)'                     => 16385,
	 'Arabic (Saudi Arabia)'              => 1025,
	 'Arabic (Syria)'                     => 10241,
	 'Arabic (Tunisia)'                   => 7169,
	 'Arabic (Yemen)'                     => 9217,
	 'Armenian'                           => 1067,
	 'Azeri (Latin)'                      => 1068,
	 'Azeri (Cyrillic)'                   => 2092,
	 'Basque'                             => 1069,
	 'Belarusian'                         => 1059,
	 'Bulgarian'                          => 1026,
	 'Catalan'                            => 1027,
	 'Chinese (China)'                    => 2052,
	 'Chinese (Hong Kong SAR)'            => 3076,
	 'Chinese (Macau SAR)'                => 5124,
	 'Chinese (Singapore)'                => 4100,
	 'Chinese (Taiwan)'                   => 1028,
	 'Croatian'                           => 1050,
	 'Czech'                              => 1029,
	 'Danish'                             => 1030,
	 'Dutch (Netherlands)'                => 1043,
	 'Dutch (Belgium)'                    => 2067,
	 'English (Australia)'                => 3081,
	 'English (Belize)'                   => 10249,
	 'English (Canada)'                   => 4105,
	 'English (Caribbean)'                => 9225,
	 'English (Ireland)'                  => 6153,
	 'English (Jamaica)'                  => 8201,
	 'English (New Zealand)'              => 5129,
	 'English (Phillippines)'             => 13321,
	 'English (South Africa)'             => 7177,
	 'English (Trinidad)'                 => 11273,
	 'English (United Kingdom)'           => 2057,
	 'English (United States)'            => 1033,
	 'Estonian'                           => 1061,
	 'Farsi'                              => 1065,
	 'Finnish'                            => 1035,
	 'Faroese'                            => 1080,
	 'French (France)'                    => 1036,
	 'French (Belgium)'                   => 2060,
	 'French (Canada)'                    => 3084,
	 'French (Luxembourg)'                => 5132,
	 'French (Switzerland)'               => 4108,
	 'Gaelic (Ireland)'                   => 2108,
	 'Gaelic (Scotland)'                  => 1084,
	 'German (Germany)'                   => 1031,
	 'German (Austria)'                   => 3079,
	 'German (Liechtenstein)'             => 5127,
	 'German (Luxembourg)'                => 4103,
	 'German (Switzerland)'               => 2055,
	 'Greek'                              => 1032,
	 'Hebrew'                             => 1037,
	 'Hindi'                              => 1081,
	 'Hungarian'                          => 1038,
	 'Icelandic'                          => 1039,
	 'Indonesian'                         => 1057,
	 'Italian (Italy)'                    => 1040,
	 'Italian (Switzerland)'              => 2064,
	 'Japanese'                           => 1041,
	 'Korean'                             => 1042,
	 'Latvian'                            => 1062,
	 'Lithuanian'                         => 1063,
	 'Macedonian'                         => 1071,
	 'Malay (Malaysia)'                   => 1086,
	 'Malay (Brunei)'                     => 2110,
	 'Maltese'                            => 1082,
	 'Marathi'                            => 1102,
	 'Norwegian (Bokmal)'                 => 1044,
	 'Norwegian (Nynorsk)'                => 2068,
	 'Polish'                             => 1045,
	 'Portuguese (Portugal)'              => 2070,
	 'Portuguese (Brazil)'                => 1046,
	 'Raeto-Romance'                      => 1047,
	 'Romanian (Romania)'                 => 1048,
	 'Romanian (Moldova)'                 => 2072,
	 'Russian'                            => 1049,
	 'Russian (Moldova)'                  => 2073,
	 'Sanskrit'                           => 1103,
	 'Serbian (Cyrillic)'                 => 3098,
	 'Serbian (Latin)'                    => 2074,
	 'Setsuana'                           => 1074,
	 'Slovenian'                          => 1060,
	 'Slovak'                             => 1051,
	 'Sorbian'                            => 1070,
	 'Spanish (Spain)'                    => 1034,
	 'Spanish (Argentina)'                => 11274,
	 'Spanish (Bolivia)'                  => 16394,
	 'Spanish (Chile)'                    => 13322,
	 'Spanish (Colombia)'                 => 9226,
	 'Spanish (Costa Rica)'               => 5130,
	 'Spanish (Dominican Republic)'       => 7178,
	 'Spanish (Ecuador)'                  => 12298,
	 'Spanish (Guatemala)'                => 4106,
	 'Spanish (Honduras)'                 => 18442,
	 'Spanish (Mexico)'                   => 2058,
	 'Spanish (Nicaragua)'                => 19466,
	 'Spanish (Panama)'                   => 6154,
	 'Spanish (Peru)'                     => 10250,
	 'Spanish (Puerto Rico)'              => 20490,
	 'Spanish (Paraguay)'                 => 15370,
	 'Spanish (El Salvador)'              => 17418,
	 'Spanish (Uruguay)'                  => 14346,
	 'Spanish (Venezuela)'                => 8202,
	 'Sutu'                               => 1072,
	 'Swahili'                            => 1089,
	 'Swedish (Sweden)'                   => 1053,
	 'Swedish (Finland)'                  => 2077,
	 'Tamil'                              => 1097,
	 'Tatar'                              => 1092,
	 'Thai'                               => 1054,
	 'Turkish'                            => 1055,
	 'Tsonga'                             => 1073,
	 'Ukrainian'                          => 1058,
	 'Urdu'                               => 1056,
	 'Uzbek (Cyrillic)'                   => 2115,
	 'Uzbek (Latin)'                      => 1091,
	 'Vietnamese'                         => 1066,
	 'Xhosa'                              => 1076,
	 'Yiddish'                            => 1085,
	 'Zulu'                               => 1077,
);

%R_LCID = reverse %LCID;


"Net::MsnMessenger::Data";
__END__

