#!/usr/bin/perl -w
#
# An example of MSNre event script that plays sounds for different events
#
# $Id: event_script.pl,v 1.2 2003/06/07 01:23:29 incoming Exp $

use strict;

my $protocol   = shift @ARGV;
my $event_type = shift @ARGV;

if (!defined $protocol || $protocol ne 'MSN' || !defined $event_type)
{
    die "This script is to be called by MSNre\n";
}

if ($event_type eq 'email')
{
    my ($from_addr, $from_name, $subject) = @ARGV;  # E-mail specific arguments
    system('play ~/msn/email.wav > /dev/null');
}

elsif ($event_type eq 'status')
{
    my $new_status = @ARGV;
    if ($new_status eq 'Online')
    {
	system('play ~/msn/online.wav > /dev/null');
    }
    elsif ($new_status eq 'Offline')
    {
	system('play ~/msn/offline.wav > /dev/null');
    }
    elsif ($new_status eq 'Be right back')
    {
	system('play ~/msn/be_right_back.wav > /dev/null');
    }
}

elsif ($event_type eq 'message')
{
    my ($sender, $message) = @ARGV;
    system('play ~/msn/message.wav > /dev/null');
}
exit 0;

__END__

