# $Id: Makefile.PL,v 1.2 2003/06/09 20:13:34 incoming Exp $
#
# Use this file to generate the Makefile:
#
#  perl Makefile.PL
#

use 5.006;
use ExtUtils::MakeMaker;
use strict;

sub MY::postamble
{
    return q[

dist_all :
	debian/rules clean
	$(PERLRUN) Makefile.PL
	@$(MAKE) dist
	@$(MAKE) bz2dist
	debian/rules binary
	debian/rules clean

bz2dist : $(DISTVNAME).tar.bz2

$(DISTVNAME).tar.bz2 : distdir
	$(PREOP)
	$(TO_UNIX)
	$(TAR) $(TARFLAGS) $(DISTVNAME).tar $(DISTVNAME)
	$(RM_RF) $(DISTVNAME)	
	bzip2 -z $(DISTVNAME).tar
	$(POSTOP)
];
}

WriteMakefile(
    NAME         => 'msnre',
    VERSION_FROM => 'bin/msnre',
    EXE_FILES    => [ 'bin/msnre' ],

    ABSTRACT     => 'MSNre - MSN Instant Messenger Clone',
    AUTHOR       => 'incoming <incoming@tiscali.cz>',

    PREREQ_PM    => { POE => '0.19',
		      Curses => '',
		    },

    dist         => { COMPRESS => 'gzip', SUFFIX => 'gz' },
);

