//
// ByteConverter.cs
//
// Author:
//   Jared Hendry (buchan@gmail.com)
//   Alan McGovern (alan.mcgovern@gmail.com)
//
// Copyright (C) 2007 Jared Hendry
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//


using Gtk;
using System;
using System.Diagnostics;

namespace Monsoon
{
	public class AboutDialog : Gtk.AboutDialog
	{
		public AboutDialog() : base()
		{
			Name = Defines.ApplicationName;
			
			try {
				Logo = Gtk.IconTheme.Default.LoadIcon("weather-showers", 64, 0);
			} catch {}

			SetUrlHook(delegate(Gtk.AboutDialog dialog, string link) {
			                Process.Start(link);
			            });			
			Website = "http://monsoon-project.org";
			WebsiteLabel = "Monsoon Project";
			
			Authors = new String[] {
						"Alan McGovern (Library)",
						"Jared Hendry (Interface)",
						"Mirco Bauer (I18N integration)"
			};
			
			Version = Defines.Version;
			this.TranslatorCredits = string.Format("{1}{0}{2}{0}{3}{0}{4}", Environment.NewLine,
			                                       _("Bulgarian - Ventsislav Mladenov"),
			                                       _("Dutch - Freek de Kruijf"),
			                                       _("French - Olivier Dufour"),
			                                       _("German - Mirco Bauer <meebey@meebey.net>"),
			                                       _("Italian - Alberto Passalacqua"),
			                                       _("Spanish - Mario Sopena"));
			                                       
			this.WrapLicense = true;
			License = @"Copyright (C) 2006-2008 Alan McGovern, Jared Hendry

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the ""Software""), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED ""AS IS"", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.";
		}
		
		private static string _(string s)
		{
			return Mono.Unix.Catalog.GetString(s);
		}
	}
}
