/* sunos4.h

   System dependencies for SunOS 4 (tested on 4.1.4)... */

/*
 * Copyright (c) 1995 RadioMail Corporation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of RadioMail Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY RADIOMAIL CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * RADIOMAIL CORPORATION OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software was written for RadioMail Corporation by Ted Lemon
 * under a contract with Vixie Enterprises, and is based on an earlier
 * design by Paul Vixie.
 */

#include <sys/types.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>

/* Time stuff... */
#include <sys/time.h>
#define TIME struct timeval
#define GET_TIME(x)	gettimeofday ((x), (struct timezone *)0)
#define TIME_DIFF_US(low, high) 					\
  (((high) -> tv_sec - (low) -> tv_sec) * 1000000			\
   + ((high) -> tv_usec - (low) -> tv_usec))
#define SET_TIME(x, y)	(((x) -> tv_sec = ((y) / 1000000)),		\
			 ((x) -> tv_usec = ((y) % 1000000)))
#define MSDELAY(ms) really_usleep (ms * 1000)
#define DELAY_ONE_SECOND() really_usleep (1000000)

/* Login stuff... */
#define SETUID(x)	setuid (x)
#define SETGID(x)	(setgroups (0, &x), setgid (x))
#define SETLOGIN(x)
#define	_PATH_LOGIN	"/bin/login"
#define _PATH_DEFPATH	"/usr/ucb:/usr/bin:/bin"
#define PATH_MAX	1024
#define USER_MAX	UT_NAMESIZE

/* Utmp stuff... */
#include <utmp.h>
#include <lastlog.h>
#define _PATH_UTMP      "/etc/utmp"
#define _PATH_WTMP      "/var/adm/wtmp"
#define _PATH_LASTLOG   "/var/adm/lastlog"
#define _PATH_MPOOL_PID	"/etc/mpoold.pid"

#define UT_NAMESIZE     8
#define UT_LINESIZE     8
#define UT_HOSTSIZE     16

/* Terminal I/O stuff... */
#define TTY_STATE	struct termios
#define TTY_OPEN_FLAGS	(O_RDWR | O_NDELAY)
#define TTY_OPEN_MODE	(0600)

#define INIT_TTY_STATE(ts)						\
  ((ts.c_iflag = ISTRIP),						\
   (ts.c_oflag = 0),							\
   (ts.c_cflag = B38400 | (B38400 << IBSHIFT) | CS8 | CREAD | HUPCL),	\
   (ts.c_lflag = PENDIN),						\
   (ts.c_cc [VMIN] = 1),						\
   (ts.c_cc [VTIME] = 2))						\

#define SET_NO_FLOW_CTL(ts)						\
  ((ts.c_iflag &= ~(IXON | IXOFF)),					\
   (ts.c_cflag &= ~CRTSCTS))

#define SET_HW_FLOW_CTL(ts)						\
  (ts.c_cflag |= CRTSCTS)

#define CVT_BAUD(speed)							\
   (speed == 50 ? B50 :							\
    (speed == 75 ? B75 :						\
     (speed == 110 ? B110 :						\
      (speed == 134 ? B134 :						\
       (speed == 150 ? B150 :						\
	(speed == 200 ? B200 :						\
	 (speed == 300 ? B300 :						\
	  (speed == 600 ? B600 :					\
	   (speed == 1200 ? B1200 :					\
	    (speed == 1800 ? B1800 :					\
	     (speed == 2400 ? B2400 :					\
	      (speed == 4800 ? B4800 :					\
	       (speed == 9600 ? B9600 :					\
		(speed == 19200 ? B19200 :				\
		 (speed == 38400 ? B38400 :				\
		  (warn ("%d baud not supported: using 38400", speed),	\
		   B38400))))))))))))))))

#define SET_TX_SPEED(ts, speed)						\
  (ts.c_cflag = (ts.c_cflag & ~CBAUD) |					\
   CVT_BAUD (speed))

#define SET_RX_SPEED(ts, speed)						\
  (ts.c_cflag = (ts.c_cflag & ~CIBAUD) |				\
   (CVT_BAUD (speed) << IBSHIFT))

#define SET_DTR(fd)							\
  { int val = TIOCM_DTR; ioctl (fd, TIOCMBIS, &val); }

#define RESET_DTR(fd)							\
  { int val = TIOCM_DTR; ioctl (fd, TIOCMBIC, &val); }

/* Tty lock stuff... */
#define	_PATH_TTYLOCK	"/var/spool/locks/LCK..%s"

/* Varargs stuff... */
#include <varargs.h>
#define VA_DOTDOTDOT va_alist
#define VA_start(list, last) va_start (list)

#define vsnprintf(buf, size, fmt, list) vsprintf (buf, fmt, list)
