/*======================================================================*\
	Check function valid_cjk with all mapping entries
	of all CJK character code mapping tables.
\*======================================================================*/

#include "charcode.c"


/*======================================================================*\
	Dummies for charcode.c
\*======================================================================*/

/**
   Providing dummy variables for charcode.c
 */
FLAG utf8_text = 0;
FLAG utf16_file = 0;
FLAG utf16_little_endian = 0;
FLAG cjk_text = 0;
FLAG mapped_text = 0;


FLAG
iscombining_unichar (u)
  unsigned long u;
{
  return term_iscombining (u);
}


/*======================================================================*\
	Checking function
\*======================================================================*/

/**
   Return # character codes marked non-valid.
 */
static
unsigned long
check (char tag)
{
	unsigned int i = 0;
	unsigned long cjkchar;
	unsigned long ok = 0;
	unsigned long non = 0;

	(void) set_text_encoding (NIL_PTR, tag, "validcjk");

	struct encoding_table_entry * cjk_table_poi = text_table;
	while (i ++ < text_table_len) {
#ifdef split_map_entries
		cjkchar = decode_cjk (cjk_table_poi, text_table);
#else
		cjkchar = cjk_table_poi->cjk;
#endif
		if (valid_cjk (cjkchar, NIL_PTR)) {
			ok ++;
		} else {
			printf ("%c %04X\n", text_encoding_tag, cjkchar);
			non ++;
		}
		cjk_table_poi ++;
	}
	printf ("%c: valid %d, not valid %d\n", text_encoding_tag, ok, non);
	return non;
}

int
main ()
{
	unsigned long non = 0;
	non += check ('B');
	non += check ('G');
	non += check ('C');
	non += check ('J');
	non += check ('S');
	non += check ('K');
	non += check ('H');

	return non > 0;
}


/*======================================================================*\
	end
\*======================================================================*/
