/* getans.c - get an answer from the user and return a string array */
#ifndef	lint
static char ident[] = "@(#)$Id: getans.c,v 1.8 1992/12/15 00:20:22 jromine Exp $";
#endif	/* lint */

#include "../h/mh.h"
#if defined(BSD42) || defined(SVR4)
#include <setjmp.h>
#endif	/* BSD42 || SVR4 */
#include <signal.h>
#include <stdio.h>


static	char ansbuf[BUFSIZ];
#if !defined(BSD42) && !defined(SVR4)
static	int interrupted;
#else	/* BSD42 || SVR4 */
static	jmp_buf sigenv;
#endif	/* BSD42 || SVR4 */
static TYPESIG	intrser ();

char  **getans (prompt, ansp)
char   *prompt;
struct swit   *ansp;
{
    int    i;
    TYPESIG    (*istat) ();
    char  *cp,
	 **cpp;

#if !defined(BSD42) && !defined(SVR4)
    interrupted = 0;
    istat = signal (SIGINT, intrser);
#else	/* BSD42 || SVR4 */
    switch (setjmp (sigenv)) {
	case OK: 
	    istat = signal (SIGINT, intrser);
	    break;

	default: 
	    (void) signal (SIGINT, istat);
	    return NULL;
    }
#endif	/* BSD42 || SVR4 */
    for (;;) {
	printf ("%s", prompt);
	(void) fflush (stdout);
	cp = ansbuf;
	while ((i = getchar ()) != '\n') {
#if !defined(BSD42) && !defined(SVR4)
	    if (i == EOF || interrupted) {
		interrupted = 0;
		(void) signal (SIGINT, istat);
		return NULL;
	    }
#else	/* BSD42 || SVR4 */
	    if (i == EOF)
		longjmp (sigenv, DONE);
#endif	/* BSD42 || SVR4 */
	    if (cp < &ansbuf[sizeof ansbuf - 1])
		*cp++ = i;
	}
	*cp = 0;
	if (ansbuf[0] == '?' || cp == ansbuf) {
	    printf ("Options are:\n");
	    printsw (ALL, ansp, "");
	    continue;
	}
	cpp = brkstring (ansbuf, " ", NULLCP);
	switch (smatch (*cpp, ansp)) {
	    case AMBIGSW: 
		ambigsw (*cpp, ansp);
		continue;
	    case UNKWNSW: 
		printf (" -%s unknown. Hit <CR> for help.\n", *cpp);
		continue;
	    default: 
		(void) signal (SIGINT, istat);
		return cpp;
	}
    }
}


static	TYPESIG intrser (i)
int	i;
{
#if !defined(BSD42) && !defined(SVR4)
	(void) signal(SIGINT, intrser);
	interrupted = 1;
#else	/* BSD42 || SVR4 */
	longjmp (sigenv, NOTOK);
#endif	/* BSD42 || SVR4 */
}
