/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include "mgl2.h"
#include "draw_engine.h"
#include "event_man.h"

int r_rect = 0;
int r_minx;
int r_maxx;
int r_miny;
int r_maxy;

static struct draw_engine rp_de,*org_de;

extern struct screen *physical_screen;

#ifndef NULL
#define NULL (void *)0
#endif

void inline rec_point(struct screen *s,int x, int y) {
	if (!( (s == physical_screen)
		||( (s->type & ST_SUBSCREEN) && 
		    (s->bitmap == (void *)physical_screen)))) {
		return;
	}
	x += s->off_x;
	y += s->off_y;

	if (!r_rect) {
		r_minx = x;
		r_maxx = x;
		r_miny = y;
		r_maxy = y;
		r_rect = 1;
	} else {
		if (x < r_minx) r_minx = x;
		if (x > r_maxx) r_maxx = x;
		if (y < r_miny) r_miny = y;
		if (y > r_maxy) r_maxy = y;
	}
	return;
}

static void rp_put_pixel(struct screen *s,int x, int y, int col) {
	CLIP_POINT(s,x,y);
	rec_point(s,x,y);
	s->need_clipping --;
	org_de->_put_pixel(s,x,y,col);
	s->need_clipping ++;
}

static void rp_draw_pixel(struct screen *s,int x, int y) {
	CLIP_POINT(s,x,y);
	rec_point(s,x,y);
	s->need_clipping --;
	org_de->_draw_pixel(s,x,y);
	s->need_clipping ++;
}

static void rp_draw_line_vertical(struct screen *s,int x1,int y1,int x2,int y2,struct draw_engine *self) {
	CLIP_VLINE(s,x1,y1,x2,y2);
	rec_point(s,x1,y1);
	rec_point(s,x2,y2);
	s->need_clipping --;
	org_de->_draw_line_vertical(s,x1,y1,x2,y2,org_de);
	s->need_clipping ++;
}


static void rp_draw_line_horizontal(struct screen *s,int x1,int y1,int x2,int y2,struct draw_engine *self) {
	CLIP_HLINE(s,x1,y1,x2,y2);
	rec_point(s,x1,y1);
	rec_point(s,x2,y2);
	s->need_clipping --;
	org_de->_draw_line_horizontal(s,x1,y1,x2,y2,org_de);
	s->need_clipping ++;
}

static void rp_clear_screen(struct screen *s,struct draw_engine *self) {
	rec_point(s,0,0);
	rec_point(s,s->width-1,s->height-1);
	org_de->_clear_screen(s,org_de);
}


static void rp_draw_line(struct screen *s,int x1,int y1,int x2,int y2,struct draw_engine *self) {
	int x = x1;
	int y = y1;
	if (x1 == x2) {
		if (y2 < y1) {
			y1 = y2;
			y2 = y;
		}
		rp_draw_line_vertical(s,x1,y1,x2,y2,self);
	} else if (y1 == y2) {
		if (x2 < x1) {
			x1 = x2;
			x2 = x;
		}
		rp_draw_line_horizontal(s,x1,y1,x2,y2,self);
	} else {
		rec_point(s,x1,y1);
		rec_point(s,x2,y2);
		org_de->_draw_line(s,x1,y1,x2,y2,org_de);
	}
}

static void rp_put_pixstream(struct screen *s,int x,int y,int *buf,int length,int dir,struct draw_engine *self) {
	int x1,y1;
	int x2,y2;

	CLIP_PIXSTREAM(s,x,y,buf,length,dir,x1,y1,x2,y2);
	rec_point(s,x,y);
	switch(dir & 3) {
	default:
	case DIR_NORTH:
		x2 = x + length;
		y2 = y;
		break;
	case DIR_WEST:
		x2 = x;
		y2 = y - length;
		break;
	case DIR_SOUTH:
		x2 = x - length;
		y2 = y;
		break;
	case DIR_EAST:
		x2 = x;
		y2 = y + length;
		break;
	}
	rec_point(s,x,y);
	rec_point(s,x2,y2);
	s->need_clipping --;
	org_de->_put_pixstream(s,x,y,buf,length,dir,org_de);
	s->need_clipping ++;
}

static void rp_bitblt(struct screen *dst, int dx, int dy
	  , struct screen *src, int sx, int sy, int xsize, int ysize
	  , int op, struct draw_engine *self) {
	if (src == NULL) src = current_screen;
	if (dst == NULL) dst = current_screen;
	if ((xsize < 0) || (ysize < 0)) {
		xsize = src->width;
		ysize = src->height;
	}
	CLIP_BITBLT(dst,dx,dy,src,sx,sy,xsize,ysize);
	rec_point(dst,dx,dy);
	rec_point(dst,dx+xsize-1,dy+ysize-1);
	dst->need_clipping --;
	org_de->_bitblt(dst,dx,dy,src,sx,sy,xsize,ysize,op,org_de);
	dst->need_clipping ++;
}

rp_wrap(struct screen *s) {
	struct draw_engine *de = s->de;

	rp_de = *de;
	rp_de._put_pixel = rp_put_pixel;
	rp_de._draw_pixel = rp_draw_pixel;
	rp_de._draw_line = rp_draw_line;
	rp_de._draw_line_vertical = rp_draw_line_vertical;
	rp_de._draw_line_horizontal = rp_draw_line_horizontal;
	rp_de._clear_screen = rp_clear_screen;
	rp_de._put_pixstream = rp_put_pixstream;
	rp_de._bitblt = rp_bitblt;

	org_de = de;
	s->de = &rp_de;
}
