#include <string.h>
#include <sys/types.h>
#include "config.h"

#ifdef USE_LOCAL_MEMSET
void *
mgl_memset(void *dst, int data, size_t bytes) {
	char *dst1=dst;
	int *dst4;
	int bytes4;
	int bytes32;
	int data32;

	while (((int)dst1 & 0x3) && bytes) {
		*dst1++ = data;
		bytes--;
	}
	if (!bytes) return dst;
	dst4 = (int *)dst1;
	bytes4 = (bytes /4);
	bytes32 = (bytes4 /8);
	bytes -= bytes4 * 4;
	bytes4 -= bytes32 * 8;
	data32 = 0x01010101 * (data & 0xff);
	while (bytes32--) {
		dst4[0] = dst4[1] = dst4[2] = dst4[3] = 
		dst4[4] = dst4[5] = dst4[6] = dst4[7] = data32;
		dst4 += 8;
	}
	while (bytes4--) {
		*dst4++ = data32;
	}
	dst1 = (char *)dst4;
	while (bytes--) {
		*dst1++ = data;
	}
	return dst;
}
#endif

#ifdef USE_LOCAL_MEMMOVE
void *
mgl_memmove(void *dst,const void *src, size_t bytes) {
   if (dst > src) {
	char *dst1=(char *)dst+bytes;
	const char *src1=(const char *)src+bytes;

	while (((int)dst1 & 0x3) && bytes) {
		*(--dst1) = *(--src1);
		bytes--;
	}
	if (!bytes) return dst;
	if (!((int)src1 & 0x3)) {
		int bytes4;
		int bytes32;
		int *dst4=(int *)dst1;
		const int *src4=(const int *)src1;

		bytes4 = (bytes /4);
		bytes32 = (bytes4 /8);
		bytes -= bytes4 * 4;
		bytes4 -= bytes32 * 8;
		while (bytes32--) {
			dst4 -= 8;
			src4 -= 8;
			dst4[7] = src4[7];
			dst4[6] = src4[6];
			dst4[5] = src4[5];
			dst4[4] = src4[4];
			dst4[3] = src4[3];
			dst4[2] = src4[2];
			dst4[1] = src4[1];
			dst4[0] = src4[0];
		}
		while (bytes4--) {
			*(--dst4) = *(--src4);
		}
		dst1 = (char *)dst4;
		src1 = (char *)src4;
	}
	while (bytes--) {
		*(--dst1) = *(--src1);
	}
  } else {
	char *dst1=(char *)dst;
	const char *src1=(const char *)src;

	while (((int)dst1 & 0x3) && bytes) {
		*dst1++ = *src1++;
		bytes--;
	}
	if (!bytes) return dst;
	if (!((int)src1 & 0x3)) {
		int bytes4;
		int bytes32;
		int *dst4=(int *)dst1;
		const int *src4=(int *)src1;

		bytes4 = (bytes /4);
		bytes32 = (bytes4 /8);
		bytes -= bytes4 * 4;
		bytes4 -= bytes32 * 8;
		while (bytes32--) {
			dst4[0] = src4[0];
			dst4[1] = src4[1];
			dst4[2] = src4[2];
			dst4[3] = src4[3];
			dst4[4] = src4[4];
			dst4[5] = src4[5];
			dst4[6] = src4[6];
			dst4[7] = src4[7];
			dst4 += 8;
			src4 += 8;
		}
		while (bytes4--) {
			*dst4++ = *src4++;
		}
		dst1 = (char *)dst4;
		src1 = (char *)src4;
	}
	while (bytes--) {
		*dst1++ = *src1++;
	}
   }
   return dst;
}
#endif

void *
mgl_memxor(void *dst, int data, size_t bytes) {
	char *dst1=dst;
	int *dst4;
	int bytes4;
	int bytes32;
	int data32;
	while (((int)dst1 & 0x3) && bytes) {
		*dst1++ ^= data;
		bytes--;
	}
	if (!bytes) return dst;
	dst4 = (int *)dst1;
	bytes4 = (bytes /4);
	bytes32 = (bytes4 /8);
	bytes -= bytes4 * 4;
	bytes4 -= bytes32 * 8;
	data32 = 0x01010101 * (data & 0xff);
	while (bytes32--) {
		dst4[0] ^= data32;
		dst4[1] ^= data32;
		dst4[2] ^= data32;
		dst4[3] ^= data32;
		dst4[4] ^= data32;
		dst4[5] ^= data32;
		dst4[6] ^= data32;
		dst4[7] ^= data32;
		dst4 += 8;
	}
	while (bytes4--) {
		*dst4++ ^= data32;
	}
	dst1 = (char *)dst4;
	while (bytes--) {
		*dst1++ ^= data;
	}
	return dst;
}

void *
mgl_memset2(void *dst, int data, size_t len) {
	short *dst1=dst;
	int *dst4;
	int len4;
	int len32;
	int data32;
	while (((int)dst1 & 0x3) && len) {
		*dst1++ = data;
		len--;
	}
	if (!len) return dst;
	dst4 = (int *)dst1;
	len4 = (len /2);
	len32 = (len4 /8);
	len -= len4 * 2;
	len4 -= len32 * 8;
	data32 = 0x00010001 * (data & 0xffff);
	while (len32--) {
		dst4[0] = data32;
		dst4[1] = data32;
		dst4[2] = data32;
		dst4[3] = data32;
		dst4[4] = data32;
		dst4[5] = data32;
		dst4[6] = data32;
		dst4[7] = data32;
		dst4 += 8;
	}
	while (len4--) {
		*dst4++ = data32;
	}
	dst1 = (short *)dst4;
	while (len--) {
		*dst1++ = data;
	}
	return dst;
}

void *
mgl_memxor2(void *dst, int data, size_t len) {
	short *dst1=dst;
	int *dst4;
	int len4;
	int len32;
	int data32;
	while (((int)dst1 & 0x3) && len) {
		*dst1++ ^= data;
		len--;
	}
	if (!len) return dst;
	dst4 = (int *)dst1;
	len4 = (len /2);
	len32 = (len4 /8);
	len -= len4 * 2;
	len4 -= len32 * 8;
	data32 = 0x00010001 * (data & 0xffff);
	while (len32--) {
		dst4[0] ^= data32;
		dst4[1] ^= data32;
		dst4[2] ^= data32;
		dst4[3] ^= data32;
		dst4[4] ^= data32;
		dst4[5] ^= data32;
		dst4[6] ^= data32;
		dst4[7] ^= data32;
		dst4 += 8;
	}
	while (len4--) {
		*dst4++ ^= data32;
	}
	dst1 = (short *)dst4;
	while (len--) {
		*dst1++ ^= data;
	}
	return dst;
}
