/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


/* #define DEBUG */

#define DATA_OFFSET_X	2000
#define DATA_OFFSET_Y	2000

const static int same_format=0;
#define MD_PUT_SCANSEGMENT(dst_y,dst_x,src,nbytes)

const static int show_mouse=1;
#define TOUCH_DEVICE            "/dev/tpanel"
const char cal_filename[] = "/etc/pointercal";
static int m_fd;
static	int m_x, m_y, m_b;
static	int tz;

static TRANSFORMATION_COEFFICIENTS tc;

static void reset_pointercal() {
	tc.a = 1; tc.b = 0; tc.c = DATA_OFFSET_X;
	tc.d = 0; tc.e = 1; tc.f = DATA_OFFSET_Y;
	tc.s = 1;
	tz = 600;
}

static int load_pointercal()
{

	int n;
	FILE* fp;
	TRANSFORMATION_COEFFICIENTS tcf;
	
	reset_pointercal();

	fp = fopen(cal_filename, "r");
	if ( fp == NULL ) {
	    fprintf(stderr, "Error %d opening %s.\n",
		errno, cal_filename);
	    return -1;
	}

	n = fscanf(fp, "%d %d %d %d %d %d %d %d",
		&tcf.a, &tcf.b, &tcf.c, &tcf.d, &tcf.e, &tcf.f, &tcf.s, &tz);
	if ( (n != 7) && (n != 8) ) {
		fprintf(stderr,"Improperly formatted %s.\n",
				cal_filename);
		fclose(fp);
		reset_pointercal();
		return -1;
	}
#ifdef COMPAT_QTE /* Qt/Embedded compatible ??? -- not tested */
	tc = tcf;
#else /* compatible MicroWindows */
	tc.a    = tcf.a * 2;	/* x 8 -> x 2 */
	tc.b    = tcf.b * 2;	/* x 8 -> x 2 */
	tc.c    = tcf.c / 4;	/* x 1 -> / 4 */
	tc.d    = tcf.d * 2;	/* x 8 -> x 2 */
	tc.e    = tcf.e * 2;	/* x 8 -> x 2 */
	tc.f    = tcf.f / 4;	/* x 1 -> / 4 */
	tc.s    = tcf.s;	/* x 4 -> x 1 */
#endif
	printf("mouse tz = %4d\n", tz);
	fclose(fp);
	return 0;
}

static int save_pointercal()
{

	int n;
	FILE* fp;
	TRANSFORMATION_COEFFICIENTS tcf;
	
#ifdef COMPAT_QTE /* Qt/Embedded compatible ??? -- not tested */
	tcf = tc;
#else /* compatible MicroWindows */
	tcf.a    = tc.a / 2;
	tcf.b    = tc.b / 2;
	tcf.c    = tc.c * 4;
	tcf.d    = tc.d / 2;
	tcf.e    = tc.e / 2;
	tcf.f    = tc.f * 4;
	tcf.s    = tc.s;
#endif
	fp = fopen(cal_filename, "w");
	if ( fp == NULL ) {
	    return -1;
	}

	fprintf(fp, "%d %d %d %d %d %d %d %d",
		tcf.a, tcf.b, tcf.c, tcf.d, tcf.e, tcf.f, tcf.s, tz);
	fclose(fp);
	return 0;
}

#define MD_CALIBRATE_CTRL calibrate_ctrl

static int calibrate_ctrl(int cmd, int *data, int max_data) {
	int n;
	switch (cmd) {
	case MGL_CALIBRATE_GET:
		if (max_data < 10) return -1;

		data[0] = MGL_CT_FORMULA;
		data[1] = 8;
		data[2] = tc.a;
		data[3] = tc.b;
		data[4] = tc.c
			 - DATA_OFFSET_X * data[2] - DATA_OFFSET_Y * data[3];
		data[5] = tc.d;
		data[6] = tc.e;
		data[7] = tc.f
			 - DATA_OFFSET_X * data[5] - DATA_OFFSET_Y + data[6];
		data[8] = tc.s;
		data[9] = tz;
		return 0;
	case MGL_CALIBRATE_SET:
		if ((data[0]) != MGL_CT_FORMULA) return -1;
		n = data[1];
		if ((n != 7) && (n != 8)) return -1;
		tc.a = data[2];
		tc.b = data[3];
		tc.c = data[4]
			 + DATA_OFFSET_X * data[2] + DATA_OFFSET_Y * data[3];
		tc.d = data[5];
		tc.e = data[6];
		tc.f = data[7]
			 + DATA_OFFSET_X * data[5] + DATA_OFFSET_Y + data[6];
		tc.s = data[8];
		if (n == 7) tz = 600;
		else tz = data[9];
		return save_pointercal();
	case MGL_CALIBRATE_RESET:
		reset_pointercal();
		return 0;
	}
}

static int open_touch(void)
{
	struct scanparam s;
	int r;

	m_fd = open(TOUCH_DEVICE, O_NONBLOCK);
	if (m_fd < 0) {
		fprintf(stderr, "Error %d opening %s\n", errno, TOUCH_DEVICE);
		return -1;
	}

	s.interval = 20000;
	s.settletime = 480;
#ifdef DEBUG
	s.interval = 20000 * 5; /* slow down to 10Hz */
#endif

	r = ioctl(m_fd, TPSETSCANPARM, &s);
	if ( r < 0 ) {
	    fprintf(stderr, "Error %d setting scan parameters.\n"
		, errno);
	}

	load_pointercal();
	do_mouse_smooth = 1;
	return 0;
}

static void close_touch(void)
{
	if(m_fd >= 0)
		close(m_fd);
}

static int MD_MOUSE_EVENT(void)
{
    short data[6];
    int data_x,data_y;
    int bytes_read;
    int ox,oy,ob;

    if (m_fd < 0) return 0;
    bytes_read = read(m_fd, data, sizeof(data));
    if (bytes_read != sizeof(data)) {
        return 0;
    }

    if (data[0] & 0x8000) {
	if (data[5] > tz) {
	    ox = m_x;
	    oy = m_y;
	    ob = m_b;
#ifdef COMPAT_QTE /* Qt/Embedded compatible ??? -- not tested */
            data_x = data[3] - data[4];
      	    data_y = data[2] - data[1];
#else /* compatible MicroWindows */
      	    data_x = data[2] - data[1];
            data_y = -(data[3] - data[4]);
#endif
            /* transform */
            m_x = (tc.a * data_x + tc.b * data_y + tc.c) / tc.s ;
            m_y = (tc.d * data_x + tc.e * data_y + tc.f) / tc.s ;
	    m_b = 1;
#ifdef DEBUG
	printf("mouse x = %4d y = %4d (org %d %d)\n",m_x,m_y,data_x,data_y);
#endif
	    return 1;
	} else {
	    return 0;
	}
    } else {
	m_b = 0;
	return 1;
    }
}


/*-------------------------------------------------------------------------------*/
static void MD_SET_MOUSEXY(int xs,int ys) {
	m_x = xs;
	m_y = ys;
}

static inline int MD_MOUSE_X() { return m_x; }
static inline int MD_MOUSE_Y() { return m_y; }

static inline int MD_MOUSE_BUTTON() {
	return m_b;
}
