
#include "mgl2.h"
#include "mglcol.h"

#define MK_MOUSE_DOWN		MK_V1
#define MK_MOUSE_MOVE		MK_V2
#define MK_MOUSE_UP		MK_V3
#define MK_DUMP_SCREEN		'\r'

#ifndef NULL
#define NULL	(void *)0
#endif

#undef MABIKI

main() {
	struct virtual_key *vk;
	int c,oldx,oldy;
	int count=0;
	int color;
	int seq = 1;
	char fname[64];

	open_graph();

	vk = create_virtual_key3(0,0,SCREEN_WIDTH,SCREEN_HEIGHT,
				MK_MOUSE_DOWN,MK_MOUSE_MOVE,MK_MOUSE_UP);
	vk_attach(NULL, vk);

	color = COLOR_BLACK;
	set_color(color);
	while (c = get_key(-1)) {
		if (c == 033) break;
		switch (c) {
		case MK_MOUSE_DOWN:
			switch (mgl_button_shift) {
			case 0: color = COLOR_BLACK;	break;
			case 1: color = COLOR_BLUE;	break;
			case 2: color = COLOR_RED;	break;
			}
			set_color(color);
			draw_rect(vk_x-1,vk_y-1,3,3);
			oldx = vk_x;
			oldy = vk_y;
			break;
		case MK_MOUSE_MOVE:
#ifdef MABIKI
			count++;
			if (count < 5) break;
			count = 0;
#endif
			draw_rect(vk_x-1,vk_y-1,3,3);
			draw_line(oldx,oldy,vk_x,vk_y);
			oldx = vk_x;
			oldy = vk_y;
			break;
		case MK_MOUSE_UP:
			draw_rect(vk_x-1,vk_y-1,3,3);
			break;
		case ' ':
		case MK_UP:
		case MK_DOWN:
			set_color(COLOR_WHITE);
			clear_screen();
			set_color(color);
			break;
		case MK_DUMP_SCREEN:
			sprintf(fname,"dump%03d",seq);
			write_screen_xpm(fname,current_screen);
			//write_screen_mgr(fname,current_screen,STK_GENERIC_192COLOR);
			seq++;
		}
	}
}

