/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999, 2000, 2001
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 *	Shin Takemura (takemura@netbsd.org)
 *	SATO Kazumi (sato@netbsd.org)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/*
 * configuration part
 */
#undef NO_VIRTUAL_CONSOLE	/* Disable wscons screen switch */
#undef USE_SHARE_FB		/* no backing store.
				 *  for 2bpp -- MC-R300, CASSIOPEIA E-55
				 * NEED NO_VIRTUAL_COSOLE.
				 */
#define USE_CMAP8		/* use implicit color map for 8bpp mahines */
#define USE_KEYMAP		/* use internal keymap.
				 * if undefed keymap controled by kernel
				 */
#define USE_SELECT		/* use select() for key/mouse */

/*
 * EDIT ME!, if your kernel varsion too old and not support HPCFBIO_GCONF
 */
#define DEF_ROWBYTE2	256	/* XX MC-R300 */
#define DEF_ROWBYTE8	1024	/* XX MC-R500 */
#define DEF_ROWBYTE16	1600	/* XX MC-R510 */

/*
 * do consistency parameters
 */
#ifndef NO_VIRTUAL_CONSOLE
#undef USE_SHARE_FB	/* need backingstore for switching screen */
#endif /* NO_VIRTUAL_CONSOLE */

#ifndef USE_CMAP8
#define USE_FAKE8		/* fake 2bpp for 8bpp machines */
#endif	/* USE_CMAP */

/* include files */
#include <unistd.h>
#include <sys/param.h>
#include <sys/sysctl.h>
#include <fcntl.h>
#include <dev/wscons/wsconsio.h>
#ifndef NO_VIRTUAL_CONSOLE
#include <dev/wscons/wsdisplay_usl_io.h>
#endif /* NO_VIRTUAL_CONSOLE */
#include <dev/hpc/hpcfbio.h>

/* ե졼Хåե񤭽Ф̥롼*/
#include "fb2.h"
#include "fb4.h"
#include "fb16.h"

/* ޥɽ define  */
static int show_mouse=0;

const static int same_format=0;
#define MD_PUT_SCANSEGMENT(dst_y,dst_x,src,nbytes)

#define MOUSEDEV	"/dev/wsmouse0"
#define FBDEV		getfbdevice()

#define mouse_fd	mgl_mouse_fd
int mouse_fd = -1;
static int m_x = 0;
static int m_y = 0;
static int m_b = 0;
static int m_event = 0;
static int fb_fd = -1;
static int fb_off = 0;
static unsigned char *fb = NULL;
static int rowbytes;
static int realdepth = 0;	/* if depth is faked, original depth */
static char *platform = NULL;

#ifdef USE_CMAP8
static int cindex_table[256];
#endif

static int MD_MOUSE_INIT(int id) {
#ifdef USE_SELECT
    if ((mouse_fd = open(MOUSEDEV, O_RDWR )) < 0)
	return -1;
#else
    if ((mouse_fd = open(MOUSEDEV, O_RDWR | O_NDELAY )) < 0)
	return -1;
#endif
    do_mouse_smooth = 1;
    return 0;
}

static void MD_MOUSE_CLOSE(void) {
    if (mouse_fd == -1)
	return;
    close(mouse_fd);
    mouse_fd = -1;
}

#ifdef USE_SELECT
static int MD_MOUSE_EVENT() {
    struct wscons_event ev[16];
    int i,n,c,d,r;
    fd_set fds;
    struct timeval to;

	if (mouse_fd < 0) return 0;

	c = 0;
retry:
	FD_ZERO(&fds);
	FD_SET(mouse_fd,&fds);
	to.tv_sec = 0;
	to.tv_usec = 0;
	if (select(mouse_fd+1,&fds,0,0,&to) != 1) return c;
	r = read(mouse_fd,ev,sizeof(ev));
	if (r < 0) {
    		close(mouse_fd);
		mouse_fd = -1;
		return 0;
	}
	n = r/sizeof(ev[0]);
//printf("event count = %d \n",n);
	for (i=0; i<n; i++) {
	    switch(ev[i].type) {
		case WSCONS_EVENT_MOUSE_UP:
//printf("MOUSE_UP\n");
			if  (ev[i].value == 0) {
				m_b = 0;
				c++;
			}
			break;
		case WSCONS_EVENT_MOUSE_DOWN:
//printf("MOUSE_DOWN\n");
			if (ev[i].value == 0) {
				m_b = 1;
				c++;
			}
			if (i+1 == n) goto retry;
			break;
		case WSCONS_EVENT_MOUSE_DELTA_X:
			d = ev[i].value;
			m_x += d;
			if (m_x < 0) m_x = 0;
			if (m_x >= SCREEN_WIDTH) m_x = SCREEN_WIDTH - 1;
			c++;
			break;
		case WSCONS_EVENT_MOUSE_DELTA_Y:
			d = ev[i].value;
			m_y += d;
			if (m_y < 0) m_y = 0;
			if (m_y >= SCREEN_HEIGHT) m_y = SCREEN_HEIGHT - 1;
			c++;
			break;
		case WSCONS_EVENT_MOUSE_ABSOLUTE_X:
			m_x = ev[i].value;
//printf("MOUSE_ABSX %d\n",m_x);
			c++;
			break;
		case WSCONS_EVENT_MOUSE_ABSOLUTE_Y:
			m_y = ev[i].value;
//printf("MOUSE_ABSY %d\n",m_y);
			c++;
			break;
	     }
	}
	return c;
}
#else /* NDELAY version */
static int MD_MOUSE_EVENT() {
    struct wscons_event ev[16];
    int i,n,c,d,r;

	if (mouse_fd < 0) return 0;

	r = read(mouse_fd,ev,sizeof(ev));
	if (r < 0) {
    		close(mouse_fd);
		mouse_fd = -1;
		return 0;
	}
	n = r/sizeof(ev[0]);
printf("event count = %d \n",n);
	c = 0;
	for (i=0; i<n; i++) {
	    switch(ev[i].type) {
		case WSCONS_EVENT_MOUSE_UP:
			if  (ev[i].value == 0) {
printf("MOUSE_UP\n");
				m_b = 0;
				c++;
			}
			break;
		case WSCONS_EVENT_MOUSE_DOWN:
			if (ev[i].value == 0) {
printf("MOUSE_DOWN\n");
				m_b = 1;
				c++;
			}
			break;
		case WSCONS_EVENT_MOUSE_DELTA_X:
			d = ev[i].value;
			m_x += d;
			if (m_x < 0) m_x = 0;
			if (m_x >= SCREEN_WIDTH) m_x = SCREEN_WIDTH - 1;
			c++;
			break;
		case WSCONS_EVENT_MOUSE_DELTA_Y:
			d = ev[i].value;
			m_y += d;
			if (m_y < 0) m_y = 0;
			if (m_y >= SCREEN_HEIGHT) m_y = SCREEN_HEIGHT - 1;
			c++;
			break;
		case WSCONS_EVENT_MOUSE_ABSOLUTE_X:
			m_x = ev[i].value;
printf("MOUSE_ABSX %d\n",m_x);
			c++;
			break;
		case WSCONS_EVENT_MOUSE_ABSOLUTE_Y:
			m_y = ev[i].value;
printf("MOUSE_ABSY %d\n",m_y);
			c++;
			break;
	     }
	}
	return c;
}
#endif

#define MD_MOUSE_X()		(m_x)
#define MD_MOUSE_Y()		(m_y)
#define MD_MOUSE_BUTTON()	(m_b)
#define MD_SET_MOUSEXY(x,y)	do { m_x = x; m_y = y; } while (0)

/* եå⡼ɤˤ */
MD_GRAPH_MODE() {
	int dispmode;

	dispmode = WSDISPLAYIO_MODE_MAPPED;
	if (ioctl(fb_fd, WSDISPLAYIO_SMODE, &dispmode) < 0) {
		perror("ioctl(WSDISPLAYIO_SMODE) WSDISPLAYIO_MODE_EMUL");
	}
}

/* ƥȥ⡼ɤˤ */
MD_TEXT_MODE() {
	int dispmode;

	dispmode = WSDISPLAYIO_MODE_EMUL;
	if (ioctl(fb_fd, WSDISPLAYIO_SMODE, &dispmode) < 0) {
		perror("ioctl(WSDISPLAYIO_SMODE) WSDISPLAYIO_MODE_EMUL");
	}
}

/*
 * get platform from environment or kernel HW_MODEL
 */
char *getplatform()
{
	char *ep,*cp;
	int mib[2];
	size_t len;

	platform = NULL;
	if ((ep = getenv("PLATFORM")) == NULL) {
		mib[0] = CTL_HW;
		mib[1] = HW_MODEL;
		sysctl(mib, 2, NULL, &len, NULL, 0);
		if ((cp = malloc(len)) != NULL) {
			sysctl(mib, 2, cp, &len, NULL, 0);
			while (*cp && *cp != ' ')	/* skip vender name */
				cp++;
			if (*cp) {
				cp++;
				platform = cp;
			}
		}
	} else {
		platform = ep;
	}
	printf("md_hpcmips getplatform: platform = %s \n", platform);
}

/*
 * frame buffer database for w/o HPCFBIO_GCONF kernel.
 */

struct _platinfo {
	int depth;
	int rowbyte;
	int off;
	char name[20];
} platinfo[] = {
	{ 2, 80, 0,  "FreeStyle" },
	{ 2, 160, 0,  "MC-R32" },
	{ 2, 256, 0,  "MC-R3" },
	{ 2, 256, 0,  "MC-CS" },
	{ 2, 256, 0,  "MobileGearII for Do" },
	{ 2, 256, 0,  "Cassiopeia E55" },
	{ 2, 256, 0,  "Cassiopeia for DoCo" },
	{ 2, 256, 0,  "E-55" },
	{ 8, 1024, 0,  "MC-R500" },
	{ 8, 1024, 0,  "MC-R510" },
	{ 8, 640, 0,  "INTERTOP" },
	{ 16, 1280, 0, "sigmarion" }, 
	{ 16, 1280, 256, "MC-R530" }, 
	{ 16, 1280, 256, "MC-R430" }, 
	{ 16, 1600, 0, "MC-R5" }, 
	{ 16, 1600, 1536, "MC-R730" }, 
	{ 16, 1600, 0, "MC-R700" }, 
	{ 16, 512, 0,  "Cassiopeia E100" },
	{ 16, 512, 0,  "E-100" },
	{ 16, 512, 0,  "Cassiopeia E500" },
	{ 16, 512, 0,  "E-500" },
	{ 16, 1280, 0,  "WorkPad" },
	{ 16, 1280, 0,  "z50" },
	{ 0, 0, 0, 0 }
};

static struct _platinfo *
platmatch(char *name, int depth)
{
	struct _platinfo *p;

	p = &platinfo[0];
	while (p->depth) {
		if (p->depth == depth 
		&& strncmp(name, p->name, strlen(p->name)) == 0) {
			return p;
		}
		p++;
	}
	return NULL;
}

/*
 * set framebuffer infomation from hpcfb_fbconf.
 */
static int 
fbsetinfo_hpcfb(struct hpcfb_fbconf *fbconf)
{
	int fbsize = 0;

	printf("fbsetinfo_hpcfb: %dx%d (%dbytes/line) %dbit offset=0x%08lx\n",
		fbconf->hf_width,
		fbconf->hf_height,
		fbconf->hf_bytes_per_line,
		fbconf->hf_pixel_width,
		fbconf->hf_offset);

	SCREEN_WIDTH = fbconf->hf_width;
	SCREEN_HEIGHT = fbconf->hf_height;

	switch (fbconf->hf_pixel_width) {
	case 2:
		realdepth = depth = fbconf->hf_pixel_width;
		rowbytes = fbconf->hf_bytes_per_line;
		break;
	case 8:
		realdepth = fbconf->hf_pixel_width;
#if defined(USE_CMAP8) || defined(USE_FAKE8)
		depth = 8;		/* XXX */
#else
		depth = 2;		/* XXX */
#endif
		rowbytes =fbconf->hf_bytes_per_line;
		break;
	case 16:
		depth = fbconf->hf_pixel_width;
		realdepth = depth;
		rowbytes = fbconf->hf_bytes_per_line;
		break;
	default:
		MD_TEXT_MODE();
		printf("hpcmips fbsetinfo_hpcfb: unknown depth %d\n", fbconf->hf_bytes_per_line);			return -1;
		break;
	}

	fb_off = fbconf->hf_offset;

	printf("display: %dx%dx%d\n",
		fbconf->hf_width,
		fbconf->hf_height,
		fbconf->hf_pixel_width);

	fbsize = rowbytes * fbconf->hf_height;

	printf("fbsize: %d off:0x%08lx rowbytes:%d\n", fbsize, fb_off, rowbytes);

	if (fb_off)
		fbsize += fb_off;
	return fbsize;
}

/*
 * set framebuffer infomation from PLATFORM string and wsdisplay_fbinfo
 */
static int 
fbsetinfo(struct wsdisplay_fbinfo *fbinfo)
{
	int fbsize = 0;
	struct _platinfo *p;

	SCREEN_WIDTH = fbinfo->width;
	SCREEN_HEIGHT = fbinfo->height;

	switch (fbinfo->depth) {
	case 2:
		realdepth = depth = fbinfo->depth;
		rowbytes = DEF_ROWBYTE2;
		break;
	case 8:
		realdepth = fbinfo->depth;
#if defined(USE_CMAP8) || defined(USE_FAKE8)
		depth = 8;		/* XXX */
#else
		depth = 2;		/* XXX */
#endif
		rowbytes = DEF_ROWBYTE8;
		break;
	case 16:
		depth = fbinfo->depth;
		realdepth = depth;
		rowbytes = DEF_ROWBYTE16;
		break;
	default:
		MD_TEXT_MODE();
		printf("hpcmips fbsetinfo: unknown depth %d\n", fbinfo->depth);			return -1;
		break;
	}

	if (platform == NULL) {
		printf("hpcmips fbsetinfo: PLATFORM is not set; use default\n");
	} else if ((p = platmatch(platform, fbinfo->depth)) == NULL) {
		printf("hpcmips fbsetinfo: unknown platform %s\n", platform);
		return -1;
	} else {
		rowbytes = p->rowbyte;
		fb_off = p->off;
	}
	printf("display: %dx%dx%d\n",
	       fbinfo->width,
	       fbinfo->height,
	       fbinfo->depth);

	fbsize = rowbytes * fbinfo->height;

	printf("fbsize: %d off:0x%08lx rowbytes:%d\n", fbsize, fb_off, rowbytes);

	if (fb_off)
		fbsize += fb_off;
	return fbsize;
}

/*
 * get fbdevice name
 */
char *getfbdevice()
{
	static char name[64];
	static char ttyE0[] = "/dev/ttyE0";
	char *p;
	int fd;

	if (isatty(2))
		fd = 2;
	else if (isatty(0))
		fd = 0;
	else if (isatty(1))
		fd = 1;
	else 
		return ttyE0;

	if ((p = ttyname(fd)) == NULL)
		return ttyE0;
	else if (strncmp(p, ttyE0, strlen(ttyE0)-1) == 0) {
			strcpy(name, p);
			return name;
	}
	return ttyE0;
}

#ifdef USE_CMAP8
static inline int
power2(int n)
{
	return n * n;
}

static void
setup_color_table()
{
	struct wsdisplay_cmap cmap;
	u_char red[256], green[256], blue[256];
	int i, j;
	int r, g, b;
	int index;
	int delta, odelta;

	cmap.index = 0;
	cmap.count = 256;
	cmap.red = red;
	cmap.green = green;
	cmap.blue = blue;
	if(ioctl(fb_fd, WSDISPLAYIO_GETCMAP, &cmap) < 0) {
		perror("GETCMAP");
		for(i = 0; i < 256; i++)
			cindex_table[i] = i;
		return;
	}

	for(i = 0; i < 192; i++) {
		unpackRGB(mc_to_rgb(CONV_FROM_COL192(i)), r, g, b);
		r <<= 4;  g <<= 4;  b <<= 4;
		odelta = 65536;
		index = 0;
		for(j = 0; j < 256; j++) {
			delta = (power2(red[j]   - r)  + 
				 power2(green[j] - g)  + 
				 power2(blue[j]  - b)) / 3;

			if(delta < odelta) {
				odelta = delta;
				index = j;
				if(delta == 0)
					break;
			}
		}
		cindex_table[i] = index;
	}
}
#endif  /*  USE_CMAP8  */

static unsigned char fake8_color_table[256] = {
  0, 18,247,255,  0,  1, 69,118,  0,  1, 32,227,  0,  1, 32,249,
  0, 18,247,255,  0, 30, 75,154,  0, 30, 36, 83,  0, 30, 36, 44,
  0, 18,247,255,  0,  3, 81,160,  0,  3, 48,229,  0,  3, 48,251,
  0, 18,247,255,  0, 33, 80,159,  0, 33, 46, 93,  0, 33, 46, 59,
  0, 18,247,255,  0,  2, 79,158,  0,  2, 45,228,  0,  2, 45,250,
  0, 18,247,255,  0, 33,113,193,  0, 33, 78,156,  0, 33, 78,123,
  0, 18,247,255,  0,  6,115,226,  0,  6,114,232,  0,  6,114,254,
  0, 18,247,255,  0, 60,139,220,  0, 60,133,212,  0, 60,133,205,
  0, 18,247,255,  0,  4,134,214,  0,  4, 95,230,  0,  4, 95,252,
  0, 18,247,255,  0, 60,135,215,  0, 60, 95,202,  0, 60, 95,198,
  0, 18,247,255,  0,  5,136,216,  0,  5,131,231,  0,  5,131,253,
  0, 18,247,255,  0, 30,104,183,  0, 30, 63,137,  0, 30, 63,100,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static int calibrate_ctrl(int cmd,int *data,int max_data) {
	int sample_cnt;
	int h;
	struct textscreen *ts;
	struct virtual_key *v;
	struct wsmouse_calibcoords calib_data;
	extern int mouse_fd;
	int i,ret;

	switch(cmd) {
	case MGL_CALIBRATE_GET:
		ret = ioctl(mouse_fd,WSMOUSEIO_GCALIBCOORDS,&calib_data);
		if ((ret < 0) && ( max_data < calib_data.samplelen*4 + 2)) {
			return -1;
		}
		*data++ = MGL_CT_SAMPLE;
		*data++ = calib_data.samplelen;
		for (i=0; i< calib_data.samplelen; i++) {
			*data++ = calib_data.samples[i].x;
			*data++ = calib_data.samples[i].y;
			*data++ = calib_data.samples[i].rawx;
			*data++ = calib_data.samples[i].rawy;
		}
		return 0;
	case MGL_CALIBRATE_SET:
		if ((*data ++) != MGL_CT_SAMPLE) return -1;
		memset(&calib_data,0,sizeof(calib_data));
		calib_data.minx = 0;
		calib_data.miny = 0;
		calib_data.maxx = SCREEN_WIDTH;
		calib_data.maxy = SCREEN_HEIGHT;
		calib_data.samplelen = *data++;
		for (i=0; i< calib_data.samplelen; i++) {
			calib_data.samples[i].x =    *data++;
			calib_data.samples[i].y =    *data++;
			calib_data.samples[i].rawx = *data++;
			calib_data.samples[i].rawy = *data++;
		}
		ret = ioctl(mouse_fd,WSMOUSEIO_SCALIBCOORDS,&calib_data);
		return ret;
	case MGL_CALIBRATE_RESET:
		memset(&calib_data,0,sizeof(calib_data));
		calib_data.minx = 0;
		calib_data.miny = 0;
		calib_data.maxx = SCREEN_WIDTH;
		calib_data.maxy = SCREEN_HEIGHT;
		calib_data.samplelen = WSMOUSE_CALIBCOORDS_RESET;
		ret = ioctl(mouse_fd,WSMOUSEIO_SCALIBCOORDS,&calib_data);
		return ret;
	}
}

/*



 0:  1: 顼 

ꤹ٤
   depth 2,8,16
   rotated žɽξ 1
      ȿФɽƤޤä emcons.c  2 򥵥ݡ
*/
MD_INIT() {
	int fbsize, dispmode;
	struct wsdisplay_fbinfo fbinfo;
	struct wskbd_keyrepeat_data rd;
	struct hpcfb_fbconf hpcfbconf;

	printf("md_hpcmips init\n");

	(void)getplatform();

	if (MD_MOUSE_INIT(0) < 0) return -1;
	printf("md_hpcmips init mouse\n");
	mgl_add_atfork_func(MD_MOUSE_CLOSE,0);

	if ((fb_fd = open(FBDEV, O_RDWR)) < 0) {
		perror(FBDEV);
		return (-1);
	}
	if (mgl_keyboard_reopen) {
		mgl_keyboard_fd = fb_fd;
	}
	printf("md_hpcmips init open %s\n", FBDEV);

	if (ioctl(fb_fd, WSKBDIO_GETKEYREPEAT,&rd) == 0) {
		repeat_tick1 = rd.del1;
		repeat_tick  = rd.delN;
	}
	
	strncpy(keymap_postfix, platform, 64);
	keymap_postfix[64] = 0;

	hpcfbconf.hf_conf_index = HPCFB_CURRENT_CONFIG;
	if (ioctl(fb_fd, HPCFBIO_GCONF, &hpcfbconf) == 0) {
		printf("md_hpcmips init HPCFBIO_GCONF\n");
		fbsize = fbsetinfo_hpcfb(&hpcfbconf);
	} else {
		printf("md_hpcmips init HPCFBIO_GCONF HPCFB_CURRENT_CONFIG fail\n");
		if (ioctl(fb_fd, WSDISPLAYIO_GINFO, &fbinfo) < 0) {
			perror("ioctl(WSDISPLAYIO_GINFO)");
			return (-1);
		}
		printf("md_hpcmips init GINFO\n");

		fbsize = fbsetinfo(&fbinfo);
	}

	dispmode = WSDISPLAYIO_MODE_MAPPED;
	if (ioctl(fb_fd, WSDISPLAYIO_SMODE, &dispmode) < 0) {
		perror("ioctl(WSDISPLAYIO_SMODE) WSDISPLAYIO_MODE_MAPPED");
		return (-1);
	}

	printf("md_hpcmips init MODE\n");
	fb = mmap(NULL, fbsize, PROT_READ | PROT_WRITE, MAP_SHARED, fb_fd, 0);
	if (fb == MAP_FAILED) {
		MD_TEXT_MODE();
		perror("mmap()");
		return (-1);
	}
	fb += fb_off;

	printf("md_hpcmips init mmap: fb=%08x, fb_off=%08lx\n", fb, fb_off);

#if 0
	color_table_test();
#endif

#ifdef USE_CMAP8
	if(depth == 8 && realdepth == 8)
		setup_color_table();
#endif

	if (depth == 16)
		fb16_setup(fb, rowbytes, ORD_R5G6B5);

	if (depth == 2 && realdepth == 2) {
#ifdef USE_SHARE_FB
		if (_create_memscreen[STK_MD_BASE]) {
printf("using share_fb accel\n");
			share_fb = 1;
			mgl_screen_addr = fb - fb_off;
			mgl_screen_offset = fb_off;
			mgl_screen_bpp = 2; 
			mgl_screen_realwidth = rowbytes * 4;
			strcpy(mgl_screen_name, FBDEV);
			mgl_screen_realtype = STK_MD_BASE;
			mgl_screen_type = STK_GENERIC_4COLOR;
			_create_memscreen[STK_NATIVE] =
				_create_memscreen[mgl_screen_realtype];
		} else {
			fb2_setup(fb, rowbytes, ORD2_REVERSE, COL2_NORMAL);
		}
#else
		fb2_setup(fb, rowbytes, ORD2_REVERSE, COL2_NORMAL);
#endif
	}

	mgl_calibrate_ctrl = calibrate_ctrl;
	return 0;
}

static
color_table_test()
{
	int sx = SCREEN_WIDTH/16;
	int sy = SCREEN_HEIGHT/16;
	int x, y, z, c;
	unsigned char *p;
	c = 0;

	for (x = 0; x < 16; x++) {
		for (y = 0; y < 16; y++) {
			for (z = 0; z < sy; z++) {
				p = fb + (y * sy + z) * rowbytes + (x * sx);
				memset(p, c, sx);
			}
			c++;
		}
	}
}


/* λ */
static void MD_TERM() {
	int dispmode;

	MD_MOUSE_CLOSE();

	dispmode = WSDISPLAYIO_MODE_EMUL;
	if (ioctl(fb_fd, WSDISPLAYIO_SMODE, &dispmode) < 0) {
		perror("ioctl(WSDISPLAYIO_SMODE) WSDISPLAYIO_MODE_EMUL");
	}
}

/* ե졼Хåե񤭽Ф */
static void
MD_PUT_PIXSTREAM2(int x,int y,int *buf,int xs,int dir,int op)
{
	if (depth == 2) {
		if (realdepth == 2)
			fb2_put_pixstream(x, y, buf, xs, dir, op);
		else if (realdepth == 8) {
			unsigned char *p;
			static color_table[] = { 0, 18, 247, 255 };	/* XXX, MC-R500 only */
			p = fb + y * rowbytes + x;
			while (0 < xs--) {
				*p++ = color_table[*buf++ & 0x3];
			}
		} else if (realdepth == 16) {
			unsigned short *p;
			static unsigned short color_table[] = { 0, 0x1ce7, 0x5EF7, 0x7fff };

			p = (unsigned short *)(fb + y * rowbytes + x);
			while (0 < xs--) {
				*p++ = color_table[*buf++ & 0x3];
			}
		}
	} else {
		MD_TEXT_MODE();
		printf("hpcmips md_put_pixstream2: unsupported depth %d\n", depth);
		return;
	}
}

static void
MD_PUT_PIXSTREAM8(int x,int y,int *buf,int xs,int dir,int op)
{
	if (depth == 8) {
		if (realdepth == 8) {
			unsigned char *p;

			p = fb + y * rowbytes + x;
			while (0 < xs--) {
#ifndef USE_CMAP8
				*p++ = fake8_color_table[CONV_TO_COL192(*buf)];
#else
				*p++ = cindex_table[CONV_TO_COL192(*buf)];
#endif
				buf++;
			}
		} else if (realdepth == 16) {
			unsigned short *p;
			int cc,r,g,b;

			p = (unsigned short *)(fb + y * rowbytes + x);
			while (0 < xs--) {
				cc = *buf++;
				cc = mc_to_rgb(cc);
				unpackRGB(cc, r, g, b);
				*p++ = ((r<<11)|(g<<6)|(b<<1));
			}
		}
	} else {
		MD_TEXT_MODE();
		printf("hpcmips md_put_pixstream8: unsupported depth %d\n", depth);
		return;
	}
}

static void
MD_PUT_PIXSTREAM16(int x,int y,int *buf,int xs,int dir,int op)
{
	fb16_put_pixstream(x, y, buf, xs, dir, op);
}


static void
MD_PUT_PIXSTREAM4(int x,int y,int *buf,int xs,int dir,int op)
{
//	fb4_put_pixstream(x, y, buf, xs, dir, op);
}

/* virtual console */

#ifdef NO_VIRTUAL_CONSOLE
#undef MD_PROC_COMSOLE
#else
#define MD_PROC_CONSOLE md_proc_console

static int md_proc_console(int key){
	static struct vt_stat vt_status;

	if (MKE_CONSOLE <= key)
		key -= MKE_CONSOLE;
	if (key == 0)
		return 0;	/* try to change myself */
	if (key < 1 || 10 < key)
		return -1;

	if (ioctl(mgl_keyboard_fd, VT_GETSTATE, &vt_status) < 0)
		return -1;

	if (key == vt_status.v_active)
		return 0;	/* try to change myself */

	fprintf(stderr, "change console from %d to %d in 0x%04x\r\n",
		vt_status.v_active, key, vt_status.v_state);

	if (vt_status.v_state & (1 << key)){
		if (ioctl(mgl_keyboard_fd, VT_ACTIVATE, key) < 0){
			return -1;
		}
		// ioctl(mgl_keyboard_fd, VT_WAITACTIVE, vt_status.v_active);
	}
	return 0;
}
#endif


/*----------------------------------------------------------------------*/
/* LCD control */

#ifdef WSDISPLAYIO_PARAM_BACKLIGHT
#define MD_PROC_BACKLIGHT md_proc_backlight
static int md_proc_backlight(int key) {
	struct wsdisplay_param param;
	static int savedbacklight = -1;

	/*
	 * try LCD backlight minimum for LCD
	 * which can't show screen without backlight
	 */
	param.param = WSDISPLAYIO_PARAM_BRIGHTNESS;
	if (ioctl(fb_fd, WSDISPLAYIO_GETPARAM, &param) >= 0) {
		if (ioctl(fb_fd, WSDISPLAYIO_GETPARAM, &param) < 0)
			return -1;
		if (param.curval == param.min) {
			/* try LCD backlight bightness saved value */
			if (savedbacklight == -1) {
				param.curval = param.max;
				savedbacklight = param.max;
			} else {
				param.curval = savedbacklight;
			}
		} else {
			/* try backlight brightness min */
			savedbacklight = param.curval;
			param.curval = param.min;
		}
		(void)ioctl(fb_fd, WSDISPLAYIO_SETPARAM, &param);
		return 0;
	} else {
		param.param = WSDISPLAYIO_PARAM_BACKLIGHT;
		if (ioctl(fb_fd, WSDISPLAYIO_GETPARAM, &param) < 0)
			return -1;
		if (param.curval == param.min) {
			/* try LCD backlight saved value */
			if (savedbacklight == -1) {
				param.curval = param.max;
				savedbacklight = param.max;
			} else {
				param.curval = savedbacklight;
			}
		} else {
			/* try backlight off */
			savedbacklight = param.curval;
			param.curval = param.min;
		}
		(void)ioctl(fb_fd, WSDISPLAYIO_SETPARAM, &param);
	}
	return 0;
}
#endif

#ifdef WSDISPLAYIO_PARAM_CONTRAST
#define MD_PROC_CONTRAST md_proc_contrast
static int md_proc_contrast(int key) {
	struct wsdisplay_param param;

	param.param = WSDISPLAYIO_PARAM_CONTRAST;
	if (ioctl(fb_fd, WSDISPLAYIO_GETPARAM, &param) < 0)
		return -1;
	if (key == MKE_CONTRAST_DOWN) {
		param.curval--;
		if (param.curval < param.min)
			param.curval = param.min;
	} else if (key == MKE_CONTRAST_UP) {
		param.curval++;
		if (param.curval > param.max)
			param.curval = param.max;
	}
	if (ioctl(fb_fd, WSDISPLAYIO_SETPARAM, &param) < 0)
		return -1;
	return 0;
}
#endif

#ifdef WSDISPLAYIO_PARAM_BRIGHTNESS
#define MD_PROC_BRIGHTNESS md_proc_brightness
static int md_proc_brightness(int key) {
	struct wsdisplay_param param;

	param.param = WSDISPLAYIO_PARAM_BRIGHTNESS;
	if (ioctl(fb_fd, WSDISPLAYIO_GETPARAM, &param) < 0)
		return -1;
	if (key == MKE_BRIGHTNESS_DOWN) {
		param.curval--;
		if (param.curval < param.min)
			param.curval = param.min;
	} else if (key == MKE_BRIGHTNESS_UP) {
		param.curval++;
		if (param.curval > param.max)
			param.curval = param.max;
	}
	if (ioctl(fb_fd, WSDISPLAYIO_SETPARAM, &param) < 0)
		return -1;
	return 0;
}
#endif

static void md_mouse_release() {
	MD_MOUSE_CLOSE();
printf("md_mouse_release: %d\n",mouse_fd);
}
#define MD_MOUSE_RELEASE md_mouse_release

static void md_mouse_catch() {
	if (MD_MOUSE_INIT(0) < 0) {
		printf("warning: md_mouse_catch fail\n");
	}
printf("md_mouse_catch: %d\n",mouse_fd);
}
#define MD_MOUSE_CATCH md_mouse_catch

