<?php
/**
 * This defines autoloading handler for whole MediaWiki framework
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 */

/**
 * Locations of core classes
 * Extension classes are specified with $wgAutoloadClasses
 * This array is a global instead of a static member of AutoLoader to work around a bug in APC
 */
global $wgAutoloadLocalClasses;

$wgAutoloadLocalClasses = array(
	# Includes
	'Action' => 'includes/Action.php',
	'AjaxDispatcher' => 'includes/AjaxDispatcher.php',
	'AjaxResponse' => 'includes/AjaxResponse.php',
	'AlphabeticPager' => 'includes/Pager.php',
	'ArrayUtils' => 'includes/ArrayUtils.php',
	'Article' => 'includes/Article.php',
	'AtomFeed' => 'includes/Feed.php',
	'AuthPlugin' => 'includes/AuthPlugin.php',
	'AuthPluginUser' => 'includes/AuthPlugin.php',
	'Autopromote' => 'includes/Autopromote.php',
	'BadTitleError' => 'includes/Exception.php',
	'BaseTemplate' => 'includes/SkinTemplate.php',
	'Block' => 'includes/Block.php',
	'CacheHelper' => 'includes/CacheHelper.php',
	'Category' => 'includes/Category.php',
	'Categoryfinder' => 'includes/Categoryfinder.php',
	'CategoryPage' => 'includes/CategoryPage.php',
	'CategoryViewer' => 'includes/CategoryViewer.php',
	'CdbFunctions' => 'includes/Cdb_PHP.php',
	'CdbReader' => 'includes/Cdb.php',
	'CdbReader_DBA' => 'includes/Cdb.php',
	'CdbReader_PHP' => 'includes/Cdb_PHP.php',
	'CdbWriter' => 'includes/Cdb.php',
	'CdbWriter_DBA' => 'includes/Cdb.php',
	'CdbWriter_PHP' => 'includes/Cdb_PHP.php',
	'ChangesFeed' => 'includes/ChangesFeed.php',
	'ChangeTags' => 'includes/ChangeTags.php',
	'ChannelFeed' => 'includes/Feed.php',
	'Collation' => 'includes/Collation.php',
	'ConcatenatedGzipHistoryBlob' => 'includes/HistoryBlob.php',
	'ConfEditor' => 'includes/ConfEditor.php',
	'ConfEditorParseError' => 'includes/ConfEditor.php',
	'ConfEditorToken' => 'includes/ConfEditor.php',
	'Cookie' => 'includes/Cookie.php',
	'CookieJar' => 'includes/Cookie.php',
	'CurlHttpRequest' => 'includes/HttpFunctions.php',
	'DeferrableUpdate' => 'includes/DeferredUpdates.php',
	'DeferredUpdates' => 'includes/DeferredUpdates.php',
	'MWCallableUpdate' => 'includes/CallableUpdate.php',
	'DeprecatedGlobal' => 'includes/DeprecatedGlobal.php',
	'DerivativeRequest' => 'includes/WebRequest.php',
	'DiffHistoryBlob' => 'includes/HistoryBlob.php',
	'DoubleReplacer' => 'includes/StringUtils.php',
	'DummyLinker' => 'includes/Linker.php',
	'Dump7ZipOutput' => 'includes/Export.php',
	'DumpBZip2Output' => 'includes/Export.php',
	'DumpFileOutput' => 'includes/Export.php',
	'DumpFilter' => 'includes/Export.php',
	'DumpGZipOutput' => 'includes/Export.php',
	'DumpLatestFilter' => 'includes/Export.php',
	'DumpMultiWriter' => 'includes/Export.php',
	'DumpNamespaceFilter' => 'includes/Export.php',
	'DumpNotalkFilter' => 'includes/Export.php',
	'DumpOutput' => 'includes/Export.php',
	'DumpPipeOutput' => 'includes/Export.php',
	'EditPage' => 'includes/EditPage.php',
	'EmailNotification' => 'includes/UserMailer.php',
	'ErrorPageError' => 'includes/Exception.php',
	'ExplodeIterator' => 'includes/StringUtils.php',
	'FakeTitle' => 'includes/FakeTitle.php',
	'Fallback' => 'includes/Fallback.php',
	'FatalError' => 'includes/Exception.php',
	'FauxRequest' => 'includes/WebRequest.php',
	'FauxResponse' => 'includes/WebResponse.php',
	'FeedItem' => 'includes/Feed.php',
	'FeedUtils' => 'includes/FeedUtils.php',
	'FileDeleteForm' => 'includes/FileDeleteForm.php',
	'ForkController' => 'includes/ForkController.php',
	'FormlessAction' => 'includes/Action.php',
	'FormAction' => 'includes/Action.php',
	'FormOptions' => 'includes/FormOptions.php',
	'FormSpecialPage' => 'includes/SpecialPage.php',
	'GitInfo' => 'includes/GitInfo.php',
	'HashRing' => 'includes/HashRing.php',
	'HashtableReplacer' => 'includes/StringUtils.php',
	'HistoryBlob' => 'includes/HistoryBlob.php',
	'HistoryBlobCurStub' => 'includes/HistoryBlob.php',
	'HistoryBlobStub' => 'includes/HistoryBlob.php',
	'Hooks' => 'includes/Hooks.php',
	'Html' => 'includes/Html.php',
	'HtmlFormatter' => 'includes/HtmlFormatter.php',
	'HTMLApiField' => 'includes/HTMLForm.php',
	'HTMLButtonField' => 'includes/HTMLForm.php',
	'HTMLCheckField' => 'includes/HTMLForm.php',
	'HTMLCheckMatrix' => 'includes/HTMLForm.php',
	'HTMLEditTools' => 'includes/HTMLForm.php',
	'HTMLFloatField' => 'includes/HTMLForm.php',
	'HTMLForm' => 'includes/HTMLForm.php',
	'HTMLFormField' => 'includes/HTMLForm.php',
	'HTMLFormFieldRequiredOptionsException' => 'includes/HTMLForm.php',
	'HTMLHiddenField' => 'includes/HTMLForm.php',
	'HTMLInfoField' => 'includes/HTMLForm.php',
	'HTMLIntField' => 'includes/HTMLForm.php',
	'HTMLNestedFilterable' => 'includes/HTMLForm.php',
	'HTMLMultiSelectField' => 'includes/HTMLForm.php',
	'HTMLRadioField' => 'includes/HTMLForm.php',
	'HTMLSelectAndOtherField' => 'includes/HTMLForm.php',
	'HTMLSelectField' => 'includes/HTMLForm.php',
	'HTMLSelectOrOtherField' => 'includes/HTMLForm.php',
	'HTMLSubmitField' => 'includes/HTMLForm.php',
	'HTMLTextAreaField' => 'includes/HTMLForm.php',
	'HTMLTextField' => 'includes/HTMLForm.php',
	'Http' => 'includes/HttpFunctions.php',
	'HttpError' => 'includes/Exception.php',
	'ICacheHelper' => 'includes/CacheHelper.php',
	'IcuCollation' => 'includes/Collation.php',
	'IdentityCollation' => 'includes/Collation.php',
	'ImageHistoryList' => 'includes/ImagePage.php',
	'ImageHistoryPseudoPager' => 'includes/ImagePage.php',
	'ImagePage' => 'includes/ImagePage.php',
	'ImageQueryPage' => 'includes/ImageQueryPage.php',
	'ImportStreamSource' => 'includes/Import.php',
	'ImportStringSource' => 'includes/Import.php',
	'IncludableSpecialPage' => 'includes/SpecialPage.php',
	'IndexPager' => 'includes/Pager.php',
	'Interwiki' => 'includes/interwiki/Interwiki.php',
	'IP' => 'includes/IP.php',
	'LCStore' => 'includes/cache/LocalisationCache.php',
	'LCStore_Accel' => 'includes/cache/LocalisationCache.php',
	'LCStore_CDB' => 'includes/cache/LocalisationCache.php',
	'LCStore_DB' => 'includes/cache/LocalisationCache.php',
	'LCStore_Null' => 'includes/cache/LocalisationCache.php',
	'License' => 'includes/Licenses.php',
	'Licenses' => 'includes/Licenses.php',
	'Linker' => 'includes/Linker.php',
	'LinkFilter' => 'includes/LinkFilter.php',
	'LinksUpdate' => 'includes/LinksUpdate.php',
	'LinksDeletionUpdate' => 'includes/LinksUpdate.php',
	'LocalisationCache' => 'includes/cache/LocalisationCache.php',
	'LocalisationCache_BulkLoad' => 'includes/cache/LocalisationCache.php',
	'MagicWord' => 'includes/MagicWord.php',
	'MagicWordArray' => 'includes/MagicWord.php',
	'MailAddress' => 'includes/UserMailer.php',
	'MappedIterator' => 'includes/MappedIterator.php',
	'MediaWiki' => 'includes/Wiki.php',
	'MediaWiki_I18N' => 'includes/SkinTemplate.php',
	'Message' => 'includes/Message.php',
	'MessageBlobStore' => 'includes/MessageBlobStore.php',
	'MimeMagic' => 'includes/MimeMagic.php',
	'MWCryptRand' => 'includes/MWCryptRand.php',
	'MWException' => 'includes/Exception.php',
	'MWExceptionHandler' => 'includes/Exception.php',
	'MWFunction' => 'includes/MWFunction.php',
	'MWHookException' => 'includes/Hooks.php',
	'MWHttpRequest' => 'includes/HttpFunctions.php',
	'MWInit' => 'includes/Init.php',
	'MWNamespace' => 'includes/Namespace.php',
	'OutputPage' => 'includes/OutputPage.php',
	'Page' => 'includes/WikiPage.php',
	'PageQueryPage' => 'includes/PageQueryPage.php',
	'Pager' => 'includes/Pager.php',
	'PasswordError' => 'includes/User.php',
	'PathRouter' => 'includes/PathRouter.php',
	'PathRouterPatternReplacer' => 'includes/PathRouter.php',
	'PermissionsError' => 'includes/Exception.php',
	'PhpHttpRequest' => 'includes/HttpFunctions.php',
	'PoolCounter' => 'includes/PoolCounter.php',
	'PoolCounter_Stub' => 'includes/PoolCounter.php',
	'PoolCounterWork' => 'includes/PoolCounter.php',
	'PoolCounterWorkViaCallback' => 'includes/PoolCounter.php',
	'PoolWorkArticleView' => 'includes/WikiPage.php',
	'Preferences' => 'includes/Preferences.php',
	'PreferencesForm' => 'includes/Preferences.php',
	'PrefixSearch' => 'includes/PrefixSearch.php',
	'ProtectionForm' => 'includes/ProtectionForm.php',
	'QueryPage' => 'includes/QueryPage.php',
	'QuickTemplate' => 'includes/SkinTemplate.php',
	'RawMessage' => 'includes/Message.php',
	'RdfMetaData' => 'includes/Metadata.php',
	'ReadOnlyError' => 'includes/Exception.php',
	'RedirectSpecialArticle' => 'includes/SpecialPage.php',
	'RedirectSpecialPage' => 'includes/SpecialPage.php',
	'RegexlikeReplacer' => 'includes/StringUtils.php',
	'ReplacementArray' => 'includes/StringUtils.php',
	'Replacer' => 'includes/StringUtils.php',
	'ReverseChronologicalPager' => 'includes/Pager.php',
	'RevisionItem' => 'includes/RevisionList.php',
	'RevisionItemBase' => 'includes/RevisionList.php',
	'RevisionListBase' => 'includes/RevisionList.php',
	'Revision' => 'includes/Revision.php',
	'RevisionList' => 'includes/RevisionList.php',
	'RSSFeed' => 'includes/Feed.php',
	'Sanitizer' => 'includes/Sanitizer.php',
	'DataUpdate' => 'includes/DataUpdate.php',
	'SqlDataUpdate' => 'includes/SqlDataUpdate.php',
	'ScopedCallback' => 'includes/ScopedCallback.php',
	'ScopedPHPTimeout' => 'includes/ScopedPHPTimeout.php',
	'SiteConfiguration' => 'includes/SiteConfiguration.php',
	'SiteStats' => 'includes/SiteStats.php',
	'SiteStatsInit' => 'includes/SiteStats.php',
	'SiteStatsUpdate' => 'includes/SiteStats.php',
	'Skin' => 'includes/Skin.php',
	'SkinTemplate' => 'includes/SkinTemplate.php',
	'SpecialCreateAccount' => 'includes/SpecialPage.php',
	'SpecialListAdmins' => 'includes/SpecialPage.php',
	'SpecialListBots' => 'includes/SpecialPage.php',
	'SpecialMycontributions' => 'includes/SpecialPage.php',
	'SpecialMypage' => 'includes/SpecialPage.php',
	'SpecialMytalk' => 'includes/SpecialPage.php',
	'SpecialMyuploads' => 'includes/SpecialPage.php',
	'SpecialAllMyUploads' => 'includes/SpecialPage.php',
	'SpecialPage' => 'includes/SpecialPage.php',
	'SpecialPageFactory' => 'includes/SpecialPageFactory.php',
	'SpecialRedirectToSpecial' => 'includes/SpecialPage.php',
	'SquidPurgeClient' => 'includes/SquidPurgeClient.php',
	'SquidPurgeClientPool' => 'includes/SquidPurgeClient.php',
	'StatCounter' => 'includes/StatCounter.php',
	'Status' => 'includes/Status.php',
	'StreamFile' => 'includes/StreamFile.php',
	'StringUtils' => 'includes/StringUtils.php',
	'StubContLang' => 'includes/StubObject.php',
	'StubObject' => 'includes/StubObject.php',
	'StubUserLang' => 'includes/StubObject.php',
	'TablePager' => 'includes/Pager.php',
	'MWTimestamp' => 'includes/Timestamp.php',
	'TimestampException' => 'includes/Timestamp.php',
	'Title' => 'includes/Title.php',
	'TitleArray' => 'includes/TitleArray.php',
	'TitleArrayFromResult' => 'includes/TitleArray.php',
	'ThrottledError' => 'includes/Exception.php',
	'UIDGenerator' => 'includes/UIDGenerator.php',
	'UnlistedSpecialPage' => 'includes/SpecialPage.php',
	'UploadSourceAdapter' => 'includes/Import.php',
	'UppercaseCollation' => 'includes/Collation.php',
	'User' => 'includes/User.php',
	'UserArray' => 'includes/UserArray.php',
	'UserArrayFromResult' => 'includes/UserArray.php',
	'UserBlockedError' => 'includes/Exception.php',
	'UserNotLoggedIn' => 'includes/Exception.php',
	'UserCache' => 'includes/cache/UserCache.php',
	'UserMailer' => 'includes/UserMailer.php',
	'UserRightsProxy' => 'includes/UserRightsProxy.php',
	'ViewCountUpdate' => 'includes/ViewCountUpdate.php',
	'WantedQueryPage' => 'includes/QueryPage.php',
	'WatchedItem' => 'includes/WatchedItem.php',
	'WebRequest' => 'includes/WebRequest.php',
	'WebRequestUpload' => 'includes/WebRequest.php',
	'WebResponse' => 'includes/WebResponse.php',
	'WikiCategoryPage' => 'includes/WikiCategoryPage.php',
	'WikiError' => 'includes/WikiError.php',
	'WikiErrorMsg' => 'includes/WikiError.php',
	'WikiExporter' => 'includes/Export.php',
	'WikiFilePage' => 'includes/WikiFilePage.php',
	'WikiImporter' => 'includes/Import.php',
	'WikiPage' => 'includes/WikiPage.php',
	'WikiRevision' => 'includes/Import.php',
	'WikiMap' => 'includes/WikiMap.php',
	'WikiReference' => 'includes/WikiMap.php',
	'WikiXmlError' => 'includes/WikiError.php',
	'Xml' => 'includes/Xml.php',
	'XmlDumpWriter' => 'includes/Export.php',
	'XmlJsCode' => 'includes/Xml.php',
	'XMLReader2' => 'includes/Import.php',
	'XmlSelect' => 'includes/Xml.php',
	'XmlTypeCheck' => 'includes/XmlTypeCheck.php',
	'ZhClient' => 'includes/ZhClient.php',
	'ZipDirectoryReader' => 'includes/ZipDirectoryReader.php',
	'ZipDirectoryReaderError' => 'includes/ZipDirectoryReader.php',

	# content handler
	'AbstractContent' => 'includes/content/AbstractContent.php',
	'ContentHandler' => 'includes/content/ContentHandler.php',
	'Content' => 'includes/content/Content.php',
	'CssContentHandler' => 'includes/content/CssContentHandler.php',
	'CssContent' => 'includes/content/CssContent.php',
	'JavaScriptContentHandler' => 'includes/content/JavaScriptContentHandler.php',
	'JavaScriptContent' => 'includes/content/JavaScriptContent.php',
	'MessageContent' => 'includes/content/MessageContent.php',
	'MWContentSerializationException' => 'includes/content/ContentHandler.php',
	'TextContentHandler' => 'includes/content/TextContentHandler.php',
	'TextContent' => 'includes/content/TextContent.php',
	'WikitextContentHandler' => 'includes/content/WikitextContentHandler.php',
	'WikitextContent' => 'includes/content/WikitextContent.php',

	# includes/actions
	'CachedAction' => 'includes/actions/CachedAction.php',
	'CreditsAction' => 'includes/actions/CreditsAction.php',
	'DeleteAction' => 'includes/actions/DeleteAction.php',
	'EditAction' => 'includes/actions/EditAction.php',
	'HistoryAction' => 'includes/actions/HistoryAction.php',
	'HistoryPage' => 'includes/actions/HistoryAction.php',
	'HistoryPager' => 'includes/actions/HistoryAction.php',
	'InfoAction' => 'includes/actions/InfoAction.php',
	'MarkpatrolledAction' => 'includes/actions/MarkpatrolledAction.php',
	'ProtectAction' => 'includes/actions/ProtectAction.php',
	'PurgeAction' => 'includes/actions/PurgeAction.php',
	'RawAction' => 'includes/actions/RawAction.php',
	'RawPage' => 'includes/actions/RawAction.php',
	'RenderAction' => 'includes/actions/RenderAction.php',
	'RevertAction' => 'includes/actions/RevertAction.php',
	'RevertFileAction' => 'includes/actions/RevertAction.php',
	'RevisiondeleteAction' => 'includes/actions/RevisiondeleteAction.php',
	'RollbackAction' => 'includes/actions/RollbackAction.php',
	'SubmitAction' => 'includes/actions/EditAction.php',
	'UnprotectAction' => 'includes/actions/ProtectAction.php',
	'UnwatchAction' => 'includes/actions/WatchAction.php',
	'ViewAction' => 'includes/actions/ViewAction.php',
	'WatchAction' => 'includes/actions/WatchAction.php',

	# includes/api
	'ApiBase' => 'includes/api/ApiBase.php',
	'ApiBlock' => 'includes/api/ApiBlock.php',
	'ApiComparePages' => 'includes/api/ApiComparePages.php',
	'ApiCreateAccount' => 'includes/api/ApiCreateAccount.php',
	'ApiDelete' => 'includes/api/ApiDelete.php',
	'ApiDisabled' => 'includes/api/ApiDisabled.php',
	'ApiEditPage' => 'includes/api/ApiEditPage.php',
	'ApiEmailUser' => 'includes/api/ApiEmailUser.php',
	'ApiExpandTemplates' => 'includes/api/ApiExpandTemplates.php',
	'ApiFeedContributions' => 'includes/api/ApiFeedContributions.php',
	'ApiFeedWatchlist' => 'includes/api/ApiFeedWatchlist.php',
	'ApiFileRevert' => 'includes/api/ApiFileRevert.php',
	'ApiFormatBase' => 'includes/api/ApiFormatBase.php',
	'ApiFormatDbg' => 'includes/api/ApiFormatDbg.php',
	'ApiFormatDump' => 'includes/api/ApiFormatDump.php',
	'ApiFormatFeedWrapper' => 'includes/api/ApiFormatBase.php',
	'ApiFormatJson' => 'includes/api/ApiFormatJson.php',
	'ApiFormatNone' => 'includes/api/ApiFormatNone.php',
	'ApiFormatPhp' => 'includes/api/ApiFormatPhp.php',
	'ApiFormatRaw' => 'includes/api/ApiFormatRaw.php',
	'ApiFormatTxt' => 'includes/api/ApiFormatTxt.php',
	'ApiFormatWddx' => 'includes/api/ApiFormatWddx.php',
	'ApiFormatXml' => 'includes/api/ApiFormatXml.php',
	'ApiFormatXmlRsd' => 'includes/api/ApiRsd.php',
	'ApiFormatYaml' => 'includes/api/ApiFormatYaml.php',
	'ApiHelp' => 'includes/api/ApiHelp.php',
	'ApiImageRotate' => 'includes/api/ApiImageRotate.php',
	'ApiImport' => 'includes/api/ApiImport.php',
	'ApiImportReporter' => 'includes/api/ApiImport.php',
	'ApiLogin' => 'includes/api/ApiLogin.php',
	'ApiLogout' => 'includes/api/ApiLogout.php',
	'ApiMain' => 'includes/api/ApiMain.php',
	'ApiModuleManager' => 'includes/api/ApiModuleManager.php',
	'ApiMove' => 'includes/api/ApiMove.php',
	'ApiOpenSearch' => 'includes/api/ApiOpenSearch.php',
	'ApiOptions' => 'includes/api/ApiOptions.php',
	'ApiPageSet' => 'includes/api/ApiPageSet.php',
	'ApiParamInfo' => 'includes/api/ApiParamInfo.php',
	'ApiParse' => 'includes/api/ApiParse.php',
	'ApiPatrol' => 'includes/api/ApiPatrol.php',
	'ApiProtect' => 'includes/api/ApiProtect.php',
	'ApiPurge' => 'includes/api/ApiPurge.php',
	'ApiQuery' => 'includes/api/ApiQuery.php',
	'ApiQueryAllCategories' => 'includes/api/ApiQueryAllCategories.php',
	'ApiQueryAllImages' => 'includes/api/ApiQueryAllImages.php',
	'ApiQueryAllLinks' => 'includes/api/ApiQueryAllLinks.php',
	'ApiQueryAllMessages' => 'includes/api/ApiQueryAllMessages.php',
	'ApiQueryAllPages' => 'includes/api/ApiQueryAllPages.php',
	'ApiQueryAllUsers' => 'includes/api/ApiQueryAllUsers.php',
	'ApiQueryBacklinks' => 'includes/api/ApiQueryBacklinks.php',
	'ApiQueryBase' => 'includes/api/ApiQueryBase.php',
	'ApiQueryBlocks' => 'includes/api/ApiQueryBlocks.php',
	'ApiQueryCategories' => 'includes/api/ApiQueryCategories.php',
	'ApiQueryCategoryInfo' => 'includes/api/ApiQueryCategoryInfo.php',
	'ApiQueryCategoryMembers' => 'includes/api/ApiQueryCategoryMembers.php',
	'ApiQueryContributions' => 'includes/api/ApiQueryUserContributions.php',
	'ApiQueryDeletedrevs' => 'includes/api/ApiQueryDeletedrevs.php',
	'ApiQueryDisabled' => 'includes/api/ApiQueryDisabled.php',
	'ApiQueryDuplicateFiles' => 'includes/api/ApiQueryDuplicateFiles.php',
	'ApiQueryExternalLinks' => 'includes/api/ApiQueryExternalLinks.php',
	'ApiQueryExtLinksUsage' => 'includes/api/ApiQueryExtLinksUsage.php',
	'ApiQueryFilearchive' => 'includes/api/ApiQueryFilearchive.php',
	'ApiQueryGeneratorBase' => 'includes/api/ApiQueryBase.php',
	'ApiQueryImageInfo' => 'includes/api/ApiQueryImageInfo.php',
	'ApiQueryImages' => 'includes/api/ApiQueryImages.php',
	'ApiQueryInfo' => 'includes/api/ApiQueryInfo.php',
	'ApiQueryIWBacklinks' => 'includes/api/ApiQueryIWBacklinks.php',
	'ApiQueryIWLinks' => 'includes/api/ApiQueryIWLinks.php',
	'ApiQueryLangBacklinks' => 'includes/api/ApiQueryLangBacklinks.php',
	'ApiQueryLangLinks' => 'includes/api/ApiQueryLangLinks.php',
	'ApiQueryLinks' => 'includes/api/ApiQueryLinks.php',
	'ApiQueryLogEvents' => 'includes/api/ApiQueryLogEvents.php',
	'ApiQueryORM' => 'includes/api/ApiQueryORM.php',
	'ApiQueryPageProps' => 'includes/api/ApiQueryPageProps.php',
	'ApiQueryPagesWithProp' => 'includes/api/ApiQueryPagesWithProp.php',
	'ApiQueryPagePropNames' => 'includes/api/ApiQueryPagePropNames.php',
	'ApiQueryProtectedTitles' => 'includes/api/ApiQueryProtectedTitles.php',
	'ApiQueryQueryPage' => 'includes/api/ApiQueryQueryPage.php',
	'ApiQueryRandom' => 'includes/api/ApiQueryRandom.php',
	'ApiQueryRecentChanges' => 'includes/api/ApiQueryRecentChanges.php',
	'ApiQueryFileRepoInfo' => 'includes/api/ApiQueryFileRepoInfo.php',
	'ApiQueryRevisions' => 'includes/api/ApiQueryRevisions.php',
	'ApiQuerySearch' => 'includes/api/ApiQuerySearch.php',
	'ApiQuerySiteinfo' => 'includes/api/ApiQuerySiteinfo.php',
	'ApiQueryStashImageInfo' => 'includes/api/ApiQueryStashImageInfo.php',
	'ApiQueryTags' => 'includes/api/ApiQueryTags.php',
	'ApiQueryUserInfo' => 'includes/api/ApiQueryUserInfo.php',
	'ApiQueryUsers' => 'includes/api/ApiQueryUsers.php',
	'ApiQueryWatchlist' => 'includes/api/ApiQueryWatchlist.php',
	'ApiQueryWatchlistRaw' => 'includes/api/ApiQueryWatchlistRaw.php',
	'ApiResult' => 'includes/api/ApiResult.php',
	'ApiRollback' => 'includes/api/ApiRollback.php',
	'ApiRsd' => 'includes/api/ApiRsd.php',
	'ApiSetNotificationTimestamp' => 'includes/api/ApiSetNotificationTimestamp.php',
	'ApiTokens' => 'includes/api/ApiTokens.php',
	'ApiUnblock' => 'includes/api/ApiUnblock.php',
	'ApiUndelete' => 'includes/api/ApiUndelete.php',
	'ApiUpload' => 'includes/api/ApiUpload.php',
	'ApiUserrights' => 'includes/api/ApiUserrights.php',
	'ApiWatch' => 'includes/api/ApiWatch.php',
	'UsageException' => 'includes/api/ApiMain.php',

	# includes/cache
	'BacklinkCache' => 'includes/cache/BacklinkCache.php',
	'CacheDependency' => 'includes/cache/CacheDependency.php',
	'ConstantDependency' => 'includes/cache/CacheDependency.php',
	'DependencyWrapper' => 'includes/cache/CacheDependency.php',
	'FileCacheBase' => 'includes/cache/FileCacheBase.php',
	'FileDependency' => 'includes/cache/CacheDependency.php',
	'GenderCache' => 'includes/cache/GenderCache.php',
	'GlobalDependency' => 'includes/cache/CacheDependency.php',
	'HTMLCacheUpdate' => 'includes/cache/HTMLCacheUpdate.php',
	'HTMLFileCache' => 'includes/cache/HTMLFileCache.php',
	'LinkBatch' => 'includes/cache/LinkBatch.php',
	'LinkCache' => 'includes/cache/LinkCache.php',
	'MessageCache' => 'includes/cache/MessageCache.php',
	'ObjectFileCache' => 'includes/cache/ObjectFileCache.php',
	'ProcessCacheLRU' => 'includes/cache/ProcessCacheLRU.php',
	'ResourceFileCache' => 'includes/cache/ResourceFileCache.php',
	'SquidUpdate' => 'includes/cache/SquidUpdate.php',
	'TitleDependency' => 'includes/cache/CacheDependency.php',
	'TitleListDependency' => 'includes/cache/CacheDependency.php',

	# includes/changes
	'ChangesList' => 'includes/changes/ChangesList.php',
	'EnhancedChangesList' => 'includes/changes/EnhancedChangesList.php',
	'OldChangesList' => 'includes/changes/OldChangesList.php',
	'RCCacheEntry' => 'includes/changes/RCCacheEntry.php',
	'RecentChange' => 'includes/changes/RecentChange.php',

	# includes/clientpool
	'RedisConnectionPool' => 'includes/clientpool/RedisConnectionPool.php',
	'RedisConnRef' => 'includes/clientpool/RedisConnectionPool.php',

	# includes/context
	'ContextSource' => 'includes/context/ContextSource.php',
	'DerivativeContext' => 'includes/context/DerivativeContext.php',
	'IContextSource' => 'includes/context/IContextSource.php',
	'RequestContext' => 'includes/context/RequestContext.php',

	# includes/dao
	'IDBAccessObject' => 'includes/dao/IDBAccessObject.php',
	'DBAccessBase' => 'includes/dao/DBAccessBase.php',

	# includes/db
	'Blob' => 'includes/db/DatabaseUtility.php',
	'ChronologyProtector' => 'includes/db/ChronologyProtector.php',
	'CloneDatabase' => 'includes/db/CloneDatabase.php',
	'DatabaseBase' => 'includes/db/Database.php',
	'DatabaseMssql' => 'includes/db/DatabaseMssql.php',
	'DatabaseMysql' => 'includes/db/DatabaseMysql.php',
	'DatabaseMysqlBase' => 'includes/db/DatabaseMysqlBase.php',
	'DatabaseMysqli' => 'includes/db/DatabaseMysqli.php',
	'DatabaseOracle' => 'includes/db/DatabaseOracle.php',
	'DatabasePostgres' => 'includes/db/DatabasePostgres.php',
	'DatabaseSqlite' => 'includes/db/DatabaseSqlite.php',
	'DatabaseSqliteStandalone' => 'includes/db/DatabaseSqlite.php',
	'DatabaseType' => 'includes/db/Database.php',
	'DBAccessError' => 'includes/db/LBFactory.php',
	'DBConnectionError' => 'includes/db/DatabaseError.php',
	'DBConnRef' => 'includes/db/LoadBalancer.php',
	'DBError' => 'includes/db/DatabaseError.php',
	'DBObject' => 'includes/db/DatabaseUtility.php',
	'IDatabase'  => 'includes/db/Database.php',
	'IORMRow' => 'includes/db/IORMRow.php',
	'IORMTable' => 'includes/db/IORMTable.php',
	'DBMasterPos' => 'includes/db/DatabaseUtility.php',
	'DBQueryError' => 'includes/db/DatabaseError.php',
	'DBUnexpectedError' => 'includes/db/DatabaseError.php',
	'FakeResultWrapper' => 'includes/db/DatabaseUtility.php',
	'Field' => 'includes/db/DatabaseUtility.php',
	'LBFactory' => 'includes/db/LBFactory.php',
	'LBFactory_Fake' => 'includes/db/LBFactory.php',
	'LBFactory_Multi' => 'includes/db/LBFactory_Multi.php',
	'LBFactory_Simple' => 'includes/db/LBFactory.php',
	'LBFactory_Single' => 'includes/db/LBFactory_Single.php',
	'LikeMatch' => 'includes/db/DatabaseUtility.php',
	'LoadBalancer' => 'includes/db/LoadBalancer.php',
	'LoadBalancer_Single' => 'includes/db/LBFactory_Single.php',
	'LoadMonitor' => 'includes/db/LoadMonitor.php',
	'LoadMonitor_MySQL' => 'includes/db/LoadMonitor.php',
	'LoadMonitor_Null' => 'includes/db/LoadMonitor.php',
	'MssqlField' => 'includes/db/DatabaseMssql.php',
	'MssqlResult' => 'includes/db/DatabaseMssql.php',
	'MySQLField' => 'includes/db/DatabaseMysqlBase.php',
	'MySQLMasterPos' => 'includes/db/DatabaseMysqlBase.php',
	'ORAField' => 'includes/db/DatabaseOracle.php',
	'ORAResult' => 'includes/db/DatabaseOracle.php',
	'ORMIterator' => 'includes/db/ORMIterator.php',
	'ORMResult' => 'includes/db/ORMResult.php',
	'ORMRow' => 'includes/db/ORMRow.php',
	'ORMTable' => 'includes/db/ORMTable.php',
	'PostgresField' => 'includes/db/DatabasePostgres.php',
	'PostgresTransactionState' => 'includes/db/DatabasePostgres.php',
	'ResultWrapper' => 'includes/db/DatabaseUtility.php',
	'SavepointPostgres' => 'includes/db/DatabasePostgres.php',
	'SQLiteField' => 'includes/db/DatabaseSqlite.php',

	# includes/debug
	'MWDebug' => 'includes/debug/Debug.php',

	# includes/diff
	'_DiffEngine' => 'includes/diff/DairikiDiff.php',
	'_DiffOp' => 'includes/diff/DairikiDiff.php',
	'_DiffOp_Add' => 'includes/diff/DairikiDiff.php',
	'_DiffOp_Change' => 'includes/diff/DairikiDiff.php',
	'_DiffOp_Copy' => 'includes/diff/DairikiDiff.php',
	'_DiffOp_Delete' => 'includes/diff/DairikiDiff.php',
	'_HWLDF_WordAccumulator' => 'includes/diff/DairikiDiff.php',
	'ArrayDiffFormatter' => 'includes/diff/DairikiDiff.php',
	'Diff' => 'includes/diff/DairikiDiff.php',
	'DifferenceEngine' => 'includes/diff/DifferenceEngine.php',
	'DiffFormatter' => 'includes/diff/DairikiDiff.php',
	'MappedDiff' => 'includes/diff/DairikiDiff.php',
	'RangeDifference' => 'includes/diff/WikiDiff3.php',
	'TableDiffFormatter' => 'includes/diff/DairikiDiff.php',
	'UnifiedDiffFormatter' => 'includes/diff/DairikiDiff.php',
	'WikiDiff3' => 'includes/diff/WikiDiff3.php',
	'WordLevelDiff' => 'includes/diff/DairikiDiff.php',

	# includes/externalstore
	'ExternalStore' => 'includes/externalstore/ExternalStore.php',
	'ExternalStoreDB' => 'includes/externalstore/ExternalStoreDB.php',
	'ExternalStoreHttp' => 'includes/externalstore/ExternalStoreHttp.php',
	'ExternalStoreMedium' => 'includes/externalstore/ExternalStoreMedium.php',
	'ExternalStoreMwstore' => 'includes/externalstore/ExternalStoreMwstore.php',

	# includes/filebackend
	'FileBackendGroup' => 'includes/filebackend/FileBackendGroup.php',
	'FileBackend' => 'includes/filebackend/FileBackend.php',
	'FileBackendError' => 'includes/filebackend/FileBackend.php',
	'FileBackendStore' => 'includes/filebackend/FileBackendStore.php',
	'FileBackendStoreShardListIterator' => 'includes/filebackend/FileBackendStore.php',
	'FileBackendStoreShardDirIterator' => 'includes/filebackend/FileBackendStore.php',
	'FileBackendStoreShardFileIterator' => 'includes/filebackend/FileBackendStore.php',
	'FileBackendMultiWrite' => 'includes/filebackend/FileBackendMultiWrite.php',
	'FileBackendStoreOpHandle' => 'includes/filebackend/FileBackendStore.php',
	'FSFile' => 'includes/filebackend/FSFile.php',
	'FSFileBackend' => 'includes/filebackend/FSFileBackend.php',
	'FSFileBackendList' => 'includes/filebackend/FSFileBackend.php',
	'FSFileBackendDirList' => 'includes/filebackend/FSFileBackend.php',
	'FSFileBackendFileList' => 'includes/filebackend/FSFileBackend.php',
	'FSFileOpHandle' => 'includes/filebackend/FSFileBackend.php',
	'SwiftFileBackend' => 'includes/filebackend/SwiftFileBackend.php',
	'SwiftFileBackendList' => 'includes/filebackend/SwiftFileBackend.php',
	'SwiftFileBackendDirList' => 'includes/filebackend/SwiftFileBackend.php',
	'SwiftFileBackendFileList' => 'includes/filebackend/SwiftFileBackend.php',
	'SwiftFileOpHandle' => 'includes/filebackend/SwiftFileBackend.php',
	'TempFSFile' => 'includes/filebackend/TempFSFile.php',
	'FileJournal' => 'includes/filebackend/filejournal/FileJournal.php',
	'DBFileJournal' => 'includes/filebackend/filejournal/DBFileJournal.php',
	'NullFileJournal' => 'includes/filebackend/filejournal/FileJournal.php',
	'LockManagerGroup' => 'includes/filebackend/lockmanager/LockManagerGroup.php',
	'LockManager' => 'includes/filebackend/lockmanager/LockManager.php',
	'ScopedLock' => 'includes/filebackend/lockmanager/ScopedLock.php',
	'FSLockManager' => 'includes/filebackend/lockmanager/FSLockManager.php',
	'DBLockManager' => 'includes/filebackend/lockmanager/DBLockManager.php',
	'LSLockManager' => 'includes/filebackend/lockmanager/LSLockManager.php',
	'MemcLockManager' => 'includes/filebackend/lockmanager/MemcLockManager.php',
	'QuorumLockManager' => 'includes/filebackend/lockmanager/QuorumLockManager.php',
	'MySqlLockManager' => 'includes/filebackend/lockmanager/DBLockManager.php',
	'PostgreSqlLockManager' => 'includes/filebackend/lockmanager/DBLockManager.php',
	'RedisLockManager' => 'includes/filebackend/lockmanager/RedisLockManager.php',
	'NullLockManager' => 'includes/filebackend/lockmanager/LockManager.php',
	'FileOp' => 'includes/filebackend/FileOp.php',
	'FileOpBatch' => 'includes/filebackend/FileOpBatch.php',
	'StoreFileOp' => 'includes/filebackend/FileOp.php',
	'CopyFileOp' => 'includes/filebackend/FileOp.php',
	'MoveFileOp' => 'includes/filebackend/FileOp.php',
	'DeleteFileOp' => 'includes/filebackend/FileOp.php',
	'CreateFileOp' => 'includes/filebackend/FileOp.php',
	'DescribeFileOp' => 'includes/filebackend/FileOp.php',
	'NullFileOp' => 'includes/filebackend/FileOp.php',

	# includes/filerepo
	'FileRepo' => 'includes/filerepo/FileRepo.php',
	'FileRepoStatus' => 'includes/filerepo/FileRepoStatus.php',
	'ForeignAPIRepo' => 'includes/filerepo/ForeignAPIRepo.php',
	'ForeignDBRepo' => 'includes/filerepo/ForeignDBRepo.php',
	'ForeignDBViaLBRepo' => 'includes/filerepo/ForeignDBViaLBRepo.php',
	'FSRepo' => 'includes/filerepo/FSRepo.php',
	'LocalRepo' => 'includes/filerepo/LocalRepo.php',
	'NullRepo' => 'includes/filerepo/NullRepo.php',
	'RepoGroup' => 'includes/filerepo/RepoGroup.php',
	'TempFileRepo' => 'includes/filerepo/FileRepo.php',

	# includes/filerepo/file
	'ArchivedFile' => 'includes/filerepo/file/ArchivedFile.php',
	'File' => 'includes/filerepo/file/File.php',
	'ForeignAPIFile' => 'includes/filerepo/file/ForeignAPIFile.php',
	'ForeignDBFile' => 'includes/filerepo/file/ForeignDBFile.php',
	'LocalFile' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileDeleteBatch' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileMoveBatch' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileRestoreBatch' => 'includes/filerepo/file/LocalFile.php',
	'OldLocalFile' => 'includes/filerepo/file/OldLocalFile.php',
	'UnregisteredLocalFile' => 'includes/filerepo/file/UnregisteredLocalFile.php',

	# includes/installer
	'CliInstaller' => 'includes/installer/CliInstaller.php',
	'DatabaseInstaller' => 'includes/installer/DatabaseInstaller.php',
	'DatabaseUpdater' => 'includes/installer/DatabaseUpdater.php',
	'InstallDocFormatter' => 'includes/installer/InstallDocFormatter.php',
	'Installer' => 'includes/installer/Installer.php',
	'LocalSettingsGenerator' => 'includes/installer/LocalSettingsGenerator.php',
	'MysqlInstaller' => 'includes/installer/MysqlInstaller.php',
	'MysqlUpdater' => 'includes/installer/MysqlUpdater.php',
	'OracleInstaller' => 'includes/installer/OracleInstaller.php',
	'OracleUpdater' => 'includes/installer/OracleUpdater.php',
	'PhpRefCallBugTester' => 'includes/installer/PhpBugTests.php',
	'PhpXmlBugTester' => 'includes/installer/PhpBugTests.php',
	'PostgresInstaller' => 'includes/installer/PostgresInstaller.php',
	'PostgresUpdater' => 'includes/installer/PostgresUpdater.php',
	'SqliteInstaller' => 'includes/installer/SqliteInstaller.php',
	'SqliteUpdater' => 'includes/installer/SqliteUpdater.php',
	'WebInstaller' => 'includes/installer/WebInstaller.php',
	'WebInstaller_Complete' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Copying' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_DBConnect' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_DBSettings' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Document' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_ExistingWiki' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Install' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Language' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Name' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Options' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Readme' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_ReleaseNotes' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Restart' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Upgrade' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_UpgradeDoc' => 'includes/installer/WebInstallerPage.php',
	'WebInstaller_Welcome' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerOutput' => 'includes/installer/WebInstallerOutput.php',
	'WebInstallerPage' => 'includes/installer/WebInstallerPage.php',

	# includes/job
	'Job' => 'includes/job/Job.php',
	'JobQueue' => 'includes/job/JobQueue.php',
	'JobQueueAggregator' => 'includes/job/aggregator/JobQueueAggregator.php',
	'JobQueueAggregatorMemc' => 'includes/job/aggregator/JobQueueAggregatorMemc.php',
	'JobQueueAggregatorRedis' => 'includes/job/aggregator/JobQueueAggregatorRedis.php',
	'JobQueueDB' => 'includes/job/JobQueueDB.php',
	'JobQueueConnectionError' => 'includes/job/JobQueue.php',
	'JobQueueError' => 'includes/job/JobQueue.php',
	'JobQueueGroup' => 'includes/job/JobQueueGroup.php',
	'JobQueueFederated' => 'includes/job/JobQueueFederated.php',
	'JobQueueRedis' => 'includes/job/JobQueueRedis.php',

	# includes/job/jobs
	'DoubleRedirectJob' => 'includes/job/jobs/DoubleRedirectJob.php',
	'DuplicateJob' => 'includes/job/jobs/DuplicateJob.php',
	'EmaillingJob' => 'includes/job/jobs/EmaillingJob.php',
	'EnotifNotifyJob' => 'includes/job/jobs/EnotifNotifyJob.php',
	'HTMLCacheUpdateJob' => 'includes/job/jobs/HTMLCacheUpdateJob.php',
	'NullJob' => 'includes/job/jobs/NullJob.php',
	'RefreshLinksJob' => 'includes/job/jobs/RefreshLinksJob.php',
	'RefreshLinksJob2' => 'includes/job/jobs/RefreshLinksJob.php',
	'UploadFromUrlJob' => 'includes/job/jobs/UploadFromUrlJob.php',
	'AssembleUploadChunksJob' => 'includes/job/jobs/AssembleUploadChunksJob.php',
	'PublishStashedFileJob' => 'includes/job/jobs/PublishStashedFileJob.php',

	# includes/json
	'FormatJson' => 'includes/json/FormatJson.php',

	# includes/libs
	'CSSJanus' => 'includes/libs/CSSJanus.php',
	'CSSJanus_Tokenizer' => 'includes/libs/CSSJanus.php',
	'CSSMin' => 'includes/libs/CSSMin.php',
	'GenericArrayObject' => 'includes/libs/GenericArrayObject.php',
	'HttpStatus' => 'includes/libs/HttpStatus.php',
	'IEContentAnalyzer' => 'includes/libs/IEContentAnalyzer.php',
	'IEUrlExtension' => 'includes/libs/IEUrlExtension.php',
	'JavaScriptMinifier' => 'includes/libs/JavaScriptMinifier.php',
	'JSCompilerContext' => 'includes/libs/jsminplus.php',
	'JSMinPlus' => 'includes/libs/jsminplus.php',
	'JSNode' => 'includes/libs/jsminplus.php',
	'JSParser' => 'includes/libs/jsminplus.php',
	'JSToken' => 'includes/libs/jsminplus.php',
	'JSTokenizer' => 'includes/libs/jsminplus.php',

	# includes/libs/lessphp
	'lessc' => 'includes/libs/lessc.inc.php',
	'lessc_parser' => 'includes/libs/lessc.inc.php',
	'lessc_formatter_classic' => 'includes/libs/lessc.inc.php',
	'lessc_formatter_compressed' => 'includes/libs/lessc.inc.php',
	'lessc_formatter_lessjs' => 'includes/libs/lessc.inc.php',

	# includes/logging
	'DatabaseLogEntry' => 'includes/logging/LogEntry.php',
	'DeleteLogFormatter' => 'includes/logging/DeleteLogFormatter.php',
	'LegacyLogFormatter' => 'includes/logging/LogFormatter.php',
	'LogEntry' => 'includes/logging/LogEntry.php',
	'LogEventsList' => 'includes/logging/LogEventsList.php',
	'LogEntryBase' => 'includes/logging/LogEntry.php',
	'LogFormatter' => 'includes/logging/LogFormatter.php',
	'LogPage' => 'includes/logging/LogPage.php',
	'LogPager' => 'includes/logging/LogPager.php',
	'ManualLogEntry' => 'includes/logging/LogEntry.php',
	'MoveLogFormatter' => 'includes/logging/MoveLogFormatter.php',
	'NewUsersLogFormatter' => 'includes/logging/NewUsersLogFormatter.php',
	'PatrolLog' => 'includes/logging/PatrolLog.php',
	'PatrolLogFormatter' => 'includes/logging/PatrolLogFormatter.php',
	'RCDatabaseLogEntry' => 'includes/logging/LogEntry.php',
	'RightsLogFormatter' => 'includes/logging/RightsLogFormatter.php',

	# Image gallery

	'ImageGallery' => 'includes/gallery/TraditionalImageGallery.php',
	'ImageGalleryBase' => 'includes/gallery/ImageGalleryBase.php',
	'NolinesImageGallery' => 'includes/gallery/NolinesImageGallery.php',
	'TraditionalImageGallery' => 'includes/gallery/TraditionalImageGallery.php',
	'PackedImageGallery' => 'includes/gallery/PackedImageGallery.php',
	'PackedHoverImageGallery' => 'includes/gallery/PackedOverlayImageGallery.php',
	'PackedOverlayImageGallery' => 'includes/gallery/PackedOverlayImageGallery.php',

	# includes/media
	'BitmapHandler' => 'includes/media/Bitmap.php',
	'BitmapHandler_ClientOnly' => 'includes/media/Bitmap_ClientOnly.php',
	'BitmapMetadataHandler' => 'includes/media/BitmapMetadataHandler.php',
	'BmpHandler' => 'includes/media/BMP.php',
	'DjVuHandler' => 'includes/media/DjVu.php',
	'DjVuImage' => 'includes/media/DjVuImage.php',
	'Exif' => 'includes/media/Exif.php',
	'ExifBitmapHandler' => 'includes/media/ExifBitmap.php',
	'FormatExif' => 'includes/media/FormatMetadata.php',
	'FormatMetadata' => 'includes/media/FormatMetadata.php',
	'GIFHandler' => 'includes/media/GIF.php',
	'GIFMetadataExtractor' => 'includes/media/GIFMetadataExtractor.php',
	'ImageHandler' => 'includes/media/ImageHandler.php',
	'IPTC' => 'includes/media/IPTC.php',
	'JpegHandler' => 'includes/media/Jpeg.php',
	'JpegMetadataExtractor' => 'includes/media/JpegMetadataExtractor.php',
	'MediaHandler' => 'includes/media/MediaHandler.php',
	'MediaTransformError' => 'includes/media/MediaTransformOutput.php',
	'MediaTransformOutput' => 'includes/media/MediaTransformOutput.php',
	'PNGHandler' => 'includes/media/PNG.php',
	'PNGMetadataExtractor' => 'includes/media/PNGMetadataExtractor.php',
	'SvgHandler' => 'includes/media/SVG.php',
	'SVGMetadataExtractor' => 'includes/media/SVGMetadataExtractor.php',
	'SVGReader' => 'includes/media/SVGMetadataExtractor.php',
	'ThumbnailImage' => 'includes/media/MediaTransformOutput.php',
	'TiffHandler' => 'includes/media/Tiff.php',
	'TransformParameterError' => 'includes/media/MediaTransformOutput.php',
	'XCFHandler' => 'includes/media/XCF.php',
	'XMPInfo' => 'includes/media/XMPInfo.php',
	'XMPReader' => 'includes/media/XMP.php',
	'XMPValidate' => 'includes/media/XMPValidate.php',

	# includes/normal
	'UtfNormal' => 'includes/normal/UtfNormal.php',

	# includes/objectcache
	'APCBagOStuff' => 'includes/objectcache/APCBagOStuff.php',
	'BagOStuff' => 'includes/objectcache/BagOStuff.php',
	'DBABagOStuff' => 'includes/objectcache/DBABagOStuff.php',
	'EhcacheBagOStuff' => 'includes/objectcache/EhcacheBagOStuff.php',
	'EmptyBagOStuff' => 'includes/objectcache/EmptyBagOStuff.php',
	'FakeMemCachedClient' => 'includes/objectcache/EmptyBagOStuff.php',
	'HashBagOStuff' => 'includes/objectcache/HashBagOStuff.php',
	'MediaWikiBagOStuff' => 'includes/objectcache/SqlBagOStuff.php',
	'MemCachedClientforWiki' => 'includes/objectcache/MemcachedClient.php',
	'MemcachedBagOStuff' => 'includes/objectcache/MemcachedBagOStuff.php',
	'MemcachedPeclBagOStuff' => 'includes/objectcache/MemcachedPeclBagOStuff.php',
	'MemcachedPhpBagOStuff' => 'includes/objectcache/MemcachedPhpBagOStuff.php',
	'MultiWriteBagOStuff' => 'includes/objectcache/MultiWriteBagOStuff.php',
	'MWMemcached' => 'includes/objectcache/MemcachedClient.php',
	'ObjectCache' => 'includes/objectcache/ObjectCache.php',
	'ObjectCacheSessionHandler' => 'includes/objectcache/ObjectCacheSessionHandler.php',
	'RedisBagOStuff' => 'includes/objectcache/RedisBagOStuff.php',
	'SqlBagOStuff' => 'includes/objectcache/SqlBagOStuff.php',
	'WinCacheBagOStuff' => 'includes/objectcache/WinCacheBagOStuff.php',
	'XCacheBagOStuff' => 'includes/objectcache/XCacheBagOStuff.php',

	# includes/parser
	'CacheTime' => 'includes/parser/CacheTime.php',
	'CoreParserFunctions' => 'includes/parser/CoreParserFunctions.php',
	'CoreTagHooks' => 'includes/parser/CoreTagHooks.php',
	'DateFormatter' => 'includes/parser/DateFormatter.php',
	'LinkHolderArray' => 'includes/parser/LinkHolderArray.php',
	'MWTidy' => 'includes/parser/Tidy.php',
	'MWTidyWrapper' => 'includes/parser/Tidy.php',
	'PPCustomFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPCustomFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDAccum_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDPart' => 'includes/parser/Preprocessor_DOM.php',
	'PPDPart_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDStack' => 'includes/parser/Preprocessor_DOM.php',
	'PPDStackElement' => 'includes/parser/Preprocessor_DOM.php',
	'PPDStackElement_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDStack_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPFrame' => 'includes/parser/Preprocessor.php',
	'PPFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode' => 'includes/parser/Preprocessor.php',
	'PPNode_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPNode_Hash_Array' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Attr' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Text' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Tree' => 'includes/parser/Preprocessor_Hash.php',
	'PPTemplateFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPTemplateFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'Parser' => 'includes/parser/Parser.php',
	'ParserCache' => 'includes/parser/ParserCache.php',
	'ParserOptions' => 'includes/parser/ParserOptions.php',
	'ParserOutput' => 'includes/parser/ParserOutput.php',
	'Parser_DiffTest' => 'includes/parser/Parser_DiffTest.php',
	'Preprocessor' => 'includes/parser/Preprocessor.php',
	'Preprocessor_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'Preprocessor_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'StripState' => 'includes/parser/StripState.php',

	# includes/profiler
	'Profiler' => 'includes/profiler/Profiler.php',
	'ProfilerSimple' => 'includes/profiler/ProfilerSimple.php',
	'ProfilerSimpleText' => 'includes/profiler/ProfilerSimpleText.php',
	'ProfilerSimpleTrace' => 'includes/profiler/ProfilerSimpleTrace.php',
	'ProfilerSimpleUDP' => 'includes/profiler/ProfilerSimpleUDP.php',
	'ProfilerStub' => 'includes/profiler/ProfilerStub.php',
	'ProfileSection' => 'includes/profiler/Profiler.php',

	# includes/rcfeed
	'RCFeedEngine' => 'includes/rcfeed/RCFeedEngine.php',
	'RedisPubSubFeedEngine' => 'includes/rcfeed/RedisPubSubFeedEngine.php',
	'UDPRCFeedEngine' => 'includes/rcfeed/UDPRCFeedEngine.php',
	'RCFeedFormatter' => 'includes/rcfeed/RCFeedFormatter.php',
	'IRCColourfulRCFeedFormatter' => 'includes/rcfeed/IRCColourfulRCFeedFormatter.php',
	'JSONRCFeedFormatter' => 'includes/rcfeed/JSONRCFeedFormatter.php',

	# includes/resourceloader
	'ResourceLoader' => 'includes/resourceloader/ResourceLoader.php',
	'ResourceLoaderContext' => 'includes/resourceloader/ResourceLoaderContext.php',
	'ResourceLoaderFileModule' => 'includes/resourceloader/ResourceLoaderFileModule.php',
	'ResourceLoaderFilePageModule' => 'includes/resourceloader/ResourceLoaderFilePageModule.php',
	'ResourceLoaderLESSFunctions' => 'includes/resourceloader/ResourceLoaderLESSFunctions.php',
	'ResourceLoaderModule' => 'includes/resourceloader/ResourceLoaderModule.php',
	'ResourceLoaderNoscriptModule' => 'includes/resourceloader/ResourceLoaderNoscriptModule.php',
	'ResourceLoaderSiteModule' => 'includes/resourceloader/ResourceLoaderSiteModule.php',
	'ResourceLoaderStartUpModule' => 'includes/resourceloader/ResourceLoaderStartUpModule.php',
	'ResourceLoaderUserCSSPrefsModule' => 'includes/resourceloader/ResourceLoaderUserCSSPrefsModule.php',
	'ResourceLoaderUserGroupsModule' => 'includes/resourceloader/ResourceLoaderUserGroupsModule.php',
	'ResourceLoaderUserModule' => 'includes/resourceloader/ResourceLoaderUserModule.php',
	'ResourceLoaderUserOptionsModule' => 'includes/resourceloader/ResourceLoaderUserOptionsModule.php',
	'ResourceLoaderUserTokensModule' => 'includes/resourceloader/ResourceLoaderUserTokensModule.php',
	'ResourceLoaderLanguageDataModule' => 'includes/resourceloader/ResourceLoaderLanguageDataModule.php',
	'ResourceLoaderWikiModule' => 'includes/resourceloader/ResourceLoaderWikiModule.php',

	# includes/revisiondelete
	'RevDel_ArchivedFileItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_ArchivedFileList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_ArchivedRevisionItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_ArchiveItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_ArchiveList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_FileItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_FileList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_Item' => 'includes/revisiondelete/RevisionDeleteAbstracts.php',
	'RevDel_List' => 'includes/revisiondelete/RevisionDeleteAbstracts.php',
	'RevDel_LogItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_LogList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_RevisionItem' => 'includes/revisiondelete/RevisionDelete.php',
	'RevDel_RevisionList' => 'includes/revisiondelete/RevisionDelete.php',
	'RevisionDeleter' => 'includes/revisiondelete/RevisionDeleter.php',
	'RevisionDeleteUser' => 'includes/revisiondelete/RevisionDeleteUser.php',

	# includes/search
	'MssqlSearchResultSet' => 'includes/search/SearchMssql.php',
	'MySQLSearchResultSet' => 'includes/search/SearchMySQL.php',
	'PostgresSearchResult' => 'includes/search/SearchPostgres.php',
	'PostgresSearchResultSet' => 'includes/search/SearchPostgres.php',
	'SearchEngine' => 'includes/search/SearchEngine.php',
	'SearchEngineDummy' => 'includes/search/SearchEngine.php',
	'SearchHighlighter' => 'includes/search/SearchEngine.php',
	'SearchMssql' => 'includes/search/SearchMssql.php',
	'SearchMySQL' => 'includes/search/SearchMySQL.php',
	'SearchNearMatchResultSet' => 'includes/search/SearchEngine.php',
	'SearchOracle' => 'includes/search/SearchOracle.php',
	'SearchPostgres' => 'includes/search/SearchPostgres.php',
	'SearchResult' => 'includes/search/SearchEngine.php',
	'SearchResultSet' => 'includes/search/SearchEngine.php',
	'SearchResultTooMany' => 'includes/search/SearchEngine.php',
	'SearchSqlite' => 'includes/search/SearchSqlite.php',
	'SearchUpdate' => 'includes/search/SearchUpdate.php',
	'SqliteSearchResultSet' => 'includes/search/SearchSqlite.php',
	'SqlSearchResultSet' => 'includes/search/SearchEngine.php',

	# includes/site
	'MediaWikiSite' => 'includes/site/MediaWikiSite.php',
	'Site' => 'includes/site/Site.php',
	'SiteObject' => 'includes/site/Site.php',
	'SiteArray' => 'includes/site/SiteList.php',
	'SiteList' => 'includes/site/SiteList.php',
	'SiteSQLStore' => 'includes/site/SiteSQLStore.php',
	'Sites' => 'includes/site/SiteSQLStore.php',
	'SiteStore' => 'includes/site/SiteStore.php',

	# includes/specials
	'ActiveUsersPager' => 'includes/specials/SpecialActiveusers.php',
	'AllmessagesTablePager' => 'includes/specials/SpecialAllmessages.php',
	'AncientPagesPage' => 'includes/specials/SpecialAncientpages.php',
	'BlockListPager' => 'includes/specials/SpecialBlockList.php',
	'BrokenRedirectsPage' => 'includes/specials/SpecialBrokenRedirects.php',
	'CategoryPager' => 'includes/specials/SpecialCategories.php',
	'ContribsPager' => 'includes/specials/SpecialContributions.php',
	'DeadendPagesPage' => 'includes/specials/SpecialDeadendpages.php',
	'DeletedContribsPager' => 'includes/specials/SpecialDeletedContributions.php',
	'DeletedContributionsPage' => 'includes/specials/SpecialDeletedContributions.php',
	'DoubleRedirectsPage' => 'includes/specials/SpecialDoubleRedirects.php',
	'EditWatchlistCheckboxSeriesField' => 'includes/specials/SpecialEditWatchlist.php',
	'EditWatchlistNormalHTMLForm' => 'includes/specials/SpecialEditWatchlist.php',
	'EmailConfirmation' => 'includes/specials/SpecialConfirmemail.php',
	'EmailInvalidation' => 'includes/specials/SpecialConfirmemail.php',
	'FewestrevisionsPage' => 'includes/specials/SpecialFewestrevisions.php',
	'FileDuplicateSearchPage' => 'includes/specials/SpecialFileDuplicateSearch.php',
	'HTMLBlockedUsersItemSelect' => 'includes/specials/SpecialBlockList.php',
	'ImageListPager' => 'includes/specials/SpecialListfiles.php',
	'ImportReporter' => 'includes/specials/SpecialImport.php',
	'IPBlockForm' => 'includes/specials/SpecialBlock.php',
	'LinkSearchPage' => 'includes/specials/SpecialLinkSearch.php',
	'ListredirectsPage' => 'includes/specials/SpecialListredirects.php',
	'LoginForm' => 'includes/specials/SpecialUserlogin.php',
	'LonelyPagesPage' => 'includes/specials/SpecialLonelypages.php',
	'LongPagesPage' => 'includes/specials/SpecialLongpages.php',
	'MergeHistoryPager' => 'includes/specials/SpecialMergeHistory.php',
	'MIMEsearchPage' => 'includes/specials/SpecialMIMEsearch.php',
	'MostcategoriesPage' => 'includes/specials/SpecialMostcategories.php',
	'MostimagesPage' => 'includes/specials/SpecialMostimages.php',
	'MostinterwikisPage' => 'includes/specials/SpecialMostinterwikis.php',
	'MostlinkedCategoriesPage' => 'includes/specials/SpecialMostlinkedcategories.php',
	'MostlinkedPage' => 'includes/specials/SpecialMostlinked.php',
	'MostlinkedTemplatesPage' => 'includes/specials/SpecialMostlinkedtemplates.php',
	'MostrevisionsPage' => 'includes/specials/SpecialMostrevisions.php',
	'MovePageForm' => 'includes/specials/SpecialMovepage.php',
	'NewFilesPager' => 'includes/specials/SpecialNewimages.php',
	'NewPagesPager' => 'includes/specials/SpecialNewpages.php',
	'PageArchive' => 'includes/specials/SpecialUndelete.php',
	'PopularPagesPage' => 'includes/specials/SpecialPopularpages.php',
	'ProtectedPagesPager' => 'includes/specials/SpecialProtectedpages.php',
	'ProtectedTitlesPager' => 'includes/specials/SpecialProtectedtitles.php',
	'RandomPage' => 'includes/specials/SpecialRandompage.php',
	'ShortPagesPage' => 'includes/specials/SpecialShortpages.php',
	'SpecialActiveUsers' => 'includes/specials/SpecialActiveusers.php',
	'SpecialAllmessages' => 'includes/specials/SpecialAllmessages.php',
	'SpecialAllpages' => 'includes/specials/SpecialAllpages.php',
	'SpecialBlankpage' => 'includes/specials/SpecialBlankpage.php',
	'SpecialBlock' => 'includes/specials/SpecialBlock.php',
	'SpecialBlockList' => 'includes/specials/SpecialBlockList.php',
	'SpecialBookSources' => 'includes/specials/SpecialBooksources.php',
	'SpecialCachedPage' => 'includes/specials/SpecialCachedPage.php',
	'SpecialCategories' => 'includes/specials/SpecialCategories.php',
	'SpecialChangeEmail' => 'includes/specials/SpecialChangeEmail.php',
	'SpecialChangePassword' => 'includes/specials/SpecialChangePassword.php',
	'SpecialComparePages' => 'includes/specials/SpecialComparePages.php',
	'SpecialContributions' => 'includes/specials/SpecialContributions.php',
	'SpecialEditWatchlist' => 'includes/specials/SpecialEditWatchlist.php',
	'SpecialEmailUser' => 'includes/specials/SpecialEmailuser.php',
	'SpecialExport' => 'includes/specials/SpecialExport.php',
	'SpecialFilepath' => 'includes/specials/SpecialFilepath.php',
	'SpecialImport' => 'includes/specials/SpecialImport.php',
	'SpecialJavaScriptTest' => 'includes/specials/SpecialJavaScriptTest.php',
	'SpecialListFiles' => 'includes/specials/SpecialListfiles.php',
	'SpecialListGroupRights' => 'includes/specials/SpecialListgrouprights.php',
	'SpecialListUsers' => 'includes/specials/SpecialListusers.php',
	'SpecialLockdb' => 'includes/specials/SpecialLockdb.php',
	'SpecialLog' => 'includes/specials/SpecialLog.php',
	'SpecialMergeHistory' => 'includes/specials/SpecialMergeHistory.php',
	'SpecialNewFiles' => 'includes/specials/SpecialNewimages.php',
	'SpecialNewpages' => 'includes/specials/SpecialNewpages.php',
	'SpecialPasswordReset' => 'includes/specials/SpecialPasswordReset.php',
	'SpecialPagesWithProp' => 'includes/specials/SpecialPagesWithProp.php',
	'SpecialPermanentLink' => 'includes/SpecialPage.php',
	'SpecialPreferences' => 'includes/specials/SpecialPreferences.php',
	'SpecialPrefixindex' => 'includes/specials/SpecialPrefixindex.php',
	'SpecialProtectedpages' => 'includes/specials/SpecialProtectedpages.php',
	'SpecialProtectedtitles' => 'includes/specials/SpecialProtectedtitles.php',
	'SpecialRandomInCategory' => 'includes/specials/SpecialRandomInCategory.php',
	'SpecialRandomredirect' => 'includes/specials/SpecialRandomredirect.php',
	'SpecialRecentChanges' => 'includes/specials/SpecialRecentchanges.php',
	'SpecialRecentchangeslinked' => 'includes/specials/SpecialRecentchangeslinked.php',
	'SpecialRedirect' => 'includes/specials/SpecialRedirect.php',
	'SpecialResetTokens' => 'includes/specials/SpecialResetTokens.php',
	'SpecialRevisionDelete' => 'includes/specials/SpecialRevisiondelete.php',
	'SpecialSearch' => 'includes/specials/SpecialSearch.php',
	'SpecialSpecialpages' => 'includes/specials/SpecialSpecialpages.php',
	'SpecialStatistics' => 'includes/specials/SpecialStatistics.php',
	'SpecialTags' => 'includes/specials/SpecialTags.php',
	'SpecialUnblock' => 'includes/specials/SpecialUnblock.php',
	'SpecialUndelete' => 'includes/specials/SpecialUndelete.php',
	'SpecialUnlockdb' => 'includes/specials/SpecialUnlockdb.php',
	'SpecialUpload' => 'includes/specials/SpecialUpload.php',
	'SpecialUploadStash' => 'includes/specials/SpecialUploadStash.php',
	'SpecialUploadStashTooLargeException' => 'includes/specials/SpecialUploadStash.php',
	'SpecialUserlogout' => 'includes/specials/SpecialUserlogout.php',
	'SpecialVersion' => 'includes/specials/SpecialVersion.php',
	'SpecialWatchlist' => 'includes/specials/SpecialWatchlist.php',
	'SpecialWhatLinksHere' => 'includes/specials/SpecialWhatlinkshere.php',
	'UncategorizedCategoriesPage' => 'includes/specials/SpecialUncategorizedcategories.php',
	'UncategorizedImagesPage' => 'includes/specials/SpecialUncategorizedimages.php',
	'UncategorizedPagesPage' => 'includes/specials/SpecialUncategorizedpages.php',
	'UncategorizedTemplatesPage' => 'includes/specials/SpecialUncategorizedtemplates.php',
	'UnusedCategoriesPage' => 'includes/specials/SpecialUnusedcategories.php',
	'UnusedimagesPage' => 'includes/specials/SpecialUnusedimages.php',
	'UnusedtemplatesPage' => 'includes/specials/SpecialUnusedtemplates.php',
	'UnwatchedpagesPage' => 'includes/specials/SpecialUnwatchedpages.php',
	'UploadChunkFileException' => 'includes/upload/UploadFromChunks.php',
	'UploadChunkZeroLengthFileException' => 'includes/upload/UploadFromChunks.php',
	'UploadChunkVerificationException' => 'includes/upload/UploadFromChunks.php',
	'UploadForm' => 'includes/specials/SpecialUpload.php',
	'UploadSourceField' => 'includes/specials/SpecialUpload.php',
	'UserrightsPage' => 'includes/specials/SpecialUserrights.php',
	'UsersPager' => 'includes/specials/SpecialListusers.php',
	'WantedCategoriesPage' => 'includes/specials/SpecialWantedcategories.php',
	'WantedFilesPage' => 'includes/specials/SpecialWantedfiles.php',
	'WantedPagesPage' => 'includes/specials/SpecialWantedpages.php',
	'WantedTemplatesPage' => 'includes/specials/SpecialWantedtemplates.php',
	'WatchlistEditor' => 'includes/specials/SpecialEditWatchlist.php',
	'WithoutInterwikiPage' => 'includes/specials/SpecialWithoutinterwiki.php',

	# includes/templates
	'UserloginTemplate' => 'includes/templates/Userlogin.php',
	'UsercreateTemplate' => 'includes/templates/Usercreate.php',

	# includes/upload
	'UploadBase' => 'includes/upload/UploadBase.php',
	'UploadFromFile' => 'includes/upload/UploadFromFile.php',
	'UploadFromChunks' => 'includes/upload/UploadFromChunks.php',
	'UploadFromStash' => 'includes/upload/UploadFromStash.php',
	'UploadFromUrl' => 'includes/upload/UploadFromUrl.php',
	'UploadStash' => 'includes/upload/UploadStash.php',
	'UploadStashBadPathException' => 'includes/upload/UploadStash.php',
	'UploadStashException' => 'includes/upload/UploadStash.php',
	'UploadStashFile' => 'includes/upload/UploadStash.php',
	'UploadStashFileException' => 'includes/upload/UploadStash.php',
	'UploadStashFileNotFoundException' => 'includes/upload/UploadStash.php',
	'UploadStashNotAvailableException' => 'includes/upload/UploadStash.php',
	'UploadStashZeroLengthFileException' => 'includes/upload/UploadStash.php',
	'UploadStashNotLoggedInException' => 'includes/upload/UploadStash.php',
	'UploadStashWrongOwnerException' => 'includes/upload/UploadStash.php',
	'UploadStashNoSuchKeyException' => 'includes/upload/UploadStash.php',

	# languages
	'ConverterRule' => 'languages/LanguageConverter.php',
	'FakeConverter' => 'languages/Language.php',
	'Language' => 'languages/Language.php',
	'LanguageConverter' => 'languages/LanguageConverter.php',
	'CLDRPluralRuleConverter' => 'languages/utils/CLDRPluralRuleEvaluator.php',
	'CLDRPluralRuleConverter_Expression' => 'languages/utils/CLDRPluralRuleEvaluator.php',
	'CLDRPluralRuleConverter_Fragment' => 'languages/utils/CLDRPluralRuleEvaluator.php',
	'CLDRPluralRuleConverter_Operator' => 'languages/utils/CLDRPluralRuleEvaluator.php',
	'CLDRPluralRuleEvaluator' => 'languages/utils/CLDRPluralRuleEvaluator.php',
	'CLDRPluralRuleEvaluator_Range' => 'languages/utils/CLDRPluralRuleEvaluator.php',
	'CLDRPluralRuleError' => 'languages/utils/CLDRPluralRuleEvaluator.php',

	# maintenance
	'BackupDumper' => 'maintenance/backup.inc',
	'ConvertLinks' => 'maintenance/convertLinks.php',
	'DeleteArchivedFilesImplementation' => 'maintenance/deleteArchivedFiles.inc',
	'DeleteArchivedRevisionsImplementation' => 'maintenance/deleteArchivedRevisions.inc',
	'DeleteDefaultMessages' => 'maintenance/deleteDefaultMessages.php',
	'DumpDBZip2Output' => 'maintenance/backup.inc',
	'ExportProgressFilter' => 'maintenance/backup.inc',
	'FakeMaintenance' => 'maintenance/Maintenance.php',
	'FixExtLinksProtocolRelative' => 'maintenance/fixExtLinksProtocolRelative.php',
	'LoggedUpdateMaintenance' => 'maintenance/Maintenance.php',
	'Maintenance' => 'maintenance/Maintenance.php',
	'PopulateCategory' => 'maintenance/populateCategory.php',
	'PopulateImageSha1' => 'maintenance/populateImageSha1.php',
	'PopulateFilearchiveSha1' => 'maintenance/populateFilearchiveSha1.php',
	'PopulateLogSearch' => 'maintenance/populateLogSearch.php',
	'PopulateLogUsertext' => 'maintenance/populateLogUsertext.php',
	'PopulateParentId' => 'maintenance/populateParentId.php',
	'PopulateRevisionLength' => 'maintenance/populateRevisionLength.php',
	'PopulateRevisionSha1' => 'maintenance/populateRevisionSha1.php',
	'RefreshLinks' => 'maintenance/refreshLinks.php',
	'SevenZipStream' => 'maintenance/7zip.inc',
	'Sqlite' => 'maintenance/sqlite.inc',
	'UpdateCollation' => 'maintenance/updateCollation.php',
	'UpdateRestrictions' => 'maintenance/updateRestrictions.php',
	'UserDupes' => 'maintenance/userDupes.inc',

	# maintenance/language
	'csvStatsOutput' => 'maintenance/language/StatOutputs.php',
	'extensionLanguages' => 'maintenance/language/languages.inc',
	'languages' => 'maintenance/language/languages.inc',
	'MessageWriter' => 'maintenance/language/writeMessagesArray.inc',
	'statsOutput' => 'maintenance/language/StatOutputs.php',
	'textStatsOutput' => 'maintenance/language/StatOutputs.php',
	'wikiStatsOutput' => 'maintenance/language/StatOutputs.php',

	# maintenance/term
	'AnsiTermColorer' => 'maintenance/term/MWTerm.php',
	'DummyTermColorer' => 'maintenance/term/MWTerm.php',

	# mw-config
	'InstallerOverrides' => 'mw-config/overrides.php',
	'MyLocalSettingsGenerator' => 'mw-config/overrides.php',

	# skins
	'CologneBlueTemplate' => 'skins/CologneBlue.php',
	'ModernTemplate' => 'skins/Modern.php',
	'MonoBookTemplate' => 'skins/MonoBook.php',
	'SkinCologneBlue' => 'skins/CologneBlue.php',
	'SkinModern' => 'skins/Modern.php',
	'SkinMonoBook' => 'skins/MonoBook.php',
	'SkinVector' => 'skins/Vector.php',
	'VectorTemplate' => 'skins/Vector.php',
);

class AutoLoader {
	/**
	 * autoload - take a class name and attempt to load it
	 *
	 * @param string $className name of class we're looking for.
	 * @return bool Returning false is important on failure as
	 * it allows Zend to try and look in other registered autoloaders
	 * as well.
	 */
	static function autoload( $className ) {
		global $wgAutoloadClasses, $wgAutoloadLocalClasses;

		// Workaround for PHP bug <https://bugs.php.net/bug.php?id=49143> (5.3.2. is broken, it's
		// fixed in 5.3.6). Strip leading backslashes from class names. When namespaces are used,
		// leading backslashes are used to indicate the top-level namespace, e.g. \foo\Bar. When
		// used like this in the code, the leading backslash isn't passed to the auto-loader
		// ($className would be 'foo\Bar'). However, if a class is accessed using a string instead
		// of a class literal (e.g. $class = '\foo\Bar'; new $class()), then some versions of PHP
		// do not strip the leading backlash in this case, causing autoloading to fail.
		$className = ltrim( $className, '\\' );

		if ( isset( $wgAutoloadLocalClasses[$className] ) ) {
			$filename = $wgAutoloadLocalClasses[$className];
		} elseif ( isset( $wgAutoloadClasses[$className] ) ) {
			$filename = $wgAutoloadClasses[$className];
		} else {
			# Try a different capitalisation
			# The case can sometimes be wrong when unserializing PHP 4 objects
			$filename = false;
			$lowerClass = strtolower( $className );

			foreach ( $wgAutoloadLocalClasses as $class2 => $file2 ) {
				if ( strtolower( $class2 ) == $lowerClass ) {
					$filename = $file2;
				}
			}

			if ( !$filename ) {
				if ( function_exists( 'wfDebug' ) ) {
					wfDebug( "Class {$className} not found; skipped loading\n" );
				}

				# Give up
				return false;
			}
		}

		# Make an absolute path, this improves performance by avoiding some stat calls
		if ( substr( $filename, 0, 1 ) != '/' && substr( $filename, 1, 1 ) != ':' ) {
			global $IP;
			$filename = "$IP/$filename";
		}

		require $filename;

		return true;
	}

	/**
	 * Force a class to be run through the autoloader, helpful for things like
	 * Sanitizer that have define()s outside of their class definition. Of course
	 * this wouldn't be necessary if everything in MediaWiki was class-based. Sigh.
	 *
	 * @param $class string
	 * @return Boolean Return the results of class_exists() so we know if we were successful
	 */
	static function loadClass( $class ) {
		return class_exists( $class );
	}
}

spl_autoload_register( array( 'AutoLoader', 'autoload' ) );
