<?php
/**
 * Internationalisation file for the reCAPTCHA module of the ConfirmEdit
 * extension.
 *
 * @addtogroup Extensions
*/

$messages = array();

$messages['en'] = array(
	'recaptcha-desc' => 'reCAPTCHA module for Confirm Edit',
	'recaptcha-edit' => 'To protect the wiki against automated edit spam, we kindly ask you to type the two words you see in the box below:',
	'recaptcha-addurl' => 'Your edit includes new external links. To protect the wiki against automated spam, we kindly ask you to type the two words you see in the box below:',
	'recaptcha-badlogin' => 'To protect the wiki against automated password cracking, we kindly ask you to type the two words you see in the box below:',
	'recaptcha-createaccount' => 'To protect the wiki against automated account creation, we kindly ask you to type the two words you see in the box below:',
	'recaptcha-createaccount-fail' => "Incorrect or missing reCAPTCHA answer.",
	'recaptcha-create' => 'To protect the wiki against automated page creation, we kindly ask you to type the two words you see in the box below:',
);

/** Message documentation (Message documentation)
 * @author Raymond
 * @author Shirayuki
 * @author Umherirrender
 */
$messages['qqq'] = array(
	'recaptcha-desc' => '{{Optional}}
{{desc}}',
	'recaptcha-edit' => '{{Related|ConfirmEdit-edit}}',
	'recaptcha-addurl' => '{{Related|ConfirmEdit-addurl}}',
	'recaptcha-badlogin' => '{{Related|ConfirmEdit-badlogin}}',
	'recaptcha-createaccount' => '{{Related|ConfirmEdit-createaccount}}',
	'recaptcha-createaccount-fail' => '{{Related|ConfirmEdit-createaccount-fail}}',
	'recaptcha-create' => '{{Related|ConfirmEdit-create}}',
);

/** Arabic (العربية)
 * @author Alexknight12
 * @author Ciphers
 * @author Meno25
 */
$messages['ar'] = array(
	'recaptcha-desc' => 'موديل reCAPTCHA لConfirm Edit',
	'recaptcha-edit' => 'للمساعدة في الحماية ضد التحرير السبام، يرجى كتابة الكلمتين التي تراها في المربع أدناه :', # Fuzzy
	'recaptcha-addurl' => 'إن تعديلك يتضمن وصلات خارجية جديدة. للمساعدة في الحماية ضد السبام، يرجى كتابة الكلمتين التي تراها في المربع أدناه :', # Fuzzy
	'recaptcha-badlogin' => 'للمساعدة في الحماية ضد الكسر الآلي لكلمة السر، يرجى كتابة الكلمتين اللتين تراهما في المربع أدناه :', # Fuzzy
	'recaptcha-createaccount' => 'للمساعدة في الحماية ضد الإنشاء الآلي للحسابات، رجاء اكتب الكلمتين اللتين تراهما في المربع أدناه:', # Fuzzy
	'recaptcha-createaccount-fail' => 'جواب reCAPTCHA غير صحيح أو مفقود.',
	'recaptcha-create' => 'للمساعدة في الحماية ضد الإنشاء الآلي للصفحات، يرجى كتابة الكلمتين اللتين تراهما في المربع أدناه :', # Fuzzy
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'recaptcha-edit' => "Pa protexer la wiki escontra'l spam d'edición automáticu, pidimos-y qu'escriba les dos pallabres que se ven na caxella d'abaxo:",
	'recaptcha-addurl' => "La so edición incluye enllaces esternos nuevos. Pa protexer la wiki escontra'l spam automáticu, pidimos-y qu'escriba les dos pallabres que se ven na caxella d'abaxo:",
	'recaptcha-badlogin' => "Pa protexer la wiki escontra'l descifráu de claves automáticu, pidimos-y qu'escriba les dos pallabres que se ven na caxella d'abaxo:",
	'recaptcha-createaccount' => "Pa protexer la wiki escontra la creación de cuentes automática, pidimos-y qu'escriba les dos pallabres que se ven na caxella d'abaxo:",
	'recaptcha-createaccount-fail' => 'Falta la rempuesta a la entruga de reCAPTCHA o ye incorreuta',
	'recaptcha-create' => "Pa protexer la wiki escontra la creación de páxines automática, pidimos-y qu'escriba les dos pallabres que se ven na caxella d'abaxo:",
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'recaptcha-edit' => 'Для абароны супраць спаму, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:', # Fuzzy
	'recaptcha-addurl' => 'Вашае рэдагаваньне ўтрымлівае новыя вонкавыя спасылкі. Для абароны супраць спаму, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:', # Fuzzy
	'recaptcha-badlogin' => 'Для абароны супраць узлому паролю, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:', # Fuzzy
	'recaptcha-createaccount' => 'Для абароны супраць аўтаматычнага стварэньня рахункаў, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Адказ reCAPTCHA няслушны ці адсутнічае.',
	'recaptcha-create' => 'Для абароны супраць аўтаматычнага стварэньня старонак, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:', # Fuzzy
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 */
$messages['br'] = array(
	'recaptcha-edit' => "Evit sikour en em wareziñ diouzh ar stroboù emgefre, merkit an daou c'her a welit er voest dindan :",
	'recaptcha-addurl' => "Liamm diavaez nevez zo bet degaset ganeoc'h. Evit sikour en em wareziñ diouzh ar stroboù, merkit an daou c'her a welit er voest dindan :",
	'recaptcha-badlogin' => "Da sikour en em wareziñ diouzh an diskuliañ gerioù-tremen emgefre dre daolioù-esae, merkit an daou c'her a welit er voest dindan :", # Fuzzy
	'recaptcha-createaccount' => "Da sikour en em wareziñ diouzh ar c'hrouiñ kontoù emgefre, merkit an daou c'her a welit er voest dindan :", # Fuzzy
	'recaptcha-createaccount-fail' => 'Respont reCAPTHCA faziek pe ezvezant.',
	'recaptcha-create' => "Da sikour en em wareziñ diouzh ar c'hrouiñ pajennoù emgefre, merkit an daou c'her a welit er voest dindan :", # Fuzzy
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'recaptcha-edit' => 'Da bismo pomogli protiv automatiziranog spam uređivanja, molimo upišite dvije riječi koje vidite u kutiju ispod:', # Fuzzy
	'recaptcha-addurl' => 'Vaše izmjene uključuju nove vanjske linkove. Da bismo pomogli protiv automatiziranog spama, molimo upišite dvije riječi koje vidite u kutiju ispod.', # Fuzzy
	'recaptcha-badlogin' => 'Da bismo pomogli protiv automatiziranog probijanja šifre, molimo upišite dvije riječi koje vidite u kutiju ispod:', # Fuzzy
	'recaptcha-createaccount' => 'Da bismo pomogli protiv automatiziranog pravljenja računa, molimo upišite dvije riječi koje vidite u kutiju ispod:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Neispravan ili nedostajući reCAPTCHA odgovor.',
	'recaptcha-create' => 'Da bismo pomogli protiv automatiziranog pravljenja stranica, molimo upišite dvije riječi koje vidite u kutiju ispod:', # Fuzzy
);

/** Czech (česky)
 * @author Jkjk
 * @author Mormegil
 */
$messages['cs'] = array(
	'recaptcha-desc' => 'Podpora reCAPTCHA pro rozšíření Confirm Edit',
	'recaptcha-edit' => 'V zájmu ochrany před automatickým spamováním opište dvě slova, která vidíte na obrázku:', # Fuzzy
	'recaptcha-addurl' => 'Vaše editace obsahuje nové externí odkazy. V zájmu ochrany před automatickým spamováním opište dvě slova, která vidíte na obrázku:', # Fuzzy
	'recaptcha-badlogin' => 'V zájmu ochrany proti automatickým pokusům uhodnout heslo opište dvě slova, která vidíte na obrázku:', # Fuzzy
	'recaptcha-createaccount' => 'V rámci ochrany před automatickým vytvářením účtů opište dvě slova, která vidíte na obrázku:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Nesprávná nebo chybějící odpověď na reCAPTCHA.',
	'recaptcha-create' => 'V zájmu ochrany před automatickým zakládáním stránek opište dvě slova, která vidíte na obrázku:', # Fuzzy
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'recaptcha-edit' => "Er mwyn arbed y wici rhag i olygyddion awtomatig osod sbam, byddwch gystal â theipio'r ddau air sydd i'w gweld yn y blwch isod:",
	'recaptcha-addurl' => "Mae'ch golygiad yn cynnwys cysylltiadau allanol newydd. Er mwyn arbed y wici rhag sbam awtomatig, byddwch gystal â theipio'r ddau air sydd i'w gweld yn y blwch isod:",
	'recaptcha-badlogin' => "Er mwyn arbed y wici rhag peiriannau sy'n datrys cyfrineiriau'n awtomatig, byddwch gystal â theipio'r ddau air sydd i'w gweld yn y blwch isod:",
	'recaptcha-createaccount' => "Er mwyn arbed y wici rhag peiriannau sy'n dechrau cyfrifon yn awtomatig, byddwch gystal â theipio'r ddau air sydd i'w gweld yn y blwch isod:",
	'recaptcha-createaccount-fail' => "Mae'r ateb i'r pos CAPTCHA yn anghywir neu yn eisiau.",
	'recaptcha-create' => "Er mwyn arbed y wici rhag peiriannau sy'n dechrau tudalennau yn awtomatig, byddwch gystal â theipio'r ddau air sydd i'w gweld yn y blwch isod:",
);

/** German (Deutsch)
 * @author Kghbln
 * @author Metalhead64
 * @author Umherirrender
 */
$messages['de'] = array(
	'recaptcha-desc' => 'reCAPTCHA-Module für die Erweiterung „Confirm Edit“',
	'recaptcha-edit' => 'Zum Schutz des Wikis vor automatisiertem Spam bitten wir dich, die beiden folgenden Wörter in das untenstehende Feld einzugeben:',
	'recaptcha-addurl' => 'Deine Bearbeitung enthält neue externe Links. Zum Schutz des Wikis vor automatisiertem Spam bitten wir dich, die beiden folgenden Wörter in das folgende Feld einzugeben:',
	'recaptcha-badlogin' => 'Zum Schutz des Wikis gegen automatisiertes Knacken von Passwörtern bitten wir dich, die beiden folgenden Wörter in das folgende Feld einzugeben:',
	'recaptcha-createaccount' => 'Zum Schutz des Wikis gegen die automatisierte Erstellung von Benutzerkonten bitten wir dich, die folgenden beiden Wörter in das untenstehende Feld einzugeben:',
	'recaptcha-createaccount-fail' => 'Fehlerhafte oder fehlende reCAPTCHA Antwort.',
	'recaptcha-create' => 'Zum Schutz des Wikis gegen automatisierte Erstellung von Seiten bitten wir dich, die beiden folgenden Wörter in das folgende Feld einzugeben:',
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author Kghbln
 */
$messages['de-formal'] = array(
	'recaptcha-createaccount' => 'Zum Schutz gegen die automatisierte Erstellung von Benutzerkonten bitten wir Sie, die folgenden beiden Wörter in das untenstehende Feld einzugeben:', # Fuzzy
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'recaptcha-createaccount-fail' => 'Wopacne abo felujuce wótegrono reCAPTCHA.',
);

/** Spanish (español)
 * @author Fitoschido
 */
$messages['es'] = array(
	'recaptcha-edit' => 'Para protegernos de la publicidad automatizada, escribe las dos palabras visibles en el cuadro de abajo:', # Fuzzy
	'recaptcha-addurl' => 'Tu edición incluye nuevos enlaces externos. Para ayudar a protegernos contra el spam automatizado, por favor, escribe las dos palabras que ves en el cuadro a continuación:', # Fuzzy
	'recaptcha-badlogin' => 'Para protegernos del robo automatizado de contraseñas, escribe las dos palabras visibles en el cuadro de abajo:', # Fuzzy
	'recaptcha-createaccount' => 'Para protegernos de la creación automática de cuentas, escribe las dos palabras que ves en el cuadro de abajo:', # Fuzzy
	'recaptcha-createaccount-fail' => 'ReCAPTCHA incorrecto o sin responder.',
	'recaptcha-create' => 'Para protegernos de la creación automática de páginas, escribe las dos palabras que ves en el cuadro de abajo:', # Fuzzy
);

/** Finnish (suomi)
 * @author Nedergard
 * @author VezonThunder
 */
$messages['fi'] = array(
	'recaptcha-edit' => 'Suojana automaattisia roskamuokkauksia vastaan sinun on syötettävä kaksi näkemääsi sanaa laatikkoon alla:', # Fuzzy
	'recaptcha-addurl' => 'Muokkauksesi sisältää uusia ulkoisia linkkejä. Suojana automaattista roskapostia vastaan sinun on syötettävä kaksi näkemääsi sanaa laatikkoon alla:', # Fuzzy
	'recaptcha-badlogin' => 'Suojana automaattisia salasanamurtoja vastaan sinun on syötettävä kaksi näkemääsi sanaa laatikkoon alla:', # Fuzzy
	'recaptcha-createaccount' => 'Suojana automaattista tunnusten luontia vastaan sinun on syötettävä kaksi näkemääsi sanaa laatikkoon alla:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Väärä tai puuttuva reCAPTCHA-vastaus.',
	'recaptcha-create' => 'Suojana automaattista sivujen luontia vastaan sinun on syötettävä kaksi näkemääsi sanaa laatikkoon alla:', # Fuzzy
);

/** French (français)
 * @author Gomoko
 * @author Urhixidur
 */
$messages['fr'] = array(
	'recaptcha-edit' => 'Afin de protéger le wiki du spam des modifications automatisées, nous vous demandons de bien vouloir écrire les deux mots visibles dans le cadre ci-dessous :',
	'recaptcha-addurl' => 'Votre contribution contient des liens vers un site externe. Pour protéger le wiki contre le spam automatisé, nous vous demandons de bien vouloir écrire les deux mots visibles dans le cadre qui suit :',
	'recaptcha-badlogin' => 'Pour protéger le wiki des essais automatiques de cassage de mot de passe, nous vous demandons de bien vouloir écrire les deux mots visibles dans le cadre qui suit:',
	'recaptcha-createaccount' => 'Pour protéger le wiki des créations automatiques de compte, nous vous demandons de bien vouloir écrire les deux mots visibles dans le cadre qui suit :',
	'recaptcha-createaccount-fail' => 'Réponse de reCAPTCHA fausse ou manquante.',
	'recaptcha-create' => 'Pour protéger le wiki des créations automatiques de pages, nous vous demandons de bien vouloir écrire les deux mots visibles dans le cadre qui suit :',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'recaptcha-desc' => 'Módulo de reCAPTCHA para Confirm Edit',
	'recaptcha-edit' => 'Para protexer o wiki contra o spam automático, introduza as dúas palabras que vexa na caixa:',
	'recaptcha-addurl' => 'A súa edición inclúe novas ligazóns externas. Para protexer o wiki contra o spam automático, introduza as dúas palabras que vexa na caixa:',
	'recaptcha-badlogin' => 'Para protexer o wiki contra o roubo de contrasinais, introduza as dúas palabras que vexa na caixa:',
	'recaptcha-createaccount' => 'Para protexer o wiki contra a creación automática de contas, introduza as dúas palabras que vexa na caixa:',
	'recaptcha-createaccount-fail' => 'Falta a resposta ao reCAPTCHA ou esta é incorrecta.',
	'recaptcha-create' => 'Para protexer o wiki contra a creación automática de páxinas, introduza as dúas palabras que vexa na caixa:',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'recaptcha-edit' => 'Zum Schutz vor automatisiertem Spam, gib bitte di beide Werter in s Fäld unten yy:', # Fuzzy
	'recaptcha-addurl' => 'In Dyre Bearbeitg het s neji extärni Links. Zum Schutz vor automatisiertem Spam, gib bitte di beide Werter in s Fäld unten yy:', # Fuzzy
	'recaptcha-badlogin' => 'Zum Schutz gege automatisiert Knacken vu Passwerter, gib bitte di beide Werter in s Fäld unten yy:', # Fuzzy
	'recaptcha-createaccount' => 'Zum Schutz gege s automatisiert Aalege vu Benutzerkonte, gib bitte di beide Werter in s Fäld unten yy:', # Fuzzy
	'recaptcha-createaccount-fail' => 'D reCAPTCHA-Antwort isch fählerhaft oder si fählt.',
	'recaptcha-create' => 'Zum Schutz gege s automatisiert Aalege vu Syte, gib bitte di beide Werter in s Fäld unten yy:', # Fuzzy
);

/** Hebrew (עברית)
 */
$messages['he'] = array(
	'recaptcha-edit' => 'אינכם משתמש רשום.כהגנה מפני ספאם אוטומטי, אנא הקלידו את שתי המילים שלהלן. תודה.', # Fuzzy
	'recaptcha-addurl' => 'אינכם משתמש רשום.כהגנה מפני ספאם אוטומטי, אנא הקלידו את שתי המילים שלהלן. תודה.', # Fuzzy
	'recaptcha-badlogin' => 'כהגנה מפני מפצחי סיסמאות אוטומטיים אנא הקלידו את שתי המילים שלהלן:', # Fuzzy
	'recaptcha-createaccount' => 'כהגנה מפני יצירת חשבונות פיקטיביים ע"י אוטומטים אנא הקלידו את שתי המילים שלהלן:', # Fuzzy
	'recaptcha-createaccount-fail' => 'לא הוקלדו מילות האישור, או שהוקלדו מילים לא נכונות. נסו שנית.',
	'recaptcha-create' => 'אינכם משתמש רשום.כהגנה מפני ספאם אוטומטי, אנא הקלידו את שתי המילים שלהלן. תודה.', # Fuzzy
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'recaptcha-edit' => 'Za škit přećiwo awtomatizowanemu spamej, prošu zapisaj dwě słowje, kotrejž w slědowacym polu widźiš:', # Fuzzy
	'recaptcha-addurl' => 'Twoja změna wobsahuje nowe eksterne wotkazy. Za škit přećiwo awtomatizowanemu spamej, prošu zapisaj dwě słowje, kotrerjž w slědowacym polu widźiš:', # Fuzzy
	'recaptcha-badlogin' => 'Za škit přećiwo awtomatizowanemu złamanju hesłow, zapisaj prošu wobě słowje, kotrejž widźiš, do slědowaceho pola:', # Fuzzy
	'recaptcha-createaccount' => 'Za škit přećiwo awtomatiskemu wutworjenju konta, prošu zapisaj tej wobě słowje, kotrejž w slědowacym polu widźiš:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Wopačna abo falowaca wotmołwa reCAPTCHA.',
	'recaptcha-create' => 'Za škit přećiwo awtomatiskemu wutworjenju strony, prošu zapisaj tej wobě słowje, kotrejž w slědowacym polu widźiš:', # Fuzzy
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'recaptcha-edit' => 'Pro adjutar a proteger le wiki contra le spam automatisate, per favor dactylographa le duo parolas que tu vide in le quadro sequente:',
	'recaptcha-addurl' => 'Iste modification include nove ligamines externe. Pro adjutar a proteger le wiki contra le spam automatisate, per favor dactylographa le duo parolas que tu vide in le quadro sequente:',
	'recaptcha-badlogin' => 'Pro adjutar a proteger le wiki contra le furto automatisate de contrasignos, per favor dactylographa le duo parolas que tu vide in le quadro sequente:',
	'recaptcha-createaccount' => 'Pro adjutar a proteger le wiki contra le creation automatisate de contos, per favor dactylographa le duo parolas que tu vide in le quadro sequente:',
	'recaptcha-createaccount-fail' => 'Responsa reCAPTCHA incorrecte o mancante.',
	'recaptcha-create' => 'Pro adjutar a proteger le wiki contra le creation automatisate de paginas, per favor dactylographa le duo parolas que tu vide in le quadro sequente:',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 */
$messages['id'] = array(
	'recaptcha-edit' => 'Untuk membantu pelindungan terhadap spam penyuntingan otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:', # Fuzzy
	'recaptcha-addurl' => 'Suntingan Anda menyertakan pranala eksternal baru. Untuk membantu pelindungan terhadap spam otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:', # Fuzzy
	'recaptcha-badlogin' => 'Untuk membantu pelindungan terhadap perengkahan sandi otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:', # Fuzzy
	'recaptcha-createaccount' => 'Untuk membantu pelindungan terhadap pembuatan akun otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Jawaban reCAPTCHA tidak benar atau tidak dimasukkan.',
	'recaptcha-create' => 'Untuk membantu pelindungan terhadap pembuatan halaman otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:', # Fuzzy
);

/** Italian (italiano)
 * @author Beta16
 * @author Nemo bis
 */
$messages['it'] = array(
	'recaptcha-edit' => 'Per proteggere il wiki dalle modifiche automatiche che aggiungono spam, ti chiediamo gentilmente di scrivere le due parole mostrate nel riquadro sottostante:',
	'recaptcha-addurl' => 'La tua modifica aggiunge qualche nuovo collegamento esterno. Per proteggere il wiki dallo spam automatico, ti chiediamo gentilmente di scrivere le due parole mostrate nel riquadro sottostante:',
	'recaptcha-badlogin' => 'Per proteggere il wiki dalla forzatura automatica delle password, ti chiediamo gentilmente di scrivere le due parole mostrate nel riquadro sottostante:',
	'recaptcha-createaccount' => 'Per proteggere il wiki dalla creazione automatica di nuovi accessi, ti chiediamo gentilmente di scrivere le due parole mostrate nel riquadro sottostante:',
	'recaptcha-createaccount-fail' => 'Risposta reCAPTCHA mancante o errata.',
	'recaptcha-create' => 'Per proteggere il wiki dalla creazione automatica di pagine, ti chiediamo gentilmente di scrivere le due parole mostrate nel riquadro sottostante:',
);

/** Japanese (日本語)
 * @author Shirayuki
 */
$messages['ja'] = array(
	'recaptcha-desc' => 'Confirm Edit 用 reCAPTCHA モジュール',
	'recaptcha-edit' => 'ウィキへの自動編集スパム攻撃を防ぐため、お手数をおかけしますが下の画像に表示されている 2 つの単語を入力してください:',
	'recaptcha-addurl' => 'あなたは新しい外部リンクを追加しようとしています。ウィキへの自動スパム攻撃を防ぐため、お手数をおかけしますが下の画像に表示されている 2 つの単語を入力してください:',
	'recaptcha-badlogin' => 'ウィキへの自動パスワードクラック攻撃を防ぐため、お手数をおかけしますが下の画像に表示されている 2 つの単語を入力してください:',
	'recaptcha-createaccount' => 'ウィキでのアカウント自動作成を防ぐため、お手数をおかけしますが下の画像に表示されている 2 つの単語を入力してください:',
	'recaptcha-createaccount-fail' => '文字列が正しくない、または入力されていません。',
	'recaptcha-create' => 'ウィキでのページの自動作成を防ぐため、お手数をおかけしますが下の画像に表示されている 2 つの単語を入力してください:',
);

/** Korean (한국어)
 * @author 아라
 */
$messages['ko'] = array(
	'recaptcha-desc' => '편집 확인에 대한 reCAPCHA 모듈',
	'recaptcha-edit' => '자동화된 편집 스팸으로부터 보호하기 위해, 아래 상자에 보이는 두 낱말을 입력하세요:', # Fuzzy
	'recaptcha-addurl' => '편집에 새로운 바깥 링크가 포함되어 있습니다. 자동화된 스팸으로부터 보호하기 위해, 아래 상자에 보이는 두 낱말을 입력하세요:', # Fuzzy
	'recaptcha-badlogin' => '자동화된 비밀번호 깨기로부터 보호하기 위해, 아래 상자에 보이는 두 낱말을 입력하세요:', # Fuzzy
	'recaptcha-createaccount' => '자동화된 계정 만들기로부터 보호하기 위해, 아래 상자에 보이는 두 낱말을 입력하세요:', # Fuzzy
	'recaptcha-createaccount-fail' => 'reCAPTCHA 답이 올바르지 않거나 없습니다.',
	'recaptcha-create' => '자동화된 문서 만들기로부터 보호하기 위해, 아래 상자에 보이는 두 낱말을 입력하세요:', # Fuzzy
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'recaptcha-edit' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje et automattesche Ändere un SPAM em Wiki schöze.', # Fuzzy
	'recaptcha-addurl' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje automattesch en et Wiki jebraate SPAM schöze, nohdämm en Dingem Beidraach {{PLURAL:$1|ene neue Lengk dren es|neue Lengks dren sin|kein neue Lengks dren sin}}.', # Fuzzy
	'recaptcha-badlogin' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje et automattesche Paßwoot Knacke em Wiki schöze.', # Fuzzy
	'recaptcha-createaccount' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje SPAM un automattesch aanjelaate Zohjäng nohm Wiki schöze.', # Fuzzy
	'recaptcha-createaccount-fail' => 'Dat wohr en verkehte udder jaa kei Antwoot op dat Kaptscha.', # Fuzzy
	'recaptcha-create' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje SPAM un automattesch aanjelaate Sigge em Wiki schöze.', # Fuzzy
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'recaptcha-edit' => "Fir d'Wiki géint automatiséierte Spam ze schützen, froe mir Iech déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner anzeginn:",
	'recaptcha-addurl' => "An Ärer Ännerung sinn nei extern Linken! Fir dës Wikie géint automatiséierte Spam ze schütze, froe mir Iech déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner anzeginn:",
	'recaptcha-badlogin' => "Fir d'Wiki géint d'automatiséiert Hacke vu Passwierder ze schützen, froe mir Iech déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner anzeginn:",
	'recaptcha-createaccount' => "Fir d'Wiki géint d'automatiséiert Uleeë vu Benotzerkonten ze schützen, froe mir Iech déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner anzeginn:",
	'recaptcha-createaccount-fail' => 'reCAPTCHA Äntwert feelt oder ass net korrekt.',
	'recaptcha-create' => "Fir d'Wiki géint d'automatiséiert Uleeë vu Säiten ze schützen, froe mir Iech déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner anzeginn:",
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'recaptcha-desc' => 'Модул reCAPTCHA за потврда на уредувања',
	'recaptcha-edit' => 'Како заштитна мерка против автоматизиран спам, би ве замолиле да ги внесете двата збора прикажани во полето:',
	'recaptcha-addurl' => 'Во вашите измени има нови надворешни врски. Како заштитна мерка против автоматизиран спам, би ве замолиле да внесете двата збора прикажани во полето:',
	'recaptcha-badlogin' => 'Како заштитна мерка против автоматизирано провалување на лозинки, би ве замолиле да внесете двата збора прикажани во полето:',
	'recaptcha-createaccount' => 'Како заштитна мерка против автоматизирано создавање на сметки, би ве замолиле да внесете двата збора прикажани во полето:',
	'recaptcha-createaccount-fail' => 'reCAPTCHA доби погрешен одговор или одговорот недостасува.',
	'recaptcha-create' => 'Како заштитна мерка против автоматизирано создавање на страници, би ве замолиле да внесете двата збора прикажани во полето:',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'recaptcha-edit' => 'Untuk membanteras kegiatan spam automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:', # Fuzzy
	'recaptcha-addurl' => 'Suntingan anda termasuk pautan luar baru. Untuk membanteras kegiatan spam automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:', # Fuzzy
	'recaptcha-badlogin' => 'Untuk membanteras kegiatan meneka kata laluan secara automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:', # Fuzzy
	'recaptcha-createaccount' => 'Untuk membanteras kegiatan membuka akaun secara automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Jawapan reCAPTCHA tidak betul atau tidak ada.',
	'recaptcha-create' => 'Untuk membanteras kegiatan mencipta laman secara automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:', # Fuzzy
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'recaptcha-edit' => "Sabiex tgħinna nipproteġu kontra l-modifiki li jżidu spam, jekk jogħġbok ikteb iż-żewġ kelmiet li tara fil-kaxxa t'hawn taħt:", # Fuzzy
	'recaptcha-addurl' => "Il-modifika tiegħek tinkludi ħoloq esterni ġodda. Sabiex tipproteġi kontra spam awtomatiku, jekk jogħġbok ikteb iż-żewġ kelmiet li tara fil-kaxxa t'hawn taħt:", # Fuzzy
	'recaptcha-badlogin' => "Sabiex tgħinna nipproteġu kontra l-infurzar awtomatiku tal-passwords, jekk jogħġbok ikteb iż-żewġ kelmiet li tara fil-kaxxa t'hawn taħt:", # Fuzzy
	'recaptcha-createaccount' => "Sabiex tgħinna nipproteġu kontra l-ħolqien awtomatiku ta' kontijiet ġodda, jekk jogħġbok ikteb iż-żewġ kelmiet li tara fil-kaxxa t'hawn taħt:", # Fuzzy
	'recaptcha-createaccount-fail' => 'Tweġiba reCAPTCHA ħażina jew nieqsa.',
	'recaptcha-create' => "Sabiex tgħinna nipproteġu kontra l-ħolqien awtomatiku ta' paġni, jekk jogħġbok ikteb iż-żewġ kelmiet li tara fil-kaxxa t'hawn taħt:", # Fuzzy
);

/** Norwegian Bokmål (norsk bokmål)
 * @author Event
 */
$messages['nb'] = array(
	'recaptcha-edit' => 'Som beskyttelse mot automatisk redigert spam, vennligst skriv inn de to ordene du ser i boksen under:', # Fuzzy
	'recaptcha-addurl' => 'Din redigering inneholder nye eksterne lenker. Som beskyttelse mot automatisk spam, vennligst skriv inn de to ordene du ser i boksen under:', # Fuzzy
	'recaptcha-badlogin' => 'Som beskyttelse mot automatisk passordknekking, vennligst skriv inn de to ordene du ser i boksen under:', # Fuzzy
	'recaptcha-createaccount' => 'Som beskyttelse mot automatisk opprettelse av brukerkonto, vennligst skriv inn de to ordene du ser i boksen under:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Feil eller manglende reCAPTCHA-svar.',
	'recaptcha-create' => 'Som beskyttelse mot automatisk opprettelse av side, vennligst skriv inn de to ordene du ser i boksen under:', # Fuzzy
);

/** Dutch (Nederlands)
 * @author HanV
 * @author Siebrand
 */
$messages['nl'] = array(
	'recaptcha-edit' => 'Voer ter bescherming tegen geautomatiseerde spam de twee woorden in die u in het onderstaande venster ziet:',
	'recaptcha-addurl' => 'Uw bewerking bevat nieuwe externe koppelingen. Voer ter bescherming tegen geautomatiseerde spam de twee woorden in die u ziet in het onderstaande venster:',
	'recaptcha-badlogin' => 'Voer ter bescherming tegen het automatisch kraken van wachtwoorden de twee woorden in die u ziet in het invoervenster:',
	'recaptcha-createaccount' => 'Om het automatisch aanmaken van gebruikers tegen te gaan moet u de twee woorden in het onderstaande venster invoeren:',
	'recaptcha-createaccount-fail' => 'Het reCAPTCHA-antwoord is onjuist of niet ingevoerd.',
	'recaptcha-create' => 'Om het automatisch aanmaken van een pagina tegen te gaan moet u de twee woorden invoeren die in het onderstaande veld staan:',
);

/** Nederlands (informeel)‎ (Nederlands (informeel)‎)
 * @author Siebrand
 */
$messages['nl-informal'] = array(
	'recaptcha-edit' => 'Voer ter bescherming tegen geautomatiseerde spam de twee woorden die je ziet in het invoervenster in:', # Fuzzy
	'recaptcha-addurl' => 'Je bewerking bevat nieuwe externe koppelingen. Voer ter bescherming tegen geautomatiseerde spam de twee woorden die je ziet in het invoervenster in:', # Fuzzy
	'recaptcha-badlogin' => 'Voer ter bescherming tegen het automatisch kraken van wachtwoorden de twee woorden die je ziet in het invoervenster in:', # Fuzzy
	'recaptcha-createaccount' => 'Om het automatisch aanmaken van gebruikers tegen te gaan moet je de twee woorden die je ziet invoeren:', # Fuzzy
	'recaptcha-create' => "Om het automatisch aanmaken van pagina's tegen te gaan moet je de twee woorden die je ziet invoeren:", # Fuzzy
);

/** Occitan (occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'recaptcha-createaccount-fail' => 'Responsa de reCAPTCHA faussa o mancanta.',
);

/** Polish (polski)
 * @author WTM
 */
$messages['pl'] = array(
	'recaptcha-edit' => 'Aby uchronić nas przed robotami, proszę wpisać dwa widoczne słowa w poniższym polu:', # Fuzzy
	'recaptcha-addurl' => 'Twoja edycja zawiera linki zewnętrzne. Aby uchronić nas przed robotami, proszę wpisać dwa widoczne słowa w poniższym polu:', # Fuzzy
	'recaptcha-badlogin' => 'Aby uchronić nas przed złamaniem automatycznym haseł, proszę wpisać dwa widoczne słowa w poniższym polu:', # Fuzzy
	'recaptcha-createaccount' => 'Aby uchronić nas przed automatycznym tworzeniem użytkowników, proszę wpisać dwa widoczne słowa w poniższym polu:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Odpowiedź na reCAPTCHA jest fałszywa lub brakująca.',
	'recaptcha-create' => 'Aby uchronić nas przed tworzeniem stron przez robotów, proszę wpisać dwa widoczne słowa w poniższym polu:', # Fuzzy
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'recaptcha-edit' => "Për giuté a protege contra la rumenta dle modìfiche automàtiche, për piasì ch'a scriva le doe paròle ch'a s-ciàira ant ël quàder sì-sota:", # Fuzzy
	'recaptcha-addurl' => "Soa modìfica a conten d'anliure esterne neuv. Për giuté a protege contra la rumenta dle modìfiche automàtiche, për piasì ch'a scriva le doe paròle ch'a s-ciàira ant ël quàder sì-sota:", # Fuzzy
	'recaptcha-badlogin' => "Për giuté a protege contra la forsadura automatisà ëd le ciav, për piasì ch'a scriva le doe paròle ch'a s-ciàira ant ël formolari sì-sota:", # Fuzzy
	'recaptcha-createaccount' => "Për giuté a protege contra la creassion automatisà ëd cont, për piasì ch'a scriva le doe paròle ch'a s-ciàira ant ël formolari sì-sota:", # Fuzzy
	'recaptcha-createaccount-fail' => 'Rispòsta ëd reCAPTCHA fàussa o mancanta.',
	'recaptcha-create' => "Për giuté a protege contra la creassion automatisà ëd pàgine, për piasì ch'a scriv le doe paròle ch'a s-ciàira ant la casela sì-sota:", # Fuzzy
);

/** Portuguese (português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'recaptcha-edit' => 'Para proteger-nos de spam, por favor escreva  as duas palavras visíveis abaixo:', # Fuzzy
	'recaptcha-addurl' => "A sua edição contém links externos novos. Como prevenção contra sistemas automatizados de inserção de ''spam'', escreva as duas palavras visíveis na caixa abaixo:", # Fuzzy
	'recaptcha-badlogin' => 'Para proteger-nos de robots que tentam adivinhar senhas, por favor escreva  as duas palavras visíveis abaixo:', # Fuzzy
	'recaptcha-createaccount' => 'Para proteger-nos de criação automática de contas, por favor escreva  as duas palavras visíveis abaixo:', # Fuzzy
	'recaptcha-createaccount-fail' => 'A resposta ao reCAPTCHA é errada.',
	'recaptcha-create' => 'Para proteger-nos da criação automática de páginas, por favor escreva  as duas palavras visíveis abaixo:', # Fuzzy
);

/** Brazilian Portuguese (português do Brasil)
 */
$messages['pt-br'] = array(
	'recaptcha-edit' => 'Para ajudar a prevenir contra vandalismos, por favor digite as duas palavras que você vê na caixa abaixo:', # Fuzzy
	'recaptcha-addurl' => 'A sua edição inclui ligações externas. Para ajudar a prevenir contra vandalismos, por favor digite as duas palavras que você vê na caixa abaixo:', # Fuzzy
	'recaptcha-badlogin' => 'Para ajudar a prevenir contra tentativas de desbloquear senhas, por favor digite as duas palavras que você vê na caixa abaixo:', # Fuzzy
	'recaptcha-createaccount' => 'Para ajudar a prevenir contra criação automatizada de usuários, por favor digite as duas palavras que você vê na caixa abaixo:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Resposta incorreta ao reCAPTCHA.',
	'recaptcha-create' => 'Para ajudar a prevenir contra criação automatizada de páginas, por favor digite as duas palavras que você vê na caixa abaixo:', # Fuzzy
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'recaptcha-edit' => "Pe darne 'na màne a proteggere condre le cangiaminde automatece de le rummate, pe piacere scrive le doje parole ca 'ndruche jndr'à buatte aqquà sotte:", # Fuzzy
	'recaptcha-addurl' => "Le cangiaminde tune 'ngludone collegaminde de fore nuève. Pe darne 'na màne a proteggere condre le cangiaminde automatece de le rummate, pe piacere scrive le doje parole ca 'ndruche jndr'à buatte aqquà sotte:", # Fuzzy
	'recaptcha-badlogin' => "Pe darne 'na màne a proteggere condre le futteminde automatece de le passuord, pe piacere scrive le doje parole ca 'ndruche jndr'à buatte aqquà sotte:", # Fuzzy
	'recaptcha-createaccount' => "Pe darne 'na màne a proteggere condre le ccrejaziune automatece de le cunde, pe piacere scrive le doje parole ca 'ndruche jndr'à buatte aqquà sotte:", # Fuzzy
	'recaptcha-createaccount-fail' => 'Resposte reCAPTCHA ingorrette o mangande.',
	'recaptcha-create' => "Pe darne 'na màne a proteggere condre le ccrejaziune automatece de le pàggene, pe piacere scrive le doje parole ca 'ndruche jndr'à buatte aqquà sotte:", # Fuzzy
);

/** Russian (русский)
 * @author Okras
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'recaptcha-edit' => 'В целях защиты от автоматического спама в правках просим вас ввести два слова, которые вы видите ниже:',
	'recaptcha-addurl' => 'Ваша правка содержит новые внешние ссылки. В целях защиты от автоматического спама просим вас ввести два слова, которые вы видите в рамке ниже:',
	'recaptcha-badlogin' => 'В целях защиты от автоматического подбора пароля просим вас ввести два слова, которые вы видите в рамке ниже:',
	'recaptcha-createaccount' => 'В целях защиты от автоматического создания учётных записей просим вас ввести два слова, которые вы видите в рамке ниже:',
	'recaptcha-createaccount-fail' => 'Ответ reCAPTCHA неправильный или отсутствует.',
	'recaptcha-create' => 'В целях защиты от автоматического создания страниц просим вас ввести два слова, которые вы видите в рамке ниже:',
);

/** Sinhala (සිංහල)
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'recaptcha-createaccount-fail' => 'වැරදි හෝ දක්නට නොමැති reCAPTCHA පිළිතුර.',
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 */
$messages['sr-ec'] = array(
	'recaptcha-desc' => 'Модул reCAPTCHA за потврду уређивања',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 */
$messages['sr-el'] = array(
	'recaptcha-desc' => 'Modul reCAPTCHA za potvrdu uređivanja',
);

/** Swedish (svenska)
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'recaptcha-edit' => 'För att skydda wikin mot automatiskt redigerings-spam ber vi dig att skriva de två orden du ser i rutan nedan.',
	'recaptcha-addurl' => 'Din redigering innehåller nya externa länkar. För att skydda wikin mot automatiserat spam ber vi dig att skriva de två ordern du ser i rutan nedan:',
	'recaptcha-badlogin' => 'För att skydda wikin mot automatiserade försök att knäcka lösenord ber vi dig att skriva in de två orden du ser i rutan nedan:',
	'recaptcha-createaccount' => 'För att skydda wikin mot automatiskt kontoskapande ber vi dig att skriva de två orden som du ser i rutan nedan:',
	'recaptcha-createaccount-fail' => 'Du har angivit ett felaktig svar för reCAPTCHA.',
	'recaptcha-create' => 'För att skydda wikin mot automatiserade sidskapande ber vi dig att skriva in de två orden du ser i rutan nedan:',
);

/** Swahili (Kiswahili)
 * @author Lloffiwr
 */
$messages['sw'] = array(
	'recaptcha-edit' => 'Ili kusaidia kuzuia mashine zisihariri, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:', # Fuzzy
	'recaptcha-addurl' => 'Haririo lako lina viungo vipya vya nje. Ili kusaidia katika kuzuisha viungo visivyotakiwa visiwekwe na mashine, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:', # Fuzzy
	'recaptcha-badlogin' => 'Ili kusaidia katika kuzuia neno lako la siri lisigunduliwe na mashine, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:', # Fuzzy
	'recaptcha-createaccount' => 'Ili kusaidia kuzuia akaunti zisifunguliwe nyingi na mashine, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Jibu la swali la CAPTCHA si sahihi au halipo.', # Fuzzy
	'recaptcha-create' => 'Ili kusaidia kuzuia kurasa zisianzishwe nyingi na mashine, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:', # Fuzzy
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'recaptcha-desc' => 'Modulo ng reCAPTCHA para sa Pagtiyak ng Pagbago',
	'recaptcha-edit' => 'Upang makatulong sa pagprutekta laban sa kusang basurang pamamatnugot, paki imakinilya ang dalawang mga salitang nakikita mo sa loob ng kahong nasa ibaba:', # Fuzzy
	'recaptcha-addurl' => 'Ang pagbabago mo ay nagsasama ng bagong panlabas na mga kawing.  Upang makatulong sa pagprutekta laban sa kusang paglusob ng basurang-liham, paki imakinilya ang dalawang mga salitang nakikita sa loob ng kahong nasa ibaba:', # Fuzzy
	'recaptcha-badlogin' => 'Upang makatulong sa pagsasanggalang laban sa kusang panghuhula ng hudyat, paki imakinilya ang dalawang mga salitang nakikita mo sa loob ng kahong nasa ibaba:', # Fuzzy
	'recaptcha-createaccount' => 'Upang makatulong sa pagprutekta laban sa kusang paglikha ng akawnt, paki imakinilya ang dalawang mga salitang nakikita mo sa loob ng kahong nasa ibaba:', # Fuzzy
	'recaptcha-createaccount-fail' => 'Hindi tama o nawawalang sagot sa reCAPTCHA.',
	'recaptcha-create' => 'Upang makatulong sa pagprutekta laban sa kusang paglikha ng pahina, paki imakinilya ang dalawang mga salitang nakikita mo sa loob ng kahong nasa ibaba:', # Fuzzy
);

/** Ukrainian (українська)
 * @author Andriykopanytsia
 * @author Base
 * @author Тест
 */
$messages['uk'] = array(
	'recaptcha-edit' => 'Для запобігання автоматичному спаму у редагуваннях просимо вас ввести два слова, які Ви бачите у блоці нижче:',
	'recaptcha-addurl' => 'Ваше редагування містить зовнішні посилання. Для запобігання автоматичному спаму у редагуваннях просимо вас ввести два слова, які Ви бачите у блоці нижче:',
	'recaptcha-badlogin' => 'Для запобігання автоматичному підбору паролю просимо вас ввести два слова, які Ви бачите у блоці нижче:',
	'recaptcha-createaccount' => 'Для запобігання автоматичному створенню облікових записів просимо вас ввести два слова, які Ви бачите у блоці нижче:',
	'recaptcha-createaccount-fail' => 'Відповідь reCAPTCHA неправильна або відсутня.',
	'recaptcha-create' => 'З метою захисту вікі від автоматичного створення сторінки просимо вас ввести два слова, які ви бачите у блоці нижче:',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'recaptcha-desc' => 'Mô đun reCAPTCHA cho Confirm Edit',
	'recaptcha-edit' => 'Để giúp tránh các sửa đổi spam tự động, xin vui lòng gõ hai từ mà bạn nhìn thấy vào hộp dưới đây:',
	'recaptcha-addurl' => 'Sửa đổi của bạn có chứa liên kết ngoài mới. Để giúp tránh các sửa đổi spam tự động, xin vui lòng gõ hai từ mà bạn nhìn vào hộp dưới đây:',
	'recaptcha-badlogin' => 'Để giúp tránh bẻ khóa mật khẩu tự động, xin vui lòng gõ hai từ mà bạn nhìn vào hộp dưới đây:',
	'recaptcha-createaccount' => 'Để giúp tránh việc mở tài khoản tự động, xin vui lòng gõ hai từ mà bạn nhìn vào hộp dưới đây:',
	'recaptcha-createaccount-fail' => 'Thiếu câu trả lời reCAPTCHA hoặc câu trả lời không đúng.',
	'recaptcha-create' => 'Để giúp tránh việc tạo trang tự động, xin vui lòng gõ hai từ mà bạn nhìn vào hộp dưới đây:',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Hydra
 * @author Hzy980512
 * @author Onecountry
 */
$messages['zh-hans'] = array(
	'recaptcha-edit' => '为了避免垃圾用户自动编辑，请键入下面框中的两个单词：',
	'recaptcha-addurl' => '您的编辑包含新的外部链接。为了避免垃圾用户自动编辑，请键入下面框中的两个单词：',
	'recaptcha-badlogin' => '为避免自动密码破解，请键入下面框中的两个单词：',
	'recaptcha-createaccount' => '为了避免创建自动垃圾用户，请键入下面框中的两个单词：',
	'recaptcha-createaccount-fail' => 'reCAPTCHA 答案不正确或未填写。',
	'recaptcha-create' => '为了避免垃圾用户自动创建页面，请键入下面框中的两个单词：',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author StephDC
 */
$messages['zh-hant'] = array(
	'recaptcha-edit' => '為了防止wiki被自動編輯的垃圾損害，我們請您鍵入您在下面的框中看到的這兩個單詞：',
	'recaptcha-addurl' => '您的編輯包含新的外部鏈接。為了幫助防止自動垃圾郵件，請鍵入您在下面的框中看到這兩個詞：', # Fuzzy
	'recaptcha-badlogin' => '為幫助防止自動密碼破解，請鍵入您看到下面的框中的兩個字：', # Fuzzy
	'recaptcha-createaccount' => '為了幫助防止創建自動化的帳戶，請鍵入您在下面的框中看到的這兩個字：', # Fuzzy
	'recaptcha-createaccount-fail' => '不正確或缺失的 reCAPTCHA 答案。',
	'recaptcha-create' => '為了幫助防止自動的頁創建，請鍵入您在下面的框中看到這兩個詞：', # Fuzzy
);
