<?php
/**
 * Internationalisation file for the FancyCaptcha module of the ConfirmEdit
 * extension.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English */
$messages['en'] = array(
	'fancycaptcha-desc'          => 'Fancy CAPTCHA generator for Confirm Edit',
	'fancycaptcha-addurl'        => 'Your edit includes new external links.
To protect the wiki against automated spam, we kindly ask you to enter the words that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-badlogin'      => 'To protect the wiki against automated password cracking, we kindly ask you to enter the words that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-createaccount' => 'To protect the wiki against automated account creation, we kindly ask you to enter the words that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-create'        => 'To create the page, please enter the words that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-edit'          => 'To edit this page, please enter the words that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-sendemail'     => 'To protect the wiki against automated spamming, we kindly ask you to enter the words that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-reload-text'   => 'Refresh',
);

/** Message documentation (Message documentation)
 * @author Fryed-peach
 * @author Hamilton Abreu
 * @author Purodha
 * @author Shirayuki
 */
$messages['qqq'] = array(
	'fancycaptcha-desc' => '{{Optional}}
{{desc}}',
	'fancycaptcha-addurl' => '{{Related|ConfirmEdit-addurl}}',
	'fancycaptcha-badlogin' => '{{Related|ConfirmEdit-badlogin}}',
	'fancycaptcha-createaccount' => '{{Related|ConfirmEdit-createaccount}}',
	'fancycaptcha-create' => '{{Related|ConfirmEdit-create}}',
	'fancycaptcha-edit' => '{{Related|ConfirmEdit-edit}}',
	'fancycaptcha-sendemail' => '{{Related|ConfirmEdit-sendemail}}',
	'fancycaptcha-reload-text' => 'Prompts a click to get a new FancyCaptcha image.',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'fancycaptcha-addurl' => 'Your redakto përfshin të jashtme lidhje të reja. Për të ndihmuar në mbrojtjen kundër spam automatizuar, ju lutem shkruani fjalët që shfaqen poshtë në kuti ([[Special:Captcha/help|më shumë informacion]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Për të ndihmuar në mbrojtjen kundër fjalëkalimin automatizuar plasaritje, ju lutem shkruani fjalët që shfaqen poshtë në kuti ([[Special:Captcha/help|më shumë informacion]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Për të ndihmuar në mbrojtjen kundër krijimit llogari e automatizuar, ju lutem shkruani fjalët që shfaqen poshtë në kuti ([[Special:Captcha/help|më shumë informacion]]):', # Fuzzy
	'fancycaptcha-create' => 'Për të krijuar një faqe, ju lutem shkruani fjalët që shfaqen poshtë në kuti ([[Special:Captcha/help|më shumë informacion]]):',
	'fancycaptcha-edit' => 'Për të redaktuar këtë faqe, ju lutem shkruani fjalët që shfaqen poshtë në kuti ([[Special:Captcha/help|më shumë informacion]]):',
	'fancycaptcha-sendemail' => 'Për të ndihmuar në mbrojtjen kundër spamming automatizuar, ju lutem shkruani fjalët që shfaqen poshtë në kuti ([[Special:Captcha/help|më shumë informacion]]):', # Fuzzy
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'fancycaptcha-createaccount' => 'ያልተፈለገ የመኪናነት አባልነት ለመከላከል፥ አባል ለመሆን በዚህ ምስል የታዩት እንግሊዝኛ ቃላት ወይም ቁጥር መልስ በትክክል መጻፍ ግዴታ ነው። ([[Special:Captcha/help|ይህ ምንድነው?]]) (To help protect against automated spam, you must type in the words or correct number answer exactly as seen beneath here before registering your account:)<br />', # Fuzzy
);

/** Aragonese (aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'fancycaptcha-desc' => 'Chenerador chocant de CAPTCHAs ta Confirmar Edicions.',
	'fancycaptcha-addurl' => "Ha encluyito vinclos esternos en a suya edición. Ta aduyar a protecher contra o spam automatico, escriba por favor as parolas que amaneixen en a caixa d'o cobaixo ([[Special:Captcha/help|más información]]):", # Fuzzy
	'fancycaptcha-badlogin' => "Ta aduyar-nos en a protección contra o trenque automatico de claus d'acceso, escriba por favor as parolas que amaneixen en a caixa d'o cobaixo ([[Special:Captcha/help|más información]]):", # Fuzzy
	'fancycaptcha-createaccount' => 'Ta aduyar a protecher contra a creyación automatica de cuentas, escriba por favor en o quatrón as parolas que amaneixen debaixo ([[Special:Captcha/help|más información]]):', # Fuzzy
	'fancycaptcha-create' => "Ta creyar a pachina, escriba por favor as parolas que amaneixen en a caixa d'o cobaixo
([[Special:Captcha/help|más información]]):",
	'fancycaptcha-edit' => "Ta editar ista pachina, escriba por favor as parolas que amaneixen en a caixa d'o cobaixo
([[Special:Captcha/help|más información]]):",
	'fancycaptcha-sendemail' => 'Ta protecher-nos contra o spam automatizau por favor escriba as parolas que amaneixen en o siguient quadro ([[Special:Captcha/help|mas información]]):', # Fuzzy
);

/** Arabic (العربية)
 * @author Aiman titi
 * @author Meno25
 */
$messages['ar'] = array(
	'fancycaptcha-desc' => 'مولد فانسي كابتشا لConfirm Edit',
	'fancycaptcha-addurl' => 'تعديلك يتضمن وصلات خارجية جديدة.
للحماية من السبام الأوتوماتيكي، من فضلك أدخل الكلمات التي تظهر بالأسفل في الصندوق ([[Special:Captcha/help|مزيد من المعلومات]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'للمساعدة في الحماية ضد سرقة كلمات السر، من فضلك أدخل الكلمات التي تظهر بالأسفل في الصندوق ([[Special:Captcha/help|مزيد من المعلومات]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'للمساعدة في منع إنشاء حسابات بطريقة أوتوماتيكية، قم من فضلك بإدخال الكلمات التي تظهر أدناه في الصندوق ([[Special:Captcha/help|مزيد من المعلومات]]):', # Fuzzy
	'fancycaptcha-create' => 'لإنشاء الصفحة، من فضلك أدخل الكلمات التي تظهر بالأسفل في الصندوق
([[Special:Captcha/help|مزيد من المعلومات]]):',
	'fancycaptcha-edit' => 'لتعديل هذه الصفحة، من فضلك أدخل الكلمات التي تظهر بالأسفل في الصندوق
([[Special:Captcha/help|مزيد من المعلومات]]):',
	'fancycaptcha-sendemail' => 'للمساعدة في منع إنشاء حسابات بطريقة أوتوماتيكية، قم من فضلك بإدخال الكلمات التي تظهر أدناه في الصندوق ([[Special:Captcha/help|مزيد من المعلومات]]):', # Fuzzy
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 * @author Ramsis II
 */
$messages['arz'] = array(
	'fancycaptcha-addurl' => 'تعديلك فيه لينكات خارجية جديدة
علشان تساعد فى الحماية من السبام الاوتوماتيكى، لو سمحت تكتب الكلمات اللى باينة تحت فى الصندوء ([[Special:Captcha/help|معلومات زيادة]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'علشان تساعد فى الحماية من السرقة الاتوماتيكية للباسورد، لو سمحت تدخل الكلمات اللى باينة تحت فى الصندوء ([[Special:Captcha/help|معلومات زيادة]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'علشان تساعد فى الحماية من الفتح الاوتوماتيكى للحسابات،لو سمحت تدخل الكلمات اللى باينة تحت فى الصندوء ([[Special:Captcha/help|معلومات زيادة]]):', # Fuzzy
	'fancycaptcha-create' => 'علشان تبتدى صفحة جديدة، لو سمحت تدخل الكلمات اللى ظاهرة تحت فى الصندوق
([[Special:Captcha/help|معلومات زيادة]]):',
	'fancycaptcha-edit' => 'علشان تعدل فى الصفحة دى،لو سمحت تكتب الكلمات اللى باينة تحت فى الصندوء  ([[Special:Captcha/help|معلومات زيادة]]):',
);

/** Assamese (অসমীয়া)
 * @author Chaipau
 * @author Gitartha.bordoloi
 * @author Rajuonline
 */
$messages['as'] = array(
	'fancycaptcha-addurl' => 'আপোনাৰ সম্পাদনাত বাহ্যিক সংযোগ আছে।
স্বয়ংক্ৰীয় সম্পাদনাৰ পৰা হাত সাৰিবলৈ, তলত দেখিবলৈ পোৱা শব্দটো বাকচৰ ভিতৰত লিখক। ([[Special:Captcha/help|অধিক তথ্য]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'স্বয়ংক্ৰীয় গুপ্তশব্দ চুৰিৰ পৰা হাত সাৰিবলৈ,
তলত দেখিবলৈ পোৱা শব্দটো বাকচৰ ভিতৰত লিখক। ([[Special:Captcha/help|অধিক তথ্য]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'স্বয়ংক্ৰীয় নতুন সদস্যভুক্তিৰ পৰা হাত সাৰিবলৈ, তলত দেখিবলৈ পোৱা শব্দটো বাকচৰ ভিতৰত লিখক। ([[Special:Captcha/help|অধিক তথ্য]]):', # Fuzzy
	'fancycaptcha-create' => 'পৃষ্ঠাটো বনাবলৈ, তলত দেখিবলৈ পোৱা শব্দটো বাকচৰ ভিতৰত লিখক। ([[Special:Captcha/help|অধিক তথ্য]]):',
	'fancycaptcha-edit' => 'এই পৃষ্ঠাটো সম্পাদনা কৰিবলৈ, তলত দেখিবলৈ পোৱা শব্দটো বাকচৰ ভিতৰত লিখক। ([[Special:Captcha/help|অধিক তথ্য]]):',
	'fancycaptcha-sendemail' => 'স্বয়ংক্ৰিয় স্পেমিঙৰ পৰা বাচিবলৈ অনুগ্ৰহ কৰি তলৰ বাকছটোৰ তলত ওলোৱা আখৰকেইটা লিখক ([[Special:Captcha/help|অধিক তথ্য]]):', # Fuzzy
);

/** Asturian (asturianu)
 * @author Esbardu
 * @author Xuacu
 */
$messages['ast'] = array(
	'fancycaptcha-addurl' => "La so edición incluye nuevos enllaces esternos. Pa protexer la wiki escontra'l spam automatizáu, pidimos-y qu'escriba nel caxellu les pallabres qu'apaecen embaxo ([[Special:Captcha/help|más información]]):",
	'fancycaptcha-badlogin' => "Pa protexer la wiki escontra'l descifráu automáticu de claves, pidimos-y qu'escriba nel caxellu les pallabres qu'apaecen embaxo ([[Special:Captcha/help|más información]]):",
	'fancycaptcha-createaccount' => "Pa protexer la wiki escontra la creación automática de cuentes, pidimos-y qu'escriba nel caxellu les pallabres qu'apaecen embaxo ([[Special:Captcha/help|más información]]):",
	'fancycaptcha-create' => "Pa crear la páxina, por favor escribi nel caxellu les pallabres qu'apaecen embaxo ([[Special:Captcha/help|más información]]):",
	'fancycaptcha-edit' => "Pa editar la páxina, por favor escribi nel caxellu les pallabres qu'apaecen embaxo ([[Special:Captcha/help|más información]]):",
	'fancycaptcha-sendemail' => "Pa protexer la wiki escontra'l corréu puxarra automáticu, pidimos-y qu'escriba nel caxellu les pallabres qu'apaecen embaxo ([[Special:Captcha/help|más información]]):",
	'fancycaptcha-reload-text' => 'Refrescar',
);

/** Bashkir (башҡортса)
 * @author Assele
 * @author Рустам Нурыев
 */
$messages['ba'] = array(
	'fancycaptcha-addurl' => 'Һеҙҙең текстығыҙҙа яңы тышҡы һылтанмалар бар.
Автоматик спамдан һаҡлау маҡсатында, зинһар, күрһәтелгән һүҙҙәрҙе түбәндәге юлға керетегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Серһүҙҙе автоматик ватыуҙан һаҡлау маҡсатында, зинһар, күрһәтелгән һүҙҙәрҙе түбәндәге юлға керетегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Иҫәп яҙмаларын автоматик булдырыуҙан һаҡлау маҡсатында, зинһар, күрһәтелгән һүҙҙәрҙе түбәндәге юлға керетегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):', # Fuzzy
	'fancycaptcha-create' => 'Яңы бит булдырыу өсөн, зинһар, күрһәтелгән һүҙҙәрҙе түбәндәге юлға керетегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):',
	'fancycaptcha-edit' => 'Был битте мөхәррирләү өсөн, зинһар, күрһәтелгән һүҙҙәрҙе түбәндәге юлға керетегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):',
	'fancycaptcha-sendemail' => 'Автоматик спамдан һаҡлау маҡсатында, зинһар, күрһәтелгән һүҙҙәрҙе түбәндәге юлға керетегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):', # Fuzzy
);

/** Southern Balochi (بلوچی مکرانی)
 * @author Mostafadaneshvar
 */
$messages['bcc'] = array(
	'fancycaptcha-addurl' => '‎بست', # Fuzzy
	'fancycaptcha-badlogin' => 'په کمک په محافظت چه اتوماتیکی پروشگ کلمه رمز، لطفا کلماتی که ته جهلگی جعبه ظاهر انت واردش کنیت  ([[Special:Captcha/help|گیشترین اطلاعات]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'په کمک په محافظت چه اتوماتیکی شرکتن حساب، لطفا کلماتی که ته جهلگی جعبه ظاهر انت واردش کنیت  ([[Special:Captcha/help|گیشترین اطلاعات]]):', # Fuzzy
	'fancycaptcha-create' => 'په شرکتن صفحه، لطفا کلماتی که ته جهلگی جعبه ظاهراند واردش کنیت ([[Special:Captcha/help|گیشتر اطلاعات]]):',
	'fancycaptcha-edit' => 'په اصلاح کتن ای صفحه، لطفا کلماتی که ته جهلگی جعبه ظاهراند واردش کنیت ([[Special:Captcha/help|گیشتر اطلاعات]]):',
);

/** Bikol Central (Bikol Central)
 * @author Geopoet
 */
$messages['bcl'] = array(
	'fancycaptcha-addurl' => 'An saimong pagliwat minabale nin baguhong mga panluwas na sugpon.
Tanganing makatabang na protektaran kontra sa awtomatikong espam, pakikaag an mga tataramon na ipinapahiling sa ibaba sa laog nin kahon ([[Special:Captcha/help|kadagdagang impormasyon]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Tanganing makatabang na magprotekta kontra sa awtomatikong pagbaak kan pasa-taramon, pakikaag an mga tataramon na ipinapahiling sa ibaba sa laog nin kahon ([[Special:Captcha/help|kadagdagang impormasyon]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Tanganing makatabang na magprotekta kontra sa awtomatikong pagmumukna nin panindog, pakikaag an mga tataramon na ipinapahiling sa ibaba sa laog nin kahon ([[Special:Captcha/help|kadagdagang impormasyon]]):', # Fuzzy
	'fancycaptcha-create' => 'Tanganing makapagmukna nin pahina, pakikaag kan mga tataramon na ipinapahiling sa ibaba sa laog nin kahon ([[Special:Captcha/help|kadagdagang impormasyon]]):',
	'fancycaptcha-edit' => 'Tanganing makapagliwat kaining pahina, pakikaag an mga tataramon na ipinapahiling sa ibaba sa laog nin kahon ([[Special:Captcha/help|kadagdagang impormasyon]]):',
	'fancycaptcha-sendemail' => 'Tanganing makatabang na magprotekta kontra sa awtomatikong pag-eespam, pakikaag an mga tataramon na ipinapahiling sa ibaba sa laog nin kahon ([[Special:Captcha/help|kadagdagang impormasyon]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Preskohon otro',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Red Winged Duck
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'fancycaptcha-addurl' => 'Вашае рэдагаваньне ўтрымлівае новыя вонкавыя спасылкі.
У мэтах абароны ад спаму, калі ласка, увядзіце словы, якія паказаныя ў выяве ([[Special:Captcha/help|болей інфармацыі]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'У мэтах абароны ад аўтаматычнага злому пароляў, калі ласка, увядзіце словы, якія паказаныя ў выяве ([[Special:Captcha/help|болей інфармацыі]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'У мэтах абароны ад аўтаматычнага стварэньня рахункаў, калі ласка, увядзіце словы, якія паказаныя ў выяве ([[Special:Captcha/help|болей інфармацыі]]):', # Fuzzy
	'fancycaptcha-create' => 'Для стварэньня старонкі, калі ласка, увядзіце словы, якія паказаныя ў выяве ([[Special:Captcha/help|болей інфармацыі]]):',
	'fancycaptcha-edit' => 'Для рэдагаваньня гэтай старонкі, калі ласка, увядзіце словы, якія паказаныя ў выяве ([[Special:Captcha/help|болей інфармацыі]]):',
	'fancycaptcha-sendemail' => 'У мэтах абароны супраць аўтаматычнага спаму, калі ласка, увядзіце словы паказаныя ніжэй у полі ([[Special:Captcha/help|дадатковая інфармацыя]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Абнавіць',
);

/** Bulgarian (български)
 * @author Borislav
 * @author DCLXVI
 */
$messages['bg'] = array(
	'fancycaptcha-addurl' => 'Текущата редакция включва нови външни препратки. Като защита от автоматизиран спам, системата изисква от потребителите да въведат думите, показани по-долу в текстовата кутия ([[Special:Captcha/help|повече информация]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Като защита срещу опити за налучкване на паролата ви, моля, въведете буквите, които виждате на картинката ([[Special:Captcha/help|повече информация]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Системата за защита от автоматично създаване на потребителски сметки изисква да въведете това, което виждате в кутията по-долу ([[Special:Captcha/help|повече информация]]):', # Fuzzy
	'fancycaptcha-create' => 'За създаване на страницата е необходимо да се въведат думите от картинката в полето по-долу ([[Special:Captcha/help|повече информация]]):',
	'fancycaptcha-edit' => 'За редактиране на страницата е необходимо да се въведат думите от картинката в полето по-долу ([[Special:Captcha/help|повече информация]]):',
	'fancycaptcha-sendemail' => 'Като защита срещу автоматизиран спам, въведете в кутията думите, които са показани по-долу ([[Special:Captcha/help|повече информация]]):', # Fuzzy
);

/** Bengali (বাংলা)
 * @author Nasir8891
 * @author Zaheen
 */
$messages['bn'] = array(
	'fancycaptcha-addurl' => 'আপনার সম্পাদনাটিতে নতুন বহিঃসংযোগ আছে। স্বয়ংক্রিয় স্প্যামের বিরুদ্ধে সুরক্ষার খাতিরে অনুগ্রহ করে নিচের বাক্সে দেখানো শব্দগুলি প্রবেশ করান ([[Special:Captcha/help|আরও তথ্য]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'স্বয়ংক্রিয় শব্দচাবি ক্র্যাকিং-এর বিরুদ্ধে সুরক্ষার খাতিরে অনুগ্রহ করে নিচের বাক্সে দেখানো শব্দগুলি প্রবেশ করান ([[Special:Captcha/help|আরও তথ্য]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'স্বয়ংক্রিয় অ্যাকাউন্ট সৃষ্টির বিরুদ্ধে সুরক্ষার জন্য অনুগ্রহ করে নিচের বাক্সে দেখানো শব্দগুলি প্রবেশ করান ([[Special:Captcha/help|আরও তথ্য]]):', # Fuzzy
	'fancycaptcha-create' => 'পাতাটি সৃষ্টি করতে চাইলে অনুগ্রহ করে নিচের বাক্সে দেখানো শব্দগুলি প্রবেশ করান ([[Special:Captcha/help|আরও তথ্য]]):',
	'fancycaptcha-edit' => 'পাতাটি সম্পাদনা করতে চাইলে অনুগ্রহ করে নিচের বাক্সে দেখানো শব্দগুলি প্রবেশ করান
([[Special:Captcha/help|আরও তথ্য]]):',
	'fancycaptcha-sendemail' => 'স্বয়ংক্রিয় স্প্যামিং এর বিরুদ্ধে সুরক্ষার খাতিরে অনুগ্রহ করে নিচের বাক্সে দেখানো শব্দগুলি প্রবেশ করান ([[Special:Captcha/help|আরও তথ্য]]):', # Fuzzy
);

/** Breton (brezhoneg)
 * @author Fohanno
 * @author Fulup
 */
$messages['br'] = array(
	'fancycaptcha-addurl' => "Liammoù diavaez nevez zo bet degaset ganeoc'h. Evit stourm a-enep d'ar strob emgefre, skrivit ar gerioù a zeu war wel er voest a-is ([[Special:Captcha/help|gouzout hiroc'h]]):", # Fuzzy
	'fancycaptcha-badlogin' => "A-benn talañ ouzh ar preizhañ kontoù dre c'herioù-tremen emgefre, skrivit er vaezienn ar gerioù merket dindan ([[Special:Captcha/help|Petra eo se?]]):", # Fuzzy
	'fancycaptcha-createaccount' => "Evit stourm a-enep d'ar c'hontoù  krouet ent emgefre, skrivit ar gerioù
a zeu war wel er voest a-is ([[Special:Captcha/help|gouzout hiroc'h]]):", # Fuzzy
	'fancycaptcha-create' => "Liammoù diavaez nevez zo bet degaset ganeoc'h. Evit stourm a-enep d'ar strob emgefre, skrivit ar gerioù a zeu war wel er voest a-is ([[Special:Captcha/help|gouzout hiroc'h]]):",
	'fancycaptcha-edit' => "Liammoù diavaez nevez zo bet degaset ganeoc'h. Evit stourm a-enep d'ar strob emgefre, skrivit ar gerioù a zeu war wel er voest a-is ([[Special:Captcha/help|gouzout hiroc'h]]):",
	'fancycaptcha-sendemail' => "Evit hor skoazellañ da zizarbenn ar strob emgefre, adskrivit ar gerioù a welit er voest dindan ([[Special:Captcha/help|gouzout hiroc'h]]):", # Fuzzy
	'fancycaptcha-reload-text' => 'Freskaat',
);

/** Bosnian (bosanski)
 * @author CERminator
 * @author DzWiki
 */
$messages['bs'] = array(
	'fancycaptcha-addurl' => 'Vaša izmjena uključuje nove vanjske linkove.
Da bi se zaštitili od automatskog spama, molimo da unesete riječi koje su prikazane u kutiji ([[Special:Captcha/help|više informacija]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Da bi pomogli u sprječavanju protiv automatskog probijanja šifre, molimo Vas da unesete riječi koje su prikazane ispod u kutiji ([[Special:Captcha/help|više informacija]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Da bi pomogli u sprječavanju automatskog pravljenja računa, molimo Vas da unesete riječi koje su prikazane u kutiji ispod ([[Special:Captcha/help|više informacija]]):', # Fuzzy
	'fancycaptcha-create' => 'Da bi ste napravili stranicu, molimo Vas unesite riječi koje su prikazane u kutiji ispod ([[Special:Captcha/help|više informacija]]):',
	'fancycaptcha-edit' => 'Da bi ste uređivali ovu stranicu, molimo Vas unesite riječi koje su prikazane u kutiji ispod ([[Special:Captcha/help|više informacija]]):',
	'fancycaptcha-sendemail' => 'Da bi pomogli u sprječavanju protiv automatskog spamovanja, molimo Vas da unesete riječi koje su prikazane ispod u kutiji ([[Special:Captcha/help|više informacija]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Osvježi',
);

/** Catalan (català)
 * @author Davidpar
 * @author SMP
 * @author Ssola
 */
$messages['ca'] = array(
	'fancycaptcha-addurl' => "La vostra modificació inclou nous enllaços externs. Com a protecció contra la propaganda automatitzada heu d'escriure en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):", # Fuzzy
	'fancycaptcha-badlogin' => "Com a protecció contra l'obtenció automatitzada de contrasenyes cal que escriviu en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):", # Fuzzy
	'fancycaptcha-createaccount' => 'Com a protecció contra la creació automatitzada de nous comptes cal que escriviu en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):', # Fuzzy
	'fancycaptcha-create' => "Per a poder crear la pàgina heu d'escriure en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):",
	'fancycaptcha-edit' => "Per a poder modificar la pàgina heu d'escriure en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):",
	'fancycaptcha-sendemail' => 'Per ajudar a protegir contra el correu brossa automatitzat, si us plau, introduïu les paraules que apareixen a sota la caixa ([[Special:Captcha/help|més informació]]):', # Fuzzy
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄)
 */
$messages['cdo'] = array(
	'fancycaptcha-badlogin' => 'Ôi-lāu huòng-cī tiàng-sê̤ṳ cê̤ṳ-dông puái-gāi mĭk-mā, chiāng nṳ̄ sṳ̆-ĭk â-dā̤ bēng-bēng diē-lié gì sṳ̀ ([[Special:Captcha/help|gáing sâ̤ séng-sék]]):', # Fuzzy
);

/** Chechen (нохчийн)
 * @author Умар
 */
$messages['ce'] = array(
	'fancycaptcha-addurl' => 'Хьан нисдар чохь керла арахьара хьажоригаш ю. Спамах лардала дерхар до лахахь гура чохь гайтан дешнаш язъе ([[Special:Captcha/help|ма-дарра…]]):', # Fuzzy
);

/** Sorani Kurdish (کوردی)
 * @author Asoxor
 */
$messages['ckb'] = array(
	'fancycaptcha-createaccount' => 'بۆ یارمەتیدانی بەرگری لە دروستکردنی خۆکاری ھەژمار، تکایە ئەو وشانە لە خوارەوەدا دیارن لە بۆکسەکەدا بنووسە ([[Special:Captcha/help|زانیاریی زۆرتر]]):', # Fuzzy
);

/** Czech (česky)
 * @author Mormegil
 */
$messages['cs'] = array(
	'fancycaptcha-desc' => 'Pokročilý generátor captcha pro rozšíření „Confirm Edit“',
	'fancycaptcha-addurl' => 'Vaše editace obsahuje nové odkazy formou URL; v zájmu ochrany před automatickým spamováním musíte opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])', # Fuzzy
	'fancycaptcha-badlogin' => 'V rámci ochrany proti automatickým pokusům uhodnout heslo musíte opsat text z následujícího obrázku. ([[Special:Captcha/help|Co tohle znamená?]])', # Fuzzy
	'fancycaptcha-createaccount' => 'V rámci ochrany před automatickým zakládáním účtů musíte pro provedení registrace opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])', # Fuzzy
	'fancycaptcha-create' => 'Abyste mohli založit stránku, musíte opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])',
	'fancycaptcha-edit' => 'Abyste mohli editovat tuto stránku, musíte opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])',
	'fancycaptcha-sendemail' => 'V rámci ochrany proti automatickému spamování musíte opsat níže zobrazená slova ([[Special:Captcha/help|více informací]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Vygenerovat nový kód',
);

/** Church Slavic (словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'fancycaptcha-createaccount' => 'блюдєниꙗ дѣл҄ьма на аѵтоматьно мѣстоꙁиданиѥ · авлѥнъ слова обраꙁъ нижьшиѥмь окънѣ напиши ⁙ ([[Special:Captcha/help|испльнѧщѧ вѣсти]]) :', # Fuzzy
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'fancycaptcha-addurl' => "Mae eich golygiad yn cynnwys cyswllt allanol newydd.
Er mwyn arbed y wici rhag peiriannau sbam, byddwch gystal â theipio'r geiriau a welwch isod yn y blwch ([[Special:Captcha/help|rhagor o wybodaeth]]):",
	'fancycaptcha-badlogin' => "Er mwyn arbed y wici rhag peiriannau datrys cyfrineiriau, byddwch gystal â theipio'r geiriau a welwch isod yn y blwch ([[Special:Captcha/help|rhagor o wybodaeth]]):",
	'fancycaptcha-createaccount' => "Er mwyn arbed y wici rhag peiriannau creu cyfrifon, byddwch gystal â theipio'r geiriau a welwch isod yn y blwch ([[Special:Captcha/help|rhagor o wybodaeth]]):",
	'fancycaptcha-create' => "Er mwyn creu'r dudalen, byddwch gystal â theipio'r geiriau a welwch isod yn y blwch ([[Special:Captcha/help|rhagor o wybodaeth]]):",
	'fancycaptcha-edit' => "Er mwyn gallu golygu'r dudalen hon, byddwch gystal â theipio'r geiriau a welwch isod yn y blwch ([[Special:Captcha/help|rhagor o wybodaeth]]):",
	'fancycaptcha-sendemail' => "Er mwyn arbed y wici rhag sbamio awtomatig, byddwch gystal â gwneud y swm isod ac ysgrifennu'r ateb yn y blwch ([[Special:Captcha/help|rhagor o wybodaeth]]):",
	'fancycaptcha-reload-text' => 'Adnewyddu',
);

/** Danish (dansk)
 * @author Christian List
 * @author HenrikKbh
 * @author Kaare
 * @author Peter Alberti
 */
$messages['da'] = array(
	'fancycaptcha-addurl' => 'Din ændring tilføjer nye eksterne henvisninger.
For at beskytte mod automatiseret spam, skal du indtaste ordene som vises i feltet nedenfor. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-badlogin' => 'For at beskytte mod automatiske forsøg på at gætte kodeord, skal du indtaste ordene som vises i feltet nedenfor. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-createaccount' => 'For at beskytte mod automatisk oprettelse af brugerkonti, der bruges til spam, skal du indtaste ordet som vises i feltet nedenfor. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-create' => 'For at oprette en ny side, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-edit' => 'For at redigere denne side, indtast da venligst ordene, der står i feltet nedenfor ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-sendemail' => 'For at beskytte mod automatisk spam, skal du skrive ordene der vises i feltet herunder ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-reload-text' => 'Opdater',
);

/** German (Deutsch)
 * @author Metalhead64
 * @author Raimond Spekking
 * @author Umherirrender
 */
$messages['de'] = array(
	'fancycaptcha-desc' => 'Fancy-CAPTCHA-Generator für die Erweiterung „Confirm Edit“',
	'fancycaptcha-addurl' => 'Deine Bearbeitung enthält neue externe Links.
Zum Schutz des Wikis vor automatisiertem Spamming bitten wir dich, das folgende Wort in das Feld unten einzugeben. Klicke dann erneut auf „Seite speichern“ ([[Special:Captcha/help|Fragen oder Probleme?]]).',
	'fancycaptcha-badlogin' => 'Zum Schutz des Wikis vor einer Kompromittierung deines Benutzerkontos bitten wir dich, das folgende Wort in das Feld unten einzugeben [[Special:Captcha/help|(Fragen oder Probleme?)]]:',
	'fancycaptcha-createaccount' => 'Zum Schutz des Wikis vor automatisierter Anlage von Benutzerkonten bitten wir dich, das folgende Wort in das Feld unten einzugeben ([[Special:Captcha/help|Fragen oder Probleme?]]):',
	'fancycaptcha-create' => 'Zur Erstellung der Seite gib das folgende Wort in das Feld unten ein [[Special:Captcha/help|(Fragen oder Probleme?)]].',
	'fancycaptcha-edit' => 'Zur Bearbeitung der Seite gib das folgende Wort in das Feld unten ein [[Special:Captcha/help|(Fragen oder Probleme?)]].',
	'fancycaptcha-sendemail' => 'Zum Schutz des Wikis vor automatischem Spamming bitten wir dich, die Wörter unten in das Feld einzugeben ([[Special:Captcha/help|mehr Informationen]]):',
	'fancycaptcha-reload-text' => 'Aktualisieren',
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author Imre
 * @author MichaelFrey
 * @author Umherirrender
 */
$messages['de-formal'] = array(
	'fancycaptcha-addurl' => 'Ihre Bearbeitung enthält neue externe Links.
Zum Schutz vor automatisiertem Spamming geben Sie das folgende Wort in das Feld unten ein. Klicken Sie dann erneut auf „Seite speichern“ ([[Special:Captcha/help|Fragen oder Probleme?]]).', # Fuzzy
	'fancycaptcha-badlogin' => 'Zum Schutz vor einer Kompromittierung Ihres Benutzerkontos geben Sie bitte das folgende Wort in das Feld unten ein [[Special:Captcha/help|(Haben Sie Fragen oder Probleme?)]]:', # Fuzzy
	'fancycaptcha-createaccount' => 'Zum Schutz vor automatisierter Anlage von Benutzerkonten geben Sie bitte das folgende Wort in das Feld unten ein ([[Special:Captcha/help|Fragen oder Probleme?]]):', # Fuzzy
	'fancycaptcha-create' => 'Zur Erstellung der Seite geben Sie das folgende Wort in das Feld unten ein [[Special:Captcha/help|(Fragen oder Probleme?)]].',
	'fancycaptcha-edit' => 'Zur Bearbeitung der Seite geben Sie das folgende Wort in das Feld unten ein [[Special:Captcha/help|(Fragen oder Probleme?)]].',
	'fancycaptcha-sendemail' => 'Um gegen automatischen Spam vorzugehen, geben Sie bitte die Wörter unten in das Feld ein ([[Special:Captcha/help|mehr Informationen]]):', # Fuzzy
);

/** Zazaki (Zazaki)
 * @author Gorizon
 * @author Xoser
 */
$messages['diq'] = array(
	'fancycaptcha-addurl' => 'Vırnayışané tod linkané hariciyé newe esto. 
Qe otomatik spami ra pawıtış, ma rica keno çekuyané ke qutiya cor de inan binuse ([[Special:Captcha/help|enformasyoné bini]]):',
	'fancycaptcha-badlogin' => 'Qe otomatik parola crack kerdişî ra pawitîş, ma rica keno çekuyanê ke qutiya cor de înan binuse ([[Special:Captcha/help|enformasyonê bînî]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Qe otomatik hesab viraştişî ra pawitîş, ma rica keno çekuyanê ke qutiya cor de înan binuse ([[Special:Captcha/help|enformasyonê bînî]]):', # Fuzzy
	'fancycaptcha-create' => 'Qe pel viraştîşî, ma rica keno çekuyanê ke qutiya cor de înan binuse ([[Special:Captcha/help|enformasyonê bînî]]):',
	'fancycaptcha-edit' => 'Qe pel vurnayîşî, ma rica keno çekuyanê ke qutiya cor de înan binuse ([[Special:Captcha/help|enformasyonê bînî]]):',
	'fancycaptcha-sendemail' => 'Qe spamê otomayoni ra pawitîşi, ma rica keno çekuyanê ke qutiya cor de înan binuse 
([[Special:Captcha/help|enformasyonê bînî]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Newe ke',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'fancycaptcha-addurl' => 'Twója změna wopśimujo nowe eksterne wótkaze.
Za šćit pśeśiwo awtomatiskemu spamowanjeju, zapódaj pšosym słowa, kótarež pokazuju se dołojce w kašćiku  ([[Special:Captcha/help|dalšne informacije]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Za šćit pśeśiwo awtomatiskemu wugódanjeju gronidła, zapódaj pšosym słowa, kótarež pokazuju se dołojce w kašćiku ([[Special:Captcha/help|dalšne informacije]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Za šćit pśeśiwo awtomatiskemu załoženjeju kontow, zapódaj pšosym słowa, kótarež pokazuju se dołojce w kašćiku ([[Special:Captcha/help|dalšne informacije]]):', # Fuzzy
	'fancycaptcha-create' => 'Aby bok napórał, zapódaj pšosym słowa, kótarež pokazuju se dołojce w kašćiku ([[Special:Captcha/help|dalšne informacije]]):',
	'fancycaptcha-edit' => 'Aby toś ten bok wobźěłał, zapódaj pšosym słowa, kótarež pokazuju se dołojce w kašćiku ([[Special:Captcha/help|dalšne informacije]]):',
	'fancycaptcha-sendemail' => 'Za šćit pśeśiwo awtomatiskemu spamowanjeju, zapódaj pšosym słowa, kótarež pokazuju se dołojce w kašćiku ([[Special:Captcha/help|dalšne informacije]]):', # Fuzzy
);

/** Greek (Ελληνικά)
 * @author Badseed
 * @author Consta
 * @author Geraki
 * @author Glavkos
 * @author ZaDiak
 */
$messages['el'] = array(
	'fancycaptcha-addurl' => 'Η επεξεργασία σας περιλαμβάνει νέους εξωτερικούς σύνδεσμους.
Ως βοήθεια για την προστασία από αυτόματα spam, παρακαλούμε γράψτε τις λέξεις που εμφανίζονται παρακάτω στο πλαίσιο ([[Special:Captcha/help|περισσότερες πληροφορίες]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Ως βοήθεια για την προστασία από αυτόματα προγράμματα σπασίματος κωδικών, παρακαλούμε γράψτε τις λέξεις που εμφανίζονται παρακάτω στο πλαίσιο ([[Special:Captcha/help|περισσότερες πληροφορίες]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Για να βοηθήσετε στην προστασία κατά των αυτόματα δημιουργούμενων λογαριασμών, παρακαλούμε πληκτρολογήστε στο πλαίσιο τις λέξεις που εμφανίζονται πιο κάτω ([[Special:Captcha/help|περισσότερες πληροφορίες]]):', # Fuzzy
	'fancycaptcha-create' => 'Για να δημιουργήσετε αυτήν την σελίδα, παρακαλώ εισάγετε τις λέξεις που εμφανίζονται παρακάτω μέσα στο κουτί
([[Special:Captcha/help|περισσότερες πληροφορίες]]):',
	'fancycaptcha-edit' => 'Για να επεξεργαστείτε αυτήν την σελίδα, παρακαλώ εισάγετε τις λέξεις που εμφανίζονται παρακάτω μέσα στο κουτί
([[Special:Captcha/help|περισσότερες πληροφορίες]]):',
	'fancycaptcha-sendemail' => 'Ως βοήθεια για την προστασία από αυτόματα προγράμματα σπασίματος κωδικών, παρακαλούμε γράψτε τις λέξεις που εμφανίζονται παρακάτω στο πλαίσιο ([[Special:Captcha/help|περισσότερες πληροφορίες]]):', # Fuzzy
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'fancycaptcha-addurl' => 'Via redakto inkluzivas novajn eksterajn ligilojn.
Por preventi aŭtomatan spamon, bonvolu enigi la jenajn vortojn en la skatolo ([[Special:Captcha/help|plia informo]]):',
	'fancycaptcha-badlogin' => 'Por protekti kontraŭ aŭtomata divenado de pasvortoj, bonvolu enigi la jenajn vortojn en la skatolo ([[Special:Captcha/help|plua informo]]):',
	'fancycaptcha-createaccount' => 'Por protekti kontraŭ aŭtomata kreado de kontoj, bonvolu enigi la jenajn vortojn en la skatolo ([[Special:Captcha/help|plia informo]]):',
	'fancycaptcha-create' => 'Por krei la paĝon, bonvolu enigi la vortojn montritajn en la jena skatolo ([[Special:Captcha/help|plua informo]]):',
	'fancycaptcha-edit' => 'Por redakti ĉi tiun paĝon, bonvolu enigi la vortojn jenajn en la kesto ([[Special:Captcha/help|plua informo]]):',
	'fancycaptcha-sendemail' => 'Por helpi protekti kontraŭ aŭtomata spamado, bonvolu enigi la jenajn vortojn de la skatolo ([[Special:Captcha/help|plia informo]]):',
	'fancycaptcha-reload-text' => 'Refreŝigi',
);

/** Spanish (español)
 * @author Fitoschido
 * @author Icvav
 * @author Pertile
 * @author Sanbec
 */
$messages['es'] = array(
	'fancycaptcha-addurl' => 'Tu edición incluye nuevos enlaces externos. Para protegernos contra el spam automatizado, por favor introduce en el recuadro las palabras que aparecen debajo ([[Special:Captcha/help|más información]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Para ayudarnos en la protección contra el descifrado automático de contraseñas, por favor, introduce las palabras que aparecen abajo en la caja ([[Special:Captcha/help|más información]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Para evitar la creación automatizada de cuentas, introduce por favor en el recuadro las palabras que aparecen debajo ([[Special:Captcha/help|más información]]):', # Fuzzy
	'fancycaptcha-create' => 'Para crear la página, por favor introduce en el recuadro las palabras que aparecen debajo ([[Special:Captcha/help|más información]]):',
	'fancycaptcha-edit' => 'Para editar esta página, por favor introduce en el recuadro las palabras que aparecen debajo ([[Special:Captcha/help|más información]]):',
	'fancycaptcha-sendemail' => 'Para protegernos contra el spam automatizado por favor ingrese las palabras que aparecen en el siguiente cuadro ([[Special:Captcha/help|más información]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Actualizar',
);

/** Estonian (eesti)
 * @author Pikne
 */
$messages['et'] = array(
	'fancycaptcha-desc' => 'Kirevate piltidega robotilõks, kinnitamaks muudatuste õigsust.',
	'fancycaptcha-addurl' => 'Sinu muudatus sisaldab uusi välislinke.
Palun sisesta allpool olevas kastis kuvatud sõnad. Abinõu on kaitseks automaadistatud rämpsmuudatuste eest ([[Special:Captcha/help|lisateave]]):',
	'fancycaptcha-badlogin' => 'Palun sisesta allpool olevas kastis kuvatud sõnad. Abinõu on kaitseks automaatsete parooliäraarvajate eest ([[Special:Captcha/help|lisateave]]):',
	'fancycaptcha-createaccount' => 'Palun sisesta allpool olevas kastis kuvatud sõnad. Abinõu on kaitseks kontode automaatse loomise eest ([[Special:Captcha/help|lisateave]]):',
	'fancycaptcha-create' => 'Lehekülje loomiseks sisesta palun allpool olevas kastis kuvatud sõnad ([[Special:Captcha/help|lisateave]]):',
	'fancycaptcha-edit' => 'Selle lehekülje muutmiseks sisesta palun allpool olevas kastis kuvatud sõnad ([[Special:Captcha/help|lisateave]]):',
	'fancycaptcha-sendemail' => 'Palun sisesta allpool olevas kastis kuvatud sõnad. Abinõu on kaitseks automaadistatud rämpsmuudatuste vastu ([[Special:Captcha/help|lisateave]]):',
	'fancycaptcha-reload-text' => 'Vaheta',
);

/** Basque (euskara)
 * @author An13sa
 */
$messages['eu'] = array(
	'fancycaptcha-addurl' => 'Zure aldaketak kanpo lotura berriak ditu. Spam automatikoa saihestu ahal izateko, beheko koadroan ageri diren hitzak idatzi ([[Special:Captcha/help|informazio gehigarria]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Pasahitzen cracking automatikoa saihestu asmoz, beheko koadroan ageri diren hitzak idazteko eskatzen dizugu ([[Special:Captcha/help|informazio gehigarria]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Erabiltzaile kontuak automatikoki sortzea saihestu asmoz, beheko koadroan ageri diren hitzak idazteko eskatzen dizugu ([[Special:Captcha/help|informazio gehigarria]]):', # Fuzzy
	'fancycaptcha-create' => 'Orrialde sortu ahal izateko, beheko koadroan ageri hitzak idatzi ([[Special:Captcha/help|informazio gehigarria]]):',
	'fancycaptcha-edit' => 'Orrialde hau aldatu ahal izateko, beheko koadroan ageri diren hitzak idatzi ([[Special:Captcha/help|informazio gehigarria]]):',
	'fancycaptcha-sendemail' => 'Zabor-posta automatizatuaz babesteko, idatzi azpiko kutxako hitzak ([[Special:Captcha/help|informazio gehiago]]):', # Fuzzy
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Huji
 * @author Ladsgroup
 * @author Meisam
 * @author Reza1615
 * @author Wayiran
 */
$messages['fa'] = array(
	'fancycaptcha-addurl' => 'ویرایش شما حاوی پیوند به بیرون جدیدی است.
برای کمک به جلوگیری از هرزنگاری خودکار، لطفاً واژه‌ای را که در تصویر می‌بینید در جعبه وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'برای کمک به جلوگیری از شکستن خودکار گذرواژه، لطفاً واژه‌ای را که در تصویر می‌بینید را وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):',
	'fancycaptcha-createaccount' => 'برای کمک به جلوگیری از ایجاد خودکار حساب کاربری، لطفاً واژه‌ای را که در تصویر می‌بینید وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):', # Fuzzy
	'fancycaptcha-create' => 'برای ایجاد این صفحه، لطفاً واژه‌ای را که در تصویر می‌بینید وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):',
	'fancycaptcha-edit' => 'برای ویرایش این صفحه، لطفاً واژه‌ای را که در تصویر می‌بینید وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):',
	'fancycaptcha-sendemail' => 'برای کمک به محافظت در برابر هرزه‌نگاری خودکار، لطفاً واژه‌هایی را که در جعبهٔ زیر نمایش داده می‌شوند وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'تازه کردن',
);

/** Finnish (suomi)
 * @author Crt
 * @author Nike
 */
$messages['fi'] = array(
	'fancycaptcha-addurl' => 'Muokkauksesi sisältää uusia linkkejä muille sivuille. Kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Automatisoidun salasanan murtamisen vaikeuttamiseksi kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):', # Fuzzy
	'fancycaptcha-create' => 'Muokkauksesi sisältää uusia linkkejä muille sivuille. Kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):',
	'fancycaptcha-edit' => 'Muokkauksesi sisältää uusia linkkejä muille sivuille. Kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):',
	'fancycaptcha-sendemail' => 'Automatisoidun roskapostin lähettämisen vaikeuttamiseksi kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):', # Fuzzy
);

/** Faroese (føroyskt)
 * @author EileenSanda
 * @author Spacebirdy
 */
$messages['fo'] = array(
	'fancycaptcha-addurl' => 'Tín rætting inniheldur nýggjar uttanhýsis slóðir.
Fyri at verja wikiina ímóti sjálvvirkandi kontoupprættan, vilja vit vinarliga biðja teg um at skriva inn tey orð, sum koma fyri í teiginum niðanfyri, til tess at stovna eina konto: <br />([[Special:Captcha/help|meira kunning]]):',
	'fancycaptcha-createaccount' => 'Fyri at verja wikiina ímóti sjálvvirkandi kontoupprættan, vilja vit vinarliga biðja teg um at skriva inn tey orð, sum koma fyri í teiginum niðanfyri, so at tú kanst stovna eina konto:
([[Special:Captcha/help|meira kunning]]):',
);

/** French (français)
 * @author Crochet.david
 * @author Gomoko
 * @author IAlex
 * @author Metroitendo
 * @author Sherbrooke
 * @author Urhixidur
 * @author Verdy p
 */
$messages['fr'] = array(
	'fancycaptcha-desc' => "Générateur d’images ''captcha'' anti-robots demandant une confirmation humaine des modifications.",
	'fancycaptcha-addurl' => 'Votre modification inclut de nouveaux liens externes.
Pour protéger le wiki contre les pourriels automatisés, nous vous demandons de bien vouloir entrer les mots qui apparaissent dans la boîte ([[Special:Captcha/help|plus d’informations]]) :',
	'fancycaptcha-badlogin' => 'Pour protéger le wiki contre le cassage des mots de passe par des automates, nous vous demandons de bien vouloir entrer les mots qui apparaissent dans la boîte ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'fancycaptcha-createaccount' => 'Pour protéger le wiki contre les créations automatiques de comptes, nous vous demandons de bien vouloir entrer les mots qui apparaissent dans la boîte ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'fancycaptcha-create' => 'Pour créer la page, veuillez entrer les mots qui apparaissent dans la boîte ci-dessous ([[Special:Captcha|plus d’informations]]) :',
	'fancycaptcha-edit' => 'Pour modifier cette page, veuillez saisir les mots qui apparaissent dans la boîte ci-dessous ([[Special:Captcha/help|plus d’information]]) :',
	'fancycaptcha-sendemail' => 'Pour protéger le wiki contre l’envoi automatisé de pourriels, nous vous demandons de bien vouloir entrer les mots qui apparaissent dans la boîte ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'fancycaptcha-reload-text' => 'Actualiser',
);

/** Franco-Provençal (arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'fancycaptcha-desc' => "G·ènèrator d’émâges ''captch·a'' anti-robots que demande una confirmacion d’homo des changements.",
	'fancycaptcha-addurl' => 'Voutron changement encllut de lims de defôr novéls.
Por nos édiér a combatre contre lo spame ôtomatisâ, volyéd buchiér los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :', # Fuzzy
	'fancycaptcha-badlogin' => 'Por nos édiér a combatre contre lo cassâjo ôtomatisâ de contresegnos, volyéd buchiér los mots qu’aparèssont dedens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :', # Fuzzy
	'fancycaptcha-createaccount' => 'Por nos édiér a combatre contre les crèacions ôtomatisâs de comptos, volyéd buchiér los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :', # Fuzzy
	'fancycaptcha-create' => 'Por fâre ceta pâge, volyéd buchiér los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :',
	'fancycaptcha-edit' => 'Por changiér ceta pâge, volyéd buchiér los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :',
	'fancycaptcha-sendemail' => 'Por nos édiér a combatre contre lo spame ôtomatisâ, volyéd buchiér los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :', # Fuzzy
);

/** Western Frisian (Frysk)
 * @author Snakesteuben
 */
$messages['fy'] = array(
	'fancycaptcha-badlogin' => 'As ekstra beskerming tsjin automatysk ûntsiferjen fan wachtwurden wurdt jo frege de ûndersteande letters oer te tikken. ([[Special:Captcha/help|mear ynformaasje]]).', # Fuzzy
);

/** Irish (Gaeilge)
 */
$messages['ga'] = array(
	'fancycaptcha-createaccount' => 'Mar chosaint in éadan cuntais a chruthaítear go huathoibríoch, ionchuir na focail a thaispeántar san íomhá seo thíos: <br />([[Special:Captcha/help|tuilleadh eolais]])', # Fuzzy
);

/** Galician (galego)
 * @author Toliño
 * @author Xosé
 */
$messages['gl'] = array(
	'fancycaptcha-desc' => 'Xerador de imaxes CAPTCHA para Confirm Edit',
	'fancycaptcha-addurl' => 'A súa edición inclúe novas ligazóns externas.
Para protexer o wiki contra o spam automático, introduza as palabras que aparecen na caixa ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-badlogin' => 'Para protexer o wiki contra o roubo de contrasinais, introduza as palabras que aparecen na caixa ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-createaccount' => 'Para protexer o wiki contra a creación automática de contas, introduza as palabras que aparecen na caixa ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-create' => 'Para crear a páxina, introduza as palabras que aparecen na caixa ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-edit' => 'Para editar esta páxina, introduza as palabras que aparecen na caixa ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-sendemail' => 'Para protexer o wiki contra o spam automático, introduza as palabras que aparecen na caixa ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-reload-text' => 'Refrescar',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 * @author Melancholie
 */
$messages['gsw'] = array(
	'fancycaptcha-addurl' => 'In Dyynere Bearbeitig het s neiji externi Link.
Zum Schutz vor automatisiertem Spamming gib des Wort in s Fäld unten yy. Druck derno nomol uf „Syte spychere“. [[Special:Captcha/help|(Frogen oder Probläm?)]]', # Fuzzy
	'fancycaptcha-badlogin' => 'Zum Schutz vor ere Kompromittierig vu Dyynm Benutzerkonto gib des Wort in s Fäld unten yy [[Special:Captcha/help|(Frogen oder Probläm?)]]:', # Fuzzy
	'fancycaptcha-createaccount' => 'Zum Schutz vor ere automatisierte Aalag vu Benutzerkonte gib bitte des Wort in s Fäld unten yy ([[Special:Captcha/help|Frogen oder Probläm?]]):', # Fuzzy
	'fancycaptcha-create' => 'Zum d Syten aalege gib des Wort in s Fäld unten yy. [[Special:Captcha/help|(Frogen oder Probläm?)]]',
	'fancycaptcha-edit' => 'Zum d Syte bearbeite gib des Wort in s Fäld unten yy. [[Special:Captcha/help|(Frogen oder Probläm?)]]',
	'fancycaptcha-sendemail' => 'As Schutz gege e automatischs Spamming, gib bitte des Wort in s Fäld unten yy ([[Special:Captcha/help|meh Informatione]]):', # Fuzzy
);

/** Gujarati (ગુજરાતી)
 * @author Dsvyas
 * @author Sushant savla
 */
$messages['gu'] = array(
	'fancycaptcha-addurl' => 'તમારા ફેરફારમાં નવી બાહ્ય કડીઓ શામિલ છે.
તમે કરેલા ફેરફારોમાં નવી બાહ્ય કડીઓ સામેલ છે. સ્વચાલિત સ્પેમ/સ્પામ(spam) થી બચવા માટે નીચે આપેલા સરળ દાખલાનો જવાબ તેની બાજુના ખાનામાં લખો
([[Special:Captcha/help|more info]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'આપોઆપ થતી ગુપ્તસંજ્ઞાની ચોરી (password cracking)થી બચાવવા માટે નીચે આપેલા શબ્દ તેની બાજુના ખાનામાં લખો ([[Special:Captcha/help|more info]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'આપોઆપ નવા ખાતા ખુલતા રોકવા માટે નીચે દેખાતા શબ્દો ખાનામાં લખો ([[Special:Captcha/help|વધુ માહિતી]]):', # Fuzzy
	'fancycaptcha-create' => 'પાનું બનાવવા માટે નીચે દેખાતા શબ્દો ખાનામાં ટાઈપ કરો ([[Special:Captcha/help|વધુ માહિતી]]):',
	'fancycaptcha-edit' => 'આ પાનામાં ફેરફાર કરવા માટે નીચે દેખાતા શબ્દો ખાનામાં ટાઈપ કરો ([[Special:Captcha/help|વધુ માહિતી]]):',
	'fancycaptcha-sendemail' => 'આપોઆપ થતી સ્પૅમીંગથી બચાવવા માટે નીચે આપેલા શબ્દ તેની બાજુના ખાનામાં લખો ([[Special:Captcha/help|more info]]):', # Fuzzy
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotem Liss
 */
$messages['he'] = array(
	'fancycaptcha-desc' => 'מחולל תמונות CAPTCHA מגניבות בשביל ההרבחבה Confirm Edit',
	'fancycaptcha-addurl' => 'עריכתכם כוללת קישורים חיצוניים חדשים.
כהגנה מפני זיבול אוטומטי, אנא הקלידו את המילים המופיעות להלן בתיבה ([[Special:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-badlogin' => 'כהגנה מפני פריצת סיסמאות אוטומטית, אנא הקלידו את המילים המופיעות להלן בתיבה ([[Special:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-createaccount' => 'כהגנה מפני יצירת חשבונות אוטומטית, אנא הקלידו את המילים המופיעות להלן בתיבה ([[Special:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-create' => 'כדי ליצור את הדף, אנא הקלידו את המילים המופיעות להלן בתיבה ([[Special:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-edit' => 'כדי לערוך את הדף, אנא הקלידו את המילים המופיעות להלן בתיבה ([[Special:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-sendemail' => 'כדי לעזור להתגונן מפני שליחת זבל אוטומטית, אנא הכניסו את המילים שמופיעות בתיבה למטה ([[Special:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-reload-text' => 'רענון',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 * @author Siddhartha Ghai
 */
$messages['hi'] = array(
	'fancycaptcha-addurl' => 'आपके सम्पादन में नई बाहरी कड़ियाँ हैं।
स्वचालित स्पॅम से बचाव में सहायता के लिये नीचे दिये हुए शब्द बक्से में लिखें ([[Special:Captcha/help|अधिक जानकारी]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'स्वचालित कूटशब्द चोरी से बचाव में सहायता के लिये नीचे दिये हुए शब्द बक्से में लिखें ([[Special:Captcha/help|अधिक जानकारी]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'स्वचालित सदस्य पंजीकरण से बचाव में सहायता के लिये नीचे दिये शब्द बक्से में लिखें ([[Special:Captcha/help|अधिक जानकारी]]):', # Fuzzy
	'fancycaptcha-create' => 'यह पृष्ठ बनाने के लिये कृपया नीचे दिये शब्द बक्से में लिखें ([[Special:Captcha/help|अधिक जानकारी]]):',
	'fancycaptcha-edit' => 'यह पृष्ठ बदलने के लिये, नीचे दिखने वाले अक्षर टेक्स्ट बक्सेमें लिखें ([[Special:Captcha/help|अधिक जानकारी]]):',
);

/** Croatian (hrvatski)
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'fancycaptcha-addurl' => 'Vaše uređivanje sadrži nove vanjske poveznice. Kao zaštitu od automatskog spama,
molimo unesite slova koja vidite na slici dolje: ([[Special:Captcha/help|Pomoć]])', # Fuzzy
	'fancycaptcha-badlogin' => 'Da se spriječi automatiziranje pogađanja lozinki, molimo unesite
slova koja vidite na slici dolje: <br />([[Special:Captcha/help|Pomoć]])', # Fuzzy
	'fancycaptcha-createaccount' => 'Kao zaštitu od automatskog otvaranja računa, pri otvaranju računa trebate
unijeti slova koja vidite na slici: <br />([[Special:Captcha/help|Pomoć]])', # Fuzzy
	'fancycaptcha-create' => 'Da bi stvorili novu stranicu, molimo unesite
slova koja vidite na slici dolje: <br />([[Special:Captcha/help|Pomoć]])',
	'fancycaptcha-edit' => 'Da bi uređivali ovu stranicu, molimo unesite slova koja vidite na slici dolje: <br />([[Special:Captcha/help|Pomoć]])',
	'fancycaptcha-sendemail' => 'Da bi ste nam pomogli protiv automatskog spama, molimo unesite riječi koje su prikazane ispod u okvir ([[Special:Captcha/help|više informacija]]):', # Fuzzy
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'fancycaptcha-addurl' => 'W twojej změnje su nowe eksterne wotkazy. Jako škitna naprawa přećiwo awtomatiskemu spamej zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]).', # Fuzzy
	'fancycaptcha-badlogin' => 'Jako škitna naprawa přećiwo awtomatiskemu zadobywanju do wužiwarskich kontow zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Jako škitna naprawa přećiwo awtomatiskemu wutworjenju wužiwarskich kontow zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]):', # Fuzzy
	'fancycaptcha-create' => 'Zo by stronu wutworić móhł zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]):',
	'fancycaptcha-edit' => 'Zo by stronu wobdźěłować móhł zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]):',
	'fancycaptcha-sendemail' => 'Za škit přećiwo awtomatiskemu spamowanju, zapodaj prošu słowa, kotrež so deleka w kašćiku jewi ([[Special:Captcha/help|dalše informacije]]):', # Fuzzy
);

/** Hungarian (magyar)
 * @author Adam78
 * @author Dorgan
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'fancycaptcha-addurl' => 'A szerkesztésed új külső hivatkozásokat tartalmaz. Az automatizált spamek megelőzése miatt kérjük, hogy add meg a lenti keretben olvasható szavakat ([[Special:Captcha/help|további segítség]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Hogy az automatizált jelszópróbálkozásokat megelőzzük, kérjük, hogy add meg a lenti keretben olvasható szavakat ([[Special:Captcha/help|további segítség]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'A felhasználói fiókok automatizált létrehozásának elkerülésére, kérlek, írd be az alább megjelenő szót a szövegdobozba ([[Special:Captcha/help|segítség]]):', # Fuzzy
	'fancycaptcha-create' => 'A lap létrehozásához kérjük, hogy add meg a lenti keretben olvasható szavakat ([[Special:Captcha/help|további segítség]]):',
	'fancycaptcha-edit' => 'A szerkesztésed új külső linkeket tartalmaz. A spam-robotok elleni védekezés elősegítésére kérlek írd be az alább megjelenő szót a szövegdobozba ([[Special:Captcha/help|segítség]]):',
	'fancycaptcha-sendemail' => 'Hogy segíts az automatikus spammelés elleni védekezésben, kérünk írd be az alábbi szavakat a szövegdobozba ([[Special:Captcha/help|segítség]]):', # Fuzzy
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'fancycaptcha-addurl' => 'Tu modification include nove ligamines externe.
Pro adjutar a proteger le wiki contra le spam automatisate, per favor entra le parolas que appare infra in le quadro ([[Special:Captcha/help|plus info]]):',
	'fancycaptcha-badlogin' => 'Pro adjutar a proteger le wiki contra le furto automatisate de contrasignos, per favor entra le parolas que appare infra in le quadro ([[Special:Captcha/help|plus info]]):',
	'fancycaptcha-createaccount' => 'Pro adjutar a proteger le wiki contra le creation automatisate de contos, per favor entra le parolas que appare infra in le quadro ([[Special:Captcha/help|plus info]]):',
	'fancycaptcha-create' => 'Pro crear le pagina, per favor entra le parolas que appare infra in le quadro ([[Special:Captcha/help|plus info]]):',
	'fancycaptcha-edit' => 'Pro modificar iste pagina, per favor entra le parolas que appare infra in le quadro ([[Special:Captcha/help|plus info]]):',
	'fancycaptcha-sendemail' => 'Pro adjutar a proteger le wiki contra le spam automatisate, per favor entra le parolas que appare infra in le quadro ([[Special:Captcha/help|plus info]]):',
	'fancycaptcha-reload-text' => 'Refrescar',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author IvanLanin
 * @author Iwan Novirion
 */
$messages['id'] = array(
	'fancycaptcha-addurl' => 'Suntingan Anda mencantumkan pranala luar baru. Untuk pelindungan terhadap spam otomatis, harap masukkan kata di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Sebagai pelindungan terhadap pemecah kata kunci otomatis, harap masukkan kata di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Untuk pelindungan terhadap pembuatan akun otomatis, tolong masukkan kata di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):', # Fuzzy
	'fancycaptcha-create' => 'Untuk membuat halaman, silahkan masukkan kata-kata yang muncul di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):',
	'fancycaptcha-edit' => 'Untuk menyunting halaman ini, silahkan masukkan kata-kata yang muncul di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):',
	'fancycaptcha-sendemail' => 'Sebagai pelindungan terhadap spam otomatis, silahkan masukkan kata-kata yang muncul di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):', # Fuzzy
);

/** Iloko (Ilokano)
 * @author Lam-ang
 */
$messages['ilo'] = array(
	'fancycaptcha-addurl' => 'Ti inurnos mo ket adda nagyan na a baro a panilpo ti ruar.
Tapno  masalakniban kadagiti automatiko a spam, pangaasim nga ikabil ti balikas nga agparang dita baba a kahon. ([[Special:Captcha/help|adu pay a pakaammo]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Tapno  masalakniban kadagiti automatiko a pinagsulbar ti kontrasenias, pangaasim nga ikabil ti balikas nga agparang dita baba a kahon. ([[Special:Captcha/help|adu pay a pakaammo]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Tapno  makasalaknib kadagiti automatiko a pinagaramid ti pakabilangan, pangaasim nga ikabil ti balikas nga agparang dita baba a kahon. ([[Special:Captcha/help|adu pay a pakaammo]]):', # Fuzzy
	'fancycaptcha-create' => 'Tapno makaaramid ti panid, pangaasim nga ikabil ti balikas nga agparang dita baba a kahon. ([[Special:Captcha/help|adu pay a pakaammo]]):',
	'fancycaptcha-edit' => 'Tapno makaurnos daytoy a panid, pangaasim nga ikabil ti balikas nga agparang dita baba a kahon. ([[Special:Captcha/help|adu pay a pakaammo]]):',
	'fancycaptcha-sendemail' => 'Tapno  makasalaknib kadagiti automatiko a pinagspam, pangaasim nga ikabil ti balikas nga agparang dita baba a kahon. ([[Special:Captcha/help|adu pay a pakaammo]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Pasadiwaen',
);

/** Icelandic (íslenska)
 * @author Snævar
 */
$messages['is'] = array(
	'fancycaptcha-addurl' => 'Breytingin þín inniheldur viðbætta ytri tengla.
Til þess að hjálpa okkur verjast sjálfvirku auglýsingarusli, vinsamlegast sláðu inn orðin sem birtast hér fyrir neðan í reitinn ([[Special:Captcha/help|frekari upplýsingar]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Til þess að hjálpa okkur að verjast gegn sjálfvirkum leyniorðaárásum, vinsamlegast sláðu inn orðin sem birtast hér fyrir neðan í reitinn ([[Special:Captcha/help|frekari upplýsingar]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Til þess að hjálpa okkur að verjast sjálfvirkri stofnun aðganga, vinsamlegast sláðu inn orðin sem birtast hér fyrir neðan í reitinn ([[Special:Captcha/help|frekari upplýsingar]]):', # Fuzzy
	'fancycaptcha-create' => 'Til þess að búa til þessa síðu, vinsamlegast sláðu inn orðin sem birtast hér fyrir neðan í reitinn ([[Special:Captcha/help|frekari upplýsingar]]):',
	'fancycaptcha-edit' => 'Til þess að breyta þessari síðu, vinsamlegast sláðu inn orðin að neðan í reitinn ([[Special:Captcha/help|frekari upplýsingar]]):',
	'fancycaptcha-sendemail' => 'Til þess að hjálpa okkur að verjast sjálfvirkum auglýsingapósti, vinsamlegast sláðu inn orðin hér fyrir neðan í reitinn ([[Special:Captcha/help|frekari upplýsinngar]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Endurhlaða',
);

/** Italian (italiano)
 * @author Beta16
 * @author BrokenArrow
 * @author Darth Kule
 * @author Nemo bis
 */
$messages['it'] = array(
	'fancycaptcha-addurl' => "La modifica richiesta aggiunge dei collegamenti esterni alla pagina; come misura precauzionale contro l'inserimento automatico di spam, ti chiediamo gentilmente di inserire nella casella sottostante le parole che compaiono di seguito ([[Special:Captcha/help|come funziona?]]):",
	'fancycaptcha-badlogin' => 'Come misura precauzionale contro i tentativi di forzatura automatica della password, ti chiediamo gentilmente di inserire nella casella sottostante le parole che compaiono di seguito ([[Special:Captcha/help|come funziona?]]):',
	'fancycaptcha-createaccount' => 'Come misura precauzionale contro i tentativi di registrazione automatica, ti chiediamo gentilmente di inserire nella casella sottostante le parole che compaiono di seguito ([[Special:Captcha/help|come funziona?]]):',
	'fancycaptcha-create' => 'Per creare la pagina si prega di inserire nella casella sottostante le parole che compaiono nella casella di seguito ([[Special:Captcha/help|come funziona?]]):',
	'fancycaptcha-edit' => 'Per modificare questa pagina si prega di inserire nella casella sottostante le parole che compaiono di seguito ([[Special:Captcha/help|come funziona?]]):',
	'fancycaptcha-sendemail' => 'Come misura precauzionale nei confronti dei messaggi di spam automatici, ti chiediamo gentilmente di inserire nella casella sottostante le parole che compaiono di seguito ([[Special:Captcha/help|come funziona?]]):',
	'fancycaptcha-reload-text' => 'Aggiorna',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Marine-Blue
 * @author Shirayuki
 */
$messages['ja'] = array(
	'fancycaptcha-desc' => 'Confirm Edit 用の装飾的な CAPTCHA ジェネレーター',
	'fancycaptcha-addurl' => 'あなたは新しい外部リンクを追加しようとしています。
ウィキへの自動スパム攻撃を防ぐため、お手数をおかけしますが下記の確認用の文字列を欄に入力してください ([[Special:Captcha/help|詳細]]):',
	'fancycaptcha-badlogin' => 'ウィキへの自動パスワードクラック攻撃を防ぐため、お手数をおかけしますが下記の確認用の文字列を欄に入力してください ([[Special:Captcha/help|詳細]]):',
	'fancycaptcha-createaccount' => 'ウィキでのアカウント自動作成を防ぐため、お手数をおかけしますが下記の確認用の文字列を欄に入力してください ([[Special:Captcha/help|詳細]]):',
	'fancycaptcha-create' => 'ページを新規作成するには、下記の確認用の文字列を欄に入力してください ([[Special:Captcha/help|詳細]]):',
	'fancycaptcha-edit' => 'このページを編集するには、下記の確認用の文字列を欄に入力してください ([[Special:Captcha/help|詳細]]):',
	'fancycaptcha-sendemail' => 'ウィキへの自動スパム攻撃を防ぐため、お手数をおかけしますが下記の確認用の文字列を欄に入力してください ([[Special:Captcha/help|詳細]]):',
	'fancycaptcha-reload-text' => '更新',
);

/** Jutish (jysk)
 * @author Huslåke
 */
$messages['jut'] = array(
	'fancycaptcha-addurl' => 'Din ændring tilføjer nye eksterne henvisninger. For at beskytte mod automatiseret spam, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'For at beskytte mod automatiske forsøg på at gætte kodeord, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'For at beskytte mod automatisk oprettelse af brugernavne, der bruges til spam, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):', # Fuzzy
	'fancycaptcha-create' => 'For at oprette en ny side, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-edit' => 'or at redigere denne side
([[Special:Captcha/help|more info]]):',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'fancycaptcha-addurl' => 'Suntingan panjenengan iku ngandhut pranala jaba anyar. Kanggo pangreksan marang spam otomatis, mangga lebokna tembung sing kapacak ing ngisor iki ing kothak sing wis cumepak ([[Special:Captcha/help|info jangkep]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Kanggo ngréwangi pangreksan marang parengkahan kunci sandhi otomatis, mangga lebokna tembung sing kapacak ing ngisor iki ing kothak sing wis cumepak ([[Special:Captcha/help|info jangkep]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Minangka pangreksan marang rékening (akun) sing digawé otomatis, tulung lebokna tembung sing kapacak ing ngisor iki ing kothak sing wis cumepak ([[Special:Captcha/help|info jangkep]]):', # Fuzzy
	'fancycaptcha-create' => 'Suntingan panjenengan ngandhut pranala jaba anyar. Kanggo nggawé kaca iki, mangga isèkna tembung-tembung sing ana ing kothak iki ([[Special:Captcha/help|info jangkep]]):',
	'fancycaptcha-edit' => 'Suntingan panjenengan ngandhut pranala jaba anyar. Kanggo nyunting kaca iki, mangga isèkna tembung-tembung sing ana ing kothak iki ([[Special:Captcha/help|info jangkep]]):',
);

/** Georgian (ქართული)
 * @author David1010
 * @author ITshnik
 */
$messages['ka'] = array(
	'fancycaptcha-addurl' => 'თქვენი ცვლილება შეიცავს ახალ გარე ბმულებს.
ავტომატური სპამინგისგან თავდაცვის მიზნით, გთხოვთ, შეიყვანოთ ქვემოთ მოცემული სიტყვები ყუთში ([[Special:Captcha/help|მეტი ინფორმაცია]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'პაროლების ავტომატური გატეხვისგან თავდაცვის მიზნით, გთხოვთ, შეიყვანოთ ქვემოთ მოცემული სიტყვები ყუთში ([[Special:Captcha/help|მეტი ინფორმაცია]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'ანგარიშების ავტომატური რეგისტრაციისაგან თავდაცვის მიზნით, გთხოვთ, შეიყვანოთ ნაჩვენები სიმბოლოები ტექსტურ ველში ([[Special:Captcha/help|დეტალურად]]):', # Fuzzy
	'fancycaptcha-create' => 'გვერდის შესაქმნელად, გთხოვთ, შეიყვანეთ ასოები, რომლებიც ნაჩვენებია ქვედა სურათზე ([[Special:Captcha/help|დეტალურად…]]):',
	'fancycaptcha-edit' => 'გვერდის რედაქტირებისათვის, გთხოვთ, შეიყვანეთ ასოები, რომლებიც ნაჩვენებია ქვედა სურათზე ([[Special:Captcha/help|დეტალურად…]]):',
	'fancycaptcha-sendemail' => 'ავტომატური სპამისაგან თავდაცვის მიზნით, გთხოვთ, შეიყვანოთ ქვევით ნაჩვენები სიტყვა ტექსტურ ველში ([[Special:Captcha/help|მეტი ინფორმაცია]]):', # Fuzzy
);

/** Kara-Kalpak (Qaraqalpaqsha)
 * @author Atabek
 */
$messages['kaa'] = array(
	'fancycaptcha-createaccount' => "Jan'a akkauntlardın' avtomatik jaratılıwının' aldın alıw ushın, to'mendegi
ko'rsetilgen so'zlerdi kiritin'([[{{ns:special}}:Captcha/help|ko'birek mag'lıwmat]]):", # Fuzzy
);

/** Kazakh (Arabic script) (قازاقشا (تٴوتە)‏)
 */
$messages['kk-arab'] = array(
	'fancycaptcha-addurl' => 'تٷزەتۋٸڭٸزدە جاڭا سىرتقى سٸلتەمەلەر بار ەكەن. ٶزدٸك تٷردە «سپام» جاسالۋىنان قورعانۋ ٷشٸن,
تٶمەندەگٸ كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'قۇپييا سٶزدٸ ٶزدٸكتٸ بۇزدىرۋدان قورعانۋ ٷشٸن, تٶمەندەگٸ
كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'جاڭا تٸركەلگٸ ٶزدٸكتٸ جاسالۋىنان قورعانۋ ٷشٸن, تٶمەندەگٸ
كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):', # Fuzzy
	'fancycaptcha-create' => 'تٷزەتۋٸڭٸزدە جاڭا سىرتقى سٸلتەمەلەر بار ەكەن. ٶزدٸك تٷردە «سپام» جاسالۋىنان قورعانۋ ٷشٸن,
تٶمەندەگٸ كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):', # Fuzzy
	'fancycaptcha-edit' => 'تٷزەتۋٸڭٸزدە جاڭا سىرتقى سٸلتەمەلەر بار ەكەن. ٶزدٸك تٷردە «سپام» جاسالۋىنان قورعانۋ ٷشٸن,
تٶمەندەگٸ كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):', # Fuzzy
);

/** Kazakh (Cyrillic script) (қазақша (кирил)‎)
 * @author Arystanbek
 */
$messages['kk-cyrl'] = array(
	'fancycaptcha-addurl' => 'Түзетуіңізде жаңа сыртқы сілтемелер бар екен. Өздік түрде «спам» жасалуынан қорғану үшін,
төмендегі көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Құпия сөзді өздікті бұздырудан қорғану үшін, төмендегі
көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Жаңа тіркелгі өздікті жасалуынан қорғану үшін, төмендегі
көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):', # Fuzzy
	'fancycaptcha-create' => 'Түзетуіңізде жаңа сыртқы сілтемелер бар екен. Өздік түрде «спам» жасалуынан қорғану үшін,
төмендегі көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):', # Fuzzy
	'fancycaptcha-edit' => 'Түзетуіңізде жаңа сыртқы сілтемелер бар екен. Өздік түрде «спам» жасалуынан қорғану үшін,
төмендегі көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Жаңарту',
);

/** Kazakh (Latin script) (qazaqşa (latın)‎)
 */
$messages['kk-latn'] = array(
	'fancycaptcha-addurl' => 'Tüzetwiñizde jaña sırtqı siltemeler bar eken. Özdik türde «spam» jasalwınan qorğanw üşin,
tömendegi körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Qupïya sözdi özdikti buzdırwdan qorğanw üşin, tömendegi
körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Jaña tirkelgi özdikti jasalwınan qorğanw üşin, tömendegi
körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):', # Fuzzy
	'fancycaptcha-create' => 'Tüzetwiñizde jaña sırtqı siltemeler bar eken. Özdik türde «spam» jasalwınan qorğanw üşin,
tömendegi körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):', # Fuzzy
	'fancycaptcha-edit' => 'Tüzetwiñizde jaña sırtqı siltemeler bar eken. Özdik türde «spam» jasalwınan qorğanw üşin,
tömendegi körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):', # Fuzzy
);

/** Khmer (ភាសាខ្មែរ)
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'fancycaptcha-addurl' => 'កំណែប្រែរបស់អ្នកមានតំណភ្ជាប់ខាងក្រៅ។

ដើម្បីការពារពីស្ប៉ាម(spam)ស្វ័យប្រវត្តិ សូមបញ្ជូលពាក្យខាងក្រោមទៅក្នុងប្រអប់ ([[Special:Captcha/help|ព័ត៌មានបន្ថែម]])៖', # Fuzzy
	'fancycaptcha-badlogin' => 'ដើម្បីការពារការបំបែកពាក្យសំងាត់ដោយស្វ័យប្រវត្តិ សូមបញ្ជូលពាក្យខាងក្រោមទៅក្នុងប្រអប់ ([[Special:Captcha/help|ព័ត៌មានបន្ថែម]])៖', # Fuzzy
	'fancycaptcha-createaccount' => 'ដើម្បីការពារការបង្កើតគណនីដោយស្វ័យប្រវត្តិ សូមបញ្ជូលពាក្យខាងក្រោមទៅក្នុងប្រអប់ ([[Special:Captcha/help|ព័ត៌មានបន្ថែម]])៖', # Fuzzy
	'fancycaptcha-create' => 'ដើម្បីបង្កើតទំព័រនេះ សូមបញ្ជូលពាក្យខាងក្រោមទៅក្នុងប្រអប់ ([[Special:Captcha/help|ព័ត៌មានបន្ថែម]])៖',
	'fancycaptcha-edit' => 'ដើម្បីកែប្រែទំព័រនេះ សូមបញ្ជូលពាក្យខាងក្រោមទៅក្នុងប្រអប់ ([[Special:Captcha/help|ព័ត៌មានបន្ថែម]])៖',
);

/** Korean (한국어)
 * @author Kwj2772
 * @author ToePeu
 * @author 아라
 */
$messages['ko'] = array(
	'fancycaptcha-desc' => '편집 확인에 대한 공상 CAPTCHA(캡차) 생성기',
	'fancycaptcha-addurl' => '편집에 새로운 바깥 링크가 포함되어 있습니다.
자동화된 스팸으로부터 위키를 보호하기 위해, 친절하게 요청하며 아래 상자에 나타나는 낱말을 입력해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'fancycaptcha-badlogin' => '자동화된 비밀번호 깨기로부터 위키를 보호하기 위해, 친절하게 요청하며 아래 상자에 나타나는 낱말을 입력해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'fancycaptcha-createaccount' => '자동화된 계정 만들기로부터 위키를 보호하기 위해, 친절하게 요청하며 아래 상자에 나타나는 낱말을 입력해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'fancycaptcha-create' => '문서를 만드려면 아래의 상자 안에 있는 낱말을 입력해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'fancycaptcha-edit' => '이 문서를 편집하려면 아래의 상자 안에 있는 낱말을 입력해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'fancycaptcha-sendemail' => '자동화된 스팸으로부터 위키를 보호하기 위해, 친절하게 요청하며 아래 상자에 나타나는 낱말을 입력해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'fancycaptcha-reload-text' => '새로 고침',
);

/** Karachay-Balkar (къарачай-малкъар)
 * @author Iltever
 */
$messages['krc'] = array(
	'fancycaptcha-createaccount' => 'Тергеу джазыуланы (аккаунтланы) автомат халда регистрация этиуню къоймаз ючюн, текстлик терезеде суратланнган символланы джазыгъыз ([[Special:Captcha/help|толуракъ]]):', # Fuzzy
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'fancycaptcha-desc' => 'Määt e nett Käptsche för dä <code lang="en">Confirm Edit</code> Projramm-Zohsatz',
	'fancycaptcha-addurl' => 'Do häß neu Lingks op frembde Websigge dobei jedonn.
Mer schöze uns Wiki jäje automatesche SPAM, dröm
don di Wööter en dat Käßje endraare. (Verklierung)', # Fuzzy
	'fancycaptcha-badlogin' => 'Mer schöze Metmaacher en unsem Wiki jäje automatesche
Paßwoot-Knackerei, dröm don di Wööt onge en dat Käßje
endraare. (Verklierung)', # Fuzzy
	'fancycaptcha-createaccount' => 'Mer schöze uns Wiki dojäje, dat mer en Masse automatesch
Metmaacher aanmeldt. Dröm beß esu joot un
don di Wööt onge en dat Käßje endraare. (Verklierung)', # Fuzzy
	'fancycaptcha-create' => 'Öm di Sigg neu aanzelääje, don di Wööt onge en dat Käßje endraare. (Verklierung)',
	'fancycaptcha-edit' => 'Öm de Sigg ze ändere, don di Wööt onge en dat Käßje endraare. ([[Special:Captcha/help|Verklierung]])',
	'fancycaptcha-sendemail' => 'Öm et Wiki jääje automattesch enjedraare SPAM ze schötze,
bes esu joot, donn di Wööter enjävve, di en däm Käßje heh dronger shtonn.
([[Special:Captcha/help|Mieh Enfommazjuhne]])', # Fuzzy
	'fancycaptcha-reload-text' => 'Nöü Aanzeije!',
);

/** Cornish (kernowek)
 * @author Kernoweger
 * @author Nrowe
 */
$messages['kw'] = array(
	'fancycaptcha-createaccount' => "Rag gwitha rag gwruthyl akontow yawtomategys, entrewgh an geryow a omdhiskwa a-woles y'n gist ([[Special:Captcha/help|moy kedhlow]]):", # Fuzzy
);

/** Kyrgyz (Кыргызча)
 * @author Chorobek
 */
$messages['ky'] = array(
	'fancycaptcha-sendemail' => 'Автоматташтырылган спамдан коргонууга жардам катары бул сөздөрдү төмөндөгү көзөнөккө киргизиңиз ([[Special:Captcha/help|more info]]):', # Fuzzy
);

/** Latin (Latina)
 * @author SPQRobin
 */
$messages['la'] = array(
	'fancycaptcha-addurl' => 'Emendatione tua insunt nexus externi; ut spam automaticum vitemus, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Ut vitemus ne tesserae frangantur, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Ut creationem rationum automaticam vitemus, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):', # Fuzzy
	'fancycaptcha-create' => 'Ad paginam creandum, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):',
	'fancycaptcha-edit' => 'Ad hanc paginam recensendum, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'fancycaptcha-addurl' => "An Ärer Ännerung sinn nei extern Linken.

Fir dës Wiki géint automatiséierte Spam ze schütze froe mir Iech d'Wierder anzeginn, déi an der Këscht ënnendrënner stinn ([[Special:Captcha/help|méi Informatiounen]]):",
	'fancycaptcha-badlogin' => "Fir ze hëllefe fir d'automatiséiert Hacke vu Passwierder méi schwéier ze maachen, froe mir Iech fir d'Wierder anzeginn, déi an der Këscht ënnendrënner stinn ([[Special:Captcha/help|méi Informatiounen]]):",
	'fancycaptcha-createaccount' => "Fir d'Wiki géint automatiséiert Opmaache vu Benotzerkonte ze schützen, froe mir Iech d'Wierder  déi an der Këscht ënnendrënner stinn anzeginn ([[Special:Captcha/help|méi Informatiounen]]):",
	'fancycaptcha-create' => 'Fir dës Säit unzeleeën, gitt w.e.g. déi Wierder an, déi an der Këscht ënnendrënner stinn ([[Special:Captcha/help|méi Informatiounen]]):',
	'fancycaptcha-edit' => "Fir dës Säit z'änneren, gitt w.e.g. déi Wierder an, déi an der Këscht ënnendrënner stinn ([[Special:Captcha/help|méi Informatiounen]]):",
	'fancycaptcha-sendemail' => "Fir eis géint automatescht Spammen ze schützen, froe mir Iech fir d'Wierder déi an der Këscht ënnendrënner stinn anzeginn ([[Special:Captcha/help|méi Informatiounen]]):",
	'fancycaptcha-reload-text' => 'Aktualiséieren',
);

/** Limburgish (Limburgs)
 * @author Matthias
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'fancycaptcha-addurl' => 'Uw bewerking bevat nieuwe externe links. Voer de woorden die
hieronder verschijnen in het invoerveld in als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Voer de woorden die hieronder verschijnen in het invoerveld in als bescherming tegen het automatisch kraken van wachtwoorden ([[Special:Captcha/help|meer informatie]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Voer de woorden die hieronder verschijnen in het invoerveld in
ter bescherming tegen het automatisch aanmaken van gebruikers ([[Special:Captcha/help|meer informatie]]):', # Fuzzy
	'fancycaptcha-create' => 'Uw bewerking bevat nieuwe externe links. Voer de woorden die
hieronder verschijnen in het invoerveld in als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-edit' => 'Uw bewerking bevat nieuwe externe links. Voer de woorden die
hieronder verschijnen in het invoerveld in als bescherming tegen automatische spam ([[Special:Captcha/help|mie informatie]]):',
	'fancycaptcha-sendemail' => "Veur de weurd die hie onger versjienen in 't inveurvèldj in es besjerming taege geautometiseerde spam ([[Special:Captcha/help|mier info]]):", # Fuzzy
);

/** Lao (ລາວ)
 */
$messages['lo'] = array(
	'fancycaptcha-addurl' => 'ການດັດແກ້ຂອງທ່ານ ມີລິ້ງຄ໌ພາຍນອກ. ເພື່ອປ້ອງກັນ ສະແປມອັດຕະໂນມັດ, ກະລຸນາ ພິມຄຳສັບຂ້າງລຸ່ມນີ້ ໃສ່ໃນກັບ ([[Special:Captcha/help|ຂໍ້ມູນເພີ່ມຕື່ມ]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'ເພື່ອຊ່ອຍປ້ອງກັນ ການສືບຄົ້ນຫາລະຫັດຜ່ານແບບອັດຕະໂນມັດ, ກະລຸນາ ພິມຄຳສັບ ຂ້າງລຸ່ມນີ້ ໃສ່ໃນກັບ ([[Special:Captcha/help|ຂໍ້ມູນເພີ່ມຕື່ມ]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'ເພື່ອປ້ອງກັນ ການສ້າງບັນຊີແບບອັດຕະໂນມດ, ກະລຸນາພິມ ຄຳສັບຂ້າງລຸ່ມນີ້​ ໃສ່ໃນກັບ ([[Special:Captcha/help|ຂໍ້ມູນເພິ່ມຕືມ]]):', # Fuzzy
	'fancycaptcha-create' => 'ກະລຸນາ ພິມຄຳສັບຂ້າງລຸ່ມນີ້​ ໃສ່ໃນກັບ ເພື່ອສ້າງໜ້ານີ້ ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-edit' => 'ກະລຸນາ ພິມຄຳສັບຂ້າງລຸ່ມນີ້ ໃສ່ໃນກັບ ເພື່ອ ດັດແກ້ໜ້ານີ້ ([[Special:Captcha/help|ຂໍ້ມູນເພີ່ມຕື່ມ]]):',
);

/** لوری (لوری)
 * @author Mogoeilor
 */
$messages['lrc'] = array(
	'fancycaptcha-reload-text' => 'د نؤ كردن',
);

/** Lithuanian (lietuvių)
 * @author Eitvys200
 */
$messages['lt'] = array(
	'fancycaptcha-reload-text' => 'Atnaujinti',
);

/** Latvian (latviešu)
 * @author Papuass
 */
$messages['lv'] = array(
	'fancycaptcha-reload-text' => 'Atjaunināt',
);

/** Minangkabau (Baso Minangkabau)
 * @author Iwan Novirion
 */
$messages['min'] = array(
	'fancycaptcha-createaccount' => 'Untuak palinduangan tahadok pambuek akun otomatis, tolong masuakan kato di bawah ko ka kotak nan tasadio ([[Special:Captcha/help|info labiah lanjuik]]):', # Fuzzy
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'fancycaptcha-desc' => 'Збогатен создавач CAPTCHA за потврда на уредувања',
	'fancycaptcha-addurl' => 'Вашето уредување вклучува нови надворешни врски.
Со цел да се заштитиме од автоматизиран спам, би ве замолиле да ги внесете зборовите на сликичката подолу ([[Special:Captcha/help|повеќе информации]]):',
	'fancycaptcha-badlogin' => 'Со цел да се заштитиме од автоматизирано пробивање на лозинки, би ве замолиле да ги внесете зборовите на сликичката подолу ([[Special:Captcha/help|повеќе информации]]):',
	'fancycaptcha-createaccount' => 'Со цел да се заштитиме од автоматизирано создавање на сметки, би ве замолиле да ги внесете зборовите на сликичката подолу ([[Special:Captcha/help|повеќе информации]]):',
	'fancycaptcha-create' => 'За да создадете страница, внесете ги зборовите на сликичката подолу ([[Special:Captcha/help|повеќе информации]]):',
	'fancycaptcha-edit' => 'За да ја уредите страницава, внесете ги зборовите на сликичката подолу ([[Special:Captcha/help|повеќе информации]]):',
	'fancycaptcha-sendemail' => 'За да се заштитиме од автоматизирано спамирање, би ве замолиле да ги внесете зборовите од сликичката во полето подолу ([[Special:Captcha/help|повеќе информации]]):',
	'fancycaptcha-reload-text' => 'Превчитај',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'fancycaptcha-addurl' => 'താങ്കളുടെ തിരുത്തലലിൽ പുറം കണ്ണികൾ ഉൾപ്പെട്ടിരിക്കുന്നു.
യാന്ത്രിക സ്പാമിനെതിരെയുള്ള സം‌രക്ഷണത്തിന്റെ ഭാഗമായി, താഴെ കാണുന്ന വാക്കുകൾ പെട്ടിയിൽ ടൈപ്പു ചെയ്യുക  ([[Special:Captcha/help|കൂടുതൽ വിവരങ്ങൾ]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'രഹസ്യവാക്ക് യാന്ത്രികമായി  പൊളിക്കുന്നത് തടയുന്നതിന്റെ ഭാഗമായി, താഴെ കാണുന്ന വാക്കുകൾ പെട്ടിയിൽ ടൈപ്പു ചെയ്യുക  ([[Special:Captcha/help|കൂടുതൽ വിവരങ്ങൾ]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'അംഗത്വം യാന്ത്രികമായി സൃഷ്ടിക്കുന്നതു തടയുന്നതൊഴിവാക്കാനുള്ള സം‌രക്ഷണത്തിന്റെ ഭാഗമായി, താഴെ കാണുന്ന വാക്കുകൾ പെട്ടിയിൽ ടൈപ്പു ചെയ്യുക  ([[Special:Captcha/help|കൂടുതൽ വിവരങ്ങൾ]]):', # Fuzzy
	'fancycaptcha-create' => 'ഈ താൾ സൃഷ്ടിക്കുവാൻ താഴെയുള്ള പെട്ടിയിൽ കാണുന്ന വാക്കുകൾ ടൈപ്പു ചെയ്യുക  ([[Special:Captcha/help|കൂടുതൽ വിവരങ്ങൾ]]):',
	'fancycaptcha-edit' => 'ഈ താൾ തിരുത്തുവാൻ ദയവായി താഴെ കാണുന്ന വാക്കുകൾ പെട്ടിയിൽ ടൈപ്പു ചെയ്യുക ([[Special:Captcha/help|കൂടുതൽ വിവരങ്ങൾ]]):',
	'fancycaptcha-sendemail' => 'യാന്ത്രികമായ പാഴെഴുത്ത് ഉൾപ്പെടുത്തലിനുള്ള പ്രതിരോധമെന്ന നിലയിൽ, താഴെ കാണുന്ന വാക്കുകൾ പെട്ടിയിൽ ടൈപ്പ് ചെയ്യുക ([[Special:Captcha/help|കൂടുതൽ വിവരങ്ങൾ]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'പുതുക്കുക',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Mahitgar
 */
$messages['mr'] = array(
	'fancycaptcha-addurl' => 'तुमच्या संपादनात नवीन बाह्य दुवे आहेत.
आपोआप होणार्‍या संपादनांपासून बचावासाठी, खाली दिसणारे शब्द दिलेल्या पृष्ठपेटी मध्ये लिहा ([[Special:Captcha/help|अधिक माहिती]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'आपोआप होणार्‍या परवलीच्या शब्दाच्या चोरीपासून वाचण्यासाठी, खाली दिसणारे शब्द दिलेल्या पृष्ठपेटी मध्ये लिहा ([[Special:Captcha/help|अधिक माहिती]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'आपोआप होणार्‍या सदस्य नोंदणीपासून वाचण्यासाठी, खाली दिसणारे शब्द दिलेल्या पृष्ठपेटी मध्ये लिहा ([[Special:Captcha/help|अधिक माहिती]]):', # Fuzzy
	'fancycaptcha-create' => 'हे पान तयार करण्यासाठी, खाली दिसणारे शब्द दिलेल्या पृष्ठपेटी मध्ये लिहा ([[Special:Captcha/help|अधिक माहिती]]):',
	'fancycaptcha-edit' => 'हे पान संपादित करण्यासाठी, खाली दिसणारे शब्द दिलेल्या पृष्ठपेटी मध्ये लिहा ([[Special:Captcha/help|अधिक माहिती]]):',
	'fancycaptcha-sendemail' => 'आपोआप होणार्‍या उत्पातापासून वाचण्यासाठी, खाली दिसणारे शब्द दिलेल्या पृष्ठपेटी मध्ये लिहा ([[Special:Captcha/help|अधिक माहिती]]):', # Fuzzy
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 * @author Aviator
 */
$messages['ms'] = array(
	'fancycaptcha-addurl' => 'Suntingan anda mengandungi pautan luar baru. Untuk membanteras kegiatan spam automatik, anda diminta mengisi huruf-huruf berikut dalam kotak yang disediakan ([[Special:Captcha/help|maklumat lanjut]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Untuk membanteras kegiatan meneka kata laluan secara automatik, anda diminta mengisi huruf-huruf berikut dalam kotak yang disediakan ([[Special:Captcha/help|maklumat lanjut]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Untuk membanteras kegiatan pembukaan akaun secara automatik, anda diminta mengisi huruf-huruf berikut dalam kotak yang disediakan ([[Special:Captcha/help|maklumat lanjut]]):', # Fuzzy
	'fancycaptcha-create' => 'Untuk mencipta laman ini, anda diminta mengisi huruf-huruf berikut dalam kotak yang disediakan ([[Special:Captcha/help|maklumat lanjut]]):',
	'fancycaptcha-edit' => 'Untuk menyunting laman ini, anda diminta mengisi huruf-huruf berikut dalam kotak yang disediakan ([[Special:Captcha/help|maklumat lanjut]]):',
	'fancycaptcha-sendemail' => 'Untuk membanteras kegiatan spam secara automatik, anda diminta mengisi huruf-huruf berikut dalam kotak yang disediakan ([[Special:Captcha/help|maklumat lanjut]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Muat semula',
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'fancycaptcha-addurl' => "Il-modifika tiegħek tinkludi ħoloq esterni ġodda.
Sabiex tipproteġi kontra spam awtomatiku, jekk jogħġbok solvi din is-somma sempliċi t'hawn taħt u daħħal ir-risposta fil-kaxxa ([[Special:Captcha/help|aktar informazzjoni]]):", # Fuzzy
	'fancycaptcha-badlogin' => 'Bħala prekawzjoni kontra l-infurzar awtomatiku tal-password, jekk jogħġbok daħħal il-kliem li jidhru hawn taħt fil-kaxxa ([[Special:Captcha/help|aktar informazzjoni]]):', # Fuzzy
	'fancycaptcha-createaccount' => "Bħala miżura ta' prekawzjoni kontra l-ħolqien awtomatiku tal-kontijiet, jekk jogħġbok daħħal fil-kaxxa l-ittri li jidhru hawn taħt ([[Special:Captcha/help|aktar informazzjoni]]):", # Fuzzy
	'fancycaptcha-create' => 'Sabiex toħloq din il-paġna, jekk jogħġbok daħħal il-kliem li jidhru hawn taħt fil-kaxxa ([[Special:Captcha/help|aktar informazzjoni]]):',
	'fancycaptcha-edit' => 'Sabiex timmodifika din il-paġna, jekk jogħġbok daħħal il-kliem li jidhru hawn taħt fil-kaxxa ([[Special:Captcha/help|aktar informazzjoni]]):',
	'fancycaptcha-sendemail' => 'Bħala prekawzjoni kontra l-ispam awtomatiku, jekk jogħġbok daħħal fil-kaxxa l-ittri li jidhru hawn taħt ([[Special:Captcha/help|aktar informazzjoni]]):', # Fuzzy
);

/** Norwegian Bokmål (norsk bokmål)
 * @author Danmichaelo
 * @author Harald Khan
 * @author Laaknor
 * @author Njardarlogar
 */
$messages['nb'] = array(
	'fancycaptcha-desc' => 'CAPTCHA-generator for «Confirm Edit»',
	'fancycaptcha-addurl' => 'Din endring inkluderer nye eksterne lenker. For hjelpe oss å beskytte oss mot automatisk spam, vennligst skriv inn ordene som kommer opp i denne boksen ([[Special:Captcha/help|mer informasjon]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Skriv inn ordene som dukker opp i boksen nedenfor for å hjelpe oss å beskytte oss mot passordtyveri ([[Special:Captcha/help|mer informasjon]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Skriv inn ordene som dukker opp i boksen nedenfor for å hjelpe oss å beskytte oss mot automatisk kontoopprettelse ([[Special:Captcha/help|mer informasjon]]):', # Fuzzy
	'fancycaptcha-create' => 'Skriv inn ordene som dukker opp i boksen nedenfor for å opprette siden ([[Special:Captcha/help|mer informasjon]]):',
	'fancycaptcha-edit' => 'For å endre denne siden, vennligst skriv inn ordene som dukker opp i boksen nedenfor ([[Special:Captcha/help|mer informasjon]]):',
	'fancycaptcha-sendemail' => 'For å beskytte mot automatisert spam så må du skrive ordene under inn i tekstboksen ([[Special:Captcha/help|mer informasjon]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Last inn ny',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'fancycaptcha-addurl' => 'In dien Ännern sünd ne’e Weblenken in.
As Schutz gegen automaatsch Spam, geev disse Bookstavenreeg in dat Feld ünnen in ([[Special:Captcha/help|mehr Infos]]).', # Fuzzy
	'fancycaptcha-badlogin' => 'As Schutz gegen Passwoord-Knackers, geev disse Bookstavenreeg in dat Feld ünnen in ([[Special:Captcha/help|mehr Infos]]).', # Fuzzy
	'fancycaptcha-createaccount' => 'As Schutz gegen dat automaatsch Opstellen vun ne’e Brukerkonten, geev disse Bookstavenreeg in dat Feld ünnen in ([[Special:Captcha/help|mehr Infos]]).', # Fuzzy
	'fancycaptcha-create' => 'Disse Sied nee optostellen, geev disse Bookstavenreeg in dat Feld ünnen in ([[Special:Captcha/help|mehr Infos]]).',
	'fancycaptcha-edit' => 'Disse Sied to ännern, geev disse Bookstavenreeg in dat Feld ünnen in ([[Special:Captcha/help|mehr Infos]]).',
);

/** Low Saxon (Netherlands) (Nedersaksies)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'fancycaptcha-addurl' => "Joew bewarking bevat uutgaonde verwiezingen. 
Um dit projekt te bescharmen tegen ongewunste reklame, mu'j t woord dat hieronder steet invullen ([[Special:Captcha/help|hulpe]]):",
	'fancycaptcha-badlogin' => "Um disse webstee te beveiligen tegen t kraken van wachtwoorden, mu'j de woorden die'j hieronder zien effen invullen ([[Special:Captcha/help|hulpe]]):",
	'fancycaptcha-createaccount' => "Um disse wiki te bescharmen tegen t automaties anmaken van gebrukersprofielen mu'j t woord hieronder invullen ([[Special:Captcha/help|hulpe]]):",
	'fancycaptcha-create' => "Um n pagina an te maken, mö'j t woord dat hieronder steet invullen
([[Special:Captcha/help|hulpe]]):",
	'fancycaptcha-edit' => "Joew bewarking bevat nieje uutgaonde verwiezingen. Um disse wiki te bescharmen tegen ongewunste reklame mö'j de woorden hieronder invullen ([[Special:Captcha/help|hulpe]]):",
	'fancycaptcha-sendemail' => 'Voer de woorden die hieronder staon in t invoerveld in as bescharming tegen automatiese ongewunste reklame 
([[Special:Captcha/help|hulpe]]):',
	'fancycaptcha-reload-text' => 'Verniejen',
);

/** Dutch (Nederlands)
 * @author HanV
 * @author Siebrand
 */
$messages['nl'] = array(
	'fancycaptcha-desc' => "Generator voor opgedirkte captcha's voor ConfirmEdit",
	'fancycaptcha-addurl' => 'Uw bewerking bevat nieuwe externe koppelingen.
Voer de woorden die hieronder verschijnen in het invoerveld in als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-badlogin' => 'Voer de woorden die hieronder getoond worden in het invoerveld in als bescherming tegen het automatisch kraken van wachtwoorden ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-createaccount' => 'Voer de woorden die hieronder getoond worden in het invoerveld in ter bescherming tegen het geautomatiseerd aanmaken van gebruikers ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-create' => 'Voer de woorden die hieronder verschijnen in het invoerveld in om de pagina aan te maken ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-edit' => 'Voer de woorden die hieronder verschijnen in het invoerveld in om deze pagina te bewerken ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-sendemail' => 'Voer de woorden die hieronder getoond worden in het invoerveld in als bescherming tegen spam ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-reload-text' => 'Verversen',
);

/** Nederlands (informeel)‎ (Nederlands (informeel)‎)
 * @author Siebrand
 */
$messages['nl-informal'] = array(
	'fancycaptcha-addurl' => 'Je bewerking bevat nieuwe externe koppelingen.
Voer de woorden die hieronder verschijnen in het invoerveld in als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):', # Fuzzy
);

/** Norwegian Nynorsk (norsk nynorsk)
 * @author Harald Khan
 * @author Njardarlogar
 */
$messages['nn'] = array(
	'fancycaptcha-addurl' => 'Endringa di inneheld nye utlenkjer.
For å hjelpa oss med å unngå automatisert spam, ver venleg og skriv inn orda som kjem til syne i boksen under ([[Special:Captcha/help|meir informasjon]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Skriv inn orda som kjem til syne i boksen nedanfor for å hjelpa oss med å unngå automatisert passordknekking ([[Special:Captcha/help|meir informasjon]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Skriv inn orda som kjem til syne i boksen nedanfor for å hjelpa oss med å unngå automatisk kontooppretting ([[Special:Captcha/help|meir informasjon]]):', # Fuzzy
	'fancycaptcha-create' => 'Skriv inn orda som kjem til syne i boksen nedanfor for å oppretta sida ([[Special:Captcha/help|meir informasjon]]):',
	'fancycaptcha-edit' => 'For å endra denne sida, ver venleg og skriv inn orda som kjem til syne i boksen nedanfor ([[Special:Captcha/help|meir informasjon]]):',
	'fancycaptcha-sendemail' => 'For å hjelpa til mot sjølvgåande spamming, skriv inn orda som kjem til syne i boksen under ([[Special:Captcha/help|meir informasjon]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Oppdater',
);

/** Occitan (occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'fancycaptcha-desc' => "Generador d’imatges ''captcha'' antirobòts que demandan una confirmacion umana de las modificacions.",
	'fancycaptcha-addurl' => "Vòstra modificacion inclutz de ligams extèrnes novèls. Per verificar que s’agisson pas de spams automatics, epicatz los mots qu'apareisson dins la bóstia çaijós ([[Special:Captcha/help|mai d’entresenhas]]) :", # Fuzzy
	'fancycaptcha-badlogin' => 'Per ajudar a vos protegir contra lo piratatge de compte per de senhals automatics, mercés de picar los mots que s’afichan dins aquesta bóstia ([[Special:Captcha/help|Ajuda]]) :', # Fuzzy
	'fancycaptcha-createaccount' => 'Coma proteccion contra las creacions de compte abusivas, picatz los mots çaijós dins la bóstia ([[Special:Captcha/help|mai d’entresenhas]]) :', # Fuzzy
	'fancycaptcha-create' => "Vòstra modificacion inclutz de ligams extèrnes novèls. Per verificar que s’agisson pas de spams automatics, picatz los mots qu'apareisson dins la bóstia çaijós ([[Special:Captcha/help|mai d’entresenhas]]) :",
	'fancycaptcha-edit' => "Vòstra modificacion inclutz de ligams extèrnes novèls. Per verificar que s’agís pas de spam automatic, picatz los mots qu'apareisson dins la bóstia çaijós ([[Special:Captcha/help|mai d’entresenhas]]) :",
	'fancycaptcha-sendemail' => "Per tal de nos ajudar a prevenir lo spam automatic, entratz los mots qu'apareisson dins la bóstia çaijós ([[Special:Captcha/help|mai d’informacions]]) :", # Fuzzy
	'fancycaptcha-reload-text' => 'Actualizar',
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Psubhashish
 */
$messages['or'] = array(
	'fancycaptcha-addurl' => 'ଆପଣଙ୍କ ସମ୍ପାଦନାରେ ନୂଆ ବାହାର ଲିଙ୍କ ରହିଛି ।
ଆପେଆପେ ହେଉଥିବା ସ୍ପାମର ପ୍ରତିରୋଧ କରିବା ନିମନ୍ତେ  ଘର ତଳେ ଥିବା ଶବ୍ଦସବୁ ଦିଅନ୍ତୁ ([[Special:Captcha/help|ଅଧିକ ବିବରଣୀ]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'ଆପେଆପେ ହେଉଥିବା ପାସବାର୍ଡ଼ ଚୋରାଇବାକୁ ପ୍ରତିରୋଧ କରିବା ନିମନ୍ତେ ଦୟାକରି ଏହି ଘରଭିତରେ ଥିବା ଶବ୍ଦସବୁକୁ ତାହା ତଳେ ଥିବା ବାକ୍ସରେ ଟାଇପ କରନ୍ତୁ । ([[Special:Captcha/help|ଅଧିକ ସୂଚନା]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'ଆପେଆପେ ଖାତା ଖୋଲିବାକୁ ଅଟକାଇବା ପାଇଁ ଦୟାକରି ଏହି ଘରଭିତରେ ଥିବା ଶବ୍ଦସବୁକୁ ତାହା ତଳେ ଥିବା ବାକ୍ସରେ ଟାଇପ କରନ୍ତୁ । ([[Special:Captcha/help|ଅଧିକ ସୂଚନା]]):', # Fuzzy
	'fancycaptcha-create' => 'ଏହି ପୃଷ୍ଠାଟିକୁ ତିଆରିବା ନିମନ୍ତେ, ଘର ତଳେ ଥିବା ଶବ୍ଦଟିକୁ ଏଠାରେ ଦିଅନ୍ତୁ ([[Special:Captcha/help|ଅଧିକ ଜାଣନ୍ତୁ]]):',
	'fancycaptcha-edit' => 'ଏହି ପୃଷ୍ଠାଟିକୁ ବଦଳାଇବା ନିମନ୍ତେ, ଘର ତଳେ ଥିବା ଶବ୍ଦଟିକୁ ଏଠାରେ ଦିଅନ୍ତୁ ([[Special:Captcha/help|ଅଧିକ ଜାଣନ୍ତୁ]]):',
	'fancycaptcha-sendemail' => 'ଆପେଆପେ ହେଉଥିବା ସ୍ପାମକୁ ରୋକିବା ନିମନ୍ତେ ଦୟାକରି ଏହି ଘରଭିତରେ ଥିବା ଶବ୍ଦସବୁକୁ ତାହା ତଳେ ଥିବା ବାକ୍ସରେ ଟାଇପ କରନ୍ତୁ । ([[Special:Captcha/help|ଅଧିକ ସୂଚନା]]):', # Fuzzy
);

/** Polish (polski)
 * @author Chrumps
 * @author Sp5uhe
 * @author WTM
 */
$messages['pl'] = array(
	'fancycaptcha-desc' => 'Generator obrazka, którego odczytanie jest wymagane dla zatwierdzenia edycji.',
	'fancycaptcha-addurl' => 'Twoja edycja zawiera nowe linki zewnętrzne. Ze względu na ochronę przed zautomatyzowanym spamem prosimy o wpisanie słów, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|pomoc]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Ze względu na zabezpieczenie przed automatycznym łamaniem haseł prosimy o wpisanie słów, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|pomoc]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Ze względu na ochronę przed automatycznym spamem, aby się zarejestrować musisz wpisać słowo, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|pomoc]])', # Fuzzy
	'fancycaptcha-create' => 'Aby utworzyć tę stronę, przepisz słowa, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|pomoc]]):',
	'fancycaptcha-edit' => 'Aby edytować tę stronę, przepisz słowa, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|pomoc]]):',
	'fancycaptcha-sendemail' => 'Zabezpieczenie przed automatycznie dodawanym spamem. Wprowadzić słowa widoczne w poniższym prostokącie ([[Special:Captcha/help|więcej informacji]]).', # Fuzzy
	'fancycaptcha-reload-text' => 'Odśwież',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Bèrto 'd Sèra
 */
$messages['pms'] = array(
	'fancycaptcha-addurl' => "Soa modìfica a l'ha andrinta dj'anliure esterne neuve.
Për protege la wiki da la rumenta aotomatisà, për piasì, ch'a l'arbata le paròle ch'a s-ciàira ant la casela ([[Special:Captcha/help|për savejne dë pì]]):",
	'fancycaptcha-badlogin' => "Për protege la wiki dai programa ch'a sërco ëd freghé le ciav, për piasì, ch'a l'arbata le paròle ch'a s-ciàira ant la casela ambelessì-sota ([[Special:Captcha/help|për savejne dë pì]]):",
	'fancycaptcha-createaccount' => "Për protege la wiki dai programa ch'a deurbo ëd cont neuv n'aotomàtich, për piasì, ch'a l'arbata le paròle ch'a s-ciàira ant la casela ambelessì-sota ([[Special:Captcha/help|për savejne dë pì]]):",
	'fancycaptcha-create' => "Për creé sta pàgina-i d'amblé, për piasì, ch'a l'arbata le paròle ch'a s-ciàira ambelessì sota ([[Special:Captcha/help|për savejne dë pì]]):",
	'fancycaptcha-edit' => "Për fe-ie dle modìfiche ansima a sta pàgina-sì, për piasì, ch'a l'arbata le paròle ch'a s-ciàira ambelessì sota ([[Special:Captcha/help|për savejne dë pì]]):",
	'fancycaptcha-sendemail' => "Për protege la wiki contra la rumenta automàtica, për piasì ch'a anserissa le paròle che as vëddo ant la casela sì-sota ([[Special:Captcha/help|për savèjne ëd pi]]):",
	'fancycaptcha-reload-text' => 'Agiorné',
);

/** Western Punjabi (پنجابی)
 * @author Khalid Mahmood
 */
$messages['pnb'] = array(
	'fancycaptcha-addurl' => 'تواڈی تبدیلی چ نویں بارلے جوڑ نیں۔
اس صفحے نوں تبدیل کرن واسطے، مہربانی کر کے ڈبے چ دتے گۓ شبداں نوں لکھو ([[Special:Captcha/help|مزید جانکاری]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'اپنے آپ کنجی توڑن دے خلاف مدد واسطے، مہربانی کر کے ڈبے چ دتے گۓ شبداں نوں لکھو ([[Special:Captcha/help|مزید جانکاری]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'اپنے آپ غلط نویں کھاتے بنان نوں روکن واسطے، مہربانی کر کے ڈبے چ دتے گۓ شبداں نوں لکھو ([[Special:Captcha/help|مزید جانکاری]]):', # Fuzzy
	'fancycaptcha-create' => 'صفحہ بنان واسطے، مہربانی کر کے ڈبے چ دتے گۓ شبداں نوں لکھو ([[Special:Captcha/help|مزید جانکاری]]):',
	'fancycaptcha-edit' => 'اس صفحے تے تبدیلی کرن واسطے، مہربانی کر کے ڈبے چ دتے گۓ شبداں نوں لکھو ([[Special:Captcha/help|مزید جانکاری]]):',
	'fancycaptcha-sendemail' => 'اپنے آپ غلط مال آن نوں روکن واسطے، مہربانی کر کے ڈبے چ دتے گۓ شبداں نوں لکھو ([[Special:Captcha/help|مزید جانکاری]]):', # Fuzzy
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'fancycaptcha-create' => 'ددې مخ د جوړلو لپاره، لطفاً ورکړل شوي توري چې څنگه تاسې ته ښکاري هماغسې کټ مټ په لانديني چوکاټ کې وليکی ([[Special:Captcha/help|نور مالومات]]):',
	'fancycaptcha-edit' => 'ددې مخ د سمولو لپاره، لطفاً ورکړل شوي توري چې څنگه تاسې ته ښکاري هماغسې کټ مټ په لانديني چوکاټ کې وليکی ([[Special:Captcha/help|نور مالومات]]):',
);

/** Portuguese (português)
 * @author Hamilton Abreu
 * @author Malafaya
 */
$messages['pt'] = array(
	'fancycaptcha-desc' => 'Gerador sofisticado de captcha para o Confirm Edit',
	'fancycaptcha-addurl' => "A sua edição introduziu links externos novos.
Para ajudar a prevenir o ''spam'' automatizado, por favor, introduza na caixa abaixo as palavras apresentadas ([[Special:Captcha/help|mais informações]]):", # Fuzzy
	'fancycaptcha-badlogin' => 'Para ajudar a prevenir mecanismos automatizados de descoberta de palavras-chave, por favor, introduza na caixa abaixo as palavras apresentadas ([[Special:Captcha/help|mais informações]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Para ajudar a prevenir a criação de contas automatizada, por favor, introduza na caixa abaixo as palavras apresentadas ([[Special:Captcha/help|mais informações]]):', # Fuzzy
	'fancycaptcha-create' => 'Para criar a página, por favor, introduza na caixa abaixo as palavras apresentadas ([[Special:Captcha/help|mais informações]]):',
	'fancycaptcha-edit' => 'Para editar esta página, por favor, introduza na caixa abaixo as palavras apresentadas ([[Special:Captcha/help|mais informações]]):',
	'fancycaptcha-sendemail' => "Para ajudar a prevenir o ''spam'' automatizado, por favor, introduza na caixa as palavras que aparecem abaixo ([[Special:Captcha/help|mais informações]]):", # Fuzzy
);

/** Brazilian Portuguese (português do Brasil)
 * @author Cainamarques
 * @author Eduardo.mps
 * @author Giro720
 */
$messages['pt-br'] = array(
	'fancycaptcha-addurl' => "A sua edição inclui novas ligações externas. Para proteger a wiki contra sistemas automatizados que inserem ''spam'', por favor, introduza as palavras exibidas na seguinte caixa ([[Special:Captcha/help|mais informações]]):",
	'fancycaptcha-badlogin' => 'Para proteger a wiki contra programas automatizados de detecção de senhas, por favor, introduza as palavras exibidas na seguinte caixa ([[Special:Captcha/help|mais informações]]):',
	'fancycaptcha-createaccount' => 'Para proteger a wiki contra sistemas automatizados de criação de contas, solicitamos que introduza as palavras exibidas na seguinte caixa ([[Special:Captcha/help|mais informações]]):',
	'fancycaptcha-create' => 'Para criar a página, por favor, introduza as palavras exibidas na seguinte caixa ([[Special:Captcha/help|mais informações]]):',
	'fancycaptcha-edit' => 'Para editar esta página, por favor, introduza as palavras exibidas na seguinte caixa ([[Special:Captcha/help|mais informações]]):',
	'fancycaptcha-sendemail' => "Para ajudar a combater ''spam'' automatizado, pedimos que, por favor, introduza as palavras que aparecem abaixo ([[Special:Captcha/help|mais informações]]):",
	'fancycaptcha-reload-text' => 'Atualizar',
);

/** Romansh (rumantsch)
 * @author Kazu89
 */
$messages['rm'] = array(
	'fancycaptcha-createaccount' => "Per impedir la creaziun automatica da contos d'utilisader, endatescha per plaschair ils bustabs che vegnan mussads sutvart ([[Special:Captcha/help|dapli infos]]):", # Fuzzy
);

/** Romanian (română)
 * @author Firilacroco
 * @author Mihai
 * @author Minisarm
 */
$messages['ro'] = array(
	'fancycaptcha-addurl' => 'Modificarea dumneavoastră include legături externe noi.
Pentru a împiedica roboții de spam, vă rugăm să introduceți cuvintele care apar mai jos în căsuță ([[Special:Captcha/help|mai multe detalii]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Pentru a împiedica spargerea automată a parolelor, vă rugăm să introduceți cuvintele care apar mai jos în căsuță ([[Special:Captcha/help|mai multe detalii]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Pentru a împiedica crearea automată de conturi, vă rugăm să introduceți cuvintele care apar mai jos în căsuță ([[Special:Captcha/help|mai multe detalii]]):', # Fuzzy
	'fancycaptcha-create' => 'Pentru a crea pagina, vă rugăm să introduceți în casetă cuvintele care apar mai jos ([[Special:Captcha/help|mai multe detalii]]):',
	'fancycaptcha-edit' => 'Pentru a modifica această pagină, vă rugăm să introduceți în casetă cuvintele care apar mai jos ([[Special:Captcha/help|mai multe detalii]]):',
	'fancycaptcha-sendemail' => 'Pentru a împiedica roboții de spam, vă rugăm să introduceți cuvintele care apar mai jos în căsuță ([[Special:Captcha/help|mai multe detalii]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Reîncarcă',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'fancycaptcha-addurl' => "'U cangiamende tue inglude de le collegaminde esterne.
Pe aiutà a proteggere condre a 'u spam automateche, pe piacere mitte le parole ca combare sotte ([[Special:Captcha/help|cchiù 'mbormaziune]]):", # Fuzzy
	'fancycaptcha-badlogin' => 'Pe aiutà a proteggere condre a futteminde automatece de password, pe piacere mitte le parole ca combare aqquà sotte ([[Special:Captcha/help|more info]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Pe aiutà a proteggere condre a ccreazione automateche de cunde utinde, pe piacere mitte le parole ca combare aqquà sotte ([[Special:Captcha/help|more info]]):', # Fuzzy
	'fancycaptcha-create' => 'Pe ccrejà sta pàgene, pe piacere mitte le parole ca combare aqquà sotte ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-edit' => 'Pe cangià sta pàgene, pe piacere mitte le parole combare aqquà sotte ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-sendemail' => "Pe aiutà a proteggere condre a spam automatece, pe piacere mitte le parole ca combare aqquà sotte ([[Special:Captcha/help|cchiù 'mbormaziune]]):", # Fuzzy
	'fancycaptcha-reload-text' => 'Aggiorne',
);

/** Russian (русский)
 * @author Dim Grits
 * @author Lockal
 * @author Okras
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'fancycaptcha-desc' => 'Необычный CAPTCHA-генератор для подтверждения редактирования',
	'fancycaptcha-addurl' => 'Ваша правка содержит новые внешние ссылки.
В целях защиты от спама просим вас ввести слова, показанные ниже в рамке ([[Special:Captcha/help|подробнее…]]):',
	'fancycaptcha-badlogin' => 'В целях защиты от автоматического взлома паролей просим вас ввести слова, показанные ниже в рамке ([[Special:Captcha/help|подробнее…]]):',
	'fancycaptcha-createaccount' => 'Для предотвращения автоматической регистрации учётных записей просим вас ввести слова, показанные ниже в рамке ([[Special:Captcha/help|подробнее…]]):',
	'fancycaptcha-create' => 'Для создания страницы, пожалуйста, введите буквы, которые видны на изображении ниже ([[Special:Captcha/help|подробнее…]]):',
	'fancycaptcha-edit' => 'Для редактирования страницы, пожалуйста, введите буквы, которые видны на изображении ниже ([[Special:Captcha/help|подробнее…]]):',
	'fancycaptcha-sendemail' => 'В целях защиты от автоматического спама просим вас ввести слова, показанные ниже в рамке ([[Special:Captcha/help|подробнее…]]):',
	'fancycaptcha-reload-text' => 'Обновить',
);

/** Rusyn (русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'fancycaptcha-addurl' => 'Ваше едітованя обсягує новы одказы формов URL; про охорону перед автоматічным спамом мусите описати текст з наступного образку. ([[Special:Captcha/help|Што тото значіть?]])', # Fuzzy
	'fancycaptcha-badlogin' => 'В рамках охороны перед автоматічныма пробами угаднути гесло мусите описати текст з наступного образку. ([[Special:Captcha/help|Што тото значіть?]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'В рамках охороны перед автоматічныма створёванями конт мусите про выконаня реґістрації описати текст з наступного образку. ([[Special:Captcha/help|Што тото значіть?]]):', # Fuzzy
	'fancycaptcha-create' => 'Жебы сьте могли створити сторінку, мусите описати текст з наступного образку:([[Special:Captcha/help|Што тото значіть?]])',
	'fancycaptcha-edit' => 'Жебы сьте могли едітовати тоту сторінку, мусите описати текст з наступного образку: ([[Special:Captcha/help|Што тото значіть?]])',
	'fancycaptcha-sendemail' => 'В рамках охороны перед автоматічным спамом мусите описати текст з наступного образку. ([[Special:Captcha/help|Што тото значіть?]]):', # Fuzzy
);

/** Sanskrit (संस्कृतम्)
 * @author Shubha
 */
$messages['sa'] = array(
	'fancycaptcha-addurl' => 'भवतः सम्पादने नूतनबाह्यानुबन्धाः अन्तर्भूताः ।
स्वचालितानिष्टसन्देशेभ्यः रक्षणस्य साहाय्यार्थं कृपया अधः मञ्जूषायां दृश्यमानानि पदानि लिखतु
([[Special:Captcha/help|more info]]) :', # Fuzzy
	'fancycaptcha-badlogin' => 'स्वचालिताभ्यः कूटशब्दभेदनेभ्यः रक्षणस्य साहाय्यार्थं कृपया अधः मञ्जूषायां दृश्यमानानि पदानि लिखतु
([[Special:Captcha/help|more info]]) :', # Fuzzy
	'fancycaptcha-createaccount' => 'स्वचालिताभ्यः लेखासर्जनेभ्यः रक्षणस्य साहाय्यार्थं कृपया अधः मञ्जूषायां दृश्यमानानि पदानि लिखतु
([[Special:Captcha/help|more info]]) :', # Fuzzy
	'fancycaptcha-create' => 'पृष्ठस्य सर्जनाय, अधः मञ्जूषायां दृश्यमानानि पदानि लिखतु ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-edit' => 'अस्य पृष्ठस्य सम्पादनाय, अधः मञ्जूषायां दृश्यमानानि पदानि लिखतु ([[Special:Captcha/help|अधिक जानकारी]]):',
	'fancycaptcha-sendemail' => 'स्वचालिताभ्यः अनिष्टसन्देशेभ्यः रक्षणस्य साहाय्यार्थं कृपया अधः मञ्जूषायां दृश्यमानानि पदानि लिखतु
([[Special:Captcha/help|more info]]) :', # Fuzzy
);

/** Sakha (саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'fancycaptcha-addurl' => 'Эн көннөрүүҥ тас ыйынньыктаах эбит. Спаамтан көмүскэнэр соруктаах дьайыыны оҥор, манна баар тыллары хатылаа ([[Special:Captcha/help|сиһилии…]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Киирии тылы аптамаатынан алдьатыыттан көмүскэнэр дьайыыны оҥороргор көрдөһөбүт, манна ойууламмыт буукубалары хатылаа ([[Special:Captcha/help|сиһилии]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Ааттары аптамаатынан бэлиэтиири суох оҥорор туһуттан бу дьайыыны оҥороргор көрдөһөбүт: ойууламмыт сурук бэлиэлэрин анал сиргэ киллэр  ([[Special:Captcha/help|сиһилии]]):', # Fuzzy
	'fancycaptcha-create' => 'Эн көннөрүүҥ тас ыйынньыктардаах эбит. Спаамтан көмүскэнэр туһуттан манна баар тыллары хатылыыргар көрдөһөбүт ([[Special:Captcha/help|сиһилии…]]):',
	'fancycaptcha-edit' => 'Эн көннөрүүҥ тас ыйынньыктардаах эбит. Спаамтан көмүскэнэр туһуттан манна баар тыллары хатылыыргар көрдөһөбүт ([[Special:Captcha/help|сиһилии…]]):',
	'fancycaptcha-sendemail' => 'Аптамаат спаамтан көмүскэнэр дьайыыны оҥороргор көрдөһөбүт, манна ойууламмыт тыллары хатылаа ([[Special:Captcha/help|сиһилии]]):', # Fuzzy
);

/** Sinhala (සිංහල)
 * @author Singhalawap
 * @author Thameera123
 * @author නන්දිමිතුරු
 */
$messages['si'] = array(
	'fancycaptcha-addurl' => 'ඔබගේ සංස්කරණයෙහි නව බාහිර සබැඳියන් අඩංගුයි.
ස්වයංක්‍රීය අයාචිත තැපෑලෙන් ආරක්ෂා වනු වස්, පහත පෙන්නුම් කෙරෙන වචන  කොටුව තුල ඇතුලත් කරන්න ([[Special:Captcha/help|වැඩිමනත් තොරතුරු]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'ස්වයංක්‍රීය මුරපද බිඳීම වලක්වනු වස්, පහත පෙන්නුම් කෙරෙන වචන  කොටුව තුල ඇතුලත් කරන්න ([[Special:Captcha/help|වැඩිමනත් තොරතුරු]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'ස්වයංක්‍රීයව ගිණුම් තැනීම වැලකුම‍ට සඳහා, පහත දැක්වෙන වචන  CAPTCHA කොටුව තුල ඇතුලත් කරන්න ([[Special:Captcha/help|වැඩිමනත් තොරතුරු]]):', # Fuzzy
	'fancycaptcha-create' => 'පිටුව තනනු වස්, පහත පෙන්නුම් කෙරෙන වචන  කොටුව තුල ඇතුලත් කරන්න ([[Special:Captcha/help|වැඩිමනත් තොරතුරු]]):',
	'fancycaptcha-edit' => 'මෙම පිටුව සංස්කරණය කරනු වස්, පහත පෙන්නුම් කෙරෙන වචන  කොටුව තුල ඇතුලත් කරන්න ([[Special:Captcha/help|වැඩිමනත් තොරතුරු]]):',
	'fancycaptcha-sendemail' => 'ස්වයංක්‍රීය ස්පෑම් කිරීම්වලින් ආරක්ෂා කිරීම සඳහා උදව් වීමට පහත කොටුවේ පෙන්වන වචන ඇතුළත් කරන්න ([[Special:Captcha/help|more info]]):', # Fuzzy
);

/** Slovak (slovenčina)
 * @author Helix84
 * @author Teslaton
 */
$messages['sk'] = array(
	'fancycaptcha-addurl' => 'Vaša úprava obsahuje nové URL odkazy; kvôli ochrane proti automatizovanému spamu je potrebné napísať slová zobrazené na tomto obrázku: <br />([[Special:Captcha/help|Čo je toto?]])', # Fuzzy
	'fancycaptcha-badlogin' => 'Ako ochranu proti automatizovanému lámaniu hesiel, prosím zadajte slová z nasledujúceho obrázka do poľa pre odpoveď ([[Special:Captcha/help|viac informácií]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Kvôli ochrane proti automatizovanému spamu je potrebné napísať slová zobrazené na tomto obrázku, až potom bude vytvorený nový účet: <br />([[Special:Captcha/help|Čo je toto?]])', # Fuzzy
	'fancycaptcha-create' => 'Vaša úprava obsahuje nové URL odkazy; kvôli ochrane proti automatizovanému spamu je potrebné napísať slová zobrazené na tomto obrázku: <br />([[Special:Captcha/help|Čo je toto?]])',
	'fancycaptcha-edit' => 'Vaša úprava obsahuje nové URL odkazy; kvôli ochrane proti automatizovanému spamu je potrebné napísať slová zobrazené na tomto obrázku: <br />([[Special:Captcha/help|Čo je toto?]])',
	'fancycaptcha-sendemail' => 'Ako ochranu proti automatizovanému spamu, prosím zadajte slová z nasledujúceho obrázka do poľa pre odpoveď ([[Special:Captcha/help|ďalšie informácie]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Vygenerovať nový kód',
);

/** Slovenian (slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'fancycaptcha-addurl' => 'Vaše urejanje vključuje nove zunanje povezave.
Zaradi zaščite wikija pred samodejnim smetjem vas prijazno naprošamo, da vnesete spodnje besede v polje ([[Special:Captcha/help|več informacij]]):',
	'fancycaptcha-badlogin' => 'Zaradi zaščite wikija pred samodejnim ugotavljanjem gesel vas prijazno naprošamo, da vnesete spodnje besede v polje ([[Special:Captcha/help|več informacij]]):',
	'fancycaptcha-createaccount' => 'Zaradi zaščite wikija pred samodejnim ustvarjanjem računov vas prijazno naprošamo, da vnesete spodnje besede v polje ([[Special:Captcha/help|več informacij]]):',
	'fancycaptcha-create' => 'Če želite ustvariti stran, prosimo vnesite spodnje besede v polje ([[Special:Captcha/help|več informacij]]):',
	'fancycaptcha-edit' => 'Če želite urediti stran, prosimo vnesite spodnje besede v polje ([[Special:Captcha/help|več informacij]]):',
	'fancycaptcha-sendemail' => 'Zaradi zaščite wikija pred samodejnim smetenjem vas prijazno naprošamo, da vnesete spodnje besede v polje ([[Special:Captcha/help|več informacij]]):',
	'fancycaptcha-reload-text' => 'Osveži',
);

/** Somali (Soomaaliga)
 * @author Abshirdheere
 */
$messages['so'] = array(
	'fancycaptcha-createaccount' => 'Si aad u caawiso dhowritaanka in la iska samaysto Akoon,Fadlan meelaha banaan buux buuxi ee hoostaan ah ([[Special:Captcha/help|Macluumaad dheeraad ah]]):', # Fuzzy
);

/** Albanian (shqip)
 * @author Dori
 * @author Olsi
 */
$messages['sq'] = array(
	'fancycaptcha-addurl' => 'Redaktimi juaj ka lidhje URL të reja dhe si mbrojtje kundër abuzimeve automatike duhet të shtypni çfarë shfaqet tek figura e mëposhtme:<br /> ([[Special:Captcha|Çfarë është kjo?]])', # Fuzzy
	'fancycaptcha-badlogin' => 'Për tu mbrojtur nga metoda automatike të gjetjes së fjalëkalimeve ju kërkojmë të vendosni fjalët e figurës në kuti ([[Special:Captcha/help|më shumë informacion]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Për të mbrojtur kundër hapjeve të llogarive në mënyrë automatike ju lutem shtypni çfarë shfaqet tek figura e mëposhtme ([[Special:Captcha|Çfarë është kjo?]]):', # Fuzzy
	'fancycaptcha-create' => 'Për të krijuar një faqe, ju lutem shtypni çfarë shfaqet tek figura e mëposhtme ([[Special:Captcha|Çfarë është kjo?]]):',
	'fancycaptcha-edit' => 'Për të redaktuar këtë faqe ju lutem shtypni çfarë shfaqet tek figura e mëposhtme ([[Special:Captcha|Çfarë është kjo?]]):',
	'fancycaptcha-sendemail' => "Për t'u mbrojtur nga metoda automatike e gjetjes së fjalëkalimeve ju kërkojmë të vendosni fjalët e figurës në kuti ([[Special:Captcha/help|më shumë informacion]]):", # Fuzzy
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Millosh
 * @author Rancher
 * @author Жељко Тодоровић
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'fancycaptcha-desc' => 'Обогаћен стварач сликовног кода за потврду уређивања',
	'fancycaptcha-addurl' => 'Ваша измена садржи нове спољашње везе.
У циљу заштите од непожељних порука, унесите речи са слике у поље испод ([[Special:Captcha/help|више информација]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'У циљу заштите од пробијања лозинки, унесите речи са слике у поље испод ([[Special:Captcha/help|више информација]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'У циљу заштите од самоотварања налога, унесите речи са слике у поље испод ([[Special:Captcha/help|више информација]]):', # Fuzzy
	'fancycaptcha-create' => 'Да бисте направили страницу, унесите речи са слике у поље испод ([[Special:Captcha/help|више информација]]):',
	'fancycaptcha-edit' => 'Да бисте уредили ову страницу, унесите речи са слике у поље испод ([[Special:Captcha/help|више информација]]):',
	'fancycaptcha-sendemail' => 'У циљу заштите од непожељних порука, унесите речи са слике у поље испод ([[Special:Captcha/help|више информација]]):', # Fuzzy
);

/** Serbian (Latin script) (srpski (latinica)‎)
 * @author Michaello
 * @author Жељко Тодоровић
 */
$messages['sr-el'] = array(
	'fancycaptcha-desc' => 'Obogaćen stvarač slikovnog koda za potvrdu uređivanja',
	'fancycaptcha-addurl' => 'Tvoja izmena uključuje nove spoljne veze. U cilju zaštite od automatskog spama, unesi reči koje se nalaze ispod u kutiju ([[Special:Captcha/help|detaljnije]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'U cilju sprečavanja automatskog otkrivanja lozinki, unesi reči koje se nalaze ispod u kutiju ([[Special:Captcha/help|detaljnije]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'U cilju zaštite od automatskog spama, unesi reči odozdo u kutiju ([[Special:Captcha/help|detaljnije]]):', # Fuzzy
	'fancycaptcha-create' => 'Da bi se napravila stranica, potrebno je uneti reči koje se nalaze ispod kutije ([[Special:Captcha/help|detaljnije]]):',
	'fancycaptcha-edit' => 'Za izmenu ove strane unesi reči koje se nalaze ispod kutije ([[Special:Captcha/help|detaljnije]]):',
	'fancycaptcha-sendemail' => 'U cilju zaštite od automatskog spama, unesi reči odozdo u kutiju ([[Special:Captcha/help|detaljnije]]):', # Fuzzy
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'fancycaptcha-addurl' => 'Dien Beoarbaidenge änthaalt näie externe Ferbiendengen.
Tou Skuts foar automatisierde Spamminge reek dät foulgjende Woud in dät Fäild ien.
Klik dan fonnäien ap „Siede spiekerje“ [[Special:Captcha/help|(Froagen of Probleme?)]].', # Fuzzy
	'fancycaptcha-badlogin' => 'Toun Skuts foar ne Kompromittierenge fon dien Benutserkonto reek dät foulgjende Woud in dät Fäild hierunner ien [[Special:Captcha/help|(Froagen of Probleme?)]]:', # Fuzzy
	'fancycaptcha-createaccount' => 'Toun Skuts foar automatisierde Anloage fon Benutserkonten reek dät foulgjende Woud in dät Fäild hierunner ien [[Special:Captcha/help|(Froagen of Probleme?)]].', # Fuzzy
	'fancycaptcha-create' => 'Tou dät Moakjen fon ju Siede reek dät foulgjende Woud in dät Fäild hierunner ien
[[Special:Captcha/help|(Froagen of Probleme?)]].',
	'fancycaptcha-edit' => 'Tou Beoarbaidenge fon disse Siede reek dät foulgjende Woud in dät Fäild hierunner ien
[[Special:Captcha/help|(Froagen of Probleme?)]].',
);

/** Sundanese (Basa Sunda)
 * @author Irwangatot
 */
$messages['su'] = array(
	'fancycaptcha-edit' => 'Éditan Anjeun ngeusikeun tumbu kaluar nu anyar. Pikeun panangtayungan ka spam otomatis, mangga asukkeun kecap di handapeun ieu ka kotak anu disadiakeun ([[Special:Captcha/help|salengkeupna]]):',
);

/** Swedish (svenska)
 * @author Ainali
 * @author Thurs
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'fancycaptcha-addurl' => 'Din ändring innehåller nya externa länkar.
För att skydda wikin mot
automatisk spam ber vi dig att skriva orden som visas i rutan nedan ([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-badlogin' => 'För att skydda wikin mot automatiserad lösenordsknäckning ber vi dig att skriva
orden som visas i rutan nedan ([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-createaccount' => 'För att skydda wikin mot automatiskt skapade av användarkonton ber vi dig att
skriva orden som visas i rutan nedan ([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-create' => 'För att skapa den här sidan måste du först skriva orden som visas härunder i rutan
([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-edit' => 'För att redigera den här sidan måste du först skriva orden som visas härunder i rutan
([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-sendemail' => 'För att skydda wikin mot automatiserad spam ber vi dig att skriva orden som visas i rutan nedan ([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-reload-text' => 'Uppdatera',
);

/** Tamil (தமிழ்)
 * @author Shanmugamp7
 * @author மதனாஹரன்
 */
$messages['ta'] = array(
	'fancycaptcha-badlogin' => 'தானியங்கு கடவுச் சொல் உடைத்தலிலிருந்து பாதுகாக்க உதவுவதற்காகத் தயவு செய்து கீழேயுள்ள பெட்டியில் தோன்றும் சொற்களை உள்ளிடவும் ([[Special:Captcha/help|கூடிய தகவல்]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'தானியங்கியாக கணக்கு உருவாக்குவதிலிருந்து பாதுகாக்க உதவ, தயவுசெய்து கீழே தெரியும் வார்த்தைகளை பெட்டியில் உள்ளிடவும் ([[Special:Captcha/help|மேலும் விவரங்களுக்கு]]):', # Fuzzy
	'fancycaptcha-create' => 'பக்கத்தை உருவாக்குவதற்காக, தயவு செய்து கீழே பெட்டியில் தோன்றுகின்ற சொற்களை உள்ளிடுங்கள் ([[Special:Captcha/help|கூடிய தகவல்]]):',
	'fancycaptcha-edit' => 'இப்பக்கத்தைத் தொகுப்பதற்குத் தயவு செய்து கீழேயுள்ள பெட்டியில் தோன்றும் சொற்களை உள்ளிடவும் ([[Special:Captcha/help|கூடிய தகவல்]]):',
);

/** Telugu (తెలుగు)
 * @author Mpradeep
 */
$messages['te'] = array(
	'fancycaptcha-addurl' => 'మీ దిద్దుబాటులో కొత్త బయటి లింకులున్నాయి. బాట్లద్వారా చేసే స్పాము నుండి రక్షణను ఏర్పరచేందుకు గాను,
కింద కనిపించే బొమ్మలోని అక్షరాలను పెట్టెలో రాయండి ([[Special:Captcha/help|మరింత సమాచారం]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'సంకేత పదాలను దొంగిలించే ఆటోమాటిక్ ప్రోగ్రాముల నుండి రక్షించేందుకు గాను, కింద కనిపించే బొమ్మలోని అక్షరాలను పెట్టెలో రాయండి ([[Special:Captcha/help|మరింత సమాచారం]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'ఆటోమాటిగ్గా ఖాతాలను సృష్టించడాన్ని నివారించేందుకు, కింద కనిపించే పదాలను
ఈ పెట్టెలో రాయండి ([[Special:Captcha/help|మరింత సహాయం]]):', # Fuzzy
	'fancycaptcha-create' => 'కొత్త పేజీ సృష్టించేందుకు గాను, కింద కనిపించే బొమ్మలోని అక్షరాలను పెట్టెలో రాయండి
([[Special:Captcha/help|మరింత సమాచారం]]):',
	'fancycaptcha-edit' => 'ఈ పేజీలో దిద్దుబాటు చేసేందుకు, కింద కనిపించే బొమ్మలోని అక్షరాలను పెట్టెలో రాయండి
([[Special:Captcha/help|మరింత సమాచారం]]):',
);

/** Tajik (Cyrillic script) (тоҷикӣ)
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'fancycaptcha-addurl' => 'Вироиши шумо пайвандҳои ҷадиди хориҷиро дар бар мегирад. Барои кӯмак ба пешгири аз ҳаразнигори худкор, лутфан вожаеро ки дар тасвир мебинед, ворид кунед ([[Special:Captcha/help|иттилооти бештар]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Барои кӯмак ба пешгири аз шикастани худкори калимаҳои убур, вожаеро ки дар тасвир мебинед, ворид кунед  ([[Special:Captcha/help|иттилооти бештар]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Барои кӯмак аз эҷоди худкори ҳисоби корбарӣ, вожаеро ки дар тасвир мебинед, ворид кунед ([[Special:Captcha/help|иттилооти бештар]]):', # Fuzzy
	'fancycaptcha-create' => 'Барои эҷоди саҳифа, вожаеро ки дар тасвир мебинед, ворид кунед  ([[Special:Captcha/help|иттилооти бештар]]):',
	'fancycaptcha-edit' => 'Барои вироиши ин саҳифа, вожаеро ки дар тасвир мебинед, ворид кунед ([[Special:Captcha/help|иттилооти бештар]]):',
);

/** Tajik (Latin script) (tojikī)
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'fancycaptcha-addurl' => 'Viroişi şumo pajvandhoi çadidi xoriçiro dar bar megirad. Baroi kūmak ba peşgiri az haraznigori xudkor, lutfan voƶaero ki dar tasvir mebined, vorid kuned ([[Special:Captcha/help|ittilooti beştar]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Baroi kūmak ba peşgiri az şikastani xudkori kalimahoi ubur, voƶaero ki dar tasvir mebined, vorid kuned  ([[Special:Captcha/help|ittilooti beştar]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Baroi kūmak az eçodi xudkori hisobi korbarī, voƶaero ki dar tasvir mebined, vorid kuned ([[Special:Captcha/help|ittilooti beştar]]):', # Fuzzy
	'fancycaptcha-create' => 'Baroi eçodi sahifa, voƶaero ki dar tasvir mebined, vorid kuned  ([[Special:Captcha/help|ittilooti beştar]]):',
	'fancycaptcha-edit' => 'Baroi viroişi in sahifa, voƶaero ki dar tasvir mebined, vorid kuned ([[Special:Captcha/help|ittilooti beştar]]):',
);

/** Thai (ไทย)
 * @author Harley Hartwell
 */
$messages['th'] = array(
	'fancycaptcha-addurl' => 'การแก้ไขของคุณมีการเพิ่มลิงก์ไปสู่เว็บไซต์อื่น เพื่อช่วยป้องกันการสแปมอัตโนมัติ กรุณาพิมพ์ข้อความที่คุณเห็นด้านล่างลงในกล่องที่กำหนดให้ ([[Special:Captcha/help|ข้อมูลเพิ่มเติม]])', # Fuzzy
	'fancycaptcha-badlogin' => 'เพื่อป้องกันการแคร็กรหัสผ่านจากกระบวนการอัตโนมัติ กรุณาพิมพ์ข้อความที่คุณเห็นด้านล่างลงในกล่องที่กำหนดให้ ([[Special:Captcha/help|ข้อมูลเพิ่มเติม]])', # Fuzzy
	'fancycaptcha-createaccount' => 'เพื่อป้องกันการสร้างบัญชีผู้ใช้ด้วยกระบวนการอัตโนมัติ กรุณาพิมพ์ข้อความที่คุณเห็นด้านล่างลงในกล่องที่กำหนดให้ ([[Special:Captcha/help|ข้อมูลเพิ่มเติม]])', # Fuzzy
	'fancycaptcha-create' => 'เพื่อสร้างหน้านี้ กรุณาพิมพ์ข้อความที่คุณเห็นด้านล่างลงในกล่องที่กำหนดให้ ([[Special:Captcha/help|ข้อมูลเพิ่มเติม]])',
	'fancycaptcha-edit' => 'เพื่อแก้ไขหน้านี้ กรุณาพิมพ์ข้อความที่คุณเห็นด้านล่างลงในกล่องที่กำหนดให้ ([[Special:Captcha/help|ข้อมูลเพิ่มเติม]])',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'fancycaptcha-badlogin' => 'Awtomatik parol döwülmeginden goranmak üçin, aşakdaky sözleri gutunyň içine ýazyň ([[Special:Captcha/help|jikme-jik]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Hasaby awtomatik parol döwülmeginden goramak üçin, aşakdaky sözleri gutunyň içine ýazyň ([[Special:Captcha/help|jikme-jik]]):', # Fuzzy
	'fancycaptcha-create' => 'Sahypa döretmek üçin, aşakdaky sözleri gutunyň içine ýazyň ([[Special:Captcha/help|jikme-jik]]):',
	'fancycaptcha-edit' => 'Bu sahypany redaktirlemek üçin, aşakdaky sözleri gutunyň içine ýazyň ([[Special:Captcha/help|jikme-jik]]):',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'fancycaptcha-desc' => 'Kaakit-akit na panlikha ng CAPTCHA para sa Pagtiyak ng Pagbago',
	'fancycaptcha-addurl' => "Kabilang sa ginawa mong pagbabago ang bagong panlabas na mga kawing.
Upang makatulong sa pagsasanggalang laban sa kusang pinapadalang mga \"manlulusob\" (''spam''), pakilagay lamang ang mga salitang lumitaw sa ibaba papasok sa loob ng kahon ([[Special:Captcha/help|mas marami pang kabatiran]]):", # Fuzzy
	'fancycaptcha-badlogin' => 'Upang makatulong sa pagsasanggalang laban sa mga kusang paglutas ng hudyat, pakilagay lamang ang mga salitang lumitaw sa ibaba patungo sa loob ng kahon ([[Special:Captcha/help|mas marami pang kabatiran]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Upang makatulong sa pagsasanggalang laban sa kusang paglikha ng kuwenta/akawnt, pakilagay lamang ang mga salitang lumitaw sa ibaba patungo sa loob ng kahon ([[Special:Captcha/help|mas marami pang kabatiran]]):', # Fuzzy
	'fancycaptcha-create' => 'Upang malikha ang pahina, pakilagay lamang ang mga salitang lumitaw sa ibaba patungo sa loob ng kahon ([[Special:Captcha/help|mas marami pang kabatiran]]):',
	'fancycaptcha-edit' => 'Upang mabago ang pahinang ito, pakilagay lamang ang mga salitang lumitaw sa ibaba patungo sa loob ng kahon ([[Special:Captcha/help|mas marami pang kabatiran]]):',
	'fancycaptcha-sendemail' => 'Upang makatulong sa pagsasanggalang laban sa mga kusang pagsalakay ng ispam, pakilagay lamang ang mga salitang lumilitaw sa ibaba sa loob ng kahong ([[Special:Captcha/help|marami pang kabatiran]]):', # Fuzzy
);

/** Turkish (Türkçe)
 * @author Emperyan
 * @author Joseph
 * @author Runningfridgesrule
 */
$messages['tr'] = array(
	'fancycaptcha-addurl' => 'Değişikliğiniz yeni dış bağlantılar içeriyor.
Otomatik spamdan korunmak için, lütfen aşağıdaki sözcükleri kutunun içine yazın ([[Special:Captcha/help|ayrıntılı bilgiler]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Otomatik parola kırma yöntemine karşı korunmak için lütfen aşağıdaki sözcükleri kutunun içine yazınız ([[Special:Captcha/help|ayrıntılı bilgi]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Otomatik hesap oluşturmaya karşı korumaya yardım etmek için, lütfen aşağıdaki kutuda görünen kelimeleri girin ([[Special:Captcha/help|daha fazla bilgi]]):', # Fuzzy
	'fancycaptcha-create' => 'Sayfayı oluşturmak için, lütfen aşağıdaki kutuda görünen kelimeleri girin ([[Special:Captcha/help|daha fazla bilgi]]):',
	'fancycaptcha-edit' => 'Bu sayfayı değiştirmek için, lütfen aşağıdaki kutuda görünen kelimeleri girin ([[Special:Captcha/help|daha fazla bilgi]]):',
	'fancycaptcha-sendemail' => 'Otomatik spamlerden korunmaya yardımcı olmak için, lütfen aşağıda görünen sözcükleri kutuya yazın ([[Special:Captcha/help|daha fazla bilgi]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Yenile',
);

/** Ukrainian (українська)
 * @author Ahonc
 * @author Andriykopanytsia
 * @author Base
 * @author Dim Grits
 * @author Ytsukeng Fyvaprol
 */
$messages['uk'] = array(
	'fancycaptcha-desc' => 'Чудернацький CAPTCHA-генератор для підтвердження редагування',
	'fancycaptcha-addurl' => 'Ваше редагування містить нові зовнішні посилання.
Із метою захисту вікі від спаму просимо вас ввести у текстове поле слова, зображені на картинці ([[Special:Captcha/help|докладніше]]):',
	'fancycaptcha-badlogin' => 'Із метою захисту вікі від автоматичного злому пароля, просимо вас ввести у текстове поле слова, зображені на картинці ([[Special:Captcha/help|докладніше]]):',
	'fancycaptcha-createaccount' => 'Із метою захисту вікі від автоматичного створення облікових записів, просимо вас ввести у текстове поле слова, зображені на картинці ([[Special:Captcha/help|докладніше]]):',
	'fancycaptcha-create' => 'Щоб створити сторінку, будь ласка, введіть у текстове поле слова, зображені на картинці: ([[Special:Captcha/help|докладніше]]):',
	'fancycaptcha-edit' => 'Щоб редагувати цю сторінку, будь ласка, введіть у текстове поле слова, зображені на картинці: ([[Special:Captcha/help|докладніше]]):',
	'fancycaptcha-sendemail' => 'Для захисту вікі від автоматичного спаму просимо вас ввести слова, які показані нижче в полі ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-reload-text' => 'Оновити',
);

/** vèneto (vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'fancycaptcha-addurl' => 'La to modifica la include dei novi colegamenti esterni.
Par jutarne a conbàtar el spam, par piaser inserissi ne la casela le parole che vien fora qua soto ([[Special:Captcha/help|magiori informazion]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Par precauzion contro i tentativi de forzatura automatica de le password, par piaser inserissi ne la casela le parole che vien fora qua soto ([[Special:Captcha/help|magiori informazion]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Par jutarne a inpedir la creazion automatica dei account, par piaser inserissi ne la casela le parole che vien fora qua soto ([[Special:Captcha/help|magiori informazion]]):', # Fuzzy
	'fancycaptcha-create' => 'Par crear la pagina, par piaser inserissi ne la casela le parole che vien fora qua soto ([[Special:Captcha/help|magiori informazion]]):',
	'fancycaptcha-edit' => 'Par modificar la pagina, par piaser inserissi ne la casela le parole che vien fora qua soto ([[Special:Captcha/help|magiori informazion]]):',
	'fancycaptcha-sendemail' => 'Par precauzion contro i tentativi de forzatura automatica de le password, par piaser inserissi ne la casela le parole che vien fora qua soto ([[Special:Captcha/help|magiori informazion]]):', # Fuzzy
	'fancycaptcha-reload-text' => 'Ajorna',
);

/** Vietnamese (Tiếng Việt)
 * @author Cheers!
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'fancycaptcha-desc' => 'Trình sản xuất hình CAPTCHA đặc biệt cho ConfirmEdit',
	'fancycaptcha-addurl' => 'Sửa đổi của bạn có chứa các liên kết ngoài. Để giúp chúng tôi chống lại spam tự động, xin vui lòng nhập những từ xuất hiện ở dưới vào ô ([[Special:Captcha/help|thông tin thêm]]):',
	'fancycaptcha-badlogin' => 'Để giúp chúng tôi tránh bẻ mật khẩu tự động, xin vui lòng nhập những từ xuất hiện ở dưới vào ô ([[Special:Captcha/help|thông tin thêm]]):',
	'fancycaptcha-createaccount' => 'Để giúp chúng tôi tránh mở tài khoản tự động, xin vui lòng nhập những chữ xuất hiện ở dưới vào ô ([[Special:Captcha/help|thông tin thêm]]):',
	'fancycaptcha-create' => 'Để tạo trang, xin hãy nhập những chữ xuất hiện ở dưới vào ô ([[Special:Captcha/help|thông tin thêm]]):',
	'fancycaptcha-edit' => 'Để sửa trang này, xin hãy nhập những từ xuất hiện ở dưới vào ô ([[Special:Captcha/help|thông tin thêm]]):',
	'fancycaptcha-sendemail' => 'Để giúp chúng tôi chống lại spam tự động, xin vui lòng nhập những từ xuất hiện ở dưới vào ô ([[Special:Captcha/help|thông tin thêm]]):',
	'fancycaptcha-reload-text' => 'Làm tươi',
);

/** Volapük (Volapük)
 * @author Smeira
 */
$messages['vo'] = array(
	'fancycaptcha-addurl' => 'Redakam olik keninükon yümis plödik nulik. Ad jelön siti ta peneds itjäfidik, penolös vödis sököl in bokil ([[Special:Captcha/help|nüns pluik]]):', # Fuzzy
	'fancycaptcha-badlogin' => 'Ad jelön siti ta daget itjäfidik letavödas, penolös, begö! vödis dono pejonölis in bokil ([[Special:Captcha/help|nüns pluik]]):', # Fuzzy
	'fancycaptcha-createaccount' => 'Ad jelön siti ta kalijafam itjäfidik, penolös, begö! vödis dono pejonölis in bokil ([[Special:Captcha/help|nüns pluik]]):', # Fuzzy
	'fancycaptcha-create' => 'Ad jafön padi at, penolös, begö! vödis dono pejonöls in bokil ([[Special:Captcha/help|nüns pluik]]):',
	'fancycaptcha-edit' => 'Ad redakön padi at, penolös, begö! vödis dono pejonölis ini bokil ([[Special:Captcha/help|nüns pluik]]):',
);

/** Võro (Võro)
 * @author Võrok
 */
$messages['vro'] = array(
	'fancycaptcha-badlogin' => 'Salasõna automaatsõ vällänuhkmisõ vasta kirodaq pildi päält sõnaq alanolõvahe kasti
([[Special:Captcha/help|Abiteedüs]]):', # Fuzzy
);

/** Walloon (walon)
 * @author Srtxg
 */
$messages['wa'] = array(
	'fancycaptcha-addurl' => "Dins vos candjmints i gn a des dfoûtrinnès hårdêyes (URL).
Po s' mete a houte des robots di spam, nos vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tapez les mots k' aparexhèt chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):", # Fuzzy
	'fancycaptcha-badlogin' => "Po s' mete a houte des des robots ki sayèt d' adviner les screts, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tapez les mots k' aperexhèt chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):", # Fuzzy
	'fancycaptcha-createaccount' => "Po s' mete a houte des des robots k' ahivèt des contes otomaticmint, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tapez les mots k' aparexhèt chal pa dzi ([[Special:Captcha/help|pus di racsegnes]]):", # Fuzzy
	'fancycaptcha-create' => "Por vos poleur ahiver l' pådje, vos dvoz taper les mots k' aparexhèt e l' boesse chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):",
	'fancycaptcha-edit' => "Po candjî cisse pådje ci, vos dvoz taper les mots k' aparexhèt e l' boesse chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):",
	'fancycaptcha-sendemail' => "Po s' mete a houte des robots di spam, nos vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula tapez les mots k' aparexhèt chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):", # Fuzzy
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'fancycaptcha-create' => 'צו שאַפֿן דעם בלאַט, זײַט אזוי גוט און קלאַפט אַרײַן די ווערטער וואָס זענען אינעם קעסטל אונטן ([[Special:Captcha/help|מער אינפֿארמאַציע]]):',
	'fancycaptcha-edit' => 'צו רעדאִקטירן דעם בלאַט, זײַט אזוי גוט און קלאַפט אַרײַן די ווערטער וואָס שטייען אינעם קעסטל אונטן ([[Special:Captcha/help|מער אינפֿארמאַציע]]):',
);

/** Yoruba (Yorùbá)
 * @author Demmy
 */
$messages['yo'] = array(
	'fancycaptcha-addurl' => 'Àwọn àtúnṣe yín ní àwọn ìjápọ̀ òde nínú.
Láti ṣèránwọ́ láti kojú spam aṣefúnrararẹ̀, ẹ jọ̀wọ́ ẹ fi àwọn ọ̀rọ̀ tí wọ́n hàn nísàlẹ̀ sínú ààyè ([[Special:Captcha/help|ẹ̀kúnrẹ́rẹ́]]):', # Fuzzy
);

/** Cantonese (粵語)
 */
$messages['yue'] = array(
	'fancycaptcha-addurl' => '你嘅編輯包括咗新嘅外部連結。為咗防止自動化嘅濫貼，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):', # Fuzzy
	'fancycaptcha-badlogin' => '為咗防止不當程式破解密碼，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):', # Fuzzy
	'fancycaptcha-createaccount' => '為咗防止自動化開新戶口，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):', # Fuzzy
	'fancycaptcha-create' => '要開一個新版，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):',
	'fancycaptcha-edit' => '要編輯呢一版，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Bencmq
 * @author Cwek
 */
$messages['zh-hans'] = array(
	'fancycaptcha-addurl' => '你的编辑内容中含有本网站以外的链接。为防止不当程式大量破坏，请输入以下的文字（[[Special:Captcha/help|相关信息]]）：',
	'fancycaptcha-badlogin' => '为防止不当程式破解密码，请输入以下的文字（[[Special:Captcha/help|相关信息]]）：',
	'fancycaptcha-createaccount' => '为防止不当程式大量建立帐户，请输入以下的文字（[[Special:Captcha/help|相关信息]]）：',
	'fancycaptcha-create' => '为防止不当程式大量建立页面，请输入以下的文字（[[Special:Captcha/help|相关信息]]）：',
	'fancycaptcha-edit' => '如你想要编辑這个页面，请输入以下的文字（[[Special:Captcha/help|相关信息]]）：',
	'fancycaptcha-sendemail' => '为防止不当程式进行破坏，请输入以下的文字（[[Special:Captcha/help|相关资讯]]）：',
	'fancycaptcha-reload-text' => '刷新',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Horacewai2
 * @author Justincheng12345
 * @author Liuxinyu970226
 * @author Waihorace
 */
$messages['zh-hant'] = array(
	'fancycaptcha-addurl' => '您的編輯內容中含有本網站以外的連結。
為防止不當程式大量破壞，請輸入以下的文字（[[Special:Captcha/help|相關資訊]]）：',
	'fancycaptcha-badlogin' => '為防止不當程式破解密碼，請輸入以下的文字（[[Special:Captcha/help|相關資訊]]）：', # Fuzzy
	'fancycaptcha-createaccount' => '為防止不當程式大量建立帳戶，請輸入以下的文字（[[Special:Captcha/help|相關資訊]]）：', # Fuzzy
	'fancycaptcha-create' => '為防止不當程式大量建立頁面，請輸入以下的文字（[[Special:Captcha/help|相關資訊]]）：',
	'fancycaptcha-edit' => '如您想要編輯此頁面，請輸入以下的文字（[[Special:Captcha/help|相關資訊]]）：',
	'fancycaptcha-sendemail' => '為防止不當程式進行破壞，請輸入以下的文字（[[Special:Captcha/help|相關資訊]]）：', # Fuzzy
	'fancycaptcha-reload-text' => '重新整理',
);
