/*
 * This module is to be used to translate usema calls into posix un-named
 * semaphore calls.
 *
 * XXX - not sure all semantics/returns are correct.  The basics work.
 *
 * usconfig calls are trapped and ignored.
 * usinit is trapped and the program exits if it is not /dev/zero.
 * usinitsema -> sem_init.
 * usnewsema -> calloc & sem_init.
 * uspsema -> sem_wait
 * usvsema -> sem_post
 * cc -shared -mips1 -o us2posix.so us2posix.o
 * _RLD_LIST=..../us2posix.o ./ns-httpd -i -d /usr/ns-home/https-<your-config>/config
 */

#include <semaphore.h>
#include <ulocks.h>
#include <malloc.h>
#ifdef	DEBUG
#	define	debug(x)	fdebug((stderr, x
#else
#	define	debug(x)
#endif

usptr_t	*usinit(const char *filename)
{
	debug((stderr, "usinit(%s)\n", filename));
	if (strcmp(filename, "/dev/zero")) {
		debug((stderr, "\nWARNING: usinit on named file.\n"));
	}
	return (0);
}

ptrdiff_t usconfig(int cmd, ...)
{
	va_list ap;
	extern ptrdiff_t _usconfig(int cmd, ...);
	unsigned	x;

	va_start(ap, cmd);
	x = va_arg(ap, unsigned);
	debug((stderr, "usconfig(%d, %d)\n", cmd, x));
	return (0);
}

usinitsema(usema_t *s, int num)
{
	debug((stderr, "usinitsema(%x, %d)\n", s, num));
	return (sem_init((sem_t*)s, 1, num));
}

usema_t *usnewsema(usptr_t *s, int num)
{
	sem_t	*sem = calloc(1, sizeof(*sem));

	debug((stderr, "usnewsema(%x, %d)\n", s, num));
	if (sem) {
		debug((stderr, "sem_init(%x, 1, %d)\n", sem, num));
		sem_init(sem, 1, num);
	}
	return ((usema_t*)sem);
}

void	usfreesema(usema_t *sem, usptr_t *s) { free((void *)sem); }

int	usctlsema(usema_t *sema, int cmd, ...)
{
}
uspsema(usema_t *s) { return (sem_wait((sem_t*)s)); }

usvsema(usema_t *s) { return (sem_post((sem_t*)s)); }
