char	*id = "$Id: seek.c,v 1.1 1996/09/05 19:32:37 lm Exp lm $\n";
/*
 * shuffle - calculate seeks as a function of distance.
 * This shuffles the physical addresses.
 *
 * Usage: shuffle file size [blksize]
 *
 * Copyright (c) 1994,1995,1996 Larry McVoy.  All rights reserved.
 */

#include "timing.h"
#include "bench.h"
#define STRIDE	4*1024*1024
#define	uint64	unsigned long long

main(ac, av)
	int	ac;
	char	*av[];
{
	char	*buf;
	int	bsize;
	int	disk;
	uint64	size;
	uint64	begin, end;
	int	usecs;
	uint64	getsize(char *s);
	uint64	shuffle(uint64);

	if (ac != 3 && ac != 4) {
		exit(1);
	}
	if ((disk = open(av[1], 0)) == -1) {
		exit(errno);
	}
	size = getsize(av[2]);
	shuffle_init(size);

	if (ac == 3) {
		bsize = 512;
	} else {
		bsize = getsize(av[3]);
	}
	buf = malloc(bsize);
	if (!buf) {
		exit(errno);
	}

	/*
	 * We flip back and forth, in strides of 1MB.
	 * If we have a 100MB disk, that means we do
	 * 1, 99, 2, 98, etc.
	 */
	end = size;
	begin = 0;
	lseek64(disk, shuffle(begin), 0);
	read(disk, buf, bsize);
	while (end > begin) {
		end -= STRIDE;
		start();
		lseek64(disk, shuffle(end), 0);
		read(disk, buf, bsize);
		usecs = stop();
		printf("%.01f %.01f\n", (end - begin) / 1000000., usecs/1000.);

		begin += STRIDE;
		start();
		lseek64(disk, shuffle(begin), 0);
		read(disk, buf, bsize);
		usecs = stop();
		printf("%.01f %.01f\n", (end - begin) / 1000000., usecs/1000.);
	}
	exit(0);
}

/*
 * Shuffle the disk such that sequential I/O will go at a constant rate.
 * We shuffle on CHUNK boundries.
 */
#define	CHUNK	(1<<30)
int	*shuffle_map;

uint64
shuffle(uint64 off)
{
	int	slot = off / CHUNK;
	uint64	noff;

	noff = shuffle_map[slot];
	noff *= CHUNK;
	noff += (off % CHUNK);
	/*
	fprintf(stderr, "%u -> %u\n", (int)(off >> 20), (int)(noff >> 20));
	*/
	return (noff);
}

shuffle_init(uint64 size)
{
	int	slots = size / CHUNK;
	int	i;

	shuffle_map = calloc(slots, sizeof(int));
	for (i = 0; i < slots; i++) {
		if (i & 1) {
			shuffle_map[i] = i;
		} else {
			shuffle_map[i] = slots - i;
		}
		/*
		fprintf(stderr, "[%u] -> %u\n", i, shuffle_map[i]);
		*/
	}
}

uint64
getsize(char *s)
{
	uint64	size = atol(s);

	switch (s[strlen(s) - 1]) {
	    case 'k':	size <<= 10;		break;
	    case 'K':	size *= 1000;		break;
	    case 'm':	size <<= 20;		break;
	    case 'M':	size *= 1000000;	break;
	    case 'g':	size <<= 30;		break;
	    case 'G':	size *= 1000000000L;	break;
	}
	return (size);
}
