char	*id = "$Id: seek.c,v 1.1 1996/09/05 19:32:37 lm Exp lm $\n";
/*
 * Seek - calculate seeks as a function of distance.
 *
 * Usage: seek file size [blksize]
 *
 * Copyright (c) 1994,1995,1996 Larry McVoy.  All rights reserved.
 */

#include "timing.h"
#include "bench.h"
#define	uint64	unsigned long long
#define	IO(a,b,c)	error = (oflag == 0 ? read(a,b,c) : write(a,b,c)); \
			if (error == -1) { perror("io"); exit(1); }

main(ac, av)
	int	ac;
	char	*av[];
{
	char	*buf;
	int	bsize;
	int	disk;
	uint64	size;
	uint64	begin, end;
	int	usecs;
	uint64	getsize(char *s);
	int	stride;
	int	oflag;
	int	error;

	if (ac != 3 && ac != 4 && ac != 5) {
		fprintf(stderr,
		    "Usage: %s file size [blksize [stride] ]\n", av[0]);
		exit(1);
	}
	if (strcmp(av[0], "seekwr") == 0) {
		oflag = 1;
	} else {
		oflag = 0;
	}
	if ((disk = open(av[1], oflag)) == -1) {
		perror(av[1]);
		exit(errno);
	}
	size = getsize(av[2]);

	stride = 1<<20;
	if (ac == 3) {
		bsize = 512;
	} else {
		bsize = getsize(av[3]);
		if (ac == 5) {
			stride = getsize(av[4]);
		}
	}
	buf = malloc(bsize);
	if (!buf) {
		perror("malloc");
		exit(errno);
	}

	/*
	 * We flip back and forth, in strides of 1MB.
	 * If we have a 100MB disk, that means we do
	 * 1, 99, 2, 98, etc.
	 */
	end = size;
	begin = 0;
	if (lseek64(disk, begin, 0)) {
		perror("lseek");
		exit(1);
	}
	IO(disk, buf, bsize);
	while (end > begin) {
		end -= stride;
		start();
		if (lseek64(disk, end, 0) != end) {
			perror("lseek");
			exit(1);
		}
		IO(disk, buf, bsize);
		usecs = stop();
		printf("%.01f %.01f\n", (end - begin) / 1000000., usecs/1000.);

		begin += stride;
		start();
		if (lseek64(disk, begin, 0) != begin) {
			perror("lseek");
			exit(1);
		}
		IO(disk, buf, bsize);
		usecs = stop();
		printf("%.01f %.01f\n", (end - begin) / 1000000., usecs/1000.);
	}
	exit(0);
}

uint64
getsize(char *s)
{
	uint64	size = atol(s);

	switch (s[strlen(s) - 1]) {
	    case 'k':	size <<= 10;		break;
	    case 'K':	size *= 1000;		break;
	    case 'm':	size <<= 20;		break;
	    case 'M':	size *= 1000000;	break;
	    case 'g':	size <<= 30;		break;
	    case 'G':	size *= 1000000000L;	break;
	}
	return (size);
}
