
#include "bench.h"
#include <ulocks.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/prctl.h>
#include <sys/sysmp.h>
#include <sys/syssgi.h>
#include <sys/cachectl.h>

usema_t	*a;
char	c[128];
usema_t	*b;

#define	waiton(a)	uspsema(a)
#define	release(a)	usvsema(a)

int	N = 5000;
volatile int step = 0;
volatile int step2 = 0;

int
main(int ac, char **av)
{
	int	i, pid;
	void	exit();
	usptr_t	*arena;
	void	child();

	arena = usinit("/tmp/lat_sema");
	a = usnewsema(arena, 0);
	b = usnewsema(arena, 0);

	sysmp(MP_MUSTRUN, 0);
	sproc(child, PR_SALL);
	while (step == 0)
		;
	step2 = 1;
	start(0);
	for (i = 0; i < N; i++) {
		release(a);
		waiton(b);
	}
	stop(0,0);
	micro("Sproc sema round trip", N);
}

/*
 * block on a and then let go b go.
 */
void
child()
{
	int	i;

	sysmp(MP_MUSTRUN, 1);
	step = 1;
	while (step2 != 1)
		;
	for (i = 0; i < N; i++) {
		waiton(a);
		release(b);
	}
}
