/* mp3mod.c
 *
 * Copyright (c) 1999 Scott Manley, Barath Raghavan, Jack Moffitt, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "mixer.h"

typedef struct mpg123_dat {
  char *filename;
  Format fmt;
  int stream;
  FILE *fstr;
  pid_t pid;
  } Mpg123_Dat;

/* most of the important control of the audio generators should be done 
through a special interface - it will be possible to 'register' modules 
which use the playlist with the playlist manager */

/* params accessible */
/*
int:
param_i[0]=play/stop
param_i[1]=continue_mode 0 - stop at end
                         1 - next track
			 2 - repeat track
			 3 - random track
param_i[2]=change track - if non-zero the track is changed 

float:
param_f[0]=speedup/slowdown  - copy this into format data

connetcions:
connections[0] = output;

*/



/* mpg123 Module - uses mpg123 to decode an mp3 file */
Mod_Ptr mod_mpg123_init(Mod_Ptr out){
Mod_Ptr new;
Mpg123_Dat *Priv_dat;
new=malloc(sizeof(Mod_Struct));
sprintf(new->name,"MPG123 Decoder %X",new);
new->Mod_Type=MOD_MPG123;
new->volume=1.0;
new->num_ints=3;
new->num_floats=1;
new->num_connections=1;
new->param_i=malloc(3*sizeof(int));
new->param_i[0]=0;
new->param_i[1]=0;
new->param_i[2]=0;
new->param_f=malloc(sizeof(float));
new->param_f[0]=1.0;
new->connections=malloc(sizeof(Mod_Ptr));
new->connections[0]=out;
new->gen_param=Priv_dat=malloc(sizeof(Mpg123_Dat));
Priv_dat->filename=NULL;
Priv_dat->fmt.rate=0;
Priv_dat->fmt.channels=0;
Priv_dat->fmt.speed=1.0;
Priv_dat->stream=0;
Priv_dat->fstr=NULL;
Priv_dat->pid=0;
new->format=out->format;
return new;
}

/* spawn mpg123 */

int spawn_stream(Mpg123_Dat *mod){
int strm[2],rate,channels;
pid_t pid;
rate=format_of (mod->filename,&channels);
mod->fmt.rate=rate;
mod->fmt.channels=channels;
   if(rate>0) {
       printf("%6dkHz %2d Channels - %s\n",mod->fmt.rate,mod->fmt.channels,mod->filename);
       /* create pipe */
       pipe(strm);
       pid=fork();
       if(pid){
	   mod->pid=pid;
	   close(strm[1]);
	   mod->stream=strm[0];
	   mod->fstr=fdopen(mod->stream,"rb");
       } else {
	   close(strm[0]);
	   close(1);
	   dup(strm[1]);
	   close(strm[0]);
	   close(strm[1]);
	   /* close audio too - don't use the close_soundcard because it causes glitches*/
	   close(audio_fd);
	   execlp("mpg123","mpg123","-sq",mod->filename,NULL);
       }
       return 0;        /* success */
   } else {
       printf("File %s is in unknown format\n");
       return -1;       /* failure */
   }
}


void reset_channel(cptr ch){
int i;
for(i=0;i<BUF_SIZE;i++) (*ch).inbuf[i]=0;
(*ch).volume=1.0;
(*ch).speed=1.0;
(*ch).on=0;
(*ch).stream=0;
(*ch).pid=0;
(*ch).stayon=0;
}

void kill_channel(Mpg123_Dat *mod_dat,Mod_Ptr mod){
int i;
printf("stopping module %s\n",mod->name);
 if(mod_dat->pid>0){
   kill(mod_dat->pid,15);
   (*ch).pid=0;
   (*ch).on=0;
   if((*ch).stream>2){
     fclose((*ch).fstr);
     ch->stream=0;
   }
 } else {
   (*ch).pid=0;
   (*ch).on=0;
 }
 
 for(i=0;i<BUF_SIZE;i++) (*ch).inbuf[i]=0;
}




void mod_null_get(Mod_Ptr set,int *adat){
int i;
for(i=0;i<BUF_SIZE;i++)
  adat[i]=0;
}
