/* tuplespace.h -- Tuplespace API
   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002 Wong Weng Fai <wongwf@comp.nus.edu.sg>

   This file is part of linda.

   linda is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   linda is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with linda; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef TUPLESPACE_H
#define TUPLESPACE_H 

#include <stdarg.h>
#include <glib.h>

typedef struct _Tuple          Tuple;
typedef enum   _TupleType      TupleType;
typedef enum   _TupleResult    TupleResult;

enum _TupleType {
  TUPLE_RD    	= 1 << 0,
  TUPLE_IN    	= 1 << 1,
  TUPLE_OUT   	= 1 << 2,
  TUPLE_EVAL  	= 1 << 3,
  TUPLE_NOBLOCK = 1 << 4,
  TUPLE_RDP     = TUPLE_RD | TUPLE_NOBLOCK,
  TUPLE_INP     = TUPLE_IN | TUPLE_NOBLOCK,
};

enum _TupleResult {
  TUPLE_HOLD      	    = 0,
  TUPLE_FREE      	    = 1 << 0,
  TUPLE_BOUND_VAL 	    = 1 << 1,
  TUPLE_TIMEOUT 	    = 1 << 2,
};

void        tuplespace_init  (void);
void        tuplespace_end   (void);
TupleResult tuplespace_enter (Tuple * tuple, GTimeVal * end_time); 

Tuple *     tuple_new        (TupleType type, const gchar * mask, va_list list);
void        tuple_free       (Tuple * tuple);

#endif /* Not def: TUPLESPACE_H */
