/* primes.c -- finding prime number with using linda
   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002 Wong Weng Fai <wongwf@comp.nus.edu.sg>

   This file is part of linda.

   linda is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   linda is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with linda; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "linda.h"
#include <stdio.h>
#include <math.h>
 
#define MAXVAL 100
#define ANSWER 97

void primes(void);

int
main(int argc, char **argv) 
{ 
  int last, i, ok;
 
  linda_init(NULL);
 
  for (i = 2; i < MAXVAL; i++) 
    { 
      linda_out("%s%d","primeargs", i);
      linda_spawn(primes);
    } 
 
  for (i=2; i < MAXVAL; i++) 
    { 
      linda_rd("%s%d?d", "primes", i, &ok); 
      if (ok == 1)  
	last = i; 
    }
  linda_end();
  printf("greatest prime is %d\n", last); 

  if (ANSWER == last)
    return 0;
  else
    return 1;
}

void 
primes(void) 
{ 
  int me, i, limit, ok; 
  linda_in("%s?d", "primeargs", &me);
  limit = sqrt((double) me) + 1; 
  for (i = 2; i < limit; i++) 
    { 
      linda_rd("%s%d?d","primes", i, &ok); 
      if (ok && ((me % i) == 0)) 
        { 
	  linda_out("%s%d%d", "primes", me, 0); 
	  return;
        } 
    } 
  linda_out("%s%d%d", "primes", me, 1); 
} 
