/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Test the ring class.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_RING
#include <libstash/libstash_r.h>

int
main()
{
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  /* ring_new(), ring_delete(). */
  {
    cw_ring_t * ring_a, ring_b;

    ring_a = ring_new(NULL, NULL, NULL);
    _cw_check_ptr(ring_a);
    ring_delete(ring_a);

    ring_a = ring_new((cw_ring_t *) _cw_malloc(sizeof(cw_ring_t)),
		      mem_dealloc,
		      cw_g_mem);
    _cw_check_ptr(ring_a);
    ring_delete(ring_a);

    _cw_assert(&ring_b == ring_new(&ring_b, NULL, NULL));
    ring_delete(&ring_b);
  }

  /* ring_get_data(), ring_set_data(). */
  {
    cw_ring_t * ring;
    char * str = "Hi";

    ring = ring_new(NULL, NULL, NULL);

    ring_set_data(ring, str);
    _cw_assert(str == ring_get_data(ring));

    ring_delete(ring);
  }

  /* ring_meld(), ring_cut(), ring_split(). */
  {
    cw_ring_t * ring_a, * ring_b, * t_ring;
    char str[11] = "abcdefghij", c;
    cw_uint32_t i;

    ring_a = ring_new(NULL, NULL, NULL);

    for (i = 0; i < 10; i++)
    {
      ring_b = ring_new(NULL, NULL, NULL);
      ring_set_data(ring_b, (void *) &str[i]);
      ring_meld(ring_a, ring_b);
    }
    ring_b = ring_a;
    ring_a = ring_cut(ring_b);
    ring_delete(ring_b);

    out_put(cw_g_out, "ring_a contents (1): ");
    t_ring = ring_a;
    do 
    {
      c = *(char *) ring_get_data(t_ring);
      out_put(cw_g_out, "[c] ", c);
      t_ring = ring_next(t_ring);
    } while (t_ring != ring_a);
    out_put(cw_g_out, "\n");

    for (i = 0, ring_b = ring_a; i < 2; i++)
    {
      ring_b = ring_next(ring_b);
    }

    ring_split(ring_a, ring_b);
    
    out_put(cw_g_out, "ring_a contents (2): ");
    t_ring = ring_a;
    do 
    {
      c = *(char *) ring_get_data(t_ring);
      out_put(cw_g_out, "[c] ", c);
      t_ring = ring_next(t_ring);
    } while (t_ring != ring_a);
    out_put(cw_g_out, "\n");

    ring_split(ring_a, ring_a);
    
    out_put(cw_g_out, "ring_a contents (3): ");
    t_ring = ring_a;
    do 
    {
      c = *(char *) ring_get_data(t_ring);
      out_put(cw_g_out, "[c] ", c);
      t_ring = ring_next(t_ring);
    } while (t_ring != ring_a);
    out_put(cw_g_out, "\n");
    
    out_put(cw_g_out, "ring_b contents (4): ");
    t_ring = ring_b;
    do 
    {
      c = *(char *) ring_get_data(t_ring);
      out_put(cw_g_out, "[c] ", c);
      t_ring = ring_next(t_ring);
    } while (t_ring != ring_b);
    out_put(cw_g_out, "\n");

    t_ring = ring_next(ring_a);
    ring_split(ring_a, t_ring);
    ring_delete(t_ring);
    out_put(cw_g_out, "ring_a contents (5): ");
    t_ring = ring_a;
    do 
    {
      c = *(char *) ring_get_data(t_ring);
      out_put(cw_g_out, "[c] ", c);
      t_ring = ring_next(t_ring);
    } while (t_ring != ring_a);
    out_put(cw_g_out, "\n");

    t_ring = ring_next(ring_a);
    ring_split(ring_a, t_ring);
    out_put(cw_g_out, "ring_a contents (6): ");
    t_ring = ring_a;
    do 
    {
      c = *(char *) ring_get_data(t_ring);
      out_put(cw_g_out, "[c] ", c);
      t_ring = ring_next(t_ring);
    } while (t_ring != ring_a);
    out_put(cw_g_out, "\n");
    
    ring_delete(ring_a);
    ring_delete(ring_b);
  }

  /* ring_next(), ring_prev(). */
  {
    cw_ring_t * ring_a, * ring_b;

    ring_a = ring_new(NULL, NULL, NULL);
    ring_b = ring_new(NULL, NULL, NULL);

    _cw_assert(ring_a == ring_next(ring_a));
    _cw_assert(ring_a == ring_prev(ring_a));

    ring_meld(ring_a, ring_b);
    _cw_assert(ring_b == ring_next(ring_a));
    _cw_assert(ring_b == ring_prev(ring_a));
    _cw_assert(ring_a == ring_next(ring_b));
    _cw_assert(ring_a == ring_prev(ring_b));
    
    ring_delete(ring_a);
  }

  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
