/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Test for the res class.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_RES
#include <libstash/libstash_r.h>

int
main()
{
  cw_res_t res;
  char s1[50] = "simple:value",
    s2[80] = "less_simple : this has spaces",
    s3[80] = "9adv_more_.nasty ::hello there!@$",
    s4[80] = "another_resource:A value with a \\\\ protected \\#.",
    s5[80] = "  	much_white_Space : the resource value w/ trailing    ",
    s6[80] = "trailing.comment : value # This is a comment.",
    s7[80] = " 	 #comment:blah",
    s8[80] = "  #comment with !@#$% other chars";
  const char * str;

  char es1[80] = "bogus space in name: value",
    es2[80] = "bad_*_character_in_name: value blah",
    es3[80] = ": empty name",
    es4[80] = " somethging #comment",
    es5[80] = "\\name:value",
    es6[80] = " :value",
    es7[80] = " !:value",
    es8[80] = "name#:value",
    es9[80] = "name\\:value",
    es10[80] = "name",
    es11[80] = "name:value\\x",
    es12[80] = "name:value\\:",
    es13[80] = "name:value\\X",
    es14[80] = "name:value\\_",
    es15[80] = "name:value\\.",
    es16[80] = "name:value\\:";

  libstash_init();
  out_put(cw_g_out, "Test begin\n");

/*   dbg_register(cw_g_dbg, "res_state"); */
  
  res_new(&res);

  out_put(cw_g_out, "Merging in a list...\n");
  _cw_assert(FALSE == res_merge_list(&res, s1, s2, s3, s4, s5, s6, s7,
				     s8, NULL));

  out_put(cw_g_out, "Searching for a resource...\n");
  str = res_get_res_val(&res, "simple");

  _cw_check_ptr(str);
  out_put(cw_g_out, "simple:[s]\n", str);
  _cw_assert(!strcmp(str, "value"));

  out_put(cw_g_out, "Testing invalid resources handling...\n");

  _cw_assert(TRUE == res_merge_list(&res, es1, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es2, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es3, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es4, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es5, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es6, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es7, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es8, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es9, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es10, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es11, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es12, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es13, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es14, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es15, NULL));
  _cw_assert(TRUE == res_merge_list(&res, es16, NULL));
  
  res_delete(&res);
  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();

  return 0;
}
