/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 *
 *
 ****************************************************************************/

#define _LIBSTASH_USE_MQ
#include <libstash/libstash_r.h>

int
main()
{
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  /* mq_new(), mq_delete(). */
  {
    cw_mq_t mq, * mq_p;

    _cw_assert(&mq == mq_new(&mq));
    mq_delete(&mq);

    mq_p = mq_new(NULL);
    _cw_check_ptr(mq_p);
    mq_delete(mq_p);
  }

  /* mq_tryget(), mq_put(). */
  {
    cw_mq_t * mq_p;
    cw_uint32_t i, j, k;

    mq_p = mq_new(NULL);
    _cw_check_ptr(mq_p);
    
    _cw_assert(NULL == mq_tryget(mq_p));
    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    _cw_assert((void *) &i == mq_tryget(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));

    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    _cw_assert(0 == mq_put(mq_p, (const void *) &j));
    _cw_assert(0 == mq_put(mq_p, (const void *) &k));
    _cw_assert((void *) &i == mq_tryget(mq_p));
    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    _cw_assert((void *) &j == mq_tryget(mq_p));
    _cw_assert((void *) &k == mq_tryget(mq_p));
    _cw_assert((void *) &i == mq_tryget(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));
    
    mq_delete(mq_p);
  }

  /* mq_get(), mq_put(), mq_tryget(). */
  {
    cw_mq_t * mq_p;
    cw_uint32_t i, j, k;

    mq_p = mq_new(NULL);
    _cw_check_ptr(mq_p);
    
    _cw_assert(NULL == mq_tryget(mq_p));
    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    _cw_assert((void *) &i == mq_get(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));

    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    _cw_assert(0 == mq_put(mq_p, (const void *) &j));
    _cw_assert(0 == mq_put(mq_p, (const void *) &k));
    _cw_assert((void *) &i == mq_get(mq_p));
    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    _cw_assert((void *) &j == mq_get(mq_p));
    _cw_assert((void *) &k == mq_get(mq_p));
    _cw_assert((void *) &i == mq_get(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));
    
    mq_delete(mq_p);
  }

  /* mq_start_get(), mq_stop_get(), mq_tryget(), mq_put(). */
  {
    cw_mq_t * mq_p;
    cw_uint32_t i, j, k;

    mq_p = mq_new(NULL);
    _cw_check_ptr(mq_p);
    
    _cw_assert(FALSE == mq_stop_get(mq_p));
    _cw_assert(TRUE == mq_stop_get(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));
    
    _cw_assert(FALSE == mq_start_get(mq_p));
    _cw_assert(TRUE == mq_start_get(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));
    
    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    
    _cw_assert(FALSE == mq_stop_get(mq_p));
    _cw_assert(TRUE == mq_stop_get(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));
    _cw_assert(NULL == mq_get(mq_p));
    
    _cw_assert(FALSE == mq_start_get(mq_p));
    _cw_assert(TRUE == mq_start_get(mq_p));
    _cw_assert((void *) &i == mq_tryget(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));

    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    _cw_assert(0 == mq_put(mq_p, (const void *) &j));
    _cw_assert(0 == mq_put(mq_p, (const void *) &k));
    
    mq_delete(mq_p);
  }

  /* mq_start_put(), mq_stop_put(), mq_try_get(), mq_put(). */
  {
    cw_mq_t * mq_p;
    cw_uint32_t i, j, k;

    mq_p = mq_new(NULL);
    _cw_check_ptr(mq_p);
    
    _cw_assert(NULL == mq_tryget(mq_p));
    _cw_assert(FALSE == mq_stop_put(mq_p));
    _cw_assert(TRUE == mq_stop_put(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));
    
    _cw_assert(1 == mq_put(mq_p, (const void *) &i));
    
    _cw_assert(FALSE == mq_start_put(mq_p));
    _cw_assert(TRUE == mq_start_put(mq_p));
    _cw_assert(0 == mq_put(mq_p, (const void *) &i));
    _cw_assert(0 == mq_put(mq_p, (const void *) &j));
    
    _cw_assert(FALSE == mq_stop_put(mq_p));
    _cw_assert(TRUE == mq_stop_put(mq_p));
    _cw_assert(1 == mq_put(mq_p, (const void *) &k));

    _cw_assert((void *) &i == mq_tryget(mq_p));
    _cw_assert((void *) &j == mq_tryget(mq_p));
    _cw_assert(NULL == mq_tryget(mq_p));
    
    mq_delete(mq_p);
  }

  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
