/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 ****************************************************************************/

#ifdef _CW_REENTRANT
#  include "libstash/libstash_r.h"
#else
#  include "libstash/libstash.h"
#endif

#include "libstash/mem_l.h"

cw_dbg_t *
dbg_new(void)
{
  cw_dbg_t * retval;

  retval = (cw_dbg_t *) _cw_malloc(sizeof(cw_dbg_t));
  if (NULL == retval)
  {
    goto RETURN;
  }

#ifdef _CW_REENTRANT
  if (NULL == oh_new_r(&retval->flag_hash))
#else
  if (NULL == oh_new(&retval->flag_hash))
#endif
  {
    _cw_free(retval);
    retval = NULL;
    goto RETURN;
  }

  RETURN:
  return retval;
}

void
dbg_delete(cw_dbg_t * a_dbg)
{
  _cw_check_ptr(a_dbg);

  oh_delete(&a_dbg->flag_hash);
  _cw_free(a_dbg);
}

cw_bool_t
dbg_register(cw_dbg_t * a_dbg, const char * a_flag)
{
  cw_bool_t retval;
  
  if ((NULL != a_dbg)
      && (-1 != oh_item_insert(&a_dbg->flag_hash, (void *) a_flag, NULL)))
  {
    retval = FALSE;
  }
  else
  {
    retval = TRUE;
  }
  
  return retval;
}

void
dbg_unregister(cw_dbg_t * a_dbg, const char * a_flag)
{
  if (NULL != a_dbg)
  {
    oh_item_delete(&a_dbg->flag_hash, a_flag, NULL, NULL);
  }
}

cw_bool_t
dbg_is_registered(cw_dbg_t * a_dbg, const char * a_flag)
{
  cw_bool_t retval;

  _cw_check_ptr(a_flag);

  if (NULL != a_dbg)
  {
    retval = ! oh_item_search(&a_dbg->flag_hash, a_flag, NULL);
  }
  else
  {
    retval = FALSE;
  }
  
  return retval;
}
