/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Test of the tree and treen classes.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_TREEN
#include <libstash/libstash_r.h>

int
main()
{
  cw_treen_t * treen_a, * treen_b, * treens[7];
  cw_uint32_t i;
  
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  treen_a = treen_new();
  _cw_check_ptr(treen_a);
  
  treen_b = treen_new_r();
  _cw_check_ptr(treen_b);

  _cw_assert(FALSE == treen_link_child(treen_a, treen_b, 0));

  treen_delete(treen_a);

  for (i = 0; i < 7; i++)
  {
    treens[i] = treen_new_r();
    _cw_check_ptr(treens);
  }
  
  /* Link the treens as such:
   *             0
   *            / \
   *           /   \
   *          /     \
   *         /       \
   *        /         \
   *       1           2
   *      / \         / \
   *     /   \       /   \
   *    3     4     5     6
   */
  _cw_assert(FALSE == treen_link_child(treens[0], treens[1], 0));
  _cw_assert(FALSE == treen_link_child(treens[0], treens[2], 1));
  _cw_assert(FALSE == treen_link_child(treens[1], treens[3], 0));
  _cw_assert(FALSE == treen_link_child(treens[1], treens[4], 1));
  _cw_assert(FALSE == treen_link_child(treens[2], treens[5], 0));
  _cw_assert(FALSE == treen_link_child(treens[2], treens[6], 1));

  /* Move part of the tree. */
  _cw_assert(FALSE == treen_unlink_child(treens[0], 1, &treen_a));
  _cw_assert(treen_a == treens[2]);
  _cw_assert(FALSE == treen_link_child(treens[1], treens[2], 0));

  treen_delete(treens[0]);

  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
