/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Check for array bounds overrun.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_BUF
#include <libstash/libstash_r.h>

#define _ARR_SIZE 64

void
print_arr(const char * a_arr, cw_uint32_t a_size, const char * a_prefix)
{
  cw_uint32_t i;

  for (i = 0; i < a_size; i++)
  {
    if (0 == (i % 16))
    {
      out_put(cw_g_out, "[s] 0x[i|w:4|p:0|b:16]:", a_prefix, i);
    }

    out_put(cw_g_out, " [i|w:2|p:0|b:16]", a_arr[i]);

    if (15 == (i % 16))
    {
      out_put(cw_g_out, "\n");
    }
  }
}

void
foo(void)
{
  char a[_ARR_SIZE];
  cw_buf_t buf;
  char b[_ARR_SIZE];

  memset(a, 'a', _ARR_SIZE);
  memset(b, 'b', _ARR_SIZE);

  print_arr(a, _ARR_SIZE, "a(0)");
  print_arr(b, _ARR_SIZE, "b(0)");

  buf_new(&buf);

  print_arr(a, _ARR_SIZE, "a(1)");
  print_arr(b, _ARR_SIZE, "b(1)");
  
  buf_delete(&buf);
  
  print_arr(a, _ARR_SIZE, "a(2)");
  print_arr(b, _ARR_SIZE, "b(2)");
}

int
main()
{
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  foo();

  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
