/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Initialization and shutdown functions for the whole library.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_BUF
#include "libstash/libstash.h"

/* Globals. */
cw_mem_t * cw_g_mem = NULL;
cw_dbg_t * cw_g_dbg = NULL;
cw_log_t * cw_g_log = NULL;
cw_out_t * cw_g_out = NULL;

cw_bool_t
libstash_init(void)
{
  cw_bool_t retval = FALSE;
  
  /* Start up global modules. */
  if (cw_g_out == NULL)
  {
    cw_g_out = out_new(NULL);
  }
  if (cw_g_log == NULL)
  {
    cw_g_log = log_new();
  }
  if (cw_g_dbg == NULL)
  {
    cw_g_dbg = dbg_new();
#ifdef _LIBSTASH_DBG
    if (NULL != cw_g_dbg)
    {
      dbg_register(cw_g_dbg, "mem_error");
    }
    if (NULL != cw_g_dbg)
    {
      dbg_register(cw_g_dbg, "pezz_error");
    }
#endif
  }
  if (cw_g_mem == NULL)
  {
    cw_g_mem = mem_new();
  }

  if ((NULL == cw_g_out)
      || (NULL == cw_g_log)
      || (NULL == cw_g_dbg)
      || (NULL == cw_g_mem))
  {
    retval = TRUE;
  }
  
  return retval;
}

void
libstash_shutdown(void)
{
  /* Shut down global modules in reverse order. */
  mem_delete(cw_g_mem);
  cw_g_mem = NULL;

  dbg_delete(cw_g_dbg);
  cw_g_dbg = NULL;

  log_delete(cw_g_log);
  cw_g_log = NULL;

  out_delete(cw_g_out);
  cw_g_out = NULL;
}
