#include <gtkmm/box.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/main.h>
#include <gtkmm/stock.h>
#include <gtkmm/window.h>
#include <libsexymm/url-label.h>
#include <stdio.h>

#define LIBSEXYMM_URL \
	"http://osiris.chipx86.com/svn/osiris-misc/trunk/libsexymm/"

class AppWindow
	: public Gtk::Window
{
public:
	AppWindow(void);

private:
	void OnUrlActivated(const Glib::ustring &url);

	Sexy::UrlLabel mUrlLabel;
};

AppWindow::AppWindow(void)
{
	set_title("Sexy URL Label Test");
	show();
	set_border_width(12);

	mUrlLabel.show();
	add(mUrlLabel);
	mUrlLabel.set_line_wrap(true);
	mUrlLabel.set_markup(
		"This is a sample Sexy::UrlLabel. For the latest version, please "
		"the <a href=\"" LIBSEXYMM_URL "\">SVN repository</a>. For a great "
		"page about mornings and what you can do with them, see "
		"<a href=\"http://www.destroymornings.com/\">DestroyMornings.com</a>.");

	mUrlLabel.signal_url_activated().connect(
		sigc::mem_fun(this, &AppWindow::OnUrlActivated));
}

void
AppWindow::OnUrlActivated(const Glib::ustring &url)
{
	std::string cmd = "gnome-open " + Glib::shell_quote(url);

	printf("Executing %s\n", cmd.c_str());
	Glib::spawn_command_line_async(cmd);
}

int
main(int argc, char **argv)
{
	Gtk::Main kit(&argc, &argv);
	AppWindow app;
	Gtk::Main::run(app);

	return 0;
}
