/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plot_clipboard.h"

static void sg_plot_clipboard_class_init   (SGplotClipboardClass *klass);
static void sg_plot_clipboard_init         (SGplotClipboard *cb);
static void sg_plot_clipboard_finalize      (GObject *o);

static GObjectClass *parent_class = NULL;

GType
sg_plot_clipboard_get_type (void)
{
  static GType sg_plot_clipboard_type = 0;
                                                                                
  if (!sg_plot_clipboard_type)
    {
      static const GTypeInfo sg_plot_clipboard_info =
      {
        sizeof (SGplotClipboardClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) sg_plot_clipboard_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (SGplotClipboard),
        0,              /* n_preallocs */
        (GInstanceInitFunc) sg_plot_clipboard_init,
	NULL
      };
                                                                                
      sg_plot_clipboard_type = g_type_register_static (G_TYPE_OBJECT, "SGplotClipboard", &sg_plot_clipboard_info, 0);
    }
                                                                                
  return sg_plot_clipboard_type;
}

GObject *
sg_plot_clipboard_new(void)
{
  return G_OBJECT(g_object_new(sg_plot_clipboard_get_type(), NULL));
}

static void
sg_plot_clipboard_class_init(SGplotClipboardClass *klass)
{
  GObjectClass *object_class;
  SGplotClipboardClass *cb_class;

  object_class = (GObjectClass*) klass;
  cb_class = (SGplotClipboardClass*) klass;

  parent_class = (GObjectClass *)g_type_class_peek_parent (klass);
  object_class->finalize = sg_plot_clipboard_finalize;
}

static void
sg_plot_clipboard_init(SGplotClipboard *clipboard)
{
  clipboard->pixmap = NULL;
}

static void
sg_plot_clipboard_finalize(GObject *o)
{
  SGplotClipboard *clipboard = SG_PLOT_CLIPBOARD(o);
  sg_plot_clipboard_clear(clipboard);
}


void
sg_plot_clipboard_clear(SGplotClipboard *cb)
{
  if(cb->pixmap)
      gdk_pixmap_unref(cb->pixmap);

  sg_plot_clipboard_init(cb);
}

void
sg_plot_clipboard_copy (SGplotClipboard *cb,
			SGplot *plot)
{
  GdkPixmap *pixmap_orig;
  GtkPlotCanvas *canvas;
  GtkAllocation a;
  gint width, height;
  gdouble m;

  sg_plot_clipboard_clear(cb);

  canvas = GTK_PLOT_CANVAS(plot);

  m = canvas->magnification;
  pixmap_orig = canvas->pixmap;
  width = canvas->pixmap_width;
  height = canvas->pixmap_height;

  cb->pixmap = gdk_pixmap_new(GTK_WIDGET(canvas)->window, 
                              canvas->width, canvas->height, -1); 

  a.x = 0;
  a.y = 0;
  a.width = canvas->width;
  a.height = canvas->height;

  gtk_plot_canvas_set_magnification(canvas, 1.0);

  canvas->pixmap = cb->pixmap;
  GTK_PLOT_GDK(canvas->pc)->drawable = cb->pixmap;

  gtk_plot_canvas_paint(canvas);

  GTK_PLOT_GDK(canvas->pc)->drawable = pixmap_orig;

  gtk_plot_canvas_set_magnification(canvas, m);

  gtk_plot_canvas_paint(canvas);
}

void
sg_plot_clipboard_paste(SGplotClipboard *cb,
			SGplot *plot,
                        gdouble x, gdouble y)
{
  GtkPlotCanvas *canvas;
  GtkPlotCanvasChild *child;
  GdkPixmap *pixmap;
  gint width, height;
  gdouble x1, x2, y1, y2;

  if(!cb->pixmap) return;

  canvas = GTK_PLOT_CANVAS(plot);

  gdk_window_get_size(cb->pixmap, &width, &height);

  pixmap = gdk_pixmap_new(GTK_WIDGET(canvas)->window, 
                          width, height, -1); 

  gdk_draw_pixmap(pixmap, 
                  GTK_WIDGET(canvas)->style->fg_gc[0], 
                  cb->pixmap, 0, 0, 0, 0, -1, -1);

  x1 = x;
  y1 = y;

  x2 = x1 + (gdouble)width / (gdouble)canvas->width * .5;
  y2 = y1 + (gdouble)height / (gdouble)canvas->height * .5;

  child = gtk_plot_canvas_pixmap_new(pixmap, NULL);
  gtk_plot_canvas_put_child(canvas, child, x1, y1, x2, y2); 

  gtk_widget_queue_draw(GTK_WIDGET(canvas));
}
