/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>

static gboolean
main_quit(SGworksheetWindow *window, SGapplication *app)
{
  sg_application_remove_worksheet(app, window->worksheet);
  gtk_main_quit();
  return FALSE;
}

/*
static void
activate_worksheet(SGapplication *app, SGworksheet *w)
{
 printf("activate_worksheet\n");
}
*/

int 
main(int argc, char *argv[])
{
  SGworksheet *worksheet;
  SGworksheetWindow *window;
  SGapplication *app;

  gtk_init(&argc, &argv);
  sg_init("testsheet");

  app = SG_APPLICATION(sg_application_new());
  worksheet = sg_worksheet_new( _("SciGraphica: Test") , 20, 5);
  sg_application_add_worksheet(app, worksheet);

  window = sg_worksheet_window_new(worksheet);

  gtk_widget_show(GTK_WIDGET(window));
  gdk_window_raise(GTK_WIDGET(window)->window);

/*
  gtk_signal_connect(GTK_OBJECT(app), "activate_worksheet",
                     activate_worksheet, NULL);

  sg_application_set_active_worksheet(app, worksheet);
*/

  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(main_quit), app);

  gtk_main();
  sg_quit();
  g_object_unref(G_OBJECT(app));

  return 0;
}

