/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <string.h>
#include <Python.h>
#include <grammar.h>
#include <node.h>
#include <parsetok.h>
#include <errcode.h>
#include <compile.h>
#include <eval.h>
#include <marshal.h>
#include "config.h"
#include "sg.h"
#include "sg_misc_dialogs.h"
#include "sg_dialog.h"
#include "sg_python.h"
#include "sg_python_expr.h"

extern PyObject *main_dict, *sg_dict;

gint python_error_report(PyObject *object)
{
    if (!object)
      { 
/*
if (sg_report_python_error)
*/
        PyErr_Print();
        Py_FlushLine();
        PyErr_Clear();
        return TRUE;
      }
    return FALSE;
}

PyObject *
python_eval_expr(gchar *command)
{ 
  PyObject *object;

  object = PyRun_String (command, Py_eval_input, main_dict, sg_dict);
  if (object) return object;
  if (PyErr_Occurred()) PyErr_Clear();

  object = PyRun_String (command, Py_single_input, main_dict, sg_dict);
  if (object) return object;
  if (sg_python_error_report(object)) return NULL;

  Py_INCREF(Py_None);
  return(Py_None);
}

PyObject *
sg_eval_func(gchar *func_def, gdouble x_value, gdouble *y_value)
{
  PyObject *object=NULL;

  object=Py_BuildValue("d",x_value);
  if (!object) return NULL;
  PyDict_SetItemString (sg_dict, "x", object);

  object=PyRun_String (func_def, Py_eval_input, main_dict, sg_dict);
  if (!object)
   { 
     if (PyErr_Occurred()) PyErr_Clear();
     object = PyRun_String (func_def, Py_single_input, main_dict, sg_dict);
     if (PyErr_Occurred()) {
       python_error_report(object);
       return NULL;
     }
     object = PyMapping_GetItemString(sg_dict, "y");
     if(object) *y_value=PyFloat_AsDouble (object);
   } else {
    *y_value=PyFloat_AsDouble (object);
   }

  return object;
}

PyObject * 
sg_eval_func_xy(gchar *func_def, gdouble x_value, gdouble y_value, gdouble *z_value)
{
  PyObject *object=NULL;

  object=Py_BuildValue("d",x_value);
  if (sg_python_error_report(object)) return NULL;
  PyDict_SetItemString (sg_dict, "x", object);

  object=Py_BuildValue("d",y_value);
  if (sg_python_error_report(object)) return NULL;
  PyDict_SetItemString (sg_dict, "y", object);

  object=PyRun_String (func_def, Py_eval_input, main_dict, sg_dict);
  if (sg_python_error_report(object)) return NULL;

  if (PyFloat_Check(object))
    *z_value=PyFloat_AsDouble (object);
  else if (PyInt_Check(object))
    *z_value=(double)PyInt_AsLong (object);
  else *z_value=0;
  
  Py_INCREF(object);
  return object;
}

/* Evalutes an expression and sends back an array of doubles */
gdouble *
sg_eval_expr_double(gchar *expr, gint *num, gint expect)
{ 
  PyObject *object=NULL,*seq_obj;
  PyArrayObject *parray;
  gpointer apt;
  GArray *array;
  double *retarray,val;
  gint i,len;

  *num=0;
  array=g_array_new (FALSE, FALSE, sizeof (gdouble));
  object=PyRun_String (expr, Py_eval_input, main_dict, sg_dict);
  if(sg_python_error_report(object))
  *num=0;
  if(FALSE){
  }
#ifdef WITH_NUMERIC_PYTHON
  else {
  if (PyArray_Check(object) && ((PyArrayObject *)object)->nd==1)
  {    parray=(PyArrayObject *)object;
       for (i=0;i<parray->dimensions[0];i++)
          { apt=parray->data+i*parray->strides[0];
            switch (parray->descr->type_num)
             { 
               case PyArray_UBYTE:
                val=(double)(*(char *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_SHORT:
                val=(double)(*(short int *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_LONG:
                val=(double)(*(long *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_FLOAT:
                val=(double)(*(float *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_DOUBLE:
                val=*(double *)(apt);
                g_array_append_val( array,val);
                break;
               case PyArray_CFLOAT:
               case PyArray_CDOUBLE:
                val=(double)(*(long double*)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_OBJECT:
                break;
             }
          }
  }
  else
#endif
  if (PySequence_Check(object) && !PyString_Check(object))
  {   len=PySequence_Length(object);
      for (i=0;i<len;i++)
       { seq_obj=PySequence_GetItem(object,i);
         Py_INCREF(seq_obj);
         if (PyFloat_Check (seq_obj))
         {
             val=PyFloat_AsDouble(seq_obj);
             g_array_append_val( array, val);
         }
         else if (PyInt_Check (seq_obj))
         {
             val=(double)PyInt_AsLong(seq_obj);
             g_array_append_val( array, val);
         }
       }
  }
  else if (PyFloat_Check (object))
  {
      val=PyFloat_AsDouble(object);
      g_array_append_val( array, val);
  }
  else if (PyInt_Check (object))
  {
      val=(double)PyInt_AsLong(object);
      g_array_append_val( array, val);
  }
 } 
 len=expect-array->len;
 if (expect>0 && array->len<expect)
    for (i=0;i<len;i++)
    { val=0;
      g_array_append_val(array,val);
    }
 retarray=(double *)(array->data);
 *num=array->len;
 g_array_free(array,FALSE); /* Delete structure, but NOT the data */

 return retarray;
}

/* Evalutes an expression and sends back an array of strings */
gchar **sg_eval_expr_string(gchar *expr, gint *num)
{ 
  PyObject *object=NULL,*seq_obj;
  GArray *array;
  gchar **retarray,*val;
  gint i,len;

  *num=0;
  object=PyRun_String (expr, Py_eval_input, main_dict, sg_dict);
  if (sg_python_error_report(object)) return NULL;

  array=g_array_new (FALSE, FALSE, sizeof (gchar *));
  if (PySequence_Check(object) && !PyString_Check(object))
  {   len=PySequence_Length(object);
      for (i=0;i<len;i++)
       { seq_obj=PySequence_GetItem(object,i);
         Py_INCREF(seq_obj);
         if (PyString_Check (seq_obj))
         {
             val=strdup(PyString_AsString(seq_obj));
             g_array_append_val( array,  val);
         }
         else
         {
             val=strdup(PyString_AsString( PyObject_Repr(seq_obj)));
             g_array_append_val( array, val);
         }
       }
  }
  else if (PyString_Check (object))
  {
      val=strdup(PyString_AsString(object));
      g_array_append_val( array, val);
  }
  else
  {
      val=strdup(PyString_AsString( PyObject_Repr(object)));
      g_array_append_val( array,  val);
  }

  retarray=(gchar  **)(array->data);
  *num=array->len;
  g_array_free(array,FALSE); /* Delete structure, but NOT the data */

  return retarray;
}

PyObject *
sg_eval_expr_xy(gchar *func_def, gdouble x_value, gdouble y_value, gdouble *new_x, gdouble *new_y)
{
  PyObject *object=NULL;
  
  *new_x = x_value;
  *new_y = y_value;

  object=Py_BuildValue("d",x_value);
  if (sg_python_error_report(object)) return NULL;
  PyDict_SetItemString (sg_dict, "x", object);

  object=Py_BuildValue("d",y_value);
  if (sg_python_error_report(object)) return NULL;
  PyDict_SetItemString (sg_dict, "y", object);

  object=PyRun_String (func_def, Py_single_input, main_dict, sg_dict);
  if (!object) { 
    if (PyErr_Occurred()) {
      python_error_report(object);
      return NULL;
    }
  }

  object = PyMapping_GetItemString(sg_dict, "x");
  if(object) *new_x=PyFloat_AsDouble (object);
  object = PyMapping_GetItemString(sg_dict, "y");
  if(object) *new_y=PyFloat_AsDouble (object);

  return object;
}



