/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"
#include "sg_plugin_layer.h"
#include "sg_dataset.h"

static void sg_plugin_layer_class_init             (SGpluginLayerClass *klass);
static void sg_plugin_layer_init                   (SGpluginLayer *plugin);
static void sg_plugin_layer_finalize                (GObject *object);
static SGpluginClass *parent_class = NULL;

GType
sg_plugin_layer_get_type (void)
{
  static GType sg_plugin_layer_type = 0;
                                                                                
  if (!sg_plugin_layer_type)
    {
      static const GTypeInfo sg_plugin_layer_info =
      {
        sizeof (SGpluginLayerClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) sg_plugin_layer_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (SGpluginLayer),
        0,              /* n_preallocs */
        (GInstanceInitFunc) sg_plugin_layer_init,
        NULL,
      };
                                                                                
      sg_plugin_layer_type = g_type_register_static (GTK_TYPE_SG_PLUGIN, "SGpluginLayer",
                                               &sg_plugin_layer_info, 0);
    }
                                                                                
  return sg_plugin_layer_type;
}

static void
sg_plugin_layer_class_init (SGpluginLayerClass *klass)
{
  GObjectClass *object_class;
  SGpluginClass *plugin_class;

  parent_class = (SGpluginClass *) g_type_class_peek_parent (klass);

  object_class = (GObjectClass *) klass;
  plugin_class = (SGpluginClass *) klass;

  object_class->finalize = sg_plugin_layer_finalize;
}


SGpluginLayer *
sg_plugin_layer_new ()
{
  SGpluginLayer *plugin;
  plugin = SG_PLUGIN_LAYER(g_object_new(sg_plugin_layer_get_type(), NULL));
  return plugin;
}

static void
sg_plugin_layer_init(SGpluginLayer *plugin)
{
  plugin->dim_mask = 0;
  plugin->construct = NULL;
  plugin->property_dialog = NULL;
}

static void
sg_plugin_layer_finalize(GObject *object)
{
  SGpluginLayer *plugin = SG_PLUGIN_LAYER(object);

  if(plugin->pixmap && GTK_IS_WIDGET(plugin->pixmap)) 
    gtk_widget_destroy(GTK_WIDGET(plugin->pixmap));
  plugin->pixmap = NULL;
  G_OBJECT_CLASS(parent_class)->finalize(object);
}

GtkPlot *
sg_plugin_layer_construct(SGpluginLayer *plugin)
{
  return plugin->construct();
}

GtkWidget *
sg_plugin_layer_toolbox(SGpluginLayer *plugin, GObject *layer)
{
  if(plugin->toolbox) 
    return plugin->toolbox(plugin, layer);
  else
    return NULL;
}

void
sg_plugin_layer_dialog(SGpluginLayer *plugin, GtkWidget *layer_control, GtkCTreeNode *root_item, GObject *layer, const gchar *name)
{ 
  plugin->property_dialog(plugin,layer_control,root_item,layer,name);
} 

SGpluginLayer *
sg_plugin_layer_get(const gchar *name)
{
  GList *list = sg_plugins();
  while(list){
    if(GTK_IS_SG_PLUGIN_LAYER(list->data)){
      SGpluginLayer *c = SG_PLUGIN_LAYER(list->data);
      if(strcmp(SG_PLUGIN(c)->name, name) == 0) return c;
    }
    list = list->next;
  }
  return NULL;
}

