/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"
#include "sg_plugin_formula.h"

static void sg_plugin_formula_class_init             (SGpluginFormulaClass *klass);
static void sg_plugin_formula_init                   (SGpluginFormula *plugin);

static SGpluginClass *parent_class = NULL;

GType
sg_plugin_formula_get_type (void)
{
  static GType sg_plugin_formula_type = 0;
                                                                                
  if (!sg_plugin_formula_type)
    {
      static const GTypeInfo sg_plugin_formula_info =
      {
        sizeof (SGpluginFormulaClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) sg_plugin_formula_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (SGpluginFormula),
        0,              /* n_preallocs */
        (GInstanceInitFunc) sg_plugin_formula_init,
        NULL,
      };
                                                                                
      sg_plugin_formula_type = g_type_register_static (GTK_TYPE_SG_PLUGIN, "SGpluginFormula",
                                               &sg_plugin_formula_info, 0);
    }
                                                                                
  return sg_plugin_formula_type;
}

static void
sg_plugin_formula_class_init (SGpluginFormulaClass *klass)
{
  GObjectClass *object_class;
  SGpluginClass *plugin_class;

  parent_class = (SGpluginClass *) g_type_class_peek_parent (klass);

  object_class = (GObjectClass *) klass;
  plugin_class = (SGpluginClass *) klass;
}


SGpluginFormula *
sg_plugin_formula_new ()
{
  SGpluginFormula *plugin;
  plugin = SG_PLUGIN_FORMULA(g_object_new(sg_plugin_formula_get_type(), NULL));
  return plugin;
}

static void
sg_plugin_formula_init(SGpluginFormula *plugin)
{
  plugin->action = NULL;
}

gboolean
sg_plugin_formula_action(SGpluginFormula *plugin, SGworksheet *w, gint row, gint col)
{
  if(!plugin->action) return FALSE;
  return (plugin->action(plugin, w, row, col));
}

SGpluginFormula *
sg_plugin_formula_get(const gchar *name)
{
  GList *list = sg_plugins();
  while(list){
    if(GTK_IS_SG_PLUGIN_FORMULA(list->data)){
      SGpluginFormula *c = SG_PLUGIN_FORMULA(list->data);
      if(strcmp(SG_PLUGIN(c)->name, name) == 0) return c;
    }
    list = list->next;
  }
  return NULL;
}

