/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <math.h>
#include "sg_misc_dialogs.h"
#include "sg.h"
#include "sg_dialog.h"
#include "sg_stock.h"
#include "pixmaps/warning.xpm"
#include "pixmaps/error.xpm"
#include "pixmaps/sorry.xpm"

typedef struct
{
  GtkWidget *entry;
  gchar *text;
} SGmiscDialog;

static void
store_text(SGpropertyDialog *pdialog, gpointer data)
{
  SGmiscDialog *dialog = (SGmiscDialog *)data;
  dialog->text = g_strdup(gtk_entry_get_text(GTK_ENTRY(dialog->entry)));
}

gchar *
sg_text_dialog (const gchar *msg, const gchar *default_text, gint type)
{
  GtkWidget *wdialog;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  gchar title[200];
  SGmiscDialog *dialog;
  gchar *return_text;

  dialog = g_new0(SGmiscDialog, 1);
  dialog->text = NULL;
  colormap = gdk_colormap_get_system();

  switch(type){
    case 0:
      sprintf(title, _("SciGraphica: Error") );
      break;
    case 1:
      sprintf(title, _("SciGraphica: Warning") );
      break;
    case 2:
      sprintf(title, _("SciGraphica: Sorry") );
      break;
  }

  /* Create widgets */
  frame = sg_property_dialog_new();
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(frame), dialog, FALSE);
  SG_PROPERTY_DIALOG(frame)->ok = store_text;

  table = gtk_table_new(2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_container_add (GTK_CONTAINER (frame), table);

  switch(type){
   case 0:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   error_xpm);
    break;
   case 1:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   warning_xpm);
    break;
   case 2:
   default:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   sorry_xpm);
    break;
  }

  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            tpixmap,
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(msg),
                            1, 2, 0, 1);

  dialog->entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            dialog->entry,
                            0, 2, 1, 2);
  gtk_entry_set_text(GTK_ENTRY(dialog->entry), default_text);

  /* connect signals */
  wdialog = sg_dialog_new(title, GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK, 0);
  sg_dialog_add(wdialog, SG_PROPERTY_DIALOG(frame));

  gtk_signal_connect_object (GTK_OBJECT (dialog->entry), "activate",
                             GTK_SIGNAL_FUNC (sg_property_dialog_ok), 
                             GTK_OBJECT(frame));

  /* Show widgets */

  sg_dialog_run(wdialog, NULL);
  return_text = dialog->text;
  g_free(dialog);

  return return_text;
}

void
sg_message_dialog (const gchar *msg, gint type)
{
  GtkWidget *dialog;
  GtkWindow *window;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  gchar title[200];

  colormap = gdk_colormap_get_system();

  switch(type){
    case 0:
      sprintf(title, _("SciGraphica: Error") );
      break;
    case 1:
      sprintf(title, _("SciGraphica: Warning") );
      break;
    case 2:
      sprintf(title, _("SciGraphica: Sorry") );
      break;
  }

  /* Create widgets */
  dialog = sg_dialog_new(title, GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK, 0);

  table = gtk_table_new(1, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (SG_DIALOG(dialog)->box), table, FALSE, FALSE, 0);

  switch(type){
   case 0:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   error_xpm);
    break;
   case 1:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   warning_xpm);
    break;
   case 2:
   default:
    pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   sorry_xpm);
    break;
  }

  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            tpixmap,
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(msg),
                            1, 2, 0, 1);

  /* Action Area */
  gtk_box_pack_start (GTK_BOX (SG_DIALOG(dialog)->box), gtk_hseparator_new(), FALSE, TRUE, 0);

  window = GTK_WINDOW(dialog);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_widget_show_all(table);

  /* connect signals */
  sg_dialog_run(dialog, NULL);

  return;
}

SGdialogButton
sg_accept_dialog (const gchar *msg, gint type)
{
  GtkWidget *dialog;
  GtkWindow *window;
  GtkWidget *main_box;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();

  /* Create widgets */
  dialog = sg_dialog_new ( _("SciGraphica: Warning") , GTK_ORIENTATION_VERTICAL, type == 0 ? SG_BUTTON_YES|SG_BUTTON_NO|SG_BUTTON_CANCEL : SG_BUTTON_YES|SG_BUTTON_NO, 0);
  main_box = SG_DIALOG(dialog)->box;
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);

  table = gtk_table_new(1, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), table, FALSE, FALSE, 0);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 warning_xpm);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            tpixmap,
                            0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(msg),
                            1, 2, 0, 1);

  /* Action Area */
  gtk_box_pack_start (GTK_BOX (main_box), gtk_hseparator_new(), FALSE, TRUE, 0);

  window = GTK_WINDOW(dialog);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_widget_show_all(main_box);

  /* wait until dialog get destroyed */
  return sg_dialog_run(dialog, NULL);
}

