/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_property_dialog.h"
#include "sg_symbol_dialog.h"
#include "sg_data_line_dialog.h"

typedef struct
{
  GtkWidget *symbol_dialog;
  GtkWidget *line_dialog;
  GtkPlotData *dataset;
} SGsymbolDialog;

static void sg_line_symbol_dialog_apply            (SGpropertyDialog *d, gpointer data);
static void sg_line_symbol_dialog_ok               (SGpropertyDialog *d, gpointer data);

GtkWidget *
sg_line_symbol_dialog_new(GtkPlotData *dataset, gboolean use_shape, gboolean use_scale)
{
  GtkWidget *widget;
  SGsymbolDialog *dialog;
  GtkWidget *table;

  dialog = g_new0(SGsymbolDialog, 1);
  widget = sg_property_dialog_new();
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(widget), dialog, TRUE);
  SG_PROPERTY_DIALOG(widget)->apply = sg_line_symbol_dialog_apply;
  SG_PROPERTY_DIALOG(widget)->ok = sg_line_symbol_dialog_ok;
  dialog->dataset = dataset;
  dialog->symbol_dialog = sg_symbol_dialog_new(dataset, use_shape, use_scale);
  dialog->line_dialog = sg_data_line_dialog_new(dataset);

  table = gtk_table_new(1, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  gtk_container_add(GTK_CONTAINER(widget), table);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->line_dialog, 0, 1, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->symbol_dialog, 1, 2, 0, 1);
  
  gtk_widget_show_all(widget); 

  return widget;
}

static void
sg_line_symbol_dialog_ok(SGpropertyDialog *d, gpointer data)
{
  SGsymbolDialog *dialog = (SGsymbolDialog *)d->data;

  sg_property_dialog_apply(SG_PROPERTY_DIALOG(dialog->symbol_dialog));
  sg_property_dialog_apply(SG_PROPERTY_DIALOG(dialog->line_dialog));
}

static void     
sg_line_symbol_dialog_apply     (SGpropertyDialog *d, gpointer _data)
{
  SGsymbolDialog *dialog = (SGsymbolDialog *)d->data;

  sg_property_dialog_apply(SG_PROPERTY_DIALOG(dialog->symbol_dialog));
  sg_property_dialog_apply(SG_PROPERTY_DIALOG(dialog->line_dialog));
}

