/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_frame_dialog.h"
#include "sg.h"
#include "sg_property_dialog.h"

typedef struct
{
/*
  GtkWidget *thick_spin; 
  GtkWidget *length_spin; 
  GtkWidget *color_combo; 
*/
  GtkWidget *bottom_scale; 
  GtkWidget *top_scale; 
  GtkWidget *left_scale; 
  GtkWidget *right_scale; 
  GtkWidget *xfactor; 
  GtkWidget *yfactor; 
  GtkWidget *zfactor; 
  GtkWidget *clip_check; 
  GtkWidget *top_check; 
  GtkPlot *plot;
  SGlayer *layer;
} SGframeDialog;

static void sg_frame_dialog_apply            (SGpropertyDialog *d, gpointer data);
static void sg_frame_dialog_ok               (SGpropertyDialog *d, gpointer data);
static void sg_frame_dialog_init_gui         (GtkWidget *widget);

GtkWidget *
sg_frame_dialog_new(SGlayer *layer)
{
  GtkWidget *widget;
  SGframeDialog *dialog;

  dialog = g_new0(SGframeDialog, 1);
  widget = sg_property_dialog_new();
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(widget), dialog, TRUE);
  SG_PROPERTY_DIALOG(widget)->ok = sg_frame_dialog_ok;
  SG_PROPERTY_DIALOG(widget)->apply = sg_frame_dialog_apply;
  dialog->layer = layer;
  dialog->plot = GTK_PLOT_CANVAS_PLOT(layer)->plot;
  sg_frame_dialog_init_gui(widget);

  return widget;
}

static void
sg_frame_dialog_ok(SGpropertyDialog *d, gpointer data)
{
  sg_frame_dialog_apply(d, data);
}

static void
sg_frame_dialog_apply(SGpropertyDialog *d, gpointer data)
{
  SGplot *parent;
  SGframeDialog *dialog = (SGframeDialog *)d->data;
  GtkPlot *plot = dialog->plot;

/*
  line_width = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(dialog->thick_spin)); 
  ticks_length = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->length_spin)); 
  combo = GTK_COLOR_COMBO(dialog->color_combo);
  color = gtk_color_combo_get_selection(combo);

  plot->left->ticks_length = ticks_length;
  plot->right->ticks_length = ticks_length;
  plot->top->ticks_length = ticks_length;
  plot->bottom->ticks_length = ticks_length;

  plot->left->ticks_width = line_width / 2;
  plot->right->ticks_width = line_width / 2;
  plot->top->ticks_width = line_width / 2;
  plot->bottom->ticks_width = line_width / 2;
*/

  plot->grids_on_top = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->top_check));
  plot->clip_data = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->clip_check));

  if(strcmp(SG_PLUGIN(dialog->layer->plugin)->name,"layer_3d") != 0){
    plot->left_align = GTK_RANGE(dialog->left_scale)->adjustment->value;
    plot->right_align = GTK_RANGE(dialog->right_scale)->adjustment->value;
    plot->top_align = GTK_RANGE(dialog->top_scale)->adjustment->value;
    plot->bottom_align = GTK_RANGE(dialog->bottom_scale)->adjustment->value;
  } else {
/*
    gtk_plot3d_frame_set_attributes(GTK_PLOT3D(plot), GTK_PLOT_LINE_SOLID, line_width, &color);
*/
    GTK_PLOT3D(plot)->xfactor = GTK_RANGE(dialog->xfactor)->adjustment->value;
    GTK_PLOT3D(plot)->yfactor = GTK_RANGE(dialog->yfactor)->adjustment->value;
    GTK_PLOT3D(plot)->zfactor = GTK_RANGE(dialog->zfactor)->adjustment->value;
  }  

/*
  gtk_plot_axis_set_attributes(gtk_plot_get_axis(plot, GTK_PLOT_AXIS_LEFT), line_width, &color);
  gtk_plot_axis_set_attributes(gtk_plot_get_axis(plot, GTK_PLOT_AXIS_RIGHT), line_width, &color);
  gtk_plot_axis_set_attributes(gtk_plot_get_axis(plot, GTK_PLOT_AXIS_TOP), line_width, &color);
  gtk_plot_axis_set_attributes(gtk_plot_get_axis(plot, GTK_PLOT_AXIS_BOTTOM), line_width, &color);
  plot->left->labels_attr.fg = color;
  plot->right->labels_attr.fg = color;
  plot->top->labels_attr.fg = color;
  plot->bottom->labels_attr.fg = color;
*/

  parent = SG_PLOT(GTK_PLOT_CANVAS_CHILD(dialog->layer)->parent);
  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(parent));
  gtk_plot_canvas_refresh(GTK_PLOT_CANVAS(parent));
}

static void
init_dialog(SGframeDialog *dialog)
{
  GtkPlot *plot = dialog->plot;

/*
  if(strcmp(SG_PLUGIN(dialog->layer->plugin)->name,"layer_3d") != 0)
    gtk_plot_axis_get_attributes(gtk_plot_get_axis(plot, 0), &line_width, &line_color);
  else 
    gtk_plot3d_frame_get_attributes(GTK_PLOT3D(plot), &line_style, &line_width, &line_color);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->thick_spin), line_width); 
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->length_spin), plot->top->ticks_length); 

  sg_color_combo_init(GTK_COLOR_COMBO(dialog->color_combo), line_color);
*/

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dialog->top_check), 
                               plot->grids_on_top);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dialog->clip_check), 
                               plot->clip_data);

  if(strcmp(SG_PLUGIN(dialog->layer->plugin)->name,"layer_3d") != 0){
    gtk_adjustment_set_value(GTK_RANGE(dialog->left_scale)->adjustment, 
                             plot->left_align);
    gtk_adjustment_set_value(GTK_RANGE(dialog->right_scale)->adjustment, 
                             plot->right_align);
    gtk_adjustment_set_value(GTK_RANGE(dialog->top_scale)->adjustment, 
                             plot->top_align);
    gtk_adjustment_set_value(GTK_RANGE(dialog->bottom_scale)->adjustment, 
                             plot->bottom_align);
  } else {
    gtk_adjustment_set_value(GTK_RANGE(dialog->xfactor)->adjustment, 
                             GTK_PLOT3D(plot)->xfactor);
    gtk_adjustment_set_value(GTK_RANGE(dialog->yfactor)->adjustment, 
                             GTK_PLOT3D(plot)->yfactor);
    gtk_adjustment_set_value(GTK_RANGE(dialog->zfactor)->adjustment, 
                             GTK_PLOT3D(plot)->zfactor);
  }

}

static void
sg_frame_dialog_init_gui (GtkWidget *frame)
{
  GtkWidget *main_table;
  GtkWidget *table;
  GtkWidget *label;
  GtkAdjustment *adjust;
  SGframeDialog *dialog;
  GtkWidget *main_box;

  dialog = (SGframeDialog *)SG_PROPERTY_DIALOG(frame)->data;

  /* Create widgets */
  main_box = gtk_hbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 0);
  gtk_container_add(GTK_CONTAINER(frame), main_box);

  main_table = gtk_table_new (3, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(main_table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(main_table), 2);
  gtk_table_set_row_spacings(GTK_TABLE(main_table), 2);
  gtk_box_pack_start (GTK_BOX (main_box), main_table, FALSE, FALSE, 0);

  /* Poperties */
/*
  frame = gtk_frame_new( _("Properties") );
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach (GTK_TABLE (main_table), frame, 0, 1, 0, 1, 0, 0, 5, 5);

  table=gtk_table_new(3, 2, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  label = gtk_label_new( _("Thickness(pts) ") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, 0, 0, 5, 5);
  label = gtk_label_new( _("Ticks length ") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, 0, 0, 5, 5);
  label = gtk_label_new( _("Color ") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3, 0, 0, 5, 5);

  adjust = (GtkAdjustment *)gtk_adjustment_new(0., 0., 6., 0.5, 1., 0.);
  dialog->thick_spin = gtk_spin_button_new(adjust, 0, 1);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->thick_spin), TRUE);

  adjust = (GtkAdjustment *)gtk_adjustment_new(0., 0., 20., 1., 1., 0.);
  dialog->length_spin = gtk_spin_button_new(adjust, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->length_spin), TRUE);

  dialog->color_combo = gtk_color_combo_new();

  gtk_table_attach(GTK_TABLE(table), dialog->thick_spin, 1, 2, 0, 1, 0, 0, 5, 5);
  gtk_table_attach(GTK_TABLE(table), dialog->length_spin, 1, 2, 1, 2, 0, 0, 5, 5);
  gtk_table_attach(GTK_TABLE(table), dialog->color_combo, 1, 2, 2, 3, 0, 0, 5, 5);
*/

  /* Alignments */
  if(strcmp(SG_PLUGIN(dialog->layer->plugin)->name,"layer_3d") != 0){

    frame = gtk_frame_new( _("Axis position") );
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    gtk_table_attach (GTK_TABLE (main_table), frame, 0, 2, 0, 1, 0, 0, 5, 5);

    table=gtk_table_new(7, 3, FALSE);  
    gtk_container_set_border_width(GTK_CONTAINER(table), 5);
    gtk_table_set_col_spacings(GTK_TABLE(table), 2);
    gtk_table_set_row_spacings(GTK_TABLE(table), 2);
    gtk_container_add(GTK_CONTAINER(frame), table);
  
    label = gtk_label_new( _("left") );
    gtk_misc_set_alignment(GTK_MISC(label), 0., .5);
    gtk_table_attach(GTK_TABLE(table), label, 1, 2, 0, 1, 0, 0, 0, 5);
    label = gtk_label_new( _("right") );
    gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
    gtk_table_attach(GTK_TABLE(table),label, 2, 3, 0, 1, 0, 0, 5, 5);
    gtk_table_attach(GTK_TABLE(table),
                     gtk_label_new( _("Left axis") ), 0, 1, 1, 2, 0, 0, 5, 5);
    gtk_table_attach(GTK_TABLE(table),
                     gtk_label_new( _("Right axis") ), 0, 1, 2, 3, 0, 0, 5, 5);
  
    adjust = (GtkAdjustment *)gtk_adjustment_new(0., -0.5, 1.6, .01, .01, .1);
    dialog->left_scale = gtk_hscale_new(adjust);
    gtk_scale_set_digits(GTK_SCALE(dialog->left_scale), 2);
    adjust = (GtkAdjustment *)gtk_adjustment_new(0., -0.5, 1.6, .01, .01, .1);
    dialog->right_scale = gtk_hscale_new(adjust);
    gtk_scale_set_digits(GTK_SCALE(dialog->right_scale), 2);
  
    gtk_table_attach_defaults(GTK_TABLE(table), dialog->left_scale, 1, 3, 1, 2);
    gtk_table_attach_defaults(GTK_TABLE(table), dialog->right_scale, 1, 3, 2, 3);
  
    gtk_table_attach(GTK_TABLE(table), gtk_hseparator_new(), 0, 3, 3, 4, GTK_EXPAND|GTK_FILL, 0, 0, 0);
  
    label = gtk_label_new( _("bottom") );
    gtk_misc_set_alignment(GTK_MISC(label), 0., .5);
    gtk_table_attach(GTK_TABLE(table), label, 1, 2, 4, 5, 0, 0, 0, 5);
    label = gtk_label_new( _("top") );
    gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
    gtk_table_attach(GTK_TABLE(table),label, 2, 3, 4, 5, 0, 0, 5, 5);
    gtk_table_attach(GTK_TABLE(table),
                     gtk_label_new( _("Bottom axis") ), 0, 1, 5, 6, 0, 0, 5, 5);
    gtk_table_attach(GTK_TABLE(table),
                     gtk_label_new( _("Top axis") ), 0, 1, 6, 7, 0, 0, 5, 5);
  
    adjust = (GtkAdjustment *)gtk_adjustment_new(0., -0.5, 1.6, .01, .01, .1);
    dialog->bottom_scale = gtk_hscale_new(adjust);
    gtk_scale_set_digits(GTK_SCALE(dialog->bottom_scale), 2);
    adjust = (GtkAdjustment *)gtk_adjustment_new(0., -0.5, 1.6, .01, .01, .1);
    dialog->top_scale = gtk_hscale_new(adjust);
    gtk_scale_set_digits(GTK_SCALE(dialog->top_scale), 2);
  
    gtk_table_attach_defaults(GTK_TABLE(table), dialog->bottom_scale, 1, 3, 5, 6);
    gtk_table_attach_defaults(GTK_TABLE(table), dialog->top_scale, 1, 3, 6, 7);
  
  } else {

    frame = gtk_frame_new( _("Scale factors") );
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
    gtk_table_attach (GTK_TABLE (main_table), frame, 0, 2, 0, 1, 0, 0, 5, 5);

    table=gtk_table_new(3, 3, FALSE);  
    gtk_container_set_border_width(GTK_CONTAINER(table), 5);
    gtk_table_set_col_spacings(GTK_TABLE(table), 2);
    gtk_table_set_row_spacings(GTK_TABLE(table), 2);
    gtk_container_add(GTK_CONTAINER(frame), table);
  
    label = gtk_label_new( _("X") );
    gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, 0, 0, 5, 5);
    label = gtk_label_new( _("Y") );
    gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
    gtk_table_attach(GTK_TABLE(table),label, 0, 1, 1, 2, 0, 0, 5, 5);
    label = gtk_label_new( _("Z") );
    gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
    gtk_table_attach(GTK_TABLE(table),label, 0, 1, 2, 3, 0, 0, 5, 5);

    adjust = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1., .01, .01, 0.);
    dialog->xfactor = gtk_hscale_new(adjust);
    adjust = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1., .01, .01, 0.);
    dialog->yfactor = gtk_hscale_new(adjust);
    adjust = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1., .01, .01, 0.);
    dialog->zfactor = gtk_hscale_new(adjust);
  
    gtk_table_attach_defaults(GTK_TABLE(table), dialog->xfactor, 1, 3, 0, 1);
    gtk_table_attach_defaults(GTK_TABLE(table), dialog->yfactor, 1, 3, 1, 2);
    gtk_table_attach_defaults(GTK_TABLE(table), dialog->zfactor, 1, 3, 2, 3);
  }

  dialog->top_check = gtk_check_item_new_with_label( _("Frame on top of data") );
  dialog->clip_check = gtk_check_item_new_with_label( _("Clip data to frame") );
  gtk_table_attach(GTK_TABLE(main_table), dialog->top_check, 0, 2, 1, 2, 0, 0, 5, 5);
  gtk_table_attach(GTK_TABLE(main_table), dialog->clip_check, 0, 1, 2, 3, 0, 0, 5, 5);

  /* connect signals */

  init_dialog(dialog);
}
